
  Esta es la documentacin para el interfaz kernel en modo protegido PMODE 3.0
DPMI/VCPI/XMS/raw. Copyright (c) 1994, Tran (a.k.a. Thomas Pytel). PMODE est
disponible de forma pblica y no es confidencial ni tiene propiedad. Yo,
Thomas Pytel, me reservo todos los derechos sobre el cdigo fuente. Sin
embargo, tienes libertad para usarlo o distribuirlo del modo que desees (hay
una pequea restriccin como la de Noviembre de 1994, lela en la seccin de
Disposicin legal). Todo lo que pido, si usas este cdigo para producir algo,
es que me acredites.

------------------------------------------------------------------------------
Contenidos:
-----------

  0 - Introduccin
      0.0 - Disposicin legal
      0.1 - Descripcin
  1 - Visin preliminar
      1.0 - Inicializacin y finalizacin
      1.1 - Segmentos, selectores y descriptores
      1.2 - Enlace de pilas y modos
      1.3 - Interrupciones
      1.4 - Llamadas de retorno en modo real
      1.5 - Cosas especficas de PMODE
      1.6 - Pilas internas del PMODE
  2 - Funciones
      2.0 - Funcin 0000h - Asignar Descriptores
      2.1 - Funcin 0001h - Liberar Descriptor
      2.2 - Funcin 0003h - Toma el Valor de Incremento del Selector
      2.3 - Funcin 0006h - Obtiene la Direccin Base del Segmento
      2.4 - Funcin 0007h - Establecer la Direccin Base del Segmento
      2.5 - Funcin 0008h - Establecer el Lmite del Segmento
      2.6 - Funcin 0009h - Establecer los Derechos de Acceso del Descriptor
      2.7 - Funcin 000Ah - Crear un Descriptor de Alias
      2.8 - Funcin 000Bh - Toma el Descriptor
      2.9 - Funcin 000Ch - Establecer Descriptor
      2.10 - Funcin 000Eh - Toma Mltiples Descriptores
      2.11 - Funcin 000Fh - Establecer Mltiples Descriptores
      2.12 - Funcin 0100h - Asignar Bloque de Memoria de DOS
      2.13 - Funcin 0101h - Liberar Bloque de Memoria de DOS
      2.14 - Funcin 0102h - Dar Nuevo Tamao al Bloque de Memoria de DOS
      2.15 - Funcin 0200h - Toma el Vector de Interrupcin en Modo Real
      2.16 - Funcin 0201h - Establecer el Vector de Interrupcin en Modo Real
      2.17 - Funcin 0204h - Toma el Vector de Interrupcin en Modo Protegido
      2.18 - Funcin 0205h - Establecer el Vector de Interrupcin en Modo
                             Protegido
      2.19 - Funcin 0300h - Simular Interrupcin en Modo Real
      2.20 - Funcin 0301h - Llamar al Procedimiento en Modo Real Con Marco de
                             Retorno Lejano
      2.21 - Funcin 0302h - Llamar al Procedimiento en Modo Real Con Marco
                             IRET
      2.22 - Funcin 0303h - Asignar la Direccin de la Llamada de Retorno en
                             Modo Real
      2.23 - Funcin 0304h - Liberar la Direccin de la Llamada de Retorno en
                             Modo Real
      2.24 - Funcin 0305h - Obtiene las Direcciones para Salvar/Restaurar el
                             Estado
      2.25 - Funcin 0306h - Toma las Direcciones de Enlace en Modo Raw
      2.26 - Funcin 0400h - Muestra la Versin
      2.27 - Funcin 0500h - Muestra la Informacin de la Memoria Libre
      2.28 - Funcin 0501h - Asignar Bloque de Memoria
      2.29 - Funcin 0502h - Liberar Bloque de Memoria
      2.30 - Funcin 0503h - Dar Nuevo Tamao al Bloque de Memoria
      2.31 - Funcin 050Ah - Toma el Tamao y la Base del Bloque de Memoria
      2.32 - Funcin 0900h - Muestra y Desactiva el Estado de la Interrupcin
                             Virtual
      2.33 - Funcin 0901h - Muestra y Habilita el Estado de la Interrupcin
                             Virtual
      2.34 - Funcin 0902h - Muestra el Estado de la Interrupcin Virtual
      2.35 - Funcin FFFFh - Special Fluffy Magical Function
  3 - Miscelnea
      3.0 - Actualizaciones
      3.1 - Glosario
      3.2 - Diferencias entre modos
      3.3 - Notas
      3.4 - Apunte final

------------------------------------------------------------------------------
0 - Introduccin:
-----------------

  Este documento no tratar de explicar el funcionamiento del modo protegido.
Si eres nuevo en la programacin en modo protegido, te sugiero que consigas un
buen libro. Tambin te aconsejo que le eches el guante a una buena
documentacin sobre DPMI que te sirva de referencia y te ponga en antecedentes
para entender PMODE. Este documento slo pretende explicar el funcionamiento
del PMODE para que se pueda usar directamente o para escribir un shell o un
interfaz de un lenguaje de alto nivel.

0.0 Disposicin legal:
----------------------

Legal:

  Declino todas y cada una de las garantas implcitas, incluyendo las
garantas de comerciabilidad y de ajuste a un prposito concreto. No doy
ninguna garanta ni representacin, expresa ni implcita, con respecto a este
cdigo fuente, su calidad, funcionamiento, comerciabilidad o ajuste para un
propsito concreto. No tendr ninguna responsabilidad por daos especiales,
incidentales o consecuentes provenientes o como resultado del uso o la
modificacin de este cdigo fuente.

Ingls:

  Si te jode, es tu problema.

Tambin:

  Hay una restriccin al uso de PMODE. No puedes vender PMODE para obtener un
beneficio o usarlo como un kernel de un extensor para ser vendido en busca de
beneficio. PUEDES usarlo en tus propias producciones para obtener beneficio,
mientras no sean un extensor del anterior. Esto significa que puedes usarlo en
juegos, demos, aplicaciones en el trabajo, etc... sin preocuparte ni tener
obligaciones monetarias conmigo. PUEDES usar PMODE en un extensor mayor
supuesto que no vendas este extensor para obtener un beneficio. Puedes usar ese
extensor en tus propias producciones para obtener un beneficio o distribuirlo
como freeware, pero NO puedes cobrar dinero por su uso en ningn caso.

0.1 Descripcin:
----------------

  PMODE 3.0 es, bsicamente, un extensor del DOS. Permite a los programas del
DOS funcionar de forma total en modo protegido. PMODE se ocupar de todos los
detalles del sistema, las tablas de descriptores, administracin de la memoria
extendida, interrupciones, etc... No importa qu tipo de sistema se encuentre
ejecutndose en ese momento. Los sistemas DMPI, VCPI, XMS y un sistema limpio,
sern manejados de la forma apropiada. Si tenemos un DPMI, PMODE no har,
bsicamente, nada y tu cdigo estar hablando directamente con el host DPMI.
Pero si no es as, PMODE suministrar un subgrupo de funcionalidad de DPMI para
tu cdigo. Es algo molesto que la mayor parte del interfaz de DPMI use pares de
registros de 16bit para valores de 32bit. Esto vuelve al soporte 80286 del
DPMI.

  El cdigo que est usando PMODE puede configurar sus propios descriptores.
Puede ejecutarse en modo real, modo protegido de 16bit y modo protegido de
32bit. Se suministra una administracin total de la memoria extendida. Se
pueden asignar, dar nuevo tamao y liberar bloques de memoria extendida. PMODE
no administra memoria baja, tu cdigo es responsable de la memoria que est por
debajo del lmite de 1M. El kernel PMODE se ajusta bien para un shell para
extender su funcionalidad. Un shell para suministrar servicios extendidos o
simplificados para cdigo de ensamblador o de nivel alto.

  Escrib PMODE prestando atencin a la velocidad. En cualquier sitio donde
pudiera controlarla, intentaba asegurarme que el cdigo que usara PMODE
funcionara tan rpido como fuera posible. Tambin intent asegurarme de que el
PMODE fuera muy estable. Bajo DPMI, tu cdigo es un esclavo de los caprichos
del host de DPMI. Casi con toda seguridad funcionando en CPL 3, lo que le hace
muy lento. No hay nada que yo pueda hacer al respecto. Bueno, localizar y
vrtelas con las tablas de sistema del host de DPMI puede que no sea muy
difcil sino muy impredecible. Ejecutando en modo protegido en CPL 3 es mejor
que el modo real en CPL 3 ya que puedes evitar bastante a menudo el cargar
registros de segmento (lo que es lento) configurando memoria plana. Sin
embargo, si no est presente el DPMI, puedes estar seguro de que tu cdigo
estar siendo ejecutado tan rpido como sea posible. Bajo un sistema VCPI, XMS
o raw, PMODE ejecutar tu cdigo en CPL 0. No se permiten comprobaciones de mapa
de bits de permisos de I/O en los accesos a puertos ni enlace de tareas. Bajo un
sistema XMS o raw, las llamadas en modo real son ejecutadas en el verdadero
modo real antes que en el ms lento modo V86, que en realidad es modo protegido
en CPL 3. Bajo VCPI, las llamadas en modo real son ejecutadas en modo V86, que
es en el que el servidor VCPI normalmente ejecuta el DOS. Tambin, bajo VCPI,
est disponible la paginacin. Es un pequeo factor que disminuye la velocidad,
pero que se evita bajo XMS o raw.

  He estado codificando sistemas en modo protegido 386 durante dos aos.
Intent hacer PMODE tan claro y definido como fuera posible. Pero fue
codificado desde el principio. Aunque lo he probado a conciencia, por
desgracia siempre existe la posibilidad de un fallo (bug). Estoy bastante
seguro de que est bien definido a pesar de todo, ya que repas CADA lnea de
cdigo cuando finalmente acab con l. Tambin lo he conectado a algunos
programas viejos usando una versin anterior de PMODE, lo que me vino bien para
encontrar unos pocos fallos.

------------------------------------------------------------------------------
1 - Visin preliminar:
----------------------

  Adopt el interfaz DPMI para el PMODE para hacer cdigo que funcionara con
PMODE y fuera fcilmente trasladable a otros extensores. Slo se soporta un
subgrupo de DPMI, tanto para mantener pequeo el tamao del kernel como porque
soy un vago (siendo esto ltimo el factor ms importante). El interfaz para
PMODE es la INT 31h en modo protegido. Las funciones estn disponibles para los
descriptores, los vectores de interrupcin, la memoria extendida, las llamadas
de retorno en modo real y para las llamadas a los procedimientos e
interrupciones en modo real. El PMODE funciona como un subgrupo de DPMI 1.0 ms
que del DPMI 0.9. Esto significa que las llamadas de funcin que no han tenido
xito devuelven errores de cdigo y se encuentran disponibles algunas funciones
que no lo estn en el DPMI 0.9. Ntese, sin embargo, que si el sistema est ya
bajo DPMI 0.9, el cdigo de PMODE no est activo y por lo tanto no se
devolvern errores de cdigo y slo estarn disponibles las funciones de DPMI
0.9.

1.0 - Inicializacin y finalizacin:
------------------------------------

  Slo hay dos funciones que puedan ser llamadas de forma inmediata en PMODE.
Estas son _pm_info y _pm_init. _pm_info devuelve informacin acerca del
tipo de sistema actual y los requerimientos de memoria baja para el modo
protegido. Independientemente del sistema, DPMI, VCPI, XMS o raw, es necesario
un buffer de memoria baja para el funcionamiento del modo protegido.
_pm_info nos devuelve el tamao de este buffer. Tu cdigo es responsable de
suministrar ese buffer a _pm_init.

  _pm_init cambia el sistema al modo protegido. Si estamos en DPMI, todo lo que
hace es una conexin al modo protegido de 32bit. Si el host DPMI no soporta
el modo protegido de 32bit, _pm_init devolver un error. El modo protegido de
32bit no significa necesariamente que tu cdigo tenga que correr en un segmento
de 32bit con instrucciones de 32bit por defecto, slo quiere decir que es
posible. Puesto que DPMI est definido para ordenadores 80286, puede que
incluso encuentres DPMI que puede con el modo protegido de 32bit pero que
rechaza esta peticin en un sistema 386.

  _pm_init volver con el flag de acarreo activado y un cdigo de error en AX
si tuvo lugar un error mientras se trataba de cambiar al modo protegido. Si la
conexin con el modo protegido tuvo xito, el flag de acarreo estar limpio y
el sistema se encontrar en el modo protegido. El registro de segmento CS habr
sido convertido en un selector en modo protegido correspondindose con un
descriptor que mapease la misma zona de memoria que mapeara en modo real.
Igualmente, se convertirn en selectores los segmentos de registro DS y SS. Si
DS y SS eran iguales antes de la llamada a _pm_init, se devolver el mismo
selector en ambos. ES contendr un selector para el PSP de tu programa. Tambin
se convertir en un selector el segmento de entorno en PSP:2ch si era un valor
distinto de cero antes de la llamada a _pm_init. FS y GS sern devueltos como 0
(selector NULL). Tu cdigo se estar ahora ejecutando en un segmento de cdigo
de 16 bit en modo protegido, con acceso total a las funciones de la INT 31h en
modo protegido. Si el sistema es DPMI, esta ser la ltima vez que tu cdigo
habr hablado con PMODE y de aqu en adelante usar directamente el host DPMI.

Ambas funciones son FAR y el formato completo de la llamada es como sigue:

) _pm_info - Obtiene informacin del modo protegido:
  In:
    Nada
  Out:
    AX - cdigo de retorno:
         0000h - tuvo xito
         0001h - no se detect 80386 o superior
         0002h - el sistema ya est en modo protegido y no se encontr VCPI or
                 DPMI
         0003h - DPMI - el host no es de 32bit
       CF - fijado si hay error, si no hay error:
         BX - nmero de prrafos necesarios para los datos en modo protegido
              (puede ser 0)
         CL - tipo de procesador:
           03h - 80386
           04h - 80486
           05h - 80586
           06h-FFh - reservado para un uso futuro
         CH - tipo de modo protegido:
           00h - raw
           01h - XMS
           02h - VCPI
           03h - DPMI

) _pm_init - Inicializa el modo protegido:
  In:
    ES - segmento en modo real para los datos en modo protegido (si no se
         necesita es ignorado)
  Out:
    AX - cdigo de retorno:
      0000h - tuvo xito
      0001h - no se detect 80386 o superior
      0002h - el sistema ya est en modo protegido y no se encontr VCPI or
              DPMI
      0003h - DPMI - el host no es de 32bit
      0004h - no se pudo activar la puerta A20
      0005h - DPMI - no se pudo entrar al modo protegido de 32bit
      0006h - DPMI - no se pudieron asignar los selectores necesarios
    CF - fijado si hay error, si no hay error:
      ESP - se limpia la palabra alta
      CS - selector de 16bit para CS en modo real con un lmite de 64k
      SS - selector de 32bit para SS en modo real con un lmite de 64k
      DS - selector de 32bit para DS en modo real con un lmite de 64k
      ES - selector de 32bit para PSP con un lmite de 100h
      FS - 0 (selector NULL)
      GS - 0 (selector NULL)

  Los selectores CS, DS y SS devueltos desde _pm_init pueden ser modificados o
liberados por tu cdigo. El selector PSP y el selector de entorno transformado
en el PSP quiz no puedan serlo. Para terminar bajo PMODE, tu cdigo debe usar
la funcin 4ch de la INT 21h en modo protegido. Al igual que en el modo real,
AL es el cdigo de retorno. Tu cdigo debera terminar nicamente desde la
corriente principal de ejecucin. Es decir, no intentes salir desde un
manejador de IRQ en modo protegido o desde una llamada de retorno en modo real.
Antes de acabar, tu cdigo tiene las siguientes responsabilidades:

) Restaurar todos los vectores de interrupcin en modo real que fuesen
  enganchados.

) Liberar todos los bloques de memoria extendida que fuesen asignados (esto es
  una salida desde estndar de DPMI).

1.1 - Segmentos, selectores y descriptores:
-------------------------------------------

  Como ya sabes (espero), en modo protegido se usan selectores en vez de los
verdaderos valores de segmento en los registros de segmento. Bsicamente, los
selectores son indexados en las tablas de sistema que contienen toda la
informacin sobre los segmentos en los descriptores. Puedes pensar en los
selectores como manejadores para los segmentos. Son independientes de la
localizacin y el tamao reales del segmento en la memoria.

  Bajo PMODE, tu cdigo puede asignar sus propios selectores y descriptores.
Puedes configurar segmentos de cdigo, segmentos de datos y tus propios
segmentos de pila. Estos segmentos pueden ser de 16bit, de 32bit o una mezcla
de ambos. El mejor uso de la flexibilidad del modo protegido es configurar
segmentos muy grandes, eliminando, en realidad, la necesidad de la
segmentacin. Puedes configurar un descriptor de cdigo y establecer su tamao
en 4G. A continuacin un descriptor de datos del mismo tamao y con la misma
direccin base. Puesto que toda la memoria se puede direccionar desde un nico
segmento, no hay necesidad de otros segmentos. Pero estn disponibles,
posiblemente para mdulos de cdigo que vayan a ser cargados desde disco en
segmentos separados.

  Tras la asignacin de un descriptor, tu cdigo puede configurarlo de una sola
vez con la funcin Establecer Descriptor (000ch). O puedes establecer la
direccin base, el lmite y los tipos/derechos de acceso independientemente.
Tambin puedes asignar un descriptor y tenerlo automticamente establecido en
la misma direccin base y el mismo tamao que otro descriptor usando la funcin
Crear Decriptor de Alias (000ah). Tu cdigo tambin puede leer todo un
descriptor o la direccin base de un descriptor. No existe la funcin Tomar
Lmite del Segmento ya que la instruccin LSL realiza esta funcin. La
instruccin LAR devuelve los tipos/derechos de acceso de un descriptor.

  Tcnicamente, el DPMI puede denegar peticiones para configurar segmentos muy
grandes por razones de proteccin. Pero ningn host DPMI que conozca hace esto.
Todos ellos realizan la proteccin en el nivel de paginacin. DPMI 1.0
especifica una funcin que devuelve un techo absoluto para segmentos grandes.
Permitiendo la memoria plana, pero quedndose corto en el rango de los 4G de las
direcciones lineales. Yo no me preocupara por esto. Si los hosts DPMI 1.0
comenzaran a denegar peticiones para establecer el tamao de los segmentos en
4G, muchos programas extendidos en modo protegido dejaran de funcionar.

  Cuando se configura un descriptor de datos que va a ser usado como un
segmento de pila, ten en cuenta que el bit B determinar si los PUSHes y POPs
en esta pila usan SP o ESP como el tope del puntero de pila. Sin embargo,
incluso si usas una pila con el bit B libre (usando SP), ESP debera seguir
siendo el tope del puntero de pila. Lo que significa que cuando se est usando
un segmento de pila de 16bit, la palabra alta de ESP DEBE estar libre.

1.2 - Enlace de pilas y modos:
------------------------------

  Dentro de tu corriente principal de ejecucin, tu cdigo puede configurar su
propia pila. Pero hay veces en que se le suministra a tu cdigo una pila y tu
cdigo debera permanecer en esta pila. En esas ocasiones, tu cdigo puede
enlazar pilas durante el proceso, pero debera volver a la misma pila a la que
se le llam. Esto se da durante el mantenimiento de interrupciones de hardware
o de llamadas de retorno en modo real en el modo protegido.

  La conexin entre el modo protegido y modo real se puede lograr de una de
las siguientes maneras. En modo protegido, los manejadores por defecto de IRQ
cambian al modo real para ejecutar el manejador en modo real para la IRQ
especfica que se llam. Una instruccin INT de software en modo protegido
tambin es, por defecto, enviada al modo real para el procesamiento. Hay tres
funciones especficas que te permiten llamar a las interrupciones y los
procedimientos del modo real de un modo mucho ms estructurado. Estn las
llamadas de retorno en modo real. Bsicamente, son direcciones en modo real
que, cuando son llamadas en modo real, transfieren el control a las rutinas del
modo protegido definidas por tu cdigo. Y, finalmente, est el enlace del modo
raw. Tu cdigo puede obtener las direcciones de una rutina en modo real que
cambiar el sistema al modo protegido y de una rutina en modo protegido que
cambiar el sistema al modo real. Este es el mtodo de nivel inferior, y el ms
rpido, para el intercambio de modos. El redireccionado de IRQ e INT se discute
ms adelante, as como las llamadas de retorno en modo real.

  Las funciones 0300h, 0301h y 0302h de la INT 31h le permiten a tu cdigo
llamar a las interrupciones en modo real de las rutinas FAR. Dado que los
selectores en modo protegido no son vlidos en modo real, debes meter los
valores a cargar en los registros de segmento en el modo real, para la
interrupcin o la rutina, en una estructura de memoria. Esta estructura tambin
contiene los registros generales por si deseas pasarlos al modo real. El uso de
estas funciones de la INT 31h, te permite especificar una parte de los datos
de la pila en modo protegido que vayan a ser puestos en la pila en modo real
para la llamada a la interrupcin o al procedimiento. Tampoco tienes que
suministrar una pila en modo real. Si pones a 0 los campos SS y SP en la
estructura de registro, PMODE suministrar una pila en modo real para la
llamada en modo real. Sin embargo, si lo prefieres, puedes suministrar la pila
t mismo. Tras el retorno de la llamada en modo real, la estructura de registro
contendr los valores que fueron devueltos a los registros desde el
procedimiento o el manejador de interrupcin en modo real. Sin embargo, los
campos CS, IP, SS y SP permanecern inalterados.

  Usar las rutinas de enlace en modo raw es la forma ms rpida para cambiar
entre modos. Sin embargo, si se van a usar estas funciones, se deben tomar
medidas especiales para preservar el estado del sistema. Si se usa el enlace en
modo raw, debes usar las funciones de grabar/restaurar estado cuyas direcciones
las puedes obtener con la funcin 0305h de la INT 31h. El estado se graba en un
buffer que t suministras. Un buen lugar para este buffer es la pila. Algn
ejemplo de cdigo:

buffersize      dd      ?               ; tamao del buffer de estado

pmstate         df      ?               ; selector:offset de la rutina de estado
pmtorm          df      ?               ; selector:offset de la rutina de enlace

rmstate         dd      ?               ; segmento:offset de la rutina de estado
rmtopm          dd      ?               ; segmento:offset de la rutina de enlace

;este cdigo toma y almacena las direcciones de las diversas rutinas

        mov ax,305h                     ; toma las direcciones de las rutinas
        int 31h                         ;  de grabar/restaurar estado

        movzx eax,ax                    ; pone a cero la palabra alta de EAX
        mov buffersize,eax              ; tamao del buffer de estado
        mov word ptr rmstate[0],cx      ; offset de la rutina de estado en modo
                                        ; real
        mov word ptr rmstate[2],bx      ; segmento de la rutina de estado en
                                        ; modo real
        mov dword ptr pmstate[0],edi    ; offset de la rutina en modo protegido
        mov word ptr pmstate[4],si      ; selector de la rutina en modo
                                        ; protegido

        mov ax,306h                     ; toma las direcciones de las rutinas
        int 31h                         ;  de enlace de modos

        mov word ptr rmtopm[0],cx       ; offset de la rutina de enlace en modo
                                        ; real
        mov word ptr rmtopm[2],bx       ; segmento de la rutina de enlace en
                                        ; modo real
        mov dword ptr pmtorm[0],edi     ; offset de la rutina en modo protegido
        mov word ptr pmtorm[4],si       ; selector de la rutina en modo
                                        ; protegido

; este cdigo graba el estado y salta al modo real

        sub esp,buffersize              ; asigna espacio de buffer en la pila
        mov edi,esp                     ; establece ES:EDI = SS:ESP, direccin
                                        ; de buffer
        mov ax,ss
        mov es,ax
        xor al,al                       ; establece AL = 0, graba el estado
        call pmstate                    ; graba el estado

        mov ax,real_mode_DS_value       ; establece los valores para los
                                        ; regitros en modo real
        mov cx,real_mode_ES_value
        mov dx,real_mode_SS_value
        mov bx,real_mode_SP_value
        mov si,real_mode_CS_value
        mov di,real_mode_IP_value
        jmp pmtorm                      ; cambia al modo real

; esto restaurar el estado tras volver del modo real

        mov edi,esp                     ; establece ES:EDI = SS:ESP, direccin
                                        ; del buffer
        mov ax,ss
        mov es,ax
        mov al,1                        ; establece AL = 1, restaurar estado
        call pmstate                    ; restaurar estado
        add esp,buffersize              ; descartar el espacio de buffer en la
                                        ; pila

  El cdigo en modo real para grabar/restaurar el estado y llamar al modo
protegido sera similar, excepto que EBX se usara para pasar un valor a ESP y
EDI se usara para pasar EIP antes que IP en los enlaces de modos. Adems,
ES:DI se usara como el buffer de estado en vez de ES:EDI.

1.3 - Interrupciones:
---------------------

  Cuando se entra primero al modo protegido, todas las interrupciones, excepto
aquellas que suministran funcionalidad a DPMI, estn dirigidas a un manejador
que las pasar al modo real. Es decir, una instruccin INT de software
ejecutada por tu cdigo en modo protegido ocasionar que la CPU se cambie al
modo real y la interrupcin ser re-lanzada en modo real.
Tras la vuelta del manejador de la interrupcin, el sistema ser cambiado de
nuevo al modo protegido. Todos los registros generales (EAX, EBX, ECX, EDX,
ESI, EDI y EBP) en modo protegido son pasados al manejador en modo real, y los
registros y flags generales son devueltos desde el modo real. Los registros de
segmento no son pasados al modo real puesto que los registros de segmento
tienen significados diferentes en modo protegido y en modo real. Esto significa
que puedes llamar rutinas de interrupcin simples que no requieran valores en
registros de segmento, tales como la funcin 0 de teclado de la BIOS para
leer un carcter del teclado, simplemente poniendo AH a 0 y lanzando una
INT 16h en modo protegido. Si necesitas pasar registros de segmento a un
manejador de interrupcin en modo real, debes usar la funcin 0300h de la
INT 31h.

  Igualmente, las IRQs son pasadas al modo real. PMODE, para lograr un ligero
aumento de velocidad, no pasar ningn registro a o desde un manejador de IRQ
en modo real. Un host DPMI autntico probablemente pasar los registros
generales tal como hara para una instruccin INT de software. Puedes enganchar
un vector de interrupcin en modo protegido para cualquier interrupcin, 0-0ffh,
y procesar la interrupcin enteramente en modo protegido si lo deseas. O puedes
hacer parte del procesado en modo protegido y luego enlazar con el manejador en
modo real mediante la transferencia del control al manejador previo para la
interrupcin que enganchaste con tu cdigo.

  Si una IRQ tiene lugar en modo real, por defecto no ser pasada a su
manejador en modo protegido. Por el contrario, ir directamente a su manejador
en modo real. Bajo un verdadero host DPMI, la IRQ probablemente sera enviada
en primer lugar a su manejador en modo protegido. Si deseas enviar IRQs que
tienen lugar en modo real a un manejador en modo protegido, configura una
llamada de retorno en modo real para ese vector de interrupcin. O ms rpido
que eso, instala tu propia rutina en modo real que cambiar a tu cdigo en modo
protegido usando las rutinas raw para intercabio de modos.

  PMODE suministrar una pila en modo real tanto para el redireccionamiento de
la INT de software como para el redireccionamiento de la IRQ de hardware al
modo real. Si no hay disponible una pila en modo real debido a demasiadas
llamadas anidadas en modo real, el altavoz interno del PC se activar y el
ordenador se colgar. Prefiero esto al cdigo de excepcin estropeando mi
estupendo y bonito extensor.

  En modo protegido, cuando se llama a los manejadores de interrupciones, el
flag de interrupcin no est desactivado como ocurre en modo real. Esto es as
slo para las IRQs y las interrupciones 0-7. Los manejadores para todas las
otras interrupciones en modo protegido no deben dar por sentado que el flag de
la interrupcin ha sido limpiado para ellos. Si necesitan que las
interrupciones estn desactivadas, deben hacerlo ellos mismos.

  Bajo DPMI, el flag de la interrupcin puede que necesite ser virtualizado.
Te ahorrar una larga explicacin porque cualquier buen texto sobre DPMI te
la dar. Pero te dar algunas reglas:

) No debes dar por sentado nada sobre las instrucciones que normalmente
  afectaran al flag de la interrupcin. Instrucciones como POPF e IRETD puede
  que no tengan ningn efecto en el estado actual del flag de la interrupcin.
  Adems, PUSHF o una INT puede que no almacenen correctamente el flag de la
  interrupcin, por lo que no confes en ellas para obtener informacin sobre
  el flag de la interrupcin.

) Las nicas cosas de las que puedes estar seguro que afectarn al flag de la
  interrupcin son CLI, STI y las funciones 0900h y 0901h de la INT 31h.

) Si necesitas enterarte del estado actual del flag de la interrupcin, debes
  usar una de las funciones de la INT 31h, la 0900h para limpiar y obtener el
  estado del flag de la interrupcin, la 0901h para establecer y obtener el
  estado del flag o la 0902h que simplemente devuelve el valor actual del flag
  de la interrupcin.

) Puesto que IRETD no puede afectar al flag de la interrupcin, deberas volver
  a habilitar las interrupciones en un manejador de IRQ en modo protegido. Esto
  es debido a que el flag de la interrupcin habr sido limpiado al entrar en
  el manejador.

  Cuando ests escribiendo manejadores de interrupcin, debes terminarlos con
un IRETD y no con un simple IRET. Para los manejadores de IRQ de hardware,
quiz quieras asegurarte de que todos los cdigos y datos que puedan ser
tocados por los manejadores de IRQ residan en memoria baja, por debajo de 1M.
Esta memoria est bloqueada bajo DPMI y evitar el tener que intercambiar del
disco durante el tiempo de interrupcin bajo hosts DPMI que soporten memoria
virtual. Una cosa ms que debes recordar de los manejadores de IRQ. La IRQ 2 en
realidad es la IRQ 9. Los dispositivos que dicen que usan la IRQ 2 en realidad
estn usando la IRQ 9. En modo real, el manejador de la BIOS para la IRQ 9 la
redirecciona al manejador de la IRQ 2. Este redireccionamiento no se realiza en
modo protegido. Por ello, si deseas escribir un manejador para la IRQ 2 en modo
protegido, debes ponrselo a la IRQ 9. Y acurdate de enviar el EOI al segundo
controlador de la interrupcin. El manejador de la BIOS para la IRQ 9 hace eso,
pero ya no tienes por ms tiempo la BIOS.

1.4 - Llamadas de retorno en modo real:
---------------------------------------

  Las llamadas de retorno en modo real permiten que el cdigo se ejecute en
modo real para llamar a los procedimientos en modo protegido de una forma
transparente. El cdigo en modo real cree que est pasando el control a otro
procedimiento en modo real. Esto es, en realidad, una llamada de retorno en
modo real. Lo que es bsicamente una pequea rutina que almacena los valores
de los registros en modo real en una estructura, a continuacin enlaza con el
modo protegido y pasa el control a una rutina en modo protegido que t
especifiques.

  Las llamadas de retorno son asignadas y liberadas igual que los descriptores
o la memoria. Cuando se asigna una llamada de retorno, tu cdigo especifica la
direccin de la rutina en modo protegido que va a tomar el control cuando se
llame a la llamada de retorno en modo real. Tambin debes especificar el
selector:offset de la estructura de memoria que vaya a recibir los contenidos
de los registros en modo real. El formato de esta estructura es el mismo que
para las funciones 0300h, 0301h y 0302h de la INT 31h. Cuando la rutina en modo
protegido para una llamada de retorno en modo real toma el control, las
interrupciones sern desactivadas y se definen los siguientes registros:

  DS:ESI - selector:offset correspondiente al SS:SP en modo real
  ES:EDI - selector:offset de la estructura de datos del registro en modo real
  SS:ESP - pila en modo protegido suministrada por PMODE o por el host DPMI

La estructura de datos del registro en modo real tiene el siguiente formato:

  Offset Longitud Contenidos
  00h     4       EDI
  04h     4       ESI
  08h     4       EBP
  0ch     4       reservado, ignorado
  10h     4       EBX
  14h     4       EDX
  18h     4       ECX
  1ch     4       EAX
  20h     2       flags de estado de la CPU
  22h     2       ES
  24h     2       DS
  26h     2       FS
  28h     2       GS
  2ah     2       IP, no definido
  2ch     2       CS, no definido
  2eh     2       SP
  30h     2       SS

  Todos los campos excepto los CS e IP son rellenados con los contenidos de los
registros en modo real cuando la llamada de retorno en modo real tom el
control. El procedimiento de llamada de retorno en modo protegido puede obtener
sus parmetros de la estructura de datos del registro y/o de la pila en modo
real. Recuerda que los registros de segmento contienen direcciones de segmento
en modo real y no selectores en modo protegido.

  El procedimiento de llamada de retorno en modo protegido sale con un IRETD
con la direccin de la estructura de datos del registro en modo real en ES:EDI.
La informacin puede ser pasada de vuelta al modo real modificando los
contenidos de la estructura de datos del registro y la pila en modo real. La
rutina de llamada de retorno en modo protegido es responsable de establecer la
direccin correcta para la reanudacin de la ejecucin en modo real en los
campos CS:IP de la estructura de datos del registro. Tambin es responsable
de actualizar los campos SS:SP en la estructura de datos del registro para
eliminar de la pila en modo real la direccin de la rutina de llamada en modo
real.

  La estructura de datos del registro en modo real y el selector DS usado para
mapear el segmento SS en modo real son estticos. Esto no es ningn problema si
dejas interrupciones desactivadas durante la rutina de llamada de retorno en
modo protegido. Pero si pretendes volver a activar las interrupciones, debes
asegurarte de que no vuelves a usar el selector DS. Si necesitas acceder a la
pila en modo real tras habilitar las interrupciones, debes crear un descriptor
de alias para el selector DS pasado a tu procedimiento de llamada de retorno. O
puedes tomar otra medidas, pero recuerda que el selector DS original no es
seguro por ms tiempo tras la habilitacin de las interrupciones en una rutina
de llamada de retorno en modo protegido.

  Puesto que la estructura de datos del registro en modo real tambin es
esttica, deberas tener especial cuidado si deseas activar interrupciones en
una llamada de retorno. Ya que la estructura de datos es necesaria para salir
de la llamada de retorno, no puedes simplemente no tenerla en cuenta.
Deberas hacer una copia de la estructura de datos. A continuacin puedes
pasar la copia de vuelta cuando salgas del procedimiento de llamada de retorno.
La ES:EDI a la salida no tiene por qu ser la misma que a la entrada.

1.5 - Especfico del PMODE:
---------------------------

  PMODE hace varias variables pblicas. Estas controlan ciertas cosas cuando
se ejecuta bajo un sistema VCPI, XMS o raw. Bajo DPMI, estas variables no hacen
absolutamente nada. El tamao del buffer de memoria baja en modo protegido
necesario para _pm_init se ve directamente afectado por estas variables. As,
estas deben ser fijadas al mismo valor para la llamada a _pm_info y a _pm_init.
Slo deberas modificar estas variables antes de cambiar al modo protegido.

) _pm_pagetables - Esta especifica el nmero de tablas de pgina que quieres
  tener bajo VCPI. Cada tabla de pgina requiere 4k y mapea 4M de memoria
  lineal. Las tablas de pgina slo definen espacio de direccin lineal, no
  verdadera memoria fsica. La cantidad de memoria extendida que estar
  disponible para tu cdigo ser la menor de la memoria lineal y fsica que
  haya en el sistema. Establecer un nmero mayor de tablas de pgina no te dar
  ms memoria fsica de la que hay disponible en el sistema, pero te dar ms
  espacio de direccin lineal en el que la memoria fsica pueda ser mapeada.
  Esto ayuda a reducir la fragmentacin de la memoria cuando se asignan bloques
  de memoria extendida bajo VCPI. Nunca fijes esta variable a 0 puesto que la
  primera tabla de pgina mapea el megabyte inferior de la memoria en modo real.

) _pm_selectors - Este es el nmero total de descriptores que quieres que PMODE
  convierta en disponibles para que tu cdigo los pueda asignar. El rango para
  esta variable es de 0 a unos 8150. El verdadero nmero mximo de descriptores
  que pueden existir en la tabla global de descriptores, que es donde residen
  los descriptores bajo PMODE, es 8191. Pero PMODE usa alguno de estos
  descriptores. Adems, DPMI puede que no sea capaz de suministrar tantos
  descriptores como 8000. Cada descriptor necesita 8 bytes de espacio en el
  buffer de memoria baja en modo protegido.

) _pm_callbacks - Este es el nmero de llamadas de retorno en modo real que
  quieres que PMODE suministre para ser asignados. Cada llamada de retorno
  necesita 25 bytes de espacio. Puedes fijar esta variable a 0.
  
) _pm_rmstacklen - Este es el tamao, en prrafos, de la pila en modo real que
  es suministrado para el redireccionamiento de la IRQ y la INT al modo real.
  Tambin para las funciones 0300h, 0301h y 0302h de la INT 31h cuando el campo
  SS:SP en la estructura del registro es cero.

) _pm_rmstacks - Este es el nmero de pilas en modo real que quieres ofrecer
  en caso de llamadas anidadas al modo real. Debe haber al menos una.

) _pm_pmstacklen - Este es el tamao, en prrafos, de la pila en modo protegido
  que hay que suministrar a los procedimientos en modo protegido que manejan
  llamadas de retorno en modo real.

) _pm_pmstacks - Este es el nmero de pilas en modo protegido que quieres
  ofrecer en caso de llamadas de retorno anidadas. Si tu cdigo no va a usar
  llamadas de retorno en modo real, puedes poner esta variable, junto con
  _pm_pmstacklen y _pm_callbacks, a cero.

) _pm_mode - Esta es una variable de flag de propsito general para PMODE.
  Actualmente slo el bit 0 tiene un significado, todos los dems bits deberan
  ser limpiados. El bit 0 determina el orden para detectar el DPMI y el VCPI.
  Si el bit 0 est limpio (por defecto), PMODE buscar primero DPMI. Si el bit
  0 est activado, se buscar primero el VCPI. Esto slo quiere decir que en
  sistemas donde se suministre tanto VCPI como DPMI, podrs ejecutar bajo VCPI
  en vez de DPMI si lo deseas. Esto significa que tu cdigo se ejecutar ms
  rpido y podr evitar bugs presentes en la implementacin de DPMI del
  gestionador de memoria que est presente. Si eliges detectar primero VCPI
  pero este no est presente y s lo est DPMI (como en Windows o OS/2),
  entonces se usar DPMI de todas formas.

1.6 - Pilas internas del PMODE:
-------------------------------

  El espacio de memoria de las pilas en modo real y en modo protegido usado por
PMODE para el redireccionamiento y las llamadas de retorno de INT e IRQ puede
ser usado por tu cdigo si haces tu propio enlace al modo raw y necesitas
espacio de pila. Esto es slo una pequea optimacin de memoria, especialmente
til si vas a tener muchos enlaces de modo anidados mientras usas los servicios
de modo raw y de PMODE. Estas reas de memoria slo estn disponibles bajo un
sistema VCPI/XMS/raw. Si se encuentra activo un host DPMI, PMODE no tiene el
control y no dispone de estas reas de memoria para compartirlas con tu cdigo,
en cuyo caso tendrs que asignar de todas formas por tu cuenta cualquier pila
de buffers que necesites.

  Todo lo de PMODE excepto esto es el interfaz estndar de DPMI. Si usas esta
tcnica no puedo garantizarte soporte en futuras revisiones de PMODE ni puedes
estar seguro de la 'portabilidad' a otros extensores. Por otro lado, si usas
este mtodo, tendrs de todas formas que configurar manualmente tus propios
buffers de pila si el sistema est corriendo bajo un host DPMI. Esto har que
tu cdigo sea 'portable' ya que, si alguna vez lo mueves, tienes el cdigo
del buffer de pila ah mismo. La razn por la que dejo esta opcin disponible
en PMODE es porque durante un tiempo mltiples reas de pilas anidadas para
PMODE y cualquier shell externo para l me han preocupado como una prdida de
memoria innecesaria.

  Las reas de memoria de las pilas estn definidas por cuatro variables hechas
pblicas en el segmento de PMODE. Definen la base y el tope actual de todas las
reas de pila en modo real y en modo protegido (todas las pilas anidadas para
cada modo). La base y el tope en modo protegido son punteros dword relativos al
comienzo de la memoria (0000:0000). La base y el tope en modo real son
valores de palabra de segmento en modo real. Las cimas de las pilas son
todo lo que realmente necesitas para usar las reas de pila, las bases se
suministran para el caso de que quieras comprobar que te quedas sin pilas
anidadas. Las cuatro variables son las siguientes:

) pmstacktop - Esta es la direccin lineal de la cima actual del rea de pila
  en modo protegido.

) pmstackbase - Esta es la direccin lineal de la base del rea total de pila
  en modo protegido. Si alguna vez el valor de pmstacktop cae por debajo de
  este valor te quedas sin memoria en el buffer de pila en modo protegido.

) rmstacktop - Este es el valor del segmento en modo real de la cima actual
  del rea de pila en modo real.

) rmstackbase - Este es el valor del segmento en modo real de la base del rea
  de pila en modo real. De nuevo, si el valor de rmstacktop cae por debajo de
  este valor, te quedas sin memoria de buffer de pila en modo real. Esto no
  significa necesariamente la muerte puesto que accederas a esto antes de
  cambiar realmente al modo real, slo significa que no hay suficiente espacio
  en los buffers de pila de PMODE para cambiar al modo real.

  El tamao de todas las reas de pila en modo real y en modo protegido se
define cuando entras en el modo protegido mediante las variables _pm_rmstacklen,
_pm_rmstacks, _pm_pmstacklen, _pm_pmstacks. El rea de pila en modo real es el
usado por PMODE para redireccionar la INT y la IRQ y las funciones 0300h, 0301h
y 0302h de la INT 31h y su tamao total en bytes es _pm_rmstacklen *
_pm_rmstacks * 16. El rea de pila en modo protegido es la usada por las
llamadas de retorno y su tamao es _pm_pmstacklen * _pm_pmstacks * 16. Esto
significa que si pretendes usar las pilas en modo protegido de PMODE debes
hacerlas disponibles mediante _pm_pmstacklen y _pm_pmstacks incluso si no usas
llamadas de retorno en modo real. Estas reas de pila se usan desde arriba
hasta abajo as como se asignan las pilas de modo anidado.

Ejemplo de uso:

; este cdigo carga DX:BX con un SS:SP vlido en modo real para un cambio de
; modo raw a modo real suponiendo que DS es un selector que mapea el segmento
; de PMODE PMODE_TEXT
   
        mov dx,rmstacktop               ; DX = cima actual de la pila en modo
                                        ; real
        mov bx,_pm_rmstacklen           ; BX = longitud de la pila de PMODE en
                                        ; modo real
        sub dx,bx                       ; resta el tamao de la pila desde la
                                        ; cima

        cmp dx,rmstackbase              ; comprueba si se queda sin memoria
        jb ran_out_of_RM_stack_memory

        mov rmstacktop,dx               ; pone de vuelta el valor ajustado
        shl bx,4                        ; ajusta la longitud de la pila de los
                                        ; parmetros a bytes

; DX:BX ahora contiene el segmento:offset en modo real de una pila vlida en
; modo real y podra ser usado por los servicios de enlace de modo raw,
; tras la vuelta del modo real debes recordar ajustar la cima actual de la pila

        mov ax,_pm_rmstacklen           ; AX = longitud de la pila en modo real
        add rmstacktop,ax               ; reajusta la cima de la pila en modo
                                        ; real

; este cdigo carga DX:EBX con un SS:ESP vlido en modo protegido para un
; cambio de modo raw a modo protegido suponiendo que DS es PMODE_TEXT

        mov ebx,pmstacktop              ; EBX = cima actual de la pila protegida
        mov ecx,ebx                     ; ECX = EBX para ajuste
        mov eax,_pm_pmstacklen          ; EAX = longitud de la pila en modo
                                        ; protegido
        shl eax,4                       ; convierte la longitud de los
                                        ; parmetros en bytes
        sub ecx,eax                     ; resta el tamao de la pila desde la
                                        ; cima

        cmp ecx,pmstackbase             ; comprueba si se queda sin memoria
        jb ran_out_of_PM_stack_memory

        mov pmstacktop,ecx              ; pone de vuelta el valor ajustado

; EBX ahora contiene la cima de un rea de pila en modo protegido relativa
; al comienzo de la memoria, todava debes cargar DX con un SS vlido en modo
; protegido y ajustar EBX mediante la direccin base de este selector para
; convertirlo en un ESP vlido relativo a la base del segmento de pila

        mov dx,PM_stack_selector        ; DX = SS selector para modo protegido
        sub ebx,PM_stack_selector_base  ; ajusta EBX para un ESP vlido

; y por supuesto tras volver del modo protegido reajusta la cima de la pila

        mov eax,_pm_pmstacklen          ; EAX = longitud de la pila en modo
                                        ; protegido
        shl eax,4                       ; convierte la longitud de los
                                        ; parmetros en bytes
        add pmstacktop,eax              ; reajusta la cima de la pila en modo
                                        ; protegido

  No tienes que usar _pm_rmstacklen y _pm_pmstacklen para el tamao de las
pilas que asignas desde la memoria de pila, pero deberas conservar los tamaos
al menos mltiplos de palabra doble. Tampoco hagas las pilas demasiado pequeas,
al menos 128 bytes es un buen valor mnimo.

  Como dije, bajo un verdadero host DPMI, PMODE no inicializa estas reas de
memoria de pila. Tu cdigo tendr que hacerlo por su cuenta. Pero puedes usar
las mismas variables para almacenar la base y la cima de las reas de memoria
de pila que tu cdigo asigna puesto que PMODE no las usar ya que no tendr el
control. Esto significa que puedes usar el mismo cdigo para el enlace de modo
raw y el modo de asignacin de pila. Todo lo que se necesitar es algo de
cdigo en el momento de iniciar el modo protegido que asignar algo de memoria
para las reas de pila y almacenar su base y su cima en las variables
respectivas.

------------------------------------------------------------------------------
2 - Funciones:
--------------

  PMODE duplica un subgrupo de funciones en modo protegido de DPMI. Estas
funciones estn disponibles SOLO en modo protegido a travs de la INT 31h.
Suministran servicios de descriptor, servicios de memoria extendida, servicios
de interrupcin, servicios de conversin y otra serie de cosas. Para llamar
a una funcin se fija AX al cdigo de la funcin, fijando todos los dems
registros para la funcin y ejecutando una INT 31h. Una vez se vuelve, el flag
de acarreo ser limpiado si la funcin tuvo xito. Si el flag de acarreo est
activado, la funcin fall. En este caso, se situar un cdigo de error en AX.
Sin embargo, DPMI 0.9 no devolver cdigos de error, slo el flag de acarreo
fijado en errores. El resto de registros se preservan a no ser que se
especifique otra cosa.

2.0 - Funcin 0000h - Asignar Descriptores:
-------------------------------------------

Asigna uno o ms descriptores en la tabla de descriptor del cliente. El/los
descriptor(es) asignado(s) debe(n) ser inicializado(s) por la aplicacin con
otras llamadas de funcin.

In:
  AX     = 0000h
  CX     = nmero de descriptores a asignar

Out:
  si tiene xito:
  AX     = selector base

  si falla:
  AX     = cdigo de error:
           8011h - descriptor no disponible
           8021h - valor no vlido (CX = 0) (slo VCPI/XMS/raw)

Notas:
) Si se solicit ms de un descriptor, la funcin devuelve un selector base
  referenciando el primero de una matriz contigua de descriptores. Los
  valores del selector para posteriores descriptores en la matriz se pueden
  calcular aadiendo el valor devuelto por la funcin 0003h de la INT 31h.

) El/los descriptor(es) asignado(s) se establecern para expandir los datos
  escribibles, con el bit actual fijo y una base y un lmite de cero.
  El nivel de privilegio del descriptor coincidir con el nivel de privilegio
  del segmento de cdigo del cliente.

2.1 - Funcin 0001h - Liberar Descriptor:
-----------------------------------------

Libera un descriptor.

In:
  AX     = 0001h
  BX     = selector para el descriptor a liberar

Out:
  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido

Notas:
) Cada descriptor asignado con la funcin 0000h de la INT 31h debe ser liberado
  individualmente con la funcin. Incluso si fue previamente asignado como
  parte de una matriz contigua de descriptores.

) Bajo DPMI 1.0/VCPI/XMS/raw, todos los registros de segmento que contengan el
  selector que est siendo liberado son puestos a cero por esta funcin.

2.2 - Funcin 0003h - Toma el Valor de Incremento del Selector:
---------------------------------------------------------------

La funcin Asignar Descriptores (0000h) puede asignar una matriz de
descriptores contiguos, pero slo devuelve un selector para el primer
descriptor. El valor devuelto por esta funcin se puede usar para calcular los
selectores para los siguientes descriptores en la matriz.

In:
  AX     = 0003h

Out:
  siempre tiene xito:
  AX     = valor de incremento del selector

Notas:
) El valor de incremento es siempre una potencia de dos.

2.3 - Funcin 0006h - Obtiene la Direccin Base del Segmento:
-------------------------------------------------------------

Devuelve la direccin base lineal de 32bit desde la tabla de descriptores para
el segmento especificado.

In:
  AX     = 0006h
  BX     = selector

Out:
  si tiene xito:
  CX:DX  = direccin base lineal de 32bit del segmento

  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido

Notas:
) Los programas del cliente deben usar la instruccin LSL para preguntar el
  lmite para un descriptor.

2.4 - Funcin 0007h - Establecer la Direccin Base del Segmento:
----------------------------------------------------------------

Establece el campo de la direccin base lineal de 32bit en el descriptor para
el segmento especificado.

In:
  AX     = 0007h
  BX     = selector
  CX:DX  = direccin base lineal de 32bit del segmento

Out:
  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido
           8025h - direccin lineal no vlida (cambiar la base provocara que
                   el descriptor referenciara un rango de direccin lineal que
                   estara fuera del permitido por los clientes de DPMI) (slo
                   DPMI 1.0)

Notas:
) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no est garantizado que lo haga.

) Confo que tengas el sentido suficiente como para no intentar modificar tus
  actuales descriptores CS o SS.

2.5 - Funcin 0008h - Establecer el Lmite del Segmento:
--------------------------------------------------------

Establece el campo lmite en el descriptor para el segmento especificado.

In:
  AX     = 0008h
  BX     = selector
  CX:DX  = lmite del segmento de 32bit

Out:
  si falla:
  AX     = cdigo de error:
           8021h - valor no vlido (el lmite es > 1M, pero los 12 bits bajos
                   no estn fijados)
           8022h - selector no vlido
           8025h - direccin lineal no vlida (cambiar la base provocara que
                   el descriptor referenciara un rango de direccin lineal que
                   estara fuera del permitido por los clientes de DPMI) (slo
                   DPMI 1.0)

Notas:
) El valor proporcionado a la funcin en CX:DX es la longitud del byte del
  segment-1.

) Lmites de segmento mayores o iguales a 1M deben ser alineados en pginas.
  Es decir, deben tener los 12 bit bajos fijos.

) Esta funcin tiene un efecto implcito en el bit "G" en el descriptor del
  segmento.

) Los programas del cliente deben usar la instruccin LSL para preguntar el
  lmite para un descriptor.

) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no est garantizado que lo haga.

) Confo que tengas el sentido suficiente como para no intentar modificar tus
  actuales descriptores CS o SS.

2.6 - Funcin 0009h - Establecer los Derechos de Acceso del Descriptor:
-----------------------------------------------------------------------

Modifica el campo de los derechos de acceso en el descriptor para el segmento
especificado.

In:
  AX     = 0009h
  BX     = selector
  CX     = palabra de derechos de acceso/tipo

Out:
  si falla:
  AX     = cdigo de error:
           8021h - valor no vlido (palabra de derechos de acceso/tipo no
                   vlida)
           8022h - selector no vlido
           8025h - direccin lineal no vlida (cambiar la base provocara que
                   el descriptor referenciara un rango de direccin lineal que
                   estara fuera del permitido por los clientes de DPMI) (slo
                   DPMI 1.0)

Notas:
) La palabra de derechos de acceso/tipo pasada a la funcin en CX tiene el
siguiente formato:

    Bit: 15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
       | G |B/D| 0 | ? |       ?       | 1 |  DPL  | 1 |C/D|E/C|W/R| A |
       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+

    G   - 0=byte granular, 1=pgina granular
    B/D - 0=por defecto 16bit, 1=por defecto 32bit
    DPL - debe ser igual al CPL del que llama
    C/D - 0=datos, 1=cdigo
    E/C - datos: 0=expand-up, 1=expand-down
          cdigo: debe ser 0 (no ajustado)
    W/R - datos: 0=leer, 1=leer/escribir
          cdigo: debe ser 1 (legible)
    A   - 0=no accedido, 1=accedido
    0   - debe ser 0
    1   - debe ser 1
    ?   - ignorado

) Los programas del cliente deberan usar la instruccin LAR para examinar
  los derechos de acceso de un descriptor.

) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no est garantizado que lo haga.

) Confo que tengas el sentido suficiente como para no intentar modificar tus
  actuales descriptores CS o SS.

2.7 - Funcin 000Ah - Crear un Descriptor de Alias:
---------------------------------------------------

Crea un nuevo descriptor de datos que tiene la misma base y el mismo lmite que
el descriptor especificado.

In:
  AX     = 000ah
  BX     = selector

Out:
  si tiene xito:
  AX     = selector de datos (alias)

  si falla:
  AX     = cdigo de error:
           8011h - descriptor no disponible
           8022h - selector no vlido

Notas:
) El selector suministrado a la funcin puede ser tanto un descriptor de datos
  como un descriptor de cdigo. El descriptor de alias creado siempre es
  segmento de datos escribible expandido.

) El descriptor de alias devuelto por la funcin no marcar cambios en el
  descriptor original.

2.8 - Funcin 000Bh - Toma el Descriptor:
-----------------------------------------

Copia la entrada de la tabla de descriptor para el selector especificado en un
buffer de 8 byte.

In:
  AX     = 000bh
  BX     = selector
  ES:EDI = selector:offset de un buffer de 8 byte

Out:
  si tiene xito:
  el buffer al que se seal por ES:EDI contiene un descriptor

  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido

2.9 - Funcin 000Ch - Establecer Descriptor:
--------------------------------------------

Copia el contenido de un buffer de 8 byte en el descriptor para el selector
especificado.

In:
  AX     = 000ch
  BX     = selector
  ES:EDI = selector:offset de un buffer de 8 byte que contenga el descriptor

Out:
  si falla:
  AX     = cdigo de error:
           8021h - valor no vlido (palabra de derechos de acceso/tipo no
                   vlida)
           8022h - selector no vlido
           8025h - direccin lineal no vlida (cambiar la base provocara que
                   el descriptor referenciara un rango de direccin lineal que
                   estara fuera del permitido por los clientes de DPMI) (slo
                   DPMI 1.0)

Notas:
) La palabra de derechos de acceso/tipo de los descriptores con un offset de 5
  dentro del descriptor siguen el mismo formato y restricciones que el parmetro
  derechos de acceso/tipo CX para la funcin Establecer los Derechos de Acceso
  del Descriptor (0009h).

) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no est garantizado que lo haga.

) Confo que tengas el sentido suficiente como para no intentar modificar tus
  actuales descriptores CS o SS o el descriptor del buffer.

2.10 - Funcin 000Eh - Devuelve Mltiples Descriptores:
-------------------------------------------------------

Copia una o ms entradas de la tabla de descriptor en un buffer.

In:
  AX     = 000eh
  CX     = nmero de descriptores a copiar
  ES:EDI = selector:offset de un buffer con el siguiente formato:

           Offset Longitud Contenidos
           00h     2       Selector #1 (fijado por el cliente)
           02h     8       Descriptor #1 (devuelto por el host)
           0ah     2       Selector #2 (fijado por el cliente)
           0ch     8       Descriptor #2 (devuelto por el host)
           ...     ...     ...

Out:
  si tiene xito:
  el buffer contiene copias de los descriptores para los selectores
  especificados

  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido
  CX     = nmero de descriptores copiados con xito

Notas:
) Si se produce un error debido a un selector o a un descriptor no vlido, la
  funcin devuelve el nmero de descriptores que fueron copiados con xito en
  CX. Todos los descriptores que se copiaron antes que el que fall son
  vlidos.

) Esta funcin no est presente bajo DPMI 0.9.

2.11 - Funcin 000Fh - Establecer Mltiples Descriptores:
---------------------------------------------------------

Copia uno o ms descriptores de un buffer del cliente en la tabla de
descriptor.

In:
  AX     = 000fh
  CX     = nmero de descriptores a copiar
  ES:EDI = selector:offset de un buffer con el siguiente formato:

           Offset Longitud Contenidos
           00h     2       Selector #1
           02h     8       Descriptor #1
           0ah     2       Selector #2
           0ch     8       Descriptor #2
           ...     ...     ...

Out:
  si falla:
  AX     = cdigo de error:
           8021h - valor no vlido (palabra de derechos de acceso/tipo no
                   vlida)
           8022h - selector no vlido
           8025h - direccin lineal no vlida (cambiar la base provocara que
                   el descriptor referenciara un rango de direccin lineal que
                   estara fuera del permitido por los clientes de DPMI) (slo
                   DPMI 1.0)
  CX     = nmero de descriptores copiados con xito

Notas:
) Si se produce un error debido a un selector o a un descriptor no vlido, la
  funcin devuelve el nmero de descriptores que fueron copiados con xito en
  CX. Todos los descriptores que se copiaron antes que el que fall son
  vlidos.

) La palabra de derechos de acceso/tipo de los descriptores con un offset de 5
  dentro del descriptor siguen el mismo formato y restricciones que el parmetro
  derechos de acceso/tipo CX para la funcin Establecer los Derechos de Acceso
  del Descriptor (0009h).

) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en la estructura de datos.
  DPMI 0.9 puede hacer esto, pero no est garantizado que lo haga.

) Confo que tengas el sentido suficiente como para no intentar modificar tus
  actuales descriptores CS o SS o el descriptor del buffer.

) Esta funcin no est presente bajo DPMI 0.9.

2.12 - Funcin 0100h - Asignar Bloque de Memoria de DOS:
--------------------------------------------------------

  Asigna memoria baja a travs de la funcin 48h de DOS y la asigna a un
descriptor.

In:
  AX     = 0100h
  BX     = prrafos a asignar

Out:
  si tiene xito:
    flag de acarreo limpio
    AX     = direccin de segmento en modo real
    DX     = selector en modo protegido para el bloque de memoria

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS
    BX     = tamao del bloque disponible ms grande

2.13 - Funcin 0101h - Liberar Bloque de Memoria de DOS:
--------------------------------------------------------

  Libera un bloque de memoria baja previamente asigando por la funcin 0100h.

In:
  AX     = 0101h
  DX     = selector en modo protegido para el bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS

2.14 - Funcin 0102h - Dar Nuevo Tamao al Bloque de Memoria de DOS:
--------------------------------------------------------------------

  Da un nuevo tamao a un bloque de memoria baja previamente asignado por la
funcin 0100h.

In:
  AX     = 0102h
  BX     = nuevo tamao del bloque en prrafos
  DX     = selector en modo protegido para el bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS
    BX     = tamao del bloque disponible ms grande

2.15 - Funcin 0200h - Toma el Vector de Interrupcin en Modo Real:
-------------------------------------------------------------------

Devuelve el segmento:offset en modo real para el vector de interrupcin
especificado.

In:
  AX     = 0200h
  BL     = nmero de interrupcin

Out:
  siempre tiene xito:
  CX:DX  = segmento:offset del manejador de interrupcin en modo real

Notas:
) El valor devuelto en CX es una direccin de segmento en modo real, no un
  selector en modo protegido.

2.16 - Funcin 0201h - Establecer el Vector de Interrupcin en Modo Real:
-------------------------------------------------------------------------

Establece el segmento:offset en modo real para el vector de interrupcin
especificado.

In:
  AX     = 0201h
  BL     = nmero de interrupcin
  CX:DX  = segmento:offset del manejador de interrupcin en modo real

Notas:
) El valor pasado en CX debe ser una direccin de segmento en modo real, no un
  selector en modo protegido. Consecuentemente, el manejador de interrupcin
  debe o bien residir en la memoria DOS (por debajo del lmite de 1M) o el
  cliente debe asignar una direccin de llamada de retorno en modo real.

2.17 - Funcin 0204h - Toma el Vector de Interrupcin en Modo Protegido:
------------------------------------------------------------------------

Devuelve la direccin del manejador de interrupcin actual en modo protegido
para la interrupcin especificada.

In:
  AX     = 0204h
  BL     = nmero de interrupcin

Out:
  siempre tiene xito:
  CX:EDX = selector:offset del manejador de interrupcin en modo protegido

Notas:
) El valor devuelto en CX es un selector en modo protegido vlido, no una
  direccin de segmento en modo real.

2.18 - Funcin 0205h - Establecer el Vector de Interrupcin en Modo Protegido:
------------------------------------------------------------------------------

Establece la direccin del manejador de interrupcin en modo protegido para la
interrupcin especificada.

In:
  AX     = 0205h
  BL     = nmero de interrupcin
  CX:EDX = selector offset del manejador de interrupcin en modo protegido

Out:
  si falla:
  AX     = cdigo de error:
           8022h - selector no vlido

Notas:
) El valor pasado en CX debe ser un selector en modo protegido vlido, no una
  direccin de segmento en modo real.

2.19 - Funcin 0300h - Simular Interrupcin en Modo Real:
---------------------------------------------------------

Simula una interrupcin en modo real. La funcin transfiere el control a la
direccin especificada por el vector de interrupcin en modo real. El manejador
en modo real debe volver mediante la ejecucin de un IRET.

In:
  AX     = 0300h
  BL     = nmero de interrupcin
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
           en modo real
  ES:EDI = selector:offset de la estructura de datos del registro con el
           siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservado, ignorado
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP (reservado, ignorado)
           2ch     2       CS (reservado, ignorado)
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
  ES:EDI = selector offset de la estructura de datos del registro en modo real
           modificada

  si falla:
  AX     = cdigo de error:
           8012h - memoria lineal no disponible (pila)
           8013h - memoria fsica no disponible (pila) (slo DPMI 1.0)
           8014h - almacenamiento de seguridad no disponible (pila) (slo DPMI
                   1.0)
           8021h - valor no vlido (CX demasiado grande) (slo DPMI 1.0)

Notas:
) Esta funcin ignora el CS:IP en la estructura de datos del registro en modo
  real. Se llamar al manejador de interrupcin apropiado basndose en el valor
  pasado en BL.

) Si los campos SS:SP en la estructura de datos del registro en modo real son
  cero, el host suministrar una pila en modo real. Si no, el SS:SP en modo
  real ser fijado en los valores especificados antes de que se llamara al
  manejador de interrupcin.

) Los flags especificados en la estructura de datos del registro en modo real
  se pondrn en el marco IRET del manejador de interrupcin en modo real. Se
  llamar al manejador de interrupcin con los flags de interrupcin y de
  seguimiento limpios.

) Los valores situados en las posiciones de registros de segmento de la
  estructura de datos deben ser vlidos para el modo real. Es decir, los
  valores deben ser direcciones de prrafos, no selectores en modo protegido.

) El manejador en modo real final debe volver con la pila en el mismo estado
  que cuando se le llam. Esto significa que el cdigo en modo real puede
  enlazar pilas mientras se est ejecutando, pero debe volver a la misma pila
  sobre la que se le llam y debe volver con un IRET.

) Cuando esta funcin vuelve, la estructura de datos del registro en modo real
  contendr los valores que fueron devueltos por el manejador de interrupcin
  en modo real. Los valores de CS:IP y SS:SP no sern modificados en la
  estructura de datos.

) Es responsabilidad del que hace la llamada el quitar todos los parmetros
  que fueron puestos en la pila en modo protegido.

2.20 - Funcin 0301h - Llamar al Procedimiento en Modo Real Con Marco de
------------------------------------------------------------------------
                       Retorno Lejano:
                       ---------------

Simula una FAR CALL (LLAMADA LEJANA) a un procedimiento en modo real. El
procedimiento al que se llam debe volver mediante la ejecucin de una
instruccin RETF.

In:
  AX     = 0301h
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
           en modo real
  ES:EDI = selector:offset de la estructura de datos del registro en modo real
           con el siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservado, ignorado
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP
           2ch     2       CS
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
  ES:EDI = selector offset de la estructura de datos del registro en modo real
           modificada

  si falla:
  AX     = cdigo de error:
           8012h - memoria lineal no disponible (pila)
           8013h - memoria fsica no disponible (pila) (slo DPMI 1.0)
           8014h - almacenamiento de seguridad no disponible (pila) (slo DPMI
                   1.0)
           8021h - valor no vlido (CX demasiado grande) (slo DPMI 1.0)

Notas:
) El CS:IP en la estructura de datos del registro en modo real especifica la
  direccin del procedimiento en modo real a llamar.

) Si los campos SS:SP en la estructura de datos del registro en modo real son
  cero, el host suministrar una pila en modo real. Si no, el SS:SP en modo
  real ser fijado a los valores especificados antes de que se llamara al
  procedimiento.

) Los valores situados en las posiciones del registro de segmento deben ser
  vlidos para el modo real. Es decir, los valores deben ser direcciones de
  prrafos, no selectores en modo protegido.

) El procedimiento en modo real final debe volver con la pila en el mismo
  estado que cuando fue llamada. Esto significa que el cdigo en modo real
  puede enlazar pilas mientras se est ejecutando, pero debe volver a la misma
  pila sobre la que se le llam y debe volver con un RETF y no debera limpiar
  la pila de ningn parmetro que le fuera pasado a la pila.

) Cuando esta funcin vuelve, la estructura de datos del registro en modo real
  contendr los valores que fueron devueltos por el procedimiento en modo real.
  Los valores CS:IP y SS:SP no sern modificados en la estructura de datos.

) Es responsabilidad del que hace la llamada el quitar todos los parmetros que
  fueron puestos en la pila en modo protegido.

2.21 - Funcin 0302h - Llamar al Procedimiento en Modo Real Con Marco IRET:
---------------------------------------------------------------------------

Simula una FAR CALL (LLAMADA LEJANA) con los flags puestos en la pila a un
procedimiento en modo real. El procedimiento en modo real debe volver mediante
la ejecucin de una instruccin IRET o un RETF 2.

In:
  AX     = 0301h
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
           en modo real
  ES:EDI = selector:offset de la estructura de datos del registro en modo real
           con el siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservado, ignorado
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP
           2ch     2       CS
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
  ES:EDI = selector offset de la estructura de datos del registro en modo real
           modificada

  si falla:
  AX     = cdigo de error:
           8012h - memoria lineal no disponible (pila)
           8013h - memoria fsica no disponible (pila) (slo DPMI 1.0)
           8014h - almacenamiento de seguridad no disponible (pila) (slo DPMI
                   1.0)
           8021h - valor no vlido (CX demasiado grande) (slo DPMI 1.0)

Notas:
) El CS:IP en la estructura de datos del registro en modo real especifica la
  direccin del procedimiento en modo real a llamar.

) Si los campos SS:SP en la estructura de datos del registro en mod real son
  cero, el host suministrar una pila en modo real.Si no, el SS:SP en modo
  real ser fijado a los valores especificados antes de que se llamara al
  procedimiento.

) Los flags especificados en la estructura de datos del registro en modo real
  se pondrn en el marco IRET del procedimiento en modo real. Se llamar al
  procedimiento con los flags de interrupcin y de seguimiento limpios.

) Los valores situados en las posiciones de los registros de segmento de la
  estructura de datos deben ser vlidos para el modo real. Es decir, los
  valores deben ser direcciones de prrafos, no selectores en modo protegido.

) El procedimiento en modo real fina> debe volver con la pila en el mismo
  estado que cuando fue llamada. Esto significa que el cdigo en modo real
  puede enlazar pilas mientras se est ejecutando, pero debe volver a la misma
  pila sobre la que se le llam y debe volver con un IRET o eliminar los flags
  de la pila con un RETF 2 y no debera limpiar la pila de ningn parmetro que
  le fuera pasado a la pila.

) Cuando esta funcin vuelve, la estructura de datos del registro en modo real
  contendr los valores que fueron devueltos por el procedimiento en modo real.
  Los valores CS:IP y SS:SP no sern modificados en la estructura de datos.

) Es responsabilidad del que hace la llamada el quitar todos los parmetros
  que fueron puestos en la pila en modo protegido.

2.22 - Funcin 0303h - Asignar la Direccin de la Llamada de Retorno en Modo
----------------------------------------------------------------------------
                       Real:
                       -----

Devuelve un segmento:offset en modo real nico, conocido como una "llamada de
retorno en modo real", que transferir el control del procedimiento en modo
real al procedimiento en modo protegido. Las direcciones de llamadas de retorno
obtenidas con esta funcin se pueden pasar mediante un programa en modo
protegido a una aplicacin en modo real, a un manejador de interrupcin, a un
controlador de dispositivo, a un TSR, etc... de tal manera que el programa en
modo real pueda llamar a los procedimientos dentro del programa en modo
protegido.

In:
  AX     = 0303h
  DS:ESI = selector:offset del procedimiento en modo protegido a llamar
  ES:EDI = selector:offset del buffer de 32h bytes para la estructura de datos
           del registro en modo real que se usar cuando se llame a la rutina
           de la llamada de retorno.

Out:
  si tiene xito:
  CX:DX  = segmento:offset de la llamada de retorno en modo real

  si falla:
  AX     = cdigo de error:
           8015h - llamada de retorno no disponible

Notas:
) Se puede asignar un descriptor para cada llamada de retorno para mantener el
  descriptor SS en modo real. Las llamadas de retorno en modo real son un
  recurso limitado del sistema. Un cliente debera liberar una llamada de
  retorno que no se siga usando.

2.23 - Funcin 0304h - Liberar la Direccin de la Llamada de Retorno en Modo
----------------------------------------------------------------------------
                       Real:
                       -----

Libera una direccin de llamada de retorno en modo real que fue previamente
asignada con la funcin Asignar la Direccin de Llamada de Retorno en Modo Real
(0303h).

In:
  AX     = 0304h
  CX:DX  = segmento:offset de la llamada de retorno en modo real a liberar

Out:
  si falla:
  AX     = cdigo de error:
           8024h - direccin de llamada de retorno no vlida

Notas:
) Las llamadas de retorno en modo real son un recurso limitado del sistema. Un
  cliente debera liberar todas las llamadas de retorno que no siga usando.

2.24 - Funcin 0305h - Obtiene las Direcciones para Salvar/Restaurar el Estado:
-------------------------------------------------------------------------------

Devuelve la direccin de dos procedimientos usados para salvar y restaurar el
estado de los actuales registros de tarea en el modo (protegido o real) que no
se est ejecutando en ese momento.

In:
  AX     = 0305h

Out:
  siempre tiene xito:
  AX     = tamao en bytes del buffer necesario para salvar el estado
  BX:CX  = segmento:offset de la rutina en modo real usada para
           salvar/restaurar el estado
  SI:EDI = selector:offset de la rutina en modo protegido usada para
           salvar/restaurar el estado

Notas:
) Se debera llamar al segmento:offset en modo real devuelto por esta funcin
  slo en modo real para salvar/restaurar el estado de los registros en modo
  protegido. Se debera llamar al selector:offset en modo protegido devuelto
  por esta funcin slo en modo protegido para salvar/restaurar el estado de
  los registros en modo real.

) Se entra en los procedimientos para salvar/restaurar el estado mediante una
  FAR CALL con los siguientes parmetros:

  AL       = 0 para salvar el estado
           = 1 para restaurar el estado
  ES:(E)DI = (selector o segmento):offset del buffer de estado

  El buffer de estado debe ser al menos tan grande como el valor devuelto en AX
  por la funcin 0305h de la INT 31h. Los procedimientos para salvar/restaurar
  el estado no modifican ningn registro. Se debe usar DI para el offset del
  buffer en modo real y usar EDI en modo protegido.

) Algunos hosts DPMI y VCPI/XMS/raw no necesitarn que se salve el estado y esto
  lo indican devolviendo un tamao de buffer de cero en AX. En tales casos,
  todava se puede llamar a esas direcciones devueltas por esta funcin, aunque
  simplemente volvern sin realizar ninguna funcin de utilidad.

) Los clientes no necesitan llamar a los procedimientos para salvar/restaurar
  el estado antes de usar las funciones 0300h, 0301h o 0302h de la INT 31h. Los
  procedimientos para salvar/restaurar el estado son suministrados por los
  clientes que usan slo los servicios de enlace del modo raw.

2.25 - Funcin 0306h - Toma las Direcciones de Enlace del Modo Raw:
-------------------------------------------------------------------

Devuelve las direcciones que se pueden llamar para el intercambio de modos a
bajo nivel.

In:
  AX     = 0306h

Out:
  siempre tiene xito:
  BX:CX  = segmento:offset del procedimiento de cambio del modo real al
           protegido
  SI:EDI = selector:offset del procedimiento de cambio del modo protegido al
           real

Notas:
) Se debera llamar al segmento:offset en modo real devuelto por esta funcin
  slo en modo real para cambiar al modo protegido. Se debera llamar al
  selector:offset en modo protegido devuelto por esta funcin slo en modo
  protegido para cambiar al modo real.

) Se entra en los procedimientos de intercambio de modos mediante un FAR JMP
  a la direccin apropiada con los siguientes parmetros:

  AX    = nuevo DS
  CX    = nuevo ES
  DX    = nuevo SS
  (E)BX = nuevo (E)SP
  SI    = nuevo CS
  (E)DI = nuevo (E)IP

  El procesador se sita en el modo deseado y los registros DS, ES, SS, (E)SP,
  CS y (E)IP son actualizados con los valores especficos. En otras palabras,
  la ejecucin del cliente contina en el modo solicitado en la direccin
  suministrada en los registros SI:(E)DI. Los valores especificados que se van
  a situar en los registros de segmento deben ser los apropiados para el modo
  de destino. Es decir, las direcciones de segmento para el modo real y los
  selectores para el modo protegido.

  Los valores en EAX, EBX, ECX, EDX, ESI y EDI tras el cambio de modo no estn
  definidos. EBP se preservar a travs de la llamada de intercambio de modo
  por lo que se puede usar como un puntero. FS y GS contendrn cero tras el
  cambio de modo.

  Si las interrupciones estn desactivadas cuando se invoca el procedimiento de
  intercambio de modo, no sern reactivadas por el host (ni siquiera
  temporalmente).

) Depende del cliente el salvar y restaurar el estado de la tarea cuando use
  esta funcin para intercambiar modos. Esto requiere procedimientos para
  salvar/restaurar el estado cuyas direcciones se puedan obtener con la funcin
  0305h de la INT 31h.

2.26 - Funcin 0400h - Muestra la Versin:
------------------------------------------

Devuelve la versin de la Especificacin de DPMI implementada por el host DPMI.
El cliente puede usar esta informacin para determinar qu funciones estn
disponibles.

In:
  AX     = 0400h

Out:
  siempre tiene xito:
  AH     = versin mayor de DPMI como un nmero binario (VCPI/XMS/raw
           devuelve 1)
  AL     = versin menor de DPMI como un nmero binario (VCPI/XMS/raw
           devuelve 0)
  BX     = flags:
           Bits    Significado
           0       0 = el host es de 16bit (PMODE nunca funciona bajo uno de
                       estos)
                   1 = el host es de 32bit
           1       0 = CPU devuelta al modo V86 para las interrupciones
                       reflejadas
                   1 = CPU devuelta al modo real para las interrupciones
                       reflejadas
           2       0 = no soporta memoria virtual
                   1 = soporta memoria virtual
           3-15    reservado
  CL     = tipo de procesador:
           03h = 80386
           04h = 80486
           05h = 80586
           06h-ffh = reservado
  DH     = valor actual de la interrupcin base del PIC maestro (las 8 IRQs
           bajas)
  DL     = valor actual de la interrupcin base del PIC esclavo (las 8 IRQs
           altas)

Notas:
) Los nmeros de la versin mayor y menor son binarios, no BCD. Por eso una
  implementacin de DPMI 0.9 devolver AH como 0 y AL como 5ah (90).

2.27 - Funcin 0500h - Muestra la Informacin de la Memoria Libre:
------------------------------------------------------------------

Devuelve informacin sobre la cantidad de memoria disponible. Puesto que los
clientes de DPMI podran estar funcionando en un entorno multitarea, se debera
considerar consultiva la informacin devuelta por esta funcin.

In:
  AX     = 0500h
  ES:EDI = selector:offset de un buffer de 48 byte

Out:
  si tiene xito:
  el buffer se llena con la siguiente informacin:

  si falla:
  AX     = cdigo de error:
           8010h - recurso interno no disonible (pila) (slo XMS)

  Offset Longitud Contenidos
  00h     4       Mayor bloque libre disponible en bytes
  04h     2ch     Otros campos slo suministrados por DPMI

Notas:
) Slo se garantiza que contenga un valor vlido el primer campo de la
  estructura. Cualquier campo que no est soportado por el host ser fijado a
  -1 (0ffffffffh) para indicar que la informacin no est disponible.

2.28 - Funcin 0501h - Asignar Bloque de Memoria:
-------------------------------------------------

Asigna un bloque de memoria extendida.

In:
  AX     = 0501h
  BX:CX  = tamao del bloque en bytes (debe ser distinto de cero)

Out:
  si tiene xito:
  BX:CX  = direccin lineal del bloque de memoria asignado
  SI:DI  = manejador del bloque de memoria (usado para dar nuevo tamao y
           liberar el bloque)

  si falla:
  AX     = cdigo de error:
           8010h - recurso interno no disponible (pila) (slo XMS)
           8012h - memoria lineal no disponible (slo DPMI 1.0/VCPI)
           8013h - memoria fsica no disponible
           8014h - almacenamiento de seguridad no disponible (slo DPMI 1.0)
           8016h - manejador no disponible (slo DPMI 1.0/XMS)
           8021h - valor no vlido (BX:CX = 0)

Notas:
) Se garantiza que el bloque asignado tenga al menos alineamiento de prrafo.

) Esta funcin no asigna ningn descriptor para el bloque de memoria. Es
  responsabilidad del cliente el asignar e inicializar cualquier descriptor que
  se necesite para acceder a la memoria con llamadas de funcin adicionales.

) Las asignaciones mediante esta funcin pueden ser prrafos, kilobyte o pgina
  alineada. Es decir, el valor que pides podra ser redondeado al siguiente
  valor de prrafo, kilobyte o pgina.

2.29 - Funcin 0502h - Liberar Bloque de Memoria:
-------------------------------------------------

Libera un bloque de memoria previamente asignado con la funcin Asignar Bloque
de Memoria (0501h).

In:
  AX     = 0502h
  SI:DI  = manejador del bloque de memoria

Out:
  si falla:
  AX     = cdigo de error:
           8010h - recurso interno no disponible (pila) (slo XMS)
           8023h - manejador no vlido

Notas:
) Esta funcin no libera ningn descriptor. Es responsabilidad del cliente el
  liberar cualquier descriptor que fuera previamente asignado para mapear el
  bloque de memoria. Los descriptores se deberan liberar antes que los bloques
  de memoria.

2.30 - Funcin 0503h - Dar Nuevo Tamao al Bloque de Memoria:
-------------------------------------------------------------

Cambia el tamao de un bloque de memoria previamente asignado con la funcin
Asignar Bloque de Memoria (0501h).

In:
  AX     = 0503h
  BX:CX  = nuevo tamao en bytes del bloque (debe ser distinto de cero)
  SI:DI  = manejador del bloque de memoria
  
Out:
  BX:CX  = nueva direccin lineal del bloque de memoria
  SI:DI  = nueva manejador del bloque de memoria

  si falla:
  AX     = cdigo de error:
           8010h - recurso interno no disponible (pila) (slo XMS)
           8012h - memoria lineal no disponible (slo DPMI 1.0/VCPI)
           8013h - memoria fsica no disponible
           8014h - almacenamiento de seguridad no disponible (slo DPMI 1.0)
           8016h - manejador no disponible (slo DPMI 1.0/XMS)
           8021h - valor no vlido (BX:CX = 0)
           8023h - manejador no vlido

Notas:
) Tras la vuelta con xito de esta funcin, el manejador previo para el
  bloque de memoria ya no es vlido y no debera usarse ms.

) Es responsabilidad del cliente el actualizar cualquier descriptor que mapee
  el bloque de memoria con la nueva direccin lineal tras dar un nuevo tamao
  al bloque.

2.31 - Funcin 050Ah - Muestra la Base y el Tamao del Bloque de Memoria:
----------------------------------------------------------------------

Devuelve el tamao y la base de un bloque de memoria que fue previamente
asignado con la funcin Asignar Bloque de Memoria (0501h).

In:
  AX     = 050ah
  SI:DI  = manejador del bloque de memoria

Out:
  si tiene xito:
  BX:CX  = direccin lineal del bloque de memoria
  SI:DI  = tamao del bloque de memoria (bytes)

  si falla:
  AX     = cdigo de error:
           8010h - recurso interno no disponible (pila) (slo XMS)
           8023h - manejador no vlido

Notas:
) Esta funcin no est presente bajo DPMI 0.9.

2.32 - Funcin 0900h - Muestra y Desactiva el Estado de la Interrupcin Virtual:
-----------------------------------------------------------------------------

Desactiva el flag de interrupcin virtual y devuelve su estado previo.

In:
  AX     = 0900h

Out:
  siempre tiene xito:
  AL     = 0 si las interrupciones virtuales fueron previamente desactivadas
  AL     = 1 si las interrupciones virtuales fueron previamente activadas

Notas:
) Esta funcin no cambia AH. Por lo tanto, se puede restaurar el estado previo
  simplemente ejecutando otra INT 31h.

) Un cliente que no necesite saber el estado anterior de la interrupcin puede
  ejecutar la instruccin CLI antes que llamar a esta funcin. La instruccin
  puede ser atrapada por un host DPMI y se debera asumir como muy lenta.

2.33 - Funcin 0901h - Muestra y Habilita el Estado de la Interrupcin Virtual
------------------------------------------------------------------------------

Habilita el flag de la interrupcin virtual y devuelve su estado previo.

In:
  AX     = 0901h

Out:
  siempre tiene xito:
  AL     = 0 si las interrupciones virtuales fueron previamente desactivadas
  AL     = 1 si las interrupciones virtuales fueron previamente activadas

Notas:
) Esta funcin no cambia AH. Por lo tanto, se puede restaurar el estado previo
  simplemente ejecutando otra INT 31h.

) Un cliente que no necesite saber el estado anterior de la interrupcin puede
  ejecutar la instruccin STI en lugar de llamar a esta funcin. La instruccin
  puede ser atrapada por un host DPMI y se debera asumir como muy lenta.

2.34 - Funcin 0902h - Muestra el Estado de la Interrupcin Virtual:
--------------------------------------------------------------------

Devuelve el estado actual del flag de la interrupcin virtual.

In:
  AX     = 0902h

Out:
  siempre tiene xito:
  AL     = 0 si las interrupciones virtuales estn desactivadas
  AL     = 1 si las interrupciones virtuales estn activadas

Notas:
) Se debera usar esta funcin con preferencia a la instruccin PUSHF para
  examinar el flag de la interrupcin, ya que la instruccin PUSHF devuelve el
  flag de la interrupcin fsica en vez del flag de la interrupcin
  virtualizada. En algunos hosts DPMI, el flag de la interrupcin fsica
  siempre estar activado, incluso cuando no se estn pasando al cliente las
  interrupciones de hardware.

2.35 - Funcin FFFFh - Special Fluffy Magical Function:
-------------------------------------------------------

Does special fluffy magical things.

In:
  AX     = ffffh

Out:
  si tiene xito:
  AX     = 1234h (normal fluffy magical number)
  BX     = 56ijh (special fluffy magical number)
  CX     = 89abh (nada realmente especial)
  DX     = cdefh (de nuevo, slo un nmero aburrido)
  EX     = return value from beyond
  FX     = un acrnimo de 'effects'
  GX     = huh?
  HX     = tamao del 'special fluffy magical buffer'

  si falla:
  AX     = cdigo de error:
           8001h - agrrate a la realidad!

Notas:
) El 'special fluffy magical buffer' no debe exceder en tamao a la constante
  'special fluffy magical', que se define en el 'special fluffy magical place'.

) Bueno, quiz exista... Quiz si tratas de llamarla muchas muchas muchas
  muchas muchas muchas muchas muchas veces seguidas funcionar.

------------------------------------------------------------------------------
3 - Miscelnea:
---------------

  Algunas ltimas cosas sobre PMODE, incluyendo algo de informacin tcnica de
bajo nivel por si sientes curiosidad.

3.0 - Actualizaciones:
----------------------

  Aqu tienes los cambios de todas las versiones anteriores de PMODE 3.0.

PMODE 3.0:
) Primera versin de PMODE 3.0.

PMODE 3.01:
) Rutinas de intercambio de modos VCPI/XMS/raw ligeramente optimizadas.

) Arreglado un bug con las funciones de conversin 0300h, 0301h y 0302h de la
  INT 31h que no devolvan los flags correctos en la estructura de registro.

) Arreglado un bug con el software de la INT de las llamadas de
  redireccionamiento que limpiaba el flag de interrupcin.

PMODE 3.02:
) Reducida la necesidad de espacio de pila libre en el enlace de modo VCPI a
  32 bytes.

PMODE 3.03:
) Arreglada la INT 15h del modo real en modo raw, ahora siempre vuelve con el
  flag de acarreo limpio, como debe ser.

PMODE 3.04:
) Arreglado un estpido bug con la INT 31h AX=03??h que necesita que la palabra
  alta de ECX estuviera limpia y que alguien me lo seal.

) Aadido (en realidad slo documentado) el acceso a bajo nivel a las pilas
  internas en modo real y modo protegido de PMODE.

PMODE 3.05:
) Arreglada la funcin 0204h de la INT 31h que no devolva correctamente la
  palabra alta de ECX.

) Arreglada la funcin 0301h de la INT 31h que pona los flags en la pila de
  retorno en modo real. Esto era una estupidez, no estaba ah desde el
  principio sino que apareci cuando arregl el bug de la INT 31h AX=03??h en
  la versin 3.04 (por ello me he estado golpeando la cabeza contra la pared
  unas cuantas veces... lo siento)...

PMODE 3.06:
) Aadido el control sobre la orden de deteccin de DPMI/VCPI.

) Cambiado el mtodo de redirecionamiento de la interrupcin (no influye en tu
  cdigo).

) PMODE ya no devuelve su propio selector de cdigo (realmente no es una
  optimacin).

) Cambiada ligeramente la asignacin de memoria de VCPI.

PMODE 3.07:
) Por favor, que alguien me enve una pistola para que me pueda pegar un tiro.
  Por segunda vez he corregido un bug que introduje en una actualizacin. El
  sistema de memoria de VCPI simplemente no funcionaba en la v3.06. Bien nios,
  qu podemos aprender de esta pequea experiencia? (Adems de que soy
  idiota). Quiz la prxima vez deberamos probar algo antes de distribuirlo...
  (En realidad lo suelo hacer, pero me senta especialmente vago cuando junt
  la v3.06).

3.1 - Glosario:
---------------

Bottom up allocation - Un mtodo de asignacin de memoria extendida que confa
  en los bloques de control especificando el comienzo de la memoria extendida
  libre. Este es el esquema VDISK de asignacin de memoria extendida.

Client - Un programa que usa los servicios DPMI de la INT 2fh y de la INT 31h
  para correr en modo protegido.

CPL, Current Privilege Level - El nivel de privilegio del cdigo que se est
  ejecutando en ese momento.

Descriptor - Una estructura de 8 byte que define un tipo de segmento, su
  direccin base y lmite y el tipo de acceso que se le permite.

DPL, Descriptor Privilege Level - El nivel de privilegio de un descriptor. La
  proteccin de un descriptor se basa en ciertas reglas del CPL y del DPL de un
  descriptor al que el cdigo quiz quiera acceder.

DPMI, DOS Protected Mode Interface - Un interfaz para los programas de DOS en
  modo protegido para gestionar la memoria, las interrupciones, las
  excepciones, el depurado de registros y la emulacin de coprocesador de
  manera que funcione correctamente y que les permita coexistir con otros
  programas y sistemas operativos en modo protegido.

Exception - Una interrupcin que ocurre debido a alguna violacin de las reglas
  de proteccin.

Extended memory - Memoria que se encuentra por debajo del lmite de 1M y slo
  puede ser direccionada en modo protegido.

GDT, Global Descriptor Table - Un tabla de descriptor que puede contener muchos
  tipos de descriptores adems de los descriptores de cdigo y datos normales.
  Esto puede incluir descriptores TSS y descriptores LDT.

Host - Un programa que suministra los servicios de DPMI en modo protegido.

IDT, Interrupt Descriptor Table - Una tabla de descriptor que contiene los
  descriptores de puerta a los manejadores para las 256 interrupciones.

LDT, Local Descriptor Table - Una tabla de descriptor que normalmente contiene
  todos los descriptores de una tarea concreta. Cada tarea en un sistema
  multitarea 386 puede tener su propio LDT mientras que slo hay un GDT para
  todo el sistema.

Linear memory - Espacio de direccin en lugar de RAM fsica real de la ROM.

Page - Un trozo de memoria de 4k. El 80386 puede mapear cualquier trozo de
  memoria fsica a cualquier direccin lineal. Tambin hay algunas reglas de
  proteccin que se pueden aplicar a las pginas, tales como slo-lectura o
  comprobacin del nivel de privilegio al acceder.

Page Directory - Un tipo de tabla de pgina maestra que mapea tablas de pgina
  en vez de pginas.

Page Table - Una tabla de 4k que contiene 1024 entradas para las pginas. Cada
  tabla de pgina mapea 4 megabytes de memoria lineal a memoria fsica.

Physical memory - La memoria fsica real presente en un sistema.

Privilege level - Un valor numrico que representa la libertad del sistema de
  acceso y qu cantidad de proteccin se usa para el cdigo. Este valor vara
  desde 0 (mayor libertad (un dios)) a 3 (menos libertad (un esclavo)).

RPL, Requestor Privilege Level - El nivel de privilegio que el cdigo pide para
  un acceso a un selector especfico. Est contenido en los dos bits bajos
  del selector.

Segment - Un trozo lineal especfico de memoria. En modo real, los segmentos
  estn limitados al primer megabyte de memoria y siempre tienen una longitud
  de 64k. En modo protegido, un segmento puede empezar en cualquier sitio de
  los 4 gigabytes de espacio de direccin del 80386 y puede tener toda esa
  longitud.

Selector - Un ndice en modo protegido para una tabla de descriptor. Los
  selectores se usan en lugar de los segmentos en modo protegido en los
  registros de segmento.

Top down allocation - Un mtodo de gestin de memoria extendida que depende de
  la funcin 88h de la INT 15h de la BIOS. Un programa que necesite asignar
  memoria extendida enganchar la INT 15h y devolver un tamao de memoria
  extendida menor. El programa de esta manera tiene libertad para usar la
  memoria entre el tope previo de memoria extendida y lo que devuelve como el
  tope de memoria extendida sin preocuparse porque otros programas
  sobreescriban su memoria extendida.

TSS, Task State Segment - Una estructura especial de memoria usada en la
  proteccin y el enlace de tarea.

V86 mode - En realidad es modo protegido, funcionando a un nivel de provilegio
  de 3. Los registros de segmento se usan de la misma manera que en modo real,
  con direcciones de segmento en vez de selectores. La ventaja es que se pueden
  activar la paginacin y otras tareas protegidas, lo que incluye otras tareas
  del modo V86. La desventaja es que es ms lento que el modo real.

VCPI, Virtual Control Program Interface - El predecesor de DPMI. VCPI extiende
  el interfaz EMS para permitir que los programas de DOS funcionen en modo
  protegido en presencia de emuladores EMS u otros programas de control de
  80386.

Virtual memory - Memoria extra ms all de la memoria fsica real presente en
  un sistema. No hay realmente ms memoria fsica en el sistema, pero un
  sistema operativo o un host DPMI puede dar esta ilusin intercambiando los
  contenidos de la memoria fsica a un disco y desde l y mapeando esa memoria
  fsica a direcciones lineales diferentes.

XMS, eXtended Memory Specification - Un interfaz de gestin de memoria
  extendida basado en un manejador.

3.2 Diferencias entre modos:
----------------------------

Algunas diferencias entre DPMI, VCPI, XMS y raw en modo protegido:

) DPMI:
    Los descriptores cliente residen en un LDT.
  VCPI/XMS/raw:
    Los descriptores cliente residen en el GDT.

) DPMI:
    El cdigo corre en un CPL 3.
  VCPI/XMS/raw:
    El cdigo corre en un CPL 0. (Mucho ms rpido)

) DPMI/VCPI:
    Las llamadas en modo real son ejecutadas en modo V86.
  XMS/raw:
    Las llamadas en modo real son ejecutadas en modo real. (Mucho ms rpido)

) DPMI/VCPI:
    La paginacin est activada.
  XMS/raw:
    La paginacin est desactivada. (Realmente no es mucho ms rpido, pero qu
    demonios)

) DPMI:
    IRET(D) y POPF(D) puede que no afecten al flag de interrupcin. PUSHF(D)
    puede que no almacene el flag de interrupcin.
  VCPI/XMS/raw:
    IRET(D) y POPF(D) afectan al flag de interrupcin en modo real. PUSHF(D)
    almacena el flag de interrupcin en modo real.

) DPMI:
    Las INTs 1Ch, 23h y 24h del modo real son enviadas primero al modo
    protegido. Esto significa que si se instala un manejador en modo protegido
    para estas interrupciones, este tomar el control.
  VCPI/XMS/raw:
    Los doc's del DPMI no son demasiado claros en el mtodo en que se llama a
    estas interrupciones. Llamadas de retorno dira yo. Pero soy demasiado vago
    para investigarlo. Y francamente, no me importa una mierda. Por eso el
    kernel de VCPI/XMS/raw no soporta esto.

) DPMI:
    Separa las excepciones de otras interrupciones e IRQs bajas. Es decir, una
    excepcin 8 jams ira por error al manejador para la IRQ 0.
  VCPI/XMS/raw:
    Hey, las excepciones son malas, no debera ser lo primero que obtuvieras.
    Reprogramar los controladores de la interrupcin o ejecutar el cdigo
    cliente a un nivel de privilegio inferior no merecen el retraso en mi
    opinin.

) DPMI:
    Tericamente, DPMI puede rechazar una peticin para fijar un lmite de
    segmento de 4G. Todava no he encontrado un DPMI que rechazara esto. Todos
    ellos realizan la proteccin en el nivel de paginacin. Y es necesario un
    lmite elevado para el modo plano y los offset negativos.
  VCPI/XMS/raw:
    No hay proteccin, nunca podra ser rechazado ningn lmite de segmento o
    direccin base.

) DPMI:
    La asignacin de memoria casi siempre es 'page granular', pero no
    necesariamente.
  VCPI:
    La asignacin de memoria es 'page granular' (trozos de 4k).
  XMS:
    La asignacin de memoria es 'kilobyte granular'.
  raw:
    La asignacin de memoria es 'paragraph granular'.

) DPMI/VCPI:
    Las direcciones lineales de memoria baja puede que sean las direcciones
    fsicas reales o puede que no. Las direcciones de memoria extendida casi
    seguro que no lo son.
  XMS/raw:
    Todas las direcciones lineales son direcciones fsicas.

3.3 - Notas:
------------

  Aqu tienes algunos detalles variados y de bajo nivel tcnico acerca de PMODE
y algunos puntos que me gustara resaltar. Algunos de ellos puede que parezcan
muy oscuros, sin que haya una necesidad real de enumerarlos. Pero por el bien
de una documentacin detallada y clara, aqu estn:

) En modo protegido, ESP siempre debe ser el puntero de pila. Esto significa,
  incluso usando un segmento de pila de 16bit, que la palabra alta de ESP DEBE
  ser 0.

) Cuando se llama a la rutina de intercambio en modo raw para cambiar al modo
  protegido, debes suministrar ESP y EIP completas. Incluso cuando los
  segmentos de pila o cdigo a los que se cambia son de 16bit.

) Si la llamada para iniciar el modo protegido fue desde un segmento diferente
  al PMODE_TEXT bajo DPMI y no se puede asignar un descriptor para este
  segmento de cdigo, se produce la finalizacin inmediata. Pero esto no
  debera pasar nunca. Un host DPMI que no puede suministrar ni siquiera un
  descriptor a sus clientes en modo protegido desafa la lgica. Pero por el
  bien de cubrir todos los posibles desajustes, se ha comprobado esta condicin.

) DPMI 1.0/VCPI/XMS/raw volver a cargar todos los registros de segmento para
  los cuales se cambie el descriptor a travs de una funcin de la INT 31h.
  DPMI 0.9 no lo hace. (Realmente s lo hace, aunque empujando y luego
  sacando todos los registros de segmento que usa. Pero no se garantiza que
  vuelva a cargar todos y cada uno de ellos).

) DPMI 1.0/VCPI/XMS/raw pondr a cero todos los registros de segmento liberados
  con la funcin 0001h de la INT 31. DPMI 0.9 puede que lo haga o puede que no.

) No s lo que hace DPMI con respecto a volver a cargar o a liberar un selector
  que se encuentre actualmente cargado en SS, pero el sistema VCPI/XMS/raw no
  volver a cargar ni pondr a cero SS. No deberas modificar tu descriptor de
  pila o de cdigo mientras lo ests usando. Esto podra ser malo, incluso si
  la INT 31h fuera manejada a travs de una puerta de tarea (lo que sera
  lento).

) Recuerda que DPMI 0.9 no devuelve cdigos de error como s hacen
  DPMI 1.0/VCPI/XMS/raw.

) Razones para llamar a la ejecucin en modo real en verdadero modo real antes
  que en modo V86 (XMS/raw):
  ) La llamada al sistema de V86 no se puede usar bajo VCPI con gran xito.
    (S, VCPI ejecuta su modo real en V86. Pero VCPI DEBE tener el control en
    este caso.)
  ) El modo real corre ms rpido que el modo V86.
  ) Las funciones de la INT 15h y de la memoria extendida XMS funcionarn.
  ) Otros programas en modo protegido que ejecutan funciones de DOS en modo
    real funcionarn.
  ) Es ms rpido cambiar entre modo protegido/real que protegido/V86.

) Usa LAR para averiguar el CPL actual para establecer los derechos de acceso
  del descriptor.

) Siempre debes fijar el bit actual cuando estableces los derechos de acceso
  del descriptor.

) Bajo los sistemas VCPI/XMS/raw, el bit AVL de los descriptores se usa para
  mantener la pista de los descriptores libres y usados. El valor que pasas
  para este bit cuando estableces los derechos de acceso del descriptor ser
  ignorado.

) Cuando se intercambian modos usando las rutinas de intercambio de raw,
  asegrate de que hay espacio en ambas pilas (real y protegida). Las
  necesidades especficas de DPMI pueden variar, pero 32 bytes son suficientes
  para VCPI/XMS/raw.

) En modo protegido, recuerda usar IRETD y no IRET. Cuando la documentacin de
  DPMI remite a usar IRET en realidad te est remitiendo a la versin de 32bit
  de la instruccin bajo sistemas de 32bit, que es IRETD.

) Recuerda que la informacin sobre memoria libre slo es informativa. Un TSR
  u otra tarea en un sistema multitarea podra coger algo de memoria entre una
  llamada a la funcin 0500h de la INT 31h y otra a la funcin 0501h de la
  INT 31h, incluso si desactivas las interrupciones.

) No se ha comprobado la vigencia de las variables _pm_?. Por ello no las fijes
  ms all de los lmites razonables. Por ejemplo, no pidas para pilas 20h en
  modo real un tamao de 1000h prrafos. Esto son dos megabytes de espacio
  de pila en modo real. Esto es demasiado, considerando que toda la memoria
  baja disponible en modo real abarca 640k.

) Deberas asignar la memoria en grandes bloques. El espacio de memoria est
  sujeto a la fragmentacin. Aunque puedes evitar ligeramente esta situacin
  bajo VCPI fijando un nmero elevado de tablas de pgina. Esto no aumentar la
  memoria fsica disponible pero aumentar el espacio de direccin disponible
  para colocar esta memoria en trozos lineales.

) He intentado equilibrar la claridad y el cdigo bien diseado con el tamao y
  la velocidad. Es verdad, algunas cosas no son tan absolutamente ptimas como
  podran ser. Pero el cdigo fuente est ah. Muy claro y comentado. Si
  realmente necesitas ese poco ms de velocidad, eres libre de modificarlo
  (esto no te libera de la obligacin de acreditarme por l).

) No puedo controlar lo que hace DPMI. Pero bajo XMS/raw, el cdigo en modo
  protegido corre a la mxima velocidad posible. Es decir, no hay comprobacin
  de privilegio para hacerlo.
  Ninguna excepcin le quitar el control a las instrucciones sensibles. Ni
  siquiera la paginacin, con sus referencias de memoria cada vez que no se
  encuentre una entrada de tabla de pgina en el TBL. Bajo VCPI, todo esto es
  aplicable excepto la paginacin. Lo que realmente no es tan malo.

) Bajo VCPI, la informacin de la memoria libre es validada en la funcin
  0500h al asignar realmente esa memoria y liberndola antes de pasar la
  informacin a tu programa. Esto es as porque bajo algunos sistemas
  multitarea, la funcin de VCPI para obtener la memoria disponible puede
  devolver informacin sobre todo el sistema. Mientras que el sistema
  multitarea puede imponer los lmites de asignacin a la tarea especfica de
  la cual tu cdigo forma parte.

) Bajo VCPI/XMS/raw, la funcin 0500h de la INT 31h devolver slo el primer
  campo del grupo de buffer. Todos los otros campos sern fijados a
  0ffffffffh.

) Bajo VCPI/XMS/raw un descriptor asignado a la funcin 0000h de la INT 31h
  llamado con CX=0 devolver un error 8021h. Los doc's del DPMI no establecen
  esto y no s si DPMI devuelve un error con CX=0.

) Las funciones 0300h, 0301h y 0302h de la INT 31h siempre te informarn de si
  no hay suficiente espacio de pila en modo real. Pero un redireccionamiento de
  INT o IRQ no puede hacerlo. En este caso, El altavoz interno del PC ser
  activado y el ordenador se colgar. Esto es mejor que permitirle desbordar
  datos por debajo suyo con resultados impredecibles. Y oye, no necesito ningn
  apestoso depurador de cdigo atestando mi preciso y bonito extensor. Lo
  que necesito es que me lo diga en caso de que algo de esto ocurra. Si quieres
  depurar cdigo, ve y hazlo t mismo.

) Los doc's del DPMI no establece esto, pero el descriptor de alias que crea
  la funcin 000ah de la INT 31h siempre es un descriptor de datos expandido y
  escribible. No importa qu tipo de descriptor de fuente sea.

) Deberas limitarte a ti mismo para asignar el menor nmero de bloques
  individuales de memoria como sea posible. Bajo XMS, normalmente hay un lmite
  estricto sobre cuntos bloques pueden ser asignados (normalmente 32).

) Los doc's del DPMI establecen que el campo entre EBP y EBX debera ser cero
  sobre una funcin 0300h de la INT 31h, pero es ignorado por las funciones
  0301h y 0302h. Este es un estpido error tipogrfico, el campo ser ignorado
  por la funcin 0300h.

) Bajo XMS sern asignados 15 bytes extra para posibles alineamientos del
  bloque de memoria XMS en un prrafo. Aunque un bloque XMS probablemente ya
  estar alineado en al menos un lmite de prrafo, esto no est definido en
  el XMS estndar. Y esto se hace para mantener la posibilidad de problemas en
  cero.

) Ten en cuenta que las funciones de asignacin de memoria bajo XMS usan
  llamadas en modo real y espacio de pila en modo real definido con
  _pm_rmstacklen y _pm_rmstacks. Si no hay suficiente espacio de pila para la
  llamada al controlador XMS en modo real, se devolver un cdigo de error
  8010h (recurso no disponible).

) Si falla un bloqueo de memoria XMS, que se usa en las funciones de asignacin
  de memoria, se devolver un error 8010h. Un fallo en un bloqueo de memoria no
  se debe a que no haya memoria disponible. Sino ms bien a algn error
  interno de XMS. Pero de todas formas no debera ocurrir jams.

) El sistema raw comprueba tanto el esquema de asignacin de memoria extendida
  de baja a alta de la INT 15h como del VDISK para obtener su rea de memoria
  extendida disponible.

) El sistema raw asigna memoria extendida basndose en su necesidad de arriba
  a abajo. Se engancha la funcin 88h de la INT 15h y se resta la cantidad
  total de memoria asignada usando, la funcin 0501h del kernel, de la cantidad
  de memoria devuelta por el manejador previo de la INT 15h. Esto es as para
  que puedas ejecutar otros programas en modo protegido desde dentro de tus
  programas y tengan as memoria extendida disponible (si dejas algo).

) Un manejador de IRQ en modo protegido o una llamada de retorno en modo real
  deben volver a la misma pila desde la que se les llam.

) Una rutina en modo real llamada con las funciones 0300h, 0301h o 0302h debe
  volver a la misma pila desde la que se la llam.

) No deberas dar nada por sentado acerca del rea de datos de la memoria baja
  en modo protegido que necesita PMODE. Puede ir desde muy pequea a muy
  grande. Y si est presente un host DPMI es impredecible.

) Asegrate de que no accedes, lees o escribes memoria extendida fuera de los
  bloques que has asignado. Incluso si no hay memoria fsica all,
  probablemente obtendrs excepciones bajo DPMI/VCPI.

) Cuando estableces los derechos de acceso del descriptor, recuerda que el
  bit B de los descriptores de pila determina si los PUSHes y los POPs usan
  SP (B=0) o ESP (B=1).

) Si activas las interrupciones en una llamada de retorno, DEBES asumir que DS
  ya no es vlido. Incluso si ests seguro de que no se volver a entrar en tu
  llamada de retorno. Esto se debe a que PMODE usa el mismo selector DS para
  TODAS las llamadas de retorno en modo real.

) El campo reservado entre EBP y EBX en la estructura de registro usado durante
  una llamada de retorno es usado por PMODE para preservar la palabra alta de
  ESP para el modo real.

) Deberas dar por sentado que las funciones de la memoria extendida de la
  INT 31h son lentas. Especialmente bajo VCPI, en donde se tiene que hacer una
  llamada al servidor VCPI por cada 4k de memoria asignada o liberada y dos
  llamadas por cada 4k verificados.

) Bajo PMODE, las llamadas de redireccionamiento de la INT software slo
  traen de vuelta los flags de acarreo, paridad, auxiliar, cero, seal y
  desbordamiento del manejador de interrupcin en modo real.

) Cuando se estn usando las rutinas de intercambio del modo raw, ten presente
  que stas usan algo de espacio de pila tanto en la pila de modo real como en
  la de modo protegido. Nunca fijes la pila de destino en la misma situacin en
  memoria que la de la pila desde la que se est enlazando.

------------------------------------------------------------------------------
3.4 - Apunte final:
-------------------

  Me gusta mucho este ltimo PMODE. Para un extensor, es preciso, slido,
rpido y pequeo. No se limita al cdigo de ensamblador. No necesita el control
al arrancar sino que se puede inicializar en cualquier momento. Se puede
convertir bsicamente en cualquier tipo de extensor. Puede trabajar con
lenguajes de alto nivel. Quiz tambin te guste porque es gratis y se
suministra el cdigo fuente. El interfaz de DPMI asegura su portabilidad y su
larga vida. Disfruta el modo protegido y recuerda los crditos.

                                                L8r...
                                                Tran...

