/********* Listing 5 *************************** MAIN1.CPP *****
*  Tests dynamic hasher. Reads any text file and inserts words 
*  into table. Allows user to insert, remove and retrieve words 
*  from hash table.
****************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stream.hpp>
#include "dynhash.hpp"

struct REC {
    char word[64];              // record key
    int number;                 // key number
};

REC item;
int number;
declare(gdynhash,REC);
gdynhash(REC) HashTable;     // declare dynamic hash table

main( int argc, char* argv[] )
{
    FILE *fp;
    char *p, *q, buf[84];
    int eol, i, n=1;
    int choice, index;
    if (argc != 2)
    {
        cout << "Provide a text file name as argument\n";
        exit(1);
    }
    fp = fopen(argv[1],"r");
    if (!fp)
    {
        cout << "file not found\n";
        exit(1);
    }
    cout << "Put unique words into hash table\n";
    while (fgets(buf, 80, fp))
    {
        for (eol = 0, p = buf; *p;)
        {
            while (*p && !isalpha(*p))
                ++p;
            if (!*p) break;
            for (q = p; isalpha(*q); ++q)
                ;
            if (!*q) ++eol;
            *q = '\0';
            strlwr(p);
            i = strlen(p);
            if (i)
            {            // found a word
                strcpy( item.word, p );
                item.number = i;        // use strlen as 'number'
                index = HashTable.insert( &item );
                int err = HashTable.error();
                if ( err == NO_MEMORY || err == EXPAND_ERROR )
                {
                  cout << "\n\nFile too big, only " << HashTable.size()
                  << " records inserted\n";
                  exit(1);
                }
            }
            if (eol)
                break;
            p = q+1;
        }
    }

    for ( ;; )
    {
      int out=0;                        // for exiting

      cout << "\nEnter choice\n";
      cout << "\t(1) Database size\n";
      cout << "\t(2) Show all keys\n";
      cout << "\t(3) Insert item\n";
      cout << "\t(4) Remove item\n";
      cout << "\t(5) Lookup item\n";
      cout << "\t(6) Quit\n";
      cout << "\n\t?: ";
      cin >> choice;

      if ( choice < 1 && choice > 6 )
        cout << "\nChoice must be between 1 and 6\n";
      else
        switch ( choice )
        {
          case 1 : 
             cout << "\nDatabase size = " <<HashTable.size()<< " records";
                   break;
          case 2 : char *ptr;       // dump all hash table keys
                   for ( i=0; i < HashTable.size(); )
                       if ( (ptr = (char *) HashTable.get_next()) != NULL )
                        cout << "\n" << ++i << ") " << ptr;
                   break;
          case 3 : cout << "\nKey to insert: ";
                   cin >> item.word;
                   cout << "Number for this record: ";
                   cin >> item.number;
                   index = HashTable.insert( &item );
                   if ( index > 0 )
                      cout << "\nItem inserted at index = " << index;
                   else if ( index == NO_MEMORY )
                      cout << "\nCan't insert - OUT OF MEMORY";
                   else if ( index == NOT_INSERTED )
                      cout << "\nItem already in table";
                   break;
          case 4 : cout << "\nKey to remove: ";
                   cin >> item.word;
                   index = HashTable.remove( &item );
                   if ( index >= 0 )
                     cout << "\nItem removed at index = " << index;
                   else
                     cout << "\nItem not in table\n";
                   break;
          case 5 : cout << "\nKey to lookup: ";
                   cin >> item.word;
                   REC *pt = HashTable.lookup( &item );
                   if ( pt )
                   {
                     cout << "\nKey found = " << pt->word;
                     cout << "\nRec number= " << pt->number;
                   }
                   else
                     cout << "\nKey not found in table\n";
                   break;
          case 6 : cout << "\nBye ...\n";
                   out = 1;
                   break;
        }
       if ( out ) break;
     }
}