/************************************************************************/ 
/*                                                                      */ 
/*								 FOSSIL.H								*/ 
/*									  									*/ 
/*					Header file for use with FOSSIL.LIB					*/ 
/*																		*/ 
/************************************************************************/ 

/************************************************************************/ 
/*                                                                      */ 
/*							LOW LEVEL FUNCTIONS							*/ 
/*																		*/ 
/************************************************************************/ 

unsigned int	f_rx(int port);
unsigned int	f_stat(int port);
unsigned int	f_peek(int port);
unsigned int	f_keyrdnowait(void);
unsigned int	f_keyrd(void);
int				f_init(int port, int trigger, int * flag_address);
int				f_txnowait(int port, int character);
int				f_readblk(int port, int count, void * buffer);
int				f_writeblk(int port, int count, void * buffer);
void			f_tx(int port, int character);
void			f_deinit(int port);

/************************************************************************/ 
/*                                                                      */ 
/*							 SUPPORT FUNCTIONS							*/ 
/*																		*/ 
/************************************************************************/ 

unsigned int	f_ctrlcchk(int port, int bitmask);
unsigned int	f_getcurs(void);
int				f_setbaud(int port, int rate_code);
int				f_ttint(void);
void			f_dtr(int port, int state);
void			f_outflush(int port);
void			f_outpurge(int port);
void			f_inpurge(int port);
void			f_flowctrl(int port, int bitmask);
void			f_setcurs(int row, int column);
void			f_wransi(int character);
void			f_watchdog(int port, int state);
void			f_wrbios(int character);
void			f_reboot(int temprature);
void			f_break(int port, int state);
void			f_data(int port, int count, void * buffer);

/************************************************************************/ 
/*                                                                      */ 
/*		  FUNCTIONS DEALING WITH TIMER TICKS, AND EXTERNAL API'S		*/ 
/*																		*/ 
/************************************************************************/ 

unsigned int	f_insertfunc(void (far * func)());
unsigned int	f_removefunc(void (far * func)());
int				f_installapi(int api_byte, void (far * api)());
int				f_removeapi(int api_byte, void (far * api)());

/************************************************************************/ 
/*                                                                      */ 
/*					  STRUCTURE REQUIRED BY f_data()					*/ 
/*																		*/ 
/************************************************************************/ 

struct _fossildata	{
		int			strsiz;		/* size of the structure in bytes		*/
		char		majver;		/* FOSSIL spec driver conforms to		*/
		char		minver;		/* rev level of this specific driver	*/
		char far *	ident;		/* "FAR" pointer to ASCII ID string		*/
		int			ibufr;		/* size of the input buffer (bytes)		*/
		int			ifree;		/* number of bytes left in buffer		*/
		int			obufr;		/* size of the output buffer (bytes)	*/
		int			ofree;		/* number of bytes left in the buffer	*/
		char		swidth;		/* width of screen on this adapter		*/
		char		sheight;	/* height of screen    "     "			*/
		char		baud;		/* ACTUAL baud rate, computer to modem	*/
};

/************************************************************************/ 
/*                                                                      */ 
/*				 DEFINES FOR f_stat() RETURN CODE BIT MAP				*/ 
/*																		*/ 
/************************************************************************/ 

#define		FST_DCD		0x0080		/* Carrier detect					*/
#define		FST_RDA		0x0100		/* Received data available			*/
#define		FST_OVRN	0x0200		/* Overrun condition				*/
#define		FST_THRE	0x2000		/* Room available in output buf		*/
#define		FST_TSRE	0x4000		/* Output buffer empty				*/

/************************************************************************/ 
/*                                                                      */ 
/*					  DEFINES FOR f_ctrlcchk() BITMAP					*/ 
/*																		*/ 
/************************************************************************/ 

#define		F_CTRLCCHK	0x0001		/* Control-C/K checking enable bit	*/
#define		F_XMITCTRL	0x0002		/* Transmitter enable bit			*/

/************************************************************************/ 
/*                                                                      */ 
/*					 DEFINES FOR f_reboot() PARAMETER					*/ 
/*																		*/ 
/************************************************************************/ 

#define		F_COLDBOOT	0x0000		/* Cold boot (memory test done)		*/
#define		F_WARMBOOT	0x0001		/* Warm boot						*/

/************************************************************************/ 
/*                                                                      */ 
/*				   MACROS FOR VARIOUS STATUS INDICATIONS				*/ 
/*																		*/ 
/************************************************************************/ 

#define		f_cd(port)		((f_status(port)&FS_CD)	 ? 1 : 0)
#define		f_rda(port)		((f_status(port)&FS_RDA) ? 1 : 0)
#define		f_ovrn(port)	((f_status(port)&FS_OVRN)? 1 : 0)
#define		f_thre(port)	((f_status(port)&FS_THRE)? 1 : 0)
#define		f_tsre(port)	((f_status(port)&FS_TSRE)? 1 : 0)

