#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <h_graph2.h>
#include <mouse.h>

int m_init(buttons)
int *buttons;
{
   union REGS reg;
   reg.x.ax=0;
   int86(0x33,&reg,&reg);
   *buttons=reg.x.bx;
   return(reg.x.ax);
}

void m_cursor(on)
int on;
{
   union REGS reg;
   reg.x.ax=((on)?1:2);
   int86(0x33,&reg,&reg);
}

int m_status(hpos,vpos)
int *hpos,*vpos;
{
   union REGS regs;
   regs.x.ax=3 ;
   int86(0x33,&regs,&regs);
   *hpos=regs.x.cx;
   *vpos=regs.x.dx;
   return regs.x.bx;
}

void  m_move(hpos,vpos)
int   hpos,vpos;
{
   union REGS regs;
   regs.x.ax=4;
   regs.x.cx=hpos;
   regs.x.dx=vpos;
   int86(0x33,&regs,&regs);
}

void  m_limit(hmin,vmin,hmax,vmax)
int   hmin,hmax,vmin,vmax;
{
   union REGS regs;
   regs.x.ax=7;
   regs.x.cx=hmin;
   regs.x.dx=hmax;
   int86(0x33,&regs,&regs);
   regs.x.ax=8;
   regs.x.cx=vmin;
   regs.x.dx=vmax;
   int86(0x33,&regs,&regs);
}

void m_shape(seg,offset)
int seg,*offset;
{
   union REGS regs;
   struct SREGS sregs;
   regs.x.ax=9;
   regs.x.bx=*(offset+32);     /* horiz HOTSPOT in cursor mask */
   regs.x.cx=*(offset+33);     /* vert HOTSPOT in cursor mask */
   regs.x.dx=offset;           /* first 16 ints are the AND mask */
   sregs.es=seg;               /* next 16 ints are the XOR mask */
   int86x(0x33,&regs,&regs,&sregs);
}


int h_isherc()
{
   union REGS reg;
   char save_byte;
   extern char far *h_p;
   reg.h.ah=15;
   int86(16,&reg,&reg);
   if(reg.h.al!=7) return(-1);
   save_byte=*(h_p+65535);
   h_p=H_MEMLOC;
   *(h_p+65535)=170;
   if(*(h_p+65535)!=170) return(1);
   *(h_p+65535)=85;
   if(*(h_p+65535)!=85) return(1);
   *(h_p+65535)=save_byte;
   return(0);
}

int h_init(mode)
int mode;
{
   extern int h_vpage,h_apage,h_xpos,h_ypos;
   extern int h_pmode,h_vmode,h_color,h_start;
   extern int h_xmax,h_xmin,h_ymax,h_ymin;
   extern char far *h_p;
   static char text[]={97,80,82,15,25,6,25,25,2,13,11,12,0,0,0,0};
   static char graph[]={53,45,46,7,91,2,87,87,2,3,0,0,0,0,0,0};
   char *ptr;
   unsigned i;
   union REGS reg;
   outp(MODEPORT,((h_vmode==99)?2:0));
   ptr=((mode==99)?graph:text);
   reg.h.ah=0;
   reg.h.al=((mode==99)?6:7);
   int86(0x10,&reg,&reg);
   outp(MODEPORT,((mode==99)?2:0));
   for(i=0;i<16;i++)
   {
      outp(ADDRPORT,i);
      outp(DATAPORT,*(ptr+i));
   }
   h_vpage=h_apage=h_xmin=h_ymin=h_ypos=h_xpos=h_pmode=h_start=0;
   h_vmode=((mode==99)?99:7);
   h_xmax=719;
   h_ymax=347;
   if(mode==99)
   {
      h_mempse(h_p,0,65535);
   }
   h_color=1;
   outp(MODEPORT,((mode==99)?10:8));
   return(h_vmode);
}


int h_setvpage(page)
int page;
{
   extern int h_vpage;
   extern int h_vmode;
   int old_page;
   if(h_vmode==99)
   {
      outp(MODEPORT,10+((page==1)?128:0));
   }
   old_page=h_vpage;
   h_vpage=page;
   return(old_page);
}


void h_onoff(on)
int on;
{
   extern int h_vmode;
   extern int h_vpage;
   outp(MODEPORT,((on)?8:0)+((h_vpage==1)?128:0)+((h_vmode==99)?2:0));
}

void h_drawc(letter,alf_ptr)
char letter;
char *alf_ptr;
{
   extern int h_xpos;
   extern int h_ypos;
   extern int h_xmin;
   extern int h_ymin;
   extern int h_xmax;
   extern int h_ymax;
   extern int h_pmode;
   extern int h_color;
   extern char far *h_p;
   int delta_x,delta_y,height,width,start,stop;
   int i,offset,byte_loc,x1,y1,start_loc,stop_loc,edge_loc;
   char andmask1,andmask2,this_byte,last_bit;
   delta_y=(int)(*alf_ptr);
   delta_x=(int)(*(alf_ptr+1));
   if(delta_y & 128) delta_y=(delta_y & ~128)*-1;
   if(delta_x & 128) delta_x=(delta_x & ~128)*-1;
   height=(int)*(alf_ptr+2);
   width=(int)*(alf_ptr+3);
   start=(int)*(alf_ptr+4);
   stop=(int)*(alf_ptr+5);
   if(h_xpos+width<h_xmin || h_xpos>=h_xmax || h_ypos+height<h_ymin || h_ypos>h_ymax)
   {
      h_xpos+=(int)delta_x;
      h_ypos+=(int)delta_y;
      return;
   }
   else
   {
      offset=h_xpos & 7;
      andmask1=(char)(255<<(8-offset));
      andmask2=255>>(offset+((width==8)?0:1));
      if(h_xpos>=h_xmin && h_xpos+width<=h_xmax);
      else
      {
         if(h_xpos<=h_xmax-width)
         {
            start_loc=((h_xpos+16)>>3)-2;
            edge_loc=h_xmin>>3;
            if(start_loc==edge_loc)
            {
               andmask1|=(char)(255<<(8-(h_xmin & 7)));
            }
            else
            {
               andmask1=255;
               andmask2|=(char)(255<<(8-(h_xmin & 7)));
            }
         }
         else
         {
            stop_loc=(h_xpos+8)>>3;
            edge_loc=h_xmax>>3;
            if(stop_loc==edge_loc)
            {
               andmask2|=255>>(h_xmax & 7);
            }
            else
            {
               andmask2=255;
               andmask1|=255>>(h_xmax & 7);
            }
         }
      }
   }
   h_p=H_MEMLOC;
   x1=h_xpos;
   switch(h_pmode)
   {
      case H_PSET:
         for(i=0;i<height;i++)
         {
            this_byte=*(alf_ptr+6+((int)(letter)*14)+i);
            last_bit=0;
            y1=h_ypos+i;
            if(y1>=h_ymin && y1<h_ymax)
            {
               byte_loc=H_FORMULA;
               *(h_p+byte_loc)=(*(h_p+byte_loc) & andmask1) | (char)((this_byte>>offset));
               if(width==9)
               {
                  if(letter>start && letter<stop)
                  {
                     last_bit=this_byte & 1;
                  }
                  *(h_p+ ++byte_loc)=(*(h_p+byte_loc) & andmask2) | ((char)(this_byte<<(8-offset))) | ((char)(last_bit<<(7-offset)));
               }
               else
               {
                  *(h_p+ ++byte_loc)=(*(h_p+byte_loc) & andmask2) | ((char)(this_byte<<(8-offset)));
               }
            }
         }
         break;
      case H_OR:
         for(i=0;i<height;i++)
         {
            this_byte=*(alf_ptr+6+((int)(letter)*14)+i);
            last_bit=0;
            y1=h_ypos+i;
            if(y1>=h_ymin && y1<h_ymax)
            {
               byte_loc=H_FORMULA;
               *(h_p+byte_loc)=*(h_p+byte_loc) | (char)((this_byte>>offset));
               if(width==9)
               {
                  if(letter>start && letter<stop)
                  {
                     last_bit=this_byte & 1;
                  }
                  *(h_p+ ++byte_loc)=*(h_p+byte_loc) | ((char)(this_byte<<(8-offset))) | ((char)(last_bit<<(7-offset)));
               }
               else
               {
                  *(h_p+ ++byte_loc)=*(h_p+byte_loc) | ((char)(this_byte<<(8-offset)));
               }
            }
         }
         break;
      case H_XOR:
         for(i=0;i<height;i++)
         {
            this_byte=*(alf_ptr+6+((int)(letter)*14)+i);
            last_bit=0;
            y1=h_ypos+i;
            if(y1>=h_ymin && y1<h_ymax)
            {
               byte_loc=H_FORMULA;
               *(h_p+byte_loc)=*(h_p+byte_loc) ^ (char)((this_byte>>offset));
               if(width==9)
               {
                  if(letter>start && letter<stop)
                  {
                     last_bit=this_byte & 1;
                  }
                  *(h_p+ ++byte_loc)=*(h_p+byte_loc) ^ ((char)(this_byte<<(8-offset))) | ((char)(last_bit<<(7-offset)));
               }
               else
               {
                  *(h_p+ ++byte_loc)=*(h_p+byte_loc) ^ ((char)(this_byte<<(8-offset)));
               }
            }
         }
         break;
   }
   h_xpos+=(int)delta_x;
   h_ypos+=(int)delta_y;
}

int h_loadfont(fname,alphaptr)
char *fname;
char *alphaptr;
{
   FILE *fptr;
   char *alpha;
   fptr=fopen(fname,"rb");
   if(fptr==0) return(-1);
   fread(alphaptr,1,3590,fptr);
   fclose(fptr);
   return(0);
}

void h_boxfill(x2,y2,tile)
int x2,y2;
char *tile;
{
   extern int h_xmin,h_xmax,h_ymin,h_ymax,h_pmode,h_xpos,h_ypos;
   extern char far *h_p;
   int i,x1,y1,byte_loc,whole_bytes;
   char save_byte,andmask1,andmask2,temp_byte;
   h_p=H_MEMLOC;
   if(h_xpos>h_xmax || h_ypos>h_ymax || x2<h_xmin || y2<h_ymin) return;
   x1=((h_xpos>h_xmin)?h_xpos:h_xmin);
   x2=((x2<h_xmax)?x2++:h_xmax);
   y1=((h_ypos>h_ymin)?h_ypos:h_ymin);
   y2=((y2<h_ymax)?y2:h_ymax);
   andmask1=(char)(255<<(8-(x1 & 7)));
   andmask2=(char)(255>>((x2 & 7)+1));
   whole_bytes=((x2>>3)-(x1>>3))-1;
   switch(h_pmode)
   {
      case H_PSET:
         for(;y1<=y2;y1++)
         {
            save_byte=*(tile+(y1 & 7));
            byte_loc=H_FORMULA;
            if(whole_bytes>=0)
            {
               *(h_p+byte_loc)=(*(h_p+byte_loc) & andmask1) | (save_byte & (~andmask1));
               if(whole_bytes)
               {
                  h_mempse((h_p+byte_loc+1),save_byte,whole_bytes);
                  byte_loc+=whole_bytes;
               }
               *(h_p+ ++byte_loc)=(*(h_p+byte_loc) & andmask2) | (save_byte & (~andmask2));
            }
            else
            {
               *(h_p+byte_loc)=(*(h_p+byte_loc) & (andmask1 ^ andmask2)) | (save_byte & ~andmask1 & ~andmask2);
            }
         }
         break;
      case H_OR:
         for(;y1<=y2;y1++)
         {
            save_byte=*(tile+(y1 & 7));
            byte_loc=H_FORMULA;
            if(whole_bytes>=0)
            {
               *(h_p+byte_loc)|=save_byte & (~andmask1);
               if(whole_bytes)
               {
                  h_memor(h_p+byte_loc+1,save_byte,whole_bytes);
                  byte_loc+=whole_bytes;
               }
               *(h_p+ ++byte_loc)|=save_byte & (~andmask2);
            }
            else
            {
               *(h_p+byte_loc)|=save_byte & ~andmask1 & ~andmask2;
            }
         }
         break;
      case H_AND:
         for(;y1<=y2;y1++)
         {
            save_byte=*(tile+(y1 & 7));
            byte_loc=H_FORMULA;
            if(whole_bytes>=0)
            {
               temp_byte=andmask1 | (save_byte & (~andmask1));
               *(h_p+byte_loc)&=temp_byte;
               if(whole_bytes)
               {
                  h_memand(h_p+byte_loc+1,save_byte,whole_bytes);
                  byte_loc+=whole_bytes;
               }
               temp_byte=andmask2 | (save_byte & (~andmask2));
               *(h_p+ ++byte_loc)&=temp_byte;
            }
            else
            {
               *(h_p+byte_loc)&=save_byte & ~andmask1 & ~andmask2;
            }
         }
         break;
      case H_XOR:
         for(;y1<=y2;y1++)
         {
            save_byte=*(tile+(y1 & 7));
            byte_loc=H_FORMULA;
            if(whole_bytes>=0)
            {
               *(h_p+byte_loc)^=save_byte & (~andmask1);
               if(whole_bytes)
               {
                  h_memxor(h_p+byte_loc+1,save_byte,whole_bytes);
                  byte_loc+=whole_bytes;
               }
               *(h_p+ ++byte_loc)^=save_byte & (~andmask2);
            }
            else
            {
               *(h_p+byte_loc)^=save_byte & ~andmask1 & ~andmask2;
            }
         }
         break;
   }
}

int h_moveto(x1,y1)
int x1,y1;
{
   extern int h_xmin,h_xmax,h_ymin,h_ymax,h_xpos,h_ypos;
   h_xpos=x1;
   h_ypos=y1;
   if(x1<=h_xmax && x1>=h_xmin && y1>=h_ymin && y1<=h_ymax) return 0;
   else return 1;
}

void h_box(x2,y2,tile)
int x2,y2;
char *tile;
{
   int x1,y1;
   extern int h_xpos,h_ypos;
   x1=h_xpos;
   y1=h_ypos;
   h_moveto(x1,y1);
   h_boxfill(x2,y1,tile);
   h_moveto(x2,y1);
   h_boxfill(x2,y2,tile);
   h_moveto(x1,y2);
   h_boxfill(x2,y2,tile);
   h_moveto(x1,y1);
   h_boxfill(x1,y2,tile);
}

int h_setpmode(newpmode)
int newpmode;
{
   int savemode;
   extern int h_pmode;
   savemode=h_pmode;
   h_pmode=newpmode;
   return savemode;
}

void h_clrw(tile)
char *tile;
{
   int savex,savey,savepmode;
   extern int h_xpos,h_ypos,h_pmode;
   savepmode=h_pmode;
   savex=h_xpos;
   savey=h_ypos;
   h_moveto(0,0);
   h_setpmode(H_PSET);
   h_boxfill(719,347,tile);
   h_setpmode(savepmode);
   h_moveto(savex,savey);
}

void h_explode(tile)
char *tile;
{
   double i;
   int halfx,halfy,totalx,totaly;
   extern int h_xmin,h_xmax,h_ymin,h_ymax;
   halfx=h_xmin+((h_xmax-h_xmin)>>1);
   halfy=h_ymin+((h_ymax-h_ymin)>>1);
   totalx=h_xmax-h_xmin;
   totaly=h_ymax-h_ymin;
   for(i=.01;i<1.01;i+=.025)
   {
       h_moveto((int)(halfx-(totalx*i)/2),(int)(halfy-(totaly*i)/2));
       h_boxfill((int)(halfx+(totalx*i)/2),(int)(halfy+(totaly*i)/2),tile);
   }
   h_clrw(tile);
}

void h_draws(string,alphabet)
char *string;
char *alphabet;
{
   int length,i;
   length=strlen(string);
   for(i=0;i<length;i++)
   {
      h_drawc(*(string+i),alphabet);
   }
}

void h_patterns()
{
   extern char lgrey[],dgrey[],fore[],back[],nlines[],nstripes[],nrhatch[];
   extern char nlhatch[],wlines[],wstripes[],wrhatch[],wlhatch[];
   h_boxfill(179,115,fore);
   h_moveto(180,0);
   h_boxfill(359,115,lgrey);
   h_moveto(360,0);
   h_boxfill(539,115,nlines);
   h_moveto(540,0);
   h_boxfill(719,115,nstripes);
   h_moveto(0,116);
   h_boxfill(179,231,nrhatch);
   h_moveto(180,116);
   h_boxfill(359,231,nlhatch);
   h_moveto(360,116);
   h_boxfill(539,231,wlines);
   h_moveto(540,116);
   h_boxfill(719,231,wstripes);
   h_moveto(0,232);
   h_boxfill(179,347,wrhatch);
   h_moveto(180,232);
   h_boxfill(359,347,wlhatch);
   h_moveto(360,232);
   h_boxfill(539,347,dgrey);
   h_moveto(540,232);
   h_boxfill(719,347,wrhatch);
   h_setpmode(H_OR);
   h_boxfill(719,347,wlhatch);
   h_setpmode(H_PSET);
}

