#ifndef CVBD2_HDR

#define CVBD2_HDR


/* Data types */
typedef unsigned char          Byte;            /* For internal use. */
typedef enum { NO, YES }       Boolean;         /* For BOOLEAN variables. */
typedef enum { cbBIN, cbOCT,                    /* Conversion bases. */
               cbDEC, cbHEX }  ConvBase;

/* Command line processing yelds one of these values */
typedef enum  { ceOK,                   /* No error */
                ceUNKNOWN_FLAG,         /* Unknown flag specified */
                ceWIDTH_SPEC_ERROR,     /* Invalid width specification */
                ceSHOW_HELP,            /* Help request (via /! or /?) */
                ceSEPAR_SPEC_ERROR,     /* Invalid separator specification */
                ceNO_FILES_SPECIFIED,   /* No files to dumb specified */
                ceHEX_ERROR,            /* Unexpected character after /H */
                ceLEFTJUST_ERROR,       /* Unexpected character after /L */
                ceLEADING0_ERROR,       /* Unexpected character after /0 */
                ceECHO_OPTIONS_ERROR,   /* Unexpected character after /E */
                ceSHOW_FNAMES_ERROR,    /* Unexpected character after /F */
                cePAUSE_ERROR           /* Unexpected character after /P */
              } CmdLnEval;

/* After command-line processing, options are stored in a variable */
/* of the following type. Put in a variable so that it can be shared */
/* with other functions that may use or modify any options. */
typedef struct {
        ConvBase cvBase;           /* Conversion base */
        Byte     bySeparator;      /* Separation character ('\0' for none) */
        Boolean  bLeading0;        /* Put leading 0s? */
        Boolean  bLeftJust;        /* Left justify? */
        Boolean  bLowerHex;        /* Lower hex? */
        Boolean  bCHex;            /* C/C++ style hex? */
        Boolean  bUseAutoWidth;    /* Use default width of each base? (overrides bWidth if YES) */
        Boolean  bShowFNames;      /* Show file names? */
        Boolean  bEchoOptions;     /* Show user options? */
        Boolean  bPause;           /* Pause before every conversion? */
        int      iWidth;           /* Values width (0 for no width formatting) */
        int      iColumns;         /* Number of columns (0 for not columnar format )*/
} OPTIONS;

/* Program defaults */
#define  defUseAutoWidth     YES     /* Use automatic formatting width for each base */
#define  defBase             cbHEX   /* Default conversion base is HEX */
#define  defColumns          10      /* No columns */
#define  defLeftJust         NO      /* Right justification */
#define  defLeading0         YES     /* Put leading 0 */
#define  defLowerHex         NO      /* Uppercase hex */
#define  defCHex             YES     /* C/C++ hex style (0xhhhh) */
#define  defSeparator        ','     /* Comma is default separator*/
#define  defShowFNames       NO      /* Don't show file names */
#define  defEchoOptions      NO      /* Don't echo user options before processing */
#define  defPause            NO      /* No pause before every conversion */
/* Various definitions */
#define ABORTED     255           /* Program return value when aborted */
#define IOBUFSIZE  4096           /* I/O buffering size */
/* Various macros */
#define BOOL_STR(b) ((b) ? "YES" : "NO")

/* Function prototypes */
void ProcessCommandLine(int argc,char **argv,OPTIONS *options);
void PerformConversion(FILE *fp,OPTIONS o);

#endif