#include <stdio.h>
#include "cvbd.h"

/* ======================================================================= */
/* Returns the name (as alphanumeric) of base */
char *ConvBaseStr(ConvBase base)
{
     switch(base)
     {
          case cbBIN: return("BINARY");
          case cbOCT: return("OCTAL");
          case cbDEC: return("DECIMAL");
          case cbHEX: return("HEXADECIMAL");
          default : return("UNKNOWN");
     }
}
/* ======================================================================= */
/* Returns the default display width for conversion base */
int defWidth(ConvBase base)
{
     if (base == cbBIN)
        return(8);                 /* 8 characters for BINARY */
     else if (base == cbOCT)
          return(3);               /* 3 characters for OCTAL */
     else if (base == cbDEC)
          return(3);               /* 3 characters for DECIMAL */
     else if (base == cbHEX)
          return(2);               /* 2 characters for HEXADECIMAL */
     else return(3);               /* 3 characters for unknown base */
}
/* ======================================================================= */
/* Reverses the string pointed by l */
char *ce_strrev(char *l)
{
     char *r = l,         /* Will be made to point at the end of the string */
	     *orig = l,      /* To store the beginning of the string */
		tmp;            /* For swapping */

     while (*(r+1))       /* r will point at the last character */
           r++;

     /* Swap every pair of leftmost-rightmost characters */
     while (l < r) {
           tmp = *l;
           *l++ = *r;
           *r-- = tmp;
     }
     return(orig);
}
/* ======================================================================= */
/* Converts integer n into a string sequence and stores it into s */
char *ce_itoa(int n,char *s)
{
     int  sign;
     char *p = s;

     /* Negative? Save sign and make it positive (so that do..while works) */
     if (n < 0) {
        sign = -1;
        n = -n;
     }
     else
         sign = +1;

     /* Here happens the actual conversion (note: result is reversed) */
     do
	 	*s++ = (n % 10) +'0';       
     while (n /= 10);

     /* If it was negative the add a minus sign */
     if (sign == -1)
        *s++ = '-';
     /* Add NULL character to end the string */
     *s = '\0';
     /* Return the string (must be reversed) */
     return(ce_strrev(p));
}
/* ======================================================================= */
/* Returns file size of stream */
long filesize(FILE *stream)
{
   long curpos, length;

   curpos = ftell(stream);
   fseek(stream, 0, SEEK_END);
   length = ftell(stream);
   fseek(stream, curpos, SEEK_SET);
   return length;
}
/* ======================================================================= */
