/*
    Example 1

    This example shows the FXVM Manager's ability to avoid memory
    corruption.

    WARNING: If you are running this example from within the Borland IDE
    your computer _might_ crash. (the IDE does strange stuff with intr's)

*/

#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>
#include <dos.h>

#include "..\source.c\_fxapi.h"

#define BUFSIZE 1024L*10

/* prototype for exit function */

void close_down( void );

/*
  The close_down function will be called just before any exit
  statement, it works just like the atexit() function, except
  that this #pragma gets linked differently (the actual structure
  of the linked code will change) compared to the atexit() function.
  Also note that we can give priorities to the exit (or startup)
  functions ranging from 64 to 255.
*/

#pragma exit close_down 64

//[ Code ]

int main( void )
{
    fxvmm_buffertype  *vmm_buffer = NULL ;
    void far          *dos_buffer = NULL ;
    unsigned long      dos_size   = 0LU  ;
    unsigned long      vmm_size   = 0LU  ;

    if( !_fxvmm_open_api() )
     {
       fprintf( stderr , "\n\rFatal: Failed to initialize FXVM Manager - aborting");
       exit( -1 );
     }

    fprintf( stderr , FXVMM_BANNER , _fxvmm_vermajor() , _fxvmm_verminor() );

    /* setup memory allocation strategy */

    _fxvmm_set_strategy( fxvmm_strat_xms_handle , FXVMM_PRIORITY1 );
    _fxvmm_set_strategy( fxvmm_strat_ems_handle , FXVMM_PRIORITY2 );
    _fxvmm_set_strategy( fxvmm_strat_vrt_handle , FXVMM_PRIORITY3 );
    _fxvmm_set_strategy( fxvmm_strat_dos_handle , FXVMM_PRIORITY4 );

    /*
      Now allocate all of the available DOS memory.
      (we save 1024 bytes, just as an overhead, it's never a good idea
      to allocate _all_ of the conventional memory (you could try that,
      and then try opening a file, it'll fail, because lots of various
      C functions require some memory, without even telling you)
    */

    if( ( dos_buffer = farmalloc( ( dos_size = (farcoreleft() - 1024L) ) ) ) == NULL )
      {
         /* We should _NEVER_ get here - figure out yourself why ... */

         fprintf( stderr,"\n\rCouldn't allocate a DOS buffer !");
         exit( -2 );
      }

    /*
       The FXVMM memory pool will be half the DOS memory size
    */

    vmm_size = dos_size / 2;

    /*
        All DOS memory is gone now, so we make use of the FXVMM API to
        allocate a new buffer of BUFSIZE size.
    */

    fprintf( stderr ,"\n\r\n\rAllocated %lu bytes of conventional memory, now allocating" , dos_size );
    fprintf( stderr ,"\n\r%lu bytes of memory thru the FXVMM API ..." , vmm_size );

    if( ( vmm_buffer = _fxvmm_alloc( (vmm_size) ) ) == NULL )
          fprintf( stderr, "\n\rWarning: Failed to allocate a block of %lu bytes !" , vmm_size );

    /*
       Fill the DOS memory with some stuff from memory, just to let
       you see that there's actually something in the buffer.
       (we just copy the EGA/VGA data area, if you would save it to
       disk you would be able to see your EGA/VGA OEM string, and
       the word 'IBM' somewhere in there.
    */

    _fmemcpy( dos_buffer , MK_FP(0xC000U,0x0000U) , (size_t)dos_size );

    /*
       Here we go !

       We are going to transfer the conventional memory to the FXVMM
       memory pool, without checking if it would actually fit !, in
       fact the FXVMM memory pool is only half the size of the DOS memory,
       so we would be overwriting something somewhere, wich would give
       disastarous results if we would be dealing with standard
       (conventional) memory.
       Since the FXVMM API checks all memory writes and reads, it will not
       corrupt the system, and we can safely do this without worrying about
       a crash !
     */

     fprintf( stderr ,"\n\rHit any key to crash the system - NOT ;)");

     getch();

     _fxvmm_abswrite( vmm_buffer , 0U , dos_buffer , dos_size );

     /* Free the FXVMM memory pool */

    _fxvmm_free( vmm_buffer );

     /* Free the DOS memory */

    farfree( dos_buffer );

 return( 0 );

}

void close_down( void )
{
    if( !_fxvmm_close_api() )
       fprintf( stderr , "\n\r*Warning* - Memory on this system has been corrupted !");
    else
       fprintf( stderr , "\n\rFXVM Manager closed down properly\n\r");
}
