INCLUDE CLIB_16.INC

;strcmp() -- Compare strings
;int __far strcmp(const char __far * const, char __far * const);
; RETURNS:
;   0	if str1 == str2 (identical)
;   1	otherwise
_TEXT SEGMENT
strcmp PROC FAR16 C USES es ds si di, p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE

	    lds si,[p_str1]	    ;SI = source
	    les di,[p_str2]	    ;DI = destination

	    mov ax, es	    ; if pointers are equal, then done
	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit

@@cont:
@@loop:     lods BYTE PTR ds:[si]   ;Load char 1
	    mov ah, ds:[di]	    ;Load char 2
            inc di
            cmp al,ah               ;Not equal?
	    je @F
	    jl @@less
	    ; more
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@:
            test al,al              ;Loop while not zero
	    jnz @@loop
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp ENDP
_TEXT ENDS
END
