INCLUDE clibc_16.inc
; strlen() -- Get length of string
; size_t __near strlen(const char __near * const);
; GIVEN:
;   p_str	near pointer relative to ss
; RETURNS: (int)
;   #		length of p_strg

_TEXT SEGMENT
strlen PROC NEAR16 C PUBLIC USES di es, p_str:NEAR PTR BYTE
	    mov ax, ss
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen ENDP

; __fastcall
; GIVEN:
;   BX		p_str
; RETURNS:
;   AX		length
; size_t __fastcall __near strlen(const char __near * const);
@strlen PROC NEAR16 USES cx es di
	    mov di, bx	    ; es:di = string pointer
	    mov ax, ss
	    mov es, ax

	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx
	    mov ax, cx
	    ret
@strlen ENDP
_TEXT ENDS
END
