INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_iscntrl:FN_CALL PTR
p_fn_fc_iscntrl P_FN_CALL @iscntrl
_DATA ENDS

 ENDIF
ENDIF

;iscntrl() - Control Character( 00h-1Fh, 7Fh)
;int fn_call iscntrl(const int);

;RETURNS:
;   0	    is NOT a control character
;   1	    is	   a control character

CLIBC_16_CS SEGMENT
iscntrl PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 7Fh
    je @@yes
    cmp bl, 1Fh
    ja @@done
@@yes:
    inc ax
@@done:
    ret
iscntrl ENDP

; __fastcall
;   AX		num
;int __fastcall fn_call iscntrl(const int);
@iscntrl PROC FN_CALL USES bx
    mov bl, al
    xor ax, ax
    cmp bl, 7Fh
    je @@yes
    cmp bl, 1Fh
    ja @@exit
@@yes:
    inc ax
@@exit:
    ret
@iscntrl ENDP

CLIBC_16_CS ENDS
END
