/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** cmplx.h      Complex numbers	                         	         **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#ifndef _CMPLX_NUM
#define _CMPLX_NUM

#include <math.h>


typedef struct FCOMPLEX {
    float           r,
                    i;
} fcomplex;
typedef struct DCOMPLEX {
    double          r,
                    i;
} dcomplex;
typedef struct FPOLAIRE {
    float           rm,
                    th;
} fpolaire;
typedef struct DPOLAIRE {
    double          rm,
                    th;
} dpolaire;

      


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Prototypes des fonctions
----------------------------------------------------------------------
--------------------------------------------------------------------*/
/*
 *   complex.c
 */
fcomplex        Cadd(fcomplex, fcomplex);
fcomplex        Csub(fcomplex, fcomplex);
fcomplex        Cnegat(fcomplex);
fcomplex        Cmul(fcomplex, fcomplex);
fcomplex        Complex(float, float);
fcomplex        Conjg(fcomplex);
fcomplex        Cdiv(fcomplex, fcomplex);
float           Cabs(fcomplex);
fcomplex        Csqrt(fcomplex);
fcomplex        RCmul(float, fcomplex);
fcomplex        RCdiv(fcomplex, float);
fcomplex        Cinv(fcomplex);
dcomplex        dCadd(dcomplex, dcomplex);
dcomplex        dCsub(dcomplex, dcomplex);
dcomplex        dCnegat(dcomplex);
dcomplex        dCmul(dcomplex, dcomplex);
dcomplex        dComplex(double, double);
dcomplex        dConjg(dcomplex);
dcomplex        dCdiv(dcomplex, dcomplex);
double          dCabs(dcomplex);
dcomplex        xdCsqrt(dcomplex);
dcomplex        dRCmul(double, dcomplex);
dcomplex        dRCdiv(dcomplex, double);
dcomplex        xdCinv(dcomplex);
fpolaire        Conv_ctp(fcomplex);
fcomplex        Conv_ptc(fpolaire);
dcomplex        dConv_ptc(dpolaire);
dpolaire        dConv_ctp(dcomplex);
fcomplex        Clog_p(fpolaire);
fcomplex	Clog_c(fcomplex);
fpolaire	Plog_c(fpolaire);
fcomplex        Csin_c(fcomplex);
fcomplex        Ccos_c(fcomplex);
fpolaire        Pexp_c(fcomplex);
fcomplex        Cexp_c(fcomplex);
fpolaire	Pexp_p(fpolaire);
dcomplex        dClog_p(dpolaire);
dcomplex	dClog_c(dcomplex);
dpolaire	dPlog_c(dpolaire);
dcomplex        dCsin_c(dcomplex);
dcomplex        dCcos_c(dcomplex);
dpolaire        dPexp_c(dcomplex);
dcomplex        dCexp_c(dcomplex);
dpolaire	dPexp_p(dpolaire);
fpolaire        Polaire(float, float);
dpolaire	dPolaire(double, double);
fpolaire	Padd(fpolaire, fpolaire);
fpolaire	Psub(fpolaire, fpolaire);
fpolaire	Pmul(fpolaire, fpolaire);
fpolaire	Pdiv(fpolaire, fpolaire);
fpolaire	Pconjg(fpolaire);
fpolaire	Psqrt(fpolaire);
fpolaire	Ppuis(fpolaire, float);
fcomplex	Cpuis(fcomplex, float);
fpolaire	RPmul(float, fpolaire);
fpolaire	RPdiv(fpolaire, float);
fpolaire	Pinv(fpolaire);
dpolaire	dPadd(dpolaire, dpolaire);
dpolaire	dPsub(dpolaire, dpolaire);
dpolaire	dPmul(dpolaire, dpolaire);
dpolaire	dPdiv(dpolaire, dpolaire);
dpolaire	dPconjg(dpolaire);
dpolaire	dPsqrt(dpolaire);
dpolaire	dPpuis(dpolaire, double);
dcomplex	dCpuis(dcomplex, double);
dpolaire	dRPmul(double, dpolaire);
dpolaire	dRPdiv(dpolaire, double);
dpolaire	dPinv(dpolaire);
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/



#endif
