/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define FRAMES 8
#define SPRITES 50
#define ITERATIONS 800
#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

/* Demonstrates sprite_build_from_buff() */

int main(void)
{
 image *pcx_pic;
 buffer_rec *offscreen;
 sprite_system *demo;
 unsigned char *pal;
 int i;
 int anim[]={ 0,1,2,3,4,5,6,7 };

 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* load pcx */
 pcx_pic = image_load_pcx("demo13.pcx");

 /* check that load was OK */
 if(pcx_pic == NULL){
    jlib_exit("PCX Load Failed.");
 }

 demo=sprite_init(SPRITES,FRAMES);

 if(demo == NULL){
    jlib_exit("Sprite Init Failed.\n");
 }

 /* set pal to point to the images palette */
 pal = IMG_PALETTE(pcx_pic);
 screen_block_set_pal(pal);

 kb_init();

 /* copy the image to the offscreen buffer */
 buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_MAX_X(pcx_pic),IMG_MAX_Y(pcx_pic));
 image_free(pcx_pic);
 
 /* blit the buffer to the screen while building sprites */
 screen_blit_fs_buffer(offscreen);

 for(i=0;i<=7;i++){
     sprite_build_from_buff(demo,i,offscreen,i*34+1,1,i*34+32,32);
 }

 /* set each sprite to a random position and built frame */
 for(i=0;i<SPRITES;i++){
     sprite_set_xy(demo,i,RANDOM(SCREEN_WIDTH),RANDOM(SCREEN_HEIGHT));
     sprite_set_mode(demo,i,SPR_MODE_WHOLE);
     sprite_set_an_frame(demo,i,RANDOM(FRAMES));
     sprite_set_anim_info(demo,i,RANDOM(3)+2,FRAMES,anim);
     sprite_turn_on(demo,i);
 }

 /* repeat animation ITERATIONS times */
 for(i=0;i<ITERATIONS;i++){
   buff_save_all_sprites(demo,offscreen);
   buff_draw_all_sprites(demo,offscreen);
   screen_blit_fs_buffer(offscreen);
   buff_rest_all_sprites(demo,offscreen);
   sprite_update_all_anim_and_move(demo);
   if(kb_key_hit()){
         break;
   }
 };

 kb_closedown();

 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
