/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

/* this only tests one stick if found, but you get the idea */

int main(void)
{
#if JOYSTICK_AVAILABLE == 1
 int numj,x1,y1,x2,y2,xc,yc,zz,buttons=0,dir;

 puts("Joystick test...");
 numj = joystick_count();
 printf("Number of sticks detected is %d\n",numj);

 if(!numj) {
    puts("None found, giving up.");
    exit(0);
 }

 puts("testing (logical) stick 1.");
 if(!joystick_init(1))
    jlib_exit("joystick init() failed");

 puts("Move stick to top-left and then press fire.");

 while(!FIRE_1_DOWN(buttons)) joystick_get_status(1,&x1,&y1,&buttons);
 while(FIRE_1_DOWN(buttons))  joystick_get_status(1,&zz,&zz,&buttons);

 puts("Move stick to bottom-right and then press fire.");

 while(!FIRE_1_DOWN(buttons)) joystick_get_status(1,&x2,&y2,&buttons);
 while(FIRE_1_DOWN(buttons))  joystick_get_status(1,&zz,&zz,&buttons);

 puts("Move stick to center and then press fire.");

 while(!FIRE_1_DOWN(buttons)) joystick_get_status(1,&xc,&yc,&buttons);
 while(FIRE_1_DOWN(buttons))  joystick_get_status(1,&zz,&zz,&buttons);

 joystick_calibrate(1,x1,x2,y1,y2,xc,yc);

 puts("Move stick to read directions, press fire when done...");
 
 buttons = 0;
 while(!FIRE_1_DOWN(buttons)){
      int ndir;

      joystick_get_status(1,&xc,&yc,&buttons);
      ndir = joystick_get_direction(1,xc,yc);
      if(ndir!=dir){
         dir=ndir;
      switch (dir) {
        case  JOY_CENTER    : puts("centered");
        break;  
        case  JOY_NORTH     : puts("north (up)");
        break;  
        case  JOY_EAST      : puts("east (right)");
        break;  
        case  JOY_SOUTH     : puts("south (down)");
        break;  
        case  JOY_WEST      : puts("west (left)");
        break;  
        case  JOY_NORTHEAST : puts("northeast (up-right)");
        break;  
        case  JOY_NORTHWEST : puts("northwest (up-left)");
        break;  
        case  JOY_SOUTHEAST : puts("southeast (down-right)");
        break;  
        case  JOY_SOUTHWEST : puts("southwest (down-left)");
        break;
        default:              printf("what? %d\n",dir);
      }
      printf("raw values %d %d\n",xc,yc);
      }
 }
#endif
 puts("Done.");
 return(0);
}
