/**  strcoll.c **********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     Locale dependent routines:     strcoll(), stricoll().
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <string.h>

#include "_locale.h"

int _lc_Coll2 = 1; /* if = 1 (default) strcoll()/strxfrm()
  use two pass: first - Case-less and second - Case-sensitive;
                      else if = 0 use single pass (Case-sensitive). */

/* Non-standard, but useful, also in used strcoll() pass 1 */

int stricoll(const char *s1, const char *s2)
{
 int ci;
 while(!(ci = (int)_lc_collati[*(unsigned char*)s1++] -
              (int)_lc_collati[*(unsigned char*)s2]) && *s2++);
 return ci;
}

int strcoll(const char *s1, const char *s2)
{
 int ci;
 if (!_lc_Coll2 ||
     !(ci = stricoll(s1, s2)))
   while(!(ci = (int)_lc_collate[*(unsigned char*)s1++] -
                (int)_lc_collate[*(unsigned char*)s2]) && *s2++);
 return ci;
}

/* end of strcoll.c */