/* Example of use of 3D routines to rotate cylinder  on X,Y,Z axes */
/* Make using 
   make make3dex.mak */
/* Written by Nigel Salt */

#include <3d.h>
#include <graph.h>
#include <math.h>

double dmatA[4][4];
matrix matA={4,4,&dmatA[0][0]};

double dmatB[4][4];
matrix matB={4,4,&dmatB[0][0]};

double dmatC[4][4];
matrix matC={4,4,&dmatC[0][0]};

double dmatD[4][4];
matrix matD={4,4,&dmatD[0][0]};

double dmatE[4][4];
matrix matE={4,4,&dmatE[0][0]};

double dmatF[4][4];
matrix matF={4,4,&dmatF[0][0]};

double dmatG[4][4];
matrix matG={4,4,&dmatG[0][0]};

double dmatH[4][4];
matrix matH={4,4,&dmatH[0][0]};

double dmatI[4][4];
matrix matI={4,4,&dmatI[0][0]};

double dmatJ[4][4];
matrix matJ={4,4,&dmatJ[0][0]};

/* OBJECTS */
#define CYLBAS 20
double cylp[CYLBAS*2][3];
int cyll[CYLBAS*3][2];
object cyl=
{
  CYLBAS*2,CYLBAS*3,&cylp[0][0],&cyll[0][0]
};

double cylp2[CYLBAS*2][3];
int cyll2[CYLBAS*3][2];
object cyl2=
{
  CYLBAS*2,CYLBAS*3,&cylp2[0][0],&cyll2[0][0]
};

main()
{
  int i,j,k;
  char buff[80];
  cyldef(CYLBAS,&cyl);
  init3d();
  scale3(&matA,50,50,50);
  objtran(&cyl,&matA);

  for (j=0;j<3;j++)
    {
    rot3(&matA,pi/16,j);
    _settextposition(30,0);
    sprintf(buff,"%c ROT",'X'+j);
    _outtext(buff);
    for (i=0;i<50;i++)
      {
      _setcolor(i%15+1);
      objdraw(&cyl);
      objcop(&cyl,&cyl2);
      objtran(&cyl,&matA);
      _setcolor(0);
      objdraw(&cyl2);
      }
    }
  _setvideomode(_DEFAULTMODE);
}

wait()
{
 _settextposition(30,70);
 _outtext("PRESS KEY");
 getch();
 _settextposition(30,70);
 _outtext("         ");
}
cyldef(max,o)
int max;
objectptr o;
{
  int i;
  double anginc,ang;
  ang=-pi;
  anginc=pi/max*2;
  for (i=0;i<max;i++)
    {
    *(o->pdat+(i+max)*3+0)=cos(ang);
    *(o->pdat+i*3+0)=cos(ang);
    *(o->pdat+i*3+1)=1;
    *(o->pdat+(i+max)*3+1)=-1;
    *(o->pdat+(i+max)*3+2)=*(o->pdat+i*3+2)=sin(ang);
    ang+=anginc;
    *(o->ldat+i*2)=i;
    *(o->ldat+i*2+1)=(i+1)%max;
    *(o->ldat+(i+max)*2)=i+max;
    *(o->ldat+(i+max)*2+1)=(i+1)%max+max;
    *(o->ldat+(i+2*max)*2)=i;
    *(o->ldat+(i+2*max)*2+1)=(i+max);
    }
}
