/* xpmbf.h                      freeware                   xhunga@tiscali.fr  */


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printmA_IDbF(
pmatrix mA)
{
 int i;
 int j;
 int n;

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   n=0;
   for ( j = 0 ; j < mA->rows * TWOCOL; j++,j++)
    {
     printf(" %2.0f/%-.0f",*(mA->pblock+i *mA->cols+j  ),
                             *(mA->pblock+i *mA->cols+j+1));
    }

   printf(" [",n);
   for ( j = mA->rows * TWOCOL ; j < mA->cols; j++,j++)
    {
     n++;
     if(*(mA->pblock+i *mA->cols+j))
     {
      if(*(mA->pblock+i *mA->cols+j  )==1 &&
         *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("+b%d",n);
        }
      else if(*(mA->pblock+i *mA->cols+j  )==-1 &&
              *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf(" - b%d",n);
        }
      else if(*(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("%+.0f b%d",*(mA->pblock+i *mA->cols+j),n);
        }
      else
        {
         printf("%+.0f/%-.0f b%d",*(mA->pblock+i *mA->cols+j  ),
                                    *(mA->pblock+i *mA->cols+j+1),n);
        }
     }
    }
    printf("]",n);

  }

  printf("\n");
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printxbF(
pmatrix mA)
{
 int i;
 int j;
 int n;
 int m;

 m = 0;
 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   n=0;
   m++;
   printf(" x%d = ",m);
   for ( j = 0 ; j < mA->cols; j++,j++)
    {
     n++;
     if(*(mA->pblock+i *mA->cols+j))
     {
      if(*(mA->pblock+i *mA->cols+j  )==1 &&
         *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("+b%d ",n);
        }
      else if(*(mA->pblock+i *mA->cols+j  )==-1 &&
              *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf(" - b%d",n);
        }
      else if(*(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("%+.0f b%d",*(mA->pblock+i *mA->cols+j    ),n);
        }
      else
        {
         printf(" %+.0f/%-.0f b%d ",*(mA->pblock+i *mA->cols+j  ),
                                      *(mA->pblock+i *mA->cols+j+1),n);
        }
     }
    }
  }
  printf("\n");
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printminvAbF(
pmatrix mA)
{
 int i;
 int j;
 int n;

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   n=0;
   for ( j = 0 ; j < mA->cols; j++,j++)
    {
     n++;

     {
      if(*(mA->pblock+i *mA->cols+j    )==1 &&
         *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("       +b%d ",n);
        }
      else if(*(mA->pblock+i *mA->cols+j  )==-1 &&
              *(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("        - b%d",n);
        }
      else if(*(mA->pblock+i *mA->cols+j+1)==1)
        {
         printf("    %+5.0f b%d",*(mA->pblock+i *mA->cols+j),n);
        }
      else
        {
         printf(" %+5.0f/%-.0f b%d ",*(mA->pblock+i *mA->cols+j  ),
                                       *(mA->pblock+i *mA->cols+j+1),n);
        }
     }
    }
  }
  printf("\n");
}

