/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
amnsb_C(int n,int p)
{
int      i;
int      j;
fraction a;
fraction b;
fraction amnsb;

double pC      [n][p*TWOCOL];matrix mC      ={n,p*TWOCOL,&pC      [0][0]};
double paC     [n][p*TWOCOL];matrix maC     ={n,p*TWOCOL,&paC     [0][0]};
double pbC     [n][p*TWOCOL];matrix mbC     ={n,p*TWOCOL,&pbC     [0][0]};
double pamnsb_C[n][p*TWOCOL];matrix mamnsb_C={n,p*TWOCOL,&pamnsb_C[0][0]};
double paCmnsbC[n][p*TWOCOL];matrix maCmnsbC={n,p*TWOCOL,&paCmnsbC[0][0]};

double pamnsb_C_mns_aCmnsbC[n][p*TWOCOL];
matrix mamnsb_C_mns_aCmnsbC={n,p*TWOCOL,&pamnsb_C_mns_aCmnsbC[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  a.numer = (randF(9)+1);
  a.denom = 1;
  b.numer = (randF(9)+1);
  b.denom = 1;

  randmI(&mC,10);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n", a.numer);
  printf("                                                      ");
  printf("b = %.0f\n\n",  b.numer);
  printf("                                                      C  :");
  printmI4(&mC);
  getchar();

  clrscrn();
  amnsb = subF(a,b);
  printf("                                      ");
  printf(" a - b = %.0f - (%.0f) = %.0f\n\n",
              a.numer,
              b.numer,
          amnsb.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                 (a-b)C :\n");
  smultmF(amnsb,&mC,&mamnsb_C);
  printmI4(         &mamnsb_C);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n",
          a.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                      aC :\n");
  smultmF(a,&mC,&maC);
  printmI4(     &maC);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("b = %.0f\n\n",
          b.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                      bC :\n");
  smultmF(b,&mC,&mbC);
  printmI4(     &mbC);
  getchar();


  clrscrn();
  printf("                                                     aC  :");
  printmI4(&maC);
  printf("                                                     bC  :");
  printmI4(&mbC);
  printf("\n                                                 (aC-bC) :");
  submF(&maC,&mbC,&maCmnsbC);
  printmI4(       &maCmnsbC);
  getchar();

  clrscrn();
  printf("                                                 (a-c)C  :");
  printmI4(&mamnsb_C);
  printf("\n                                                 (aC-bC) :");
  printmI4(       &maCmnsbC);
  printf("\n                                      ((a-c)C) - (aC-bC) :");
  submF(&mamnsb_C,&maCmnsbC,&mamnsb_C_mns_aCmnsbC);
  printmI4(                 &mamnsb_C_mns_aCmnsbC);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            (a-c)C = aC-bC                        ");
  printf("\n            **************                      \n");
  printf("\n The size of  mC         : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"pki.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"pki.exe 2 3\" -> 2x3                  ");
  printf("\n          \"pki.exe 1 5\" -> 1x5                  ");
  printf("\n          \"pki.exe 4 2\" -> 4x2                  ");
  printf("\n          \"pki.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

  srand(time(&t));
  hello();

do
{
if( argc == 3 && atoi(argv[1])&& atoi(argv[2]) )
 {
  n = atoi(argv[1]);
  p = atoi(argv[2]);

  if( n < 1){n=1;}
  if( n > 5){n=5;}
  if( p < 1){p=1;}
  if( p > 5){p=5;}
 }
else
 {
  n = (int) fabs(randF(5)+1);
  p = (int) fabs(randF(5)+1);
 }

  amnsb_C(n,p);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












