/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction k;

double pbA      [n][n*TWOCOL];matrix mA      ={n,n*TWOCOL,&pbA      [0][0]};
double pbkA     [n][n*TWOCOL];matrix mkA     ={n,n*TWOCOL,&pbkA     [0][0]};
double pbTrpsA  [n][n*TWOCOL];matrix mTrpsA  ={n,n*TWOCOL,&pbTrpsA  [0][0]};
double pbTrpskA [n][n*TWOCOL];matrix mTrpskA ={n,n*TWOCOL,&pbTrpskA [0][0]};
double pbk_TrpsA[n][n*TWOCOL];matrix mk_TrpsA={n,n*TWOCOL,&pbk_TrpsA[0][0]};

double pbTrpskA_mns_k_TrpsA[n][n*TWOCOL];
matrix mTrpskA_mns_k_TrpsA={n, n*TWOCOL,&pbTrpskA_mns_k_TrpsA[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */

 k.numer = (int)     (randF(9)+1);
 k.denom = (int) fabs(randF(9)+1);

 randmF(&mA,9,4);

 clrscrn();
 printf(" %6.0f/%.0f",k.numer,k.denom);
 printf("                                                k :\n\n");
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                                        kA :\n");
 smultmF(k,&mA,&mkA);
 printmF(&mkA);
 printf("                                             transpose(kA) :\n");
 transposeF(&mkA,&mTrpskA);
 printmF(        &mTrpskA);
 getchar();


 clrscrn();
 printf(" %6.0f/%.0f",k.numer,k.denom);
 printf("                                                k :\n\n");
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmF(       &mTrpsA);
 printf("                                            k transpose(A) :\n");
 smultmF(k,&mTrpsA,&mk_TrpsA);
 printmF(          &mk_TrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(kA) :\n");
 printmF(&mTrpskA);
 printf("                                            k transpose(A) :\n");
 printmF(&mk_TrpsA);
 printf("                          transpose(kA) - (k transpose(A)) :\n");
 submF(&mTrpskA,&mk_TrpsA,&mTrpskA_mns_k_TrpsA);
 printmF(&mTrpskA_mns_k_TrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          transpose(kA) - (k transpose(A))        ");
  printf("\n          ********************************      \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpdf.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpdf.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpdf.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpdf.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

