/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
AplsB_BplsA(int n)
{
double pbA    [mxr][mxc*TWOCOL];matrix mA    ={mxr,mxc*TWOCOL,&pbA    [0][0]};
double pbTrpsA[mxr][mxc*TWOCOL];matrix mTrpsA={mxr,mxc*TWOCOL,&pbTrpsA[0][0]};

double pAplsTrpsA [mxr][mxc*TWOCOL];
matrix mAplsTrpsA={mxr, mxc*TWOCOL,&pAplsTrpsA[0][0]};

                     mA.rows=n;                  mA.cols=n*TWOCOL;
                 mTrpsA.rows=n;              mTrpsA.cols=n*TWOCOL;
             mAplsTrpsA.rows=n;          mAplsTrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

  randmF(&mA,9,9);

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  getchar();

  clrscrn();
  printf("                                                      A  :");
  printmF(&mA);
  printf("                                            Transpose(A) :");
  transposeF(&mA,&mTrpsA);
  printmF(       &mTrpsA);
  getchar();

  clrscrn();
  printf("                                                       A :\n");
  printmF(&mA);
  printf("\n                                            Transpose(A) :\n");
  printmF(&mTrpsA);
  printf("\n                         A + Transpose(A) : Is Symmetric :\n");
  addmF(&mA,&mTrpsA,&mAplsTrpsA);
  printmF(&mAplsTrpsA);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n        A + Transpose(A) : Is Symmetric           ");
  printf("\n        *******************************         \n");
  printf("\n The size of mA          : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"symaf.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"symaf.exe 2\" -> 2x2                  ");
  printf("\n          \"symaf.exe 1\" -> 1x1                  ");
  printf("\n          \"symaf.exe 4\" -> 2x2                  ");
  printf("\n          \"symaf.exe 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

  srand(time(&t));
  hello();

do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]);

  if( n > mxr){n=mxr;}
 }
else
 {
  n = (int) fabs(randF(mxr));
 }

  if(n<2){n=2;}

  AplsB_BplsA(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












