/* ------------------------------ SCR.H ----------------------------------- */

/* -------------------- ScrGetMode() & ScrSetMode() ----------------------- */
struct Mode	{
	int VideoMode;
	int Columns;
	int VideoPage;
};

void ScrGetMode (struct Mode *ModePtr);
void ScrSetMode (struct Mode *ModePtr);

void InitScr (void);		/* initialize to color/mono */
#define COLOR 1
#define MONO  0
int VideoSeg = 0xb800;		/* default to color segment */
int VideoMode = COLOR;
/* ------------------------- cursor functions ----------------------------- */

void ScrGetCur (int *Col, int *Row, int Page);
void ScrSetCur (int Col, int Row, int Page);
void ScrGetStyle (int *StartLine, int *StopLine);
void ScrSetStyle (int StartLine, int StopLine);

/* ----------------------- ScrPush() & ScrPop() --------------------------- */

						/* Error constants 									*/
#ifndef NOERROR
#define NOERROR		0	/* No error 										*/
#endif
#define MAXTOOSMALL	1   /* Request to push more than MAXSCREENS times 		*/
#define NOHEAP		2	/* Out of heap memory 								*/
#define STACKEMPTY	3   /* No screen has been pushed 						*/

int ScrPush (void);
int ScrPop (int Remove);

/* -------------------------- ScrReadWindow() ----------------------------- */

#define OPENERR		1	/* Error opening screen file 					    */
#define READERR		2	/* Error reading screen file						*/
#define CLOSERR		3	/* Error closing screen file						*/

int ScrReadWindow (char *Buffer, char *FileName);

/* ---------------- Other definitions and prototypes ---------------------- */

							/* Constants for ScrGetS 'Mode parameter		*/
#define NOFEAT		0x0000	/* Turn off all 'mode' features					*/
#define AUTOEXIT	0x0001	/* Exit field automattically on full buffer		*/
#define UPPER		0x0002	/* Convert all letters to uppercase				*/
#define DIR         0x0003  /* Add backslash after ':' & no space fill      */

void ScrPutWindow (char *Buffer, int SourceStartRow, int SourceStartCol,
				   int SourceEndRow, int SourceEndCol, int TargetRow,
				   int TargetCol);
void PutStr (int Col, int Row, int Attr, char *fmt, ...);
void ScrPutS (char *String, int Attr, int Row, int Col);
void ScrPutBox (int ULC, int ULR, int LRC, int LRR, int Style);
void ScrClear (int StartCol, int StartRow, int StopCol, int StopRow);
void ClrScrn (int x, int y, int xx, int yy, int attr);
void Cls (void);
void HideCur (void);
void RestCur (void);
int ScrGetS (char *Buffer, int Attr, int Row, int Col, int Length, int Mode);
void ScrPutAttr (int Attr, int StartCol, int StartRow,
				 int StopCol, int StopRow);

