/***********************************************************/
/* File Id.                  Qfill.C                       */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/06/88.                     */
/* Modifications:                                          */
/* 11/13/88 - Changed function & file name to wfill        */
/*                                                         */
/*              (c) Copyright by Stan Milam                */
/*                                                         */
/* Comments:  This routine will color in a text block on   */
/* screen via an assembler routine.                        */
/***********************************************************/

#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int qfill(int urow,int ucol,int lrow,int lcol,int fcolor,int bcolor,int ch) {

   int rows, cols, attr;
   int page, pagesize;
   int mx_rows, mx_cols;
   int far *scrnptr;
   unsigned offset, scrnseg;

   if (!chk_video_state(&mx_rows, &mx_cols)) return(0);

   rows = (lrow - urow) + 1;                 /* Calc number of rows */
   cols = (lcol - ucol) + 1;                 /* Calc number of cols */
   ch   &= 0x00ff;

   scrnseg = getscrnseg();
   page    = getpage();
   pagesize= getpagesize();

   offset  = MK_SCRNOFF(urow, ucol);         /* Make offset to scrn memory */
   scrnptr = (int far *) MK_FP(scrnseg,offset); /* Make far pointer to scrn */
   attr    = MK_ATTR(fcolor,bcolor) + ch;    /* fill with colored chars */
   TextFill(rows, cols, scrnptr, attr);      /* Call assembler function */
   return(1);
}


