#include "prfifl.h"
#include <dos.h>
#include <stdio.h>

int PRFstart(short ip,short cs)
{
	if (! PRF_IsInstalled( 0x88)) {
		fprintf(stderr,"PRF is not installed.\n");
		return -1;
	}

	fprintf(stderr, "profiling started using CS = %04x\n",cs);
	
	PRF_Fn( PRF_START, cs);
	return 0;
}
int PRFstop()
{		 
	const char *prfname = "PROFIL.OUT";
	unsigned long far *lpData;
	unsigned short far *tot_ints;
	FILE *prf;
	long i;
	
	long total = 0;

	lpData = (unsigned long far *) PRF_Fn( PRF_STOP );
	tot_ints = (unsigned short far *)lpData;
	tot_ints--;
	

	prf = fopen(prfname,"w");
	if(prf == NULL){
		perror(prfname);
		return -1;
	}
	fprintf(stderr,"Profiling stopped:%d total interrupts\n",*tot_ints);
	fprintf(stderr,"Writing data to %s\n",prfname);

	for (i=0;i < 8192 ;i++){
		if (*lpData) fprintf(prf,"%04lx %ld\n",(i << 3),*lpData);
		total += *lpData++;
	}	 
	fprintf(stderr," Total samples : %ld\n",total);
	fclose(prf);
	return 0;
}
