#ifndef __PROCESS_H__
#define __PROCESS_H__

#include <stddef.h>

#define P_WAIT 0
#define P_NOWAIT 1  //not implemented (duhh...)
#define P_OVERLAY 2

#ifdef __cplusplus
  extern "C" {
#endif

extern int spawnl  (int mode, char *path, char *arg0, ...);  //, NULL
extern int spawnle (int mode, char *path, char *arg0, ...);  //, NULL, char *envp[]
extern int spawnlp (int mode, char *path, char *arg0, ...);  //, NULL
extern int spawnlpe(int mode, char *path, char *arg0, ...);  //, NULL, char *envp[]

extern int spawnv  (int mode, char *path, char *argv[]);
extern int spawnve (int mode, char *path, char *argv[], char *envp[]);
extern int spawnvp (int mode, char *path, char *argv[]);
extern int spawnvpe(int mode, char *path, char *argv[], char *envp[]);

extern int execl  (char *path, char *arg0, ...);  //, NULL
extern int execle (char *path, char *arg0, ...);  //, NULL, char **env
extern int execlp (char *path, char *arg0, ...);  //, NULL
extern int execlpe(char *path, char *arg0, ...);  //, NULL, char **env

extern int execv  (char *path, char *argv[]);
extern int execve (char *path, char *argv[], char **env);
extern int execvp (char *path, char *argv[]);
extern int execvpe(char *path, char *argv[], char **env);

extern void exit(byte el);
extern void _exit(byte el);
extern void _cexit(void);
extern void _c_exit(void);
extern void abort(void);
extern void _dos_exit(byte el);

extern system(char *sys);

#ifdef __cplusplus
  }
#endif

#endif

