/*===========================================================================*\
| QWIKDEMO.C                                                ver 2.1, 07-06-89 |
|                                                                             |
| Demo has been programmed best for color cards in 25-line mode.              |
| Do not terminate this program manually.                                     |                                             |
|                                                                             |
|  Copyright (c) 1988,1989 by James H. LeMay, All rights reserved.            |
|                                                                             |
|  Conversion to C by Jordan Gallagher / Wisdom Research                      |
\*===========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <math.h>

#include "qwikc21.h"

char ch;
char lastmode;
char step, colmax;
char blkrow, blkcol, v;
char numstr[80];
char coll[3], colr[3];
char saved_block[4000], popup_block[4000];
int  brdrattr, wndwattr;
int  i, count, fgrnd, bgrnd;
long rnum;

char strng[40]={ " Q Screen Utilities " };
char strng2[40]={ " QWIKC Screen Utilities  " };
char data[9][40]=
{ "1", "22", "333", " Q Screen Utilities ", "Odd  Length", "Even  Length",
  "18 characters wide", "19 characters width", "Margin to Margin width" };
char pc[14][80]=
{ "COMPUTERS:           ADAPTERS:",
  "------------------   ----------",
  "IBM PC               MDA",
  "IBM XT               CGA",
  "IBM AT               EGA",
  "IBM PCjr             MCGA",
  "IBM PC Convertible   VGA",
  "IBM PS/2 Model 25    8514/A",
  "IBM PS/2 Model 30    Hercules:",
  "IBM PS/2 Model 50      HGC",
  "IBM PS/2 Model 60      HGC Plus",
  "IBM PS/2 Model 70      InColor",
  "IBM PS/2 Model 80",
  "IBM 3270 PC" };
char other[12][80]=
{ "qscrollup  - Qwik scroll up",
  "qscrolldown- Qwik scroll down",
  "qscrtovscr - block to virtual screen",
  "qvscrtoscr - virtual screen to block",
  "qreadstr   - reads string from screen",
  "qreadchar  - reads char   from screen",
  "qreadattr  - reads attr   from screen",
  "qviewpage  - view any video page",
  "qwritepage - write to any video page",
  "qwrite_sub - for arrays/partial strings",
  "qfillc     - a self-centering qfill",
  "qattrc     - a self-centering qattr" };
char crsr[12][80]=
{ "gotorc        - absolute cursor position",
  "wherer        - absolute cursor row",
  "wherec        - absolute cursor column",
  "setcursor     - sets cursor mode",
  "getcursor     - gets cursor mode",
  "modcursor     - modifies cursor mode",
  "cursor_initial   - cursor at startup",
  "cursor_underline - normal cursor",
  "cursor_halfblock - for insert editing",
  "cursor_block     - for the nearsighted",
  "A total of 41 utilities",
  "optimizing in just 2.7k bytes or less!" };
char init[10][80]=
{ " Detects dual monitor/adapters for all",
  "  systems listed on the previous page",
  " Identifies each system by name",
  " Gets system ID and submodel ID",
  " Gets CPU ID",
  " Sets far pointer for virtual screens",
  " Determines need for wait-for-retrace",
  " Gets screen dimensions: rows by cols",
  " Determines the number of video pages",
  " Sets 4 standard cursor shapes" };
char eoss[4][80]=
{ "  qwriteeos     - just like qwrite     ",
  "  qwriteeos_sub - just like qwrite_sub ",
  "  qfilleos      - just like qfill      ",
  "  qattreos      - just like qattr      " };

int wait=400;
struct border_t {
    char TL[2];
    char TH[2];
    char TR[2];
    char LV[2];
    char RV[2];
    char BL[2];
    char BH[2];
    char BR[2];
} border = { "", "", "", "", "", "", "", "" };

char bwcolors[4]={ BLACK, LIGHTGRAY, WHITE, LIGHTGRAY_BG };

#ifndef __TURBOC__
union REGS mr;
#define disable _disable
#define enable _enable
#define random(num)     (rand() % (num))
#define randomize()     srand((unsigned)time(NULL))
#define textmode(m)     { mr.h.ah=0; mr.h.al=m; int86(0x10,&mr,&mr); }
#endif

#ifdef __TURBOC__
#define tclock() (*(long far *)0x46CL)
#else
#define tclock() (*(long far *)(0x46CL+_z))
#endif


/******************************| check_zenith |*****************************\
Since Zenith doesn't have snow on any CGAs, turn off snow checking.
\***************************************************************************/
void check_zenith(void)
{
    char tmp[10];

    movedata( 0xF000u, 0x800Cu, (unsigned)(((char far *)tmp)+1),
                                (unsigned)((char far *)tmp),     8 );
    if(qsnow && (strncmp( tmp, "ZDS CORP", 8 )) == 0) {
        qsnow=0;
        cardsnow=0;
    }
}


/******************************| closedemo |********************************\
Exits the demo.
\***************************************************************************/
void closedemo(void)
{
    if(qvideo_mode <= C40) {
#ifdef __TURBOC__
        delay( wait*6 );
#else
        suspend( wait*6 );
#endif
        textmode( lastmode );
    }

    gotorc( 24, 1 );

    setcursor( cursor_initial );
}


/*********************************| qbox |**********************************\
qbox is an application of QWIKC Screen Utilities.  It can make fast
pop-up menus.  See WNDWxx.ARC for more applications.
\***************************************************************************/
void qbox( char row, char col, char rows, char cols, int wndwattr,
           int brdrattr, struct border_t *b )
{
    if(rows >=2 && cols >=2) {
        qwrite(   row,        col,                        brdrattr, b->TL );
        qfilleos(                         1,      cols-2, brdrattr, b->TH[0] );
        qwriteeos(                                        brdrattr, b->TR );
        qfill(    row+1,      col,        rows-2, 1,      brdrattr, b->LV[0] );
        qfill(    row+1,      col+cols-1, rows-2, 1,      brdrattr, b->RV[0] );
        qwrite(   row+rows-1, col,                        brdrattr, b->BL );
        qfilleos(                         1,      cols-2, brdrattr, b->BH[0] );
        qwriteeos(                                        brdrattr, b->BR );
        qfill(    row+1,      col+1,      rows-2, cols-2, wndwattr, ' '  );
    }
}


/********************************| waitkey |********************************\
Displays a prompt and awaits a keypress.
\***************************************************************************/
void waitkey(void)
{
    qwrite( 25, crt_cols-19, SAMEATTR, "press any key ..." );
    if( (ch=getch()) == 0 ) ch=getch();
    else if(ch==27) {
        closedemo();
        exit(0);
    }
}


/*******************************| clearscr |********************************\
Clears the screen using the specified attribute.
\***************************************************************************/
void clearscr( int attr )
{
    qfill( 1, 1, crt_rows, crt_cols, attr, ' ' );
}


/*******************************| scatter |*********************************\
Displays random boxes on the screen.
\***************************************************************************/
void scatter( char maxrows, char leftcol, char rightcol,
              char botrow, char toprow )
{
    int a;
    char row, col, rows, cols;

    rows=random(maxrows)+1;

    if(qvideo_mode <= C40) {
        cols = rows + (rows >> 2);
    } else {
        cols = (rows << 1) + (rows >> 1 );
    }

    col = leftcol + random( rightcol - leftcol - cols + 2 );
    row = toprow + random( botrow - toprow - rows + 2 );

    if(qvideo_mode == MONO) {
        a=bwcolors[ random(4) ];
    } else {
        fgrnd=random(16);
        bgrnd=random(8);
        if(bgrnd == fgrnd) ++fgrnd;
        a=fgrnd + (bgrnd << 4);
    }

    qfill( row, col, rows, cols, a, 178 );
}


/*******************************| explode |*********************************\
Makes the screen "explode" with boxes.
\***************************************************************************/
void explode(void)
{
    char toprow, botrow, maxrows, delta, leftcol, rightcol, center;
    long start_time, elapsed_time;

    center = crt_cols >> 1;
    randomize();

    disable();
    start_time = tclock();
    enable();

    for(step=1; step <= 12; step++) {
        /* set boundaries */
        toprow = 13-step;
        botrow = 13+step;
        maxrows = step;

        if(qvideo_mode <= C40) {                      /* Keep aspect 1:1 */
            delta=( step*5/3 );
        } else {
            delta=( step*10/3 );
        }

        leftcol=center-delta+1;
        rightcol=center+delta;

        if(step < 12) {
            for(count=1; count <= 40; count++)
                scatter(maxrows, leftcol, rightcol, botrow, toprow);
        } else
        do {
            scatter(maxrows, leftcol, rightcol, botrow, toprow);
            disable();
            elapsed_time=tclock() - start_time;
            enable();
        } while( elapsed_time < 60 );      /* about 60/18.2 seconds */
    }
}


/********************************| initdemo |********************************\
Initialization for the QWIKC demo.
If you set a mode, do it first before qinit()!
Please!  Test a mode first to see if it is different than what you want;
then change if necessary.  Otherwise, the screen jumps.
\****************************************************************************/
void initdemo(void)
{
    /* set up data */

    check_zenith();
    setmultitask();
    lastmode=qvideo_mode;

    if(qvideo_mode != MONO && !have_3270) {
        clearscr( LIGHTGRAY+BLACK_BG );
        qwritec( 11, 1, crt_cols, SAMEATTR, "(1) 40 column mode" );
        qwritec( 12, 1, crt_cols, SAMEATTR, "(2) 80 column mode" );
        qwritec( 14, 1, crt_cols, SAMEATTR, "Which mode (1,2)? " );
        gotoeos();
        while( !strchr( "12", (ch=getch()) ) );

        v=qvideo_mode;
        switch(ch) {
            case '1':
                switch(v) {
                    case BW80: v=BW40; break;
                    case C80: v=C40; break;
                } break;
            case '2':
                switch(v) {
                    case BW40: v=BW80; break;
                    case C40: v=C80; break;
                } break;
        }

        if(v != qvideo_mode) {
            textmode( v );
            qreinit();            /* call qreinit() after mode change! */
            check_zenith();
            setmultitask();
        }
    }

    modcursor( cursor_off );
}


/****************************| explode_screen |*****************************\
Explodes the screen with boxes.
\***************************************************************************/
void explode_screen(void)
{
    int a;

    /* initial screen */
    clearscr( WHITE+BLUE_BG );
    qwritec( 11, 1, crt_cols, YELLOW+BLUE_BG, strng2 );
    qwritec( 13, 1, crt_cols, SAMEATTR, "Your screen is about to explode." );
    qwritec( 14, 1, crt_cols, SAMEATTR, "Hold on to your seat ..." );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    /* Explosion of Boxes */
    clearscr( BLACK+LIGHTGRAY_BG );
    explode();

    qfillc( 10, 1, crt_cols, 6, 34, RED_BG, ' ' );
    qfillc( 11, 1, crt_cols, 4, 30, BROWN_BG, ' ' );

    a=YELLOW+RED_BG;
    qwritec( 12, 1, crt_cols, a, strng2 );
    qwritec( 13, 1, crt_cols, a, "       Version 2.1       " );
}


/*****************************| save_screen |*******************************\
Saves the current screen.
\***************************************************************************/
void save_screen(void)
{
    int a, row, col;

    /* Save screen for Page Demo */
    if(maxpage > 0) {
        qstoretomem( 1, 1, 25, crt_cols, saved_block );
        qwritepage(1);
        qstoretoscr( 1, 1, 25, crt_cols, saved_block );
        qwritepage(0);
    }

    /* End of Save Screen */
#ifdef __TURBOC__
    delay( wait*4 );
#else
    suspend( wait*4 );
#endif
    a=WHITE+BLUE_BG;
    qwritec( 6, 1, crt_cols, a, " qwrite will write with new attributes  " );
    qwritec( 7, 1, crt_cols, a, " that you specify direct to the screen. " );
#ifdef __TURBOC__
    delay( wait*6 );
#else
    suspend( wait*6 );
#endif
    qwritec( 18, 1, crt_cols, SAMEATTR,
    "qwrite will also use existing attributes" );
    qwritec( 19, 1, crt_cols, SAMEATTR,
    "   when you do not even know or care.   " );

    /* highlight the word "existing" */
    qattrc( 18, 6, crt_cols+5, 1, 10, WHITE+RED_BG+BLINK );
#ifdef __TURBOC__
    delay( wait*10 );
#else
    suspend( wait*10 );
#endif
    qwritec( 21, 1, crt_cols, a, " Say Goodbye to this screen. " );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    /* Disintegrate Screen */
    for(i=0; i < 5000; i++) {
        row=random(25)+1;
        col=random(crt_cols)+1;
        qfill( row, col, 1, 1, BLACK, ' ' );
    }
}


/*****************************| list_compats |******************************\
Lists the computers and adapters, etc. that QWIKC is compatible with.
\***************************************************************************/
void list_compats(void)
{
    int row,col;

    /* Compatible computer and adapter list */
    clearscr( LIGHTGRAY_BG );
    qwritec( 4, 1, crt_cols, SAMEATTR,
    "QWIKC Screen Utilities detects these IBM");
    qwritec( 5, 1, crt_cols, SAMEATTR,
    "or compatible computers and adapters:");
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif
    col=(crt_cols-30) >> 1;

    for(row=7; row <= 20; row++)
        qwrite( row, col, SAMEATTR, pc[row-7] );

    qwritec( 23, 1, crt_cols, SAMEATTR, "Working text modes 0,1,2,3, or 7!" );

    waitkey();
}


/*****************************| list_detect |*******************************\
Lists the auto-detection features of qinit().
\***************************************************************************/
void list_detect(void)
{
    int row,col;

    /* qinit() detection */
    clearscr( LIGHTGRAY_BG );
    qwritec( 4, 1, crt_cols, SAMEATTR, "To configure QWIKC, qinit() not only" );
    qwritec( 5, 1, crt_cols, SAMEATTR, "detects computers/adapters, it:" );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif
    col=(crt_cols-36) >> 1;
    for(row=10; row <= 19; row++)
        qwrite( row, col, SAMEATTR, init[row-10]);
    waitkey();
}


/******************************| write_num |********************************\
Shows how qwrite can be used with converted numbers.
\***************************************************************************/
void write_num(void)
{
    int row, col;

    clearscr( YELLOW+BLACK_BG );
    qwritec( 2, 1,crt_cols, SAMEATTR,"qwrite with sprintf() will write");
    qwritec( 3, 1, crt_cols, SAMEATTR, "number conversions faster:" );
#ifdef __TURBOC__
    delay( wait*7 );
#else
    suspend( wait*7 );
#endif

    rnum=1234500000L;

    for(col=0; col <= crt_cols/20-1; col++) {
        for(row=5; row <= 24; row++) {
            ++rnum;
            sprintf( numstr, "%ld", rnum );
            qwrite( row, col*20+4, SAMEATTR, numstr );
        }
    }

    waitkey();
}


/******************************| centering |********************************\
Demonstrates the auto-centering features of QWIKC.
\***************************************************************************/
void centering(void)
{
    int row;

    /* Centering demo */
    clearscr( LIGHTGRAY_BG );
    qwritec( 2, 1, crt_cols, SAMEATTR, "qwritec will automatically" );
    qwritec( 3, 1, crt_cols, SAMEATTR, "center your data ..." );
    qwritec( 4, 1, crt_cols, SAMEATTR, "(Odd breaks are shifted to the "
                                       "left.)" );
#ifdef __TURBOC__
    delay( wait*6 );
#else
    suspend( wait*6 );
#endif

    /* Set up columns for varying column modes */
    coll[1]=1; colr[1]=crt_cols;

    if(crt_cols < 80) {
        coll[0]=coll[1]; coll[2]=crt_cols/2;
        colr[0]=colr[1]; colr[2]=crt_cols/2;
    } else {
        coll[0]=3; colr[0]=26;
        coll[2]=crt_cols-14; colr[2]=crt_cols-14;
    }

    qwritec( 7, coll[0], colr[0], SAMEATTR, "between margins ..." );
    qbox( 8, ((coll[0]+colr[0]) >> 1) - 12, 15, 26, WHITE, LIGHTGRAY,
          &border );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    for(row=11; row <= 19; row++)
        qwritec( row, coll[0], colr[0], SAMEATTR, data[row-11] );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    qwritec( 7, coll[1], colr[1], SAMEATTR, "between two columns ..." );
    qfillc( 9, coll[1], colr[1], 13, 24, YELLOW, ' ' );   /* Clear window */

    for(row=9; row <=21; row++)
        qwritec( row, coll[1], colr[1], SAMEATTR, "><"); /* Show two columns */
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    for(row=11; row <= 19; row++)
        qwritec( row, coll[1], colr[1], LIGHTRED, data[row-11]);
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    qwritec( 7, coll[2], colr[2], SAMEATTR, "or on a center line ..." );
    /* Clear window */
    qfillc( 8, coll[2], colr[2], 15, 27, BLACK+LIGHTGRAY_BG, ' ' );

    for(row=9; row <= 21; row++)        /* show center line */
        qwritec( row, coll[2], colr[2], BLACK+LIGHTGRAY_BG, "|" );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    for(row=11; row <= 19; row++)
        qwritec( row, coll[2], colr[2], SAMEATTR, data[row-11]);

    waitkey();
}


/*******************************| filling |*********************************\
Demonstrates the screen filling and attributing utilities of QWIKC.
\***************************************************************************/
void filling(void)
{
    int row, col;

    /* qfill demo */
    clearscr( WHITE+BLACK_BG );
    qwritec( 2, 1, crt_cols, SAMEATTR, "qfill as well as qattr can fill" );
    qwritec( 3, 1, crt_cols, SAMEATTR, "your screen in several ways." );
#ifdef __TURBOC__
    delay( wait*7 );
#else
    suspend( wait*7 );
#endif

    qwritec( 7, 1, crt_cols, SAMEATTR, "by rows ..." );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    for(row=9; row <= 24; row++)
        qfill( row, 2, 1, crt_cols-2, 9+row, row+56 );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    qfill( 7, 1, 19, crt_cols, WHITE, ' ' );       /* clear lines */
    qwritec( 7, 1, crt_cols, SAMEATTR, "by columns ..." );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif

    for( col=2; col <= crt_cols-2; col++ )
        qfill( 9, col, 16, 1, 16+col, col+63 );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    qfill( 7, 1, 19, crt_cols, WHITE, ' ' );       /* clear lines */
    qwritec( 7, 1, crt_cols, SAMEATTR, "or by row-by-column blocks ..." );
#ifdef __TURBOC__
    delay( wait*3 );
#else
    suspend( wait*3 );
#endif
    qfill( 9, 2, 16, crt_cols-2, YELLOW+BLUE_BG, '!' );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif
}


/*******************************| qboxdemo |********************************\
Demonstrates the application of the QWIKC utilities for making boxes on the
screen.
\***************************************************************************/
void qboxdemo(void)
{
    int row, col;

    /* qbox demo */
    clearscr( LIGHTGRAY_BG );
    qwritec( 2, 1, crt_cols, SAMEATTR,
    "qbox is an application function made " );
    qwritec( 3, 1, crt_cols, SAMEATTR,
    "from qwrite and qfill.  Together they" );
    qwritec( 4, 1, crt_cols, SAMEATTR,
    "can make windows with borders easy. " );
#ifdef __TURBOC__
    delay( wait*9 );
#else
    suspend( wait*9 );
#endif
    qwritec( 14, 1, crt_cols, SAMEATTR, "How about 100 of them? ... " );
#ifdef __TURBOC__
    delay( wait*4 );
#else
    suspend( wait*4 );
#endif
    colmax=crt_cols-21;

    for(i=0; i<100; i++) {
        row=random( 10 )+6;
        col=random( colmax )+2;

        if(qvideo_mode == MONO) {
            brdrattr=bwcolors[random(4)];
            wndwattr=bwcolors[random(4)];
        } else {
            brdrattr=random (128);
            wndwattr=random (128);
        }

        qbox( row, col, 10, 20, brdrattr, wndwattr, &border );
    }

#ifdef __TURBOC__
    delay( wait*10 );
#else
    suspend( wait*10 );
#endif
}


/*******************************| popupdemo |*******************************\
Demonstrates the use of QWIKC for pop-up menus.
\***************************************************************************/
void popupdemo(void)
{
    /* Block transfer and popup demo */
    qfill( 1, 1, 25, crt_cols, YELLOW, '?' );         /* clear screen */
    qfillc( 10, 1, crt_cols, 6, 40, BROWN_BG, ' ' );  /* clear block */
    qwritec( 11, 1, crt_cols, SAMEATTR, "qstore will save and restore" );
    qwritec( 12, 1, crt_cols, SAMEATTR,
    "row-by-column blocks on your display." );
    qwritec( 13, 1, crt_cols, SAMEATTR,
    "It is so fast, I have to slow it down" );
    qwritec( 14, 1, crt_cols, SAMEATTR, "so you can see it." );
#ifdef __TURBOC__
    delay( wait*11 );
#else
    suspend( wait*11 );
#endif
    blkrow=8;
    blkcol=crt_cols/2-9;
    qstoretomem( blkrow, blkcol, 10, 20, saved_block );

    /* make a pop up menu */
    qbox( blkrow, blkcol, 10, 20, YELLOW+BLUE_BG, BROWN+BLUE_BG, &border );
    qwritec( blkrow+4, blkcol, blkcol+20, SAMEATTR, "Pop up" );
    qwritec( blkrow+5, blkcol, blkcol+20, SAMEATTR, "menu" );

    /* End of pop up menu */
    qstoretomem( blkrow, blkcol, 10, 20, popup_block );
#ifdef __TURBOC__
    delay( wait*4 );
#else
    suspend( wait*4 );
#endif
    colmax = crt_cols-20;

    for(i=0; i < 30; i++) {
#ifdef __TURBOC__
        delay( wait/2 );
#else
        suspend( wait/2 );
#endif
        qstoretoscr( blkrow, blkcol, 10, 20, saved_block );
        blkrow=random(15)+1;
        blkcol=random(colmax)+1;
        qstoretomem( blkrow, blkcol, 10, 20, saved_block );
        qstoretoscr( blkrow, blkcol, 10, 20, popup_block );
    }
}


/*******************************| pagedemo |********************************\
Demonstrates the page-flipping features of QWIKC.
\***************************************************************************/
void pagedemo(void)
{
    int a;

    /* page demo */
    if(maxpage > 0 && !inmultask) {
        qviewpage(1);
        qwritepage(1);
        a=YELLOW+BLUE_BG;

        qfillc( 20, 1, crt_cols, 3, 35, a, ' ' );
        qwritec( 20, 1, crt_cols, SAMEATTR, " Remember this page?  " );
        qwritec( 21, 1, crt_cols, SAMEATTR, " It wasn't lost, but saved "
                                            "using" );
        qwritec( 22, 1, crt_cols, SAMEATTR, "qstores and placed on a new "
                                            "page. " );
#ifdef __TURBOC__
        delay( wait*14 );
#else
        suspend( wait*14 );
#endif
        qwritepage(0);
        qviewpage(0);
    }
}


/*******************************| eosmarker |*******************************\
Demonstrates the use of the QWIKC utilities' EOS marker.
\***************************************************************************/
void eosmarker(void)
{
    int col;

    /* EOS marker */
    clearscr( LIGHTGREEN+BLACK_BG );
    qwritec( 3, 1, crt_cols, WHITE, "EOS marker:" );
    col=eosc();
    sprintf( numstr, "%c%c%cright here", 7, 0, 24 );
    qwriteeos( BLINK+YELLOW, numstr );
    qwrite( 4, col, YELLOW, &numstr[2] );
    qwritec( 7, 1, crt_cols, SAMEATTR,
             "The printf function locates your next" );
    qwritec( 8, 1, crt_cols, SAMEATTR,
             "string by placing the cursor at the end " );
    qwritec( 9, 1, crt_cols, SAMEATTR,
             "of the string.  QWIKC functions can do  " );
    qwritec( 10, 1, crt_cols, SAMEATTR,
             "the same thing, but without moving the  " );
    qwritec( 11, 1, crt_cols, SAMEATTR,
             "cursor!  It's done with an offset called" );
    qwritec( 12, 1, crt_cols, SAMEATTR,
             "qeosofs.  It's updated after every QWIKC" );
    qwritec( 13, 1, crt_cols, SAMEATTR,
             "function.                               " );
    qwritec( 16, 1, crt_cols, SAMEATTR,
             "Now you can have the convenience of a" );
    qwritec( 17, 1, crt_cols, SAMEATTR,
             "printf but the speed of QWIKC!  Check   " );
    qwritec( 18, 1, crt_cols, SAMEATTR,
             "out the following q*eos functions.      " );
    waitkey();
}


/*******************************| qeosdemo |********************************\
Demonstrates the QWIKC EOS functions.
\***************************************************************************/
void qeosdemo(void)
{
    int row, col;

    /* QWIKC EOS utilities demo */
    clearscr( BLACK+LIGHTGRAY_BG );
    qwritec( 3, 1, crt_cols, SAMEATTR, "The q*eos functions:" );

    for(row=5; row <= 8; row++)
        qwritec( row, 1, crt_cols, YELLOW+BLACK_BG, eoss[row-5] );
    qwritec( 10, 1, crt_cols, SAMEATTR, "Take advantage of the EOS marker "
                                        "to" );
    qwritec( 11, 1, crt_cols, SAMEATTR, "chain the next string - with an "
                                        "   " );
    qwritec( 12, 1, crt_cols, SAMEATTR, "optional change of attribute! "
                                        "     " );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    col=(crt_cols-38) >> 1;
    qwrite( 14, col, BLACK+BROWN_BG, " Yellow " );

    for(count=1; count <= 2; count++) {
#ifdef __TURBOC__
        delay( wait );
#else
        suspend( wait );
#endif
        qwriteeos( WHITE+BLUE_BG, "  Blue  " );
#ifdef __TURBOC__
        delay( wait );
#else
        suspend( wait );
#endif
        qwriteeos( BLACK+BROWN_BG, " Yellow " );
    }

#ifdef __TURBOC__
    delay(wait);
#else
    suspend( wait);
#endif
    qwritec( 16, 1, crt_cols, SAMEATTR, "Starts where the last QWIKC" );
    qwritec( 17, 1, crt_cols, SAMEATTR, "function left off!" );
    qwritec( 18, 1, crt_cols, SAMEATTR, "Like printf ... but at QWIKC "
                                        "speeds!" );
#ifdef __TURBOC__
    delay( wait*2 );
#else
    suspend( wait*2 );
#endif

    qwrite( 21, col, BLACK+BROWN_BG, " Yellow " );
    for(count=1; count <= 2; count++) {
        qwriteeos( WHITE+BLUE_BG, "  Blue  " );
        qwriteeos( BLACK+BROWN_BG, " Yellow " );
    }

    waitkey();
}


/*******************************| usingeos |********************************\
Demonstrates the use of the EOS marker.
\***************************************************************************/
void usingeos(void)
{
    int col;

    /* Using EOS marker */
    clearscr( BLACK+LIGHTGRAY_BG );
    col=((crt_cols-40) >> 1)+1;
    qwritec( 2, 1, crt_cols, WHITE, " Using the EOS marker: " );
    qwrite(  4, col, SAMEATTR, "Now you have two marker utilities -" );
    qwrite(  5, col, SAMEATTR, "(1) EOS, and (2) the cursor.  Both can" );
    qwrite(  6, col, SAMEATTR, "be used interchangeably:" );
    qwrite(  8, col, SAMEATTR, "gotoeos   - cursor to end-of-string" );
    qwrite(  9, col, SAMEATTR, "eosr      - end-of-string row" );
    qwrite( 10, col, SAMEATTR, "eosc      - end-of-string column" );
    qwrite( 12, col, SAMEATTR, "You can also manually alter EOS with the" );
    qwrite( 13, col, SAMEATTR, "following functions:" );
    qwrite( 15, col, SAMEATTR, "eostorc     - Sets EOS to a given row" );
    qwrite( 16, col, SAMEATTR, "              and column." );
    qwrite( 17, col, SAMEATTR, "eostorcrel  - Relatively shifts EOS by" );
    qwrite( 18, col, SAMEATTR, "              row and column." );
    qwrite( 19, col, SAMEATTR, "eostocursor - Matches EOS to the cursor" );
    qwrite( 20, col, SAMEATTR, "              position." );
    qwrite( 21, col, SAMEATTR, "eosln       - Sets EOS to next row" );
    qwrite( 22, col, SAMEATTR, "qeosln      - Like eosln, but scrolls up" );
    qwrite( 23, col, SAMEATTR, "              if on last row." );

    waitkey();
}


/*******************************| moreutils |*******************************\
Displays information about the other screen functions.
\***************************************************************************/
void moreutils(void)
{
    int row, col;

    /* Other Screen Utilities demo */
    clearscr( BLACK+LIGHTGRAY_BG );
    qwritec( 3, 1, crt_cols, SAMEATTR, "Here are more powerful" );
    qwritec( 4, 1, crt_cols, SAMEATTR, "QWIKC Screen Utilities" );
    qwritec( 5, 1, crt_cols, SAMEATTR, "(for standard and virtual):" );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif
    col=(crt_cols-38) >> 1;

    for(row=8; row <= 19; row++)
        qwrite( row, col, SAMEATTR, other[row-8]);
    waitkey();
}


/*****************************| cursorutils |*******************************\
Displays information about the cursor manipulation functions.
\***************************************************************************/
void cursorutils(void)
{
    int row, col;

    /* cursor utilities demo */
    clearscr( BLACK+BROWN_BG );
    qwritec( 1, 1, crt_cols, SAMEATTR, "And of course there is a complete" );
    qwritec( 2, 1, crt_cols, SAMEATTR, "set of CURSOR location and mode  " );
    qwritec( 3, 1, crt_cols, SAMEATTR, "routines for all video pages and " );
    qwritec( 4, 1, crt_cols, SAMEATTR, "video cards:                     " );
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif
    col=(crt_cols-38) >> 1;

    for(row=6; row <= 11; row++)
        qwrite( row, col, SAMEATTR, crsr[row-6] );

    qwritec( 13, 1, crt_cols, SAMEATTR, "For universal cursor sizes, four" );
    qwritec( 14, 1, crt_cols, SAMEATTR, "standard shapes are initialized " );
    qwritec( 15, 1, crt_cols, SAMEATTR, "by detecting each video card:   " );

    for(row=17; row <= 20; row++)
        qwrite( row, col, SAMEATTR, crsr[row-11] );
    for(row=22; row <= 23; row++)
        qwritec( row, 1, crt_cols, SAMEATTR, crsr[row-12] );
    waitkey();
}


/******************************| attrdemo |*********************************\
Demonstrates the attribute-changing features of QWIKC.
\***************************************************************************/
void attrdemo(void)
{
    int a, row, col, cols;

    /* Attribute demo */
    clearscr( GREEN+GREEN_BG );
    a=WHITE+GREEN_BG;
    qwritec( 2, 1, crt_cols, a, "QWIKC Screen Utilities are hiding data" );
    qwritec( 3, 1, crt_cols, a, "on your screen ..." );
    cols=crt_cols/20;

    if(qvideo_mode == MONO)
         a=BLACK+BLACK_BG;
    else a=GREEN+GREEN_BG;

    for(col=0; col < cols; col++)
        for(row=5; row <= 20; row++)
            qwrite( row, 20*col+1, a, strng );

#ifdef __TURBOC__
    delay( wait*8 );
#else
    suspend( wait*8 );
#endif
    qfill( 2, 1, 2, crt_cols, SAMEATTR, ' ' );        /* clear lines */
    a=WHITE+GREEN_BG;
    qwritec( 2, 1, crt_cols, a, "qattr can show them -" );
    qwritec( 3, 1, crt_cols, a, "by merely changing the attribute!" );
#ifdef __TURBOC__
    delay( wait*6 );
#else
    suspend( wait*6 );
#endif

    a=BLACK+GREEN_BG;
    qattr( 5, 1, 16, crt_cols, a );                   /* reveal data */
#ifdef __TURBOC__
    delay( wait*5 );
#else
    suspend( wait*5 );
#endif

    qfill( 2, 1, 2, crt_cols, SAMEATTR, ' ' );        /* clear lines */
    a=YELLOW+GREEN_BG;
    qwritec( 2, 1, crt_cols, a, "Or even just emphasize what's seen ..." );

    for(i=0; i < 500; i++) {
        row=random( 16 ) + 5;
        col=random( cols )*20+1;
        qattr( row, col, 1, 20, 46 );
#ifdef __TURBOC__
        delay( 3 );
#else
        suspend( 3 );
#endif
        qattr( row, col, 1, 20, 32 );
    }

    for(i=1; i <= cols; i++)
        qattr( 5*i, (i-1)*20+1, 1, 20, YELLOW+GREEN_BG+BLINK );
    qattr( 21, 1, 5, crt_cols, a );
    qwritec( 22, 1, crt_cols, a, " (c) 1988-1989 James H. LeMay " );
    qwritec( 23, 1, crt_cols, a, "Conversion to C by" );
    qwritec( 24, 1, crt_cols, a, "Jordan Gallagher/Wisdom Research" );
}


/*********************************| main |***********************************\
The main block.
\****************************************************************************/
main()
{
    qinit();
    initdemo();

    explode_screen();
    save_screen();
    list_compats();
    list_detect();
    write_num();
    centering();
    filling();
    qboxdemo();
    popupdemo();
    if(maxpage>0 && !inmultask)
        pagedemo();
    eosmarker();
    qeosdemo();
    usingeos();
    moreutils();
    cursorutils();
    attrdemo();
    closedemo();

    return;
}
