/* dtest.c
 *
 * test program for Data Collection routines
 */
/*----------------------------------------------------------*/
#include "simc.h"
#include <stdio.h>
#include <ctype.h>
#include <string.h>

void Pause( void);

/*----------------------------------------------------------*/
void main( void)
{
  Accum_ID A;
  Tally_ID T;
  double   Time  = 0.0,
           V;

  printf( "\nData Test\n");

  A = AccumCreate();
  T = TallyCreate();

  printf( "Tally:\n");
  V = 1; printf( "%8f\n", V); Tally( T, V);
  V = 2; printf( "%8f\n", V); Tally( T, V);
  V = 3; printf( "%8f\n", V); Tally( T, V);
  V = 4; printf( "%8f\n", V); Tally( T, V);

  printf( "\n"
          "Count:%ld\n"
          "Mean:%8f\n"
          "SD  :%8f\n"
          "Max :%8f\n"
          "Min :%8f\n",
	     TallyCount( T),
          TallyMean( T),
          TallyStdDev( T),
	     TallyMax( T),
          TallyMin(T));

  Pause();

#ifdef __cplusplus
  printf( "C++ Tally:\n");
  TallyInit( T);
  T = 1.0;
  T = 2;
  T = 3L;
  T = 4.0;

  printf( "\n"
          "Count:%ld\n"
          "Mean:%8f\n"
          "SD  :%8f\n"
          "Max :%8f\n"
          "Min :%8f\n",
	     TallyCount( T),
          TallyMean( T),
          TallyStdDev( T),
	     TallyMax( T),
          TallyMin(T));

  Pause();
#endif /* __cplusplus */

  printf( "\nAccum:\n");
  Time = 0.0; V = 1;
  printf( "\n%8f %8f", Time, V); AccumT( A, V, Time);
  Time = 1.0; V = 2;
  printf( "\n%8f %8f", Time, V); AccumT( A, V, Time);
  Time = 2.0; V = 3;
  printf( "\n%8f %8f", Time, V); AccumT( A, V, Time);
  Time = 3.0; V = 4;
  printf( "\n%8f %8f", Time, V); AccumT( A, V, Time);
  Time = 4.0;

  printf( "\n"
          "Count:%ld\n"
          "Mean:%8f\n"
          "SD  :%8f\n"
          "Max :%8f\n"
          "Min :%8f\n",
	     AccumCount( A),
          AccumMeanT( A, Time),
	     AccumStdDevT( A, Time),
	     AccumMax( A),
          AccumMin(A));

  Pause();

#ifndef __cplusplus
  {
  char *TestA = NULL,
       *TestT = NULL;
  printf( "\nDeliberate Error Test\n");
  Accum( TestA, 0.0);
  Tally( TestT, 0.0);
  Pause();
  }
#endif
}
/*==========================================================*/
/*---------------------------------------------------------- Pause*/
void Pause( void)
{
  char S[8];
  printf( "\nPress <Enter> to Continue\n");
  gets( S);
}
/*----------------------------------------------------------*/
