/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbA[2][2*TWOCOL]=
{
  -1,1,   0,1,
   0,1,   1,1,
};
matrix mA={2,2*TWOCOL,&pbA[0][0]};

double pbu[2][2*TWOCOL];matrix mu={2,2*TWOCOL,&pbu[0][0]};
double pbv[2][2*TWOCOL];matrix mv={2,2*TWOCOL,&pbv[0][0]};

double pb0[2][1*TWOCOL];matrix m0={2,1*TWOCOL,&pb0[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,6,3);
   mzero(&m0);
  copymF(&m0,&mu);

  clrscrn();

  printf("\n Reflection about the y-axis :                  \n");
  printf("\n                | -1  0 |                         ");
  printf("\n           v  = |       |  u                      ");
  printf("\n                |  0  1 |                         ");

  printf("\n\n                                          u = OA");
  printmF(&mu);
  printGnuPlot2d("u",&mu);

  multmF(&mA,&mu,&mv);
  printf("\n\n                                          v = OB");
  printmF(&mv);
  printGnuPlot2d("v",&mv);

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw u and v. \n");
  printf("  * Press Return in this window. (To create a new value for u) \n");
  printf("  * Use the command Replot in Gnuplot to draw the news u and v.\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n        Reflection about the y-axis :             ");
  printf("\n        ***************************               ");
  printf("\n\n                                                ");
  printf("\n                  u = OA                          ");
  printf("\n\n                                                ");
  printf("\n                | -1  0 |                         ");
  printf("\n           v  = |       |  u                      ");
  printf("\n                |  0  1 |                         ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












