/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbT[3][3*TWOCOL]=
{
   1,1,   0,1,   3,1,
   0,1,   1,1,   0,1,
   0,1,   0,1,   1,1,
};
matrix mT={3,3*TWOCOL,&pbT[0][0]};

double pbABCD[3][5*TWOCOL]=
{
  2,1,   4,1,   4,1,   2,1,   2,1,
  2,1,   2,1,   4,1,   4,1,   2,1,
  1,1,   1,1,   1,1,   1,1,   1,1,
};
matrix mABCD={3,5*TWOCOL,&pbABCD[0][0]};

double pbT_ABCD[3][5*TWOCOL];matrix mT_ABCD={3,5*TWOCOL,&pbT_ABCD[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  clrscrn();
  printf("\n                                              T");
  printmF3(&mT);

  printf("\n\n                                          ABCD");
  printmF3(&mABCD);
  gnpltvectcol2d("u",&mABCD);

  multmF(&mT,&mABCD,&mT_ABCD);
  printf("\n\n                                        T(ABCD)");
  printmF3(&mT_ABCD);
  gnpltvectcol2d("v",&mT_ABCD);
  gnpltaxis(     "aa2d.plt");

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw ABCD and T(ABCD)\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n       Horizontal shift (right) c > 0 :           ");
  printf("\n       ******************************             ");
  printf("\n\n                                                ");
  printf("\n\n                                                ");
  printf("\n                | 1  0  c |                       ");
  printf("\n     T(ABCD)  = | 0  1  0 |  ABCD                  ");
  printf("\n                | 0  0  1 |                       ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
/*-------------------------------- PROGRAM ---------------------------------- */
  hello();

  AB();


  printf("\n Press Return to stop\n");
  getchar();

  return 0;
}












