/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 25                        
                                                                            
 Good practice for understanding the movement and animation commands.       
 See if you can guess what each move will do before you run this program.   
 It will help you understand the format for the movements.                  
 Press 'Q' to quit.                                                         
                                                                            
  PROJECT                                                             
 This program requires the WSPR.LIB and the WGT45.LIB to be linked.         
                                                                            
  DATA FILES                                                          
 Make sure that you have MOUSE.SPR in your executable directory.            
                                                                            
ͼ
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <alloc.h>
#include <wgt45.h>
#include <wgtspr.h>

block sprites[1001];			/* Pointers to sprites */
int quit;				/* If quit !=0, program quits */
int sprite_toggle = 0;			/* Toggles movement and animation */
char c;					/* Input from keyboard - q quits */

void looper (void);	        /* a routine which controls the sprites */

void main(void)
{
color palette[256];		/* Our palette */
int i;				/* Loop counter */
int oldmode;			/* Stores previous video mode */

  printf ("WGT Example #25\n\n");
  printf ("Another sprite movement and animation demo......\n");
  printf ("Press Q to end the program. Any other key toggles the movement and\n");
  printf ("animation status of the sprites.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  vga256 ();
  wloadsprites (palette, "mouse.spr", sprites, 0, 1000);  /* load sprites */
  wsetpalette (0, 255, palette);
  initialize_sprites (sprites);			  /* initialize them */
  maxsprite = 4;				  /* number of sprites on */
  minit ();

  for (i = 0; i < 200; i++)			  /* draw a background */
    {
     wsetcolor (i);
     wfline (0, i, 159, i);
     wfline (160, 199 - i, 319, 199 - i);
    }

  wcopyscreen (0, 0, 319, 199, NULL, 0, 0, spritescreen);
  wcopyscreen (0, 0, 319, 199, NULL, 0, 0, backgroundscreen);
  /* when using sprites, whatever is on the visual page must be on
     spritescreen and backgroundscreen too! */

  /* Also, you must make sure you turn a sprite on AFTER you draw
     the background or it will leave a black spot where the sprite
     is first shown. */
  wsetscreen (spritescreen);
  spriteon (1, 0, 0, 1);
  animate (1, "(1,30)(2,30)(3,30)(4,30)(3,30)(2,30)R");
  movex (1, "(2,150,0)(0,90,0)(-2,150,0)(0,90,0)R");
  movey (1, "(0,150,0)(2,90,0)(0,150,0)(-2,90,0)R");

  spriteon (2, 160, 0, 1);
  animate (2, "(1,30)(2,30)(3,30)(4,30)R");
  movex (2, "(-1,150,0)(1,300,0)(-1,150,0)R");
  movey (2, "(1,180,0)(-1,180,0)R");

  spriteon (3, 0, 100, 1);
  animate (3, "(1,30)(4,30)R");
  movex (3, "(1,300,1)(-300,1,0)R");
  movey (3, "(0,1,0)");		/* must set a y move since
				   I turn it on below even
				   if it doens't do anything */
  for (i = 1; i < 4; i++)
    {
     animon (i);
     movexon (i);
     moveyon (i);
    }

  do {
    looper ();
  } while (!quit);

  spriteoff (1);		/* turn off sprite */
  spriteoff (2);		/* turn off sprite */
  spriteoff (3);		/* turn off sprite */
  /* To be safe, turn off all sprites before ending program.
     This will free any memory used from them. */
  deinitialize_sprites();
  mdeinit ();                   /* Deinitialize the mouse handler */

  wfreesprites (sprites, 0, 1000);		/* free memory */
  wsetmode (oldmode);
}


void looper (void)
{
int i;

  erase_sprites ();			/* clear the sprites */
  if (kbhit ())
    {
     c = toupper (getch ());
     if (c == 'Q')
	quit = 1;

     sprite_toggle = !sprite_toggle;
     if (sprite_toggle)
       for (i = 1; i < 4; i++)
	 {
	  movexoff (i);
	  moveyoff (i);
	  animoff (i);
	 }
     else
	for (i = 1; i < 4; i++)
	 {
	  movexon (i);
	  moveyon (i);
	  animon (i);
	 }
    }

  draw_sprites (1);		/* draw them back on */
				/* This loop is required to update sprite
				   positions */
  wretrace ();			/* Remove this to see how fast they can move */
}
