/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 19                         
									      
 This program loads in some sprites created with the WGT Sprite Editor.      
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 Make sure that SPACE.SPR is in your executable directory.                   
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  block screen1;          /* one virtual screen */
  block sprites[10];      /* An array of blocks to load the sprites into.
			     Version 5.0 allows for any number to be
			     loaded in, as long as you pass the same size
			     of the array to the wloadsprites and wfreesprites
			     commands. */
  short y;
  short sp;
  short oldmode;
  color palette[256];

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #19\n\n");
  printf ("This program loads some images from a sprite file. Press the left mouse\n");
  printf ("button to flip between the images. Press the right mouse button to end the\n");
  printf ("demo and display image dimensions.  The top image uses wputblock and\n");
  printf ("the bottom image uses wresize with xray mode.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();
  wloadsprites (palette, "space.spr", sprites, 0, 9);
  /* loads the first 10 sprites */
  wsetpalette(0, 255, palette);

  screen1 = wnewblock(0, 0, 319, 199);
  wsetscreen (screen1);

  sp = 1;                       /* sprites always start at 1 in the array */
  minit ();
  msetbounds (0, 0, 160, 199);

  do {
    for (y = 0; y < 200; y++)
    {
      wsetcolor (y);
      wline (0, y, 319, y); /* clear the screen by drawing horz lines (fast) */
    }
    wputblock (0, 0, sprites[1], 0);
    if (sprites[sp] != NULL)
     {
      wputblock (mouse.mx, mouse.my, sprites[sp], 1);   /* put the block using xray mode at mouse position */

      wflipblock (sprites[sp], 0); /* flip the sprite vertically */
      wresize (mouse.mx - 20, mouse.my + 50, mouse.mx + 20, mouse.my + 90,
	       sprites[sp], 1); 
      /* resize the sprite using xray mode just below the first one */
      
      wflipblock (sprites[sp], 0); /* flip it back to normal */
     }
    wcopyscreen (0, 0, 160, 199, screen1, 0, 0, NULL);  /* copy the whole screen */

    if (mouse.but == 1)  /* Show the next sprite */
    {
      sp++;
      if (sp > 9) 
	sp = 1;
      noclick ();
    }

  } while (mouse.but != 2);            /* right button exits */
  msetbounds (0, 0, 319, 199);
  mdeinit ();                   /* Deinitialize the mouse handler */
  wfreeblock (screen1);
  wsetmode (oldmode);
  for (y = 1; y < 10; y++)
    if (sprites[y] != NULL)
      printf ("#%2d is %d by %d\n", y, wgetblockwidth (sprites[y]), wgetblockheight (sprites[y]));
  wfreesprites (sprites, 0, 9);  /* frees all sprites in that array */
}
