* Function: Net_fopen()
* Author:   David Morgan
* Version:  Clipper Summer '87
* Note(s):  Tries to open a file with specified open mode.
*
* Copyright (c) 1988 Nantucket Corp.

FUNCTION Net_fopen

* Pass the following parameters:
*
* 1. Character - name of the file to open.
*
* 2. Logical or Numeric - mode of open.
*
*    if logical: .T. = Deny Read/Write-R/W (146).
*                .F. = Deny None-R/W (194).
*    if numeric: you name it per DOS 3Dh/INT 21h,
*                this value as open mode.
*
* 3. Numeric - seconds to wait (0 = wait forever).

PARAMETERS file, ex_use, wait
PRIVATE forever, handl, keystroke, open_mode
open_mode = IIF (  TYPE('ex_use') ='L'  ,;
                   IIF(ex_use,146,194)  ,;
                   ex_use)
forever = (wait = 0)
DO WHILE (forever .OR. wait > 0)
   handl = FOPEN(file, open_mode)
   IF handl > -1                && FOPEN succeeds.
      RETURN (handl)
   ENDIF
   keystroke = INKEY(1)        	&& Wait 1 second.
   IF keystroke = 27
      BREAK
   END
   wait = wait - 1
ENDDO
RETURN handl 			&& FOPEN fails: handl is -1.
