              page 60,132
              title XMDM CRC and Timing Routines MSC 3.00 & 4.00
;
;---------------------------------------------------------------------------
;    This module contains all of the 16 bit CRC routines used in
; XMDM as well as the hardware timing funtion used to perform delays.
; The CRC routines are calculated on the fly, an require speed to
; perform well. All timing functions used in XMDM use a hardware timing
; function to keep a standard timing reference on various machines.
;---------------------------------------------------------------------------
;                        General Equates
;---------------------------------------------------------------------------
;
YES     equ     1
NO      equ     0
;
;---------------------------------------------------------------------------
;  Memory Model selector for Microsoft C v3.0, ASM files.
;---------------------------------------------------------------------------
;  -- model --                    -- equates --
; {small}                   _LDATA = NO    _LCODE = NO
; {medium}                  _LDATA = NO    _LCODE = YES
; {compact}                 _LDATA = YES   _LCODE = NO
; {large}                   _LDATA = YES   _LCODE = YES
;---------------------------------------------------------------------------
;
;       -- Small Memory Model --
;
_LDATA  equ   NO                  ; data area size
_LCODE  equ   NO                  ; code pointers far.
;
include  MODEL.H                  ; get memory model header
;
;
;---------------------------------------------------------------------------
; Set up the program segment according to memory model.
;---------------------------------------------------------------------------
;
if _LCODE                    ; setup program segment
    pseg crc
else
    pseg
endif
;
;---------------------- CRC Storage Accumulator ----------------------------
;
crcval         dw   0
;
;---------------------------------------------------------------------------
;
;---------------------------------------------------------------------------
;
;  void crc_sum(c)
;
;  Parms:      int port; 8 bit character to sum the crc with.
;
;  Purpose:    Sums the character in using CCITT CRC polynomial.
;
;  Return:     <none>
;
;---------------------------------------------------------------------------
;
               public _crc_sum
;
if             _LCODE
_crc_sum       proc far
else
_crc_sum       proc near
endif
               push bp                  ;standard 'C' function entry
               mov  bp,sp
               push di
               push si
               mov  ax,@ab[bp]          ;get the port# argument
               and  ax,00FFh            ;mask out the msb.

               mov bl,8
               mov cl,al
               mov dx,cs:crcval

updloop:       mov al,cl
               rol al,1
               mov cl,al
               mov al,dl
               rcl al,1
               mov dl,al
               mov al,dh
               rcl al,1
               mov dh,al
               jnc skipit

               mov al,dh
               xor al,10h
               mov dh,al
               mov al,dl
               xor al,21h
               mov dl,al

skipit:        dec bl
               jnz updloop
               mov cs:crcval,dx

               pop  si                  ;standard  'C' function exit
               pop  di
               mov  sp,bp
               pop  bp
               ret

_crc_sum       endp
;
;
;---------------------------------------------------------------------------
;
;  void crc_init()
;
;  Parms:      <none>
;
;  Purpose:    Clears the crc accumulator word to zero.
;
;  Return:     <none>
;
;---------------------------------------------------------------------------
;
               public _crc_init
;
if             _LCODE
_crc_init      proc far
else
_crc_init      proc near
endif
               push bp                  ;standard 'C' function entry
               mov  bp,sp
               push di
               push si

               mov cs:crcval,0

               pop  si                  ;standard  'C' function exit
               pop  di
               mov  sp,bp
               pop  bp
               ret

_crc_init      endp
;
;
;---------------------------------------------------------------------------
;
;  unsigned crc_value()
;
;  Parms:      <none>
;
;  Purpose:    Returns the crc accumulator word.
;
;  Return:     <none>
;
;---------------------------------------------------------------------------
;
               public _crc_value
;
if             _LCODE
_crc_value     proc far
else
_crc_value     proc near
endif
               push bp                  ;standard 'C' function entry
               mov  bp,sp
               push di
               push si

               mov ax, cs:crcval

               pop  si                  ;standard  'C' function exit
               pop  di
               mov  sp,bp
               pop  bp
               ret

_crc_value     endp
;
;---------------------------------------------------------------------------
;
;  void timer( n )
;  int n;               -- Number of 1/18.2 sec intervals to delay
;
;  Provide a timed delay of the indicated number of 1/18.2 second
;  intervals.  This permits timing of all manner of things.
;
;---------------------------------------------------------------------------
;
if _LCODE
    dynx    struc
    xscx    dw      ?        ; timer data storage area
    xsdx    dw      ?
    x_bp    dw      ?
    xret    dd      ?
    xarg1   dw      ?
    dynx    ends
else
    dynx    struc
    xscx    dw      ?
    xsdx    dw      ?
    x_bp    dw      ?
    xret    dw      ?
    xarg1   dw      ?
    dynx    ends
endif
;
        public _timer
;
if _LCODE
_timer proc     far
else
_timer proc     near
endif
        push    bp
        sub     sp,4                    ; local variables
        mov     bp,sp
        push    si
        push    di
        xor     ah,ah                   ; see what ticker says first
        int     1Ah                     ; CX:DX is starting point.
        mov     [bp].xsdx,dx            ; save it on the stack
        mov     [bp].xscx,cx

tloop:  xor     ah,ah                   ; function to get timer
        int     1Ah                     ; get timer tiks to CX:DX
        cmp     cx,word ptr [bp].xscx   ; check hi-order part
        je      tl2                     ; if same
;
;  Hi-order part has rolled over, so add instead of subtracting
;  the lo-order parts, with increment
;
        add     dx,[bp].xsdx
        inc     dx

tl2:    sub     dx,[bp].xsdx            ; low-order part
        cmp     dx,word ptr [bp].xarg1  ; is elapsed = specified ?
        jl      tloop
        add     sp,4
        pop     di
        pop     si
        pop     bp
        ret
_timer  endp
;
;
;---------------------------------------------------------------------------
;   End of program code
;---------------------------------------------------------------------------
;
if            _LCODE
              endps crc
else
              endps
endif
              end

