; ----- Findname: Look up a word in the dialing directory
;	If no directory entry matches, look for a script
;	with the given name.
;
;	R.McG; 7/89, Chicago
; ----------------------------------------------------------------
;	Ask for a word
;
   WOPEN 10 10 13 70 (blue red) ESCape
   ATSAY 10 12 (blue yellow) " Find Name "
   ATSAY 11 12 (blue yellow) "Enter the word to be searched: "
   ATGET 12 12 (blue white) 26 S0 ; Read word
   WCLOSE

   IF NULL S0			; If file not open
      SOUND 55,1000		; Bronx cheer
      EXIT			; Stop here
      ENDIF
;
;	Look for the word in the dialing directory
;
   LEGEND "FindName: Searching dialing directory"
   FOR N0 = 1,100
       DIRECT S1 N0		; Entry name
       IF FIND S1 S0		; If we find word in name
	  LEGEND "FindName: Dialing " * S1
	  DIAL N0		; Dial number
	  IF SUCCESS		; Entry number
	     DSCRIPT S1 N0	; Look for a linked script
	     IF NOT NULL S1	; Script name when used
		SET LINKED ON	; Fake entry from dial command
		EXECUTE S1	; Link to script
		ENDIF
	     ENDIF
	   EXIT 		; Exit whether dial succeed or failed
	   ENDIF
       ENDFOR
;
;	Look for an executable script file of that name
;
   LEGEND "FindName: Searching for script named "*S0
   IF ISSCFile S0		; If script file of that name exists
      LEGEND ""                 ; Clear legend line
      EXECUTE S0		; Execute it
      ENDIF
;
;	Failed
;
   CURSOR N0,N1
   ATSAY N0,N1 (DEFAULT) "Word does not exist"
   MESSAGE "^M^J"               ; Scroll down
   SOUND 55,500
   EXIT
;
;	Escape - simply no-op
;
Escape:
   S0 = ""                      ; Make null return
   RETURN
