/*-
 * PTY service.  (pty.h)
 *
 * Mutex in UNIX
 *
 *      This module implements some utility routines for managing UNIX
 *	pseudo-terminals.
 *........................................................................
 * Pty p;
 *
 *      Pty is a structure that stores the bookkeeping information about
 *	each pseudo-terminal.
 *........................................................................
 * int  pty_master_fd(Pty *p)					   (macro)
 * int  pty_slave_fd(Pty *p)					   (macro)
 *
 *	Return the file descriptor associcated with the pseudo-terminal p.
 *........................................................................
 * int  pty_master(Pty *p)
 *
 *	Create the master part of a pseudo-terminal pair.  Return the file
 *	descriptor for the master if successful, or -1 if error.  The file
 *	descriptor can also be accessed as pty_fd(Pty *p).
 *........................................................................
 * int  pty_slave(Pty *p)
 *
 *	Create the slave part of a pseudo-terminal pair, assuming p has
 *	been initialized by calling pty_master(&p) by a previous parent
 *	process.
 *........................................................................
 * void pty_close(Pty *p)
 *
 * 	Close both the master and the slave of a pty pair.
 *........................................................................
 *
 * Bryan So, September 28, 1990
 */

#if !defined(PTY_H)

#define PTY_H

/*
 * Main pty structure.
 */

typedef struct {
    int master, slave;		/* File descriptors */
    char name[12];     		/* TTY filename     */
} Pty;


/*
 * Public Functions
 */

#if defined(__STDC__)

extern int pty_master(Pty *pty);
extern int pty_slave(Pty *pty);
extern pty_close(Pty *pty);

#else

extern int pty_master();
extern int pty_slave();
extern pty_close();

#endif


/*
 * Inline Functions
 */

#define pty_master_fd(p) ((p)->master)
#define pty_slave_fd(p) ((p)->slave)


#endif
