
/*
	DATE.CPP
    Created 1995 by Dejvid Zaninovic
*/

#include <time.h>
#include <dos.h>
#include "c.hpp"
#include "date.hpp"

int monlen[] = {									// months length
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};


/*
	xdate::xdate (word year, byte month, byte day);

	- init all
*/

xdate::xdate (word year, byte month, byte day) 
{
	if (!xdate::set (year, month, day))
		xdate::null();
}


/*
	xdate xdate::null();

	- set date to null
*/

xdate xdate::null() 
{
	year = 0; 
	month = 0; 
	day = 0;
	return *this;
}	


/*
	- is date null
*/

boolean xdate::isnull() const
{
	if (year == 0)
		return TRUE;
	else
		return FALSE;
}


/*
	word xdate::setyear (word n);

	- set year, return year
*/

word xdate::setyear (word n) 
{					 
	if (n != 0) {
		year = n;
		return n;
	} else
		return 0;
}


/*
	byte xdate::setmonth (byte n);

	- set month, return month
*/

byte xdate::setmonth (byte n) 
{
	if ((n != 0) && (n <= 12)) {
		month = n;
		return n;
	} else
		return 0;
}


/*
	byte xdate::setday (byte n);

	- set day, return day
*/

byte xdate::setday (byte n) 
{				 
	if ((n != 0) && (n <= 31)) {
		day = n;
		return n;
	} else
		return 0;
}


/*
	boolean xdate::set (word year, byte month, byte day);

	- set year, month and day of month
*/

boolean xdate::set (word year, byte month, byte day) 
{
	if (::isdate (year, month, day)) {
		xdate::year = year;
		xdate::month = month;
		xdate::day = day;
		return TRUE;
	} else
		return FALSE;
}


/*
	boolean isdate (word year, byte month, byte day);

	- is date correct
*/

boolean isdate (word year, byte month, byte day)
{
	boolean leap;

	if (year < 1)
		return FALSE;

	if (month < 1 || month > 12)
		return FALSE;

	leap = isleap (year);
	if ((month == 2) && leap && (month > (monlen[1]+1)))
		return FALSE;

	if (day > monlen [month-1])
		return FALSE;

	return TRUE;
}


/*
	boolean isleap (word year);

	- is leap year ?
*/

boolean isleap (word year)
{
	if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0)
		return TRUE;
	else
		return FALSE;
}


/*
	dword xdate::dton();

	- return numeric from date
*/

dword xdate::dton() const
{
	word prvyear;		// years pass
	word leaps;			// leap years pass
	dword n;			// days pass
	int i;

	if (!isdate())
		return FALSE;

	prvyear = year - 1;
	leaps = prvyear / 4 - prvyear / 100 + prvyear / 400;
	for (i=0, n=day; i < month; i++) {
		if (i > 0)
			n += monlen [i-1];
	}
	if ((isleap (year) == TRUE) && month != 1 && month != 2)
		++n;
	n += (dword)prvyear * 365L + (dword)leaps;

	return n;
}


/*
	xdate xdate::ntod (dword n);

	- set date from numeric
*/

xdate xdate::ntod (dword n)
{
	int quadcents, remcents, remquads, remyears;
	boolean leap;

	quadcents = n / QCENTDAYS;
	n -= QCENTDAYS * quadcents;
	if (n < 1) {
		year = 400 * quadcents;
		day = YEARDAYS + 1;
	}

	remcents = n / CENTDAYS;
	n -= CENTDAYS * remcents;
	if (n < 1) {
		year = 400 * quadcents + 100 * remcents;
		day = YEARDAYS;
	}

	remquads = n / QUADDAYS;
	n -= QUADDAYS * remquads;
	if (n < 1) {
		year = 400 * quadcents + 100 * remcents + 4 * remquads;
		day = YEARDAYS + 1;
	}

	remyears = n / YEARDAYS;
	n -= YEARDAYS * remyears;
	if (n < 1) {
		year = 400 * quadcents + 100 * remcents + 4 * remquads + remyears;
		day = YEARDAYS;
	}

	year = 1 + 400 * quadcents + 100 * remcents + 4 * remquads + remyears;

	leap = isleap (year);
	if (n < 1)
	{
		month = 12;
		day = 31;
	}
	else if (n <= 31)
	{
		month = 1;
		day = n;
	}
	else if (n <= leap + 59)
	{
		month = 2;
		day = n - 31;
	}
	else if (n <= leap + 90)
	{
		month = 3;
		day = n - leap - 59;
	}
	else if (n <= leap + 120)
	{
		month = 4;
		day = n - leap - 90;
	}
	else if (n <= leap + 151)
	{
		month = 5;
		day = n - leap - 120;
	}
	else if (n <= leap + 181)
	{
		month = 6;
		day = n - leap - 151;
	}
	else if (n <= leap + 212)
	{
		month = 7;
		day = n - leap - 181;
	}
	else if (n <= leap + 243)
	{
		month = 8;
		day = n - leap - 212;
	}
	else if (n <= leap + 273)
	{
		month = 9;
		day = n - leap - 243;
	}
	else if (n <= leap + 304)
	{
		month = 10;
		day = n - leap - 273;
	}
	else if (n <= leap + 334)
	{
		month = 11;
		day = n - leap - 304;
	}
	else
	{
		month = 12;
		day = n - leap - 334;
	}

	return *this;
}


/*
	char xdate::dayofweek()

	- day of week, 0 - ned, 1 - pon...
	- -1 if date not valid
*/

char xdate::dayofweek() const
{
	tm dtime;

	if (!isdate())
		return -1;
	dtime.tm_year = year - 1900;
	dtime.tm_mon = month - 1;
	dtime.tm_mday = day;
	dtime.tm_hour = 0;
	dtime.tm_min = 0;
	dtime.tm_sec = 1;
	dtime.tm_isdst = -1;
	if (mktime (&dtime) == -1) 
		return -1;
	return dtime.tm_wday;
}


/*
	xdate today();

	- get today date
*/

xdate today()
{
	xdate d;
	
	return d.today();
}


/*
	xdate xdate::today();

	- set date to today
*/

xdate xdate::today()
{
	date d;
	
	getdate (&d);
	set (d.da_year, d.da_mon, d.da_day);

	return *this;
}


/*
	byte mlen (byte month);			

	- get len of month
*/

byte mlen (byte month)
{
	if ((month == 0) || (month > 12))
		return -1;

	return monlen [month-1];
}


/*
	xdate xdate::operator + (dword n);

	- add num to date
*/

xdate xdate::operator + (dword n)
{
	return ntod (dton() + n);
} 


/*
	xdate xdate::operator - (dword n);

	- sub num from date
*/

xdate xdate::operator - (dword n)
{
	return ntod (dton() - n);
} 


/*
	long xdate::operator - (xdate d);

	- sub date from date
*/

long xdate::operator - (xdate d) 
{
	return dton() - d.dton();
} 


/*
	boolean xdate::operator > (xdate d) const;	

	- compare dates
*/

boolean xdate::operator > (xdate d) const
{
	return dton() > d.dton();
}


/*
	boolean xdate::operator < (xdate d) const;	

	- compare dates
*/

boolean xdate::operator < (xdate d) const
{
	return dton() < d.dton();
}


/*
	boolean xdate::operator >= (xdate d) const;	

	- compare dates
*/

boolean xdate::operator >= (xdate d) const
{
	return dton() >= d.dton();
}


/*
	boolean xdate::operator <= (xdate d) const;	

	- compare dates
*/

boolean xdate::operator <= (xdate d) const
{
	return dton() <= d.dton();
}


/*
	boolean xdate::operator == (xdate d) const;	

	- compare dates
*/

boolean xdate::operator == (xdate d) const
{
	return dton() == d.dton();
}


/*
	boolean xdate::operator != (xdate d) const;	

	- compare dates
*/

boolean xdate::operator != (xdate d) const
{
	return dton() != d.dton();
}
