// File from page 485 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: FRAMIS.CPP -- Local overloaded new & delete
#include <stddef.h> // Size_t
#include <fstream.h>
ofstream out("framis.out");

class framis {
  char c[10];
public:
  framis() { out << "framis()\n"; }
  ~framis() { out << "~framis() ... "; }
  void* operator new(size_t);
  void operator delete(void*);
};

const psize = 100; // Number of frami allowed
unsigned char pool[psize * sizeof(framis)];
// Allocation map:
unsigned char alloc_map[psize] = {0};

// Size is ignored -- assume a framis object
void* framis::operator new(size_t) {
  for(int i = 0; i < psize; i++)
    if(!alloc_map[i]) {
      out << "using block " << i << " ... ";
      alloc_map[i] = 1; // Mark it used
      return pool + (i * sizeof(framis));
    }
  out << "out of memory" << endl;
  return 0;
}

void framis::operator delete(void* m) {
  if(!m) return; // Check for null pointer
  // Assume it was created in the pool
  // Calculate which block number it is:
  unsigned long block = (unsigned long)m
    - (unsigned long)pool;
  block /= sizeof(framis);
  out << "freeing block " << block << endl;
  // Mark it free:
  alloc_map[block] = 0;
}

main() {
  framis* f[psize];
  for(int i = 0; i < psize; i++)
    f[i] = new framis;
  new framis; // Out of memory
  delete f[10];
  f[10] = 0;
  // Use released memory:
  framis* x = new framis;
  delete x;
  for(int j = 0; j < psize; j++)
    delete f[j]; // Delete f[10] OK
}
