// File referred to (not printed) on page 204 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: FULLWRAP.CPP -- Fully wrapped file IO
#include "..\5\fullwrap.h"
#include <assert.h>
#include <stdlib.h>
#include <stdarg.h>

File::File(){ f = 0; }

FILE* File::F() {
  assert(f); // Or more sophisticated test
  return f;
}

File::File(const char* path, const char* mode){
  open(path, mode);
}

File::~File() {
  if(f)
    fclose(f);
}

int File::open(const char* path,
         const char* mode) {
  if(f) fclose(f);
  f = fopen(path, mode);
  if(f == NULL) {
    printf("%s: file not found", path);
    exit(1);
  }
  return (int)f;
}

int File::reopen(const char* path,
           const char* mode) {
  f = freopen(path, mode, f);
  if(f == NULL) {
    printf("%s: file not found", path);
    exit(1);
  }
  return (int)f;
}

int File::Getc() {
  return fgetc(F());
}

int File::Ungetc(int c) {
  return ungetc(c, F());
}

int File::Putc(int c) {
  return fputc(c, F());
}

int File::puts(const char* s) {
  return fputs(s, F());
}

char* File::gets(char* s, int n) {
  return fgets(s, n, F());
}

int File::printf(const char* format, ...) {
   va_list argptr;
   int cnt;
   va_start(argptr, format);
   cnt = vfprintf(F(), format, argptr);
   va_end(argptr);
   return cnt;
}

size_t File::read(void* ptr, size_t size,
             size_t n) {
  return fread(ptr, size, n, F());
}

size_t File::write(const void* ptr,
              size_t size, size_t n) {
  return fwrite(ptr, size, n, F());
}

int File::eof() { return feof(F()); }

int File::close() { return fclose(F()); }

int File::flush() { return fflush(F()); }

int File::seek(long offset, int whence) {
  return fseek(F(), offset, whence);
}

int File::getpos(fpos_t* pos) {
  return fgetpos(F(), pos);
}

int File::setpos(const fpos_t* pos) {
  return fsetpos(F(), pos);
}

long File::tell() { return ftell(F()); }

void File::rewind() { ::rewind(F()); }

void File::setbuf(char* buf) {
  ::setbuf(F(), buf);
}

int File::setvbuf(char* buf, int type,
                  size_t sz) {
  return ::setvbuf(F(), buf, type, sz);
}

int File::error() { return ferror(F()); }

void File::Clearerr() { clearerr(F()); }
