#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "extern.h"
#include "local.h"
#include "lines.h"
#include "types.h"

#define OBJECT_BUFFER_SIZE 256
extern BOOL prm_case_sensitive;
extern uint modnumber;

char modname[20];			/* Module name of current module */
int usedfloat = FALSE;
uint maus;
BOOL bigend = TRUE;
uint bitspermau;
char bigendchar;
unsigned long lconfig, maxconfig;
BYTE *bptr;

static BYTE objectbuffer[OBJECT_BUFFER_SIZE]; /* Record buffer */
static long offset;				/* Current offset in file */
static int left;
static BYTE checksum;
static BOOL endofmodule;
static FILE *curfile;
static BYTE putbackchbuf;

void ReadHeader(uint mode);
void CheckSum(uint mode);
void ModEnd(uint mode);
void SetMAUs(uint mode);
void Assign(uint mode);
void PublicSetType(uint mode );
void DateTime(uint mode);

/* List of defined MUFOM records.  Bit defs:
 *  TE_REPORT: Generate a warning message for this record
 *  TE_IGNORE: Ignore the record
 */
static TYPEXEC main_exec_list[] = {
	{ "AD",TE_REPORT - TE_REPORT, SetMAUs },
	{ "AS",TE_REPORT - TE_REPORT, Assign },
	{ "AT",TE_REPORT - TE_REPORT, SetType },
	{ "CO",TE_REPORT - TE_REPORT, Comment },
	{ "CS",TE_REPORT - TE_REPORT, CheckSum },
	{ "DT",TE_REPORT - TE_REPORT, DateTime },
	{ "LD",TE_REPORT - TE_REPORT, EnumeratedData },
	{ "LR",TE_REPORT - TE_REPORT, ReadFixup },
	{ "MB",TE_REPORT - TE_REPORT, ReadHeader },
	{ "ME",TE_REPORT - TE_REPORT, ModEnd },
	{ "NI",TE_REPORT - TE_REPORT, PublicDefinitions },
	{ "NN",TE_REPORT - TE_REPORT, LocalDefinitions },
	{ "NX",TE_REPORT - TE_REPORT, ExternDefinitions },
	{ "SA",TE_REPORT - TE_REPORT, SectionAlignment },
	{ "SB",TE_REPORT - TE_REPORT, SectionStart },
	{ "ST",TE_REPORT - TE_REPORT, SectionDefinitions },
	{ "TY",TE_REPORT - TE_REPORT, ReadType },
	{ "\0\0", 0, 0 }
} ;
long theoffset (void)
{
	return(offset-left);
}
/*
 * Quit with a message if a bad record is encountered
 */
void BadObjectFile(void)
{
 	fatal("Bad Object module %s near file offset 0x%x",
		modname,theoffset());
}
void CheckForPeriod(void)
{
  if (ReadChar() != '.')
		BadObjectFile();
}
BOOL CheckForComma(BOOL musthave)
{
	BYTE rv = ReadChar();
	if (rv == ',')
		return(TRUE);
	if (musthave || rv != '.')
		BadObjectFile();
	return(FALSE);
}
/*
 * Perform  function
 */
static void ReadHeader(uint mode)
{
	BYTE rv;
	if ((rv = ReadChar()) != 'I')
		usedfloat = TRUE;
	while ((rv) != '.' && rv != ',') 
		rv = ReadChar();
	if (rv == ',') {
  	ReadString(modname,20);
		CheckForPeriod();
	}
}
static void ModEnd(uint mode)
{
	CheckForPeriod();
	FixLines();
	endofmodule = TRUE;
}
static void Comment(uint mode)
{
	int level = 0;
	level = ReadNumber(0);
	CheckForComma(FALSE);
	if (level ==0x100) {
		ReadString(0,0);
		if ( mode == SCAN)
			endofmodule = TRUE;
	}
	if (level == 0x104) {
		ReadNumber(2);
		lconfig = ReadNumber(8);
		maxconfig |= lconfig;
	}
	else if (level == 0x105) {
		char buf[100];
		ReadString(buf,100);
		EnterLineFile(buf);
	}
	else
		ReadString(0,0);
	CheckForPeriod();
}
static void CheckSum(uint mode)
{
	BYTE lchecksum, rv;
	rv = ReadChar();
	if (rv != '.') {
		BYTE achecksum;
		putbackch(rv);
		achecksum = checksum;
		lchecksum = ReadNumber(2);
		if ((lchecksum^achecksum) & 0x7f)
 			fatal("Bad checksum, Object module %s near file offset 0x%x",
				modname,theoffset()-2);
		CheckForPeriod();
	}
	checksum = 0;
}
static void SetMAUs(uint mode)
{
	static BOOL firsttime = FALSE;
	if (!firsttime) {
		firsttime = TRUE;
		while (ReadChar() != '.');
		return;
	}
	maus = 4;
	bigend = TRUE;
  bitspermau = ReadNumber(0);
	if (!CheckForComma(FALSE))
		return;
	maus = ReadNumber(0);
	if (!CheckForComma(FALSE))
		return;
	bigend =  ((bigendchar = ReadChar()) != 'L');
	CheckForPeriod();
}
static void Assign(uint mode)
{
	char ch = ReadChar();
	switch(ch) {
		case 'I':
			PublicSetAddress();
			break;
		case 'G':
			GotoSetAddress(mode);
			break;
		case 'S':
			SectionSetSize();
			break;
		case 'N':
			LocalSetAddress();
			break;
		default:
			BadObjectFile();
	}
}
static void DateTime(uint mode)
{
	while (ReadChar() != '.') ;
}
/*
 * Read data into the objectbuffer
 */
void ReadFile(void)
{
	if (!feof(curfile)) {
		left = fread(objectbuffer,1,OBJECT_BUFFER_SIZE,curfile);
		offset += left;
		if (left < 0)
			fatal("File read error in module %s",modname);
		bptr = objectbuffer;
	}
}
/*
 * Read a char & do checksumming
 */
BYTE ReadCharNOCS(void)
{
	BYTE rv;
	if (putbackchbuf) {
		rv = putbackchbuf;
		putbackchbuf = 0;
		return(rv);
	}
	while (TRUE) {
		if (!left) {
			ReadFile();
			if (!left) 
				fatal("missing modend statement in module %s", modname);
		}
		left--;
		rv = *bptr++;
		if (rv >31)
			break;
	}
	return(rv);
}
BYTE ReadChar(void)
{
	BYTE rv = ReadCharNOCS();
	if (rv > 31)
		checksum += rv;
	return(rv);
}
void putbackch(BYTE ch)
{
	putbackchbuf = ch;
	if (ch > 31)
		checksum-=ch;
}
long ReadNumber(uint digits)
{
	int i;
	long rv = 0;
	if (!digits)
		digits = 200;
	for (i=0; i < digits; i++) {
		BYTE ch = ReadChar();
		if (!isxdigit(ch)) {
			putbackch(ch);
			break;
		}
		rv *= 16;
		ch -= '0';
		if (ch > 9)
			ch -= 7;
		rv += ch;
	}
	return(rv);
}
void ReadString(char *buf,int len)
{
	int slen = (int)(ReadNumber(2)),i;
	int rlen = slen > len-1 ? len-1 : slen;
	for (i=0; i<rlen; i++)
		if (prm_case_sensitive)
			buf[i] = ReadChar();
		else
			buf[i] = toupper(ReadChar());
	if (rlen >= 0)
		buf[rlen] = 0;
	else
		rlen = 0;
	for (i=rlen; i < slen; i++)
		ReadChar();
}
	
	
/*  
 * Read and execute an object record
 */
static uint ReadObjectRecord(uint mode)
{
	uint command;
	TYPEXEC *p = main_exec_list;
	command = ReadChar() + (ReadChar() << 8);

  /* Search the dispatch table */

  while (p->select[0]) {
    if (*((uint *)p->select) == command) {
			uint temp = p->flags;
      if (temp & TE_REPORT)
				if (mode == SCAN)
          printf("Record type %c%c ignored at offset 0x%lx in module %s\n",p->select[0], p->select[1],theoffset()-2 , modname);
      if (temp& TE_ERROR)
        return(MODERR);
			if ((temp & TE_IGNORE) || !p->run)	/* Undefined functions are ignored, better have the TE_REPORT bit set!!! */
			  return(MODIGNORE);

      /* Dispatch the function */
      p->run(mode);
      break;
    }
		p++;
  }
  /* Return an error if not found */
  if (p->select[0] == 0)
    return(MODERR);

  /* Return the record type if was found */
  return(command);
}
/*
 * Read in a module
 */
uint ReadModule(FILE *infile, char *name, int mode, BOOL sof)
{
  uint temp;
  offset = 0;
	checksum = 0;
	modname[0] = 0;
	if (sof)
		left = 0;
	curfile = infile;
	endofmodule = FALSE;
	lconfig = 0;

  modname[0] = 0;
  while (!endofmodule) {
    switch(temp = ReadObjectRecord(mode)) {
      case MODERR:
				BadObjectFile();
      case MODQUIT:
			  endofmodule = TRUE;
				break;
	  }
	}
  /* Module names are collected in pass 1, already resident at the start */
  /* of pass 2 */
	TypeModuleRundown(mode);
	LineModuleRundown(mode);
  PublicModuleRundown(mode);
	ExternModuleRundown(mode);
	LocalModuleRundown(mode);
  SectionModuleRundown(mode);
  return(temp);
}