                     ------------------------------------
                     USERS MANUAL FOR THE KGRAPH SOFTWARE
                     ------------------------------------

                        Version 1.01 - Copyright 1992
                          Solar Terrestrial Dispatch


                                   CONTENTS
                                   --------

                                 INTRODUCTION
                       SELECTING DATES OF DATA TO GRAPH
                THREE-DIMENSIONAL GRAPHICS FUNCTIONS OF KGRAPH
            PRODUCING HIGH-DENSITY K-INDEX DATA PLOTS USING KGRAPH
USING THE HIGH-DENSITY DATA PLOTS TO DETERMINE RECURRENCE AND OTHER PHENOMENA
                  * New Sections Inserted Here - See Below *
                     EXITING KGRAPH AND RETURNING TO DOS


                 New Sections to this Manual for Version 1.01
                 --------------------------------------------

         SWITCHING KGRAPH TO USE 27 OR 28 DAY SOLAR ROTATIONAL CYCLES
       SAVING SCREEN IMAGES TO GIF-IMAGE OR POSTSCRIPT FORMATTED FILES
                   VIEWING A-INDICES AND K-INDICES TOGETHER
                SETTING DEFAULTS USING THE BCAST.INI ACRONYMS


INTRODUCTION

     The daily Solar Geophysical Data Broadcast (SGDB) reports released by
the Solar Terrestrial Dispatch contain a large amount of information
regarding the state of solar and geophysical activity.  In the past, the only
software which permitted manipulation of this data was the BCAST software
program.  However, this software lacks the ability to chart and track the
geomagnetic K-index information.

     The geomagnetic K-index rates geomagnetic activity on a scale between 0
(very quiet) and 9 (very disturbed).  The index is based on an open-ended
quasi-logarithmic algorithm and is measured once every three hours by
magnetic observatories around the world.  Generally, K-indices greater than 5
indicate major to severe geomagnetic storm conditions.  K-indices of 4 or
less indicate active to quiet conditions.

     The geomagnetic K-index is very important to persons such as radio
communicators who rely on the geomagnetically-sensitive ionosphere to
transmit and receive radio signals.  Quiet levels of geomagnetic activity
usually produce very good and stable radio communications.  Active levels
of geomagnetic activity can begin to introduce minor instabilities in radio
communications such as rapid fading or flutter and increased directionality.
Minor geomagnetic storming (K-indices of 5) and particularly major
geomagnetic storming (K-indices of 6) can significantly impair the
propagation of radio signals through the ionosphere.  Severe geomagnetic
storming (K-indices of 7 or more) can produce radio blackout conditions for
many middle, high, and polar latitude regions.  The level of geomagnetic
activity is therefore a very important parameter which must be considered
when used in conjunction with radio communications.

     K-indices are also very important to persons watching for auroral
activity.  Major to severe storm level excursions of the geomagnetic K-index
is often associated with visible levels of auroral activity over the lower
latitude regions.

     People who are interested in attempting to forecast the level of
geomagnetic activity into the future will find detailed records of K-indices
extremely valuable.  Solar phenomena which can influence geomagnetic activity
for several solar rotations (ex. such as stable coronal holes) can be
identified through records of K-index geomagnetic activity.  Knowing when
enhanced geomagnetic activity has occurred in the past enables one to
determine when it might occur in the future, since the Sun rotates
approximately once every 27 days.

     KGRAPH is a powerful program designed to exploit the detailed K-index
information which is stored in your BCAST database file ("datasets.dat").  It
will examine and display K-index information in useful graphical detail using
the power of your computers VGA graphics system.

     KGRAPH will produce three-dimensional graphs of geomagnetic activity in
a variety of formats.  It will graph either the geomagnetic Boulder K-Index
(from Boulder, Colorado) or the estimated Planetary K-Index information which
is stored in your database file.  The three-dimensional graphs are very
useful for analyzing episodes of activity relative to neighboring periods of
activity.  It is also visually impressive and easy to interpret.

     KGRAPH will produce detailed high-density VGA-quality graphical plots of
Boulder or Planetary K-Index data.  These graphical plots of activity let you
easily determine the cyclical behavior of geomagnetic activity.  As much as
eight solar rotations worth of K-index data can be viewed on-screen at one
time.  This is equivalent to 216 days worth of data, or 1,728 three-hour
interval periods.  The plots also indicate days in which major flare activity
occurred, or days where interplanetary disturbances arrived and produced
sudden magnetic impulses.  These features can be used to help you determine
which episodes of activity may have been flare-induced.  In addition, the
plotting method employed by KGRAPH lets you visually determine, quickly and
easily, periods of activity which were associated with major or severe
storming.

     Overall, KGRAPH is a powerful visual aid package intended to exploit
the large amount of geomagnetic information contained in the BCAST-maintained
database file.  It requires the BCAST-maintained database file "datasets.dat"
to operate.  Registration of the BCAST software program is therefore
manditory for anyone who wants to use KGRAPH (see the file "REGISTER.DOC" for
more information).  For those who have already registered the BCAST software,
KGRAPH can immediately be used to examine the large base of K-index
information archived in your database file.


SELECTING DATES OF DATA TO GRAPH

     Each of the graphical functions supported by KGRAPH first ask you to
type in the date of the last dataset to display on-screen.  By default, when
you first start up KGRAPH, the date of the last dataset in your database file
will be displayed.  If this is the date you wish to use, simply press ENTER.
If the default date is not what you want to use, type in the appropriate date
(using the given format) and press ENTER.  Thereafter, the default date
becomes the last valid date you typed in.


THREE-DIMENSIONAL GRAPHICS FUNCTIONS OF KGRAPH

     KGRAPH provides eight three-dimensional graphics functions to display
K-index data in a variety of ways.  These eight functions are described
below:

        1.  KGRAPH can produce a three-dimensional graph of Boulder K-Indices
     U      with dates descending from the bottom of the screen to the top
 B   N      of the screen.  That is, the date of the data at the "front" of
 O   S      the three-dimensional graph would be the most recent date
 U   O      graphed.
 L   R
 D   T  2.  KGRAPH will generate a three-dimensional graph of Boulder
 E   E      K-Indices with dates ascending from the bottom of the screen to
 R   D      the top of the screen.  In this case, the date of the data at the
            front of the graph would be the oldest date on-screen.  The most
 K          recent date would be at the "back" of the graph, behind the rest.
 I
 N      3.  KGRAPH will sort the Boulder K-Index data and graph the data in
 D          three-dimensional format in ascending order.  Sorting is done by
 E          simply summing the eight three-hour K-index values for each day
 X   S      and sorting the summed values.  The resulting graph displays the
     O      quietest days at the front of the graph and the most disturbed
 D   R      days at the end of the graph.
 A   T
 T   E  4.  KGRAPH will sort the Boulder K-indices and graph the data in
 A   D      descending order.  In this case, the graph shows the quietest
            days at the end of the graph and the most disturbed days at the
            front of the graph.


     U  5.  KGRAPH will generate three-dimensional graphs of the estimated
 P   N      planetary geomagnetic K-indices in order of descending dates.
 L   S      This graph is identical to #1 above, except the K-indices used
 A   O      are the estimated planetary data as opposed to the Boulder data.
 N   R
 E   T  6.  KGRAPH will generate graphs of planetary K-indices in order of
 T   E      ascending dates.  This graph functions the same as #2 above,
 A   D      except planetary data is used.
 R
 Y      7.  KGRAPH will sort the estimated planetary (global) geomagnetic
     S      K-indices in ascending order.  Graphs of these sorted indices
 D   O      are identical to function #3 given above, except planetary
 A   R      K-indices are used.
 T   T
 A   E  8.  KGRAPH will sort the estimated planetary K-indices in descending
     D      order.  These three-dimensional graphs are identical to the
            graphs produced by function #4, except planetary data is used.


The purpose of producing three-dimensional graphs in orders of ascending and
descending dates is to change the viewing angle of the display.  Since the
graphed data is three-dimensional, producing graphs in descending or
ascending order may aid in "unblocking" areas which were previously blocked
from view.  For example, a day which has high K-indices will will produce
three-dimensional graph lines which may block out data behind the date with
the high K values.  By using these functions to view the data in a different
order, you may be able to see what is behind the three dimensional "wall" of
high K-indices.

     While viewing these three-dimensional graphs, you can instruct KGRAPH to
redraw the data in a "slow mode".  To accomplish this, press the "S" key to
toggle between the fast and slow modes while viewing graphs of data.  While
in the slow mode, KGRAPH will redraw the screen one date at a time, pausing
in-between dates and waiting for a keypress.  Using this feature, you can
carefully examine each date of data.  To view the next date of data, press
any key on your keyboard.  KGRAPH will respond by drawing the next series of
K-indices, pausing after the next group of eight has been drawn.  After all
of the indices have been drawn on-screen, you can switch back to the "fast
mode" by pressing "S" again.

     Version 1.01 of KGRAPH contains two additional features which can be
invoked by pressing the "G" and/or "P" keys.  Pressing "G" forces KGRAPH to
create a GIF image file of the screen you are currently viewing.  Pressing
"P" forces KGRAPH to create a Postscript-compatible screen image file which,
when sent to a postscript-compatible printer (such as a laser printer), will
produce a copy of the screen image on paper.  See the section on "Saving
Screen Images" for more information.

     To exit back to the main menu, press any key other than "S", "G", or
"P".


PRODUCING HIGH-DENSITY K-INDEX DATA PLOTS USING KGRAPH

     The second and third-last options of the main menu engage powerful
utilities for viewing large quantities of K-index data on-screen at one time.
One option produces a high-density plot of Boulder K-Index data.  The other
main menu option generates a high-density plot of estimated Planetary
(global) geomagnetic K-Index data.  Both of these functions produce graphs
with identical formats.  The only difference is the data which is used.
Boulder K-Index data is generally valid for middle latitude regions near
Boulder Colorado. The Planetary K-indices represent estimated global levels
of geomagnetic activity and may be more reliable characteristics of global
activity.

     The high-density plots use the high-resolution of the VGA graphics
system to produce easily interpreted high-quality graphs of contiguous
activity for up to eight consecutive solar rotations.  As much as 1,728 data
points may be plotted on-screen at one time for analysis.

     The structural format of these high-density graphical plots is described
as follows.  Up to eight horizontal rows of the screen are used to graph
the data.  Each horizontal group of graphed K-indices represents one solar
rotation (approximately 27 days).

     Each horizontal segment of data is divided into 26 days and each of
these days are labelled.  The month of the first date encountered on each
horizontal row is displayed adjacent to the horizontal row.  Each horizontal
row is composed of a series of vertical lines which depict the K-indices
being graphed.  A sample ASCII representation of one day (eight vertical
lines) of K-index data follows below:


                             _o__o__o_
          F               _o__|__|__|_
          E            _o__|__|__|_*#*
          B         _o__|__|__|__|_*#*    /-<-- Next day of data starts
                 _o__|__|__|__|_*#**#*  /       on this boundary
               o__|__|__|__|__|_*#**#*_\/_____________________
               |         1  4          |         1  5         |


Each vertical line (with a "dot" on top) represents one K-index value.
K-Indices are defined as follows:


                               _o__o__o__o_*#*
                            _o__|__|__|_*#**#*
                         _o__|__|__|_*#**#**#*
                      _o__|__|__|__|_*#**#**#*
                   _o__|__|__|__|_*#**#**#**#*
                 o__|__|__|__|__|_*#**#**#**#*
                /\ /\ /\ /\ /\ /\ /\ /\ /\ /\
                || || || || || || || || || ||
                || || || || || || || || || ||
                0  1  2  3  4  5  6  7  8  9
                      K - I N D I C E S

This method of graphing K-indices has several notable advantages over
straight linear graphing.  First, the graph line is effectively compressed in
vertical extent, allowing a larger number of horizontal segments to be fit
on-screen at one time.  Second, determination of the value of each K-index
point is easily accomplished by counting the horizontal divisions.  And
finally, visual determination of major to severe storm periods is easily
accomplished simply by examining which graph lines are "filled in" (see
K-indices 6 through 9 in the graph above).

     KGRAPH significantly enhances the visibility of major storm periods by
"filling in" these intervals with the color red.  This easily distinguishes
major storm periods from active or quiet periods when viewing the data
on-screen.

     Also, KGRAPH color-codes the dates of the data as follows:


DATE COLOR:     RED = One or more Major Flares occurred on this date.
             YELLOW = A Sudden Magnetic Impulse (SI) occurred on this date.
            MAGENTA = Both a Sudden Magnetic Impulse AND a Major Flare(s)
                      occurred on this date.
              WHITE = No Major Flares or Sudden Magnetic Impulses occurred.


     This scheme for identifying days where major flares occurred is useful
when attempting to determine which periods of geomagnetic activity may have
been influenced by major flaring.  This is particularly valuable when
searching for recurrent geomagnetic patterns caused by stable coronal holes.
By ignoring the periods of activity which may have been enhanced by major
flaring, you can better identify the recurrent patterns attributed to coronal
holes.  When looking for flare-induced enhancements in geomagnetic activity,
keep in mind that increases in geomagnetic activity typically do not occur
until after approximately 24 to 48 hours (up to possibly 72 hours) from the
onset of the major flare.  It usually takes this long for the plasma cloud to
traverse the distance from the Sun to the Earth.  Also, not all major flares
produce enhancements in geomagnetic activity.  In fact, only a relatively
small percentage are geoeffective.  However, knowing which dates are
associated with major flares helps to eliminate uncertainties when analyzing
the recurrent patterns of geomagnetic activity.

     The identification of days when sudden magnetic impulses occur is very
useful during the analysis of the high-density data plots.  Since sudden
magnetic impulses are produced by the arrival of interplanetary shockwaves
(such as those which are spawned by major flares), it is possible to
determine which episodes of activity were produced by the arrival of
interplanetary shocks.  Coronal holes are not usually associated with sudden
magnetic impulses.  The enhancements in geomagnetic activity produced by well
placed solar coronal holes are most often gradual in nature.


USING THE HIGH-DENSITY DATA PLOTS TO DETERMINE RECURRENCE AND OTHER PHENOMENA

     To use the high-density data plots properly, you must keep in mind that
each horizontal row of data represents one solar rotation.  Since eight rows
may be stacked on top of one another, searching for recurrent patterns is as
simple as scanning vertically down the rows of data.  Periods of recurrent
enhancements in geomagnetic activity will be discerned as consistent
increases in K-indices over periods of between 2 or more solar rotations
(which is displayed on-screen as two or more horizontal rows spaced
vertically above and below each other).

     Since many coronal holes are constantly evolving and changing in
structure, shape, and spatial extent, some deviations from the above may be
observed.  For example, if a coronal hole which enhances geomagnetic activity
during one solar rotation expands in size or becomes elongated in an
east-west direction, enhancements in geomagnetic activity may be observed a
few days earlier or later than would be expected if the coronal hole remained
in the same position and retained the same spatial characteristics.  The
amplitude of the recurrent enhancement may also differ quite considerably
from one solar rotation to the next.

     As we continue to decline from the solar maximum toward the solar
minimum, coronal hole stability and geoeffectiveness will increase which will
make identification and prediction of recurrent periods easier using the
high-density plot functions of KGRAPH.

     Recurrent phenomena is not limited to enhancements of geomagnetic
activity.  Indeed, recurrent quiet intervals are also frequently observed.
In fact, these quiet intervals are often easier to discern than recurrent
enhancements of activity due to coronal holes.  The same method of
identifying recurrent enhancements of activity applies to the identification
of recurrent quiet periods.  Simply scan the high-density graphs of K-index
data vertically between the horizontal rows of data.  Consistent and
consecutive periods of low K-indices are typically associated with recurrent
quiet intervals.  These are often the best periods for radio communicators,
since low levels of geomagnetic activity can support very stable and reliable
ionospheric communications.

     Since active solar regions responsible for major flares also rotate with
periods of approximately 26-28 days, it is possible to determine potential
future influences of energetic active solar regions on the geomagnetic field.
This is less reliable than determining recurrence for coronal holes since
active regions are much more dynamic and change more rapidly than coronal
holes.  Although most solar regions fail to survive two solar rotations, and
still fewer remain energetic enough to affect terrestrial geomagnetic
activity over two rotations, the odd ones do and may be capable of producing
recurrent enhancements in geomagnetic activity if they remain energetic for
that length of time.

     Finally, these high-density graphs may also be used to help determine
periods of enhanced auroral activity.  Since auroral activity is tied closely
to levels of geomagnetic activity, it is often possible to determine the
potential visibility of future auroral activity simply by determining
recurrent patterns of geomagnetic activity.  K-indices of six or more are
typically required before auroral activity becomes visible over widespread
areas.  K-indices of 7 or more may produce visible auroral activity over the
lower latitude regions.  To be most accurate in making predictions, it is
important to remember the influence of lunar phase on visible levels of
auroral activity.  However, since the moon also has a period similar to the
solar rotation period of 27 days, the phase of the moon should be
approximately the same between vertical rows of the high density graphs.
This serves to improve the usefulness of this data, even beyond what has
already been discussed.


SWITCHING KGRAPH TO USE 27 OR 28 DAY SOLAR ROTATIONAL CYCLES

     Version 1.01 of KGRAPH lets you select the length of the solar
rotational cycle you wish to use when displaying the high-density geomagnetic
K-index data plots. By pressing "7", KGRAPH selects 27-day solar rotational
cycle intervals.  By pressing "8", KGRAPH uses 28-day solar cycle intervals.
This additional flexibility is useful when analyzing which cycle interval
yields the best alignment with recurrent activity.

     When displaying the graphs of geomagnetic activity over many solar
rotations, you will notice that the flow of dates from the left to the right
is contiguous (provided you do not have any missing datasets in your
database).  You may also notice that the dates between the end of one
horizontal row and the beginning of the next horizontal row are NOT
contiguous.  In short, you may notice that one or two days are skipped
between the end of one graph line and the beginning of the next.  This
peculiarity is required in order to ensure that each horizontal graph of data
is properly aligned to coincide with the solar rotation period of 27-28 days.
The number of days skipped at the end of each horizontal row is dependent on
whether you have set up KGRAPH to display the K-index data using 27 or 28 day
solar cycles.  If KGRAPH is set up to display 27 day cycles, only one day is
skipped at the end of each graphed row of K-indices.  If you select to
display 28 day cycles, two days will be skipped at the end of each row.

     Also, version 1.01 of KGRAPH also lets you shift the last row of data to
the left by 14 days by pressing the "S" key (to "S"hift the screen).  In
older versions of KGRAPH, a full eight solar rotations of data were
displayed.  Due to the inability of KGRAPH to fit a full 27 or 28 days of
data on one row of graphed data (only 26-days per row can be displayed), it
was much more difficult to determine the possible influence of recurrence
during intervals 24 to 48 hours into the future because these dates were
hidden from view in order to maintain proper rotational cycle alignment.

     In version 1.01, you are given the option to display eight full solar
rotations, or 7.5 solar rotation.  Shifting the screen to display 7.5 solar
rotations lets you see the data which was previously hidden at the end of
each row and lets you determine possible imminent influences of recurrent
activity.

     The "S" key acts as a toggle.

     To exit the high-density K-index graphs of geomagnetic activity, simply
press any key.


SAVING SCREEN IMAGES TO GIF-IMAGE OR POSTSCRIPT FORMATTED FILES

     Version 1.01 of KGRAPH has the ability to save screen images to disk
files.  KGRAPH supports two types of image files: GIF formatted image files
and Postscript formatted image files.

     GIF (or Graphical Image Format) files are one of the most popular types
of image formats in use today.  There are numerous GIF image viewing software
packages available from other software vendors which can be used to display
the images saved in this format.

     To convert any of the VGA graphical screens produced by KGRAPH into a
GIF image file, press the "G" (for "G"IF) key while viewing the graphic
screens.  By default, KGRAPH will store the image in a file named
"screen.gif" in your current working directory.

     If you have a laser printer capable of handling Postscript-formatted
files, you can create a Postscript compatible file which can be printed on
your Postscript printer.  To create a Postscript compatible copy of the VGA
screens, press the "P" (for "P"ostscript) key while viewing any of the
graphic screens generated by KGRAPH.  By default, KGRAPH will store the image
in a Postscript file named "screen.ps" in your current working directory.
Postscript files generated in this manner are rather large in size (around
500K) due to the required conversion from a binary bit-mapped format to an
ascii bit-mapped format.

     KGRAPH lets you monitor the progress of the conversion to either GIF or
Postscript formats.


VIEWING A-INDICES AND K-INDICES TOGETHER

     While viewing the high-density geomagnetic K-index data plots, you can
force KGRAPH to redraw the display so all of the dates are replaced with
the appropriate A-indices.  This useful feature lets you display both K-index
and A-index information on-screen at the same time.  This is a powerful
feature when used to search for episodes of recurrent coronal-hole related
activity.

     To display the A-index data, simply press the "A" (for "A"-Indices) key
while viewing the high-density data plots.  This key acts as a toggle.  Press
it a second time to replace the A-indices with the corresponding dates.  The
default is to display the dates.  However, you can change the default by
inserting the "AINDEX-SHOW" acronym in the BCAST.INI initialization file (see
below for more information regarding the acronym definitions).


SETTING DEFAULTS USING THE BCAST.INI ACRONYMS

     KGRAPH now supports numerous default settings through the BCAST.INI
initialization file.  Each time KGRAPH is executed, it searches for the
BCAST.INI file (using either the current directory or the path defined by the
environment variable "BCAST") and processes it if it exists.

     Version 1.02 of the BCAST software package includes support for numerous
additional acronyms to control the behavior of KGRAPH.  These acronyms are
described below.

 "CYCLES 27"    - Instructs KGRAPH to display the high-density geomagnetic
                  K-index data plots using 27-day cycles.

 "CYCLES 28"    - Instructs KGRAPH to display the high-density geomagnetic
                  K-index data plots using 28-day cycles.

 "SHIFT-ON"     - Forces KGRAPH to shift the last plotted high-density
                  geomagnetic K-index line left 14-days to simplify detection
                  of imminent recurrent periods.

 "SHIFT-OFF"    - Instructs KGRAPH to display eight full solar rotations of
                  geomagnetic K-index data.

 "GIF-FILENAME" - Sets the default filename to save screen images to when
                  processing screen images into GIF image files.  The
                  predefined name is "screen.gif".  The parameter following
                  this acronym may also include a full path name.

 "PS-FILENAME"  - Sets the default filename to save screen images to when
                  processing screen images into Postscript-compatible image
                  files.  The predefined name is "screen.ps".  The parameter
                  following this acronym may also include a full path name.

 "IMAGE-COLOR"  - (or, "IMAGE-COLOUR")  Forces KGRAPH to generate full-color
                  GIF image or Postscript formatted files.  Note that
                  Postscript files generated in full color will likely be
                  dithered on two-color (B & W) Postscript printers.

"IMAGE-NOCOLOR" - (or, "IMAGE-NOCOLOUR")  Forces KGRAPH to generate black and
                  white (black background and white foreground) GIF or
                  Postscript images when either the "G" or "P" keys are
                  pressed while viewing graphic images.

"IMAGE-INVERSE" - Instructs KGRAPH to produce black and white images
                  (inversed, with a WHITE background and BLACK foreground)
                  when either the "G" or "P" keys are pressed.  In order for
                  this acronym to have any effect, the "IMAGE-NOCOLOR"
                  acronym must precede this acronym.  This is usually the
                  preferred mode to use when saving images that are to be
                  printed out on two-color (black and white) printers.

"IMAGE-NOINVERSE"-This final acronym forces KGRAPH not to inverse screen
                  images.  It is, of course, the opposite of "IMAGE-INVERSE".

"AINDEX-SHOW"   - Forces KGRAPH to display (by default) A-indices instead of
                  (in place of) the dates when viewing the high-density
                  geomagnetic K-index data plots.

"AINDEX-NOSHOW" - Forces KGRAPH to display the dates instead of the A-indices
                  when viewing the high-density data plots.

     Although the definitions above were all in upper-case lettering, KGRAPH
will process the acronyms in either upper, lower, or mixed case.

     Consult the "BCAST.INI" file for examples of how these acronyms are
used and for a full description of all of the available acronyms.


EXITING KGRAPH AND RETURNING TO DOS

     To return to DOS at the main menu of KGRAPH, either select the "Exit
Program" function of KGRAPH, press the associated menu letter ('K'), or press
the ESCape key.

