/*
Convert database ASCII file records to ICF PRN format.
Copyright by M.Arnow 1988.
All rights reserved.
*/
#include <stdio.h>
#include <dir.h>
#include <string.h>

void main()
{
register int i,j,k;
char in_name[80],out_name[80];
char path[80],ut[80],drive[3],dir[66],file[9],ext[5];
char answer[80],flag;
unsigned char a,*combo,*buffer,*b[19],*ptr;
FILE *in,*out,*util;
int fields,wide[50],ln[3],w[3],fn,t_width;

printf("\n\
Program to convert ASCII output files of database programs into ICF PRN files.");

printf("\n\n\n\
This program should be used if the ASCII file uses one line for each record.\n\n\
Each field from the input file will become a line in the PRN file.  You have\n\
the option of combining the first two or three fields into the first line of\n\
the PRN file.\n");

printf("\nInput file name: ");
scanf("%s",in_name);
in = fopen(in_name,"r");
if(!in)
	{
	printf("\nCan't open %s.\n",in_name);
	exit(1);
	}
printf("Output file name: ");
scanf("%s",out_name);
fnsplit(out_name,drive,dir,file,ext);
fnmerge(ut,drive,dir,file,".PRN");
out = fopen(ut,"w");
if(!out)
	{
	printf("\nCan't open %s\n",path);
	exit(1);
	}

printf("\nHow many fields per record of input file (Max. fields is 50)? ");
scanf("%d",&fields);
if(fields<=0 || fields>50)
	{
	printf("\nRange error.\n");
	exit(1);
	}

printf("\n");
for(i=0;i<19;++i) wide[i] = 0;
for(i=0,t_width=0;i<fields;++i)
	{
	printf("How many characters wide is a field #%d (Max. width is 100)? ",i+1);
	scanf("%d",&wide[i]);
	if(wide<=0 || wide[i]>100)
		{
		printf("\nRange error.\n");
		exit(1);
		}
	t_width += wide[i];
	}

do
	{
	flag = 0;
	printf("\nDo you wish to combine fields 1,2, and optionally 3 into one line (Y/N)? ");
	scanf("%s",answer);
	if(answer[0]=='y' || answer[0]=='Y') flag = 1;
	if(answer[0]=='n' || answer[0]=='N') flag = -1;
	} while(!flag);
if(flag==1)
	{
	printf("Enter the fields in the order you want to appear  in line 1.\n");
	for(i=0;i<2;++i)
		{
		printf("    Entry %d is field: ",i+1);
		scanf("%d",&ln[i]);
		if(ln[i]>3)
			{
			printf("\nRange error.\n");
			exit(1);
			}
		}
	printf("    Entry 3 is field (quit=0): ");
	scanf("%d",&ln[i]);
	if(ln[i]>3)
		{
		printf("\nRange error.\n");
		exit(1);
		}
	if(!ln[i]) fn = 2;
	else fn = 3;

	for(i=0;i<fn;++i) --ln[i];
	}

printf("\nWriting file %s\n\n",ut);

/* Allocate input buffer. */
buffer = (unsigned char *) malloc(fields*t_width+2);
if(!buffer)
	{
	printf("Not enough memory for file input buffer.\n");
	exit(1);
	}
combo = (unsigned char *) malloc(fields*(wide[0]+wide[1]+wide[2])+2);
if(!combo)
	{
	printf("Not enough memory for file input buffer.\n");
	exit(1);
	}

j = 0;
for(;;)
	{
	ptr = fgets(buffer,t_width+2,in);
	if(!ptr) break;
	if(flag==1)
		{
		switch (ln[0])
			{
			case 0: i = 0; break;
			case 1: i = wide[0]; break;
			case 2: i = wide[0]+wide[1]; break;
			}
		strncpy(combo,&buffer[i],wide[ln[0]]);
		combo[wide[ln[0]]] = 0;

		switch (ln[1])
			{
			case 0: i = 0; break;
			case 1: i = wide[0]; break;
			case 2: i = wide[0]+wide[1]; break;
			}
		strncat(combo,&buffer[i],wide[ln[1]]);
		j = wide[ln[0]] + wide[ln[1]];
		if(fn==3)
			{
			switch (ln[2])
				{
				case 0: i = 0; break;
				case 1: i = wide[0]; break;
				case 2: i = wide[0]+wide[1]; break;
				}
			strncat(combo,&buffer[i],wide[ln[2]]);
			j += wide[ln[2]];
			}
		fprintf(out,"%s\n",combo);
		printf("%s\n",combo);
		k = fn;
		}
	else
		{
		k = 0;
		j = 0;
		}
	for(i=k;i<fields;++i)
		{
		strncpy(combo,&buffer[j],wide[i]);
		combo[wide[i]] = 0;
		fprintf(out,"%s\n",combo);
		printf("%s\n",combo);
		j += wide[i];
		}
	}

fclose(out);
free(buffer);
free(combo);
}

