//================================================================
// nB (nano Base)
// Copyright (c) 1996   Daniele Giacomini
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
// USA.
//
//================================================================
// Send your comments, suggestions, bug reports and english text
// corrections to:
//
// Daniele Giacomini
// Via Turati, 15
// I-31100 Treviso
// Italy
//
// daniele@system.abacom.it
//
//================================================================
// - ATTENTION -
//
// This is a PURE CA-Clipper 5.2 code!
//
// No external libraries are used.
//
//================================================================
// #IFDEF - IFNDEF organisation.
//
// If RUNTIME is defined, the source is compiled using less code,
// enough to make a run time interpreter
//
// If RDD is defined, all Replaceable database drivers are
// linked with nB, otherwise, only DBFNTX and DBFNDX are
// included.
//
// If LINK is defined, the source is compiled using less code,
// enough to make an object to link with a macro to be compiled
// to generate a .EXE file.
//
//================================================================
// Source file organisation and sequence.
//
// - xxxxxxxx.ch files inclusion.
//
// - Library request.
//
// - General purpose #define.
//
// - #define used inside functions.
//
// - global static variables definition.
//
// - static functions:
//
//   - nB()       Main function.
//
//   - cm*()      Macro Compiler and Compiled Macro executor
//                functions.
//
//   - dbi*()     DB informations.
//
//   - dot*()     "Dot" command line.
//
//   - error*()   Error handling.
//
//   - field*()   Field selection. 
//
//   - frm*()     Report forms creation and editing.
//
//   - idb*()     Interactive DB functions.
//
//   - lbl*()     Label forms creation and editing.
//
//   - macro*()   Macro functions.
//
//   - mnu*()     Menu system support functions and
//                vertical/pop-up menu.
//
//   - set*()     Set functions.
//
//   - select*()  Selection functions.
//
//   - status*()  Status information functions.
//
//   - tgl*()     Toggle functions.
//
//   - true*()    Returnign ever true functions.
//
// - public functions:
//
//   - accept*()  Prompting functions.
//
//   - dir*()     Select drive/directory/file.
//
//   - doc*()     Text editor.
//
//   - dte*()     Date/time functions.
//
//   - dot*()     Public "dot" command line functions.
//
//   - ex*()      Macro interpreter and executor.
//
//   - htf*()     Help Text File generation and browse.
//
//   - is*()      Checking for existance functions.
//
//   - list*()    Pop-up list choice.
//
//   - memo*()    Memo edit functions.
//
//   - rf*()      Report Form analogue.
//
//   - rpt*()     Formatted text printer.
//
//   - set*()     Set functions.
//
//   - str*()     String path/file name functions.
//
//   - text*()    Text display functions.
//
//   - tb*()      Browse system.
//
//   - wait*()    Wait functions.
//
// - Command substitution functions.
//
// - Assist(), nB menu driven system.
//
//
//================================================================
// STANDARD INCLUDE
//================================================================
//#include "std.ch"
#include "common.ch"
#include "box.ch"
#include "color.ch"
#include "directry.ch"
#include "fileio.ch"
#include "inkey.ch"
#include "memoedit.ch"
#include "rddsys.ch"
#include "setcurs.ch"
#include "set.ch"
#include "error.ch"
#include "dbstruct.ch"

//================================================================
// REQUEST
//================================================================
// RDDs (Replaceable Database Driver)

#ifdef RDD
    request dbfcdx
    request dbfmdx
#endif

request dbfndx
request dbfntx // default

//================================================================
// ASCII characters
//================================================================
#define NUL chr(00)  // NULl
#define SOH chr(01)  // Start Of Hiteration
#define STX chr(02)  // Start TeXt
#define ETX chr(03)  // End TeXt
#define EOT chr(04)  // End Of Transmission
#define ENQ chr(05)  // ENQuery
#define ACK chr(06)  // ACKnowledge
#define BEL chr(07)  // BELl
#define BS  chr(08)  // Back Space
#define HT  chr(09)  // Horizontal Tab
#define LF  chr(10)  // Line Feed
#define VT  chr(11)  // Vertical Tab
#define FF  chr(12)  // Form Feed
#define CR  chr(13)  // Carriage Return
#define SO  chr(14)  // Shift Out
#define SI  chr(15)  // Shif In
#define DLE chr(16)  // Data Loop Exit
#define DC1 chr(17)  // Dispositive Check 1
#define DC2 chr(18)  // Dispositive Check 2
#define DC3 chr(19)  // Dispositive Check 3
#define DC4 chr(20)  // Dispositive Check 4
#define NAK chr(21)  // Not AKnowledge
#define SYN chr(22)  // SYNcronized
#define ETB chr(23)  // End Trasmission Block
#define CAN chr(24)  // CANcel
#define EM  chr(25)  // End Medium
#define SUB chr(26)  // SUBstitute
#define ESC chr(27)  // ESCape
#define FS  chr(28)  // File Separator
#define GS  chr(29)  // Group Separator
#define RS  chr(30)  // Record Separator
#define US  chr(31)  // Unit Separator

//================================================================
// ASCII STRINGS
//================================================================
#define NL( nTimes )    ( replicate ( CR + LF, nTimes ) )
#define ENDTEXT         NL(2) + ""
#define SPACE_LEN       254 // max normal string, see memoline()
#define SPACE_STR       space(SPACE_LEN)

//================================================================
// COLORS
//================================================================
#define COLOR_BW0       "W/N, N/W, N, N, N/W"
#define COLOR_BW1       "N/W, W+/N, N, N, W/N"
#define COLOR_BW2       "W/N, N/W, N, N, W+/N"
#define COLOR_C0        "GB+/N, W+/G, N, N, N/W"
#define COLOR_C1        "W+/GR, G+/N, N, N, W/N"
#define COLOR_C2        "N/W, G+/N, N, N, B/W"
#define COLOR_DEFAULT0  ( iif( iscolor(), COLOR_C0, COLOR_BW0 ) )
#define COLOR_DEFAULT1  ( iif( iscolor(), COLOR_C1, COLOR_BW1 ) )
#define COLOR_DEFAULT2  ( iif( iscolor(), COLOR_C2, COLOR_BW2 ) )

//================================================================
// PROGRAM INFO/COPYRIGHT
//================================================================
#define PROGRAM_COPYRIGHT_START;
    "nB (nano Base) 1996.06.16 (c) 1996 Daniele Giacomini." +;
    NL(1) +;
    "nB comes with ABSOLUTELY NO WARRANTY, " +;
    "see file COPYING for details." +;
    NL(1) +;
    "This is free software, " +;
    "and you are welcome to redistribute it" +;
    NL(1) +;
    "under certain conditions; again see file COPYING for " +;
    "details." +;
    NL(1)

#ifndef RUNTIME
    #define PROGRAM_COPYRIGHT_HELP;
    NL(1) +;
    "nB [<nB_parameters>] [<macro_filename>] " +;
    "[<macro_parameters>]" +;
    NL(2) +;
    "<nB_parameters>    -c  Suppress copyright notice." +;
    NL(1) +;
    "                   -w  Suppress wait-wheel." +;
    NL(1) +;
    "                   -?  This help." +;
    NL(1) +;
    "<macro_filename>   Macro file name to be executed." +;
    NL(1) +;
    "<macro_parameters> Parameters used from the macro." +;
    NL(1) +;
    "nB without parameters starts the dot/xbase system." +;
    NL(2) +;
    "nB -m <macro_filename> [<compiled_macro_filename>]" +;
    NL(1) +;
    '"Compiles" the text file <macro_filename> into ' +;
    "a nB macro." +;
    NL(1)
#else
    #define PROGRAM_COPYRIGHT_HELP;
    NL(1) +;
    "nB RUNTIME interpreter" +;
    NL(1) +;
    "nB [<nB_parameters>] <macro_filename> " +;
    "[<macro_parameters>]" +;
    NL(2) +;
    "<nB_parameters>    -w  Suppress wait-wheel." +;
    NL(1) +;
    "                   -?  This help." +;
    NL(1) +;
    "<macro_filename>   Macro file name to be executed." +;
    NL(1) +;
    "<macro_parameters> Parameters used from the macro." +;
    NL(1)
#endif

#define PROGRAM_COPYRIGHT_INFO;
    "nB (nano Base) 1996.06.16 - mini xBase" +;
    NL(1) +;
    "(c) 1996 Daniele Giacomini." +;
    NL(2) +;
    "This program is free software; you can redistribute it " +;
    "and/or modify it under the terms of the GNU General " +;
    "Public License as published by the Free Software " +;
    "Foundation; either version 2 of the License, or " +;
    "(at your option) any later version." +;
    NL(1) +;
    "This program is distributed in the hope that it will be " +;
    "useful, but WITHOUT ANY WARRANTY; without even the " +;
    "implied warranty of MERCHANTABILITY or FITNESS FOR A " +;
    "PARTICULAR PURPOSE.  See the GNU General Public License for " +;
    "more details." +;
    NL(1) +;
    "You should have received a copy of the GNU General " +;
    "Public License along with this program; if not, write to " +;
    "the Free Software Foundation, Inc., 675 Mass Ave, " +;
    "Cambridge, MA 02139, USA." +;
    NL(2) +;
    "Send your comments, suggestions, bug reports and " +;
    "english text corrections to:" +;
    NL(1) +;
    "Daniele Giacomini" + NL(1) +;
    "Via Turati, 15" + NL(1) +;
    "I-31100 Treviso" + NL(1) +;
    "Italy" +;
    NL(1) +;
    "daniele@system.abacom.it"

//================================================================
// GENERAL USE
//================================================================
#define _DEFAULT_RDD          "DBFNTX"
#define _ERROR_EXCLUSIVE_REQUIRED;
    "For this action, the Alias must be opened in exclusive mode."
#define _ERROR_FLOCK_FAILURE  "The file is already in use."
#define _ERROR_NO_ALIAS       "There is no active Alias."
#define _ERROR_NO_FILE        "The file do not exists."
#define _ERROR_NO_FILE_HERE;
    "The file do not exists in the specified directory."
#define _ERROR_NO_INDEX;
    "An opened index and a selected order is needed before."
#define _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE;
    "This file already exists. Overwrite?"

#define _EXTENTION_DBF                  "DBF"
#define _EXTENTION_FORM                 "FRM"
#define _EXTENTION_HTF                  "HLP"
#define _EXTENTION_INDEXBAG             substr( ordbagext(), 2 )
#define _EXTENTION_INDEXBAG_STANDARD    "NTX"
#define _EXTENTION_LABEL                "LBL"
#define _EXTENTION_TEXT                 "TXT"
#define _EXTENTION_COMPILED_MACRO       "NB"

#define _KEY_CTRLY;
    "[Ctrl]+[Y] delete/recall"
#define _KEY_CTRLW;
    "[Ctrl]+[W] Confirm modification"
#define _KEY_ENTER;
    "[Enter] select"
#define _KEY_ESC_EXIT_ENTER_UP_DOWN;
    "[Esc] exit  [Enter] select  []/[] move"
#define _KEY_ESC_CANCEL_F1;
    "[Esc] cancel  [F1] help"
#define _KEY_ESC_CANCEL_F1_F2_PGDN;
    "[Esc] cancel  [F1] help  [F2] list  [Pag] confirm"
#define _KEY_ESC_CANCEL_PGDN;
    "[Esc] cancel  [Pag] confirm"
#define _KEY_ESC_END_F1;
    "[Esc] end  [F1] help"
#define _KEY_ESC_EXIT_F1;
    "[Esc] exit  [F1] help"
#define _KEY_ESC_EXIT_F1_PGDN;
    "[Esc] exit  [F1] help  [Pag] continue"
#define _KEY_ESC_EXIT_F1_F2_PGDN;
    "[Esc] exit  [F1] help  [F2] list  [Pag] confirm"
#define _KEY_ESC_EXIT_F1_F2_ENTER_UP_DOWN;
    "[Esc] exit  [F1] help  [F2] list " +;
    "[Enter] select  []/[] move"
#define _KEY_ESC_EXIT_F1_F2_CTRLY;
    "[Esc] exit  [F1] help  [F2] list  [Ctrl]+[Y] delete"
#define _KEY_ESC_EXIT_F1_F10;
    "[Esc] exit  [F1] help  [F10] menu"
#define _KEY_ESC_NORMAL_F1_PGDN;
    "[Esc] normal  [F1] help  [Pag] continue"
#define _KEY_F2_PGDN;
    "[F2] list/dir  [Pag] confirm"
#define _KEY_MENU_H;
    "[Esc] exit  [-]/[-] move cursor  [Enter] open menu"
#define _KEY_MENU_V;
    "[Esc] exit  [-]/[-]/[]/[] cursor movement  [Enter] select"
#define _KEY_MENU_P;
    "[Esc] exit  []/[] cursor movement  [Enter] select"
#define _KEY_UP_DOWN;
    "[]/[] move cursor"
#define _KEY_UP_DOWN_ENTER;
    "[]/[] move  [Enter] select"

#define _MAX_ORDER  255
#define _MAX_SELECT 255

#define _MEMVAR_MACRO_RECORDER          c_MacroRec
#define _MEMVAR_MACRO_RECORDER_NAME     "c_MacroRec"
#define _MEMVAR_MACRO_RECORDING         l_MacroRec
#define _MEMVAR_MACRO_RECORDING_NAME    "l_MacroRec"
#define _MEMVAR_PAR0                c_Par0
#define _MEMVAR_PAR1                c_Par1
#define _MEMVAR_PAR2                c_Par2
#define _MEMVAR_PAR3                c_Par3
#define _MEMVAR_PAR4                c_Par4
#define _MEMVAR_PAR5                c_Par5
#define _MEMVAR_PAR6                c_Par6
#define _MEMVAR_PAR7                c_Par7
#define _MEMVAR_PAR8                c_Par8
#define _MEMVAR_PAR9                c_Par9

#define _MENU_YES             " YES "
#define _MENU_NO              " NO "
#define _MENU_CONTINUE        " CONTINUE "
#define _MENU_EXIT            " EXIT "
#define _MENU_TENDINA_WIDTH 28

#define _MENU_HELP;
    "MENU SYSTEM" +;
    NL(2) +;
    "The Menu system is organised into:" + NL(1) +;
    "     Horizontal menu,"              + NL(1) +;
    "     Vertical menu,"                + NL(1) +;
    "     Pop-up menu."                  +;
    NL(3)                                +;
    "Horizontal menu."                   +;
    NL(2)                                +;
    " One Two Three Four Five"           + NL(1) +;
    " \_____________________/"           + NL(1) +;
    "            "                      + NL(1) +;
    "      Horizontal menu"              + NL(1) +;
    NL(2) +;
    "The cursor may be moved on a different position using " +;
    "arrow keys [-]/[-];" +;
    NL(2) +;
    "[Esc] terminates the menu." +;
    NL(2) +;
    "[Enter] opens a vertical menu." +;
    NL(3) +;
    "Vertical menu."                     +;
    NL(2)                                +;
    " One Two Three Four Five"           + NL(1) +;
    "Ŀ"                      + NL(1) +;
    "First      "                      + NL(1) +;
    "Second> Menu function"      + NL(1) +;
    "Third      > Vertical menu"      + NL(1) +;
    ""                      + NL(1) +;
    NL(2) +;
    "The arrow keys UP and DOWN []/[] move the cursor "+;
    "to the previous or to the next menu function, inside " +;
    "the opened vertical menu." +;
    NL(2) +;
    "The arrow keys LEFT and RIGHT [-]/[-] change the " +;
    "Vertical menu." +;
    NL(2) +;
    "[Esc] closes the menu." +;
    NL(2) +;
    "[Enter] starts the selected menu function." +;
    NL(3)                                +;
    "Pop-Up menu."                       +;
    NL(2)                                +;
    " One Two Three Four Five"           + NL(1) +;
    "Ŀ"                      + NL(1) +;
    "First      "                      + NL(1) +;
    "Second     "                      + NL(1) +;
    "Third     Ŀ"      + NL(1) +;
    "ĳSub function 1Ŀ"  + NL(1) +;
    "            Sub function 2    "  + NL(1) +;
    "             Menu sub-function" + NL(1) +;
    NL(2) +;
    "The arrow keys UP and DOWN []/[] move the cursor "+;
    "to the previous or to the next menu sub-function, inside " +;
    "the opened pop-up menu." +;
    NL(2) +;
    "[Esc] closes the pop up menu." +;
    NL(2) +;
    "[Enter] starts the selected menu sub-function."

#define _STDHLP_START                   NL(2) + ""
#define _STDHLP_EVER_TRUE;
    NL(2) +;
    "The condition .T. (point, T, point) is ever true."
#define _STDHLP_WHILE_CONDITION;
    NL(2) +;
    "'WHILE' identifies a conditional execution " +;
    "that is carried out until the condition is true. " +;
    "When for the first time the checked condition is false, " +;
    "the conditional execution is stopped."
#define _STDHLP_FOR_CONDITION;
    NL(2) +;
    "'FOR' identifies a conditional execution " +;
    "that is carried out all the times that the condition is true."

#define _MACRO_EXIT_NORMAL          0
#define _MACRO_EXIT_BREAK           1
#define _MACRO_EXIT_STATEMENT_ERROR 2
#define _MACRO_EXIT_NO_MACRO_FILE   3
#define _MACRO_EXIT_FILE_LOCKED     4
#define _MACRO_EXIT_FILE_NOT_DBF    5
#define _MACRO_EXIT_DIFFERENT_DBF   6

#define _MACRO_ERROR_FILE_NOT_FOUND;
    "Macro file not found!"
#define _MACRO_ERROR_FILE_LOCKED;
    "Macro file is locked!"
#define _MACRO_ERROR_FILE_DIFFERENT_STRUCTURE;
    "This file is not a macro!"

#define _MACRO_MENU_CHOICE_ABORT        "Abort"
#define _MACRO_MENU_CHOICE_CONTINUE     "Continue"

#define _MACRO_PROMPT_EXECUTION_ABORT;
    "Abort or continue macro execution?"

#define _STATEMENT_MAX_NEST       256

#define _STATEMENT_PROCEDURE        1
#define _STATEMENT_RETURN           2
#define _STATEMENT_ENDPROCEDURE     3
#define _STATEMENT_DOPROCEDURE      4

#define _STATEMENT_BEGIN           11
#define _STATEMENT_BREAK           12

#define _STATEMENT_IF              21
#define _STATEMENT_THEN            22
#define _STATEMENT_ELSE            23

#define _STATEMENT_WHILE           31

#define _STATEMENT_DOCASE          41
#define _STATEMENT_CASE            42
#define _STATEMENT_CASEMATCHED     43
#define _STATEMENT_OTHERWISE       44

#define _STATEMENT_MAIN            81

#define _STATEMENT_LOOP            97
#define _STATEMENT_EXIT            98
#define _STATEMENT_END             99


#define _STATEMENT_ERROR_ALONE_BREAK;
    "BREAK: missing BEGIN SEQUENCE."
#define _STATEMENT_ERROR_ALONE_CASE;
    "CASE: missing DO CASE."
#define _STATEMENT_ERROR_ALONE_ELSE;
    "ELSE: missing IF."
#define _STATEMENT_ERROR_ALONE_END;
    "END: missing IF|WHILE|DO CASE|BEGIN SEQUENCE."
#define _STATEMENT_ERROR_ALONE_ENDPROCEDURE;
    "ENDPROCEDURE: missing PROCEDURE."
#define _STATEMENT_ERROR_ALONE_EXIT;
    "EXIT: missing WHILE."
#define _STATEMENT_ERROR_ALONE_LOOP;
    "LOOP: missing WHILE."
#define _STATEMENT_ERROR_ALONE_OTHERWISE;
    "OTHERWISE: missing DO CASE."

#define _STATEMENT_ERROR_LINE_TOO_LONG;
    "Command line too long: it exeeds " +;
    ltrim( str( SPACE_LEN ) ) + " bytes."
#define _STATEMENT_ERROR_NO_CONDITION;
   "No condition supplied!"
#define _STATEMENT_ERROR_NO_PROCEDURE_NAME;
    "Missing procedure name."
#define _STATEMENT_ERROR_PROCEDURE_NOT_FOUND;
    "Procedure not found!"
#define _STATEMENT_ERROR_SEMICOLON_EOF;
    "The file is terminated before expected: semicolon."
#define _STATEMENT_ERROR_UNCLOSED_STRUCTURE;
    "Structure unclosed: missing END."
#define _STATEMENT_ERROR_UNCLOSED_PROCEDURE;
    "Structure unclosed: missing ENDPROCEDURE."


#define _UNTITLED    "UNTITLED"

//================================================================
// OTHERS DIVIDED PER FUNCTION GROUP
//================================================================
#define ACCEPT_FUNCTION_MANE;
    "Accept()"

//----------------------------------------------------------------
#define ASSIST_FUNCTION_NAME;
    "Assist()"
#define ASSIST_PROMPT_EXIT;
    "Exit " + ASSIST_FUNCTION_NAME + " ?"

//----------------------------------------------------------------
#define CM_MAX_LINES           999999
#define CM_MAX_LINES_DIGITS         6

#define CM_COMPILED_MACRO_ALIAS     "_CM_ALIAS"

#define CM_STEP00;
    "Reading the file..."
#define CM_STEP01;
    "Deleting comments..."
#define CM_STEP02;
    "Translating multiple line commands..."
#define CM_STEP03;
    "Deleting empty lines..."
#define CM_STEP04;
    "Packing..."
#define CM_STEP05;
    "Calculating PROCEDURE pointers..."
#define CM_STEP06;
    "Calculating BEGIN|IF|CASE|WHILE structure pointers..."

//----------------------------------------------------------------
#define DBI_STRUCTURE_TOP;
   "Name     Type Len Dec"

//----------------------------------------------------------------
#define DIR_WAIT_READING_DIRECTORY;
    "Reading Directory..."

#define DIR_SAY_DRIVE;
    "<Drive:>"

#define DIR_GET_NEW_DRIVE;
    "New Drive:"

#define DIR_HELP;
    "DISK/DIRECTORY/FILE SELECTION" +;
    NL(2) +;
    "This function permits to select:" +;
    NL(2) +;
    "- a disk drive," +;
    NL(1) +;
    "- a directory, " +;
    NL(1) +;
    "- a file," +;
    NL(2) +;
    "depending of the context." +;
    NL(2) +;
    "Use arrow keys, []/[], to move cursor. " +;
    "Press [Enter] to select a drive, a new directory, " +;
    "the current directory or " +;
    "a file." +;
    NL(2) +;
    "If a directory or a new drive is selected, it will " +;
    "appear the new list." +;
    NL(2) +;
    "If a file or the current displayed directory [.] is selected, the " +;
    "selection window disappears automatically and the program " +;
    "continues."

//----------------------------------------------------------------
#define DOC_FUNCTION_NAME       "Doc()"

#define DOC_TOP      1
#define DOC_LEFT     0
#define DOC_BOTTOM   maxrow()-1
#define DOC_RIGHT    maxcol()
#define DOC_WIDTH    SPACE_LEN
#define DOC_TABSIZE  4

#define DOC_OLD      1
#define DOC_NAME     2
#define DOC_TEXT     3
#define DOC_WRAP     4
#define DOC_INS      5
#define DOC_ROW      6
#define DOC_COL      7
#define DOC_RELROW   8
#define DOC_RELCOL   9
#define DOC_CHANGED  10
#define DOC_LASTKEY  11
#define DOC_EXIT     12
#define DOC_NEW      13
#define DOC_LENGTH   13  // array length

#define DOC_WRITING     "Writing..."
#define DOC_WRITE_OK    "Write OK."
#define DOC_WRITE_ERROR "Write error."

#define DOC_PROMPT_OPEN_FILE_DOC;
    "Text or document file name:"
#define DOC_PROMPT_EXIT;
    "Exit " + DOC_FUNCTION_NAME + " ?"
#define DOC_PROMPT_ABANDON_CHANGES;
    "Abandon changes?"
#define DOC_PROMPT_OPEN_FILE_TEXT_DOCUMENT;
    "Text/Document file name:"
#define DOC_PROMPT_WHILE_EXPRESSION;
    "WHILE expression condition:"
#define DOC_PROMPT_FOR_EXPRESSION;
    "FOR expression condition:"
#define DOC_OPEN_DOCUMENT;
    "Open Document for editing."
#define DOC_INSERT_NEW_DOCUMENT_NAME;
    "Insert new Document name."
#define DOC_FILE_NOT_CHANGED;
    "File has not been modified."
#define DOC_NEW_NAME;
    "Enter new file name."

#define DOC_DIALOG_BOX_TOP_OPEN;
    "Open a Text/Document"
#define DOC_DIALOG_BOX_TOP_PRINT;
    "Print a Text/Document"

#define DOC_ERROR_FILE_CREATION;
    "File creation error!"

#define DOC_HELP;
    "TEXT/DOCUMENT EDITOR " + DOC_FUNCTION_NAME +;
    NL(2) +;
    "This function creates and modifies little ASCII " +;
    "files: max 64K." +;
    NL(2) +;
    DOC_FUNCTION_NAME + " permits to create also formatted " +;
    "text with variables identified by  delimiters: " +;
    "when an active Alias exists, [F2] gives a list of " +;
    "insertable fields." +;
    NL(2) +;
    "It follows the available command list." +;
    NL(2) +;
    "[Esc]                     Exit" + NL(1) +;
    "[F1]                      this help" + NL(1) +;
    "[F2]                      field list" + NL(1) +;
    "[] / [Ctrl]+[E]          up" + NL(1) +;
    "[] / [Ctrl]+[X]          down" + NL(1) +;
    "[-] / [Ctrl]+[S]         left" + NL(1) +;
    "[-] / [Ctrl]+[D]         right" + NL(1) +;
    "[Ctrl]+[-] / [Ctrl]+[A]  word left" + NL(1) +;
    "[Ctrl]+[-] / [Ctrl]+[F]  word right" + NL(1) +;
    "[Home]                    line start" + NL(1) +;
    "[End]                     line end" + NL(1) +;
    "[Ctrl]+[Home]             top window" + NL(1) +;
    "[Ctrl]+[End]              bottom window" + NL(1) +;
    "[Pag]                    previous window" + NL(1) +;
    "[Pag]                    next window" + NL(1) +;
    "[Ctrl]+[Pag]             document start" + NL(1) +;
    "[Ctrl]+[Pag]             end document" + NL(1) +;
    "[Del]                     delete character" + NL(1) +;
    "[Backspace] / [----]     delete character left" + NL(1) +;
    "[Tab] / [--|]            insert tab" + NL(1) +;
    "[Ins]                     insert/overwrite" + NL(1) +;
    "[Enter]                   next line" + NL(1) +;
    "[Ctrl]+[Y]                delete line" + NL(1) +;
    "[Ctrl]+[T]                delete word right" + NL(1) +;
    "[F10] / [Alt]+[M]         menu"

#define DOC_HELP_PRINT;
    "TEXT/DOCUMENT STANDARD PRINT" +;
    NL(2) +;
    "It prints the loaded text/document linking with data " +;
    "obtained from the active Alias." +;
    NL(3) +;
    "WHILE EXPRESSION - the WHILE condition for the Alias " +;
    "records;" +;
    NL(2) +;
    "FOR EXPRESSION - the FOR condition for the Alias " +;
    "records." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

//----------------------------------------------------------------
#define DOT_MESSAGE_ERROR               "Error"
#define DOT_PROMPT_EXIT                 "Exit nB ?"
#define DOT_KEY_REMINDER;
    "[Esc] exit  [F2] list  " +;
    "[Pag]/[Pag] prev./next  " +;
    "[Enter] execute  [F10] menu"
#define DOT_LIST_KEY_REMINDER;
    "[Esc] exit  []/[] previous/next  " +;
    "[Enter] select"
#define DOT_LIST_WINDOW_TOP;
   "Command history"
#define DOT_HELP;
    "nB DOT" +;
    NL(2) +;
    "nB works like an interactive xbase where only functions " +;
    "are allowed." +;
    NL(2) +;
    "[Esc]              closes the program." +;
    NL(2) +;
    "[Enter]            executes the function written into " +;
    "the prompt line." +;
    NL(2) +;
    "[Pag]             recalls previous line." +;
    NL(2) +;
    "[Pag]             go to next command line." +;
    NL(2) +;
    "[F2]               shows the history command list." +;
    NL(2) +;
    "[F10] or [Alt]+[M] calls the ASSIST() menu." +;
    NL(2) +;
    "The usable functions are all those of CA-Clipper " +;
    "5.2 and the others made available into this program." +;
    NL(2) +;
    "ASSIST() is a menu driven function usefull for " +;
    "creating and modifying database files and more." +;
    NL(2) +;
    "DOC() is the internal text editor usefull for creating " +;
    "and print of simple reports." +;
    NL(2) +;
    "TB() is the internal database file browser." +;
    NL(2) +;
    "For more informations see the manual." +;
    NL(3) +;
    "CA-Clipper is a trademark of Computer Associates."

#define DOT_HELP_LIST;
    "DOT - COMMAND HISTORY" +;
    NL(2) +;
    "Select a command from the command history list." +;
    NL(2) +;
    "Use arrow keys, []/[], to move cursor. " +;
    "Press [Enter] to select a command." +;
    NL(2) +;
    "Press [Esc] to abandon without selecting."

#define DOT_LINE_HELP;
    "DOT LINE" +;
    NL(2) +;
    "This function is a dot line useable as a pop up " +;
    "calculator." +;
    NL(2) +;
    "A calculation may be done simply writing on the dot line." +;
    NL(3) +;
    "Examples:" +;
    NL(2) +;
    "123 + 456" +;
    NL(1) +;
    "(256 + 567) * 45" +;
    NL(3) +;
    "+, -, *, /, **, (, ) and matematical functions " +;
    "may be used." +;
    NL(3) +;
    "[Esc]       exit dot line." +;
    NL(1) +;
    "[Enter]     resolve dot line." +;
    NL(1) +;
    "[Pag]      insert the dot line content into the the keyboard buffer."

#define DOT_LINE_TITLE;
   "Dot Line Calculator"

#define DOT_LINE_BOTTOM;
    "[Esc] exit  [Enter] resolve  [Pag] keyboard"

//----------------------------------------------------------------
#define ERROR_MENU_CHOICE_IGNORE        "Ignore"
#define ERROR_MENU_CHOICE_BREAK         "Break"
#define ERROR_MENU_CHOICE_RETRY         "Retry"
#define ERROR_MENU_CHOICE_DEFAULT       "Default"
#define ERROR_MENU_CHOICE_QUIT          "Quit"

//----------------------------------------------------------------
#define FIELD_WINDOW_TOP_FIELD_CHOICE;
   "Name     Type Length Decimal"

#define FIELD_DIALOG_BOX_TOP_ALIGN_CHARACTER;
   "Character alignment"
#define FIELD_DIALOG_BOX_TOP_ALIGN_NUMBER;
   "Number alignment"

#define FIELD_PROMPT_ALIGN_NORMAL;
   "Normal? (Y/T/N/F)"
#define FIELD_PROMPT_ALIGN_CHARACTER_DIMENSION;
   "Dimention"
#define FIELD_PROMPT_ALIGN_CHARACTER_ALIGNMENT;
   "Alignment (Left/Center/Right)"
#define FIELD_PROMPT_ALIGN_NUMBER_LENGTH;
   "Number Length"
#define FIELD_PROMPT_ALIGN_NUMBER_LENGTH_NOTE;
   "(included comma and decimal)"
#define FIELD_PROMPT_ALIGN_NUMBER_DECIMAL;
   "Decimal Length"
#define FIELD_PROMPT_MEMO_LENGTH;
   "Insert memo length."

#define FIELD_ERROR_MEMO_FILEDS_NOT_ALLOWED;
   "MEMO fields cannot be included into index keys."

#define FIELD_TRUE;
   "True "
#define FIELD_FALSE;
   "False"

#define FIELD_HELP_FIELD_CHOICE;
    "FIELD CHOICE" +;
    NL(2) +;
    "It permits to select a column " +;
    "or a field from a file. " +;
    NL(2) +;
    "The user have to move the cursor " +;
    "with the arrow keys, []/[], " +;
    "and select the name pressing [Enter]." +;
    NL(2) +;
    "Pressing [Esc], the function terminates."

#define FIELD_HELP_ALIGN_CHARACTER;
    "ALIGN A CHARACTER FIELD" +;
    NL(2) +;
    "It helps to define the dimension " +;
    "and the alignment of a field." +;
    NL(2) +;
    "When normal is true (.T.), the field is left with " +;
    "no transformations." +;
    NL(2) +;
    "Otherwise, the dimension and alignment must " +;
    "be spesified exactly." +;
    NL(2) +;
    "Pressing [Esc] will be returned a normal " +;
    "alignment. Pressing [Pag] will be confirmd the choice selected."

#define FIELD_HELP_ALIGN_NUMBER;
    "ALIGN A NUMERIC FIELD" +;
    NL(2) +;
    "It helps to define the dimension " +;
    "and the alignment of a numeric field." +;
    NL(2) +;
    "When normal is ture (.t.), the number appears with " +;
    "a default transformation into string; " +;
    "otherwise, the dimension must " +;
    "be specified exactly. " +;
    NL(2) +;
    "Pressing [Esc] will be returned a normal " +;
    "alignment. Pressing [Pag] will be confirmd " +;
    "the choice selected." +;
    NL(3) +;
    "Examples:" +;
    NL(2) +;
    "Lenght, Decimals,  Number        Result    " + NL(1) +;
    "  10        0      12345,456     _____12345" + NL(1) +;
    "  10        2      12345,456     __12345.45" + NL(1) +;
    "  14        3      12345,456     _____12345.456" + NL(1) +;
    "   5        3      12345,456     *****" +;
    NL(2) +;
    "With the last case the result is an error."

//----------------------------------------------------------------
// xcFormVal vector
#define FRM_PAGE_HDR                 1
#define FRM_GRP_EXPR                 2
#define FRM_SUB_EXPR                 3
#define FRM_GRP_HDR                  4
#define FRM_SUB_HDR                  5
#define FRM_PAGE_WIDTH               6
#define FRM_LINES_PAGE               7
#define FRM_LEFT_MARG                8
#define FRM_RIGHT_MARG               9
#define FRM_COL_COUNT               10
#define FRM_DBL_SPACED              11
#define FRM_SUMMARY                 12
#define FRM_PE                      13
#define FRM_PEBP                    14
#define FRM_PEAP                    15
#define FRM_PLAINPAGE               16

// buffer dimensions
#define FRM_SIZE_FILE_BUFF        1990   // file length
#define FRM_SIZE_LENGTHS_BUFF      110
#define FRM_SIZE_OFFSETS_BUFF      110
#define FRM_SIZE_EXPR_BUFF        1440
#define FRM_SIZE_FIELDS_BUFF       300
#define FRM_SIZE_PARAMS_BUFF        24

// buffer offsets (start points)
// contined into cBuffer, that is the file (.frm) loaded
// into a variable and seen from the point fo view
// of CA-Clipper and not from the one of Dos.
#define FRM_LENGTHS_OFFSET           5
#define FRM_OFFSETS_OFFSET         115
#define FRM_EXPR_OFFSET            225
#define FRM_FIELDS_OFFSET         1665
#define FRM_PARAMS_OFFSET         1965

// Offsets contained in acFormBuffer[ FRM_FIELDS_BUFF ]
#define FRM_FIELD_OFFSET               0
#define FRM_FIELD_WIDTH_OFFSET         1
#define FRM_FIELD_TOTALS_OFFSET        6
#define FRM_FIELD_DECIMALS_OFFSET      7
#define FRM_FIELD_CONTENT_EXPR_OFFSET  9
#define FRM_FIELD_HEADER_EXPR_OFFSET  11

// Offsets contained in cParamsBuff
#define FRM_PAGE_HDR_OFFSET         1
#define FRM_GRP_EXPR_OFFSET         3
#define FRM_SUB_EXPR_OFFSET         5
#define FRM_GRP_HDR_OFFSET          7
#define FRM_SUB_HDR_OFFSET          9
#define FRM_PAGE_WIDTH_OFFSET      11
#define FRM_LNS_PER_PAGE_OFFSET    13
#define FRM_LEFT_MRGN_OFFSET       15
#define FRM_RIGHT_MRGN_OFFSET      17
#define FRM_COL_COUNT_OFFSET       19
#define FRM_DBL_SPACE_OFFSET       21
#define FRM_SUMMARY_RPT_OFFSET     22
#define FRM_PE_OFFSET              23
#define FRM_PLNPG_PEAP_PEBP_OFFSET 24

// FormBuffers
#define FRM_LENGTHS_BUFF            1
#define FRM_OFFSETS_BUFF            2
#define FRM_EXPR_BUFF               3
#define FRM_PARAMS_BUFF             4
#define FRM_FIELDS_BUFF             5

// anNum[5]
#define FRM_PAGE_HDR_NUM            1
#define FRM_GRP_EXPR_NUM            2
#define FRM_SUB_EXPR_NUM            3
#define FRM_GRP_HDR_NUM             4
#define FRM_SUB_HDR_NUM             5

#define FRM_HEAD_REPORT_ORDER;
   "Order"
#define FRM_HEAD_REPORT_HEADER;
   "Column Header"
#define FRM_HEAD_REPORT_CONTENT;
   "Content"
#define FRM_HEAD_REPORT_WIDTH;
   "Width"
#define FRM_HEAD_REPORT_DECIMALS;
   "dec."
#define FRM_HEAD_REPORT_TOTAL;
   "Totals"

#define FRM_DIALOG_BOX_TOP_REPORT;
   "REPORT FORM ..."

#define FRM_PROMPT_COMPRESSED_PRINT;
   "Compressed Print ? (Y/T/N/F) "
#define FRM_PROMPT_OPEN_FILE_REPORT;
   "Report file name:"
#define FRM_PROMPT_WHILE_EXPRESSION;
   "WHILE expression condition:"
#define FRM_PROMPT_FOR_EXPRESSION;
   "FOR expression condition:"
#define FRM_PROMPT_TO_FILE;
   "Periferal or destination file:"
#define FRM_PROMPT_NEW_FILE_NAME;
   "Insert new name."
#define FRM_PROMPT_SAVE_REPORT;
   "Name to use to save the report:"
#define FRM_PROMPT_REPORT_PAGE_WIDTH;
   "Page Width....:"
#define FRM_PROMPT_REPORT_LINES_PER_PAGE;
   "Lines per Page:"
#define FRM_PROMPT_REPORT_LEFT_MARGIN;
   "Left Margin...:"
#define FRM_PROMPT_REPORT_RIGHT_MARGIN;
   "Right Margin..:"
#define FRM_PROMPT_REPORT_DOUBLE_SPACED;
   "Double Spaced ?"
#define FRM_PROMPT_REPORT_PAGE_EJECT_BEFORE;
   "Page Eject Before Print........?"
#define FRM_PROMPT_REPORT_PAGE_EJECT_AFTER;
   "Page Eject After Print.........?"
#define FRM_PROMPT_REPORT_PLAIN_PAGE;
   "Plain Page......?"
#define FRM_PROMPT_REPORT_PAGE_HEADER;
   "Page Header"
#define FRM_PROMPT_REPORT_GROUP_HEADER;
   "Group Header"
#define FRM_PROMPT_REPORT_GROUP_EXPRESSION;
   "Group Expression"
#define FRM_PROMPT_REPORT_SUMMARY_REPORT_ONLY;
   "Summary Report Only............?"
#define FRM_PROMPT_REPORT_PAGE_EJECT_AFTER_GROUP;
   "Page Eject After Group.........?"
#define FRM_PROMPT_REPORT_SUB_GROUP_HEADER;
   "Sub Group Header"
#define FRM_PROMPT_REPORT_SUB_GROUP_EXPRESSION;
   "Sub Group Expression"

#define FRM_HELP_REPORT_FORM;
    "REPORT FORM..." +;
    NL(2) +;
    "It may ask for:" +;
    NL(2) +;
    "- the report file name;" +;
    NL(2) +;
    "- the WHILE condition;" +;
    NL(2) +;
    "- the FOR condition." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

#define FRM_HELP_REPORT_EDIT;
    "MODIFY REPORT FORM" +;
    NL(2) +;
    "It opens a report form file and edits it."

#define FRM_HELP_REPORT_EDIT_HEAD;
    "STANDARD REPORT" +;
    NL(2) +;
    "It creates or modifies a report file, " +;
    "." + _EXTENTION_FORM + " under the dBaseIII+ standard." +;
    NL(2) +;
    "The informations are divided into two parts: " +;
    "* the head and groups," + NL(1) +;
    "* the columns." +;
    NL(2) +;
    "PAGE WIDTH - the page width in characters;" +;
    NL(2) +;
    "LINES PER PAGE - the usable lines per per page;" +;
    NL(2) +;
    "LEFT MARGIN - the left margin in characters;" +;
    NL(2) +;
    "DOUBLE SPACED? - double spaced print, yes or no;" +;
    NL(2)+;
    "PAGE EJECT BEFORE PRINT? - form feed before print, " +;
    "yes or no;" +;
    NL(2) +;
    "PAGE EJECT AFTER PRINT? - form feed after print, " +;
    "yes or no;" +;
    NL(2) +;
    "PLAIN PAGE? - plain page, yes or no;" +;
    NL(2) +;
    "PAGE HEADER - the page header, max 4 lines of 60 characters " +;
    "(the separation between one line and the other is " +;
    "obtained writing a semicolon, ';');" +;
    NL(2)+;
    "GROUP HEADER - the group title;" +;
    NL(2) +;
    "GROUP EXPRESSION - the group expression (when it " +;
    "changes, the group changes);" +;
    NL(2) +;
    "SUMMARY REPORT ONLY? - only totals and no columns, yes or no;" +;
    NL(2)+;
    "PAGE EJECT AFTER GROUP? - form feed when the group changes, " +;
    "yes or no;" +;
    NL(2)+;
    "SUB GROUP HEADER - sub group title;" +;
    NL(2) +;
    "SUB GROUP EXPRESSION - the sub group expression."

#define FRM_HELP_REPORT_EDIT_COLUMNS;
    "STANDARD REPORT" +;
    NL(2) +;
    "It creates or modifies a report file, " +;
    "." + _EXTENTION_FORM + ", under the dBaseIII+ standard." +;
    NL(2) +;
    "The informations are divided into two parts: " +;
    "* the head and groups," + NL(1) +;
    "* the columns." +;
    NL(2) +;
    "ORDER - used only to change the columns order;" +;
    NL(2) +;
    "COLUMN HEADER - column head description " +;
    "(it can contain 4 lines separated with a semicolon);" +;
    NL(2)+;
    "CONTENT - the column expression;" +;
    NL(2) +;
    "WIDTH - the column witdth;" +;
    NL(2) +;
    "DEC. - the decimal lengh for numeric columns;" +;
    NL(2)+;
    "TOTALS - totals to be calculated, yes or no " +;
    "(usefull only for numeric columns)."

#define FRM_HELP_REPORT_SAVE;
    "REPORT FORM SAVE" +;
    NL(2) +;
    "It specify the name to use to save this report."

#define FRM_ERROR_CANNOT_OPEN;
    "Cannot open this file. See FERROR() error n. "
#define FRM_ERROR_CANNOT_CREATE;
    "Cannot create this file. See FERROR() error n. "
#define FRM_ERROR_FILE_TOO_LITTLE;
    "File too little or empty."
#define FRM_ERROR_FILE_NOT_SAVED;
    "File not saved!"
#define FRM_ERROR_FILE_NOT_VALID;
    "File not valid."
#define FRM_ERROR_SOMETHING_GONE_WRONG;
    "Something is gone wrong trying to save."
#define FRM_ERROR_PRINT_FILE_NOT_FOUND;
    "The file do not exists."

#define FRM_WAIT_LOADING;
    "Loading..."
#define FRM_WAIT_SAVING;
    "Saving..."

//----------------------------------------------------------------
#define HTF_INDEX_START         "##"
#define HTF_INDEX_END           "##"
#define HTF_POINTER_START       "<"
#define HTF_POINTER_END         ">"

#define HTF_ERROR_FILE_TYPE;
    "This is not a Help Text File."

#define HTF_ERROR_PATTERN_NOT_FOUND;
    "Pattern not found."

#define HTF_WINDOW_BOTTOM;
    "[Esc] exit  [F1] help  " +;
    "[Enter] select  []/[] move  " +;
    "[<-]/[->] prev./next"

#define HTF_DIALOG_BOX_TOP_GENERATE;
    "Generate a file for the use with htf()."

#define HTF_DIALOG_BOX_TOP_OPEN;
    "Help Text File open."

#define HTF_DIALOG_BOX_TOP_SEARCH;
    "Search for a pattern."

#define HTF_PROMPT_HTF_FILE_OPEN;
    "Insert the Help Text File to open:"

#define HTF_PROMPT_SOURCE_FILE;
    "Insert the source text file name:"
#define HTF_PROMPT_DESTINATION_FILE;
    "Insert the destination file name:"

#define HTF_PROMPT_INDEX_START;
    "Insert the INDEX start code:"
#define HTF_PROMPT_INDEX_END;
    "Insert the INDEX end code:"
#define HTF_PROMPT_POINTER_START;
    "Insert the POINTER start code:"
#define HTF_PROMPT_POINTER_END;
    "Insert the POINTER end code:"

#define HTF_PROMPT_SEARCH_PATTERN;
    "Insert the pattern to search:"

#define HTF_WAIT_APPENDING;
    "Loading "
#define HTF_WAIT_SEARCHING_INDEXES;
    "Searching for indexes..."
#define HTF_WAIT_SEARCHING_POINTERS;
    "Searching for pointers..."

#define HTF_WAIT_SEARCHING;
    "Searching for "


#define HTF_HELP_OPEN;
    "OPEN AND BROWSE A HELP TEXT FILE" +;
    NL(3) +;
    "Insert the Help Text File name to be browsed."

#define HTF_HELP;
    "HELP TEXT FILE BROWSER" +;
    NL(2) +;
    "Browse the document using the following keys." +;
    NL(2) +;
    "[Esc]          Exit." + NL(1) +;
    "[]            Move cursor up." + NL(1) +;
    "[]            Move cursor down." + NL(1) +;
    "[Page]        Move cursor PageUp." + NL(1) +;
    "[Page]        Move cursor Pagedown." + NL(1) +;
    "[Ctrl]+[Page] Move cursor Top." + NL(1) +;
    "[Ctrl]+[Page] Move cursor Bottom." + NL(1) +;
    "[Enter]        Select reference." + NL(1) +;
    "[<-]           Previous selected reference." + NL(1) +;
    "[->]           Next selected reference." + NL(1) +;
    "[Shift]+[F3]   Search for a new pattern." + NL(1) +;
    "[F3]           Repeat previous search."

#define HTF_HELP_GENERATE;
    "HELP TEXT FILE GENERATION." +;
    NL(3) +;
    "It generates a file readable from the Help Text File browser." +;
    NL(2) +;
    "The source is an Ascii file where three kind of information " +;
    "are available: Normal text, Indexes and pointers." +;
    NL(2) +;
    "Indexes and Pointers are word or phrases delimited with " +;
    "user defined delimiters; indexes are placed inside the " +;
    "text to indicate an argument, pointers are placed inside " +;
    "the text to indicate a reference to indexes." +;
    NL(2) +;
    "Only one index per line is allowed, only one pointer per " +;
    "line is allowed." +;
    NL(2) +;
    "The Delimiters used do identify indexes and pointers are " +;
    "user defined; the start identifyer symbol can be equal " +;
    "to the end identifyer symbol. The symbols used for " +;
    "indexes cannot be used for the pointers."

#define HTF_HELP_PATTERN_SEARCH;
    "HELP TEXT FILE PATTERN SEARCH." +;
    NL(3) +;
    "Insert the pattern to search starting from the current " +;
    "position."

//----------------------------------------------------------------
#define IDB_DIALOG_BOX_TOP_NTX_NEW;
   "New Index"
#define IDB_DIALOG_BOX_TOP_OPEN_DBF;
   "Open ." + _EXTENTION_DBF
#define IDB_DIALOG_BOX_TOP_OPEN_NTX;
   "Open ." + _EXTENTION_INDEXBAG
#define IDB_DIALOG_BOX_TOP_REPLACE;
   "Replace"
#define IDB_DIALOG_BOX_TOP_RECALL;
   "Recall"
#define IDB_DIALOG_BOX_TOP_DELETE;
   "Delete"
#define IDB_DIALOG_BOX_TOP_RELATION_DEFINITION;
   "Relation definition"
#define IDB_DIALOG_BOX_DBF_FILE;
   "." + _EXTENTION_DBF + " File"

#define IDB_WINDOW_TOP_DBF_STRUCTURE;
   "Database file structure"

#define IDB_WAIT_PACK;
   "Removing deleted records..."

#define IDB_PROMPT_MODIFY_STRUCTURE;
    "Inproper structure modification;" +;
    "may result in a loss of data."
#define IDB_PROMPT_OPEN_FILE_TO_MODIFY;
    "." + _EXTENTION_DBF + " file - modify structure:"
#define IDB_PROMPT_DBF_CREATE_LAST_STRUCTURE;
    "Do you want to use last structure?"
#define IDB_PROMPT_DBF_MODIFY_STRUCTURE;
    "Confirm structure modification?"
#define IDB_PROMPT_DBF_REPLACE;
    "Confirm replacement on all records?"
#define IDB_PROMPT_DBF_RECALL;
    "Confirm deleted record recall?"
#define IDB_PROMPT_DBF_DELETE;
    "Confirm record deletion?"
#define IDB_PROMPT_DBF_PACK;
    "Confirm file pack?"
#define IDB_PROMPT_NEW_NTX_FILENAME;
    "Index file name to create:"
#define IDB_PROMPT_TAG_NAME;
    "Order name (Tag) to be created:"
#define IDB_PROMPT_NEW_NTX_KEYEXPR;
    "Key expression:"
#define IDB_PROMPT_OPEN_NTX_FILENAME;
    "Insert the index file name to open:"
#define IDB_PROMPT_WHILE_EXPRESSION;
    "WHILE expression condition (.t.=ALL):"
#define IDB_PROMPT_FOR_EXPRESSION;
    "FOR expression condition (.t.=ALL):"
#define IDB_PROMPT_OPEN_DBF_FILENAME;
    "Filename:"
#define IDB_PROMPT_OPEN_DBF_ALIASNAME;
    "Alias:"
#define IDB_PROMPT_OPEN_DBF_RDDNAME;
    "RDD:"
#define IDB_PROMPT_OPEN_DBF_SHARED;
    "Shared ? (Y/T/N/F):"
#define IDB_PROMPT_OPEN_DBF_READ_ONLY;
    "Read Only ? (Y/T/N/F):"
#define IDB_PROMPT_REPLACE_FIELD;
    "Field to replace:"
#define IDB_PROMPT_REPLACE_NEW_VALUE;
    "New value expression:"
#define IDB_PROMPT_TEMP_DELETE;
    "Do you want to delete the temporary file " + ;
    "corresponding to the old one before the modification?"
#define IDB_PROMPT_RELATION_DEFINITION_CHILDNAME;
    "Child Alias:"
#define IDB_PROMPT_RELATION_DEFINITION_EXPRESSION;
    "Relation expression:"
#define IDB_PROMPT_NEW_DBF_SAVE;
    "." + _EXTENTION_DBF + " file save; insert the name:"
#define IDB_PROMPT_NEW_RDD_SAVE;
    "Replaceable Database Driver (rdd):"

#define IDB_ERROR_FILE_NOT_EXIST;
   "The file do not exists."
#define IDB_ERROR_RELATION;
   "Relation creation error!"
#define IDB_ERROR_FIELD_TYPE;
   "Valid values are C, N, D, L and M"
#define IDB_ERROR_FIELD_NUMERIC_TOO_LITTE;
   "A numeric field must have a lenght greater then 0"
#define IDB_ERROR_FIELD_DECIMAL_TOO_BIG;
   iif( Field->Field_Len-2 > 0,;
       "Decimal may range from 0 to " +;
       ltrim( str( Field->Field_Len-2 ) ),;
       "Only 0 (Zero) is allowed";
       )

#define IDB_HELP_OPEN_FILE_TO_MODIFY;
   "OPEN A FILE AND MODIFY THE STRUCTURE." +;
   NL(3) +;
   "Insert the file name that you intend to modify."

#define IDB_HELP_SAVE_CREATED_MODIFYED_FILE;
   "SAVE A " + _EXTENTION_DBF + " FILE." +;
   NL(3) +;
   "Insert the name and the database driver " +;
   "to use to save the file."

#define IDB_HELP_DBF_STRUCTURE_BODY;
    "ORDER - The column order may be changed modifying the " +;
    "serial number on the left. This information is " +;
    "temporary, that is, it is not part of the database file." +;
    NL(2) +;
    "FIELD NAME - The column name may be long 10 character max, it " +;
    "must begin with a letter and may contains also " +;
    "numbers and '_'; the space ' ' is not allowed." +;
    NL(2) +;
    "TYPE - The column type may be 'C' for character, 'N' for " +;
    "numeric, 'D' for data, 'L' for logic and 'M' for " +;
    "memo." +;
    NL(2) +;
    "LENGTH - The length is the column width in character." +;
    NL(2) +;
    "DECIMAL - Is the decimal portion of LENGTH when the " +;
    "column type identifies a number. The maximum decimal " +;
    "dimention is LENGTH -2 as the decimal point takes one " +;
    "place." +;
    NL(3) +;
    "The maximum column (field) width may be different " +;
    "depending on the active database driver." + NL(1) +;
    "For DBFNTX, the standard, the maximum dimentions are " +;
    "as follows:" +;
    NL(2) +;
    "C - Character - max length  = 255" + NL(1) +;
    "                max decimal = 250" + NL(1) +;
    "    Width = LENGTH + (DECIMAL * 256)" + NL(1) +;
    "    Max Width = 64255" +;
    NL(2) +;
    "N - Numeric - max length  = 16" + NL(1) +;
    "              max decimal = LENGTH-2" + NL(1) +;
    "    Width = LENGTH" +;
    NL(2) +;
    "D - Data - length  = leave 0" + NL(1) +;
    "           decimal = leave 0" +;
    NL(2) +;
    "L - Logic - length  = leave 0" + NL(1) +;
    "            decimal = leave 0" +;
    NL(2) +;
    "M - Memo - length  = leave 0" + NL(1) +;
    "           decimal = leave 0" +;
    NL(3) +;
    "After completing the column (field) description, " +;
    "press [Esc] to exit: the name to use to save " +;
    "the new structure will be asked."

#define IDB_HELP_DBF_CREATE;
    "." + _EXTENTION_DBF + " CREATION" +;
    NL(2) +;
    "This function permits to create a new database file." +;
    NL(3) +;
    IDB_HELP_DBF_STRUCTURE_BODY

#define IDB_HELP_DBF_MODIFY_STRUCTURE;
    "." + _EXTENTION_DBF + " STRUCTURE MODIFICATION" +;
    NL(2) +;
    "Only the content of columns with the same name " +;
    "are saved; the others are new empty columns." +;
    NL(3) +;
    IDB_HELP_DBF_STRUCTURE_BODY

#define IDB_HELP_NTX_CREATE;
    "INDEX/TAG CREATION" +;
    NL(2) +;
    "Create an index file (Order Bag) or add a Tag to " +;
    "an Order Bag." +;
    NL(2) +;
    "Depending on the active Database Driver, the following " +;
    "may be asked." +;
    NL(2) +;
    "- The index file (Order Bag) name." + NL(1) +;
    "- The key expression." + NL(1) +;
    "- The FOR condition."  + NL(1) +;
    "- The Tag name." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_FOR_CONDITION

#define IDB_HELP_SET_INDEX;
    "." + _EXTENTION_INDEXBAG + " FILE OPEN" +;
    NL(2) +;
    "It activates an index previously created."

#define IDB_HELP_DBF_OPEN;
    "." + _EXTENTION_DBF + " FILE OPEN" +;
    NL(2) +;
    "Open (use) another ." +;
    _EXTENTION_DBF + " file. " +;
    NL(2) +;
    "FILENAME - The complete file " +;
    "pathname of what is going to be opened." +;
    NL(2) +;
    "ALIAS - The name to be used as Alias." +;
    NL(2) +;
    "RDD - The Replaceable Database Driver name to be used." +;
    NL(2) +;
    "SHARED - When 'Shared' is set to true (T), the file is " +;
    "opened in shared mode." +;
    NL(2) +;
    "READ ONLY - When true, " +;
    "it will not be possible any modification to " +;
    "the file." +;
    NL(2) +;
    "To open a file in EXCLUSIVE mode, set both SHARED " +;
    "and READ ONLY to false (.F.)."

#define IDB_HELP_DBF_REPLACE;
    "FIELD REPLACE" +;
    NL(2) +;
    "It permits to modify the content of a " +;
    "column. The replace can be controlled by the " +;
    "WHILE and FOR conditions." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

#define IDB_HELP_DBF_RECALL;
    "DELETED RECORD RECALL" +;
    NL(2) +;
    "It permits to recall as many records as " +;
    "defined by the WHILE and FOR conditions." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

#define IDB_HELP_DBF_DELETE;
    "DELETE RECORDS" +;
    NL(2) +;
    "It permits to delete as many records as " +;
    "defined by the WHILE and FOR conditions." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

#define IDB_HELP_RELATION_DEFINITION;
    "RELATION DEFINITION" +;
    NL(2) +;
    "It makes a link between the active Alias and a 'child' " +;
    "one." +;
    NL(2) +;
    "Usually, the 'child' Alias is already associated " +;
    "to an index file." +;
    NL(2) +;
    "The expression defines the relation using elements " +;
    "from the active Alias."

//----------------------------------------------------------------
#define LBL_REMARK    1
#define LBL_HEIGHT    2
#define LBL_WIDTH     3
#define LBL_MARGIN    4
#define LBL_LINES     5
#define LBL_SPACES    6
#define LBL_ACROSS    7

#define LBL_SIZE      1034  // dimensione standard dei file di etichetta

#define LBL_DIALOG_BOX_LABEL_FORM_TOP;
   "LABEL FORM ..."

#define LBL_WINDOW_FILE_SEARCH_TOP;
   "Open File"
#define LBL_WINDOW_LABEL;
   "LABEL"

#define LBL_PROMPT_COMPRESSED_PRINT;
   "Compressed Print ? (Y/T/N/F) "
#define LBL_PROMPT_WHILE_EXPRESSION;
   "WHILE expression condition:"
#define LBL_PROMPT_FOR_EXPRESSION;
   "FOR expression condition:"
#define LBL_PROMPT_TO_FILE;
   "Periferal or destination file:"
#define LBL_PROMPT_SAVE_QUESTION;
   "Save?"
#define LBL_PROMPT_LABEL_REMARK;
   "Remark:"
#define LBL_PROMPT_LABEL_HEIGHT;
   "Height:"
#define LBL_PROMPT_LABEL_WIDTH;
   "Width: "
#define LBL_PROMPT_LABEL_MARGIN;
   "Margin:"
#define LBL_PROMPT_LABEL_LINES;
   "Lines: "
#define LBL_PROMPT_LABEL_SPACES;
   "Spaces:"
#define LBL_PROMPT_LABEL_ACROSS;
   "Across:"
#define LBL_PROMPT_OPEN_FILE_LABEL;
   "Label file name:"
#define LBL_PROMPT_SAVE_FILE_LABEL;
   "Name to use to save the label:"

#define LBL_HELP_LABEL;
    "STANDARD LABEL" +;
    NL(2) +;
    "It creates or modifies a label file, " +;
    "." + _EXTENTION_LABEL + ", under the dBaseIII+ standard." +;
    NL(2) +;
    "Labels may be printed in more than one column and can " +;
    "contain 16 lines maximum." +;
    NL(2) +;
    "REMARK - it will not be printed." +;
    NL(2) +;
    "HEIGHT - the label content; vertical dimension." +;
    NL(2) +;
    "WIDTH - the label content; horizzontal dimension." +;
    NL(2) +;
    "MARGIN - the left margin in character." +;
    NL(2) +;
    "LINES - the vertical spacing between labels." +;
    NL(2) +;
    "SPACES - the horizzontal spacing in character " +;
    "between label columns." +;
    NL(2) +;
    "ACROSS - the number of label columns." +;
    NL(2) +;
    "1-16 - the label content."

#define LBL_HELP_LABEL_FORM;
    "LABEL FORM PRINT" +;
    NL(2) +;
    "It may ask for:" +;
    NL(2) +;
    "- the label file name;" +;
    NL(2) +;
    "- the WHILE condition;" +;
    NL(2) +;
    "- the FOR condition." +;
    _STDHLP_START +;
    _STDHLP_EVER_TRUE +;
    _STDHLP_WHILE_CONDITION +;
    _STDHLP_FOR_CONDITION

#define LBL_HELP_LABEL_EDIT;
    "LABEL EDIT" +;
    NL(2) +;
    "It opens a label file and edit it."

#define LBL_HELP_LABEL_SAVE;
    "LABEL SAVE" +;
    NL(2) +;
    "It permit to specify the name to use to save this label."

#define LBL_ERROR_CANNOT_OPEN;
    "Cannot open this file. See FERROR() error n. "
#define LBL_ERROR_CANNOT_CREATE;
    "Cannot create this file. See FERROR() error n. "
#define LBL_ERROR_FILE_TOO_LITTLE;
    "File too little or empty."
#define LBL_ERROR_FILE_NOT_SAVED;
    "File not saved!"
#define LBL_ERROR_FILE_NOT_VALID;
    "File not valid."
#define LBL_ERROR_SOMETHING_GONE_WRONG;
    "Something is gone wrong during the label save."
#define LBL_ERROR_PRINT_SOMETHING_GONE_WRONG;
    "The label print is failed. Maybe the DBF file is not compatible."
#define LBL_ERROR_PRINT_FILE_NOT_FOUND;
    "The file do not exist."

#define LBL_WAIT_LOADING;
    "Loading..."
#define LBL_WAIT_SAVING;
    "Saving..."

//----------------------------------------------------------------
#define MACRO_DIALOG_BOX_TOP_COMPILE;
    'Macro "Compilation"'

#define MACRO_DIALOG_BOX_TOP_OPEN;
    "Macro Load and execute"

#define MACRO_DIALOG_BOX_TOP_EDIT;
    "Macro Edit"

#define MACRO_DIALOG_BOX_TOP_SAVE;
    "Save Macro"

#define MACRO_PROMPT_SOURCE_FILE;
    "Insert the source macro file name:"
#define MACRO_PROMPT_DESTINATION_FILE;
    "Insert the destination macro file name:"

#define MACRO_ALERT_ERASE;
    "Do you want to erase the macro recording?"


#define MACRO_PROMPT_LOAD;
    "Insert the macro file name:"
#define MACRO_PROMPT_LOAD_PAR1;
    "Insert the eventual 1st parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR2;
    "Insert the eventual 2nd parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR3;
    "Insert the eventual 3rd parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR4;
    "Insert the eventual 4th parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR5;
    "Insert the eventual 5th parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR6;
    "Insert the eventual 6th parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR7;
    "Insert the eventual 7th parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR8;
    "Insert the eventual 8th parameter for the macro:"
#define MACRO_PROMPT_LOAD_PAR9;
    "Insert the eventual 9th parameter for the macro:"

#define MACRO_PROMPT_SAVE_MACRO;
    "Insert the macro name:"

#define MACRO_COMPILE_HELP;
    "COMPILE A MACRO FILE." +;
    NL(3) +;
    "This dialog box helps you to specify a source macro to be " +;
    '"compiled" into a destination compiled macro.'

#define MACRO_LOAD_HELP;
    "LOAD AND RUN A MACRO FILE." +;
    NL(3) +;
    "This dialog box helps you to specify a macro to be " +;
    "loaded and executed." +;
    NL(2) +;
    "The macro name is then transferd inside the public " +;
    "variable c_Par0; parameters 1 to 9 are transferd inside " +;
    "variables c_Par1 to c_Par9."

#define MACRO_EDIT_HELP;
    "MODIFY RECORDED MACRO." +;
    NL(3) +;
    "This function lets you modify the macro you are " +;
    "recording." +;
    NL(3) +;
    "[Esc]          Leave without modification." +;
    NL(2) +;
    "[Ctrl]+[W]     Confirm modifications and exit the function."

#define MACRO_SAVE_HELP;
    "SAVE RECORDED MACRO." +;
    NL(3) +;
    "This function lets you save the recorded macro."

//----------------------------------------------------------------
#define LIST_WINDOW_BOTTOM   "[Esc] cancel  [Enter] select"

#define LIST_WINDOW_HELP;
    "SELECT AN ITEM." +;
    NL(3) +;
    "This function lets you select an item form a list." +;
    NL(3) +;
    "[Esc]          Leave without selecting anything." +;
    NL(2) +;
    "[Enter]        Select what appears under the cursor." +;
    NL(2) +;
    "[]/[]        Move the cursor up or down."
//----------------------------------------------------------------
#define MEMO_WINDOW_BOTTOM   "[Esc] cancel  [Ctrl]+[W] save"

#define MEMO_WINDOW_HELP;
    "LONG CHARACTER FIELD EDITOR." +;
    NL(3) +;
    "This function lets you modify a long character field " +;
    "just like a little text editor." +;
    NL(3) +;
    "[Esc]          Leave editing without modification." +;
    NL(2) +;
    "[Ctrl]+[W]     Confirm modifications and exit the function."
//----------------------------------------------------------------

#define MNU_MENU_FILE_CHOICE        "File"
#define MNU_MENU_EDIT_CHOICE        "Edit"
#define MNU_MENU_REPORT_CHOICE      "Report"
#define MNU_MENU_HTF_CHOICE         "Htf"
#define MNU_MENU_MACRO_CHOICE       "Macro"
#define MNU_MENU_INFO_CHOICE        "Info"
#define MNU_MENU_DOC_CHOICE         "Doc"

#define MNU_MENU_FILE_MSG;
    "File menu"
#define MNU_MENU_EDIT_MSG;
    "Editing menu"
#define MNU_MENU_REPORT_MSG;
    "Report menu"
#define MNU_MENU_HTF_MSG;
    "Help Text File menu"
#define MNU_MENU_MACRO_MSG;
    "Macro menu"
#define MNU_MENU_INFO_MSG;
    "Information menu"
#define MNU_MENU_DOC_MSG;
    "Text/Document menu"

#define MNU_MENU_FILE_NEWDIR_CHOICE;
    padr( "Change Directory",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_FILE_DBF_CHOICE;
    padr( "File ." + _EXTENTION_DBF,;
    _MENU_TENDINA_WIDTH-3 ) + ""
#define MNU_MENU_FILE_NTX_CHOICE;
    padr( "File ." + _EXTENTION_INDEXBAG,;
    _MENU_TENDINA_WIDTH-3 ) + ""
#define MNU_MENU_FILE_ALIAS_CHOICE;
    padr( "Alias",;
    _MENU_TENDINA_WIDTH-3 ) + ""
#define MNU_MENU_FILE_INDEX_CHOICE;
    padr( "Order",;
    _MENU_TENDINA_WIDTH-3 ) + ""
#define MNU_MENU_FILE_RELATION_CHOICE;
    padr( "Relation",;
    _MENU_TENDINA_WIDTH-3 ) + ""
#define MNU_MENU_FILE_RDD_DEFAULT_CHOICE;
    padr( "RDD Default",;
    _MENU_TENDINA_WIDTH-3 ) + ""

#define MNU_MENU_FILE_NEWDIR_MSG;
    "Change the actual directory"
#define MNU_MENU_FILE_DBF_MSG;
    "." + _EXTENTION_DBF + " file operations"
#define MNU_MENU_FILE_NTX_MSG;
    "." + _EXTENTION_INDEXBAG + " file operations"
#define MNU_MENU_FILE_ALIAS_MSG;
    "Alias operations"
#define MNU_MENU_FILE_INDEX_MSG;
    "Index/Order operations"
#define MNU_MENU_FILE_RELATION_MSG;
    "Relation operations"
#define MNU_MENU_FILE_RDD_DEFAULT_MSG;
   "Replaceable Database Driver"

#define MNU_MENU_FILE_DBF_NEW_CHOICE;
    padr( "New ." + _EXTENTION_DBF,;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_FILE_DBF_MODSTRU_CHOICE;
    padr( "Modify ." + _EXTENTION_DBF + " structure",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_FILE_DBF_OPEN_CHOICE;
    padr( "Open ." + _EXTENTION_DBF,;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"

#define MNU_MENU_FILE_DBF_NEW_MSG;
    "Create a new ." + _EXTENTION_DBF + " file"
#define MNU_MENU_FILE_DBF_OPEN_MSG;
    "Open a ." + _EXTENTION_DBF + " file"
#define MNU_MENU_FILE_DBF_MODSTRU_MSG;
    "Modify the structure of a ." + _EXTENTION_DBF + " file"

#define MNU_MENU_FILE_NTX_NEW_CHOICE;
    padr( "New ." + _EXTENTION_INDEXBAG + " / New Tag",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_FILE_NTX_OPEN_CHOICE;
    padr( "Open Index",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"

#define MNU_MENU_FILE_NTX_NEW_MSG;
    "Create a new index for the actual Alias or add a Tag"
#define MNU_MENU_FILE_NTX_OPEN_MSG;
    "Open and index for the actual Alias"

#define MNU_MENU_FILE_ALIAS_SELECT_CHOICE;
    padr( "Select",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_FILE_ALIAS_DISPSTRU_CHOICE;
    padr( "Display structure",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_FILE_ALIAS_CLOSE_CHOICE;
    padr( "Close active Alias",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_FILE_ALIAS_CLOSEALL_CHOICE;
    padr( "Close all Aliases",;
    _MENU_TENDINA_WIDTH-3 ) + "&"

#define MNU_MENU_FILE_ALIAS_SELECT_MSG;
    "Select another Alias or a new area"
#define MNU_MENU_FILE_ALIAS_DISPSTRU_MSG;
    "Show the actual Alias scructure"
#define MNU_MENU_FILE_ALIAS_CLOSE_MSG;
    "Close the actual Alias"
#define MNU_MENU_FILE_ALIAS_CLOSEALL_MSG;
    "Close all areas"

#define MNU_MENU_FILE_INDEX_REINDEX_CHOICE;
    padr( "Order List Rebuild",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_FILE_INDEX_SET_ORDER_CHOICE;
    padr( "Order Set Focus",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_FILE_INDEX_CLOSENTX_CHOICE;
    padr( "Order List Clear",;
    _MENU_TENDINA_WIDTH-3 ) + "&"

#define MNU_MENU_FILE_INDEX_SET_ORDER_MSG;
    "Select another index order for the actual Alias"
#define MNU_MENU_FILE_INDEX_REINDEX_MSG;
    "Index rebuild"
#define MNU_MENU_FILE_INDEX_CLOSENTX_MSG;
    "Close indexes for the actual Alias"

#define MNU_MENU_FILE_RELATION_SET_CHOICE;
    padr( "Set Relation",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_FILE_RELATION_CLOSE_CHOICE;
    padr( "Clear Relation",;
    _MENU_TENDINA_WIDTH-3 ) + "&"

#define MNU_MENU_FILE_RELATION_SET_MSG;
   "Define a relation"
#define MNU_MENU_FILE_RELATION_CLOSE_MSG;
   "Relise all relations for the actual Alias"

#define MNU_MENU_FILE_RDD_SHOW_CHOICE;
    padr( "Show actual RDD default",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_FILE_RDD_SET_DEFAULT_CHOICE;
    padr( "Set default RDD",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"

#define MNU_MENU_FILE_RDD_SHOW_MSG;
    "Show the default RDD"
#define MNU_MENU_FILE_RDD_SET_DEFAULT_MSG;
    "Define a new default RDD"

#define MNU_MENU_EDIT_VIEW_CHOICE;
    padr( "View",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_EDIT_BROWSE_CHOICE;
    padr( "Edit/Browse",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_EDIT_REPLACE_CHOICE;
    padr( "Replace",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_EDIT_RECALL_CHOICE;
    padr( "Recall",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_EDIT_DELETE_CHOICE;
    padr( "Delete",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_EDIT_PACK_CHOICE;
    padr( "Pack",;
    _MENU_TENDINA_WIDTH-3 ) + "&"

#define MNU_MENU_EDIT_BROWSE_MSG;
    "Browse the actual Alias"
#define MNU_MENU_EDIT_VIEW_MSG;
    "View the actual Alias"
#define MNU_MENU_EDIT_REPLACE_MSG;
    "Data replacement"
#define MNU_MENU_EDIT_RECALL_MSG;
    "Record undelete"
#define MNU_MENU_EDIT_DELETE_MSG;
    "Record delete"
#define MNU_MENU_EDIT_PACK_MSG;
    "Deleted record elimination"

#define MNU_MENU_REPORT_DBGOTOP_CHOICE;
    padr( "dbgotop()",;
    _MENU_TENDINA_WIDTH-6 ) + "   &"
#define MNU_MENU_REPORT_LABEL_NEW_CHOICE;
    padr( "New Label",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_REPORT_LABEL_MODIFY_CHOICE;
    padr( "Modify Label",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_REPORT_LABEL_FORM_CHOICE;
    padr( "Label Form",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_REPORT_REPORT_NEW_CHOICE;
    padr( "New Report",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_REPORT_REPORT_MODIFY_CHOICE;
    padr( "Modify Report",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_REPORT_REPORT_FORM_CHOICE;
    padr( "Report Form",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_REPORT_DOCUMENT_NEW_CHOICE;
    padr( "Create/Modify/Print Text",;
    _MENU_TENDINA_WIDTH-2 )

#define MNU_MENU_REPORT_DBGOTOP_MSG;
    "Go top record on the active Alias"
#define MNU_MENU_REPORT_LABEL_NEW_MSG;
    "Create a label file '.LBL'"
#define MNU_MENU_REPORT_LABEL_MODIFY_MSG;
    "Modify a label file '.LBL'"
#define MNU_MENU_REPORT_LABEL_FORM_MSG;
    "Print labels"
#define MNU_MENU_REPORT_REPORT_NEW_MSG;
    "Create a report file ." + _EXTENTION_FORM
#define MNU_MENU_REPORT_REPORT_MODIFY_MSG;
    "Modify a report file ." +_EXTENTION_FORM
#define MNU_MENU_REPORT_REPORT_FORM_MSG;
    "Print a report"
#define MNU_MENU_REPORT_DOCUMENT_NEW_MSG;
    "DOC() - Create / Modify / Print a text or document file"

#define MNU_MENU_HTF_GENERATE_CHOICE;
    padr( "New Help Text File",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_HTF_BROWSE_CHOICE;
    padr( "Open Help Text File",;
    _MENU_TENDINA_WIDTH-6 ) + "... "

#define MNU_MENU_HTF_GENERATE_MSG;
    "Generate a Help Text File from a Ascii text file"
#define MNU_MENU_HTF_BROWSE_MSG;
    "Open and browse a Help Text File"

#define MNU_MENU_MACRO_START_STOP_CHOICE;
    padr( iif( isMemvar( _MEMVAR_MACRO_RECORDING_NAME ),;
    "Pause Recording",;
    "Start Recording" ),;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_MACRO_SAVE_RECORD_CHOICE;
    padr( "Save Recording",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_MACRO_DELETE_RECORD_CHOICE;
    padr( "Erase Recording",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_MACRO_EDIT_RECORD_CHOICE;
    padr( "Edit Recording",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_MACRO_COMPILE_CHOICE;
    padr( 'Macro "compilation"',;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_MACRO_LOAD_CHOICE;
    padr( "Load + Execute Macro",;
    _MENU_TENDINA_WIDTH-6 ) + "... "

#define MNU_MENU_MACRO_START_STOP_MSG;
    "Start/Stop macro recording"
#define MNU_MENU_MACRO_SAVE_RECORD_MSG;
    "Save macro to file"
#define MNU_MENU_MACRO_DELETE_RECORD_MSG;
    "Delete macro recording"
#define MNU_MENU_MACRO_EDIT_RECORD_MSG;
    "Edit macro recording"
#define MNU_MENU_MACRO_COMPILE_MSG;
    'Macro "compilation"'
#define MNU_MENU_MACRO_LOAD_MSG;
    "Load and execute a macro file"

#define MNU_MENU_INFO_ABOUT_CHOICE;
    padr( "About",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_INFO_MANUAL_CHOICE;
    padr( "Manual browse",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_INFO_F1_CHOICE;
    padr( "[F1] help",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_INFO_F2_CHOICE;
    padr( "[F2] list",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_INFO_F3_CHOICE;
    padr( "[F3] Alias info",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_INFO_F5_CHOICE;
    padr( "[F5] Set output to",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_INFO_F8_CHOICE;
    padr( "[F8] Dot Line Calculator",;
    _MENU_TENDINA_WIDTH-2 )

#define MNU_MENU_INFO_ABOUT_MSG;
    "Copyright information"
#define MNU_MENU_INFO_MANUAL_MSG;
    "nB Manual browse"

#define MNU_MENU_DOC_NEW_CHOICE;
    padr( "New",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_DOC_OPEN_CHOICE;
    padr( "Open",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_DOC_SAVE_CHOICE;
    padr( "Save",;
    _MENU_TENDINA_WIDTH-2 )
#define MNU_MENU_DOC_SAVE_AS_CHOICE;
    padr( "Save as",;
    _MENU_TENDINA_WIDTH-6 ) + "... "
#define MNU_MENU_DOC_SET_DEFAULT_TO_CHOICE;
    padr( "Set output to",;
    _MENU_TENDINA_WIDTH-6 ) + "..." + "&"
#define MNU_MENU_DOC_PRINT_AS_IS_CHOICE;
    padr( "Print as it is",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_DOC_PRINT_ONCE_CHOICE;
    padr( "Print with RPT() once",;
    _MENU_TENDINA_WIDTH-3 ) + "&"
#define MNU_MENU_DOC_PRINT_CHOICE;
    padr( "Print with RPT() std",;
    _MENU_TENDINA_WIDTH-6 ) +"..." + "&"
#define MNU_MENU_DOC_EXIT_CHOICE;
    padr( "Exit DOC()",;
    _MENU_TENDINA_WIDTH-2 )

#define MNU_MENU_DOC_NEW_MSG;
    "Removes currently loaded file from memory"
#define MNU_MENU_DOC_OPEN_MSG;
    "Loads new file into memory"
#define MNU_MENU_DOC_SAVE_MSG;
    "Saves current file"
#define MNU_MENU_DOC_SAVE_AS_MSG;
    "Saves current file with specified name"
#define MNU_MENU_DOC_SET_DEFAULT_TO_MSG;
    "Determinate the output peripheral or file"
#define MNU_MENU_DOC_PRINT_AS_IS_MSG;
    "Prints the actual text/document as it appears on the screen"
#define MNU_MENU_DOC_PRINT_ONCE_MSG;
    "Prints once the actual text/document " +;
    "with the RPT() function"
#define MNU_MENU_DOC_PRINT_MSG;
    "Prints for every logical record " +;
    "the actual text/document with the RPT() function"
#define MNU_MENU_DOC_EXIT_MSG;
    "Exit " + DOC_FUNCTION_NAME

//----------------------------------------------------------------
// Report array definitions
#define RF_P_HEADER   1  // Array of header strings
#define RF_P_WIDTH    2  // Numeric, report page width
#define RF_P_LMARGIN  3  // Numeric, report page offset
#define RF_P_RMARGIN  4  // NIL, Not used
#define RF_P_LINES    5  // Numeric, number of lines per page
#define RF_P_SPACING  6  // Numeric, single=1, double=2
#define RF_P_BEJECT   7  // Logical, eject before 1st page
#define RF_P_AEJECT   8  // Logical, eject after last page
#define RF_P_PLAIN    9  // Logical, plain report
#define RF_P_SUMMARY  10  // Logical, no detail lines
#define RF_P_COLUMNS  11  // Array of Column arrays
#define RF_P_GROUPS   12  // Array of Group arrays
#define RF_P_HEADING  13  // Character, heading for the report

#define RF_P_COUNT    13  // Number of elements in the Report array


// Column array definitions ( one array per column definition )
#define RF_C_EXP      1  // Block, contains compiled column exp.
#define RF_C_TEXT     2  // Character, contains text column exp.
#define RF_C_TYPE     3  // Character, type of expression
#define RF_C_HEADER   4  // Array of column heading strings
#define RF_C_WIDTH    5  // Numeric, column width including
                         // decimals and decimal point
#define RF_C_DECIMALS 6  // Numeric, number of decimal places
#define RF_C_TOTAL    7  // Logical, total this column
#define RF_C_PICT     8  // Character, picture string

#define RF_C_COUNT    8  // Number of elements in the Column array


// Group array definitions ( one array per group definition )
#define RF_G_EXP      1  // Block, contains compiled group exp.
#define RF_G_TEXT     2  // Character, contains text group exp.
#define RF_G_TYPE     3  // Character, type of expression
#define RF_G_HEADER   4  // Character, column heading string
#define RF_G_AEJECT   5  // Logical, eject after group

#define RF_G_COUNT    5  // Number of elements in the Group array


#define RF_MSG_PAGENO       1
#define RF_MSG_SUBTOTAL     2
#define RF_MSG_SUBSUBTOTAL  3
#define RF_MSG_TOTAL        4
#define RF_MSG_COLSEP       5
#define RF_MSG_LINESEP      6

//----------------------------------------------------------------
#define RPT_DEFAULT_COMMAND_SYMBOL      "*"
#define RPT_DEFAULT_LPP                 60
#define RPT_ERROR_PRINT_COMMAND_UNCOMPLETED     "Print command uncompleted."
#define RPT_ERROR_PRINT_FILE_NOT_FOUND          "File not found."
#define RPT_ERROR_PRINT_ISOLATED_END;
    RPT_DEFAULT_COMMAND_SYMBOL + "END isolated."
#define RPT_ERROR_PARENTESES    "Error with   delimiters."

//----------------------------------------------------------------
#define SELECT_MESSAGE_NEW_AREA;
    "New Area"
#define SELECT_MESSAGE_NATURAL_ORDER;
    "Natural"
#define SELECT_WINDOW_TOP_SELECT;
    "Alias list"
#define SELECT_WINDOW_TOP_RDD;
    "Database driver list"
#define SELECT_WINDOW_TOP_ORDER;
    "Order list for the active Alias"

#define SELECT_HELP_RDD;
    "DATABASE DRIVER SELECTION" +;
    NL(2) +;
    "Select a database driver."

#define SELECT_HELP_SELECT;
    "ALIAS SELECTION" +;
    NL(2) +;
    "Select an Alias or a new area."

#define SELECT_HELP_ORDER;
    "ORDER SELECTION" +;
    NL(2) +;
    "Select an index order."

//----------------------------------------------------------------
#define SET_DIALOG_BOX_TOP_ALTERNATE_FILE;
    "SET OUTPUT TO ..."

#define SET_PROMPT_ALTERNATE_FILE;
    "Set output to (define output device):"

#define SET_HELP_ALTERNATE_FILE;
    "SET OUTPUT TO ..." +;
    NL(3) +;
    "A output filename or peripheral name must be specified." +;
    NL(3) +;
    "Examples:" +;
    NL(2) +;
    "CON       Console/Display." + NL(1) +;
    "PRN       Printer." + NL(1) +;
    "LPT1      Printer connected at LPT1." + NL(1) +;
    "LPT2      Printer connected at LPT2." + NL(1) +;
    "LPT3      Printer connected at LPT3." + NL(1) +;
    "LPT4      Printer connected at LPT4." + NL(1) +;
    "COM1      Printer connected at COM1." + NL(1) +;
    "COM2      Printer connected at COM2." + NL(1) +;
    "COM3      Printer connected at COM3." + NL(1) +;
    "COM4      Printer connected at COM4." + NL(1) +;
    NL(2) +;
    "If it is used a name not corresponding to any present " +;
    "peripheral, then, a text file with the same name and .TXT " +;
    "extention will be created."

//----------------------------------------------------------------
#define TEXT_KEY_REMINDER;
   "[Esc] Exit  [F7] Print  []/[]/[Pag]/[Pag] Move text."

//----------------------------------------------------------------
#define TB_FUNCTION_NAME        "Tb()"

#define TB_APP_MODE_ON( b )     ( b:cargo := TRUE  )
#define TB_APP_MODE_OFF( b )    ( b:cargo := FALSE )
#define TB_APP_MODE_ACTIVE( b ) ( b:cargo )
#define TB_ERROR_ARRAY_DIFFERENT_DIMENTIONS;
                                "TB() - Different dimention arrays."
#define TB_ERROR_NO_COLUMNS     "TB() - No Columns."
#define TB_ERROR_NO_PICTURES    "TB() - No Pictures."
#define TB_ERROR_RECORD_LOCKED  "TB() - Record locked.;Try again later."
#define TB_PROMPT_DELETE_RECORD "Delete Record?"
#define TB_WINDOW_BOTTOM_MEMO   "[Esc] cancel  [Ctrl]+[W] save"

#define TB_HELP;
    "Function " + TB_FUNCTION_NAME +;
    NL(2) +;
    "This function permits to browse the active Alias, " +;
    "eventually with relations." +;
    NL(3) +;
    "Special keys:" +;
    NL(2) +;
    "[Pag]        previous page;" + NL(1) +;
    "[Pag]        next page;" + NL(1) +;
    "[Ctrl]+[Pag] top of file;" + NL(1) +;
    "[Ctrl]+[Pag] bottom of file;" + NL(1) +;
    "[Ctrl]+[Home] first column;" + NL(1) +;
    "[Ctrl]+[End]  last column;" + NL(1) +;
    "[Ctrl]+[Y]    delete/recall record." +;
    NL(3) +;
    "When a memo field is edited:" +;
    NL(2) +;
    "[Esc]         cancel and close window;" + NL(1) +;
    "[Ctrl]+[Y]    line delete;" + NL(1) +;
    "[Ctrl]+[W]    save and close window."

//----------------------------------------------------------------
#define WAIT_DO_YOU_WANT_TO_BREAK;
    "[Esc] was pressed.;" +;
    "Do you want to break or continue the process?;" +;
    "As 'break' is not ever safe, if you select 'break', " +;
    "you accept all the consequences of this choice!"

#define WAIT_MENU_CHOICE_BREAK         "Break"
#define WAIT_MENU_CHOICE_CONTINUE      "Continue"

//================================================================
// STATIC GLOBAL
//================================================================
// used by doc()
#ifndef RUNTIME
    static docArray
#endif

// used by error*()
static errorChoice


#ifndef LINK
//================================================================
// nB - Main function
//================================================================
function nB( cPar0,;
             cPar1,;
             cPar2,;
             cPar3,;
             cPar4,;
             cPar5,;
             cPar6,;
             cPar7,;
             cPar8,;
             cPar9,;
             cPar10,;
             cPar11 )
//
// nB( [<cPar0>], [<cPar1>], [<cPar2>], [<cPar3>],
//     [<cPar4>], [<cPar5>], [<cPar6>], [<cPar7>],
//     [<cPar8>], [<cPar9>], [<cPar10>], [<cPar11>] ) --> NIL
//
// This is the main program function.
//
// <cPar0>      May contains the name of a macro program (&)
//              to be executed. If no paramenter is given,
//              nB() starts with the Dot() function.
//
// <cPar1> ... <cPar11> Optional parameters to send to a macro
//                      program via public variables:
//                      c_Par1 ... c_Par9.
//

    local cOldScreen
    local cOldColor           := setcolor()
    local bOldErrorHandler    :=;
        errorblock( {|e| ErrorHandler(e)} )
    local nOldRow             := row()
    local nOldCol             := col()

    local Result

#ifndef RUNTIME
    local lCopyright          := .T.
#else
    local lCopyright          := .F.
#endif    

    // Translate the calling parameters into public variables
    // for macro (&) use.
    public _MEMVAR_PAR0
    public _MEMVAR_PAR1
    public _MEMVAR_PAR2
    public _MEMVAR_PAR3
    public _MEMVAR_PAR4
    public _MEMVAR_PAR5
    public _MEMVAR_PAR6
    public _MEMVAR_PAR7
    public _MEMVAR_PAR8
    public _MEMVAR_PAR9

    begin sequence

        while .T.
            do case
            case cPar0 == "+C";         // copyright ON
                .or. cPar0 == "+c"
                lCopyright := .T.
            case cPar0 == "-C";         // copyright OFF
                .or. cPar0 == "-c"
                lCopyright := .F.
            case cPar0 == "+W";         // Wait Wheel ON
                .or. cPar0 == "+w"
                waitWheel(.T.)
            case cPar0 == "-W";         // Wait Wheel OFF
                .or. cPar0 == "-w"
                waitWheel(.F.)
            case cPar0 = "?";           // help
                .or. cPar0 = "-?";
                .or. cPar0 = "/?";
                .or. cPar0 = "-H";
                .or. cPar0 = "-h";
                .or. cPar0 = "/H";
                .or. cPar0 = "/h"
                //
                qqout( PROGRAM_COPYRIGHT_START )
                qqout( PROGRAM_COPYRIGHT_HELP )
                nOldRow := row()
                nOldCol := 0
                break
            case cPar0 == "+M";         // macro Compilation
                .or. cPar0 == "+m";
                .or. cPar0 == "-M";
                .or. cPar0 == "-m"
                qqout( PROGRAM_COPYRIGHT_START )
                cm( cPar1, cPar2 )
                break
            otherwise
                exit
            end    
            // Scroll.
            cPar0 := cPar1
            cPar1 := cPar2
            cPar2 := cPar3
            cPar3 := cPar4
            cPar4 := cPar5
            cPar5 := cPar6
            cPar6 := cPar7
            cPar7 := cPar8
            cPar8 := cPar9
            cPar9 := cPar10
            cPar10 := cPar11
            cPar11 := ""
        end

#ifdef RUNTIME
        if empty( cPar0 )
            // There is no macro call.
            // The copyright and help will be shown.
            qqout( PROGRAM_COPYRIGHT_START )
            qqout( PROGRAM_COPYRIGHT_HELP )
            nOldRow := row()
            nOldCol := 0
            break
        end    
#endif

        // Memvar save.
        Memvar->_MEMVAR_PAR0 := cPar0
        Memvar->_MEMVAR_PAR1 := cPar1
        Memvar->_MEMVAR_PAR2 := cPar2
        Memvar->_MEMVAR_PAR3 := cPar3
        Memvar->_MEMVAR_PAR4 := cPar4
        Memvar->_MEMVAR_PAR5 := cPar5
        Memvar->_MEMVAR_PAR6 := cPar6
        Memvar->_MEMVAR_PAR7 := cPar7
        Memvar->_MEMVAR_PAR8 := cPar8
        Memvar->_MEMVAR_PAR9 := cPar9

        // Copyright
        if lCopyright
            qqout( PROGRAM_COPYRIGHT_START )
            nOldRow := row()
            nOldCol := 0
        end

        // Copyright notice is saved with savescreen()
        cOldScreen      := savescreen()

        // Date for the next millenium.
        set( _SET_DATEFORMAT, "dd/mm/yyyy" )
        // Only one output device at a time.
        setOutput( "CON" )
        //set( _SET_CONSOLE, "ON" )
        //set( _SET_PRINTER, "OFF" )
        //set( _SET_ALTERNATE, .F.)
        //set( _SET_ALTFILE, "CON", .T. )
        //
        // No default directory path.
        set( _SET_DEFAULT, "")
        // Show deleted records.
        set( _SET_DELETED, "OFF" )
        // Do not exit automatically form a get.
        set( _SET_CONFIRM, "ON" )
        // No scoreborad (other infoline is supplied).
        set( _SET_SCOREBOARD, "OFF" )
        // Insert mode is normal.
        set( _SET_INSERT, "ON" )
        // Color.
        setcolor( COLOR_DEFAULT0 )
        // Replaceable database driver.
        rddsetdefault( _DEFAULT_RDD )
        // Rpt() do not Ejects sheets
        setRptEject( .F. )

        // Macro execution or Command line activation
        if !( empty( cPar0 ) )
            // The function EX() will check the file
            // existance.
            EX( cPar0 )
        else
            // command line
            dot()
        end

        // end of program
        dbcloseall()
        dbcommitall()
        scroll()
        setpos(0,0)

    recover
        // nil
    end sequence
    errorblock(bOldErrorHandler)

    // restore old values
    setcolor( cOldColor )
    restscreen( NIL, NIL, NIL, NIL, cOldScreen )
    setpos( nOldRow, nOldCol )

    return NIL

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// CM - MACRO "COMPILER" AND "COMPILED" MACRO EXECUTOR
//----------------------------------------------------------------
static function cm( cFileMacro, cFileCompiled )
//
// CM( <cFileMacro>, [<cFileCompiled>] ) --> nExitCode
//
// Compile <cFileMacro> into [<cFileMacro>].
//
// <cFileMacro>     The macro filename with extension.
// <cFileCompiled>  The compiled macro filename with extention.
//
//

    local bOldErrorHandler
    local cMacro
    local nReturn             := _MACRO_EXIT_NORMAL
    local nOldSelect          := select()
    local aStruct             := {}

    // The name must be alltrimed.
    cFileMacro := alltrim( cFileMacro )


    bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
    begin sequence
    
        // Test for macro file existance.
        if !file( cFileMacro )
            alert( cFileMacro + ";" +;
                _MACRO_ERROR_FILE_NOT_FOUND )
            nReturn := _MACRO_EXIT_NO_MACRO_FILE
            break
        end


        // cFileCompiled determination.
        if valtype(cFileCompiled) == "C"
            cFileCompiled :=;
                alltrim( strAddExtention( cFileCompiled,;
                _EXTENTION_COMPILED_MACRO ) )
        else
            cFileCompiled :=;
                strPath( cFileMacro ) +;
                strFile( cFileMacro )
            cFileCompiled := strCutExtention( cFileCompiled )
            cFileCompiled := strAddExtention( cFileCompiled,;
            _EXTENTION_COMPILED_MACRO )
        end

        // File existance.
        if file( cFileCompiled )
            if alert( cFileCompiled + ";" +;
                _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                { _MENU_NO, _MENU_YES } ) == 1
                //
                break
            end    
        end

        // A structure file is created using the default RDD
        aStruct := {}
        aadd( aStruct, { "Line",    "N", CM_MAX_LINES_DIGITS, 0 } )
        aadd( aStruct, { "Macro",   "C", SPACE_LEN, 0 } )
        aadd( aStruct, { "Command", "N", 2, 0 } )
        aadd( aStruct, { "Goto1",   "N", CM_MAX_LINES_DIGITS, 0 } )
        aadd( aStruct, { "Goto2",   "N", CM_MAX_LINES_DIGITS, 0 } )
        dbcreate( cFileCompiled, aStruct, _DEFAULT_RDD )

        // The structure file is opened
        dbusearea( .T., _DEFAULT_RDD, cFileCompiled,;
            CM_COMPILED_MACRO_ALIAS, .F., .F. )

        // Step 00
        waitFor( cFileMacro + NL(1) + CM_STEP00 )
        Append from (cFileMacro) fields Macro sdf

        // Step 01
        waitFor( cFileCompiled + NL(1) + CM_STEP01 )
        cmStep01()

        // Step 02
        waitFor( cFileCompiled + NL(1) + CM_STEP02 )
        cmStep02()

        // Step 03
        waitFor( cFileCompiled + NL(1) + CM_STEP03 )
        cmStep03()

        // Step 04
        waitFor( cFileCompiled + NL(1) + CM_STEP04 )
        pack

        // Step 05
        waitFor( cFileCompiled + NL(1) + CM_STEP05 )
        cmStep05()

        // Step 06
        waitFor( cFileCompiled + NL(1) + CM_STEP06 )
        cmStep06()

        waitfor()

        dbclosearea()

    recover

        if select(CM_COMPILED_MACRO_ALIAS) > 0
            // the file is still open
            (CM_COMPILED_MACRO_ALIAS)->(dbclosearea())
        end
    
    end sequence

    // Restore.
    select( nOldSelect )

    return nReturn

//----------------------------------------------------------------
static function cmStep01()
//
// *    line number save,
// *    comment cut,
// *    left trim.
//

    dbgotop()
    dbeval( {|| Field->Line := recno(),;
            Field->Macro :=;
            ltrim( exCommentCut( Field->Macro ) ) },;
        {||waitFileEval()},;
        ,,, .F. )
    waitFileEval( .T. )    

    return NIL

//----------------------------------------------------------------
static function cmStep02()
//
// *    more lines commands translated into one line.
//

    local nRecord
    local nNext
    
    dbgotop()

    for nRecord := 1 to lastrec()

        dbgoto( nRecord )
        waitFileEval()

        Field->Macro := cmSemicolon()

    next

    waitFileEval(.T.)

    return NIL
    
//----------------------------------------------------------------
static function cmSemicolon()
//
//

    local cCommand := rtrim( Field->Macro )
    
    if right( cCommand, 1 ) == ";"
        cCommand := left( cCommand, len( cCommand )-1 )
        dbskip(+1)
        if eof()
            alert( "(End Of File)" +;
                ";" +;
                _STATEMENT_ERROR_SEMICOLON_EOF )
            // Continue.
        end
        // Recursion.
        cCommand += cmSemicolon()
        Field->Macro := SPACE_STR
        dbskip(-1)
    end

    // Command line length.
    if len( cCommand ) > SPACE_LEN
        alert( "Line(" +;
            ltrim(str(Field->Line)) +;
            ")" +;
            ";" +;
            left(cCommand, 80) +;
            ";" +;
            _STATEMENT_ERROR_LINE_TOO_LONG )
    end

    return cCommand
    
//----------------------------------------------------------------
static function cmStep03()
//
// *    delete empty lines.
//

    dbgotop()
    dbeval( {|| iif( Field->Macro == SPACE_STR,;
            dbdelete(), NIL ) },;
        {||waitFileEval()},;
        ,,, .F. )
    waitFileEval( .T. )

    return NIL

//----------------------------------------------------------------
static function cmStep05()
//
// *    procedures.
//
// aProcedure[n][1] = Nth Procedure name,
// aProcedure[n][2] = Nth starting line position,
// 

    local aProcedure          := {}
    local nProcedure          := 0
    local cProcedure          := ""
    local nRecord
    local cCommand            := ""
    local nEndProc

    local nExitCode           := _MACRO_EXIT_NORMAL

    begin sequence

        for nRecord := 1 to lastrec()

            dbgoto( nRecord )

            waitFileEval()
            
            cCommand := Field->Macro

            // line analisys
            do case
            case upper( left( cCommand, 10 ) ) == "PROCEDURE "
                // Determinate the ENDPROCEDURE position.
                nEndProc := cmEndProc()
                // Save it on the array.
                cProcedure :=;
                    alltrim( substr( ltrim( cCommand ), 10 ) )
                cProcedure := upper( cProcedure )    
                aadd( aProcedure,;
                    { cProcedure, recno() } )
                // Update the CM file.
                Field->Command := _STATEMENT_PROCEDURE
                Field->Goto1   := nEndProc+1

            case upper( left( cCommand, 13 ) ) == "ENDPROCEDURE "
                Field->Command := _STATEMENT_ENDPROCEDURE

            case upper( left( cCommand, 7 ) ) == "RETURN "
                Field->Command := _STATEMENT_RETURN

            end

        next

        waitFileEval( .T. )

        // DOPROCEDURE can be scanned only when all procedure
        // are listed inside the aProcedure array.
        for nRecord := 1 to lastrec()

            dbgoto( nRecord )

            waitFileEval()
            
            cCommand := Field->Macro

            // line analisys
            do case
            case upper( left( cCommand, 13 ) ) == "DO PROCEDURE "
                cProcedure :=;
                    alltrim( substr( ltrim( cCommand ), 13 ) )
                cProcedure := upper( cProcedure )
                nProcedure := 1
                while .t.
                    if nProcedure > len( aProcedure )
                        alert( ;
                            "Line(" +;
                            ltrim(str(Field->Line)) +;
                            ")" +";" +;
                            cProcedure + ";" +;
                            _STATEMENT_ERROR_PROCEDURE_NOT_FOUND )
                        exit
                        // But the compilation will continue!
                    end
                    if aProcedure[nProcedure][1] == cProcedure
                        // Procedure found.
                        Field->Command := _STATEMENT_DOPROCEDURE
                        Field->Goto1 :=;
                            aProcedure[nProcedure][2]+1
                        exit
                    end
                    nProcedure++
                end
            end

        next

        waitFileEval( .T. )

    end sequence

    return nExitCode

//----------------------------------------------------------------
static function cmEndProc()

    local nOldRecord := recno()
    local nEndProc
    
    while .t.
        dbskip()
        do case
        case eof()
            alert( "( EOF )" + ";" +;
            _STATEMENT_ERROR_UNCLOSED_PROCEDURE )
            exit
        case upper( left( Field->Macro, 13 ) ) == "ENDPROCEDURE "
            exit
        end
    end

    nEndProc := recno()
    dbgoto( nOldRecord )

    return nEndProc

//----------------------------------------------------------------
static function cmStep06()
//

    local aNest               := array( _STATEMENT_MAX_NEST )
    local nNest               := 0
    local nRecord
    local cCommand            := ""
    local cCondition          := ""
    local nPosition
    local nPosition2

    local nExitCode           := _MACRO_EXIT_NORMAL

    begin sequence

        nNest := 1
        aNest[nNest]          := { _STATEMENT_MAIN }
        // [1]MAIN

        for nRecord := 1 to lastrec()

            waitFileEval()

            dbgoto( nRecord )
            cCommand := Field->Macro

            if eof()
                nExitCode := _MACRO_EXIT_NORMAL
                break
            end

            do case
            case upper( left( cCommand, 4 ) ) == "END "

                Field->Command  := _STATEMENT_END

                // Close one nest level.
                do case
                case aNest[nNest][1] == _STATEMENT_MAIN
                    // Not allowed.
                    alert( "(" + ltrim(str(Field->Line)) + ")" +";" +;
                        _STATEMENT_ERROR_ALONE_END )
                    // The compilation breaks.
                    nExitCode := _MACRO_EXIT_BREAK
                    break

                case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                    // Not allowed.
                    alert( "Line(" +;
                        ltrim(str(Field->Line)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_END )
                    // The compilation breaks.
                    nExitCode := _MACRO_EXIT_BREAK
                    break

                case aNest[nNest][1] == _STATEMENT_IF
                    aNest[nNest] := NIL
                    nNest--

                case aNest[nNest][1] == _STATEMENT_BEGIN
                    aNest[nNest] := NIL
                    nNest--

                case aNest[nNest][1] == _STATEMENT_WHILE
                    aNest[nNest] := NIL
                    nNest--

                case aNest[nNest][1] == _STATEMENT_DOCASE
                    aNest[nNest] := NIL
                    nNest--
                end

            case upper( left( cCommand, 10 ) ) == "PROCEDURE "
                // Procedure are already checked.
                nNest++
                aNest[nNest] := { _STATEMENT_PROCEDURE }
                // [1]PROCEDURE

            case upper( left( cCommand, 13 ) ) == "ENDPROCEDURE "
                do case
                case aNest[nNest][1] == _STATEMENT_PROCEDURE
                    aNest[nNest] := NIL
                    nNest--
                otherwise
                    // Not allowed.
                    alert( "Line(" +;
                        ltrim(str(Field->Line)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_ENDPROCEDURE )
                    // The compilation breaks.
                    nExitCode := _MACRO_EXIT_BREAK
                    break
                end

            case upper( left( cCommand, 15 ) ) == "BEGIN SEQUENCE "
                // Find End.
                nPosition := cmEndPosition()
                // Save one nest level.
                nNest++
                aNest[nNest] :=;
                    {_STATEMENT_BEGIN, nPosition }
                // [1]BEGIN SEQUENCE  [2]nEndPosition
                Field->Command := _STATEMENT_BEGIN
                Field->Goto1   := nPosition+1

            case upper( left( cCommand, 6 ) ) == "BREAK "
                    Field->Command := _STATEMENT_BREAK

            case upper( left( cCommand, 3 ) ) == "IF "
                nPosition := cmEndPosition()
                nPosition2 := cmElsePosition()
                nNest++
                aNest[nNest] := { _STATEMENT_IF, nPosition, nPosition2 }
                // [1]IF  [2]nEndPosition [3]nElsePosition

                Field->Command := _STATEMENT_IF
                Field->Goto1   := nPosition+1
                Field->Goto2   := nPosition2+1

            case upper( left( cCommand, 5 ) ) == "ELSE "
                Field->Command := _STATEMENT_ELSE

            case upper( left( cCommand, 8 ) ) == "DO CASE "
                nPosition := cmEndPosition()
                nNest++
                aNest[nNest] := {_STATEMENT_DOCASE, nPosition}
                // [1]DO CASE [2]nEndPosition
                Field->Command := _STATEMENT_DOCASE
                Field->Goto1   := nPosition+1

            case upper( left( cCommand, 5 ) ) == "CASE "
                if aNest[nNest][1] == _STATEMENT_DOCASE
                    // ok
                    nPosition := cmCasePosition()
                    Field->Command := _STATEMENT_CASE
                    Field->Goto1   := nPosition
                else
                    alert( "Line(" +;
                        ltrim( str( Field->Line ) ) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_CASE )
                    nExitCode := _MACRO_EXIT_BREAK
                    break
                end

            case upper( left( cCommand, 10 ) ) == "OTHERWISE "
                if aNest[nNest][1] == _STATEMENT_DOCASE
                    // ok
                    Field->Command := _STATEMENT_OTHERWISE
                else
                    alert( "Line(" +;
                        ltrim( str( Field->Line ) ) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_OTHERWISE )
                    nExitCode := _MACRO_EXIT_BREAK
                    break
                end

            case upper( left( cCommand, 6 ) ) == "WHILE "
                nPosition := cmEndPosition()
                nNest++
                aNest[nNest] := {_STATEMENT_WHILE, nPosition}
                // [1]WHILE  [2]nEndPosition
                Field->Command := _STATEMENT_WHILE
                Field->Goto1   := nPosition+1

            case upper( left( cCommand, 5 ) ) == "LOOP "
                Field->Command := _STATEMENT_LOOP

            case upper( left( cCommand, 5 ) ) == "EXIT "
                Field->Command := _STATEMENT_EXIT

            end

        end

    end sequence

    waitFileEval( .T. )

    return nExitCode

//----------------------------------------------------------------
static function cmEndPosition()
//
//

    local nOldRecord := recno()
    local nRecord    := recno()
    local nLevel     := 1
    local cLine

    begin sequence

        while .T.
            nRecord++
            dbgoto(nRecord)
            if eof()
                alert( "( EOF )" + ";" +;
                    "_STATEMENT_ERROR_NO_END" )
                break
            end

            cLine := upper( Field->Macro )

            do case
            case left( cLine, 4 ) == "END "
                nLevel--
                if nLevel == 0
                    // The right END is found
                    break
                end
            case left( cLine, 13 ) == "ENDPROCEDURE "
                // This is an error.
                alert( "Line(" +;
                    ltrim( str( Field->Line ) ) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_UNCLOSED_STRUCTURE )
                break
            case left( cLine, 6 ) == "WHILE ";
                .or. left( cLine, 3 ) == "IF ";
                .or. left( cLine, 15 ) == "BEGIN SEQUENCE ";
                .or. left( cLine, 8 ) == "DO CASE "
                //
                nLevel++
            end
        end

    end sequence

    dbgoto( nOldRecord )

    return nRecord
//----------------------------------------------------------------
static function cmElsePosition()
//
//

    local nOldRecord := recno()
    local nRecord    := recno()
    local nLevel     := 1
    local cLine

    begin sequence

        while .T.
            nRecord++
            dbgoto(nRecord)
            if eof()
                alert( "Line(End Of File)" +;
                    ";" +;
                    "_STATEMENT_ERROR_NO_END" )
                break
            end

            cLine := upper( Field->Macro )

            do case
            case nLevel == 1;
                .and. left( cLine, 5 ) == "ELSE "
                // The right ELSE is found.
                break
            case left( cLine, 4 ) == "END "
                nLevel--
                if nLevel == 0
                    // The right END is found
                    break
                end
            case left( cLine, 13 ) == "ENDPROCEDURE "
                // This is an error.
                alert( "Line(" +;
                    ltrim( str( Field->Line ) ) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_UNCLOSED_STRUCTURE )
                break
            case left( cLine, 6 ) == "WHILE ";
                .or. left( cLine, 3 ) == "IF ";
                .or. left( cLine, 15 ) == "BEGIN SEQUENCE ";
                .or. left( cLine, 8 ) == "DO CASE "
                //
                nLevel++
            end
        end

    end sequence

    dbgoto( nOldRecord )

    return nRecord

//----------------------------------------------------------------
static function cmCasePosition()
//
//

    local nOldRecord := recno()
    local nRecord    := recno()
    local nLevel     := 1
    local cLine

    begin sequence

        while .T.
            nRecord++
            dbgoto(nRecord)
            if eof()
                alert( "Line(End Of File)" +;
                    ";" +;
                    "_STATEMENT_ERROR_NO_END" )
                break
            end

            cLine := upper( Field->Macro )

            do case
            case nLevel == 1;
                .and. (;
                     left( cLine, 5 ) == "CASE ";
                     .or. left( cLine, 10 ) == "OTHERWISE ";
                     )
                // The next CASE or OTHERWISE is found.
                break
            case left( cLine, 4 ) == "END "
                nLevel--
                if nLevel == 0
                    // The right END is found
                    break
                end
            case left( cLine, 13 ) == "ENDPROCEDURE "
                // This is an error.
                alert( "Line(" +;
                    ltrim( str( Field->Line ) ) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_UNCLOSED_STRUCTURE )
                break
            case left( cLine, 6 ) == "WHILE ";
                .or. left( cLine, 3 ) == "IF ";
                .or. left( cLine, 15 ) == "BEGIN SEQUENCE ";
                .or. left( cLine, 8 ) == "DO CASE "
                //
                nLevel++
            end
        end

    end sequence

    dbgoto( nOldRecord )

    return nRecord

//----------------------------------------------------------------
static function  cmScanBack( aNest, nNest, cName )

    begin sequence

        while nNest > 0
            if aNest[nNest][1] == cName
                // Found.
                break
            else
                nNest--
            end
        end

    end sequence

return nNest

#endif
//----------------------------------------------------------------
static function cmExecute( cFileName )
//
// cmExecute( <cFileName> ) --> nExitCode
//
// <cFileName>  nB compiled macro file.
//
//

    local bSaveErrorHandler
    local nOldSelect          := select()
    local aNest               := array( _STATEMENT_MAX_NEST )
    local nNest               := 0
    local nRecord
    local cCondition          := ""
    local xResult

    local nExitCode           := _MACRO_EXIT_NORMAL

    begin sequence

        // Test for valid data.
        if valtype( cFileName ) == "C"
            cFileName := alltrim( cFileName )
        else
            break
        end

        // Test for macro file existance.
        if !file( cFileName )
            alert( cFileName + ";" +;
                _MACRO_ERROR_FILE_NOT_FOUND )
            nExitCode := _MACRO_EXIT_NO_MACRO_FILE
            break
        end

        // Open the macro file.
        (cmLastArea())->( dbusearea( .F., _DEFAULT_RDD, cFileName,;
            CM_COMPILED_MACRO_ALIAS, .T., .T. ) )

        // Main nest level.
        nNest := 1
        aNest[nNest]          := { _STATEMENT_MAIN }
        // [1]MAIN

        nRecord := 1
        (CM_COMPILED_MACRO_ALIAS)->(dbgoto( nRecord ))

        while !(CM_COMPILED_MACRO_ALIAS)->(eof())

            do case
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_END
                // Try to close one nest level.

                do case
                case aNest[nNest][1] == _STATEMENT_MAIN
                    // Not allowed.
                    alert( cFileName +;
                        "(" +;
                        ltrim(str((CM_COMPILED_MACRO_ALIAS)->Line )) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_END )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                case aNest[nNest][1] == _STATEMENT_IF;
                    .or. aNest[nNest][1] == _STATEMENT_THEN;
                    .or. aNest[nNest][1] == _STATEMENT_ELSE
                    //
                    aNest[nNest] := NIL
                    nNest--
                    nRecord++
                case aNest[nNest][1] == _STATEMENT_BEGIN
                    aNest[nNest] := NIL
                    nNest--
                    nRecord++
                case aNest[nNest][1] == _STATEMENT_WHILE
                    if &(aNest[nNest][4])
                        // Continue While loop.
                        nRecord := aNest[nNest][3]
                    else
                        // Terminate While loop.
                        aNest[nNest] := NIL
                        nNest--
                        nRecord++
                    end
                case aNest[nNest][1] == _STATEMENT_DOCASE
                    aNest[nNest] := NIL
                    nNest--
                    nRecord++
                case aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    aNest[nNest] := NIL
                    nNest--
                    nRecord++
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_PROCEDURE
                //
                // Jump after procedure.
                nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto1
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_DOPROCEDURE
                //
                nNest++
                aNest[nNest] :=;
                    { _STATEMENT_DOPROCEDURE, nRecord+1 }
                // [1]DOPROCEDURE  [2]nReturnLine
                // Jump to procedure begin.
                nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto1
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_RETURN
                //
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                        // Ok, ready to return.
                        nRecord := aNest[nNest][2]
                        aNest[nNest] := NIL
                        nNest--
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        // This RETURN must be considered
                        // as a "terminate file execution".
                        break
                    otherwise   
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_ENDPROCEDURE
                //
                do case
                case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                    // Ok, return.
                    nRecord := aNest[nNest][2]
                    aNest[nNest] := NIL
                    nNest--
                otherwise
                    alert( cFileName +;
                        "(" +;
                        ltrim(str((CM_COMPILED_MACRO_ALIAS)->Line)) +;
                        ")" +;
                        _STATEMENT_ERROR_ALONE_ENDPROCEDURE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_BEGIN
                //
                nNest++
                aNest[nNest] :=;
                    { _STATEMENT_BEGIN, (CM_COMPILED_MACRO_ALIAS)->Goto1 }
                // [1]BEGIN  [2] nAfterEnd
                nRecord++
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_BREAK
                //
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_BEGIN
                        nRecord := aNest[nNest][2]
                        aNest[nNest] := NIL
                        nNest--
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        alert( cFileName +;
                            "(" +;
                            ltrim(str((CM_COMPILED_MACRO_ALIAS)->Line)) +;
                            ")" +;
                           _STATEMENT_ERROR_ALONE_BREAK )
                        nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                        break
                    otherwise
                        // Back one nest level.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_IF
                //
                cCondition :=;
                    substr( (CM_COMPILED_MACRO_ALIAS)->Macro, 3 )
                do case
                case &(cCondition)
                    nNest++
                    aNest[nNest] :=;
                        { _STATEMENT_IF,;
                        (CM_COMPILED_MACRO_ALIAS)->Goto1 }
                    // [1]IF  [2]nAfterEnd
                    nRecord++
                otherwise
                    do case
                    case (CM_COMPILED_MACRO_ALIAS)->Goto1 ==;
                        (CM_COMPILED_MACRO_ALIAS)->Goto2
                        // Then there is no Else
                        // Jump over End.
                        nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto1
                    case (CM_COMPILED_MACRO_ALIAS)->Goto1 >;
                        (CM_COMPILED_MACRO_ALIAS)->Goto2
                        // There is a Else
                        nNest++
                        aNest[nNest] :=;
                            { _STATEMENT_IF,;
                            (CM_COMPILED_MACRO_ALIAS)->Goto1 }
                            // [1]IF  [2]nAfterEnd
                        nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto2
                    otherwise
                        // There is a error
                    end
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_ELSE
                //
                do case
                case aNest[nNest][1] == _STATEMENT_IF
                    // A Then was executed, so
                    // jump it.
                    nRecord := aNest[nNest][2]
                    // Back one nest level.
                    aNest[nNest] := NIL
                    nNest--
                otherwise
                    alert( cFileName +;
                        "(" +;
                        ltrim(str((CM_COMPILED_MACRO_ALIAS)->Line)) +;
                        ")" +;
                        _STATEMENT_ERROR_ALONE_ELSE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_DOCASE
                //
                nNest++
                aNest[nNest] :=;
                    { _STATEMENT_DOCASE, (CM_COMPILED_MACRO_ALIAS)->Goto1 }
                // [1]DOCASE  [2]nAfterEndCase
                nRecord++
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_CASE
                //
                do case
                case aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    // Jump after endcase.
                    nRecord := aNest[nNest][2]
                    // Back one nest level.
                    aNest[nNest] := NIL
                    nNest--
                case aNest[nNest][1] == _STATEMENT_DOCASE
                    cCondition :=;
                        substr( (CM_COMPILED_MACRO_ALIAS)->Macro, 5 )
                    do case
                    case &(cCondition)
                        aNest[nNest][1] := _STATEMENT_CASEMATCHED
                        // No more case.
                        // Execute following lines until next
                        // Case or Otherwise or End.
                        nRecord++
                    otherwise
                        // Next case or otherwise or endcase
                        nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto1
                    end
                otherwise
                    alert( cFileName +;
                        "(" +;
                        ltrim(str((CM_COMPILED_MACRO_ALIAS)->Line)) +;
                        ")" +;
                        _STATEMENT_ERROR_ALONE_CASE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_OTHERWISE
                //
                do case
                case aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    // Jump after endcase.
                    nRecord := aNest[nNest][2]
                    // Back one nest level.
                    aNest[nNest] := NIL
                    nNest--
                case aNest[nNest][1] == _STATEMENT_DOCASE
                    aNest[nNest][1] := _STATEMENT_CASEMATCHED
                    // no more case
                    nRecord++
                otherwise
                    alert( cFileName +;
                        "(" +;
                        ltrim( str( (CM_COMPILED_MACRO_ALIAS)->Line ) ) +;
                        ")" +;
                        _STATEMENT_ERROR_ALONE_OTHERWISE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_WHILE
                //
                cCondition :=;
                    substr( (CM_COMPILED_MACRO_ALIAS)->Macro, 6 )
                do case
                case &(cCondition)
                    // Ok, go on.
                    nNest++
                    aNest[nNest] :=;
                        { _STATEMENT_WHILE,;
                        (CM_COMPILED_MACRO_ALIAS)->Goto1,;
                        nRecord+1,;
                        cCondition }
                    // [1]WHILE  [2]nAfterEndWhile
                    // [3]nLine1stStatement [4]cCondition
                    nRecord++
                otherwise
                    nRecord := (CM_COMPILED_MACRO_ALIAS)->Goto1
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_LOOP
                //
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_WHILE
                        do case
                        case &(aNest[nNest][4])
                            // loop
                            nRecord := aNest[nNest][3]
                        otherwise
                            // exit
                            nRecord := aNest[nNest][2]
                            // Back one nest level.
                            aNest[nNest] := NIL
                            nNest--
                        end
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        alert( cFileName +;
                            "(" +;
                            ltrim( str( (CM_COMPILED_MACRO_ALIAS)->Line ) ) +;
                            ")" +;
                            _STATEMENT_ERROR_ALONE_LOOP )
                        nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                        break
                    otherwise
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end
            case (CM_COMPILED_MACRO_ALIAS)->Command ==;
                _STATEMENT_EXIT
                //
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_WHILE
                        nRecord := aNest[nNest][2]
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        alert( cFileName +;
                            "(" +;
                            ltrim( str( (CM_COMPILED_MACRO_ALIAS)->Line ) ) +;
                            ")" +;
                            _STATEMENT_ERROR_ALONE_EXIT )
                        nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                        break
                    otherwise
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end

            otherwise
                // If we are here, it must be a function

                bSaveErrorHandler :=;
                    errorblock( { |e| errorMacro(;
                        e,;
                        cFileName,;
                        (CM_COMPILED_MACRO_ALIAS)->Line,;
                        rtrim((CM_COMPILED_MACRO_ALIAS)->Macro);
                        ) } )
                begin sequence
                    // Execute with macro compiler.
                    xResult := &((CM_COMPILED_MACRO_ALIAS)->Macro)
                recover
                    do case
                    case errorChoice == ERROR_MENU_CHOICE_IGNORE
                        // Ignore error.
                    case errorChoice == ERROR_MENU_CHOICE_BREAK
                        nExitCode := _MACRO_EXIT_BREAK
                    end
                end sequence
                errorblock(bSaveErrorHandler)

                if nExitCode == _MACRO_EXIT_BREAK
                    break
                end

                nRecord++

            end

            (CM_COMPILED_MACRO_ALIAS)->(dbgoto( nRecord ))

        end

    end sequence

    if select(CM_COMPILED_MACRO_ALIAS) > 0
        // the file is still open
        (CM_COMPILED_MACRO_ALIAS)->(dbclosearea())
    end

    select( nOldSelect )

    return nExitCode

//----------------------------------------------------------------
static function cmLastArea()

    local nSelect

    for nSelect := _MAX_SELECT to 1 step -1
        if !(nSelect)->(used())
            return nSelect
        end
    end

    return 0
    
//----------------------------------------------------------------
// DBI - DB INFO
//----------------------------------------------------------------
static function dbiStatus(lRecursion)
//
// dbiStatus( [<lRecursion>] ) --> cDbInformations
//
// <lRecursion>     If true, it is a recursive call.
//
// This function returns the information on all the Aliases
// in all areas in text form.
// The paramenter <lRecursuion> is used for internal recursive
// call.
//

    local cFileInfo := ""
    local cOrdKey := ""
    local cLinkExpr := ""
    local nOrder    := 0
    local nRelation := 0
    local cFilter   := ""
    local nRelSelect := 0

    // default
    if lRecursion == NIL
        lRecursion := .F.
    end

    if len( alias() ) == 0
        // No file is available now.
        cFileInfo := _ERROR_NO_ALIAS
    else
        cFileInfo := "Select n. " +;
            alltrim( str( select() ) ) + NL(1)
        cFileInfo += "Alias: " + alias() + NL(1)

        nOrder := 1
        while .T.
            cOrdKey := ordkey( nOrder )
            if cOrdKey == ""
                exit
            else
                cFileInfo += "Order n. " +;
                    alltrim( str( nOrder ) ) +;
                    ": " + ordname(nOrder) + " " + cOrdKey + NL(1)
            end
            nOrder++
        end

        cFilter := dbfilter()
        if cFilter == ""
            // exit
        else
            cFileInfo += "Filter : " + cFilter + NL(1)
        end

        nRelation := 0
        while .T.
            cLinkExpr := dbrelation( ++nRelation )
            if cLinkExpr == ""
                exit
            else
                nRelSelect := dbrselect( nRelation )
                cFileInfo += "Relation n. " +;
                    alltrim( str( nRelation ) ) +;
                    " " + alias(nRelSelect) +;
                    ": " + cLinkExpr + NL(1) +;
                    "--------------------" + NL(1) +;
                    (nRelSelect)->(dbiStatus(.T.)) + NL(1) +;
                    "--------------------" + NL(1) +;
                    "end Relation n. " +;
                    alltrim( str( nRelation ) ) +;
                    " " + alias(nRelSelect)
            end
        end

    end

    return cFileInfo

//----------------------------------------------------------------
static function dbiStructure()
//
// dbiStructure() --> cTextStructure
//                --> NIL
//
// It returns a text containing the active Alias structure

    local cOldRdd
    local cStructure := ""
    local cOldAlias  := ""

    if alias() == "";
        // null string means no active alias
        //
        alert( _ERROR_NO_ALIAS )
        return NIL
    end

    // Alias name save
    cOldAlias := alias()

    // Copy structure with default rdd
    cOldRdd := rddsetdefault( _DEFAULT_RDD )
    copy structure extended to &(strTempPath()+"\TMP_STRU")
    rddsetdefault( cOldRdd )

    // new select
    dbusearea(.T., _DEFAULT_RDD, strTempPath()+"\TMP_STRU",;
        "TMP_STRU", .F., .F.)
    if neterr()
        select(cOldAlias)
        return NIL
    end

    TMP_STRU->(dbgotop())
    cStructure := "Alias: " + cOldAlias +;
         NL(2) +;
         DBI_STRUCTURE_TOP +;
         NL(2)
    while .T.
        cStructure +=;
            TMP_STRU->Field_Name + " " +;
            TMP_STRU->Field_Type + " " +;
            str( TMP_STRU->Field_Len, 3, 0 ) + " " +;
            str( TMP_STRU->Field_Dec, 4, 0 ) + NL(1)
        skip +1
        if TMP_STRU->(eof())
            exit
        end
    end

    // Close temp file.
    TMP_STRU->(dbclosearea())

    // restore previous Alias
    select(cOldAlias)

    return cStructure

#ifndef RUNTIME
//----------------------------------------------------------------
// DOT - COMMAND LINE
//----------------------------------------------------------------
static function Dot()
//&
//
// Dot () --> NIL
//
// Interactive "dot" command line. Only functions and calculations
// allowed.
//

    local getlist           := {}
    local bOld_F1           :=;
        setkey( K_F1, { || Text( DOT_HELP )} )
    local bOld_F3           :=;
        setkey( K_F3, { || Text( dbiStatus() ) } )
    local bOld_F5           :=;
        setkey( K_F5, { || setAlternate()} )
    local bOld_F8           :=;
        setkey( K_F8, { || dotLine()} )


    local bOldErrorHandler
    local cOldScreen     := savescreen()

    local lMore     := .T.
    local cCommand  := SPACE_STR
    local acCommand := {}
    local nMax      := 0
    local nInd      := 0

    // clear screen
    scroll()

    // loop
    while .T.

        // Show the status line.
        statusLine()

        // Clear last 2 lines on the screen
        scroll( maxrow()-1,00,maxrow(),maxcol() )
        setpos( maxrow(), 00 )

        setpos( maxrow(), 00 )
        dispout( padc( DOT_KEY_REMINDER, maxcol()+1 ) )

        @maxrow()-1,00;
            get cCommand;
            picture "@s"+ltrim(str(maxcol()+1))+"@";
                when ( truesetkey( K_F10,;
                        { || assist(), statusLine() } );
                    .and. truesetkey( K_ALT_M,;
                        { || assist(), statusLine() } );
                    .and. truesetkey( K_F2,;
                        { || cCommand :=;
                        padr( dotList( acCommand ),;
                        SPACE_LEN ) } ) )
        readmodal(getlist)
        getlist := {}

        do case
        case lastkey() = K_PGUP  // previous
            if nInd > 1
                if nInd > nMax
                    nInd := nMax
                else
                    nInd--
                end
                cCommand := padr( acCommand[nInd], SPACE_LEN )
            end
        case lastkey() = K_PGDN  // next
            do case
            case nInd < nMax
                nInd++
                cCommand := padr( acCommand[nInd], SPACE_LEN )
            case nInd >= nMax
                cCommand := SPACE_STR
                nInd := nMax +1
            otherwise
                // nil
            end
        case lastkey() = K_ESC
            if alert( DOT_PROMPT_EXIT,;
                { _MENU_YES, _MENU_NO } ) == 1
                //
                exit
            end
        case lastkey() = K_ENTER
            cCommand := alltrim( cCommand )
            if !empty( cCommand )
                // Scroll Screen up 2 lines.
                scroll(00,00,maxrow()-2,maxcol(), +2)
                setpos( maxrow()-3, 00 )
                dispout( cCommand )
                // Save error handler.
                bOldErrorHandler :=;
                    errorblock( {|e| ErrorHandler(e)} )
                begin sequence
                    setpos( maxrow()-2, 00 )
                    dispout( &(cCommand) )

                    // Macro recorder
                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            alltrim( cCommand )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    end

                    // Array increment or swap.
                    nInd := ascan( acCommand, cCommand )
                    if nInd == 0
                        aadd( acCommand, cCommand )
                    else
                        adel( acCommand, nInd )
                        acCommand[nMax] := cCommand
                    end

                recover
                    setpos( maxrow()-2, 00 )
                    dispout( DOT_MESSAGE_ERROR )
                end
                errorblock(bOldErrorHandler)

                // Array pointer update.
                nMax := len( acCommand )
                nInd := nMax +1

                // cCommand prepare
                cCommand := SPACE_STR

            else
                cCommand := SPACE_STR
            end

        otherwise
            // nil
        end
    end

    setkey( K_F1, bOld_F1 )
    setkey( K_F3, bOld_F3 )
    setkey( K_F5, bOld_F5 )
    setkey( K_F8, bOld_F8 )

    restscreen( NIL, NIL, NIL, NIL, cOldScreen )

    return NIL

//----------------------------------------------------------------
static function dotList( acCommand )
//

    local cOldScreen    := savescreen() // all the screen
    local cOldColor     := setcolor()
    local nOldCursor    := setcursor( SC_NONE )
    local nOldRow       := row()
    local nOldCol       := col()
    local bOld_F1       :=;
        setkey( K_F1, {|| Text( DOT_HELP_LIST ) } )
    local bOld_F2       := setkey( K_F2, NIL )
    local nTop          := 0
    local nLeft         := 0
    local nBottom       := 0
    local nRight        := 0
    local nWidth        := 0
    local nHeight       := 0

    local nI            := 0

    local cReturn       := ""

    begin sequence

        // Create a kind of window.
        nTop    := 1
        nLeft   := 0
        nBottom := maxrow()
        nRight  := maxcol()
        nWidth  := nRight - nLeft +1
        nHeight := nBottom - nTop +1

        if nHeight > len( acCommand ) +2
            nTop := nBottom - len( acCommand ) -1
        end

        setcolor( COLOR_DEFAULT1 )
        @nTop, nLeft;
            say padc( DOT_LIST_WINDOW_TOP, nWidth )
        @nBottom, nLeft;
            say padc( DOT_LIST_KEY_REMINDER, nWidth )
        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft, nBottom-1, nRight )
        nI := achoice( nTop+1, nLeft,;
            nBottom-1, nRight, acCommand,,, len(acCommand) )

        do case
        case nI == 0  // [Esc]
            // nil
        case nI > 0   // [Enter]
            cReturn := acCommand[nI]
        otherwise
            // nil
        end

    end sequence

    // restore
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( ,,,, cOldScreen )
    setpos( nOldRow, nOldCol )

    return cReturn

#endif
//----------------------------------------------------------------
// ERROR - ERROR HANDLING
//----------------------------------------------------------------
static function errorHandler(e)
//
// errorHandler( <oError> ) --> lRetry
//
// <oError>    Error object.
//
// Error handling function. If it don't breaks or quit, it returns
// true if a "retry" choice is made, or false if a "default" choice
// is made by the user.
//
// Example:
//
//  * Save the previous error handler
//  bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
//  *
//  begin sequence
//      * Action to be protected from the new error handler
//      ...
//      ...
//  recover
//      * Alternative action to be taken when an error
//      * followed by a break is occurred
//      dbcloseall()
//      ...
//  end sequence
//  * Restore previous error handler
//  errorblock( bOldErrorHandler )
//

    local cMessage
    local aOptions
    local nChoice

    // zero division => 0
    if ( e:genCode == EG_ZERODIV )
        return (0)
    end

    // network open error
    if ( e:genCode == EG_OPEN;
        .and. e:osCode == 32;
        .and. e:canDefault )
        //
        neterr(.T.)
        return (.F.)
    end

    // lock error during APPEND BLANK
    if ( e:genCode == EG_APPENDLOCK .and. e:canDefault )
        neterr(.T.)
        return (.F.)
    end

    // build error message
    cMessage := ErrorMessage(e)

    // build options array
    aOptions := {ERROR_MENU_CHOICE_BREAK}
    if (e:canRetry)
        aadd(aOptions, ERROR_MENU_CHOICE_RETRY)
    end
    if (e:canDefault)
        aadd(aOptions, ERROR_MENU_CHOICE_DEFAULT)
    end
    aadd(aOptions, ERROR_MENU_CHOICE_QUIT)

    // alert box
    nChoice := 0
    while ( nChoice == 0 )
        nChoice := alert( cMessage, aOptions )
        if ( nChoice == NIL )
            exit
        end
    end

    // do as instructed
    do case
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_BREAK )
        break(e)
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_RETRY )
        return (.T.)
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_DEFAULT )
        return (.F.)
    otherwise
        // exit
    end

    cMessage += ErrorMoreInfo(e)

    Text( cMessage )

    // end of program
    errorlevel(1)
    quit

    return (.F.)

//----------------------------------------------------------------
static function errorMessage(e)

    local cMessage

    // start error message
    cMessage := if( e:severity > ES_WARNING, "Error ", "Warning " )

    // add subsystem name if available
    if ( ValType(e:subsystem) == "C" )
        cMessage += e:subsystem()
    else
        cMessage += "???"
    end

    // add subsystem's error code if available
    if ( ValType(e:subCode) == "N" )
        cMessage += ("/" + alltrim( str(e:subCode) ) )
    else
        cMessage += "/???"
    end

    // add error description if available
    if ( ValType(e:description) == "C" )
        cMessage += ("  " + e:description)
    end

    // add either filename or operation
    if ( !Empty(e:filename) )
        cMessage += (": " + e:filename)
    elseif ( !Empty(e:operation) )
        cMessage += (": " + e:operation)
    end

    // add dos error
    if !( Empty(e:osCode) )
        cMessage += ";(DOS Error " + alltrim( str(e:osCode) ) + ")"
    end

    return cMessage

//----------------------------------------------------------------
static function errorMoreInfo(e)

    local cMessage := ""
    local i := 0

    cMessage += NL(2)

    // Procedure names
    i := 2 // to jump ErrorHandler() and ErrorMoreInfo()
    while ( !Empty(procname(i)) )
        cMessage += rtrim( ProcName(i) ) +;
            "(" + alltrim( str( ProcLine(i) ) ) + ")" +;
            NL(1)
        i++
    end

    // Active Alias
    if len( alias() ) == 0
        cMessage += NL(1)
        cMessage += "Actual area n. 0 - New Area"
    else
        cMessage += "Actual area n. " +;
             alltrim( str( select() ) ) +;
             " - Alias: " + alias() + NL(1) +;
             "----------"
    end

    // All Aliases informations
    for i := 1 to _MAX_SELECT
        if !( alias(i) == "" )
            cMessage += NL(1)
            cMessage += (i)->(dbiStatus());
                // at end there is a NL(1)
            cMessage += "----------"
        end
    next

    return cMessage

//----------------------------------------------------------------
static function errorMacro( e, cName, nLine, cCommand )
//
// Macro executor error handler
//

    local cMessage
    local aOptions
    local nChoice

    // zero division => 0
    if ( e:genCode == EG_ZERODIV )
        return (0)
    end

    // network open error
    if ( e:genCode == EG_OPEN;
        .and. e:osCode == 32;
        .and. e:canDefault )
        //
        neterr(.T.)
        return (.F.)
    end

    // lock error during APPEND BLANK
    if ( e:genCode == EG_APPENDLOCK .and. e:canDefault )
        neterr(.T.)
        return (.F.)
    end

    // build error message
    cMessage := errorMsgMacro( e, cName, nLine, cCommand )

    // build options array
    aOptions :=;
        {;
        ERROR_MENU_CHOICE_IGNORE,;
        ERROR_MENU_CHOICE_BREAK;
        }
    if (e:canRetry)
        aadd(aOptions, ERROR_MENU_CHOICE_RETRY)
    end
    if (e:canDefault)
        aadd(aOptions, ERROR_MENU_CHOICE_DEFAULT)
    end
    aadd(aOptions, ERROR_MENU_CHOICE_QUIT)

    // alert box
    nChoice := 0
    while ( nChoice == 0 )
        nChoice := alert( cMessage, aOptions )
        if ( nChoice == NIL )
            exit
        end
    end

    // do as instructed
    do case
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_IGNORE )
        // Save status on static variable.
        errorChoice := ERROR_MENU_CHOICE_IGNORE
        // Break
        break(e)
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_BREAK )
        // Save status on static variable.
        errorChoice := ERROR_MENU_CHOICE_BREAK
        // Break
        break(e)
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_RETRY )
        return (.T.)
    case ( aOptions[nChoice] == ERROR_MENU_CHOICE_DEFAULT )
        return (.F.)
    otherwise
        // exit
    end

    cMessage := errorInfMacro( e, cName, nLine, cCommand )

    Text( cMessage )

    // end of program
    errorlevel(1)
    quit

    return (.F.)

//----------------------------------------------------------------
static function errorMsgMacro( e, cName, nLine, cCommand )

    local cMessage := ""

    // Prepare cCommand.
    cCommand := alltrim( cCommand )
    if len( cCommand ) > SPACE_LEN /2
        cCommand :=;
            left( cCommand, SPACE_LEN /2 ) +;
            ""
    end

    // start error message
    cMessage :=;
        upper(alltrim(cName)) +;
        "(" +;
        ltrim( str( nLine ) ) +;
        ")" +;
        ";" +;
        cCommand +;
        ";"
    cMessage += if( e:severity > ES_WARNING, "Error ", "Warning " )

    // add subsystem name if available
    if ( ValType(e:subsystem) == "C" )
        cMessage += e:subsystem()
    else
        cMessage += "???"
    end

    // add subsystem's error code if available
    if ( ValType(e:subCode) == "N" )
        cMessage += ("/" + alltrim( str(e:subCode) ) )
    else
        cMessage += "/???"
    end

    // add error description if available
    if ( ValType(e:description) == "C" )
        cMessage += ("  " + e:description)
    end

    // add either filename or operation
    if ( !Empty(e:filename) )
        cMessage += (": " + e:filename)
    elseif ( !Empty(e:operation) )
        cMessage += (": " + e:operation)
    end

    // add dos error
    if !( Empty(e:osCode) )
        cMessage += ";(DOS Error " + alltrim( str(e:osCode) ) + ")"
    end

    return cMessage

//----------------------------------------------------------------
static function errorInfMacro( e, cName, nLine, cCommand )

    local cMessage := ""
    local i        := 0

    // start error message
    cMessage :=;
        upper(alltrim(cName)) +;
        "(" +;
        ltrim( str( nLine ) ) +;
        ")" +;
        NL(1) +;
        cCommand +;
        NL(1)

    // Active Alias
    if len( alias() ) == 0
        cMessage += NL(1)
        cMessage += "Actual area n. 0 - New Area"
    else
        cMessage += "Actual area n. " +;
             alltrim( str( select() ) ) +;
             " - Alias: " + alias() + NL(1) +;
             "----------"
    end

    // All Aliases informations
    for i := 1 to _MAX_SELECT
        if !( alias(i) == "" )
            cMessage += NL(1)
            cMessage += (i)->(dbiStatus());
                // at end there is a NL(1)
            cMessage += "----------"
        end
    next

    return cMessage

#ifndef RUNTIME
//----------------------------------------------------------------
// FIELD - FIELD SELECTION
//----------------------------------------------------------------
static function fieldNormal()
//
// this function calls fieldArray() and returns the selected
// field name or "" if no choice was made.
//

    local aMyField            := {}
    local cReturnString       := ""

    begin sequence

        aMyField := fieldArray()

        do case
        case len( aMyField ) == 0
            cReturnString := ""
        otherwise
            cReturnString := aMyField[DBS_NAME]
        end

    end sequence

    return cReturnString

//----------------------------------------------------------------
static function fieldIndex()
//
// this function calls fieldArray() and returns a character
// string usefull for indexes creation or "" if no choice
// was made.
//

    local aMyField            := {}
    local cReturnString       := ""

    begin sequence

        aMyField := fieldArray()

        do case
        case len( aMyField ) == 0
            cReturnString := ""
        case aMyField[DBS_TYPE] == "C"
            cReturnString := "+upper(" + aMyField[DBS_NAME] + ")"
        case aMyField[DBS_TYPE] == "N"
            cReturnString :=;
                "+str(" +;
                aMyField[DBS_NAME] +;
                "," +;
                alltrim(str(aMyField[DBS_LEN])) +;
                "," +;
                alltrim(str(aMyField[DBS_DEC])) +;
                ")"
        case aMyField[DBS_TYPE] == "D"
            cReturnString := "+dtos(" + aMyField[DBS_NAME] + ")"
        case aMyField[DBS_TYPE] == "L"
            cReturnString :=;
                "+transform(" + aMyField[DBS_NAME] + ",'L')"
        case aMyField[DBS_TYPE] == "M"
            alert( FIELD_ERROR_MEMO_FILEDS_NOT_ALLOWED )
        end

     end sequence

     return cReturnString

//----------------------------------------------------------------
static function fieldRelation()
//
// this function calls fieldArray() and returns a character
// string usefull for relation creation or "" if no choice
// was made.
//

    local aMyField            := {}
    local cAlias              := alias()
    local cReturnString       := ""

    begin sequence

        aMyField := fieldArray()

        do case
        case len( aMyField ) == 0
            cReturnString := ""
        case aMyField[DBS_TYPE] == "C"
            cReturnString :=;
                "+upper(" +;
                cAlias +;
                "->" +;
                aMyField[DBS_NAME] +;
                ")"
        case aMyField[DBS_TYPE] == "N"
            cReturnString :=;
                "+str(" +;
                cAlias + "->" + aMyField[DBS_NAME] +;
                "," +;
                alltrim(str(aMyField[DBS_LEN])) +;
                "," +;
                alltrim(str(aMyField[DBS_DEC])) +;
                ")"
        case aMyField[DBS_TYPE] == "D"
            cReturnString :=;
                "+dtos(" +;
                cAlias +;
                "->" +;
                aMyField[DBS_NAME] +;
                ")"
        case aMyField[DBS_TYPE] == "L"
            cReturnString :=;
                "+transform(" +;
                cAlias +;
                "->" +;
                aMyField[DBS_NAME] +;
                ",'L')"
        case aMyField[DBS_TYPE] == "M"
            alert( FIELD_ERROR_MEMO_FILEDS_NOT_ALLOWED )
        end

     end sequence

     return cReturnString

//----------------------------------------------------------------
static function fieldPicture()
//
// This function calls fieldArray() and asks for a picture.
// It returns a character string usefull for text substitution
// or "" if no choice was made.
//

    local aMyField            := {}
    local cReturnString       := ""
    local lNormal             := .F.
    local nDim                := 20
    local cAlign              := "L"
    local nNumLen             := 10
    local nDecLen             := 0
    local nMemoLen            := 0

    begin sequence

        aMyField := fieldArray()

        do case
        case len( aMyField ) == 0
            cReturnString := ""
        case aMyField[DBS_TYPE] == "C"
            // Alignment prompt
            fieldAlCharacter( @lNormal, @nDim, @cAlign,;
                aMyField[DBS_NAME] )
            do case
            case lNormal
                cReturnString := aMyField[DBS_NAME]
            case cAlign == "L"
                cReturnString :=;
                    [padr(alltrim(] +;
                    aMyField[DBS_NAME] +;
                    [),] +;
                    alltrim(str(nDim)) +;
                    [)]
            case cAlign == "C"
                cReturnString :=;
                    [padc(alltrim(] +;
                    aMyField[DBS_NAME] +;
                    [),] +;
                    alltrim(str(nDim)) +;
                    [)]
            case cAlign == "R"
                cReturnString :=;
                    [padl(alltrim(] +;
                    aMyField[DBS_NAME] +;
                    [),] +;
                    alltrim(str(nDim)) +;
                    [)]
            otherwise
                cReturnString := aMyField[DBS_NAME]
            end
        case aMyField[DBS_TYPE] == "N"
            // Alignment prompt
            nNumLen := aMyField[DBS_LEN]
            nDecLen := aMyField[DBS_DEC]
            fieldAlNumber( @lNormal, @nNumLen, @nDecLen )
            do case
            case lNormal
                cReturnString :=;
                    [str(] +;
                    aMyField[DBS_NAME] +;
                    [)]
            case nNumLen > nDecLen
                cReturnString :=;
                    [str(] +;
                    aMyField[DBS_NAME] +;
                    [,] +;
                    alltrim(str(nNumLen)) +;
                    [,] +;
                    alltrim(str(nDecLen)) +;
                    [)]
            otherwise
                cReturnString :=;
                    [str(] +;
                    aMyField[DBS_NAME] +;
                    [)]
            end
        case aMyField[DBS_TYPE] == "D"
            cReturnString :=;
                [dtoc(] +;
                aMyField[DBS_NAME] +;
                [)]
        case aMyField[DBS_TYPE] == "L"
            cReturnString :=;
                [iif(] +;
                aMyField[DBS_NAME] +;
                [,"<] +;
                FIELD_TRUE +;
                [>","<] +;
                FIELD_FALSE +;
                [>" )]
        case aMyField[DBS_TYPE] == "M"
            nMemoLen :=;
                Accept( nMemoLen, FIELD_PROMPT_MEMO_LENGTH )
            if valtype(nMemoLen) == "N"
                cReturnString :=;
                    [left(] +;
                    aMyField[DBS_NAME] +;
                    [,] +;
                    alltrim(str(nMemoLen)) +;
                    [)]
            end
        end

   end sequence

   return cReturnString

//----------------------------------------------------------------
static function fieldAlCharacter( lNormal, nDim, cAlign )

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, {|| Text( FIELD_HELP_ALIGN_CHARACTER ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 7
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( FIELD_DIALOG_BOX_TOP_ALIGN_CHARACTER,;
            nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_NORMAL_F1_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-1, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft say FIELD_PROMPT_ALIGN_NORMAL
            @row()+1,nLeft get lNormal picture "L";
                when trueSetkey( K_F2, NIL );
                valid ( .t. )
            @row()+1,nLeft;
                say FIELD_PROMPT_ALIGN_CHARACTER_DIMENSION
            @row()+1,nLeft;
                get nDim picture "999";
                when trueSetkey( K_F2, NIL );
                    .and. !lNormal;
                valid ( .t. )
            @row()+1,nLeft;
                say FIELD_PROMPT_ALIGN_CHARACTER_ALIGNMENT
            @row()+1,nLeft get cAlign picture "!";
                when trueSetkey( K_F2, NIL );
                    .and. !lNormal;
                valid cAlign == "L";
                    .or. cAlign == "C";
                    .or. cAlign == "R"

            read

            do case
            case lastkey() = K_ESC  // exit
                lNormal := .T.
                exit
            case lastkey() = K_PGDN // ok
                exit
            otherwise
                // loop
            end
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function fieldAlNumber( lNormal, nNumLen, nDecLen )

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, {|| Text( FIELD_HELP_ALIGN_NUMBER ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 8
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( FIELD_DIALOG_BOX_TOP_ALIGN_NUMBER, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_NORMAL_F1_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-1, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft say FIELD_PROMPT_ALIGN_NORMAL
            @row()+1,nLeft get lNormal picture "L";
                when trueSetkey( K_F2, NIL );
                valid ( .t. )
            @row()+1,nLeft say FIELD_PROMPT_ALIGN_NUMBER_LENGTH
            @row()+1,nLeft;
                say FIELD_PROMPT_ALIGN_NUMBER_LENGTH_NOTE
            @row()+1,nLeft;
                get nNumLen picture "999";
                when trueSetkey( K_F2, NIL );
                    .and. !lNormal;
                valid ( .t. )
            @row()+1,nLeft;
                say FIELD_PROMPT_ALIGN_NUMBER_DECIMAL
            @row()+1,nLeft;
                get nDecLen picture "999";
                when trueSetkey( K_F2, NIL );
                    .and. !lNormal;
                valid ( .t. )

            read

            do case
            case lastkey() = K_ESC  // exit
                lNormal := .T.
                exit
            case lastkey() = K_PGDN // ok
                exit
            otherwise
                // loop
            end
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function fieldArray()
//
// fieldArray() --> aFieldData
//              --> {}
//
// This function refers to the active alias and may be used as
// usually so:
//      (cAlias)->(fieldArray())
//
// This function returns an empty array when no selections are
// made; otherewise, an array containing the field data is
// returned.
//

    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NONE )
    local bOld_F1             :=;
        setkey( K_F1, {|| Text( FIELD_HELP_FIELD_CHOICE )} )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local aField              := {}
    local aFieldEasy          := {}
    local nI                  := 0

    begin sequence

        if alias() == ""
             alert( _ERROR_NO_ALIAS )
             break
        end

        aField := dbstruct()

        for nI := 1 to len( aField )
            aadd( aFieldEasy,;
                left( aField[nI, DBS_NAME] +;
                space(20), 11) +;
                aField[nI, DBS_TYPE] + "    " +;
                str( aField[nI, DBS_LEN], 4, 0) + "   " +;
                str( aField[nI, DBS_DEC], 4, 0)  )
        next

        // Create a kind of window.
        nTop    := 0
        nLeft   := maxcol()-30
        nBottom := maxrow()
        nRight  := maxcol()
        nWidth  := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        dispbox( nTop, nLeft, nBottom, nLeft, B_DOUBLE )
        dispbox( nTop, nRight, nBottom, nRight, B_DOUBLE )

        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft+1, nTop, nRight-1 )
        scroll( nBottom-1, nLeft+1, nBottom, nRight-1 )
        @nTop,nLeft+1;
            say padr( FIELD_WINDOW_TOP_FIELD_CHOICE, nWidth-2 )
            // Must be on the left
        @nBottom-2,nLeft+1;
            say padc( _KEY_ESC_CANCEL_F1, nWidth-2 )
        @nBottom-1,nLeft+1 say padc( _KEY_UP_DOWN, nWidth-2 )
        @nBottom,nLeft+1 say padc( _KEY_ENTER, nWidth-2 )

        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft+1, nBottom-3, nRight-1 )
        nI := achoice ( nTop+1, nLeft+1, nBottom-2, nRight-1,;
            aFieldEasy )

    end sequence

    // restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setpos( nOldRow, nOldCol )

    if nI <> 0
        return { aField[nI, DBS_NAME],;
                 aField[nI, DBS_TYPE],;
                 aField[nI, DBS_LEN],;
                 aField[nI, DBS_DEC] }
    end

    // otherwise
    return {}

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// FRM - FORM REPORT CREATION AND EDITING
//----------------------------------------------------------------
static function frmPrint()
//&
//
// frmPrint() --> NIL
//
// This function asks for the label file name, the
// FOR and WHILE condition.
//


    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( FRM_HELP_REPORT_FORM ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoPrint            := .T.
    local cReportFile         :=;
        padr( "*." + _EXTENTION_FORM, SPACE_LEN )
    local cWhileCondition     := padr( ".T.", SPACE_LEN )
    local cForCondition       := padr( ".T.", SPACE_LEN )

    local bWhileCondition
    local bForCondition

    begin sequence

        if ( alias() == "" ) // no alias
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 8
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( FRM_DIALOG_BOX_TOP_REPORT, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say FRM_PROMPT_OPEN_FILE_REPORT
            @row()+1,nLeft;
                get cReportFile;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, {|| cReportFile :=;
                        padr( dir( cReportFile,,,,.T. ),;
                        SPACE_LEN ) } );
                    valid ( isFile( cReportFile :=;
                        padr(strAddExtention( cReportFile,;
                        _EXTENTION_FORM ), SPACE_LEN) ) )
            @row()+1,nLeft;
                say FRM_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft;
                get cWhileCondition;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cWhileCondition :=;
                        padr( fieldNormal(),;
                        SPACE_LEN ) } );
                    valid ( ( cWhileCondition :=;
                        iif( cWhileCondition <> SPACE_STR,;
                        cWhileCondition,;
                        padr( ".T.", SPACE_LEN ) ) ) <> NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft;
                get cForCondition;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cForCondition :=;
                        padr( fieldNormal(),;
                        SPACE_LEN ) } );
                    valid ( ( cForCondition :=;
                        iif( cForCondition <> SPACE_STR,;
                        cForCondition, padr( ".T.",;
                        SPACE_LEN ) ) ) <> NIL )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoPrint := .F.
                exit
            case lastkey() = K_PGDN // confirm
                // Check for correct data
                if isFile( strAddExtention( cReportFile,;
                    _EXTENTION_FORM ) );
                    .and. cWhileCondition <> SPACE_STR;
                    .and. cForCondition <> SPACE_STR
                    //
                    lGoPrint := .T.
                    // Transform character conditions
                    bWhileCondition := { || &(cWhileCondition) }
                    bForCondition :=;
                        { || &(cForCondition);
                        .and. waitFileEval() }

                    exit

                else
                    // loop
                end
            otherwise
                // loop
            end

        end

        // close window
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoPrint
            bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                // Check if the print goes on console
                if isConsoleOn()
                    setcolor( COLOR_DEFAULT2 )
                    scroll()
                end
                // Print
                //__ReportForm( alltrim(cReportFile), .f., ,;
                //    .f., bForCondition, bWhileCondition,;
                //    , , .f.,;
                //    .f., , .t. , .f. )
                rf( alltrim(cReportFile),;
                    bForCondition, bWhileCondition )
                // Close the possible wait bar.
                waitFileEval( .T. )
                // Wait if console is ON.
                if isConsoleOn()
                    // Wait for a key press.
                    inkey(0)
                    scroll()
                end
                // The record pointer is maybe at bottom.
                // No action is taken to move the record pointer.
                // dbgotop()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Report print.] +;
                        NL(1) +;
                        [// This is not a CA-Clipper ] +;
                        [standard function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [rf( "] +;
                        alltrim(cReportFile) +;
                        [", {|| ] +;
                        alltrim(cForCondition) +;
                        [ }, {|| ] +;
                        alltrim(cWhileCondition) +;
                        [} )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                dbgotop()
            end sequence
            errorblock(bOldErrorHandler)
            waitFileEval( .T. )
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function frmModify()
//
// frmModify() --> NIL
//
// It executes the frm() function asking for the file name to
// modify.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( FRM_HELP_REPORT_EDIT ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .F.
    local cReportFile         :=;
        padr( "*." + _EXTENTION_FORM, SPACE_LEN )

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 4
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( FRM_DIALOG_BOX_TOP_REPORT, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say FRM_PROMPT_OPEN_FILE_REPORT
            @row()+1,nLeft;
                get cReportFile;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cReportFile :=;
                    padr( Dir( cReportFile,,,,.T. ), SPACE_LEN ) } );
                valid ( isFile( cReportFile :=;
                    padr(strAddExtention( cReportFile,;
                    _EXTENTION_FORM ), SPACE_LEN) ) )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // ok
                if isFile( strAddExtention( cReportFile,;
                    _EXTENTION_FORM ) )
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end

        // Close window
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
            frm( cReportFile )
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function frm( cFileName )
//
// frm( <cFileName> ) --> NIL
//
// <cFileName>  the report file name to modify.
//              If not present, it will be created.
//
// Offsets:
//    CA-Clipper array and character variables pointers starts
//    from position 1. This menans that the first element is
//    number one and not number 0.
//    Addresses writtend inside the Report Form file starts
//    from position 0 (zero).
//    All "DOS offsets" starts here from 0.
//
// Description from the original "RL" program.
//    Report file length is 7C6h (1990d) bytes.
//    Expression length array starts at 04h (4d) and can
//       contain upto 55 short (2 byte) numbers.
//    Expression offset index array starts at 72h (114d) and
//       can contain upto 55 short (2 byte) numbers.
//    Expression area starts at offset E0h (224d).
//    Expression area length is 5A0h (1440d).
//    Expressions in expression area are null terminated.
//    Field expression area starts at offset 680h (1664d).
//    Field expressions (column definition) are null terminated.
//    Field expression area can contain upto 25 12-byte blocks.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( FRM_HELP_REPORT_EDIT ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0
    local lOldDeleted         := set( _SET_DELETED, .T. )

    local axFormVal[16]
    local nLastSelect         := select() // save last select
    local aStruct := {}

    local cOldName
    local lSave
    local lGoOn

    begin sequence

        // Header array initialization.
        axFormVal[FRM_PAGE_WIDTH]       := 80
        axFormVal[FRM_LINES_PAGE]       := 58
        axFormVal[FRM_LEFT_MARG]        := 8
        axFormVal[FRM_RIGHT_MARG]       := 0
        axFormVal[FRM_COL_COUNT]        := 0
        axFormVal[FRM_DBL_SPACED]       := "N"
        axFormVal[FRM_SUMMARY]          := "N"
        axFormVal[FRM_PE]               := "N"
        axFormVal[FRM_PLAINPAGE]        := "N"
        axFormVal[FRM_PEAP]             := "Y"
        axFormVal[FRM_PEBP]             := "N"
        axFormVal[FRM_PAGE_HDR]         := space(240)
        axFormVal[FRM_GRP_EXPR]         := space(200)
        axFormVal[FRM_SUB_EXPR]         := space(200)
        axFormVal[FRM_GRP_HDR]          := space(50)
        axFormVal[FRM_SUB_HDR]          := space(50)

        // Structure body file creation.
        aadd( aStruct, { "ORDER", "N", 6, 0 } )
        aadd( aStruct, { "WIDTH", "N", 3, 0 } )
        aadd( aStruct, { "TOTALS", "C", 1, 0 } )
        aadd( aStruct, { "DECIMALS", "N", 2, 0 } )
        aadd( aStruct, { "CONTENTS", "C", 254, 0 } )    // 254
        aadd( aStruct, { "HEADER", "C", 254, 0 } )      // 260

        dbcreate( strTempPath()+"\TEMPFORM", aStruct )
        dbusearea( .T., NIL, strTempPath()+"\TEMPFORM",;
            "FormStru" )
        index on Field->Order to &(strTempPath()+"\TEMPFORM")

        if valtype( cFileName ) <> "C"
            cFileName :=;
                strAddExtention( _UNTITLED, _EXTENTION_FORM )
                //
            cOldName := NIL
            // It will be created
        else
            // The file name must be alltrimed.
            cFileName := alltrim( cFileName )
            if file( cFileName )
                cOldName := alltrim(cFileName)
                // It is loaded
                frmLoad( cFileName, @axFormVal )
            else
                cOldName := NIL
                // It will be created
            end
        end

        lSave := frmEdit( cFileName, @axFormVal, nLastSelect )

        if lSave

            cFileName := padr( cFileName, SPACE_LEN )

            // Create a kind of window.
            nBottom     := maxrow()
            nTop        := nBottom - 4
            nLeft       := 0
            nRight      := maxcol()
            nWidth      := nRight - nLeft +1
            cOldScreen  :=;
                savescreen( nTop, nLeft, nBottom, nRight )
            setcolor( COLOR_DEFAULT1 )
            scroll( nTop, nLeft, nTop, nRight )
            scroll( nBottom-1, nLeft, nBottom, nRight )
            setpos( nTop, nLeft )
            dispout( padc( FRM_DIALOG_BOX_TOP_REPORT, nWidth ) )
            setpos( nBottom-1, nLeft )
            dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
            setpos( nBottom, nLeft )
            dispout( padc( _KEY_F2_PGDN, nWidth ) )

            while .t.
                setcolor( COLOR_DEFAULT2 )
                scroll( nTop+1, nLeft, nBottom-2, nRight )
                setpos( nTop, nLeft )
                @row()+1,nLeft;
                    say FRM_PROMPT_SAVE_REPORT
                @row()+1,nLeft;
                    get cFileName;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, {|| cFileName :=;
                        padr( Dir( cFileName,,,,.T. ), SPACE_LEN ) } );
                    valid ( ( cFileName :=;
                        padr(strAddExtention(cFileName,;
                        _EXTENTION_FORM), SPACE_LEN) ) <> NIL )
                read

                do case
                case lastkey() = K_ESC  // exit
                    lGoOn := .F.
                    exit
                case lastkey() = K_PGDN // ok
                    do case
                    case alltrim(cFileName) <> cOldName;
                        .and. file( strAddExtention( cFileName,;
                        _EXTENTION_FORM ) );
                        .and. ( alert( alltrim(cFileName) + ";" +;
                        _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                        { _MENU_NO, _MENU_YES } ) == 1 )
                        //
                        // loop
                    case strCutExtention( cFileName ) == ""
                        // loop

                    otherwise
                        lGoOn := .T.
                        exit
                    end

                otherwise
                    // loop
                end
            end

            if lGoOn
                // Ok save.
                if FrmSave( alltrim(cFileName), axFormVal )
                    // ok
                else
                    alert( FRM_ERROR_FILE_NOT_SAVED )
                end
            else
                // nil
            end

        else
            // nil
        end

        // Close structure file for the Report Form.
        close FormStru

        // Select previous file.
        dbselectarea( nLastSelect )

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    set( _SET_DELETED, lOldDeleted )

    return NIL

//----------------------------------------------------------------
static function frmLoad( cFileName, axFormVal )

    local cBuffer             := space( FRM_SIZE_FILE_BUFF )
    local acFormBuffer[5]
    local nPlusByte           := 0
    local nPointer            := 0
    local nHandle             := fopen( cFileName )
    local nByteRead           := 0
    local nFieldOffset        := 0
    local nI                  := 0
    local lFileError          := .F.

    if !ferror() == 0
        alert( cFileName + ";" +;
            FRM_ERROR_CANNOT_OPEN + str(ferror()) )
        return .F.
    end

    // Reed the file
    nByteRead := fread( nHandle, @cBuffer, FRM_SIZE_FILE_BUFF )

    // Check the dimention.
    if nByteRead < FRM_SIZE_FILE_BUFF
        alert( cFileName + ";" +;
            FRM_ERROR_FILE_TOO_LITTLE )
        return .F.
    elseif !( bin2i(substr( cBuffer, 1, 2 )) == 2;
        .and. bin2i(substr( cBuffer, FRM_SIZE_FILE_BUFF - 1, 2 ));
        == 2 )
        // If it don't starts and ends with the number 2
        // it is not a report form.
        //
        alert( cFileName + ";" +;
            FRM_ERROR_FILE_NOT_VALID )
        return .F.
    end

    Waitfor( FRM_WAIT_LOADING )

    // Data extractions.
    acFormBuffer[ FRM_LENGTHS_BUFF ] := ;
        substr(cBuffer, FRM_LENGTHS_OFFSET, FRM_SIZE_LENGTHS_BUFF)
    acFormBuffer[ FRM_OFFSETS_BUFF ] := ;
        substr(cBuffer, FRM_OFFSETS_OFFSET, FRM_SIZE_OFFSETS_BUFF)
    acFormBuffer[ FRM_EXPR_BUFF ] := ;
        substr( cBuffer, FRM_EXPR_OFFSET, FRM_SIZE_EXPR_BUFF )
    acFormBuffer[ FRM_FIELDS_BUFF ] := ;
        substr( cBuffer, FRM_FIELDS_OFFSET, FRM_SIZE_FIELDS_BUFF )
    acFormBuffer[ FRM_PARAMS_BUFF ] := ;
        substr( cBuffer, FRM_PARAMS_OFFSET, FRM_SIZE_PARAMS_BUFF )

    axFormVal[FRM_PAGE_WIDTH] := ;
        bin2i( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_PAGE_WIDTH_OFFSET, 2 ) )
    axFormVal[FRM_LINES_PAGE] := ;
        bin2i( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_LNS_PER_PAGE_OFFSET, 2 ) )
    axFormVal[FRM_LEFT_MARG] := ;
        bin2i( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_LEFT_MRGN_OFFSET, 2 ) )
    axFormVal[FRM_RIGHT_MARG] := ;
        bin2i( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_RIGHT_MRGN_OFFSET, 2 ) )
    axFormVal[FRM_COL_COUNT] := ;
        bin2i( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_COL_COUNT_OFFSET, 2 ) )

    axFormVal[FRM_DBL_SPACED] := ;
        substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_DBL_SPACE_OFFSET, 1 )
    axFormVal[FRM_SUMMARY] := ;
        substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_SUMMARY_RPT_OFFSET, 1 )
    axFormVal[FRM_PE] := ;
        substr( acFormBuffer[ FRM_PARAMS_BUFF ], FRM_PE_OFFSET, 1 )

    nPlusByte := ;
        asc( substr( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_PLNPG_PEAP_PEBP_OFFSET, 1) )
    if int( nPlusByte/4 ) == 1
        axFormVal[FRM_PLAINPAGE] := "Y"
        nPlusByte -= 4
    end
    if int( nPlusByte/2 ) == 1
        axFormVal[FRM_PEAP] := "Y"
        nPlusByte -= 2
    end
    if int( nPlusByte/1 ) == 1
        axFormVal[FRM_PEBP] := "N"
        nPlusByte -= 1
    end

    // String expressions extraction.

    // Page Header
    nPointer := ;
        bin2i( substr ( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_PAGE_HDR_OFFSET, 2 ) )
    axFormVal[FRM_PAGE_HDR] := ;
        padr( frmGetExpr( @acFormBuffer, nPointer ), 240 )
    // Grouping Expression
    nPointer := ;
        bin2i( substr ( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_GRP_EXPR_OFFSET, 2 ) )
    axFormVal[FRM_GRP_EXPR] := ;
        padr( frmGetExpr( @acFormBuffer, nPointer ), 200 )
    // Sub-grouping Expression
    nPointer := ;
        bin2i( substr ( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_SUB_EXPR_OFFSET, 2 ) )
    axFormVal[FRM_SUB_EXPR] := ;
        padr( frmGetExpr( @acFormBuffer, nPointer ), 200 )
    // Group Header
    nPointer := ;
        bin2i( substr ( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_GRP_HDR_OFFSET, 2 ) )
    axFormVal[FRM_GRP_HDR] := ;
        padr( frmGetExpr( @acFormBuffer, nPointer ), 50 )
    // Sub-group header
    nPointer := ;
        bin2i( substr ( acFormBuffer[ FRM_PARAMS_BUFF ],;
        FRM_SUB_HDR_OFFSET, 2 ) )
    axFormVal[FRM_SUB_HDR] := ;
        padr( frmGetExpr( @acFormBuffer, nPointer ), 50 )

    // Fields extraction and transfer inside a temporary
    // structure file.

    // Field transfer.
    nFieldOffset := 12
    for nI = 1 to axFormVal[FRM_COL_COUNT]
        nFieldOffset := ;
         frmGetField( @acFormBuffer, nFieldOffset, @lFileError )
    next

    WaitFor()

    return !lFileError

//----------------------------------------------------------------
static function frmGetExpr( acFormBuffer, nPointer )
//
// The expression is empty if:
//    - passed pointer is equal to 65535;
//    - character following character pointed to by
//      pointer is CHR(0) (NULL).
//

    local nExprOffset         := 0
    local nExprLength         := 0
    local nOffsetOffset       := 0
    local cString             := ""

    if nPointer != 65535
        // Convert DOS FILE offset to CLIPPER string offset
        nPointer += 1
        // Calculate offset into OFFSETS_BUFF
        if nPointer > 1
           nOffsetOffset = ( nPointer * 2 ) - 1
        end

        nExprOffset := ;
            bin2i( substr( acFormBuffer[ FRM_OFFSETS_BUFF ],;
            nOffsetOffset, 2) )
        nExprLength := ;
            bin2i( substr( acFormBuffer[ FRM_LENGTHS_BUFF ],;
            nOffsetOffset, 2) )

        // EXPR_OFFSET points to a NULL, so add one (+1)
        // to get the string and subtract one (-1) from
        // EXPR_LENGTH for correct length
        nExprOffset += 1
        nExprLength -= 1

        // Extract string
        cString := substr( acFormBuff[ FRM_EXPR_BUFF ],;
            nExprOffset, nExprLength )

        // dBASE does this so we must do it too
        // Character following character pointed to by pointer
        // is NULL
        if chr(0) == substr( cString, 1, 1) .and.;
              len( substr( cString, 1, 1 ) ) == 1
            cString = ""
        end
    end

    return cString

//----------------------------------------------------------------
static function frmGetField( acFormBuffer, nFieldOffset,;
    lFileError )
//
// The Header or Contents expressions are empty if:
//    - passed pointer is equal to 65535;
//    - character following character pointed to by
//      pointer is CHR(0) (NULL).
//

    local nPointer  := 0
    local nNumber   := 0

    // Append an empty record.
    append blank

    // Field sequence number
    FormStru->Order := nFieldOffset * 50
    // Column width
    FormStru->Width := ;
        bin2i( substr( acFormBuffer[ FRM_FIELDS_BUFF ],;
        nFieldOffset + FRM_FIELD_WIDTH_OFFSET, 2) )
    // Total
    FormStru->Totals :=;
        substr( acFormBuffer[ FRM_FIELDS_BUFF ],;
        nFieldOffset + FRM_FIELD_TOTALS_OFFSET, 1)
    // Decimals width
    FormStru->Decimals :=;
       bin2i( substr( acFormBuffer[ FRM_FIELDS_BUFF ],;
       nFieldOffset + FRM_FIELD_DECIMALS_OFFSET, 2 ) )
    // Content expression
    nPointer :=;
        bin2i( substr( acFormBuffer[ FRM_FIELDS_BUFF ],;
        nFieldOffset + FRM_FIELD_CONTENT_EXPR_OFFSET, 2 ) )
    FormStru->Contents := frmGetExpr( @acFormBuffer, nPointer )
    // Header expression
    nPointer :=;
        bin2i( substr( acFormBuffer[ FRM_FIELDS_BUFF ],;
        nFieldOffset + FRM_FIELD_HEADER_EXPR_OFFSET, 2))
    FormStru->Header := frmGetExpr( @acFormBuffer, nPointer )

    return nFieldOffset + 12

//----------------------------------------------------------------
static function frmEdit( cFileName, axFormVal, nLastSelect )

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             := setkey( K_F1, NIL )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local cLastAlias          := alias(nLastSelect)
    local lSave               := .F.

    local acCol
    local acColSayPic
    local acColHead
    local alColCalc
    local abColValid
    local abColMsg

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 21
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( FRM_DIALOG_BOX_TOP_REPORT, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_EXIT_F1_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-1, nRight )

            setkey( K_F1, { || Text( FRM_HELP_REPORT_EDIT_HEAD)} )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PAGE_WIDTH;
                get axFormVal[ FRM_PAGE_WIDTH ];
                    picture "999";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_LINES_PER_PAGE;
                get axFormVal[ FRM_LINES_PAGE ];
                    picture "999";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_LEFT_MARGIN;
                get axFormVal[ FRM_LEFT_MARG ];
                    picture "999";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_RIGHT_MARGIN;
                get axFormVal[ FRM_RIGHT_MARG ];
                    picture "999";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_DOUBLE_SPACED;
                get axFormVal[ FRM_DBL_SPACED ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_DBL_SPACED ] = "Y";
                        .or. axFormVal[FRM_DBL_SPACED ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PAGE_EJECT_BEFORE;
                get axFormVal[ FRM_PEBP ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_PEBP ] = "Y";
                        .or. axFormVal[FRM_PEBP ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PAGE_EJECT_AFTER;
                get axFormVal[ FRM_PEAP ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_PEAP ] = "Y";
                        .or. axFormVal[FRM_PEAP ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PLAIN_PAGE;
                get axFormVal[ FRM_PLAINPAGE ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_PLAINPAGE ] = "Y";
                        .or. axFormVal[FRM_PLAINPAGE ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PAGE_HEADER
            @row()+1,nLeft;
                get axFormVal[ FRM_PAGE_HDR ];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_GROUP_HEADER
            @row()+1,nLeft;
                get axFormVal[ FRM_GRP_HDR ];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_GROUP_EXPRESSION
            @row()+1,nLeft;
                get axFormVal[ FRM_GRP_EXPR ];
                    picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                    { || (cLastAlias)->;
                    ( keyboard( fieldNormal() ) ) } )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_SUMMARY_REPORT_ONLY;
                get axFormVal[ FRM_SUMMARY ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_SUMMARY ] = "Y";
                        .or. axFormVal[FRM_SUMMARY ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_PAGE_EJECT_AFTER_GROUP;
                get axFormVal[ FRM_PE ];
                    picture "!";
                    when trueSetkey( K_F2, NIL );
                    valid axFormVal[FRM_PE ] = "Y";
                        .or. axFormVal[FRM_PE ] = "N"
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_SUB_GROUP_HEADER
            @row()+1,nLeft;
                get axFormVal[ FRM_SUB_HDR ];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say FRM_PROMPT_REPORT_SUB_GROUP_EXPRESSION
            @row()+1,nLeft;
                get axFormVal[ FRM_SUB_EXPR ];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        { || (cLastAlias)->;
                        ( keyboard( fieldNormal() ) ) } )
            read

            do case
            case lastkey() = K_ESC
                lSave := .F.
            exit
            case lastkey() = K_PGDN // confirm choice
                // Close last and open next window.
                restscreen( nTop, nLeft, nBottom, nRight,;
                    cOldScreen )
                nBottom       := maxrow()
                nTop          := nBottom - 22
                nLeft         := 0
                nRight        := maxcol()
                nWidth        := nRight - nLeft +1
                cOldScreen    :=;
                    savescreen( nTop, nLeft, nBottom, nRight )
                setcolor( COLOR_DEFAULT1 )
                scroll( nTop, nLeft, nTop, nRight )
                scroll( nBottom-1, nLeft, nBottom, nRight )
                setpos( nTop, nLeft )
                dispout( padc( FRM_DIALOG_BOX_TOP_REPORT, nWidth ) )
                setpos( nBottom, nLeft )
                dispout( padc( _KEY_ESC_EXIT_F1_F2_CTRLY, nWidth ) )
                setcolor( COLOR_DEFAULT0 )
                scroll( nTop+1, nLeft, nBottom-1, nRight )

                setkey( K_F2, { || (cLastAlias)->;
                    ( keyboard( fieldNormal() ) ) } )

                dbgotop() // to the first report column
                setkey( K_F1,;
                    { || Text( FRM_HELP_REPORT_EDIT_COLUMNS ) } )

                acCol := { "if( deleted(), '*', ' ' )",;
                           "Order",;
                           "Header",;
                           "Contents",;
                           "Width",;
                           "Decimals",;
                           "Totals" }
                acColSayPic := { "X",;
                                 "999999",;
                                 "@s25",;
                                 "@s25",;
                                 "999",;
                                 "99",;
                                 "!" }
                acColHead := { "*",;
                                FRM_HEAD_REPORT_ORDER,;
                                FRM_HEAD_REPORT_HEADER,;
                                FRM_HEAD_REPORT_CONTENT,;
                                FRM_HEAD_REPORT_WIDTH,;
                                FRM_HEAD_REPORT_DECIMALS,;
                                FRM_HEAD_REPORT_TOTAL}
                alColCalc := { .T.,;
                               .F.,;
                               .F.,;
                               .F.,;
                               .F.,;
                               .F.,;
                               .F. }
                abColValid := { {||.T.},;
                               {||.T.},;
                               {||.T.},;
                               {||.T.},;
                               {||.T.},;
                               {||.T.},;
                               {|| Field->Totals=="Y";
                                    .or. Field->Totals=="N";
                                    .or. Field->Totals==" " } }
                abColMsg := { {||""},;
                              {||""},;
                              {||""},;
                              {||""},;
                              {||""},;
                              {||""},;
                              {||"Y/N"} }

                // TB( <nTop>, <nLeft>, <nBottom>, <nRight>,
                //      <acCol>, <acColSayPic>,
                //      [<acColHead>], [<acColFoot>],
                //      [<alColCalc>], [<abColValid>], [<abColMsg>],
                //      [<nFreeze>],
                //      [<lModify>], [<lAppend>], [<lDelete>],
                //      [<lAutosort>] )  --> NIL
                TB( nTop+1, nLeft, nBottom-1, nRight,;
                     acCol, acColSayPic,;
                     acColHead, NIL,;
                     alColCalc, abColValid, abColMsg,;
                     1,;
                     .t., .t., .t., .t.)

                // Close window
                restscreen( nTop, nLeft, nBottom, nRight,;
                    cOldScreen )

                lSave := .T.
                exit

            otherwise
                // nix
            end
            // loop
        end


    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    // Terminate.
    return lSave

//---------------------------------------------------------------
static function frmSave( cFileName, axFormVal )

    local nHandle             := 0
    local nByteWritten        := 0
    local cBuffer             := ""

    local nLastExpr           := 0  // initial value
    local nExprCount          := -1 // initial value
    local nLengthOffset       :=;
        FRM_LENGTHS_OFFSET - 1 // DOS offsets
    local nOffsetsOffset      := FRM_OFFSETS_OFFSET - 1
    local nFieldsOffset       := FRM_FIELDS_OFFSET - 1
    local nLengthsOffset      := FRM_LENGTHS_OFFSET - 1

    local anNum[5]

    local i                   := 0
    local j                   := 0

    local lOk                 := .F.

    nHandle := fcreate( cFileName )

    if !ferror() == 0
        alert( cFileName + ";" +;
            FRM_ERROR_CANNOT_CREATE + str(ferror()) )
        return .F.
    end

    // Write the Report Form skeleton.
    cBuffer := chr(2) + chr(0) +;
        replicate( chr(0), ( FRM_SIZE_FILE_BUFF - 4 ) ) +;
        chr(2) + chr(0)
    nByteWritten = fwrite( nHandle, cBuffer, FRM_SIZE_FILE_BUFF )

    if nByteWritten != FRM_SIZE_FILE_BUFF
        alert( FRM_ERROR_SOMETHING_GONE_WRONG )
        return .F.
    end

    // Write Page Heading info.
    if ( anNum[ FRM_PAGE_HDR_NUM ] :=;
         frmWriteExpr( nHandle, axFormVal[ FRM_PAGE_HDR ], .T.,;
         @nLastExpr, @nExprCount,;
         @nLengthsOffset, @nOffsetsOffset ) ) = -1
         //
         return .F.
    end

    // Write Grouping expression info.
    if ( anNum[ FRM_GRP_EXPR_NUM ] :=;
         frmWriteExpr( nHandle, axFormVal[ FRM_GRP_EXPR ], .T.,;
         @nLastExpr, @nExprCount,;
         @nLengthsOffset, @nOffsetsOffset ) ) = -1
         //
         return .F.
    end

    if ( anNum[ FRM_SUB_EXPR_NUM ] :=;
         frmWriteExpr( nHandle, axFormVal[ FRM_SUB_EXPR ], .T.,;
         @nLastExpr, @nExprCount,;
         @nLengthsOffset, @nOffsetsOffset ) ) = -1
         //
         return .F.
    end

    if ( anNum[ FRM_GRP_HDR_NUM ] :=;
         frmWriteExpr( nHandle, axFormVal[ FRM_GRP_HDR ], .T.,;
         @nLastExpr, @nExprCount,;
         @nLengthsOffset, @nOffsetsOffset ) ) = -1
         //
         return .F.
    end

    if ( anNum[ FRM_SUB_HDR_NUM ] :=;
         frmWriteExpr( nHandle, axFormVal[ FRM_SUB_HDR ], .T.,;
         @nLastExpr, @nExprCount,;
         @nLengthsOffset, @nOffsetsOffset ) ) = -1
         //
         return .F.
    end

    // If here it's ok.
    lOk := .T.

    // In this moment, the structure file for Report Form
    // is opened.
    dbgotop()
    j := lastrec()
    axFormVal[ FRM_COL_COUNT ] := j
    for i = 1 to j
        if i == j;
            .and. len( trim( Field->Contents ) ) == 0
            //
            lOk := .T.
            axFormVal[ FRM_COL_COUNT ]-- // decrementa
        else
            if !frmWriteField( nHandle,;
                @nFieldsOffset, @nLengthsOffsets,;
                @nOffsetsOffset, @nLastExpr, @nExprCount )
                //
                lOk := .F.
                // If a column insert don't work, exit.
            end
        end
        // If still here...
        dbskip()
    next

    // Column info written ok?
    if lOk
        // Write last 24 bytes of report and update 
        // next_free_offset
        lOk := frmWriteParams( nHandle, anNum,;
            axFormVal, nLastExpr )
    end

    // close
    if !fclose( nHandle )
        lOk := .F.
    end

    return lOk

//---------------------------------------------------------------
static function frmWriteExpr( nHandle, cString, lBlank, nLastExpr,;
    nExprCount, nLengthsOffset, nOffsetsOffset )
//
// cString    string to be written inside the expression area.
//
// lBlank     test for dBASE like blank expression handling
//            and return a 65535 if expression to write is blank.
//
// -->
//    numeric, expression count (0 to 55 inclusive) or
//    65535 (if blank = .T. and EMPTY(string) = .T.) or
//    -1 (if WRITE/SEEK error).
//

    local lStatus             := .F.
    local cWriteItem          := ""
    local nWriteLen           := 0
    local nWriteCount         := 0
    local nReturnCount        := 0;
        // expression count/65535 if empty/-1 error.

    // For dBASE compatability.
    if lBlank .and. len(cString) = 0
        // espressione vuota
        return 65535
    end

    cWriteItem := cString + chr(0)
    nWriteLen  := len(cWriteItem)

    // Move to the next free area (DOS offsets).
    fseek( nHandle, FRM_EXPR_OFFSET - 1 + nLastExpr )
    if ferror() <> 0
        return -1
    end

    // Write the expression.
    nWriteCount := fwrite( nHandle, cWriteItem, nWriteLen )
    if nWriteCount == 0 .or. ferror() <> 0
        return -1
    end

    fseek( nHandle, nOffsetsOffset)
    if ferror() <> 0
        return -1
    end

    // Add an offset to the offsets array.
    nWriteCount := fwrite( nHandle, i2Bin( nLastExpr ), 2 )
    if nWriteCount == 0 .or. ferror() <> 0
        return -1
    end

    fseek( nHandle, nLengthsOffset )
    if ferror() <> 0
        return -1
    end

    // Add the expression length to the lengths array.
    nWriteCount := fwrite( nHandle, i2bin( nWriteLen ), 2)
    if nWriteCount == 0 .or. ferror() <> 0
        return -1
    end

    // Move offsets to next position.
    nLastExpr += nWriteLen
    nLengthsOffset += 2
    nOffsetsOffset += 2

    nExprCount += 1         // global increment.

    return nExprCount

//---------------------------------------------------------------
static function frmWriteField( nHandle, nFieldsOffset,;
    nLengthsOffset, nOffsetsOffset, nLastExpr, nExprCount )
//
//
// -->
//    logical, success or fail of write operation.
//

    local cWriteItem          := ""
    local nWriteLen           := 0
    local nWriteCount         := 0
    local nCntsOffset         := 65535
    local nHdrOffset          := 65535

    // Write Contents.
    nCntsOffset := frmWriteExpr( nHandle,;
        trim( Field->Contents ), .F.,;
        @nLastExpr, @nExprCount,;
        @nLengthsOffset, @nOffsetsOffset )
    // WRITE ok?
    if nCntsOffset != -1
        // Write Header
        nHdrOffset :=;
            frmWriteExpr( nHandle,;
            trim( Field->Header ),;
            .T.,;
            @nLastExpr,;
            @nExprCount,;
            @nLengthsOffset,;
            @nOffsetsOffset )
        // WRITE ok?
        if nHdrOffset != -1
            // Seek to the next free FIELDS area
            nFieldsOffset := nFieldsOffset + 12
            fseek( nHandle, nFieldsOffset )

            // SEEK ok?
            if ferror() == 0
                cWriteItem := i2bin( Field->Width ) +;
                          replicate( chr(0), 3) +;
                          Field->Totals +;
                          i2bin( Field->Decimals ) +;
                          i2bin( nCntsOffset ) +;
                          i2bin( nHdrOffset )
                nWriteLen := len( cWriteItem )

                //  Write the FIELDS info
                nWriteCount :=;
                    fwrite( nHandle, cWriteItem, nWriteLen )

                if nWriteCount = 0 .or.;
                    ferror() <> 0
                    return .F.
                else
                    return .T.
                end
            end
        end
    end

    return .T.

//---------------------------------------------------------------
static function frmWriteParams( nHandle, anNum, axFormVal,;
    nLastExpr )
//
//
//  Writes the last 24 bytes of the report file plus
//   updates the first un-used offset. (last_offset)
//
// -->
//    logical, success or fail of write operation.
//

    local status              := .F.
    local cWriteItem          := ""
    local nWriteLen           := 0
    local nWriteCount         := 0
    local nPlusByte           := 0

    // Calculate plus byte.
    if axFormVal[ FRM_PLAINPAGE ] == "Y"
        nPlusByte += 4
    end
    if axFormVal[ FRM_PEAP ] == "Y"
        nPlusByte += 2
    end
    if axFormVal[ FRM_PEBP ] == "N"
        nPlusByte += 1
    end

    // Prepare miscellaneous data area string for write ops.
    cWriteItem =;
        i2bin( anNum[ FRM_PAGE_HDR_NUM ] ) +;
        i2bin( anNum[ FRM_GRP_EXPR_NUM ] ) +;
        i2bin( anNum[ FRM_SUB_EXPR_NUM ] ) +;
        i2bin( anNum[ FRM_GRP_HDR_NUM ] ) +;
        i2bin( anNum[ FRM_SUB_HDR_NUM ] ) +;
        i2bin( axFormVal[ FRM_PAGE_WIDTH ] ) +;
        i2bin( axFormVal[ FRM_LINES_PAGE ] ) +;
        i2bin( axFormVal[ FRM_LEFT_MARG ] ) +;
        i2bin( axFormVal[ FRM_RIGHT_MARG ] ) +;
        i2bin( axFormVal[ FRM_COL_COUNT ] ) +;
        axFormVal[ FRM_DBL_SPACED ] +;
        axFormVal[ FRM_SUMMARY ] +;
        axFormVal[ FRM_PE ] +;
        chr( nPlusByte )
    nWriteLen := len( cWriteItem )

    // Seek to first parameters area (DOS offsets).
    fseek( nHandle, FRM_PARAMS_OFFSET -1  )

    // SEEK ok?
    if ferror() == 0
        nWriteCount := fwrite( nHandle, cWriteItem, nWriteLen )

        if nWriteCount = 0;
            .or. ferror() <> 0
            return .F.
        end
    else
        return .F.
    end

    fseek( nHandle, 2 )  // next_free_offset

    if ferror() == 0
        // Update the next free expression offset.
        nWriteCount := fwrite( nHandle, i2bin( nLastExpr ), 2)
        // write error.
        if nWriteCount = 0 .or.;
            ferror() <> 0
            return .F.
        end
    end

    // If here, ok.
    return .T.

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// IDB - INTERACTIVE DB FUNCTIONS
//----------------------------------------------------------------
static function idbModStructure()
//
// idbModStructure() --> NIL
//
// This function modifies a .dbf file structure asking for the name
// of the file to modify.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, {|| Text( IDB_HELP_OPEN_FILE_TO_MODIFY ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local cFileName := padr( "*." + _EXTENTION_DBF, SPACE_LEN )
    local lGoOn := .F.

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 4
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_DBF_FILE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft say IDB_PROMPT_OPEN_FILE_TO_MODIFY
            @row()+1,nLeft;
                get cFileName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                     {|| cFileName :=;
                     padr( Dir( cFileName,,,,.T. ), SPACE_LEN ) } );
                valid file( cFileName :=;
                      padr( strAddExtention( cFileName,;
                      _EXTENTION_DBF ), SPACE_LEN) )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                if file( strAddExtention( cFileName,;
                    _EXTENTION_DBF ) )
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end

        // Close window
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
           idbStructure( cFileName )
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbStructure(cName)
//&
//
// idbStructure(<cName>) --> NIL
//
// <cName>  database file name.
//
// It modifies or creates the file (.dbf) <cName>
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldRddDefault      := rddsetdefault()
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             := setkey( K_F1, NIL )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0
    local lOldDeleted         := set( _SET_DELETED, .T. )

    local aStruct := {}
    local acCol
    local acColSayPic
    local acColHead
    local alColCalc
    local abColValid
    local abColMsg
    local acColSep
    local nOrder := 0
    local lCreate := .F.
    local lGoOn := .F.
    local cNewName
    local cNewRdd
    local nI
    local cTempPath := strTempPath()

    local bOk       := {|| messageLine(), .T.}

    begin sequence

        if cName == NIL
            // the file must be created
            lCreate := .T.
            cName := SPACE_STR
        else
            // Eventual extention addition
            cName := strAddExtention( cName, _EXTENTION_DBF )
            if !file( cName )
                alert( cName + ";" + IDB_ERROR_FILE_NOT_EXIST )
                break
            end
        end

        if lCreate
            setkey( K_F1, { || Text(IDB_HELP_DBF_CREATE) } )
        else
            setkey( K_F1,;
                { || Text(IDB_HELP_DBF_MODIFY_STRUCTURE) } )
            if alert( cName +";" +;
                      IDB_PROMPT_MODIFY_STRUCTURE, ;
                   { _MENU_EXIT, _MENU_CONTINUE } ) == 1
                break
            end

        end

        // A structure file is created using the default RDD
        aStruct := {}
        aadd( aStruct, { "Order",       "N",  6, 0 } )
        aadd( aStruct, { "Field_Name",  "C", 10, 0 } )
        aadd( aStruct, { "Field_Type",  "C",  1, 0 } )
        aadd( aStruct, { "Field_Len",   "N",  3, 0 } )
        aadd( aStruct, { "Field_Dec",   "N",  4, 0 } )
        dbcreate( cTempPath + "\TMPKSTRU", aStruct, _DEFAULT_RDD )

        // The structure file is opened
        dbusearea( .T., _DEFAULT_RDD, cTempPath + "\TMPKSTRU",;
            "TMPKSTRU", .F., .F. )
        if neterr()
            // If it fails, break
            break
        end

        // Create structure index file
        dbcreateindex( cTempPath+"\TMPKSTRU", "Field->Order",;
            { || Field->Order } )
        // Test if modification or creation is on
        if !lCreate
            // Try to open the existing file
            bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                // If the file has a structure defect,
                // an error occurs and the files TMP_STRU and
                // DBF_MODIFY must be closed.
                dbusearea( .T., cOldRddDefault, cName,;
                    "DBF_MODIFY", .F., .F. )
            recover
                TMPKSTRU->(dbclosearea())
                DBF_MODIFY->(dbclosearea())
                break
            end sequence
            errorblock( bOldErrorHandler )
            if neterr()
                // If it fails, break
                alert( alltrim( cName ) + ";" +;
                    _ERROR_FLOCK_FAILURE )
                TMPKSTRU->(dbclosearea())
                break
            end

            // Copy structure
            rddsetdefault( _DEFAULT_RDD )
            copy structure extended to;
                &(cTempPath+"\TMP_STRU")
            rddsetdefault( cOldRddDefault )

            // Open structure file
            dbusearea( .T., _DEFAULT_RDD, cTempPath + "\TMP_STRU",;
                "TMP_STRU", .F., .F. )
            if neterr()
                break
            end

            // If everything goes ok, transfer temporary structure
            // file to obtain a structure file with field order.
            TMP_STRU->(dbgotop())
            nOrder := 0
            while .T.
                TMPKSTRU->(dbappend())
                nOrder += 600
                TMPKSTRU->Order := nOrder
                TMPKSTRU->Field_Name := TMP_STRU->Field_Name
                TMPKSTRU->Field_Type := TMP_STRU->Field_Type
                TMPKSTRU->Field_Len  := TMP_STRU->Field_Len
                TMPKSTRU->Field_Dec  := TMP_STRU->Field_Dec
                TMP_STRU->(dbskip())
                if TMP_STRU->(eof())
                    exit
                end
            end

            // Close
            TMP_STRU->(dbclosearea())

            // Make a temporary copy.
            // Rename is not possible as a memo (.dbt) file
            // can be present.
            // The RDD must be the cOldRddDefault to generate
            // a right copy of the file.
            select( "DBF_MODIFY" )
            __dbCopy( cTempPath+"\TEMP", NIL,;
                { || WaitFileEval() } )
            waitFileEval( .T. )

            // Close
            DBF_MODIFY->( dbCloseArea() )

        end

        // Select
        select( "TMPKSTRU" )
        dbgotop()

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := 0
        nRight      := maxcol()
        nLeft       := nRight - 41
        nWidth      := nRight - nLeft +1
        cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_WINDOW_TOP_DBF_STRUCTURE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_END_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_CTRLY, nWidth ) )

        setcolor( COLOR_DEFAULT2 )
        @nTop,nLeft to nBottom,nLeft double
        @nTop,nRight to nBottom,nRight double
        scroll( nTop+1, nLeft+1, nBottom-2, nRight-1 )

        acCol        := { "if( deleted(), '*', ' ' )",;
                        "Order",;
                        "Field_Name",;
                        "Field_Type",;
                        "Field_Len",;
                        "Field_Dec" }

        acColSayPic  := { "!",;
                        "999999",;
                        "!!!!!!!!!!",;
                        "!",;
                        "999",;
                        "9999" }

        acColHead    := { "*",;
                        "Order",;
                        "Field Name",;
                        "Type",;
                        "Length",;
                        "Decimal" }

        alColCalc    := { .T.,;
                        .F.,;
                        .F.,;
                        .F.,;
                        .F.,;
                        .F. }

        abColValid   := { bOK,;
                        bOk,;
                        bOk,;
                        {|| iif( Field->Field_Type == "C";
                            .or. Field->Field_Type == "N";
                            .or. Field->Field_Type == "D";
                            .or. Field->Field_Type == "L";
                            .or. Field->Field_Type == "M",;
                            eval(bOk),;
                            eval( {||;
                                messageLine(IDB_ERROR_FIELD_TYPE,,row()+1),;
                                .f.}) ) },;
                        {|| iif( Field->Field_Type == "N";
                            .and. Field->Field_Len <= 0,;
                            eval( {||;
                                messageLine(IDB_ERROR_FIELD_NUMERIC_TOO_LITTE,,row()+1),;
                                .f.} ),;
                            eval(bOk);
                            ) },;
                        {|| iif( (Field->Field_Type == "N";
                                .and. Field->Field_Dec > 0;
                                .and. Field->Field_Dec > Field->Field_Len-2);
                            .or. Field->Field_Dec < 0,;
                            eval( {||;
                                messageLine(IDB_ERROR_FIELD_DECIMAL_TOO_BIG,,row()+1),;
                                .f.}),;
                            eval(bOk);
                            ) } }

        abColMsg     := { {||""},;
                        {||"Fields sequence order"},;
                        {||""},;
                        {||"C, N, D, L, M"},;
                        {|| iif( Field->Field_Type == "N", "", "" ) +;
                            iif( Field->Field_Type == "C", "Max 255", "" ) +;
                            iif( Field->Field_Type == "D", "8", "" ) +;
                            iif( Field->Field_Type == "M", "10", "" ) +;
                            iif( Field->Field_Type == "L", "1", "") },;
                        {|| iif( Field->Field_Type == "N";
                            .and. Field->Field_Len > 2,;
                            "Max " + alltrim( str( Field->Field_Len-2 ) ), "" ) +;
                            iif( Field->Field_Type == "C",;
                            "Max 250", "" ) } }


        // TB( <nTop>, <nLeft>, <nBottom>, <nRight>,
        //      <acCol>, <acColSayPic>,
        //      [<acColHead>], [<acColFoot>],
        //      [<alColCalc>], [<abColValid>], [<abColMsg>],
        //      [<nFreeze>],
        //      [<lModify>], [<lAppend>], [<lDelete>],
        //      [<lAutosort>] )  --> NIL

        TB( nTop+1, nLeft+1, nBottom-2, nRight-1,;
            acCol, acColSayPic,;
            acColHead, NIL,;
            alColCalc, abColValid, abColMsg,;
            1, .T., .T., .T., .T. )
        pack

        sort to (cTempPath+"\TMPSSTRU") on Order
        TMPKSTRU->(dbclosearea())

        // Closes window
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        cNewName :=;
            padr( strAddExtention( cName, _EXTENTION_DBF ),;
            SPACE_LEN )

        cNewRdd := padr( cOldRddDefault, SPACE_LEN )

        // Create a kind of window.
        setkey( K_F1, { || Text(IDB_HELP_SAVE_CREATED_MODIFYED_FILE) } )
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_DBF_FILE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft say IDB_PROMPT_NEW_DBF_SAVE
            @row()+1,nLeft;
                get cNewName picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                    {|| cNewName := padr( Dir( cNewName,,,,.T. ),;
                    SPACE_LEN ) } );
                valid ( ( cNewName :=;
                    padr(strAddExtention(cNewName,;
                    _EXTENTION_DBF),;
                    SPACE_LEN) ) <> NIL )
            @row()+1,nLeft say IDB_PROMPT_NEW_RDD_SAVE
            @row()+1,nLeft;
                get cNewRdd picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                    {|| cNewRdd := padr( selectRdd(),;
                    SPACE_LEN ) } );
                valid ( ( cNewRdd :=;
                    padr( cNewRdd, SPACE_LEN) ) <> SPACE_STR )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // ok
                do case
                case strAddExtention(cNewName, _EXTENTION_DBF);
                    <> strAddExtention( cName, _EXTENTION_DBF );
                    .and. file( strAddExtention( cNewName,;
                    _EXTENTION_DBF ) );
                    .and. ( alert( alltrim(cNewName) + ";" +;
                    _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                    { _MENU_NO, _MENU_YES } ) == 1 )
                    //
                    // loop
                case strCutExtention( cNewName ) == ""
                        // loop
                otherwise
                    lGoOn := .T.
                    exit
                end

            otherwise
                // loop
            end
        end

        if lGoOn
            // ok save
            cNewName := strAddExtention( cNewname, _EXTENTION_DBF )
        else
            break
        end

        // The file is created
        bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
        begin sequence
            // The file is created deleting before the
            // eventual memo file
            cNewName := strCutExtention( cNewName )
            ferase( cNewName+".DBT" )
            create (cNewName);
                FROM &(cTempPath+"\TMPSSTRU");
                NEW;
                VIA (cNewRdd)
            select( strFile(cNewName) )

            if !lCreate
                // The content is copied
                append FROM &(cTempPath+"\TEMP") FOR WaitFileEval()
                waitFileEval( .T. )
                // Temporary file deletion
                if ( alert( IDB_PROMPT_TEMP_DELETE,;
                    { _MENU_NO, _MENU_YES } ) == 2 )
                    //
                    ferase( cTempPath+"\TEMP." + _EXTENTION_DBF )
                    ferase( cTempPath+"\TEMP.DBT" )
                end
            end

            // Macro Recorder.
            if lCreate;
                .and. isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                //
                aStruct := dbstruct()
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    "// Create a db file."
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    "// dbcreate( <cDatabase>, " +;
                    "<aStruct>, [<cDriver>] ) --> NIL"
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [dbcreate( "] +;
                    strCutExtention(cNewName) +;
                    [", ;] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [   { ;] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                for nI := 1 to len( aStruct )
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [      {"] +;
                        aStruct[nI][1] +;
                        [","] +;
                        aStruct[nI][2] +;
                        [",] +;
                        ltrim(str(aStruct[nI][3])) +;
                        [,] +;
                        ltrim(str(aStruct[nI][4])) +;
                        [}] +;
                        iif( nI == len(aStruct), [], [,] ) +;
                        [;] 
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                next
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [   }, "] + alltrim(cNewRdd) + [" )] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            end

            // close
            dbclosearea()
            // Temporary file deletion
            ferase( cTempPath+"\TMP_STRU." + _EXTENTION_DBF )
            ferase( cTempPath+"\TMPKSTRU." + _EXTENTION_DBF )
            ferase( cTempPath+"\TMPKSTRU." +;
                _EXTENTION_INDEXBAG_STANDARD )
            ferase( cTempPath+"\TMPSSTRU." + _EXTENTION_DBF )

        recover
            (cNewName)->( dbCloseArea() )
            dbusearea( .T., NIL, cTempPath+"\TEMP", "Temp", .F. )
            select( "Temp" )
            copy TO &(cNewName) FOR WaitFileEval()
            ("Temp")->( dbCloseArea() )
            waitFileEval( .T. )
        end sequence
        errorblock(bOldErrorHandler)

    end sequence

    // restore
    rddsetdefault( cOldRddDefault )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    set( _SET_DELETED, lOldDeleted )
    dbselectarea( nOldSelect )

    return NIL

//----------------------------------------------------------------
static function idbUseArea()
//&
//
// idbUseArea() --> NIL
//
// It Opens a (.dbf) file.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local cOldRddDefault      := rddsetdefault()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_DBF_OPEN) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local cDbfName            :=;
        padr( "*." + _EXTENTION_DBF, SPACE_LEN )
    local cAliasName          := space(10) // max alias name length
    local lShared             := .T.
    local lReadOnly           := .T.
    local cRdd
    local lGoOn

    begin sequence

        // Prepare the RDD name.
        cRdd := padr( cOldRddDefault, SPACE_LEN )

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 12
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_OPEN_DBF, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_DBF_FILENAME
            @row()+1,nLeft;
                get cDbfName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cDbfName :=;
                    padr( Dir( cDbfName,,,,.T. ), SPACE_LEN ) } );
                valid ( isFile ( cDbfName :=;
                    padr(strAddExtention(cDbfName,;
                    _EXTENTION_DBF),;
                    SPACE_LEN) ) )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_DBF_ALIASNAME
            @row()+1,nLeft;
                get cAliasName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when ( truesetkey( K_F2, NIL );
                    .and. (cAliasName:=;
                    padr( strCutExtention( strFile(cDbfName) ),;
                    10) ) <> NIL );
                    valid ( cAliasName <> SPACE_STR )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_DBF_RDDNAME
            @row()+1,nLeft;
                get cRdd picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                    {|| cRdd := padr( selectRdd(),;
                    SPACE_LEN ) } );
                valid ( ( cRdd :=;
                    padr( cRdd, SPACE_LEN) ) <> SPACE_STR )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_DBF_SHARED
            @row()+1,nLeft;
                get lShared picture "@L";
                when truesetkey( K_F2, NIL )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_DBF_READ_ONLY
            @row()+1,nLeft;
                get lReadOnly;
                picture "@L";
                when truesetkey( K_F2, NIL )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                // chack for valid data
                if isFile( strAddExtention( cDbfName,;
                    _EXTENTION_DBF ) );
                    .and. !empty(cAliasName)
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end

        end

        restscreen( nTop, nLeft,;
            nBottom, nRight, cOldScreen )

        if lGoOn
            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                // the file is opened
                dbusearea( .T., cRdd,;
                    alltrim(cDbfName), alltrim(cAliasName),;
                    lShared, lReadOnly )

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Open a db file.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// dbusearea( [<lNewArea>], " +;
                        "[<cDriver>], <cName>, [<xcAlias>], " +;
                        "[<lShared>], [<lReadOnly>] ) --> NIL"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbusearea( .T., "]+;
                        alltrim(cRdd) + [", "] +;
                        alltrim(cDbfName) +;
                        [", "] +;
                        rtrim(cAliasName) +;
                        [", .] +;
                        transform( lShared, 'L' ) +;
                        [., .] +;
                        transform( lReadOnly, 'L' ) +;
                        [. ) ]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                // nil
            end sequence
            errorblock(bOldErrorHandler)
        end

    end sequence

    // restore
    rddsetdefault( cOldRddDefault )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbReplace()
//&
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_DBF_REPLACE) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn := .F.

    static cField
    static cExpr
    static cWhileCondition
    static cForCondition

    if cWhileCondition == NIL;
        .or. cWhileCondition = SPACE_STR
        //
        cWhileCondition := padr( ".T.", SPACE_LEN )
    end

    if cForCondition == NIL;
        .or. cForCondition = SPACE_STR
        //
        cForCondition := padr( ".T.", SPACE_LEN )
    end

    if cField = NIL
        cField := space(10)
    end

    if cExpr == NIL
        cExpr := SPACE_STR
    end

    begin sequence

        if alias() == ""
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Try to lock
        if flock()
            // ok
        else
            alert( _ERROR_FLOCK_FAILURE )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 10
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_REPLACE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_REPLACE_FIELD
            @row()+1,nLeft;
                get cField;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cField :=;
                    padr( fieldNormal(),;
                    10 ) } );
                valid ( .t. )
            @row()+1,nLeft;
                say IDB_PROMPT_REPLACE_NEW_VALUE
            @row()+1,nLeft;
                get cExpr;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cExpr :=;
                    padr( rtrim(cExpr) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( .t. )
            @row()+1,nLeft;
                say IDB_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft;
                get cWhileCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cWhileCondition :=;
                    padr( rtrim(cWhileCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cWhileCondition == SPACE_STR,;
                    ".T.", cWhileCondition ) <> NIL )
            @row()+1,nLeft;
                say IDB_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft;
                get cForCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cForCondition :=;
                    padr( rtrim(cForCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cForCondition == SPACE_STR,;
                    ".T.", cForCondition ) <> NIL )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                if alert( IDB_PROMPT_DBF_REPLACE,;
                    { _MENU_NO, _MENU_YES } ) == 2
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                cField := padr( alltrim(cField), 10 )
                dbgotop()
                dbeval( {|| _FIELD->&(cField) :=;
                    &(rtrim(cExpr))},;
                    {|| &(alltrim(cForCondition) );
                    .AND. !deleted();
                    .AND. waitFileEval() },;
                    {|| &(alltrim(cWhileCondition))},,, .F. )
                // Close the possible wait bar.
                waitFileEval( .T. )
                dbgotop()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Replace.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [flock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbeval( { || (Field->] +;
                        alltrim(cField) +;
                        [:=] +;
                        rtrim(cExpr) +;
                        [) }, { || (!deleted() .and. ] +;
                        alltrim(cForCondition) +;
                        [ ) }, { || ] +;
                        alltrim(cWhileCondition) +;
                        [ },,, .F. )]  
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbgotop()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbunlock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                dbgotop()
            end sequence
            waitFileEval( .T. )
            errorblock(bOldErrorHandler)
        end

        dbunlock()

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbRecall()
//&
//
    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_DBF_RECALL) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn := .F.

    static cWhileCondition
    static cForCondition

    if cWhileCondition == NIL;
        .or. cWhileCondition = SPACE_STR
        //
        cWhileCondition := padr( ".T.", SPACE_LEN )
    end

    if cForCondition == NIL;
        .or. cForCondition = SPACE_STR
        //
        cForCondition := padr( ".T.", SPACE_LEN )
    end

    begin sequence

        if alias() == ""
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Try to lock
        if flock()
            // ok
        else
            alert( _ERROR_FLOCK_FAILURE )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_RECALL, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft;
                get cWhileCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cWhileCondition :=;
                    padr( rtrim(cWhileCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cWhileCondition == SPACE_STR,;
                    ".T.", cWhileCondition ) <> NIL )
            @row()+1,nLeft;
                say IDB_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft;
                get cForCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cForCondition :=;
                    padr( rtrim(cForCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cForCondition == SPACE_STR,;
                    ".T.", cForCondition ) <> NIL )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                if alert( IDB_PROMPT_DBF_RECALL,;
                    { _MENU_NO, _MENU_YES } ) == 2
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                dbgotop()
                dbeval( {|| dbrecall()},;
                    {|| deleted();
                    .and. &(alltrim(cForCondition));
                    .and. waitFileEval() },;
                    {|| &(alltrim(cWhileCondition))},,, .F. )
                // Close the possible wait bar.
                waitFileEval( .T. )
                dbgotop()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Recall records marked for deletion.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [flock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbeval( { || ( dbrecall() ) }, ] +;
                        [{ || (deleted() .and. ] +;
                        alltrim(cForCondition) +;
                        [ ) }, { || ] +;
                        alltrim(cWhileCondition) +;
                        [ },,, .F. )]  
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbgotop()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbunlock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                dbgotop()
            end sequence
            waitFileEval( .T. )
            errorblock(bOldErrorHandler)
        end

        dbunlock()

    end sequence

    // restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbDelete()
//&
//
    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_DBF_DELETE) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn := .F.

    static cWhileCondition
    static cForCondition

    if cWhileCondition == NIL;
        .or. cWhileCondition = SPACE_STR
        //
        cWhileCondition := padr( ".F.", SPACE_LEN )
    end

    if cForCondition == NIL;
        .or. cForCondition = SPACE_STR
        //
        cForCondition := padr( ".F.", SPACE_LEN )
    end

    begin sequence

        if alias() == ""
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Try to lock
        if flock()
            // ok
        else
            alert( _ERROR_FLOCK_FAILURE )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_DELETE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft say IDB_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft get cWhileCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cWhileCondition :=;
                    padr( rtrim(cWhileCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cWhileCondition == SPACE_STR,;
                    ".T.", cWhileCondition ) <> NIL )
            @row()+1,nLeft say IDB_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft get cForCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cForCondition :=;
                    padr( rtrim(cForCondition) + fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( iif( cForCondition == SPACE_STR,;
                    ".T.", cForCondition ) <> NIL )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                if alert( IDB_PROMPT_DBF_DELETE,;
                    { _MENU_NO, _MENU_YES } ) == 2
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end

        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                dbgotop()
                dbeval( {|| dbdelete()},;
                    {|| !deleted();
                    .and. &(alltrim(cForCondition));
                    .and. waitFileEval() },;
                    {|| &(alltrim(cWhileCondition))},,, .F. )
                // Close the possible wait bar.
                waitFileEval( .T. )
                dbgotop()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Delete records.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [flock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbeval( { || ( dbdelete() ) }, ] +;
                        [{ || (!deleted() .and. ] +;
                        alltrim(cForCondition) +;
                        [ ) }, { || ] +;
                        alltrim(cWhileCondition) +;
                        [ },,, .F. )]  
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbgotop()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbunlock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end
            recover
                dbgotop()
            end sequence
            waitFileEval( .T. )
            errorblock(bOldErrorHandler)
        end

        dbunlock()

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbPack()
//&
//
// It tries to make a PACK, and if it fails, there is no program
// interruption.
//

    local bOldErrorHandler

    if alias() == ""  // no alias
        alert( _ERROR_NO_ALIAS )
        return NIL
    end

    if alert( IDB_PROMPT_DBF_PACK,;
        { _MENU_NO, _MENU_YES } ) == 1
        return NIL
    end

    WaitFor( IDB_WAIT_PACK )

    bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
    begin sequence
        pack

        // Macro recorder
        if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            Memvar->_MEMVAR_MACRO_RECORDER +=;
                [// Pack.]
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            Memvar->_MEMVAR_MACRO_RECORDER +=;
                [__dbpack()]
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
        end

    recover
        // nil
    end sequence
    errorblock(bOldErrorHandler)

    WaitFor()

    return NIL

//----------------------------------------------------------------
static function idbOrdCreate()
//&
//
// idbOrdCreate() --> NIL
//
// Create an index for the active Alias.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_NTX_CREATE) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0
    local lOldDeleted         := set( _SET_DELETED, .T. )

    local cFileName := SPACE_STR
    local lExit     := .F.
    local lGoOn     := .T.

    static cTagName
    static cForCondition
    static cOrdBagName
    static cOrdExpr

    if cForCondition == NIL;
        .or. cForCondition = SPACE_STR // empty
        //
        cForCondition := padr( ".T.", SPACE_LEN )
    else
        cForCondition := padr( cForCondition, SPACE_LEN )
    end

    if cTagName == NIL
        cTagName := SPACE_STR
    else
        cTagName := padr( cTagName, SPACE_LEN )
    end

    if cOrdBagName == NIL
        cOrdBagName := padr( "*." + _EXTENTION_INDEXBAG,;
            SPACE_LEN )
    else
        cOrdBagName := padr( cOrdBagName, SPACE_LEN )
    end

    if cOrdExpr == NIL
        cOrdExpr := SPACE_STR
    else
        cOrdExpr := padr( cOrdExpr, SPACE_LEN )
    end

    begin sequence

        if alias() == "" // no alias
            alert( _ERROR_NO_ALIAS )
            break
        end


        // Create a kind of window.
        nBottom     := maxrow()
        do case
        case rddname() == "DBFNTX"
            nTop    := nBottom - 8
        case rddname() == "DBFNDX"
            nTop    := nBottom - (8 -2)
        case rddname() == "DBPX"
            nTop    := nBottom - (8 -2)
        case rddname() == "DBFCDX"
            nTop    := nBottom - (8 +2)
        case rddname() == "DBFMDX"
            nTop    := nBottom - (8 +2)
        otherwise
            nTop    := nBottom - 8 +2
        end
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_NTX_NEW, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_NEW_NTX_FILENAME
            @row()+1,nLeft;
                get cOrdBagName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cOrdBagName :=;
                    padr( Dir( cOrdBagName,,,,.T. ), SPACE_LEN ) } );
                valid true( cOrdBagName :=;
                    padr(strAddExtention( cOrdBagName,;
                    _EXTENTION_INDEXBAG ), SPACE_LEN ) );
                    .and. !isWild( cOrdBagName )
            @row()+1,nLeft;
                say IDB_PROMPT_NEW_NTX_KEYEXPR
            @row()+1,nLeft;
                get cOrdExpr;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cOrdExpr :=;
                    padr( rtrim(cOrdExpr) + fieldIndex(),;
                    SPACE_LEN ) } );
                valid ( cOrdExpr <> SPACE_STR )
            if rddname() == "DBFMDX";
                .or. rddname() == "DBFCDX"
                //
                @row()+1,nLeft;
                    say IDB_PROMPT_TAG_NAME
                @row()+1,nLeft;
                    get cTagName;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when truesetkey( K_F2, NIL );
                    valid true( iif( cTagName == SPACE_STR,;
                        cTagName := cOrdBagName,;
                        .t. ) )
            end
            if rddname() == "DBFNDX";
                .or. rddname() == "DBPX"
                //
                // There is no FOR condition
            else
                @row()+1,nLeft;
                    say IDB_PROMPT_FOR_EXPRESSION
                @row()+1,nLeft;
                    get cForCondition;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, {|| cForCondition :=;
                        padr( rtrim(cForCondition) +;
                        fieldNormal(),;
                        SPACE_LEN ) } );
                    valid true( iif( cForCondition == SPACE_STR,;
                        ".t.", cForCondition ) )
            end

            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                if file( strAddExtention( cOrdBagName,;
                    _EXTENTION_INDEXBAG ) )
                    //
                    if alert( strAddExtention( cOrdBagName,;
                        _EXTENTION_INDEXBAG ) + ";" +;
                        _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                        {_MENU_NO, _MENU_YES} ) == 2
                        //
                        lGoOn := .T.
                        exit
                    else
                        // loop
                    end
                else
                    if !isWild( cOrdBagName )
                        //
                        lGoOn := .T.
                        exit
                    else
                        // loop
                    end
                end
            otherwise
                // loop
            end

        end

        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn

            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                lExit := .T.
                do case
                case rddname() == "DBFCDX"
                    ordCondSet( (cForCondition),;
                        {|| &(cForCondition)},,,;
                        {|| WaitFileEval()},, RECNO(),,,, .F. )
                    ordCreate((alltrim(cOrdBagName)),;
                        (alltrim(cTagName)),;
                        (alltrim(cOrdExpr)),;
                        {|| &(alltrim(cOrdExpr))}, .F. )
                    waitFileEval( .T. )

                    // Macro recorder
                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [// Create index.]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCondSet( ] +;
                            alltrim(cForCondition) +;
                            [ , {|| ] +;
                            alltrim(cForCondition) +;
                            [},,,,, RECNO(),,,, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCreate( "] +;
                            alltrim(cOrdBagName) +;
                            [", "] +;
                            alltrim(cTagName) +;
                            [", "] +;
                            alltrim(cOrdExpr) +;
                            [", {|| ] +;
                            alltrim(cOrdExpr) +;
                            [ }, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    end

                case rddname() == "DBFMDX"
                    ordCondSet( (cForCondition),;
                        {|| &(cForCondition)},,,;
                        {|| WaitFileEval()},, RECNO(),,,, .F. )
                    ordCreate((alltrim(cOrdBagName)),;
                        (alltrim(cTagName)),;
                        (alltrim(cOrdExpr)),;
                        {|| &(alltrim(cOrdExpr))}, .F. )
                    waitFileEval( .T. )

                    // Macro recorder
                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [// Create index.]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCondSet( ] +;
                            alltrim(cForCondition) +;
                            [ , {|| ] +;
                            alltrim(cForCondition) +;
                            [},,,,, RECNO(),,,, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCreate( "] +;
                            alltrim(cOrdBagName) +;
                            [", "] +;
                            alltrim(cTagName) +;
                            [", "] +;
                            alltrim(cOrdExpr) +;
                            [", {|| ] +;
                            alltrim(cOrdExpr) +;
                            [ }, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    end

                case rddname() == "DBFNTX"
                    ordCondSet( (cForCondition),;
                        {|| &(cForCondition)},,,;
                        {|| WaitFileEval()},, RECNO(),,,, .F. )
                    ordCreate((alltrim(cOrdBagName)),,;
                        (alltrim(cOrdExpr)),;
                        {|| &(alltrim(cOrdExpr))}, .F. )
                    waitFileEval( .T. )

                    // Macro recorder
                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [// Create index.]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCondSet( ] +;
                            alltrim(cForCondition) +;
                            [ , {|| ] +;
                            alltrim(cForCondition) +;
                            [},,,,, RECNO(),,,, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCreate( "] +;
                            alltrim(cOrdBagName) +;
                            [",, "] +;
                            alltrim(cOrdExpr) +;
                            [", {|| ] +;
                            alltrim(cOrdExpr) +;
                            [ }, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    end

                case rddname() == "DBFNDX"
                    ordCreate((alltrim(cOrdBagName)),,;
                        (alltrim(cOrdExpr)),;
                        {|| &(alltrim(cOrdExpr))}, .F. )
                    // Macro recorder

                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [// Create index.]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCondSet( ,,,, ] +;
                            [{|| zFileEval()},, ] +;
                            [RECNO(),,,, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordCreate( "] +;
                            alltrim(cOrdBagName) +;
                            [",, "] +;
                            alltrim(cOrdExpr) +;
                            [", {|| ] +;
                            alltrim(cOrdExpr) +;
                            [ }, .F. )]
                        Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    end

                end

                dbgotop()
            recover
                set index to
                dbgotop()
                lExit := .F.
            end sequence
            errorblock(bOldErrorHandler)
            waitFileEval( .T. )
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    set( _SET_DELETED, lOldDeleted )

    return NIL

//----------------------------------------------------------------
static function idbSetindex()
//&
//
// idbNtxOpen() --> NIL
//
// It Opens an index bag file.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_SET_INDEX) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local cOrdBagName         :=;
        padr( "*." + _EXTENTION_INDEXBAG, SPACE_LEN )
    local lGoOn

    begin sequence

        if alias() == ""
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 3
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_OPEN_NTX, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_OPEN_NTX_FILENAME
            @row()+1,nLeft;
                get cOrdBagName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cOrdBagName :=;
                    padr( Dir( cOrdBagName,,,,.T. ), SPACE_LEN ) } );
                valid file( cOrdBagName :=;
                    padr(strAddExtention(cOrdBagName,;
                    _EXTENTION_INDEXBAG),;
                    SPACE_LEN) )
            read
            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                // chack for valid data
                if file( strAddExtention( cOrdBagName,;
                    _EXTENTION_INDEXBAG ) );
                    .and. ( cOrdBagName <> SPACE_STR )
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end

        end

        restscreen( nTop, nLeft,;
            nBottom, nRight, cOldScreen )

        if lGoOn
            bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                dbsetindex( alltrim( cOrdBagName ) )

                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Open an index.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// dbsetindex(<cOrdBagName>)"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbsetindex( "] + alltrim(cOrdBagName) + [" ) ] 
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                set index to
            end sequence
            errorblock(bOldErrorHandler)
        end

    end sequence

    // restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function idbClearIndex()
//&
//
    if alias() == ""
        // There is no need to do it.
    else
        dbclearindex()

        // Macro Recorder.
        if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            Memvar->_MEMVAR_MACRO_RECORDER +=;
                [// Close all indexes for the current work area.]
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            Memvar->_MEMVAR_MACRO_RECORDER +=;
                [dbclearindex()] 
            Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
        end

    end

    return NIL

//----------------------------------------------------------------
static function idbReindex()
//&
//
    local bOldErrorHandler

    do case
    case ( alias() == "" )  // no alias
        alert( _ERROR_NO_ALIAS )
    case ordbagname( ordsetfocus() ) == ""
        alert( _ERROR_NO_INDEX )
    otherwise
        // Try to flock, but it works only on NTX files.
        // With other index bag types an exclusive,
        // open is required.
        bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
        begin sequence
            if !flock()
                alert( _ERROR_FLOCK_FAILURE )
                break
            end
            begin sequence

                reindex eval WaitFileEval()
                waitFileEval( .T. )

                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Reindex.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER += [flock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbreindex()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbunlock()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                alert( _ERROR_EXCLUSIVE_REQUIRED )
            end sequence
        end sequence    
        errorblock(bOldErrorHandler)
        dbunlock()

    end

    return NIL

//----------------------------------------------------------------
static function idbRelation()
//&
//
// idbRelation() --> NIL
//
// Establish a relation in a guided form.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(IDB_HELP_RELATION_DEFINITION) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local cChildName := space(10)
    local lGoOn := .F.

    static cRelExpression

    if cRelExpression == NIL
        cRelExpression := SPACE_STR
    end

    begin sequence

        if alias() == ""
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( IDB_DIALOG_BOX_TOP_RELATION_DEFINITION,;
            nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say IDB_PROMPT_RELATION_DEFINITION_CHILDNAME
            @row()+1,nLeft;
                get cChildName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when truesetkey( K_F2, {|| cChildName :=;
                    padr( selectAlias(), 10 ) } );
                valid ( .T. )
            @row()+1,nLeft;
                say IDB_PROMPT_RELATION_DEFINITION_EXPRESSION
            @row()+1,nLeft;
                get cRelExpression;
                picture "@s"+ltrim(str(nWidth))+"@";
                when truesetkey( K_F2, {|| cRelExpression :=;
                    padr( rtrim(cRelExpression) + fieldRelation(),;
                    SPACE_LEN ) } );
                valid ( .T. )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN
                lGoOn := .T.
                exit
            otherwise
                // loop
            end

        end

        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn

            bOldErrorHandler :=;
                errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                dbSetRelation( alltrim(cChildName),;
                    {|| &(alltrim(cRelExpression))},;
                    (alltrim(cRelExpression)) )

                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Relate two work areas.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// dbsetrelation( <nArea>|<cAlias>, " +;
                        "<bExpr>, [<cExpr>] ) --> NIL"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbsetrelation( "] +;
                        alltrim(cChildName) +;
                        [", { || (] +;
                        alltrim(cRelExpression) +;
                        [) }, "] +;
                        alltrim(cRelExpression) +;
                        [" ) ]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                alert( IDB_ERROR_RELATION )
            end sequence
            errorblock(bOldErrorHandler)

        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// LBL - LABELS CREATION / EDITING
//----------------------------------------------------------------
static function lblPrint()
//&
//
// lblPrint() --> NIL
//
// This function asks for label file name,
// the FOR and WHILE condition before print.
//


    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( LBL_HELP_LABEL_FORM ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoPrint            := .T.
    local cLabelFile          :=;
        padr( "*." + _EXTENTION_LABEL, SPACE_LEN )
    local cWhileCondition     := padr( ".T.", SPACE_LEN )
    local cForCondition       := padr( ".T.", SPACE_LEN )

    local bWhileCondition
    local bForCondition

    begin sequence

        if ( alias() == "" ) // no alias
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Create a kind of window.
        nBottom           := maxrow()
        nTop              := nBottom - 8
        nLeft             := 0
        nRight            := maxcol()
        nWidth            := nRight - nLeft +1
        cOldScreen        :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( LBL_DIALOG_BOX_LABEL_FORM_TOP, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say LBL_PROMPT_OPEN_FILE_LABEL
            @row()+1,nLeft;
                get cLabelFile;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cLabelFile :=;
                        padr( Dir( cLabelFile,,,,.T. ),;
                        SPACE_LEN ) } );
                    valid ( isFile( cLabelFile :=;
                        padr( strAddExtention( cLabelFile,;
                        _EXTENTION_LABEL ), SPACE_LEN) ) )
            @row()+1,nLeft;
                say LBL_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft;
                get cWhileCondition;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cWhileCondition :=;
                        padr( fieldNormal(),;
                        SPACE_LEN ) } );
                    valid ( ( cWhileCondition :=;
                        iif( cWhileCondition <> SPACE_STR,;
                        cWhileCondition, padr( ".T.",;
                        SPACE_LEN ) ) ) <> NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft;
                get cForCondition;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cForCondition :=;
                        padr( fieldNormal(),;
                        SPACE_LEN ) } );
                    valid ( ( cForCondition :=;
                        iif( cForCondition <> SPACE_STR,;
                        cForCondition, padr( ".T.",;
                        SPACE_LEN ) ) ) <> NIL )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoPrint := .F.
                exit
            case lastkey() = K_PGDN // confirm
                // Check for correct data.
                if isFile( strAddExtention( cLabelFile,;
                    _EXTENTION_LABEL ) );
                    .and. cWhileCondition <> SPACE_STR;
                    .and. cForCondition <> SPACE_STR
                    //
                    lGoPrint := .T.
                    // Transform character conditions.
                    bWhileCondition :=;
                        bCompile( alltrim(cWhileCondition) )
                    bForCondition :=;
                        bCompile( alltrim(cForCondition);
                            + " .and. waitFileEval()" )

                    exit

                else
                    // loop
                end

            otherwise
                // loop
            end

        end

        // Close window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoPrint
            bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                // Check if the print goes on console
                if isConsoleOn()
                    setcolor( COLOR_DEFAULT2 )
                    scroll()
                end
                // Print
                __LabelForm( cLabelFile, .f., , .f.,;
                    bForCondition, bWhileCondition, , , .f., .f. )
                // Close waitProgress().
                waitFileEval( .T. )
                // If output is on the console, wait for a key.
                if isConsoleOn()
                    // Wait for a key press.
                    inkey(0)
                    scroll()
                end
                // The record pointer is maybe at bottom.
                // No action is taken to move the record pointer.
                // dbgotop()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Label print.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [__LabelForm( "] +;
                        alltrim(cLabelFile) +;
                        [", .F., NIL, .F., {|| ] +;
                        alltrim(cForCondition) +;
                        [ }, {|| ] +;
                        alltrim(cWhileCondition) +;
                        [},,, .F., .F. )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            recover
                dbgotop()
            end sequence
            errorblock(bOldErrorHandler)
            waitFileEval( .T. )
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function lblModify()
//
// lblModify() --> NIL
//
// It executes the lbl() function asking for the file name to
// modify.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( LBL_HELP_LABEL_EDIT ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .F.
    local cLabelFile          :=;
        padr( "*." + _EXTENTION_LABEL, SPACE_LEN )

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 4
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( LBL_WINDOW_LABEL, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say LBL_PROMPT_OPEN_FILE_LABEL
            @row()+1,nLeft;
                get cLabelFile;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                     {|| cLabelFile :=;
                     padr( Dir( cLabelFile,,,,.T. ), SPACE_LEN ) } );
                valid file( cLabelFile :=;
                      padr( strAddExtention( cLabelFile,;
                      _EXTENTION_LABEL ), SPACE_LEN) )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // ok
                if file( strAddExtention( cLabelFile,;
                    _EXTENTION_LABEL ) )
                    //
                    lGoOn := .T.
                    exit
                else
                    // loop
                end
            otherwise
                // loop
            end
        end

        // Close window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoOn
            lbl( cLabelFile )
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function lbl( cFileName )
//
// lbl ( [<cFileName>] ) --> NIL
//
// <cFileName>  the label file name to modify.
//              If the name is not given, it is created.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( LBL_HELP_LABEL_SAVE ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local axLblDim            :=;
        { space(60), 5, 35, 0, 1, 0, 1 }  // default
    local acLblCont[16]
    local nI
    local cOldName
    local lSave               := .F.
    local lGoOn               := .F.

    begin sequence

        if valtype( cFileName ) <> "C"
             cFileName :=;
                 strAddExtention( _UNTITLED, _EXTENTION_LABEL )
             cOldName := NIL
             // It must be created;
             // the array acLblCont[] is prepared.
             for nI = 1 to 16
                 acLblCont[nI] := space(60)
             next
         else
            // The name must be alltrimed.
            cFileName := alltrim( cFileName )
            if file( cFileName )
                cOldName := alltrim(cFileName)
                // The label file is created.
                lblLoad( cFileName, @axLblDim, @acLblCont )
            else
                cOldName := NIL
                // It must be created;
                // the array acLblCont[] is prepared.
                for nI = 1 to 16
                    acLblCont[nI] := space(60)
                next
            end
        end

        lSave := lblEdit( @axLblDim, @acLblCont )

        if lSave

            cFileName := padr( cFileName, SPACE_LEN )

            // Create a kind of window.
            nBottom     := maxrow()
            nTop        := nBottom - 4
            nLeft       := 0
            nRight      := maxcol()
            nWidth      := nRight - nLeft +1
            cOldScreen  :=;
                savescreen( nTop, nLeft, nBottom, nRight )
            setcolor( COLOR_DEFAULT1 )
            scroll( nTop, nLeft, nTop, nRight )
            scroll( nBottom-1, nLeft, nBottom, nRight )
            setpos( nTop, nLeft )
            dispout( padc( LBL_WINDOW_LABEL, nWidth ) )
            setpos( nBottom-1, nLeft )
            dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
            setpos( nBottom, nLeft )
            dispout( padc( _KEY_F2_PGDN, nWidth ) )

            while .t.
                setcolor( COLOR_DEFAULT2 )
                scroll( nTop+1, nLeft, nBottom-2, nRight )
                setpos( nTop, nLeft )
                @row()+1,nLeft;
                    say LBL_PROMPT_SAVE_FILE_LABEL
                @row()+1,nLeft;
                    get cFileName;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2,;
                        {|| cFileName :=;
                        padr( Dir( cFileName,,,,.T. ), SPACE_LEN ) } );
                    valid ( ( cFileName :=;
                        padr(strAddExtention(cFileName,;
                        _EXTENTION_LABEL), SPACE_LEN) ) <> NIL )
                read

                do case
                case lastkey() = K_ESC  // exit
                    lGoOn := .F.
                    exit
                case lastkey() = K_PGDN // ok
                    do case
                    case alltrim(cFileName) <> cOldName;
                        .and. file( strAddExtention( cFileName,;
                        _EXTENTION_LABEL ) );
                        .and. ( alert( alltrim(cFileName) + ";" +;
                        _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                        { _MENU_NO, _MENU_YES } ) == 1 )
                        //
                        // loop
                    case strCutExtention( cFileName ) == ""
                        // loop

                    otherwise
                        lGoOn := .T.
                        exit
                    end

                otherwise
                    // loop
                end
            end

            if lGoOn
                // ok save
                if lblWrite( alltrim(cFileName),;
                    axLblDim, acLblCont )
                    //
                    // ok
                else
                    alert( LBL_ERROR_FILE_NOT_SAVED )
                end
            else
               // nil
            end

        else
            // nil
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function lblLoad( cFileName, axLblDim, acLblCont )

    local cBuffer   := space( LBL_SIZE )
    local nHandle   := 0
    local nByteRead := 0
    local nOffset   := 0
    local nI

    nHandle := fopen( cFileName )

    if !ferror() == 0
        alert( cFileName + ";" +;
            LBL_ERROR_CANNOT_OPEN + str(ferror()) )
        return .F.
    end

    // Reed the file.
    nByteRead := fread( nHandle, @cBuffer, LBL_SIZE )
    if nByteRead < LBL_SIZE
        alert( cFileName + ";" +;
            LBL_ERROR_FILE_TOO_LITTLE )
        return .F.
    end

    WaitFor( LBL_WAIT_LOADING )

    // Reed dimensions.
    axLblDim[LBL_REMARK] := substr( cBuffer, 2, 60 )
    axLblDim[LBL_HEIGHT] := bin2I( substr( cBuffer, 62, 2 ) )
    axLblDim[LBL_WIDTH]  := bin2I( substr( cBuffer, 64, 2 ) )
    axLblDim[LBL_MARGIN] := bin2I( substr( cBuffer, 66, 2 ) )
    axLblDim[LBL_LINES]  := bin2I( substr( cBuffer, 68, 2 ) )
    axLblDim[LBL_SPACES] := bin2I( substr( cBuffer, 70, 2 ) )
    axLblDim[LBL_ACROSS] := bin2I( substr( cBuffer, 72, 2 ) )

    // Reed label lines content.
    nOffset := 74
    for nI = 1 to 16 // reed all
        acLblCont[nI] := substr( cBuffer, nOffset, 60 )
        nOffset += 60
    next

    fclose( nHandle )

    WaitFor()

    // ok
    return .T.

//----------------------------------------------------------------
static function lblEdit( axLblDim, acLblCont )

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, {|| Text( LBL_HELP_LABEL ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lSave := .F.

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 24  // max
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( LBL_WINDOW_LABEL, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-1, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_REMARK;
                get axLblDim[ LBL_REMARK ];
                   picture "@s"+ltrim(str(nWidth))+"@";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_HEIGHT;
                get axLblDim[ LBL_HEIGHT ] picture "999";
                   when trueSetkey( K_F2, NIL );
                   valid ( axLblDim[ LBL_HEIGHT ] > 0 .and.;
                           axLblDim[ LBL_HEIGHT ] <= 16 )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_WIDTH;
                get axLblDim[ LBL_WIDTH ]  picture "999";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_MARGIN;
                get axLblDim[ LBL_MARGIN]  picture "999";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_LINES;
                get axLblDim[ LBL_LINES ]  picture "999";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_SPACES;
                get axLblDim[ LBL_SPACES]  picture "999";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say LBL_PROMPT_LABEL_ACROSS;
                get axLblDim[ LBL_ACROSS]  picture "999";
                   when trueSetkey( K_F2, NIL )
            @row()+1,nLeft;
                say "   1   ";
                get acLblCont[1];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 1 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "   2   ";
                get acLblCont[2];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 2 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft say;
                "   3   ";
                get acLblCont[3];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 3 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft say;
                "   4   ";
                get acLblCont[4];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 4 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft say;
                "   5   ";
                get acLblCont[5];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 5 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft say;
                "   6   ";
                get acLblCont[6];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 6 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "   7   ";
                get acLblCont[7];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 7 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "   8   ";
                get acLblCont[8];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 8 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "   9   ";
                get acLblCont[9];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 9 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  10   ";
                get acLblCont[10];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 10 .and.;
                        trueSetkey( K_F2,;
                        { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  11   ";
                get acLblCont[11];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 11 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  12   ";
                get acLblCont[12];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 12 .and.;
                        trueSetkey( K_F2,;
                        { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  13   ";
                get acLblCont[13];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 13 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  14   ";
                get acLblCont[14];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 14 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  15   ";
                get acLblCont[15];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 15 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            @row()+1,nLeft;
                say "  16   ";
                get acLblCont[16];
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when axLblDim[LBL_HEIGHT] >= 16 .and.;
                        trueSetkey( K_F2,;
                            { || keyboard( fieldPicture() ) } )
            read

            do case
            case lastkey() = K_ESC
                lSave := .F.
                exit
            case lastkey() = K_PGDN // conferma la scelta
                lSave := .T.
                exit
            otherwise
                // loop
            end
            // loop
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    // Terminate.
    return lSave

//---------------------------------------------------------------
static function lblWrite( cFileName, axLblDim, acLblCont )

    local cBuffer
    local nHandle   := 0
    local nByteWritten := 0
    local nI

    // Must be alltrimed.
    cFileName := alltrim( cFileName )

    // Create the label file.
    nHandle := fcreate( cFileName )

    if !ferror() == 0
        alert( cFileName + ";" +;
            LBL_ERROR_CANNOT_CREATE + ;
            str(ferror()) )
        return .F.
    end

    WaitFor( LBL_WAIT_SAVING )

    // Buffer prepare.
    cBuffer := chr(2)
    cBuffer += axLblDim[LBL_REMARK]
    cBuffer += i2bin(axLblDim[LBL_HEIGHT])
    cBuffer += i2bin(axLblDim[LBL_WIDTH])
    cBuffer += i2bin(axLblDim[LBL_MARGIN])
    cBuffer += i2bin(axLblDim[LBL_LINES])
    cBuffer += i2bin(axLblDim[LBL_SPACES])
    cBuffer += i2bin(axLblDim[LBL_ACROSS])
    for nI = 1 to 16
        cBuffer += acLblCont[nI]
    next
    cBuffer += chr(2)

    nByteWritten := fwrite( nHandle, cBuffer )

    if nByteWritten != LBL_SIZE
        alert( LBL_ERROR_SOMETHING_GONE_WRONG )
    end

    fclose( nHandle )

    WaitFor()

    // ok
    return .T.

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// MACRO - MACRO FUNCTIONS
//----------------------------------------------------------------
static function macroCompile()
//
// It asks for the name of a macro to compile.
//

    local getlist             := {}
    local bOldErrorHandler
    local nOldSelect          := select()
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( MACRO_COMPILE_HELP ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .T.

    local cMacroName          :=;
        padr( "*.*", SPACE_LEN )
    local cCompiledName       := SPACE_STR

    begin sequence

        // Create a window.
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( MACRO_DIALOG_BOX_TOP_COMPILE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say MACRO_PROMPT_SOURCE_FILE
            @row()+1,nLeft;
                get cMacroName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cMacroName :=;
                    padr( Dir( cMacroName,,,,.T. ),;
                        SPACE_LEN ) } );
                valid ( isFile( alltrim( cMacroName ) ) )
            @row()+1,nLeft;
                say MACRO_PROMPT_DESTINATION_FILE
            @row()+1,nLeft;
                get cCompiledName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid ( empty( cCompiledName );
                    .or. !isWild( alltrim( cCompiledName ) ) )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // choice confirmation
                // Verify to have correct data.
                if isFile( alltrim(cMacroName) );
                    .and. empty( cCompiledName );
                        .or. !isWild( alltrim( cCompiledName ) )
                    //
                    if empty( cCompiledName )
                        cCompiledName := NIL
                    end
                    //
                    lGoOn := .T.
                    exit
                else
                    // Loop.
                end
            otherwise
                // Loop.
            end
        end

        // Delete window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        // Restore Colors.
        setcolor( cOldColor )

        if lGoOn
            // Start compilation.
            cm( cMacroName, cCompiledName )
        end

    end sequence

    // Restore.
    select( nOldSelect )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function macroLoad()
//
// It asks for the name of a macro to load and execute.
//

    local getlist             := {}
    local bOldErrorHandler
    local nOldSelect          := select()
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( MACRO_LOAD_HELP ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .T.

    local cMacroName          :=;
        padr( "*.*", SPACE_LEN )
    local cPar1               := SPACE_STR
    local cPar2               := SPACE_STR
    local cPar3               := SPACE_STR
    local cPar4               := SPACE_STR
    local cPar5               := SPACE_STR
    local cPar6               := SPACE_STR
    local cPar7               := SPACE_STR
    local cPar8               := SPACE_STR
    local cPar9               := SPACE_STR

    begin sequence

        // Create a window.
        nBottom     := maxrow()
        nTop        := nBottom - 22
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( MACRO_DIALOG_BOX_TOP_OPEN, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD
            @row()+1,nLeft;
                get cMacroName;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cMacroName :=;
                    padr( Dir( cMacroName,,,,.T. ),;
                        SPACE_LEN ) } );
                valid ( isFile( alltrim( cMacroName ) ) )
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR1
            @row()+1,nLeft;
                get cPar1;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar1 :=;
                    padr( Dir( cPar1,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR2
            @row()+1,nLeft;
                get cPar2;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar2 :=;
                    padr( Dir( cPar2,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR3
            @row()+1,nLeft;
                get cPar3;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar3 :=;
                    padr( Dir( cPar3,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR4
            @row()+1,nLeft;
                get cPar4;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar4 :=;
                    padr( Dir( cPar4,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR5
            @row()+1,nLeft;
                get cPar5;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar5 :=;
                    padr( Dir( cPar5,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR6
            @row()+1,nLeft;
                get cPar6;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar6 :=;
                    padr( Dir( cPar6,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR7
            @row()+1,nLeft;
                get cPar7;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar7 :=;
                    padr( Dir( cPar7,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR8
            @row()+1,nLeft;
                get cPar8;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar8 :=;
                    padr( Dir( cPar8,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            @row()+1,nLeft;
                say MACRO_PROMPT_LOAD_PAR9
            @row()+1,nLeft;
                get cPar9;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cPar9 :=;
                    padr( Dir( cPar9,,,,.T. ),;
                        SPACE_LEN ) } );
                valid .T.
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // choice confirmation
                // Verify to have correct data.
                if isFile( alltrim(cMacroName) )
                    //
                    lGoOn := .T.
                    exit
                else
                    // Loop.
                end
            otherwise
                // Loop.
            end
        end

        // Delete window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        // Restore Colors.
        setcolor( cOldColor )


        if lGoOn
            // No help.
            setkey( K_F1, NIL )
            // Run the macro executor, but before, transfer
            // public variables.
            Memvar->_MEMVAR_PAR0 := alltrim( cMacroName )
            Memvar->_MEMVAR_PAR1 := alltrim( cPar1 )
            Memvar->_MEMVAR_PAR2 := alltrim( cPar2 )
            Memvar->_MEMVAR_PAR3 := alltrim( cPar3 )
            Memvar->_MEMVAR_PAR4 := alltrim( cPar4 )
            Memvar->_MEMVAR_PAR5 := alltrim( cPar5 )
            Memvar->_MEMVAR_PAR6 := alltrim( cPar6 )
            Memvar->_MEMVAR_PAR7 := alltrim( cPar7 )
            Memvar->_MEMVAR_PAR8 := alltrim( cPar8 )
            Memvar->_MEMVAR_PAR9 := alltrim( cPar9 )
            ex( alltrim(cMacroName) )
        end

    end sequence

    // Restore.
    select( nOldSelect )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function macroEdit()
//
// Edit memvar->c_MacroRec
//
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( MACRO_EDIT_HELP ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    begin sequence

        // Create a window.
        nBottom     := maxrow()
        nTop        := 0
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( MACRO_DIALOG_BOX_TOP_EDIT, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_CTRLW, nWidth ) )

        // Do the editing.
        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft, nBottom-2, nRight )
        memvar->_MEMVAR_MACRO_RECORDER :=;
            Memoedit(memvar->_MEMVAR_MACRO_RECORDER,;
            1, 0, maxrow()-2, maxcol(), .T., NIL, SPACE_LEN )
   
    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function macroSave()

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( MACRO_SAVE_HELP ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .T.

    local cMacroName          :=;
        padr( "*.*", SPACE_LEN )

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 4
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom-1, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( MACRO_DIALOG_BOX_TOP_SAVE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )
            setpos( nTop, nLeft )
            @row()+1,nLeft say MACRO_PROMPT_SAVE_MACRO
            @row()+1,nLeft;
                get cMacroName picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2,;
                    {|| cMacroName := padr( dir( , , , .F. ),;
                    SPACE_LEN ) } );
                valid ( !isWild( cMacroName );
                    .and. cMacroName <> SPACE_STR )
            read

            do case
            case lastkey() = K_ESC  // exit
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // ok
                do case
                case cMacroName == SPACE_STR;
                    .or. isWild( cMacroName );
                    .or. (file( cMacroName );
                        .and. ( alert( alltrim(cMacroName) + ";" +;
                        _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                        { _MENU_NO, _MENU_YES } ) == 1 ) )
                    //
                    // loop
                case strCutExtention( cMacroName ) == ""
                        // loop
                otherwise
                    lGoOn := .T.
                    exit
                end

            otherwise
                // loop
            end
        end

        if lGoOn
            // ok save
            memowrit( alltrim(cMacroName),;
                Memvar->_MEMVAR_MACRO_RECORDER )
        else
            break
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

#endif
#ifndef RUNTIME
//----------------------------------------------------------------
// MNU - MENU SYSTEM
//----------------------------------------------------------------
static procedure mnuLeft()

   // Redirect left key for menu
   keyboard chr(K_ESC)+chr(K_LEFT)+chr(K_ENTER)

   return

//----------------------------------------------------------------
static procedure mnuRight()

   // Redirect right key for menu
   keyboard chr(K_ESC)+chr(K_RIGHT)+chr(K_ENTER)

   return

//----------------------------------------------------------------
static function mnuvFile( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +9       // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local dummy

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_NEWDIR_CHOICE;
                message MNU_MENU_FILE_NEWDIR_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_DBF_CHOICE;
                message MNU_MENU_FILE_DBF_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_NTX_CHOICE;
                message MNU_MENU_FILE_NTX_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_ALIAS_CHOICE;
                message MNU_MENU_FILE_ALIAS_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_INDEX_CHOICE;
                message MNU_MENU_FILE_INDEX_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_RELATION_CHOICE;
                message MNU_MENU_FILE_RELATION_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_FILE_RDD_DEFAULT_CHOICE;
                message MNU_MENU_FILE_RDD_DEFAULT_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                dummy := Dir( "", .T., .T., .F. )
                if right( dummy, 1 ) == "\"
                    // The last backslash must be removed
                    // or it will not work on most MS-DOS
                    // version.
                    dummy := left( dummy, len(dummy) -1 )
                end
                run( "cd " + dummy )
                dummy := strDrive( dummy )
                // If the string contains a Drive information.
                if !(dummy == "")
                    // Change drive.
                    run( dummy )
                end
            case nMnuChoice == 2
                mnupDbf(5,nRB)
            case nMnuChoice == 3
                mnupNtx(6,nRB)
            case nMnuChoice == 4
                mnupAlias(7,nRB)
            case nMnuChoice == 5
                mnupIndex(8,nRB)
            case nMnuChoice == 6
                mnupRelation(9,nRB)
            case nMnuChoice == 7
                mnupRDD(10,nRB)
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupDbf(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 5    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say;
            padc( _KEY_MENU_P,;
                maxcol()+1 )
        n := 0
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_DBF_NEW_CHOICE;
            message MNU_MENU_FILE_DBF_NEW_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_DBF_MODSTRU_CHOICE;
            message MNU_MENU_FILE_DBF_MODSTRU_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_DBF_OPEN_CHOICE;
            message MNU_MENU_FILE_DBF_OPEN_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case nMnuChoice == 1
            idbStructure()
        case nMnuChoice == 2
            idbModStructure()
        case nMnuChoice == 3
            idbUseArea()
        end

        setkey( K_F1, bSaveF1 )

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupNtx(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 4    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say padc( _KEY_MENU_P, maxcol()+1 )
        n := 0

        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_NTX_NEW_CHOICE;
            message MNU_MENU_FILE_NTX_NEW_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_NTX_OPEN_CHOICE;
            message MNU_MENU_FILE_NTX_OPEN_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case (nMnuChoice == 1)
            idbOrdCreate()
        case (nMnuChoice == 2)
            idbSetIndex()
        end

        setkey( K_F1, bSaveF1 )	

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupAlias(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 6    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local dummy

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say padc( _KEY_MENU_P, maxcol()+1 )
        n := 0

        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_ALIAS_SELECT_CHOICE;
            message MNU_MENU_FILE_ALIAS_SELECT_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_ALIAS_DISPSTRU_CHOICE;
            message MNU_MENU_FILE_ALIAS_DISPSTRU_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_ALIAS_CLOSE_CHOICE;
            message MNU_MENU_FILE_ALIAS_CLOSE_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_ALIAS_CLOSEALL_CHOICE;
            message MNU_MENU_FILE_ALIAS_CLOSEALL_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case nMnuChoice == 1
            dummy := selectArray()[1]
            if valtype(dummy) == "N"
                dbselectarea(dummy)
                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Select Alias.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbselectarea( "] + alias() + [" )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end
            end
        case nMnuChoice == 2
            dummy := dbiStructure()
            if valtype(dummy) == "C"
                text( dummy )
            end
        case nMnuChoice == 3
            dbclosearea()
            // Macro Recorder.
            if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [// Close the active work area.]
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [dbclosearea()] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            end
        case nMnuChoice == 4
            dbcloseall()
            // Macro Recorder.
            if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [// Close all work areas.] +;
                    NL(1) +;
                    [// dbcloseall()]
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [dbclose()] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            end
        end

        setkey( K_F1, bSaveF1 )

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupIndex(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 5    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local dummy

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say padc( _KEY_MENU_P, maxcol()+1 )
        n := 0

        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_INDEX_REINDEX_CHOICE;
            message MNU_MENU_FILE_INDEX_REINDEX_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_INDEX_SET_ORDER_CHOICE;
            message MNU_MENU_FILE_INDEX_SET_ORDER_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_INDEX_CLOSENTX_CHOICE;
            message MNU_MENU_FILE_INDEX_CLOSENTX_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case nMnuChoice == 1
            idbReindex()
        case nMnuChoice == 2
            dummy := selectOrder()
            if valtype( dummy ) == "N"
                ordsetfocus( dummy )

                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// ordSetFocus.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    if dummy == 0
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordsetfocus( 0 )]
                    else
                        Memvar->_MEMVAR_MACRO_RECORDER +=;
                            [ordsetfocus( "] + ordname( dummy ) + [" )]
                    end
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            end
        case nMnuChoice == 3
            idbClearIndex()
        end

        setkey( K_F1, bSaveF1 )

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupRelation(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 4    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local dummy

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say padc( _KEY_MENU_P, maxcol()+1 )
        n := 0

        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_RELATION_SET_CHOICE;
            message MNU_MENU_FILE_RELATION_SET_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_RELATION_CLOSE_CHOICE;
            message MNU_MENU_FILE_RELATION_CLOSE_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case nMnuChoice == 1
            idbRelation()
        case nMnuChoice == 2
            dbclearrelation()

            // Macro Recorder.
            if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [// Clear active relation.]
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [dbclearrelation()] 
                Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
            end

        end

        setkey( K_F1, bSaveF1 )

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnupRDD(nTB,nLB)


    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nMenuHeight       := 4    // menu lines +2
    local nBB                       // bottom border
    local nRB                       // right border
    local n

    local dummy

    local nMnuChoice := 0

    local bSaveF1

    local lRetBreak := .F.

    if (nTB + nMenuHeight -1) > maxrow()
        nBB := maxrow()
        nTB := maxrow() - nMenuHeight +1
    else
        nBB := nTB + nMenuHeight -1
    end
    if (nLB + _MENU_TENDINA_WIDTH -1) > maxcol()
        nLB := nLB - 2*_MENU_TENDINA_WIDTH +1
    end
    nRB := nLB + _MENU_TENDINA_WIDTH -1

    begin sequence

        setcolor( COLOR_DEFAULT1 )
        dispbox( nTB,nLB, nBB,nRB )
        @maxrow(),00 say padc( _KEY_MENU_P, maxcol()+1 )
        n := 0

        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_RDD_SHOW_CHOICE;
            message MNU_MENU_FILE_RDD_SHOW_MSG
        @nTB+(++n),nLB+1;
            prompt MNU_MENU_FILE_RDD_SET_DEFAULT_CHOICE;
            message MNU_MENU_FILE_RDD_SET_DEFAULT_MSG
        menu to nMnuChoice

        bSaveF1 := setkey( K_F1, NIL )

        do case
        case nMnuChoice == 1
            alert( rddsetdefault() )
        case nMnuChoice == 2
            dummy := selectRdd()
            if valtype(dummy) == "C"
                rddsetdefault( dummy )

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Change the current default RDD.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [rddsetdefault( "] + dummy + [" )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end
                
            end
        end

        setkey( K_F1, bSaveF1 )	

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvEdit( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +8       // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_VIEW_CHOICE;
                message MNU_MENU_EDIT_VIEW_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_BROWSE_CHOICE;
                message MNU_MENU_EDIT_BROWSE_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_REPLACE_CHOICE;
                message MNU_MENU_EDIT_REPLACE_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_RECALL_CHOICE;
                message MNU_MENU_EDIT_RECALL_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_DELETE_CHOICE;
                message MNU_MENU_EDIT_DELETE_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_EDIT_PACK_CHOICE;
                message MNU_MENU_EDIT_PACK_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                tb(,,,,,,,,,,,, .f.,,,)

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// View the active Alias.] +;
                        NL(1) +;
                        [// This is not a CA-Clipper ] +;
                        [standard function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [tb(,,,,,,,,,,,, .f.,,,)]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end
                
            case nMnuChoice == 2
                tb()

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Edit the active Alias.] +;
                        NL(1) +;
                        [// This is not a CA-Clipper ] +;
                        [standard function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [tb()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            case nMnuChoice == 3
                idbReplace()
            case nMnuChoice == 4
                idbRecall()
            case nMnuChoice == 5
                idbDelete()
            case nMnuChoice == 6
                idbPack()
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvReport( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +12      // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_DBGOTOP_CHOICE;
                message MNU_MENU_REPORT_DBGOTOP_MSG
            @nTB+(++n),nLB+1;
                say    replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_LABEL_NEW_CHOICE;
                message MNU_MENU_REPORT_LABEL_NEW_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_LABEL_MODIFY_CHOICE;
                message MNU_MENU_REPORT_LABEL_MODIFY_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_LABEL_FORM_CHOICE;
                message MNU_MENU_REPORT_LABEL_FORM_MSG
            @nTB+(++n),nLB+1;
                say    replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_REPORT_NEW_CHOICE;
                message MNU_MENU_REPORT_REPORT_NEW_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_REPORT_MODIFY_CHOICE;
                message MNU_MENU_REPORT_REPORT_MODIFY_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_REPORT_FORM_CHOICE;
                message MNU_MENU_REPORT_REPORT_FORM_MSG
            @nTB+(++n),nLB+1;
                say    replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_REPORT_DOCUMENT_NEW_CHOICE;
                message MNU_MENU_REPORT_DOCUMENT_NEW_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                dbgotop()

                // Macro Recorder.
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Go Top Record.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [dbgotop()]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

            case nMnuChoice == 2
                lbl()
            case nMnuChoice == 3
                lblModify()
            case nMnuChoice == 4
                lblPrint()
            case nMnuChoice == 5
                frm()
            case nMnuChoice == 6
                frmModify()
            case nMnuChoice == 7
                frmPrint()
            case nMnuChoice == 8
                doc()
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvHtf( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +3       // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_HTF_GENERATE_CHOICE;
                message MNU_MENU_HTF_GENERATE_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_HTF_BROWSE_CHOICE;
                message MNU_MENU_HTF_BROWSE_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                htfGenDialog()
            case nMnuChoice == 2
                htfOpen()
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvMacro( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )
    local nOldSelect

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +10      // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0

            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_START_STOP_CHOICE;
                message MNU_MENU_MACRO_START_STOP_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_SAVE_RECORD_CHOICE;
                message MNU_MENU_MACRO_SAVE_RECORD_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_DELETE_RECORD_CHOICE;
                message MNU_MENU_MACRO_DELETE_RECORD_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_EDIT_RECORD_CHOICE;
                message MNU_MENU_MACRO_EDIT_RECORD_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_COMPILE_CHOICE;
                message MNU_MENU_MACRO_COMPILE_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_MACRO_LOAD_CHOICE;
                message MNU_MENU_MACRO_LOAD_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                do case
                case isMemvar( _MEMVAR_MACRO_RECORDING_NAME );
                    .and. isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                        // recording in on
                    // Pause recording
                    release _MEMVAR_MACRO_RECORDING
                case isMemvar( _MEMVAR_MACRO_RECORDING_NAME );
                    .and. !isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                        // it is an error
                    // Correct error.
                    release _MEMVAR_MACRO_RECORDING
                case !isMemvar( _MEMVAR_MACRO_RECORDING_NAME );
                    .and. isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                        // recording is paused
                    // Restart recording.
                    public _MEMVAR_MACRO_RECORDING
                    memvar->_MEMVAR_MACRO_RECORDING := .T.
                case  !isMemvar( _MEMVAR_MACRO_RECORDING_NAME );
                    .and. !isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                        // recording is stopped
                    // Start recording.
                    public _MEMVAR_MACRO_RECORDING
                    memvar->_MEMVAR_MACRO_RECORDING := .T.
                    public _MEMVAR_MACRO_RECORDER
                    memvar->_MEMVAR_MACRO_RECORDER := ""
                end
            case nMnuChoice == 2
                if isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                    macroSave()
                end    
            case nMnuChoice == 3
                if alert(;
                    MACRO_ALERT_ERASE,;
                    {;
                        _MENU_NO,;
                        _MENU_YES;
                        };
                    ) == 2
                    //
                    // Erase recording OK.
                    if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                        release _MEMVAR_MACRO_RECORDING
                    end    
                    if isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                        release _MEMVAR_MACRO_RECORDER
                    end
                else
                    // Do not erase recording.
                end
            case nMnuChoice == 4
                if isMemvar( _MEMVAR_MACRO_RECORDER_NAME )
                    macroEdit()
                end
            case nMnuChoice == 5
                macroCompile()
            case nMnuChoice == 6
                macroLoad()
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvInfo( nHLeft, nHRight )

    local cOldScreen        := savescreen()
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )
    local nOldSelect

    local nTB               := 2            // top border
    local nLB               :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                            // left border
    local nBB               := nTB +8       // bottom border
    local nRB               :=;
        nLB +_MENU_TENDINA_WIDTH -1         // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_ABOUT_CHOICE;
                message MNU_MENU_INFO_ABOUT_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_MANUAL_CHOICE;
                message MNU_MENU_INFO_MANUAL_MSG
            @nTB+(++n),nLB+1;
                say    replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_F1_CHOICE
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_F3_CHOICE
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_F5_CHOICE
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_INFO_F8_CHOICE
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case nMnuChoice == 0  // ESC
                exit
            case nMnuChoice == 1
                // Waitfor() is used as new lines 
                // are made with CL+LF.
                WaitFor( PROGRAM_COPYRIGHT_INFO )
                inkey(0)
                WaitFor()
            case nMnuChoice == 2
                htfOpen( "NB.HLP" )
            case nMnuChoice == 3
                Text( _MENU_HELP )
            case nMnuChoice == 4
                Text( dbiStatus() )
            case nMnuChoice == 5
                setAlternate()
            case nMnuChoice == 6
                dotLine()
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

//----------------------------------------------------------------
static function mnuvDoc( nHLeft, nHRight )

    local cOldScreen          := savescreen()
    local lOldSetWrap         := set(_SET_WRAP, .T.)
    local nOldSetMessage      := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter       := set(_SET_MCENTER, .T.)
    local bOld_F1             :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )

    local nTB                 := 2      // top border
    local nLB                 :=;
        iif( nHLeft+_MENU_TENDINA_WIDTH > maxcol(),;
        nHRight - _MENU_TENDINA_WIDTH,;
        nHLeft )                        // left border
    local nBB                 := nTB +13       // bottom border
    local nRB                 :=;
        nLB +_MENU_TENDINA_WIDTH -1            // right border
    local n

    local cSaveScreen
    local bSaveF1

    local nMnuChoice := 0

    local lRetBreak := .F.

    begin sequence

        while .T.  // do until Esc
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            dispbox( nTB,nLB, nBB,nRB )
            @maxrow(),00 say padc( _KEY_MENU_V, maxcol()+1 )
            n := 0
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_NEW_CHOICE;
                message MNU_MENU_DOC_NEW_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_OPEN_CHOICE;
                message MNU_MENU_DOC_OPEN_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_SAVE_CHOICE;
                message MNU_MENU_DOC_SAVE_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_SAVE_AS_CHOICE;
                message MNU_MENU_DOC_SAVE_AS_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_SET_DEFAULT_TO_CHOICE;
                message MNU_MENU_DOC_SET_DEFAULT_TO_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_PRINT_AS_IS_CHOICE;
                message MNU_MENU_DOC_PRINT_AS_IS_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_PRINT_ONCE_CHOICE;
                message MNU_MENU_DOC_PRINT_ONCE_MSG
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_PRINT_CHOICE;
                message MNU_MENU_DOC_PRINT_MSG
            @nTB+(++n),nLB+1;
                say replicate("", _MENU_TENDINA_WIDTH-2)
            @nTB+(++n),nLB+1;
                prompt MNU_MENU_DOC_EXIT_CHOICE;
                message MNU_MENU_DOC_EXIT_MSG
            menu to nMnuChoice

            // Extra security screen save.
            cSaveScreen := savescreen()

            // Arrow keys are released.
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

            setcolor( COLOR_DEFAULT0 )

            bSaveF1 := setkey( K_F1, NIL )

            do case
            case (nMnuChoice == 0)
                lRetBreak := .F.
                exit
            case (nMnuChoice == 1)
                lRetBreak := .T.
                docNew()
                exit
            case (nMnuChoice == 2)
                lRetBreak := .T.
                docOpen()
                exit
            case (nMnuChoice == 3)
                lRetBreak := .T.
                docSave()
                exit
            case (nMnuChoice == 4)
                lRetBreak := .T.
                docSaveAs()
                exit
            case (nMnuChoice == 5)
                setAlternate()
            case (nMnuChoice == 6)
                lRetBreak := .T.
                if isConsoleOn()
                    setcolor( COLOR_DEFAULT2 )
                    scroll()
                end
                QOut( docArray[DOC_TEXT] )
                if isConsoleOn()
                    // Wait for a key press.
                    inkey(0)
                    scroll()
                end
                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Print text.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// qout( <text> )"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [qout( memoread( "] +;
                        docArray[DOC_NAME] +;
                        [" ) )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

                exit
            case (nMnuChoice == 7)
                lRetBreak := .T.
                if isConsoleOn()
                    setcolor( COLOR_DEFAULT2 )
                    scroll()
                end
                rpt( docArray[DOC_TEXT] )
                if isConsoleOn()
                    // Wait for a key press.
                    inkey(0)
                    scroll()
                end
                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Print Text once with the active Alias.] +;
                        NL(1) +;
                        [// This is not a CA-Clipper standard ] +;
                        [function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// rpt( <cText> )"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [rpt( memoread("] +;
                        docArray[DOC_NAME] +;
                        [") )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

                exit
            case (nMnuChoice == 8)
                lRetBreak := .T.
                if isConsoleOn()
                    setcolor( COLOR_DEFAULT2 )
                    scroll()
                end
                docPrintCondition( docArray[DOC_TEXT] )
                if isConsoleOn()
                    // Wait for a key press.
                    inkey(0)
                    scroll()
                end

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [// Print Text with the active Alias.] +;
                        NL(1) +;
                        [// This is not a CA-Clipper standard ] +;
                        [function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        "// rptMany( <cText> )"
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [rptMany( memoread("] +;
                        docArray[DOC_NAME] +;
                        [") )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end

                exit
            case (nMnuChoice == 9)
                lRetBreak := .T.
                docArray[DOC_EXIT] := .T.
                exit
            end

            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            // Screen restore.
            restscreen(,,,,cSaveScreen)

            setkey( K_F1, bSaveF1 )

        end

    end sequence

    // Restore
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setkey( K_F1, bOld_F1 )

    return lRetBreak

#endif
//----------------------------------------------------------------
// SELECT - SELECTION LIST
//----------------------------------------------------------------
static function selectAlias()
//
// selectAlias()    --> cAlias
//                  --> ""
//

    local nSelect

    nSelect := selectArray()[1]

    if nSelect <> NIL;
        .and. nSelect <> 0
        return alias(nSelect)
    end

    return ""

//----------------------------------------------------------------
static function selectArray()
//
// selectChoice()  --> aSelect
//                 --> NIL
// selectChoice()[1] == Area number
// selectChoice()[2] == Alias
// selectChoice()[3] == Ordsetfocus
// selectChoice()[4] == OrdKey
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldSelect          := select()
    local bOld_F1             :=;
        setkey( K_F1, { || Text(SELECT_HELP_SELECT) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local aSelect             := {}
    local aSelectEasy         := {}
    local nI                  := 0
    local aSelected           :=;
        { NIL, NIL, NIL, NIL }

    begin sequence

        // Reed the Aliases and add the "new area" as numnber 0
        // as the first on the list.
        aadd( aSelect, { 0, SELECT_MESSAGE_NEW_AREA, "", "" } )
        for nI := 1 to _MAX_SELECT
            if alias(nI) == "" // the <> cannot be used to test
                               // empty strings.
                // nil
            else
                aadd( aSelect,;
                    { nI, alias(nI),;
                    (alias(nI))->(ordsetfocus()),;
                    (alias(nI))->(ordkey(ordsetfocus()))  } )
            end
        next

        // travasa il vettore
        for nI := 1 to len( aSelect )
            aadd( aSelectEasy, str( aSelect[nI,1], 3 ) + " " +;
                padr( aSelect[nI,2], 10 ) + " " +;
                aSelect[nI,3] + " " +;
                aSelect[nI,4] )
        next

        // Create a kind of window.
        nTop    := 0
        nLeft   := maxcol()-50
        // It is a big window as it must contain also the index
        // information when an index is associated.
        nBottom := maxrow()
        nRight  := maxcol()
        nWidth   := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        dispbox( nTop, nLeft, nBottom, nLeft, B_DOUBLE )
        dispbox( nTop, nRight, nBottom, nRight, B_DOUBLE )

        setcolor( COLOR_DEFAULT1 )
        @nTop,nLeft+1 say;
            padc( SELECT_WINDOW_TOP_SELECT, nWidth-2 )
        @nBottom-1,nLeft+1;
            say padc( _KEY_ESC_CANCEL_F1, nWidth-2 )
        @nBottom,nLeft+1;
            say padc( _KEY_UP_DOWN_ENTER, nWidth-2 )
        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft+1, nBottom-2, nRight-1 )
        nI := achoice ( nTop+1, nLeft+1, nBottom-2, nRight-1,;
            aSelectEasy )

        if nI <> 0
            aSelected := aSelect[nI]
        end

    end sequence

    // restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return aSelected

//----------------------------------------------------------------
static function selectOrder()
//
// selectOrder() --> nOrder
//                --> NIL
//
// It returns the order number selectable form the order list.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NONE )
    local bOld_F1             :=;
        setkey( K_F1, { || Text(SELECT_HELP_ORDER) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local aOrder              := {}
    local aOrderEasy          := {}
    local nI                  := 0

    begin sequence

        if alias() == ""  // there is no active Alias
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Read the indexes including Zero as the natural order
        aadd( aOrder, { 0, SELECT_MESSAGE_NATURAL_ORDER, "" } )
        for nI := 1 to _MAX_ORDER
            if ordkey(nI) == "" // <> can't be used.
                // nil
            else
                aadd( aOrder, { nI, ordname(nI), ordkey(nI) } )
            end
        next

        // Array transfer
        for nI := 1 to len( aOrder )
            aadd( aOrderEasy, str( aOrder[nI,1], 3 ) + " " +;
                aOrder[nI,2] + " " +;
                aOrder[nI,3] )
        next

        // Create a kind of window.
        nBottom     := maxrow()
        nRight      := maxcol()
        nTop        := 0
        nLeft       := nRight - 40
        nWidth      := nRight - nLeft +1
        cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
        @nTop,nLeft to nBottom,nLeft double
        @nTop,nRight to nBottom,nRight double
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft+1, nTop, nRight-1 )
        scroll( nBottom, nLeft+1, nBottom, nRight-1 )
        setpos( nTop, nLeft+1 )
        dispout( padc( SELECT_WINDOW_TOP_ORDER, nWidth-2 ) )
        @nBottom-1,nLeft+1;
            say padc( _KEY_ESC_CANCEL_F1, nWidth-2 )
        @nBottom,nLeft+1;
            say padc( _KEY_UP_DOWN_ENTER, nWidth-2 )
        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft+1, nBottom-2, nRight-1 )
        nI := achoice ( nTop+1, nLeft+1, nBottom-2, nRight-1,;
            aOrderEasy )

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    if nI <> 0
        return aOrder[nI,1]
    end

    // If [Esc] was pressed
    return NIL

//----------------------------------------------------------------
static function selectRdd()
//
// selectRDD() --> cRDD
//             --> NIL
//
// It returns a RDD name from the available ones.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NONE )
    local bOld_F1             :=;
        setkey( K_F1, { || Text(SELECT_HELP_RDD) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local aRDD := {}
    local aRDDX := {}
    local nI := 0

    begin sequence

        aRDD := rddlist( RDT_FULL )

        // Delete the driver names that do not contains index
        nI := 1
        for nI = 1 to len( aRDD )
            if right( aRDD[nI], 1 ) == "X"  // driver with index
                aadd( aRDDX, aRDD[nI] )
            end
        next

        // Create a kind of window.
        nBottom     := maxrow()
        nRight      := maxcol()
        nTop        := 0
        nLeft       := nRight - 30
        nWidth      := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        @nTop,nLeft to nBottom,nLeft double
        @nTop,nRight to nBottom,nRight double
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft+1, nTop, nRight-1 )
        scroll( nBottom, nLeft+1, nBottom, nRight-1 )
        setpos( nTop, nLeft+1 )
        dispout( padc( SELECT_WINDOW_TOP_RDD, nWidth-2 ) )
        @nBottom-1,nLeft+1;
            say padc( _KEY_ESC_CANCEL_F1, nWidth-2 )
        @nBottom,nLeft+1;
            say padc( _KEY_UP_DOWN_ENTER, nWidth-2 )
        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft+1, nBottom-2, nRight-1 )
        nI := achoice ( nTop+1, nLeft+1, nBottom-2, nRight-1,;
            aRDDX )

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    if nI <> 0
        return aRDDX[nI]
    end

    // if nI == 0, [Esc]
    return NIL

//----------------------------------------------------------------
// SET - SET FUNCTIONS
//----------------------------------------------------------------
static function setAlternate()
//&
//

    local getlist               := {}
    local bOldErrorHandler
    local cOldScreen            := ""
    local cOldColor             := setcolor()
    local nOldCursor            := setcursor( SC_NORMAL )
    local bOld_F1               :=;
        setkey( K_F1, {|| Text( SET_HELP_ALTERNATE_FILE ) } )
    local bOld_F2               := setkey( K_F2, NIL )
    local nOldRow               := row()
    local nOldCol               := col()
    local nTop                  := 0
    local nLeft                 := 0
    local nBottom               := 0
    local nRight                := 0
    local nWidth                := 0

    local cAltFile              := ;
        padr( set( _SET_ALTFILE ), SPACE_LEN )

    begin sequence

        // Create a kind of window.
        nBottom     := maxrow()
        nTop        := nBottom - 3
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( SET_DIALOG_BOX_TOP_ALTERNATE_FILE,;
            nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_NORMAL_F1_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-1, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say SET_PROMPT_ALTERNATE_FILE
            @row()+1,nLeft;
                get cAltFile;
                picture "@s"+ltrim(str(maxcol()+1))+"@";
                when trueSetkey( K_F2, NIL );
                valid ( .t. )
            read

            do case
            case lastkey() = K_ESC  // exit
                exit
            case lastkey() = K_PGDN // ok
                setOutput( alltrim( cAltFile ) )

                // Macro recorder
                if isMemvar( _MEMVAR_MACRO_RECORDING_NAME )
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                    [// Set Output for qout() and qqout()] +;
                    NL(1) +;
                    [// This is not a CA-Clipper standard ] +;
                    [function.]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                    Memvar->_MEMVAR_MACRO_RECORDER +=;
                        [setOutput( "] +;
                        alltrim( cAltFile ) +;
                        [" )]
                    Memvar->_MEMVAR_MACRO_RECORDER += NL(1)
                end
                exit
            otherwise
               // loop
            end
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
// STATUS - STATUS LINE
//----------------------------------------------------------------
static function statusLine()
//
// statusLine() --> NIL
//
// It shows a status line on the first line of the screen.
//
    local getlist             := {}
    local bOldErrorHandler
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local lOldSetBlink        := setblink()
    local nOldCursor          := setcursor( SC_NONE )
    local nOldRow             := row()
    local nOldCol             := col()

    // Clear the first line on the screen;
    // this line will be used as "status line".
    //scroll( 0, 0, 0, maxrow() )

    // The status line cleans the space automatically.
    setpos(0,0)
    @row(),col() say ""
    setblink( .T. )
    if isMemvar(_MEMVAR_MACRO_RECORDER_NAME)
        // The macro exists.
        if isMemvar(_MEMVAR_MACRO_RECORDING_NAME)
            // The recorder is active.
            @row(),col();
                say "&";
                color "*" + setcolor()
        else
            // The recorder is paused.
            @row(),col();
                say "&"
        end
    else
    // The memvar macro is not present.
    @row(),col();
        say " "
    end
    setblink( lOldSetBlink )
    @row(),col() say ""
    @row(),col() say padr(rddsetdefault(), 10)
    @row(),col() say ""
    @row(),col() say iif( set( _SET_DELETED ), " ", "*" )
    @row(),col() say ""
    @row(),col() say str(select(), 3)
    @row(),col() say ""
    @row(),col() say padr( alias(), 10 )
    @row(),col() say ""
    @row(),col();
        say iif( eof(), " End Of File ",;
            iif( bof(), "Begin Of File",;
            str( recno(), 6 ) + "/" + str( reccount(), 6 ) ) )
    @row(),col() say ""
    @row(),col();
        say padr( iif( alias() == "", "",;
            strFile(ordbagname(ordsetfocus())) ), 12 )
    @row(),col() say ""
    @row(),col();
        say iif( alias() == "", "  0",;
            str( ordnumber( ordsetfocus() ), 3 ) )
    @row(),col() say ""
    @row(),col();
        say padr( iif( alias() == "", "", ordsetfocus() ), 10 )
    @row(),col() say ""
    scroll( row(),col(),row(),maxcol() )

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    setpos( nOldRow, nOldCol )

    return NIL

//----------------------------------------------------------------
// TGL - TOGGLE
//----------------------------------------------------------------
static function tglInsert()
//
// TglInsert() -->  NIL
//
// Toggle the global insert mode and the cursor shape.
//
//
    if readinsert()
        readinsert(FALSE)
        setcursor(SC_NORMAL)
    else
        readinsert(TRUE)
        setcursor(SC_INSERT)
    end

    return NIL

//----------------------------------------------------------------
// TRUE - RETURNING EVER .T.
//----------------------------------------------------------------
static function true( p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
//
// true( , , , , , , , , , ) --> true
//
// It does nothing, it returns true.
//

    return .t.

//----------------------------------------------------------------
static function trueSetKey( nInkeyCode, bAction )
//
// trueSetKey( <nInkeyKode>, [<bAction>] ) --> true
//
// Just like SetKey() but returns ever true (.t.) and not the
// previous bAction.
//

    return true( setkey( nInkeyCode, bAction ) )

//================================================================
//================================================================
// ACCEPT - PROMPT FUNCTIONS
//================================================================
function Accept( Field, cMessage, cHeader )
//
// Accept( <Field>, [<cMessage>], [<cHeader>] ) --> Field|NIL
//
// <Field>      the variable to be edited and returned.
//
// <cMessage>   the message to show.
//
// <cHeader>    the header to show at the top window.
//
// The function shows <cMessage> and waits for input to place
// into <Field>.
//

    local getlist             := {}
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0
    local nLines
    local nLine
    local ReturnField         := NIL

    default cMessage to ""
    default cHeader  to "Accept/Input"

    begin sequence

        if Field == NIL
            break
        end

        if valtype( cMessage ) <> "C"
            cMessage := NIL
        end

        // Calculate field dimention.
        nWidth := maxcol()+1

        // Message line count.
        cMessage := alltrim(cMessage)
        nLines := mlcount( cMessage, nWidth )

        // Calculate window.
        nBottom     := maxrow()
        nTop        := nBottom - ( nLines+1+1 )
        nLeft       := 0
        nRight      := maxcol()

        // Save window area.
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )

        // Create window.
        setcolor( COLOR_DEFAULT1 )
        scroll( nTop, nLeft, nTop, nRight )
        scroll( nBottom, nLeft, nBottom, nRight )
        setpos( nTop, nLeft )
        dispout( padc( cHeader, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_PGDN, nWidth ) )

        setcolor( COLOR_DEFAULT2 )
        scroll( nTop+1, nLeft, nBottom-1, nRight )

        nLine := 1
        while nLine <= nLines
            setpos( nTop+nLine, nLeft )
            dispout( memoline(cMessage, nWidth, nLine ) )
            nLine++
        end

        do case
        case valtype( Field ) == "C"
            setpos( nTop+nLines+1, nLeft )
            @row(),col();
                get Field;
                picture "@s"+ltrim(str(nWidth))+"@"
        case valtype( Field ) == "N"
            setpos( nTop+nLines+1, nLeft )
            @row(),col() get Field
        case valtype( Field ) == "D"
            setpos( nTop+nLines+1, nLeft )
            @row(),col() get Field
        otherwise
            setpos( nTop+nLines+1, nLeft )
            @row(),col() get Field
        end

        readmodal( getlist )
        getlist := {}

        do case
        case lastkey() = K_ESC
            ReturnField := NIL
        otherwise
            ReturnField := Field
        end

    end sequence

    // Restore.
    setcolor( cOldColor )
    setcursor( nOldCursor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )

    return ReturnField

//================================================================
// DIR - SELECT DRIVE / DIRECTORY / FILE
//================================================================
function dir( cFileSpec, lDrives, lDirs, lFiles,;
    lNoDirReturn, nSortColumn )
//
// dir( [<cFileSpec>], [<lDrives>], [<lDirs>], [<lFiles>],
//      [<cBottomMessage>], [<nSortColumn>] ) --> cPathname
//
// <cFileSpec>      Filename, Pathname, also with wildcards.
//
// <lDrives>        true (.t.) means: include drives letters.
//
// <lDirs>          true (.t.) means: include directory names.
//
// <lFiles>         true (.t.) means: include file names.
//
// <lNoRirReturn>   true (.t.) means: do not return the
//                  shown directory if [Esc] is used to exit.
//
// <nSortColumn>        the column number to use to sort the
//                      list.
//                      The columns are:
//                      F_NAME = 1,
//                      F_SIZE = 2,
//                      F_DATE = 3,
//                      F_TIME = 4,
//                      F_ATTR = 5.
//                      It is not possible to sort for extention.
//

    local cOldScreen    := ""
    local cOldColor     := setcolor()
    local nOldCursor    := setcursor( SC_NONE )
    local nOldRow       := row()
    local nOldCol       := col()
    local bOld_F1       :=;
        setkey( K_F1, {|| Text( DIR_HELP ) } )
    local bOld_F2       := setkey( K_F2, NIL )
    local nTop          := 0
    local nLeft         := 0
    local nBottom       := 0
    local nRight        := 0
    local nWidth        := 0

    local aDir := {}
    local nI := 0
    local cDrive
    local cPath
    local cWild
    local cFile

    local cOldFileSpec

    local cNewDir
    local cNewDrive

    local cReturn

    default cFileSpec      to "*.*"
    default lDrives        to .t.
    default lDirs          to .t.
    default lFiles         to .t.
    default lNoDirReturn   to .f.
    default nSortColumn    to F_NAME

    cOldFileSpec := cFileSpec

    begin sequence

        // Correct eventual error on nSortColumn
        if nSortColumn > F_ATTR
            nSortColumn := F_NAME
        end

        // Name division
        cDrive := strDrive( cFileSpec )
        cPath  := strPath( cFileSpec )
        cFile  := strFile( cFileSpec )

        do case
        case cDrive == "" .and.;
            cPath == "" .and.;
            curdir() == ""
            //
            cPath := "\"
        case cDrive == "" .and.;
            cPath == "" .and.;
            !empty( curdir() )
            //
            cPath := "\" + curdir() + "\"
        case cDrive == "" .and.;
            !empty( cPath )
            // ok, do nothing
        case !empty( cDrive ) .and.;
            cPath == "" .and.;
            curdir( cDrive ) == ""
            //
            cPath := "\"
        case !empty( cDrive ) .and.;
            cPath == "" .and.;
            curdir( cDrive ) <> ""
            //
            cPath := "\" + curdir( cDrive ) + "\"
        case !empty( cDrive ) .and.;
            !empty( cPath )
            // ok, do nothing
        end

        cWild  := StrFile( cFileSpec )

        // read the directory
        aDir := dirArray( cDrive+cPath+cWild,;
            lDrives, lDirs, lFiles, lNoDirReturn, nSortColumn )

        // Create a kind of window.
        nTop    := 0
        nLeft   := maxcol()-46
        nBottom := maxrow()
        nRight  := maxcol()
        nWidth   := nRight - nLeft +1
        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )
        dispbox( nTop, nLeft, nBottom, nLeft, B_DOUBLE )
        dispbox( nTop, nRight, nBottom, nRight, B_DOUBLE )

        while .t.

            setcolor( COLOR_DEFAULT1 )
            @nTop,nLeft+1;
                say padc( cDrive+cPath+cWild, nWidth-2 )
            @nBottom-1,nLeft+1;
                say padc( _KEY_ESC_EXIT_F1, nWidth-2 )
            @nBottom,nLeft+1;
                say padc( _KEY_UP_DOWN_ENTER, nWidth-2 )

            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft+1, nBottom-2, nRight-1 )
            nI := achoice( nTop+1, nLeft+1,;
                nBottom-2, nRight-1, aDir )

            do case

            // [Esc] pressed
            case nI == 0  // [Esc]
                // Abandon: the original is returned.
                cReturn := cOldFileSpec
                exit

            // Directory
            case left( aDir[nI], 3 ) == "[.]"
                // Return current directory.
                cReturn := cDrive+cPath
                exit
            
            case left( aDir[nI], 1 ) == "["
                // Note that the at() function cannot work on "["
                // parentesis !!!
                //
                cNewDir := left( aDir[nI], 15 )   // "[EXAMPLE.XX]"
                cNewDir := alltrim( cNewDir )     // "[EXAMPLE.XX]"
                cNewDir := substr( cNewDir, 2 )   // "EXAMPLE.XX]
                cNewDir := substr( cNewDir, 1, len( cNewDir ) -1 );
                    // "EXAMPLE.XX"
                do case
                case cNewDir == "."
                    // don't move
                case cNewDir == ".."
                    // go back
                    cPath := strParent( cPath )
                    aDir := dirArray( cDrive+cPath+cWild,;
                        lDrives, lDirs, lFiles, lNoDirReturn, nSortColumn )
                otherwise
                    cPath := cPath+cNewDir+"\"
                    aDir := dirArray( cDrive+cPath+cWild,;
                        lDrives, lDirs, lFiles, lNoDirReturn, nSortColumn )
                end

            // Drive
            case aDir[nI] == DIR_SAY_DRIVE + space( 60 )
                cNewDrive := dirDriveGet()
                if cNewDrive <> NIL
                    cDrive := cNewDrive+":"
                    if curdir(cDrive) == ""
                        cPath := "\"
                    else
                        cPath := "\" + curdir(cDrive) + "\"
                    end
                    aDir := dirArray( cDrive+cPath+cWild,;
                        lDrives, lDirs, lFiles, lNoDirReturn, nSortColumn )
                end

            otherwise
                cFile := left( aDir[nI], 16 )
                cFile := alltrim( cFile )
                cReturn := cDrive+cPath+cFile
                exit
            end
        end

    end sequence

    // restore
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )

    return cReturn

//----------------------------------------------------------------
static function dirArray( cFileSpec, lDrives, lDirs, lFiles,;
    lNoDirReturn, nSortColumn )

    local aDirectory
    local aDir := {}
    local nI := 0

    local cDrive := strDrive( cFileSpec )
    local cPath  := strPath( cFileSpec )

    if len( cPath ) > 0 .and.;
       right( cPath, 1 ) <> "\"
        cPath := cPath + "\"
    end

    WaitFor( DIR_WAIT_READING_DIRECTORY )

    // Drives
    if lDrives
        aadd( aDir, DIR_SAY_DRIVE + space( 60 ) )
    end

    // Directories
    if lDirs
        aDirectory :=;
            asort( directory( cDrive+cPath+"*.*", "D" ), NIL, NIL,;
            { |x, y| x[nSortColumn] < y[nSortColumn] } )

        for nI := 1 to len( aDirectory )
            if aDirectory[nI,F_ATTR] <> "D"
                loop
            end
            if aDirectory[nI, F_NAME] == "."
                if !lNoDirReturn
                    // Current directory will mean return directory.
                    aadd( adir, "[.] " + cFileSpec + space(60) )
                end
            else
                aadd( adir, left( "[" + aDirectory[nI, F_NAME] + "]" +;
                    space(20), 15) +;
                    str(aDirectory[nI,F_SIZE], 10, 0) + " " +;
                    dtoc(aDirectory[nI,F_DATE]) + " " +;
                    aDirectory[nI,F_TIME] + " " +;
                    aDirectory[nI,F_ATTR]  )
            end
        next
    end

    // Files
    if lFiles
        aDirectory := asort( directory( cFileSpec, "" ), NIL, NIL,;
                    { |x, y| x[nSortColumn] < y[nSortColumn] } )
        for nI := 1 to len( aDirectory )
            aadd( aDir, left( aDirectory[nI,F_NAME] +;
                space(20), 15)  +;
                str(aDirectory[nI,F_SIZE],10,0) + " " +;
                dtoc(aDirectory[nI,F_DATE]) + " " +;
                aDirectory[nI,F_TIME] + " " +;
                aDirectory[nI,F_ATTR] )
        next
    end

    WaitFor( NIL )

    return aDir

//----------------------------------------------------------------
static function dirArrayDrives()

    local aLogicalDisks := {}
    local nChar

    // chr(65) == "A"; chr(90) == "Z"
    for nChar := 65 to 90
         aadd( aLogicalDisks, chr( nChar ) )
    next

    return aLogicalDisks

//----------------------------------------------------------------
static function dirDriveGet()

    local GetList   := {}

    local cNewDrive := space(1)
    local nRow      := row()
    local nCol      := maxcol() -45

    local nOldCursor := setcursor( SC_NORMAL )
    
    @nRow,nCol say space(45)
    @nRow,nCol say DIR_GET_NEW_DRIVE
    @nRow,col()+1;
        get cNewDrive;
        picture "!"

    read

    do case
    case lastkey() = K_ESC  // exit
        cNewDrive := NIL
    case cNewDrive >= chr(65) .and. cNewDrive <= chr(90)
        // Ok.
    otherwise
        // Nil.
        cNewDrive := NIL
    end
    
    // Restore.
    setcursor( nOldCursor )

    return cNewDrive

#ifndef RUNTIME
//================================================================
// DOC - TEXT EDITOR
//================================================================
function Doc( cFileName )
//
// Doc( [<cFileName>] ) --> NIL
//
// Text editor for small files, less than 64K.
//
// <cFileName>  the text file name to modify.
//

    local bOldErrorHandler
    local cOldScreen    := savescreen()
    local cOldColor     := setcolor()
    local nOldCursor    := setcursor( SC_NONE )
    local bOld_F1       := setkey( K_F1, NIL )
    local bOld_F2       := setkey( K_F2, NIL )
    // [Alt]+[M] and [F10] must be resetted, otherwise the menu
    // will be the ASSIST()!!
    local bOld_ALT_M    := setkey( K_ALT_M, NIL )
    local bOld_F10      := setkey( K_F10, NIL )

    local nOldRow       := row()
    local nOldCol       := col()

    local cOldName
    local lNew

    begin sequence

        setcursor( SC_NORMAL )
        set(_SET_BELL, .f.)
        set(_SET_SCOREBOARD, .f.)
        setkey( K_F2, {|| keyboard("" + fieldPicture() + "") } )

        if valtype( cFileName ) <> "C"
            cFileName :=;
                strAddExtention( _UNTITLED, _EXTENTION_TEXT )
            cOldName := NIL
            lNew := .T.
        else
            cFileName :=;
                upper( strAddExtention( cFileName,;
                _EXTENTION_TEXT) )
            if file( cFileName )
                cOldName := cFileName
            else
                cOldName := NIL
                lNew := .T.
            end
        end

        // Start the editing
        docEditor( cFileName, cOldName, lNew )

    end sequence

    // restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( NIL, NIL, NIL, NIL, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setkey( K_ALT_M, bOld_ALT_M )
    setkey( K_F10, bOld_F10 )

    return NIL

//----------------------------------------------------------------
static function docEditor( cFile, cOld, lNew )

    local nKey

    setkey( K_F1, { || Text( DOC_HELP ) } )

    // docArray array compilation.
    docArray                := Array(DOC_LENGTH)
    docArray[DOC_NEW]       := lNew
    docArray[DOC_OLD]       := cOld
        // eventually upper and alltrim
    docArray[DOC_NAME]      := cFile
        // eventually upper and alltrim
    do case
    case docArray[DOC_NEW]
        docArray[DOC_TEXT]      := ""
    case file( docArray[DOC_NAME] )
        docArray[DOC_TEXT]      := MemoRead(cFile)
    otherwise
        docArray[DOC_TEXT]      := ""
    end

    docArray[DOC_WRAP]      := .T.
    docArray[DOC_INS]       := Set(_SET_INSERT)

    docArray[DOC_ROW]       := 1
    docArray[DOC_COL]       := 0
    docArray[DOC_RELROW]    := 0
    docArray[DOC_RELCOL]    := 0

    docArray[DOC_CHANGED]   := .F.
    docArray[DOC_LASTKEY]   := 0

    docArray[DOC_EXIT]      := .F.

    // Clear screen.
    scroll()

    setcolor( COLOR_DEFAULT1 )
    scroll( 00,00,00,maxcol() )
    @00,05 say alltrim( cFile )
    scroll( maxrow(),00,maxrow(),maxcol() )
    @maxrow(),00 say padc( _KEY_ESC_EXIT_F1_F10, maxcol()+1 )
    setcolor( COLOR_DEFAULT0 )

    // Editing.
    while (!docArray[DOC_EXIT])

        docDoEditing()
        nKey := docArray[DOC_LASTKEY]

        do case
        case (nKey == K_F10);
            .or. (nKey == K_ALT_M)
            //
            docMenu()
            docInfoLine()
                // to modify the header
        case (nKey == K_ESC)
            docExit()
        otherwise
        end
    end

    // Release data inside the static array.
    docArray := {}

    return NIL

//----------------------------------------------------------------
static function  docDoEditing()

    docArray[DOC_WRAP] := .T.
    docArray[DOC_TEXT] :=;
        memoedit( docArray[DOC_TEXT],;
        DOC_TOP,;
        DOC_LEFT,;
        DOC_BOTTOM,;
        DOC_RIGHT,;
        .t.,;
        "docUDF",;
        DOC_WIDTH,;
        DOC_TABSIZE,;
        docArray[DOC_ROW],;
        docArray[DOC_COL],;
        docArray[DOC_RELROW],;
        docArray[DOC_RELCOL] )

    return NIL

//----------------------------------------------------------------
function docUDF(nMode, nLine, nCol)
//
// This is the UDF function for memoedit().
// The call to docUDF() is made with macro interpretation at
// runtime inside memoedit(). This is the reason why it can't
// be static.
//

    local nKey

    docArray[DOC_LASTKEY]        := nKey := LastKey()
    docArray[DOC_ROW]            := nLine
    docArray[DOC_COL]            := nCol
    docArray[DOC_RELROW]         := Row() - DOC_TOP
    docArray[DOC_RELCOL]         := Col() - DOC_LEFT

    if (nMode == ME_INIT)
        if (docArray[DOC_WRAP])
            // Turn off word wrap.
            docArray[DOC_WRAP] := .f.
            return (ME_TOGGLEWRAP)
        end
        setcursor( if(docArray[DOC_INS], SC_INSERT, SC_NORMAL) )
    elseif (nMode == ME_IDLE)
        // Show information line.
        docInfoLine()
    else
        // Keystroke exception.
        if (nMode == ME_UNKEYX)
            docArray[DOC_CHANGED] := .t.
        end

        do case
        case (nKey == K_F1)
            Text( DOC_HELP )
        case (nKey == K_F10);
            .or. (nKey == K_ALT_M)
            // Call the menu.
            return (K_CTRL_W)
        case (nKey == K_INS)
            // Insert/Overwrite.
            docArray[DOC_INS] := !Set(_SET_INSERT)
            setcursor( if(docArray[DOC_INS], SC_INSERT, SC_NORMAL) )
            docInfoLine()
            return (nKey)
        case (nKey == K_ESC)
            // Esc.
            return (K_CTRL_W)
        otherwise
            // nil
        end
    end

    return 0

//----------------------------------------------------------------
static function docInfoLine()

    local cLine
    local cCol
    local nCtype
    local nRow
    local nCol

    cLine := padl( alltrim( str( docArray[DOC_ROW] ) ), 6, "0" )
    cCol  := padl( alltrim( str( docArray[DOC_COL]+1 ) ), 4, "0" )

    nCtype := SetCursor(0)
    nRow := Row()
    nCol := Col()
    setcolor( COLOR_DEFAULT1 )
    scroll( 00,00,00,maxcol() )
    @00,01 say DOC_FUNCTION_NAME
    @00,col()+5 say alltrim( docArray[DOC_NAME] )
    @00,col()+5 say cLine + ":" + cCol
    @00,col()+5 say iif( docArray[DOC_INS], "INS", "OVR" )
    setcolor( COLOR_DEFAULT0 )

    setpos(nRow, nCol)

    SetCursor(nCtype)

    return NIL

//----------------------------------------------------------------
static function docNew()

    local c
    local nCtype
    local lOkDoit := .F.

    if ( docArray[DOC_CHANGED] )
        nCtype := SetCursor(SC_NORMAL)
        if alert( DOC_PROMPT_ABANDON_CHANGES,;
                   { _MENU_NO, _MENU_YES } ) == 2
            lOkDoit := .T.
        end
        SetCursor(nCtype)
    else
        lOkDoit := .T.
    end

    if lOkDoit
        // nuovo file
        docArray[DOC_OLD]       := NIL
        docArray[DOC_NAME]      := _UNTITLED + "." + _EXTENTION_TEXT
        docArray[DOC_TEXT]      := ""
        docArray[DOC_CHANGED]   := .F.
        docArray[DOC_ROW]       := 1
        docArray[DOC_COL]       := 0
        docArray[DOC_RELROW]    := 0
        docArray[DOC_RELCOL]    := 0
    end

    return NIL

//----------------------------------------------------------------
static function docOpen()

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor( COLOR_DEFAULT0 )
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             := setkey( K_F1, NIL )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local c
    local nCtype
    local lOkDoit             := .F.

    local lGoOn               := .F.
    local cFileName           :=;
        padr( "*." + _EXTENTION_TEXT, SPACE_LEN )

    begin sequence

        if ( docArray[DOC_CHANGED] )
            if alert( DOC_PROMPT_ABANDON_CHANGES,;
                 { _MENU_NO, _MENU_YES } ) == 2
                lOkDoit := .T.
            end
        else
            lOkDoit := .T.
        end

        if lOkDoit
            // Open file.

            // Create a kind of window
            nBottom     := maxrow()
            nTop        := nBottom - 4
            nLeft       := 0
            nRight      := maxcol()
            nWidth      := nRight - nLeft +1
            cOldScreen  :=;
                savescreen( nTop, nLeft, nBottom, nRight )
            setcolor( COLOR_DEFAULT1 )
            scroll( nTop, nLeft, nTop, nRight )
            scroll( nBottom, nLeft, nBottom, nRight )
            setpos( nTop, nLeft )
            dispout( padc( DOC_DIALOG_BOX_TOP_OPEN, nWidth ) )
            setpos( nBottom-1, nLeft )
            dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
            setpos( nBottom, nLeft )
            dispout( padc( _KEY_F2_PGDN, nWidth ) )

            while .t.
                setcolor( COLOR_DEFAULT2 )
                scroll( nTop+1, nLeft, nBottom-2, nRight )
                setpos( nTop, nLeft )
                @row()+1,nLeft;
                    say DOC_PROMPT_OPEN_FILE_DOC
                @row()+1,nLeft;
                    get cFileName;
                    picture "@s"+ ltrim( str( nWidth ) ) +"@" ;
                    when trueSetkey( K_F2, {|| cFileName :=;
                        padr( Dir( cFileName,,,,.T. ), SPACE_LEN ) } );
                    valid ( isFile( cFileName :=;
                        padr(strAddExtention( cFileName,;
                        _EXTENTION_TEXT ), SPACE_LEN) ) )
                read

                do case
                case lastkey() = K_ESC  // exit
                    lGoOn := .F.
                    exit
                case lastkey() = K_PGDN // ok
                    if isFile( strAddExtention( cFileName,;
                        _EXTENTION_TEXT ) )
                        //
                        lGoOn := .T.
                        exit
                    else
                        // loop
                    end
                otherwise
                    // loop
                end
            end

            // delete window
            restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

            if lGoOn
                docArray[DOC_NEW]       := .F.
                docArray[DOC_OLD]       := upper(alltrim( cFileName ))
                docArray[DOC_NAME]      := upper(alltrim( cFileName ))
                docArray[DOC_TEXT]      := MemoRead(alltrim(cFileName))
                docArray[DOC_CHANGED]   := .F.
                docArray[DOC_ROW]       := 1
                docArray[DOC_COL]       := 0
                docArray[DOC_RELROW]    := 0
                docArray[DOC_RELCOL]    := 0
            end

        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function docExit()

    local c
    local lRet
    local nCtype

    lRet = .t.
    if ( docArray[DOC_CHANGED] )
        nCtype := SetCursor(SC_NORMAL)
        if alert( DOC_PROMPT_ABANDON_CHANGES,;
                   { _MENU_NO, _MENU_YES } ) == 2
            lRet := .T.
        else
            lRet := .f.
        end
        setcursor(nCtype)
    else
        nCtype := SetCursor(SC_NORMAL)
        if alert( DOC_PROMPT_EXIT,;
               { _MENU_YES, _MENU_NO } ) == 1
            lRet := .T.
        else
            lRet := .f.
        end
        setcursor(nCtype)
    end

    docArray[DOC_EXIT] := lRet
    return (lRet)

//----------------------------------------------------------------
static function docSave()

    local lRet

    lRet := .F.

    WaitFor( DOC_WRITING + docArray[DOC_NAME] )

    begin sequence

        do case
        case docArray[DOC_NEW]  // new file
            lRet := docSaveAs()   // recursive call
            break
        case docArray[DOC_NAME] <> docArray[DOC_OLD]
            // these are allready upper and alltrim
            //
            if file( docArray[DOC_NAME] )
                if alert( docArray[DOC_NAME] + ";" +;
                      _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                      { _MENU_NO, _MENU_YES } ) == 1
                    // Do not overwrite and do not save.
                    lRet := .F.
                    break
                else
                    // Ok, save.
                end
            else
                // Ok, go on.
            end
        end

        // If here, go on.

        // Update old name.
        docArray[DOC_OLD] := docArray[DOC_NAME]

        if ( MemoWrit(docArray[DOC_NAME], docArray[DOC_TEXT]) )
            WaitFor( DOC_WRITE_OK )
            docArray[DOC_CHANGED] := .F.
            lRet := .T.
        else
            alert( DOC_WRITE_ERROR )
            lRet := .F.
        end

    end sequence

    WaitFor()

    return lRet

//----------------------------------------------------------------
static function docSaveAs()

    local cNewName := padr( docArray[DOC_NAME], SPACE_LEN )
    local lRet := .F.

    cNewName := Accept( cNewName, DOC_NEW_NAME )

    if cNewName == NIL   // premuto [Esc]
        lRet := .F.
    else
        cNewName := strAddExtention( cNewName, _EXTENTION_TEXT )
        docArray[DOC_NAME] := upper( alltrim(cNewName) )
        docArray[DOC_NEW] := .F.
        lRet := docSave()
    end

    return lRet

//----------------------------------------------------------------
static function docMenu()
//
    local cOldScreen          := savescreen()
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local lOldSetWrap         := set(_SET_WRAP, .T.)
    local nOldSetMessage      := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter       := set(_SET_MCENTER, .T.)
    local bOld_F1             :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )
    local bOld_F2             := setkey( K_F2, NIL )
    local bOld_LEFT           := setkey( K_LEFT, NIL )
    local bOld_RIGHT          := setkey( K_RIGHT, NIL )
    local nOldRow             := row()
    local nOldCol             := col()

    local nMnuChoice := 1

    begin sequence

        while .T.
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            scroll( 01, 00, 01, maxcol() )
            scroll( maxrow()-1, 00, maxrow()-1, maxcol() )
            @maxrow(),00 say padc( _KEY_MENU_H, maxcol()+1 )
            // The horizontal menu starts.
            @01,01;
                prompt MNU_MENU_DOC_CHOICE;
                message MNU_MENU_DOC_MSG
            @01,col()+1;
                prompt MNU_MENU_FILE_CHOICE;
                message MNU_MENU_FILE_MSG
            @01,col()+1;
                prompt MNU_MENU_EDIT_CHOICE;
                message MNU_MENU_EDIT_MSG
            @01,col()+1;
                prompt MNU_MENU_MACRO_CHOICE;
                message MNU_MENU_MACRO_MSG
            @01,col()+1;
                prompt MNU_MENU_INFO_CHOICE;
                message MNU_MENU_INFO_MSG
            menu to nMnuChoice

            // [Left]/[Right] key redirection.
            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            setcolor( COLOR_DEFAULT0 )

            // Menu analilsys.
            do case
            case nMnuChoice == 0 // ESC
                break
            case nMnuChoice == 1
                if mnuvDoc( 0, 0+len(MNU_MENU_DOC_CHOICE)+1 )
                    break
                end
            case nMnuChoice == 2
                mnuvFile( 4, 4+len(MNU_MENU_DOC_CHOICE)+1 )
            case nMnuChoice == 3
                mnuvEdit( 9, 9+len(MNU_MENU_DOC_CHOICE)+1 )
            case nMnuChoice == 4
                mnuvMacro( 14, 14+len(MNU_MENU_DOC_CHOICE)+1 )
            case nMnuChoice == 5
                mnuvInfo( 20, 20+len(MNU_MENU_DOC_CHOICE)+1 )
            end

            // Arrow keys are released.
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

        end

    end sequence

    // Restore.
    setcolor( cOldColor )
    setcursor( nOldCursor )
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setkey( K_LEFT, bOld_LEFT )
    setkey( K_RIGHT, bOld_RIGHT )

    return NIL

//----------------------------------------------------------------
static function docPrintCondition( cText )
//
// It asks for conditions FOR and WHILE before printing with the
// RPT() function.
//
// <cText>      the text to print.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( DOC_HELP_PRINT ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoPrint := .T.

    local cWhileCondition     := padr( ".T.", SPACE_LEN )
    local cForCondition       := padr( ".T.", SPACE_LEN )

    begin sequence

        // Parameters check.
        if valtype( cText ) <> "C"
            // There is no text to print.
            break
        end

        // An active Alias must be present.
        if alias() == "";
            // null string means no active alias
            //
            alert( _ERROR_NO_ALIAS )
            break
        end

        // Create a window.
        nBottom     := maxrow()
        nTop        := nBottom - 6
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( DOC_DIALOG_BOX_TOP_PRINT, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say DOC_PROMPT_WHILE_EXPRESSION
            @row()+1,nLeft;
                get cWhileCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, NIL );
                valid ( ( cWhileCondition :=;
                    iif( cWhileCondition <> SPACE_STR,;
                    cWhileCondition, padr( ".T.",;
                    SPACE_LEN ) ) ) <> NIL )
            @row()+1,nLeft;
                say DOC_PROMPT_FOR_EXPRESSION
            @row()+1,nLeft;
                get cForCondition;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cForCondition :=;
                    padr( fieldNormal(),;
                    SPACE_LEN ) } );
                valid ( ( cForCondition :=;
                    iif( cForCondition <> SPACE_STR,;
                    cForCondition, padr( ".T.",;
                    SPACE_LEN ) ) ) <> NIL )
            read

            do case
            case lastkey() = K_ESC
                lGoPrint := .F.
                exit
            case lastkey() = K_PGDN // choice confirmation
                // Verify to have correct data.
                if cWhileCondition <> SPACE_STR;
                    .and. cForCondition <> SPACE_STR
                    //
                    lGoPrint := .T.
                    exit
                else
                    // Loop.
                end
            otherwise
                // Loop.
            end
        end

        // Delete window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        if lGoPrint
            rptMany( cText,;
                { || &(alltrim(cWhileCondition)) },;
                { || &(alltrim(cForCondition)) }, NIL )
        end
        waitFileEval( .T. )

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

#endif
//================================================================
// DOT - DOT FUNCTIONS
//================================================================
function dotLine( cColorTop, cColorBody )
//
// dotLine( [<cColorTop>], [<cColorBody>] ) --> NIL
//
// Mini dot command line to use as a pop up calcultor.
// Keyboard() is used to send a result to a get field.
//

    local getlist           := {}
    local bOld_F1           :=;
        setkey( K_F1, { || Text( DOT_LINE_HELP )} )

    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOldErrorHandler
    local cOldScreen
    local nOldRow        := row()
    local nOldCol        := col()
    local nOldSetDec     := set( _SET_DECIMALS, 15 )

    local nTop
    local nLeft
    local nBottom
    local nRight
    local nWidth
    local nHeight

    local lMore     := .T.
    local cCommand  := SPACE_STR
    local xResult

    default cColorTop       to COLOR_DEFAULT1
    default cColorBody      to COLOR_DEFAULT2

    begin sequence

        // Create a kind of window.
        nTop    := row()+1
        nLeft   := col()
        nBottom := nTop+2
        if nBottom > maxrow()
            nBottom := maxrow()
            nTop    := nBottom - 2
        end
        nRight  := nLeft+59
        if nRight > maxcol()
            nRight := maxcol()
            nLeft  := nRight -59
        end
        nWidth  := nRight - nLeft +1
        nHeight := nBottom - nTop +1

        cOldScreen    :=;
            savescreen( nTop, nLeft, nBottom, nRight )

        setcolor( cColorTop )
        setpos( nTop, nLeft)
        dispout( padc( DOT_LINE_TITLE, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( DOT_LINE_BOTTOM, nWidth ) )
        setcolor( cColorBody )
        dispbox( nTop, nLeft, nBottom, nLeft, 2 )
        dispbox( nTop, nRight, nBottom, nRight, 2 )

        while .T.

            @nTop+1, nLeft+1;
                get cCommand;
                picture "@s"+ltrim(str(nWidth-2))+"@"
            readmodal(getlist)
            getlist := {}

            do case
            case lastkey() = K_PGDN
                keyboard( alltrim(cCommand) )
                exit
            case lastkey() = K_ESC
                exit
            case lastkey() = K_ENTER
                if !empty( cCommand )
                    // Save error handler.
                    bOldErrorHandler :=;
                        errorblock( {|e| break(e)} )
                    begin sequence
                        xResult := &(alltrim(cCommand))

                    recover
                        xResult := padr( "Error", SPACE_LEN )
                    end
                    errorblock(bOldErrorHandler)

                    // cCommand prepare
                    cCommand :=;
                        padr( alltrim(transform( xResult, "@!" )),;
                            SPACE_LEN )
                end
            otherwise
                // nil
            end
        end
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

    end sequence

    setpos( nOldRow, nOldCol )
    setcursor(nOldCursor)
    setcolor( cOldColor )
    set( _SET_DECIMALS, nOldSetDec )
   
    return NIL

//================================================================
// DTE - DATE/TIME FUNCTIONS
//================================================================
function dteMonth( nMonth, cLanguage )
//
// dteMonth( <nMonth>, <cLanguage> ) --> cMonth
//
// <nMonth>     the month number
// <cLanguage>  the language name
//
// This function translates the <nMonth> number into the month
// name.
//
    local cMonth := ""

    begin sequence

        if valtype( nMonth ) <> "N"
            break
        end
        if valtype( cLanguage ) <> "C"
            break
        end

        cLanguage := upper( alltrim( cLanguage ) )

        do case
        case cLanguage == "ITALIANO" .or.;
             cLanguage == "ITALIANA" .or.;
             cLanguage == "ITALIA"
            do case
            case nMonth = 1
                cMonth := "gennaio"
            case nMonth = 2
                cMonth := "febbraio"
            case nMonth = 3
                cMonth := "marzo"
            case nMonth = 4
                cMonth := "aprile"
            case nMonth = 5
                cMonth := "maggio"
            case nMonth = 6
                cMonth := "giugno"
            case nMonth = 7
                cMonth := "luglio"
            case nMonth = 8
                cMonth := "agosto"
            case nMonth = 9
                cMonth := "settembre"
            case nMonth = 10
                cMonth := "ottobre"
            case nMonth = 11
                cMonth := "novembre"
            case nMonth = 12
                cMonth := "dicembre"
            end
        end

    end sequence

    return cMonth

//================================================================
function dteWeek( nWeek, cLanguage )
//
// dteWeek( <nWeek>, <cLanguage> ) --> cWeek
//
// <nWeek>      the week number
// <cLanguage>  the language name
//
// This function translates the <nWeek> number into the week
// name.
// nWeek == 1 -> Sunday
// nWeek == 2 -> Monday
// ...
// nWeek == 7 -> Saturday
//
    local cWeek := ""

    begin sequence

        if valtype( nWeek ) <> "N"
            break
        end
        if valtype( cLanguage ) <> "C"
            break
        end

        cLanguage := upper( alltrim( cLanguage ) )

        do case
        case cLanguage == "ITALIANO" .or.;
             cLanguage == "ITALIANA" .or.;
             cLanguage == "ITALIA"
            do case
            case nWeek = 1
                cWeek := "domenica"
            case nWeek = 2
                cWeek := "lunedi'"
            case nWeek = 3
                cWeek := "martedi'"
            case nWeek = 4
                cWeek := "mercoledi'"
            case nWeek = 5
                cWeek := "giovedi'"
            case nWeek = 6
                cWeek := "venerdi'"
            case nWeek = 7
                cWeek := "sabato"
            end
        end

    end sequence

    return cWeek

//================================================================
// EX - MACRO INTERPRETER AND EXECUTOR
//================================================================
function ex( cFileMacro )
//
// ex( <cFileMacro> ) --> nExitCode
//
// execute <cFileMacro>.
//
// <cFileMacro> The macro filename with extension.
//
//

    local cProcedure
    local nExitCode

    // The name must be alltrimed.
    cFileMacro := alltrim( cFileMacro )

    nExitCode := exTestFile( cFileMacro )
    do case
    case nExitCode == _MACRO_EXIT_NORMAL
        // It is a "compiled" macro.
        nExitCode := cmExecute( cFileMacro )
    case nExitCode == _MACRO_EXIT_NO_MACRO_FILE
        // File not found.
        alert( cFileMacro + ";" +;
            _MACRO_ERROR_FILE_NOT_FOUND )
    case nExitCode == _MACRO_EXIT_FILE_LOCKED
        // File LOCKED.
        alert( cFileMacro + ";" +;
            _MACRO_ERROR_FILE_LOCKED )
    case nExitCode == _MACRO_EXIT_DIFFERENT_DBF
        // Not a right "compiled" macro file.
        alert( cFileMacro + ";" +;
            _MACRO_ERROR_FILE_DIFFERENT_STRUCTURE )
    case nExitCode == _MACRO_EXIT_FILE_NOT_DBF
        // Not a "compiled" macro, maybe a text macro.
        cProcedure := memoread( cFileMacro )
        nExitCode := execute( cProcedure, cFileMacro )
    otherwise
        // Unknown.
    end
    
    return nExitCode

//----------------------------------------------------------------
static function exTestFile( cFileName )
//
//

    local nExitCode
    local nOldSelect := select()
    local bOldErrorHandler
    local dummy

    do case
    case file( cFileName )
        // The file exists
        
        bOldErrorHandler    := errorblock( {|e| break(e)} )
        begin sequence
            // Try to open the file
            dbusearea(.T., _DEFAULT_RDD, cFileName,;
                "_TEST_", .T., .T.)
            do case
            case neterr()
                nExitCode := _MACRO_EXIT_FILE_LOCKED
            case fieldpos("Line") > 0;
                .and. fieldpos("Macro") > 0;
                .and. fieldpos("Command") > 0;
                .and. fieldpos("Goto1") > 0;
                .and. fieldpos("Goto2") > 0
                // It contains all the right fields.
                nExitCode := _MACRO_EXIT_NORMAL
            otherwise
                nExitCode := _MACRO_EXIT_DIFFERENT_DBF
            end                
            dbclosearea()
        recover
            nExitCode := _MACRO_EXIT_FILE_NOT_DBF
        end sequence
        errorblock( bOldErrorHandler )

    otherwise
        nExitCode   := _MACRO_EXIT_NO_MACRO_FILE
    end

    dbselectarea( nOldSelect )

    return nExitCode

//----------------------------------------------------------------
static function execute( cCommands, cName )
//
// execute( <cCommands>, [<cName>] ) --> nExitCode
//
// <cCommands>  Variable containing many commands separated
//              by NL(1) ( = CR+LF).
//
// <cName>      A name to be used for error report duriing program
//              execution.
//

    local aNest               := array( _STATEMENT_MAX_NEST )
    local nNest               := 0
    local aProcedure          := {}
    local nProcedure          := 0
    local cProcedure          := ""
    local nLine
    local cCommand            := ""
    local cCondition          := ""

    local nExitCode           := _MACRO_EXIT_NORMAL

    begin sequence

        nLine := 1
        nNest := 1
        aNest[nNest]          := { _STATEMENT_MAIN, .T. }
        // [1]MAIN  [2]lContinue

        while .T.

            cCommand := exCommandExtract( cCommands, @nLine )

            if cCommand == NIL  // end of file
                nExitCode := _MACRO_EXIT_NORMAL
                break
            end
            
            do case
            case upper( cCommand ) == "END"
                // Try to close one nest level.
                
                do case
                case aNest[nNest][1] == _STATEMENT_MAIN
                    // Not allowed.
                    alert( cName +;
                        "(" +;
                        ltrim(str(nLine)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_END )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                    // Not allowed.
                    alert( cName +;
                        "(" +;
                        ltrim(str(nLine)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_END )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                case aNest[nNest][1] == _STATEMENT_IF;
                    .or. aNest[nNest][1] == _STATEMENT_THEN;
                    .or. aNest[nNest][1] == _STATEMENT_ELSE
                    //
                    aNest[nNest] := NIL
                    nNest--
                    nLine++
                case aNest[nNest][1] == _STATEMENT_BEGIN
                    aNest[nNest] := NIL
                    nNest--
                    nLine++
                case aNest[nNest][1] == _STATEMENT_WHILE
                    do case
                    case &(aNest[nNest][2])
                        // Continue While loop.
                        nLine := aNest[nNest][3]
                    otherwise
                        // Terminate While loop.
                        aNest[nNest] := NIL
                        nNest--
                        nLine++
                    end
                case aNest[nNest][1] == _STATEMENT_LOOP
                    aNest[nNest] := NIL
                    nNest--
                    // nLine remains on last END.
                    // Test previous level.
                    do case
                    case aNest[nNest][1] == _STATEMENT_WHILE
                        do case
                        case &(aNest[nNest][2])
                            // Repeat While loop.
                            nLine := aNest[nNest][3]
                        otherwise
                            // Exit While loop.
                            exJumpIt( cCommands, @nLine,;
                                {|cLine| cLine=="END"} )
                            // Now nLine should be on next END.
                            // nLine is not advanced and the nest
                            // level is not reduced: if it is
                            // the right END will end "naturally".
                        end
                    otherwise
                        aNest[nNest][1] := _STATEMENT_LOOP
                        // Go to next END starting from next line.
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                        // Now nLine should be on next END.
                        // nLine is not advanced and the nest
                        // level is not reduced: if it is
                        // the right END will end "naturally".
                    end
                case aNest[nNest][1] == _STATEMENT_BREAK
                    aNest[nNest] := NIL
                    nNest--
                    // nLine remain on last END.
                    // Test previous level.
                    do case
                    case aNest[nNest][1] == _STATEMENT_BEGIN
                        // Reach the end sequence.
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                        // Now nLine should be on next END.
                        // nLine is not advanced and the nest
                        // level is not reduced: if it is
                        // the right END will end "naturally".
                    otherwise
                        aNest[nNest][1] := _STATEMENT_BREAK
                        // Reach the end sequence.
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                        // Now nLine should be on next END.
                        // nLine is not advanced and the nest
                        // level is not reduced: if it is
                        // the right END will end "naturally".
                    end
                case aNest[nNest][1] == _STATEMENT_EXIT
                    aNest[nNest] := NIL
                    nNest--
                    // nLine remain on last END.
                    // Test previous level.
                    do case
                    case aNest[nNest][1] == _STATEMENT_WHILE
                        // Exit While loop.                    
                        aNest[nNest][2] := ".F."
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                        // Now nLine should be on next END.
                        // nLine is not advanced and the nest
                        // level is not reduced: if it is
                        // the right END will end "naturally".
                    otherwise
                        aNest[nNest][1] := _STATEMENT_EXIT
                        // Exit While loop.
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                        // Now nLine should be on next END.
                        // nLine is not advanced and the nest
                        // level is not reduced: if it is
                        // the right END will end "naturally".
                    end
                case aNest[nNest][1] == _STATEMENT_DOCASE;
                    .or. aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    aNest[nNest] := NIL
                    nNest--
                    nLine++
                end

            case upper( cCommand ) == "PROCEDURE"
                // No procedure name following PROCEDURE.
                alert( cName +;
                    "(" +;
                    ltrim(str(nLine)) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_NO_PROCEDURE_NAME )
                nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                break
            case upper( left( cCommand, 10 ) ) == "PROCEDURE "
                // Save the procedure name inside the
                // procedure array.
                cProcedure :=;
                    alltrim( substr( ltrim( cCommand ), 10 ) )
                cProcedure := upper( cProcedure )
                aadd( aProcedure, { cProcedure, nLine+1 } )
                // Jump to the line following the ENDPROCEDURE
                exEndproc( cCommands, @nLine )
                nLine++
            case upper( cCommand ) == "DO PROCEDURE"
                // No procedure name to call.
                alert( cName +;
                    "(" +;
                    ltrim(str(nLine)) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_PROCEDURE_NOT_FOUND )
                nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                break
            case upper( left( cCommand, 13 ) ) == "DO PROCEDURE "
                nNest++
                aNest[nNest] := {_STATEMENT_DOPROCEDURE, nLine+1}
                // [1]PROCEDURE  [2]nNextLine
                cProcedure :=;
                    alltrim( substr( ltrim( cCommand ), 13 ) )
                cProcedure := upper( cProcedure )
                // Scan procedure array.
                nProcedure := 1
                while .t.
                    if nProcedure > len( aProcedure )
                        alert( cName +;
                            "(" +;
                            ltrim(str(nLine)) +;
                            ")" +;
                            ";" +;
                            _STATEMENT_ERROR_PROCEDURE_NOT_FOUND )
                        nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                        break
                    end
                    if aProcedure[nProcedure][1] == cProcedure
                        nLine := aProcedure[nProcedure][2]
                        exit
                    end
                    nProcedure++
                end
            case upper( cCommand ) == "RETURN"
                // The return line is contained inside
                // aNest at the correponding DOPROCEDURE
                // position
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                        // Ok, ready to return.
                        nLine := aNest[nNest][2]
                        aNest[nNest] := NIL
                        nNest--
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        // This RETURN must be considered
                        // as a "terminate file execution".
                        break
                    otherwise
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end
            case upper( cCommand ) == "ENDPROCEDURE"
                // The return line is contained inside
                // aNest at the correponding DOPROCEDURE
                // position
                while .T.
                    do case
                    case aNest[nNest][1] == _STATEMENT_DOPROCEDURE
                        // Ok, ready to return.
                        nLine := aNest[nNest][2]
                        aNest[nNest] := NIL
                        nNest--
                        exit
                    case aNest[nNest][1] == _STATEMENT_MAIN
                        alert( cName +;
                            "(" +;
                            ltrim(str(nLine)) +;
                            ")" +;
                            ";" +;
                            _STATEMENT_ERROR_ALONE_ENDPROCEDURE )
                        nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                        break
                        break
                    otherwise
                        // Go back one nest.
                        aNest[nNest] := NIL
                        nNest--
                    end
                end
            case upper( cCommand ) == "BEGIN SEQUENCE"
                nNest++
                aNest[nNest] := {_STATEMENT_BEGIN}
                // [1]BEGIN SEQUENCE
                nLine++
            case upper( cCommand ) == "BREAK"
                do case
                case aNest[nNest][1] == _STATEMENT_BEGIN
                    // Reach the end sequence.
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                    // Now nLine should be on next END.
                    // nLine is not advanced and the nest
                    // level is not reduced: if it is
                    // the right END will end "naturally".
                otherwise
                    // Reach the end sequence.
                    aNest[nNest][1] := _STATEMENT_BREAK
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                    // Now nLine should be on next END.
                    // nLine is not advanced and the nest
                    // level is not reduced: if it is
                    // the right END will end "naturally".
                end
            case upper( cCommand ) == "IF"
                // No condition following IF.
                alert( cName +;
                    "(" +;
                    ltrim(str(nLine)) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_NO_CONDITION )
                nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                break
            case upper( left( cCommand, 3 ) ) == "IF "
                nNest++
                aNest[nNest] := {_STATEMENT_IF }
                // [1]IF|THEN|ELSE
                cCondition :=;
                    alltrim( substr( ltrim(cCommand), 3 ) )
                if &(cCondition)
                    aNest[nNest][1] := _STATEMENT_THEN
                    nLine++
                else
                    // Reach Else or End.
                    aNest[nNest][1] := _STATEMENT_ELSE
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="ELSE"},;
                        {|cLine| cLine=="END"} )
                    // Now nLine should be on next ELSE or END.
                    // nLine is not advanced.
                end
            case upper( cCommand ) == "ELSE"
                do case
                case aNest[nNest][1] == _STATEMENT_ELSE
                    // THEN wasn't executed.
                    // Ok execute ELSE.
                    nLine++
                otherwise
                    // THEN was executed and it must be jumped.
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                    // Now nLine should be on next END.
                    // nLine is not advanced and the nest
                    // level is not reduced: if it is
                    // the right END will end "naturally".
                end
            case upper( cCommand ) == "DO CASE"
                nNest++
                aNest[nNest] := {_STATEMENT_DOCASE}
                // [1]DOCASE|CASEMATCHED
                nLine++
            case upper( cCommand ) == "CASE"
                // No condition following CASE.
                alert( cName +;
                    "(" +;
                    ltrim(str(nLine)) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_NO_CONDITION )
                nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                break
            case upper( left( cCommand, 5 ) ) == "CASE "
                do case
                case aNest[nNest][1] == _STATEMENT_DOCASE
                    // Ok try it.
                    cCondition :=;
                        alltrim( substr( ltrim(cCommand), 5 ) )
                    do case
                    case &(cCondition)
                        aNest[nNest][1] := _STATEMENT_CASEMATCHED
                        // No more case (but execute following
                        // lines.
                        nLine++
                    otherwise
                        // Try to find next CASE or OTHERWISE.
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| left(cLine,5)=="CASE "},;
                            {|cLine| cLine=="OTHERWISE"},;
                            {|cLine| cLine=="END"} )
                    end
                case aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    // Reach next end.
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                otherwise
                    alert( cName +;
                        "(" +;
                        ltrim(str(nLine)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_CASE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case upper( cCommand ) == "OTHERWISE"
                do case
                case aNest[nNest][1] == _STATEMENT_DOCASE
                    // Ok do it.
                    nLine++
                case aNest[nNest][1] == _STATEMENT_CASEMATCHED
                    // Reach next end.
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                otherwise
                    alert( cName +;
                        "(" +;
                        ltrim(str(nLine)) +;
                        ")" +;
                        ";" +;
                        _STATEMENT_ERROR_ALONE_OTHERWISE )
                    nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                    break
                end
            case upper( cCommand ) == "WHILE"
                // No condition following WHILE.
                alert( cName +;
                    "(" +;
                    ltrim(str(nLine)) +;
                    ")" +;
                    ";" +;
                    _STATEMENT_ERROR_NO_CONDITION )
                nExitCode := _MACRO_EXIT_STATEMENT_ERROR
                break
            case upper( left( cCommand, 6 ) ) == "WHILE "
                nNest++
                aNest[nNest] := {_STATEMENT_WHILE, NIL, NIL }
                // [1]WHILE  [2]cCondition  [3]nLine1stStatement
                // Save condition.
                aNest[nNest][2] :=;
                    alltrim( substr( ltrim(cCommand), 6 ) )
                // Save the first statement begin point
                // (it is better).
                aNest[nNest][3] := nLine +1
                // Check condition
                do case
                case &(aNest[nNest][2])
                    // Ok, go on.
                    nLine++
                otherwise
                    aNest[nNest][2] := ".F."
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                end
            case upper( cCommand ) == "LOOP"
                do case
                case aNest[nNest][1] == _STATEMENT_WHILE
                    do case
                    case &(aNest[nNest][2])
                        // Repeat While loop.
                        nLine := aNest[nNest][3]
                    otherwise
                        // Exit While loop.
                        aNest[nNest][2] := ".F."
                        exJumpIt( cCommands, @nLine,;
                            {|cLine| cLine=="END"} )
                    end
                otherwise
                    aNest[nNest][1] := _STATEMENT_LOOP
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                end
            case upper( cCommand ) == "EXIT"
                do case
                case aNest[nNest][1] == _STATEMENT_WHILE
                    aNest[nNest][2] := ".F."
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                otherwise
                    aNest[nNest][1] := _STATEMENT_EXIT
                    exJumpIt( cCommands, @nLine,;
                        {|cLine| cLine=="END"} )
                end

            otherwise
                // If we are here, it must be a function.
                nExitCode := exOneCommand( cCommand, cName, nLine )
                if nExitCode == _MACRO_EXIT_BREAK
                    break
                end
                nLine++
            end

        end

    end sequence

    return nExitCode

//----------------------------------------------------------------
static function exCommandExtract( cCommands, nLine )
//
// exCommandExtract( <cCommands>, @<nLine> ) --> NIL
//                                           --> cCommand
//
// It returns one complete command or NIL if end of file.
//
// <cCommands>  The variable containing the commands.
//
// <nLine>      The actual line position.
//

    local cCommand      := ""
    local nSemicolonPos := 0

    // waitWheel.
    waitWheel()
    
    // Reach next not-empty line.
    while .T.
        cCommand := memoline( cCommands, SPACE_LEN, nLine )
        do case
        case cCommand == ""
            // End of file reached.
            return NIL
        case !( empty( cCommand ) )
            // Cut eventual comment.
            cCommand := EXCommentCut( cCommand )
            // Cut unusefull blanks.
            cCommand := alltrim( cCommand )
            // Check if there is something.
            if !( cCommand == "" )
                // Not empty.
                exit
            end
            // Otherwise repeat loop.
        end
        // Loop.
        nLine++
    end

    // At this point there is a command line.

    // Semicolon.
    if right( cCommand, 1 ) == ";"
        // It follows to the next line.
        cCommand := left( cCommand, len( cCommand )-1 )
        nLine++
        // Recursion.
        cCommand += exCommandExtract( cCommands, @nLine )
    end

    return cCommand

//----------------------------------------------------------------
static function exCommentCut( cCommandLine )
//
// exCommentCut( <cCommandLine> ) --> cCommandLine
//
// The function cuts the command line at the first
// occurence of "//" that is used as only comment
// indicator.
//
// The string "//" cannot be used for other purpose
// as the command line will be truncated there.
//
// <cCommandLine>       a line to be cutted.
//

    local nCommentPos

    nCommentPos := at( "//", cCommandLine )
    if nCommentPos > 0
        cCommandLine := substr( cCommandLine, 1, nCommentPos -1 )
    end

    return cCommandLine

//----------------------------------------------------------------
static function exOneCommand( cCommand, cName, nLine )
//
// exOneCommand( <cCommand>, <cName>, <nLine> ) --> nExitCode
//
// This function execute a command after cleaning.
//
// <cCommand>   The command to execute.
//
// <cName>      The procedure name to be used for error
//              documentation.
//
// <nLine>      Actual command line to be used for error
//              documentation.
//

    local bSaveErrorHandler
    local xResult
    local nExitCode := _MACRO_EXIT_NORMAL

    // Empty lines should not be executed.
    if cCommand == ""
        return _MACRO_EXIT_NORMAL
    end

    bSaveErrorHandler :=;
        errorblock({|e| errorMacro(;
            e,;
            cName,;
            nLine,;
            cCommand;
            )})
    begin sequence
        // Execute macro compilation.
        xResult := &(cCommand)
    recover
        do case
        case errorChoice == ERROR_MENU_CHOICE_IGNORE
            // Ignore error.
        case errorChoice == ERROR_MENU_CHOICE_BREAK
            nExitCode := _MACRO_EXIT_BREAK
        end
    end
    errorblock(bSaveErrorHandler)

    return nExitCode

//----------------------------------------------------------------
static function exJumpIt( cCommands, nLine,;
                          bExit1, bExit2, bExit3 )
//
// --> NIL
//
// This function jumps to the statements whitch are not to be
// executed according with the control structure used.
//

    local cLine
    local nLevel := 1

    default bExit1 to { | cLine | cLine == "END" }
    default bExit2 to bExit1
    default bExit3 to bExit2

    begin sequence

        while .T.
            nLine++
            cLine := exCommandExtract( cCommands, @nLine )
            if cLine == NIL
                alert( _STATEMENT_ERROR_UNCLOSED_STRUCTURE )
                break
            end
            cLine := upper( cLine )

            if nLevel == 1 // start level
                if eval( bExit1, cLine ) .or.;
                   eval( bExit2, cLine ) .or.;
                   eval( bExit3, cLine )
                    break
                end
            end

            do case
            case cLine == "END"
                nLevel--
                if nLevel == 0
                    alert( _STATEMENT_ERROR_ALONE_END )
                    break
                end
            case cLine == "WHILE"; // (without)
                .or. left( cLine, 6 ) == "WHILE ";  // (with)
                .or. cLine == "IF"; // (without)
                .or. left( cLine, 3 ) == "IF "; //(with)
                .or. cLine == "BEGIN SEQUENCE";
                .or. cLine == "DO CASE"
                // (with)/(without) means with/without condition.
                //
                nLevel++
            end
        end

    end sequence

    // nLine is pointed on END or beiond end of file.

    return NIL

//----------------------------------------------------------------
static function exEndProc( cCommands, nLine )
//
// --> NIL
//
// This function jumps with speed to the end of procedure.
//

    local cLine

    begin sequence

        while .T.
            nLine++
            waitWheel()
            cLine := upper( memoline( cCommands, SPACE_LEN, nLine ) )
            do case
            case cLine == ""
                // End of file reached.
                alert( "( End of file );" +;
                    _STATEMENT_ERROR_UNCLOSED_PROCEDURE )
                break
            case left( ltrim( cLine ), 12 ) ==;
                "ENDPROCEDURE"
                //
                // End procedure reached
                break
            case left( ltrim( cLine ), 9 ) ==;
                "PROCEDURE"
                //
                alert( "(" + ltrim( str(nLine) ) + ");" +;
                    _STATEMENT_ERROR_UNCLOSED_PROCEDURE )
                // End procedure reached because a new procedure
                // is beginning.
                nLine--
                break
            end
        end

    end sequence

    // nLine is pointed on ENDPROCEDURE or beiond end of file.

    return NIL

//================================================================
// HTF - HELP TEXT FILE
//================================================================
function htf( nInitialRecord, cHeader )
//
// htf([<nInitialRecord>]) --> NIL
//
// <nInitialRecord> The starting record to reach befor showing
//                  the text.
//
// Uses the active Alias as an hypertext help file.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := savescreen()
    local cOldColor           := setcolor()
    local lReadExit
    local nOldCursor          := setcursor()
    local nOldRow             := row()
    local nOldCol             := col()
    local bOld_F1             :=;
        setkey( K_F1, { || Text( HTF_HELP ) } )
    local bOld_F3             := setkey( K_F3 )
    local bOld_SH_F3          := setkey( K_SH_F3 )
    local oBrowse
    local oColumn
    local nKey
    local lTerminate := .f.

    local nTop                := 0 +1
    local nLeft               := (maxcol()+1-80) /2
    local nBottom             := maxrow() -1
    local nRight              := nLeft+80-1

    local anPointer           := {}
    local nI                  := 0

    default cHeader     to ""

    // Check for a valid HTF file
    if fieldname(1) == "TEXT";
        .and. fieldname(2) == "POINTER";
        .and. valtype( field->Text ) == "C";
        .and. valtype( field->Pointer ) == "N"
        //
        // OK.
    else
        alert( HTF_ERROR_FILE_TYPE )
        return NIL
    end

    // Check initial record.
    if valtype( nInitialRecord ) == "N"
        // ok
        if nInitialRecord < 0;
           .or. nInitialRecord > reccount()
           //
           dbgotop()
        else
            dbgoto( nInitialRecord )
        end
    else
        // nil
    end    

    // If eof() it is better to move the record pointer.
    if eof()
        dbgobottom()
    end
    if bof()
        dbgotop()
    end

    lReadExit           := readexit(.T.)
    nOldCursor          := setcursor()
    nOldRow             := row()
    nOldCol             := col()

    bOldErrorHandler    := errorblock( {|e| ErrorHandler(e)} )

    begin sequence


        setcolor( COLOR_DEFAULT1 )
        scroll( 0, 0, 1, maxcol() )
        scroll( maxrow(), 0, maxrow(), maxcol() )
        setpos( 0, 0 )
        dispout( padc( cHeader, maxcol()+1 ) )
        setpos( maxrow(), 0 )
        dispout( padc( HTF_WINDOW_BOTTOM,;
            maxcol()+1 ) )
        setcolor( COLOR_DEFAULT2 )

        while .t.
            // Make a Tbrowse object for the current workarea.
            oBrowse := tbrowsedb(nTop, nLeft, nBottom, nRight)
            oColumn :=;
                 tbColumnNew( "", fieldwblock( "TEXT", select() ) )
            oBrowse:addColumn( oColumn )

            // Use a custom skipper.
            oBrowse:skipBlock :=;
                { | nSkip | htfSkip( nSkip, oBrowse ) }

            // Define pictures.
            tbColPicture(oBrowse, { "@s80" } )

            // Turn the cursor off while browsing.
            setcursor(SC_NONE)

            // Main loop.
            while .t.
                // Stabilize the display until it's stable
                // or a key is pressed.
                oBrowse:forceStable()
                // Wait for a key.
                nKey := inkey( 0 )

                do case
                case ( nKey == K_ESC )
                    // Esc means leave.
                    lTerminate := .t.
                    exit
                case nKey == K_DOWN
                    oBrowse:down()
                case nKey == K_PGDN
                    oBrowse:pageDown()
                case nKey == K_CTRL_PGDN
                    oBrowse:goBottom()
                case nKey == K_UP
                    oBrowse:up()
                case nKey == K_PGUP
                    oBrowse:pageUp()
                case nKey == K_CTRL_PGUP
                    oBrowse:goTop()
                case nKey == K_SH_F3
                    // Search a new pattern.
                    htfSearch(.F.)
                    exit
                case nKey == K_F3
                    // Search old pattern.
                    htfSearch(.T.)
                    exit
                case nKey == K_RETURN
                    if htfGo( @anPointer, @nI )
                        exit
                    end
                case nKey == K_LEFT
                    if htfPrevious( @anPointer, @nI )
                        exit
                    end
                case nKey == K_RIGHT
                    if htfNext( @anPointer, @nI )
                        exit
                    end
                case nKey == K_F1
                    Text( HTF_HELP )
                end
            end
            if lTerminate
                exit
            end
        end

    recover
        // nil
    end sequence

    errorblock(bOldErrorHandler)
    readexit(lReadExit)
    restscreen( NIL, NIL, NIL, NIL, cOldScreen )
    setcolor( cOldColor )
    setcursor(nOldCursor)
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F3, bOld_F3 )
    setkey( K_SH_F1, bOld_SH_F3 )

    return NIL

#ifndef RUNTIME
//----------------------------------------------------------------
static function htfOpen( cHtf )
//
// htfOpen( [<cHtf>] ) --> NIL
//
// <cHtf>       is the name of the file to search for; it can
//              contain wildcards.
//
// It asks for the name of the HTF file to browse if <cHtf> is not
// found or it contains wildcards.
//

    local getlist             := {}
    local bOldErrorHandler
    local nOldSelect          := select()
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( HTF_HELP_OPEN ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .T.


    
    if valtype( cHtf ) == "C"
        // OK.
    else
        cHtf := "*." + _EXTENTION_HTF
    end

    begin sequence

        do case
        case "*" $ cHtf .or. "?" $ cHtf
            // Wildcards means continue.
        case file( alltrim( cHtf ) )
            // The file is present:
            // just open it.
            // Open the selected htf file.
            dbusearea(.T., _DEFAULT_RDD, alltrim(cHtf),;
                "HlpTxtFile", .T., .T.)
            // Run htf
            htf( NIL, alltrim(cHtf) )
            // Close htf file.
            HlpTxtFile->(dbclosearea())
            // Exit.
            break
        otherwise
            // Announce that there is no file.
            alert( alltrim( cHtf ) + ";" + _ERROR_NO_FILE_HERE )
        end

        // Ask for the name to load. 

        // Prepare data before editing.
        cHtf := padr( cHtf, SPACE_LEN )

        // Create a window.
        nBottom     := maxrow()
        nTop        := nBottom - 4
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( HTF_DIALOG_BOX_TOP_OPEN, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say HTF_PROMPT_HTF_FILE_OPEN
            @row()+1,nLeft;
                get cHtf;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cHtf :=;
                    padr( Dir( cHtf,,,,.T. ),;
                        SPACE_LEN ) } );
                valid ( isFile( alltrim( cHtf ) ) )
            read

            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // choice confirmation
                // Verify to have correct data.
                if isFile( alltrim(cHtf) )
                    //
                    lGoOn := .T.
                    exit
                else
                    // Loop.
                end
            otherwise
                // Loop.
            end
        end

        // Delete window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        // Restore Colors.
        setcolor( cOldColor )


        if lGoOn
            // Open the selected htf file.
            dbusearea(.T., _DEFAULT_RDD, alltrim(cHtf),;
                "HlpTxtFile", .T., .T.)
            // Run htf
            htf( NIL, alltrim(cHtf) )
            // Close htf file.
            HlpTxtFile->(dbclosearea())
        end

    end sequence

    // Restore.
    select( nOldSelect )
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

#endif
//----------------------------------------------------------------
static function htfSkip(nSkip, oBrowse)
//
// htfSkip(nSkip, oBrowse) --> nSkippedRecords
//
// Handle record movement requests from the Tbrowse object.
//

    local nI            := 0

    do case
    case ( nSkip == 0 .or. lastrec() == 0 )
        // Skip 0 (significant on a network)
        dbSkip(0)
    case ( nSkip > 0 .and. !eof() )
        // Skip Forward
        while (nI < nSkip)
            dbskip( 1 )
            if eof()
                // Don't let the cursor go to eof
                dbgobottom()
                exit
            end
            nI++
        end
    case ( nSkip < 0 )
        // Skip backward
        while ( nI > nSkip )
            dbskip(-1)
            if bof()
                // Don't let the cursor go to bof
               dbgotop()
               exit
            end
            nI--
        end
    end

   return nI

//----------------------------------------------------------------
static function htfGo( anPointer, nI )

    local nPointer := Field->Pointer

    if nPointer > 0
        // Go to the selected record.
        dbgoto( nPointer )
        // Add the new position inside the Pointer array.
        aadd( anPointer, nPointer )
        // Point the nI to the Array's last position.
        nI := len( anPointer )
        // A valid go to record was done.
        return .t.
    end

    return .f.


//----------------------------------------------------------------
static function htfPrevious( anPointer, nI )

    if nI < 2
        // can't go back
    else
        nI--
        dbgoto( anPointer[nI] )
        // A valid go to record was done.
        return .t.
    end

    return .f.

//----------------------------------------------------------------
static function htfNext( anPointer, nI )

    if nI < len( anPointer )
        nI++
        dbgoto( anPointer[nI] )
        // A valid go to record was done.
        return .t.
    else
        // can't go next
    end

    return .f.

//----------------------------------------------------------------
static function htfSearch( lRepeatSearch )
//
// Search for a text pattern.
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( HTF_HELP_PATTERN_SEARCH ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .F.

    local nStartRecord        := recno()

    static cPattern

    default lRepeatSearch to .F.

    if cPattern == NIL
        cPattern := SPACE_STR
    end

    if empty( cPattern )
        lRepeatSearch := .F.
    end

    begin sequence

        if !lRepeatSearch
        
            // Create a kind of window.
            nBottom     := maxrow()
            nTop        := nBottom - 3
            nLeft       := 0
            nRight      := maxcol()
            nWidth      := nRight - nLeft +1
            cOldScreen  := savescreen( nTop, nLeft, nBottom, nRight )
            setcolor( COLOR_DEFAULT1 )
            scroll( nTop, nLeft, nTop, nRight )
            scroll( nBottom-1, nLeft, nBottom, nRight )
            setpos( nTop, nLeft )
            dispout( padc( HTF_DIALOG_BOX_TOP_SEARCH, nWidth ) )
            setpos( nBottom, nLeft )
            dispout( padc( _KEY_ESC_NORMAL_F1_PGDN, nWidth ) )

            while .t.
                setcolor( COLOR_DEFAULT2 )
                scroll( nTop+1, nLeft, nBottom-2, nRight )
                setpos( nTop, nLeft )
                @row()+1,nLeft;
                    say HTF_PROMPT_SEARCH_PATTERN
                @row()+1,nLeft;
                    get cPattern;
                    picture "@s"+ltrim(str(nWidth))+"@";
                    when trueSetkey( K_F2, {|| NIL } );
                    valid ( cPattern <> SPACE_STR )
                read

                do case
                case lastkey() = K_ESC  // exit
                    lGoOn := .F.
                    exit
                case lastkey() = K_PGDN // confirm
                    // Check for correct data
                    if (cPattern <> SPACE_STR)
                        //
                        lGoOn := .T.
                        exit
                    else
                        // loop
                    end
                otherwise
                    // loop
                end
            end

            // close window
            restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )

        end

        if lGoOn;
            .or. lRepeatSearch
            //
            bOldErrorHandler := errorblock( {|e| ErrorHandler(e)} )
            begin sequence
                WaitFor( HTF_WAIT_SEARCHING +;
                    upper( alltrim( cPattern ) ) )
                dbskip()
                while !eof()
                    if upper( alltrim( cPattern ) );
                        $ upper( Field->Text )
                        //
                        exit
                    end
                    dbskip()
                end
                if eof()
                    alert( upper( alltrim( cPattern ) ) +;
                        ";" + HTF_ERROR_PATTERN_NOT_FOUND )
                    dbgoto( nStartRecord )
                end    
            recover
                dbgoto( nStartRecord )
            end sequence
            waitfor()
            errorblock(bOldErrorHandler)
        end

    end sequence

    // Restore
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

#ifndef RUNTIME
//----------------------------------------------------------------
static function htfGenDialog()
//
// It asks for parameters needed to run htfGenerate().
//

    local getlist             := {}
    local bOldErrorHandler
    local cOldScreen          := ""
    local cOldColor           := setcolor()
    local nOldCursor          := setcursor( SC_NORMAL )
    local bOld_F1             :=;
        setkey( K_F1, { || Text( HTF_HELP_GENERATE ) } )
    local bOld_F2             := setkey( K_F2, NIL )
    local nOldRow             := row()
    local nOldCol             := col()
    local nTop                := 0
    local nLeft               := 0
    local nBottom             := 0
    local nRight              := 0
    local nWidth              := 0

    local lGoOn               := .T.

    local cHtfSource          := padr( "*.*", SPACE_LEN )
    local cHtfDestination     := SPACE_STR
    
    static cIndexStart
    static cIndexEnd
    static cPointerStart
    static cPointerEnd

    if cIndexStart == NIL
        cIndexStart     := padr( HTF_INDEX_START, SPACE_LEN )
    end
    if cIndexEnd == NIL
        cIndexEnd       := padr( HTF_INDEX_END, SPACE_LEN )
    end
    if cPointerStart == NIL
        cPointerStart   := padr( HTF_POINTER_START, SPACE_LEN )
    end
    if cPointerEnd == NIL
        cPointerEnd     := padr( HTF_POINTER_END, SPACE_LEN )
    end

    begin sequence

        // Create a window.
        nBottom     := maxrow()
        nTop        := nBottom - 14
        nLeft       := 0
        nRight      := maxcol()
        nWidth      := nRight - nLeft +1
        cOldScreen  :=;
            savescreen( nTop, nLeft, nBottom, nRight )
        setcolor( COLOR_DEFAULT1 )
        setpos( nTop, nLeft )
        dispout( padc( HTF_DIALOG_BOX_TOP_GENERATE, nWidth ) )
        setpos( nBottom-1, nLeft )
        dispout( padc( _KEY_ESC_CANCEL_F1, nWidth ) )
        setpos( nBottom, nLeft )
        dispout( padc( _KEY_F2_PGDN, nWidth ) )

        while .t.
            setcolor( COLOR_DEFAULT2 )
            scroll( nTop+1, nLeft, nBottom-2, nRight )

            setpos( nTop, nLeft )
            @row()+1,nLeft;
                say HTF_PROMPT_SOURCE_FILE
            @row()+1,nLeft;
                get cHtfSource;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| cHtfSource :=;
                    padr( Dir( cHtfSource,,,,.T. ),;
                        SPACE_LEN ) } );
                valid ( isFile( alltrim( cHtfSource ) ) )
            @row()+1,nLeft;
                say HTF_PROMPT_DESTINATION_FILE
            @row()+1,nLeft;
                get cHtfDestination;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid true( cHtfDestination :=;
                    iif( cHtfDestination <> SPACE_STR,;
                    cHtfDestination,;
                    padr( strAddExtention(;
                    strCutExtention( cHtfSource ),;
                    _EXTENTION_DBF ),;
                    SPACE_LEN ) ) )
            @row()+1,nLeft;
                say HTF_PROMPT_INDEX_START
            @row()+1,nLeft;
                get cIndexStart;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid true( cIndexStart :=;
                    iif( cIndexStart <> SPACE_STR,;
                    cIndexStart,;
                    padr( HTF_INDEX_START, SPACE_LEN ) ) )
            @row()+1,nLeft;
                say HTF_PROMPT_INDEX_END
            @row()+1,nLeft;
                get cIndexEnd;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid true( cIndexEnd :=;
                    iif( cIndexEnd <> SPACE_STR,;
                    cIndexEnd,;
                    padr( HTF_INDEX_END, SPACE_LEN ) ) )
            @row()+1,nLeft;
                say HTF_PROMPT_POINTER_START
            @row()+1,nLeft;
                get cPointerStart;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid true( cPointerStart :=;
                    iif( cPointerStart <> SPACE_STR,;
                    cPointerStart,;
                    padr( HTF_POINTER_START, SPACE_LEN ) ) )
            @row()+1,nLeft;
                say HTF_PROMPT_POINTER_END
            @row()+1,nLeft;
                get cPointerEnd;
                picture "@s"+ltrim(str(nWidth))+"@";
                when trueSetkey( K_F2, {|| NIL } );
                valid true( cPointerEnd :=;
                    iif( cPointerEnd <> SPACE_STR,;
                    cPointerEnd,;
                    padr( HTF_POINTER_END, SPACE_LEN ) ) )
            read
            do case
            case lastkey() = K_ESC
                lGoOn := .F.
                exit
            case lastkey() = K_PGDN // choice confirmation
                // Verify to have correct data.
                if isFile( cHtfSource );
                    .and. !isWild( cHtfDestination );
                    .and. cIndexStart <> SPACE_STR;
                    .and. cIndexEnd <> SPACE_STR;
                    .and. cPointerStart <> SPACE_STR;
                    .and. cPointerEnd <> SPACE_STR
                    //
                    lGoOn := .T.
                    exit
                else
                    // Loop.
                end
            otherwise
                // Loop.
            end
        end

        // Delete window.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        // Restore Colors.
        setcolor( cOldColor )


        if lGoOn
            // Run htfGenerate
            htfGenerate( alltrim(cHtfSource),;
                alltrim(cHtfDestination),;
                alltrim(cIndexStart),;
                alltrim(cIndexEnd),;
                alltrim(cPointerStart),;
                alltrim(cPointerEnd))
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )

    return NIL

//----------------------------------------------------------------
static function htfGenerate( cHtfText, cDestName,;
    cIndexStart, cIndexEnd,;
    cPointerStart, cPointerEnd )
//
// htfGenerate( <cHtfText>, [<cDestName>],
//     [<cIndexStart>], [<cIndexEnd>],
//     [<cPointerStart>], [<cPointerEnd>] ) --> NIL
//
// <cHtfText>      the filename used as input.
// <cDestName>     the filename used as output.
// <cIndexStart>   the symbol used as index start.
// <cIndexEnd>     the symbol used as index end.
// <cPointerStart> the symbol used as pointer start.
// <cPointerEnd>   the symbol used as pointer end.
//
// This function generates a .dbf file to use as a kind of
// hypertext.
//

    local bOldErrorHandler
    local nOldSelect          := select()
    local cOldRdd             := rddsetdefault( _DEFAULT_RDD )

    local nIStart             := 0
    local nIEnd               := 0
    local nIStartLen          := 0
    local nIendLen            := 0
    local nPStart             := 0
    local nPEnd               := 0
    local nPStartLen          := 0
    local nPEndLen            := 0
    local cIndex              := ""
    local cPointer            := ""
    local axIndex             := {}
    local aStruct             := {}

    default cIndexStart       to HTF_INDEX_START
    default cIndexEnd         to HTF_INDEX_END
    default cPointerStart     to HTF_POINTER_START
    default cPointerEnd       to HTF_POINTER_END

    begin sequence

        if cHtfText == NIL
            //
            break
        end

        if valtype( cDestName ) == "C"
            cDestName :=;
                strAddExtention( cDestName, _EXTENTION_DBF )
        else
            cDestName :=;
                strAddExtention( strCutExtention( cHtfText ),;
                _EXTENTION_DBF )
        end

        // Check if the cHtfText exists
        if file( cHtfText )
            // Ok.
        else
            alert( cHtfText + ";" +;
                _ERROR_NO_FILE )
            break
        end

        nIStartLen := len( cIndexStart )
        nIEndLen   := len( cIndexEnd )
        nPStartLen := len( cPointerStart )
        nPEndLen   := len( cPointerEnd )

        // Check if the destination file already exists.
        if file( cDestName )
            if alert( cDestName + ";" +;
                _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE,;
                { _MENU_NO, _MENU_YES } ) == 1
                //
                break
            end
        end

        // The destination file is created.
        aadd( aStruct, { "TEXT", "C", 80, 0 } )
        aadd( aStruct, { "POINTER", "N", 8, 0 } )

        dbcreate( cDestName, aStruct )
        dbusearea( .T., NIL, cDestName,;
            "HlpTxtFile" )

        // Data transfer.
        waitFor( HTF_WAIT_APPENDING + alltrim( cHtfText ) )
        append from (cHtfText) SDF

        // Find indexes.
	waitFor( HTF_WAIT_SEARCHING_INDEXES )
        HlpTxtFile->(dbgotop())
        while !eof()
            // There may be only one index per line.
            HlpTxtFile->(waitFileEval())
            nIStart := at( cIndexStart, HlpTxtFile->Text )
            if nIStart > 0
                nIStart += nIStartLen
                nIEnd :=  at( cIndexEnd,;
                    substr( HlpTxtFile->Text, nIStart ) )
                if nIEnd > 0
                    cIndex := substr( HlpTxtFile->Text,;
                        nIStart, nIEnd-1)
                    cIndex := upper( alltrim( cIndex ) )
                    aadd( axIndex, { cIndex, recno() } )
                end
            end
            HlpTxtFile->(dbskip())
        end

        // Close Wait bar.
        waitFileEval( .T. )

        // Find pointers.
	waitFor( HTF_WAIT_SEARCHING_POINTERS )
        HlpTxtFile->(dbgotop())
        while !eof()
            // There may be only one pointer per line.
            HlpTxtFile->(waitFileEval())
            nPStart := at( cPointerStart, HlpTxtFile->Text )
            if nPStart > 0
                nPStart += nPStartLen
                nPEnd := at( cPointerEnd,;
                    substr( HlpTxtFile->Text, nPStart ) )
                if nPEnd > 0
                    cPointer := substr( HlpTxtFile->Text,;
                        nPStart, nPEnd-1 )
                    cPointer := upper( alltrim( cPointer ) )    
                    aeval( axIndex,;
                        { |aValue, nIndex|;
                        iif( aValue[1] == cPointer,;
                        HlpTxtFile->Pointer := aValue[2], NIL) } )
                end
            end
            HlpTxtFile->(dbskip())
        end

        // Close Wait.
        waitFor()
        waitFileEval( .T. )

        // Close file
        HlpTxtFile->(dbclosearea())

    end sequence

    // Restore.
    rddsetdefault( cOldRdd )
    select( nOldSelect )

    return NIL

#endif
//================================================================
// IS - TEST FUNCTIONS
//================================================================
function isFile( cName )
//
// isFile( <cName> ) --> lIsFilePresent
//
// <cName>  the name to check for existance.
//
// The function returns true (.T.) if it finds the file.
// Before it checks for wild characters "*" or "?".
//

    if "*" $ cName .or. "?" $ cName
        return .F.
    end
    if !file( alltrim( cName ) )
        return .F.
    end
    
    // If we are here, the file exists and it is not undefined.
    return .T.

//================================================================
function isWild( cName )
//
// isWild( <cName> ) --> lIsWild
//
// <cName>  the name to check for wild characters.
//
// The function returns true (.T.) if it finds "*" or "?"
// inside the given string.
//

    if "*" $ cName .or. "?" $ cName
        return .T.
    end
    
    return .f.
//================================================================
function isMemvar( cName )
//
// isMemvar( <cName> ) --> lIsMemvar
//
// <cName>  the memvar name to check for existance.
//
// The function returns true (.T.) if it finds a memvar with the
// name contained inside <cName>.
//

    local bSaveErrorHandler := errorblock( {|e| break(e)} )
    local dummy
    local lReturn := .F.
    
    begin sequence
        dummy := memvar->&(cName)
        lReturn := .T.
    recover
        lReturn := .F.
    end sequence
    bSaveErrorHandler := errorblock( bSaveErrorHandler )
    
    return lReturn

//================================================================
function isConsoleOn()
//
// isConsoleOn() --> lConsoleIsOn
//
// The function return true if qout() and qqout() print to the
// console.
//

    if set( _SET_CONSOLE );
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "CON");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "CON.TXT")
        //
        return .T.
    end

    return .F.
        
//================================================================
function isPrinterOn()
//
// isPrinterOn() --> lPrinterIsOn
//
// The function return true if qout() and qqout() print to a
// printer.
//

    if set( _SET_PRINTER );
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "PRN");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "PRN.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT1");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT1.TXT")
        /*
            ;
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT2");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT2.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT3");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT3.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT4");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT4.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT5");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT5.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT6");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT6.TXT");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT7");
        .or. (set( _SET_ALTERNATE );
            .and. upper( set( _SET_ALTFILE ) ) == "LPT7.TXT")
        */
        //
        return .T.
    end

    return .F.
        
//================================================================
// LIST - POP UP LIST FUNCTIONS
//================================================================
function listWindow(;
    acMenuItem, cDescription,;
    nTop, nLeft, nBottom, nRight,;
    cColorTop, cColorBody;
    )
//
// listWindow(
//    <acMenuItem>, [<cDescription>],
//    [<nTop>], [<nLeft>], [<nBottom>], [<nRight>],
//    [<cColorTop>], [<cColorBody>] ) --> nPosition
//
// <acMenuItem>     is the character array containing the list
//                  of choices.
// <cDescription>   is the header to be shown at the top
//                  window.
// <nTop>, <nLeft>, <nBottom>, <nRight> are the window
//                  coordinates.
// <cColorTop>      is the color to use for window header
//                  and footer.
// <cColorBody>     is the color to use for the window body
//                  that is the space where the text appears.
//
// This function is an similar to achoice(), but it shows a
// header and footer, and it saves the screen, acting like a
// window.
//

    local cOldColor     := setcolor()
    local cOldScreen
    local nSetCursor    := setcursor ( SC_NORMAL )
    local bOld_F1       :=;
        setkey( K_F1, { || Text( LIST_WINDOW_HELP )} )
    local nOldRow       := row()
    local nOldCol       := col()
    local nChoice       := 0

    default cDescription    to "Select"
    default nTop            to 0
    default nLeft           to 0
    default nBottom         to maxrow()
    default nRight          to maxcol()
    default cColorTop       to COLOR_DEFAULT1
    default cColorBody      to COLOR_DEFAULT2

    cOldScreen    :=;
        savescreen( nTop, nLeft, nBottom, nRight )

    scroll( nTop, nLeft, nBottom, nRight )
    setcolor( cColorTop )
    setpos( nTop, nLeft)
    dispout( padc( cDescription, nRight-nLeft+1 ) )
    setpos( nBottom, nLeft )
    dispout( padc( LIST_WINDOW_BOTTOM, nRight-nLeft+1 ) )
    setcolor( cColorBody )
    dispbox( nTop, nLeft, nBottom, nLeft, 2 )
    dispbox( nTop, nRight, nBottom, nRight, 2 )

    nChoice := achoice(;
        nTop+1, nLeft+1, nBottom-1, nRight-1,;
        acMenuItem )

    // Restore.
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setcursor ( nSetCursor )
    setcolor( cOldColor )
    setkey( K_F1, bOld_F1 )
    setpos( nOldRow, nOldCol )

    return nChoice

//================================================================
// MEMO - MEMO FUNCTIONS
//================================================================
function memoWindow(;
    cVar, cDescription,;
    nTop, nLeft, nBottom, nRight,;
    cColorTop, cColorBody,;
    lEditMode, nLineLength, nTabSize )
//
// memoWindow(
//    <cVar>, [<cDescription>],
//    [<nTop>], [<nLeft>], [<nBottom>], [<nRight>],
//    [<cColorTop>], [<cColorBody>],
//    [<lEditMode>], [<nLineLength>], [<nTabSize>] ) --> cVar
//
// <cVar>           is the character field (variable) to be
//                  edited.
// <cDescription>   is the header to be shown at the top
//                  window.
// <nTop>, <nLeft>, <nBottom>, <nRight> are the window
//                  coordinates.
// <cColorTop>      is the color to use for window header
//                  and footer.
// <cColorBody>     is the color to use for the window body
//                  that is the space where the text appears.
// <lEditMode>      is equivalent to memoedit().
// <nLineLenght>    is equivalent to memoedit().
// <nTabSize>       is equivalent to memoedit().
//
// This function lets you easyly edit a long character field
// (memo) defining automatically a simple window and providing
// a simple help.
//
//

    local cOldColor     := setcolor()
    local cOldScreen
    local nSetCursor    := setcursor ( SC_NORMAL )
    local bOld_F1           :=;
        setkey( K_F1, { || Text( MEMO_WINDOW_HELP )} )
    local nOldRow       := row()
    local nOldCol       := col()

    default cDescription    to "Edit long character field"
    default nTop            to 0
    default nLeft           to 0
    default nBottom         to maxrow()
    default nRight          to maxcol()
    default cColorTop       to COLOR_DEFAULT1
    default cColorBody      to COLOR_DEFAULT2

    cOldScreen    :=;
        savescreen( nTop, nLeft, nBottom, nRight )

    scroll( nTop, nLeft, nBottom, nRight )
    setcolor( cColorTop )
    setpos( nTop, nLeft)
    dispout( padc( cDescription, nRight-nLeft+1 ) )
    setpos( nBottom, nLeft )
    dispout( padc( MEMO_WINDOW_BOTTOM, nRight-nLeft+1 ) )
    setcolor( cColorBody )
    dispbox( nTop, nLeft, nBottom, nLeft, 2 )
    dispbox( nTop, nRight, nBottom, nRight, 2 )

    cVar := memoedit(;
        cVar,;
        nTop+1, nLeft+1, nBottom-1, nRight-1,;
        lEditMode, NIL, , nLineLength, nTabSize )

    // Restore.
    restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
    setcursor ( nSetCursor )
    setcolor( cOldColor )
    setkey( K_F1, bOld_F1 )
    setpos( nOldRow, nOldCol )
    
    return cVar

//================================================================
// MESSAGE - MESSAGING FUNCTIONS
//================================================================
function messageLine( cMessage, cColor, nPosTop, nPosLeft )
//
// messageLine( [<cMessage>], [<cColor>] ) --> NIL
//
// Message line appearing near the cursor position.
//

    local getlist           := {}
    local cOldColor         := setcolor()
    local nOldRow           := row()
    local nOldCol           := col()

    local nWidth

    static cOldScreen
    static nTop
    static nLeft
    static nBottom
    static nRight

    default cColor          to COLOR_DEFAULT1

    do case
    case cMessage == NIL;
        .and. cOldScreen == NIL
        // Nothing to be closed.
        return NIL
    case cMessage == NIL;
        .and. cOldScreen <> NIL
        // Close previous line.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        cOldScreen := NIL
        return NIL
    case cMessage <> NIL;
        .and. cOldScreen == NIL
        // New Message Line.
    case cMessage <> NIL;
        .and. cOldScreen <> NIL
        // Close previous line.
        restscreen( nTop, nLeft, nBottom, nRight, cOldScreen )
        cOldScreen := NIL
    end
    

    begin sequence

        // Prepare cMessage.
        cMessage := alltrim(cMessage)
        nWidth := len( cMessage )
        do case
        case nWidth == 0
            break
        case nWidth > maxcol()+1
            nWidth := maxcol()+1
            cMessage := left( cMessage, nWidth )
        end


        // Create a kind of window.
        if nPosTop <> NIL
            nTop    := nPosTop
        else
            nTop    := row()  // At the same cursor pos.
        end
        if nPosLeft <> NIL
            nLeft := nPosLeft
        else
            nLeft   := col()
        end
        nBottom := nTop
        if nBottom > maxrow()
            nBottom := maxrow() -1
            nTop    := nBottom
        end
        
        nRight  := nLeft+nWidth-1
        
        if nRight > maxcol()
            nRight := maxcol()
            nLeft  := nRight -nWidth+1
        end

        cOldScreen    :=;
            savescreen( nTop, nLeft, nBottom, nRight )

        setcolor( cColor )
        setpos( nTop, nLeft)
        dispout( cMessage )

    end sequence

    setpos( nOldRow, nOldCol )
    setcolor( cOldColor )
    
    return NIL

//================================================================
// RF - REPORT FORM ALTERNATIVE
//================================================================
function rf(;
    cFrmName,;
    bForCondition,;
    bWhileCondition,;
    nNext,;
    nRecord,;
    lRest,;
    lPlain,;
    cHeading,;
    lBEject,;
    lSummary,;
    lDate,;
    acExtra;
    )
//
// rf( <cFRMName>,
//      [<bForCondition>],
//      [<bWhileCondition>],
//      [<nNext>],
//      [<nRecord>],
//      [<lRest>],
//      [<lPlain>],
//      [<cHeading>],
//      [<lBeforeEject>],
//      [<lSummary>],
//      [<lDate>],
//      [<acExtra>] )
//
// <cFRMName>           the form (.FRM) file to use to
//                      print the active Alias.
// <bForCondition>      code block for the FOR condition.
// <bWhileCondition>    code block for the WHILE condition.
// <nNext>              see REPORT FORM.
// <nRecord>            see REPORT FORM.
// <lRest>              see REPORT FORM.
// <lPlain>             if true (.T.), force the print
//                      in a simple way.
// <cHeading>           additional header in character or
//                      code block form.
//                      If a code block is sent, the final
//                      result must be a character string.
// <lBeforeEject>       if true (.T.), force a form feed
//                      before the print.
// <lSummary>           if true (.T.), force a summary print only.
// <lDate>              if false (.F.), force the print without
//                      date at the top of page.
// <acExtra>            a character array that may be used for
//                      translating standard printed report form
//                      words and to add vertical and horizontal
//                      separations. The default value of acExtra
//                      is:	
//                      acExtra[1]  "Page No."	
//                      acExtra[2]  "** Subtotal **"	
//                      acExtra[3]  "* Subsubtotal *"	
//                      acExtra[4]  "*** Total ***"	
//                      acExtra[5]  " "     vertical column	
//                                          separation	
//                      axExtra[6]  ""      horizontal	
//                                          separation: no	
//                                          separation.
//
// This function does the same work of REPORT FORM or __ReportForm
// or dbReportForm, but it prints where qout() and qqout() print.
//

    local nCol
    local nGroup
    local xBreakVal
    local lBroke        := .F.
    local err

    local lAnyTotals
    local lAnySubTotals

    local aRepData
    local nPageNum          //@
    local nLinesLeft        //@
    local aReportTotals     //@
    local aGroupTotals      //@
    local lFirstPass        //@
    local nMaxLinesAvail

    local cLineSeparation := ""

    // Resolve parameters
    if valtype( cFRMName ) == "C"
        cFRMName := strAddExtention( cFRMName, _EXTENTION_FORM )
    else
        err             := ErrorNew()
        err:severity    := ES_ERROR
        err:genCode     := EG_ARG
        err:subSystem   := "FRMLBL"
        eval(ErrorBlock(), err)
    end

    default bForCondition       to {||.T.}
    default bWhileCondition     to {||.T.}
    default nNext               to NIL
    default nRecord             to NIL
    default lRest               to .F.
    default lPlain              to .F.
    default cHeading            to ""
    default lBEject             to .F.
    default lSummary            to .F.
    default lDate               to .T.
    default acExtra             to {;
        "Page No.",;
        "** Subtotal **",;
        "* Subsubtotal *",;
        "*** Total ***",;
        " ",;
        "";
        }


    begin sequence

        // Load the frm into an array
        aRepData := __FrmLoad( cFRMName )

        nMaxLinesAvail := aRepData[RF_P_LINES]

        // Modify aRepData based on the report parameters
        if lSummary == .T.
            // Set the summary only flag
            aRepData[RF_P_SUMMARY] := lSummary
        end

        if lBEject == .T.
            aRepData[RF_P_BEJECT]  := .T.
        end
        

        if lPlain
            // Set plain report flag.
            aRepData[RF_P_PLAIN]    := .T.
            cHeading                := ""
        else
            // Create the horizontal separation line.
            if !(acExtra[RF_MSG_LINESEP] == "")
                for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                    cLineSeparation +=;
                        replicate( acExtra[RF_MSG_LINESEP],;
                            aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH] )
                    if nCol > 1
                        cLineSeparation +=;
                            acExtra[RF_MSG_LINESEP]
                    end
                next
            end
        end

        aRepData[ RF_P_HEADING ]  := cHeading

        nPageNum := 1              // Set the initial page number
        lFirstPass  := .T.         // Set the first pass flag

        nLinesLeft  := aRepData[ RF_P_LINES ]

        // Check to see if a "before report" eject,
        // or TO FILE has been specified
        if aRepData[RF_P_BEJECT]
            // Eject Page
            if !aRepData[RF_P_PLAIN]
                qqout( FF )
            end
        end

        // Generate the initial report header manually
        // (in case there are no
        // records that match the report scope)
        rfReportHeader(;
            aRepData,;
            @aReportTotals,;
            @aGroupTotals,;
            @nPageNum,;
            @nLinesLeft,;
            @nMaxLinesAvail,;
            acExtra,;
            lDate,;
            cLineSeparation;
            )

        // Initialize aReportTotals to track both
        // group and report totals, then
        // set the column total elements to 0
        // if they are to be totaled, otherwise
        // leave them NIL.
        aReportTotals :=;
            array(;
                len(aRepData[RF_P_GROUPS]) + 1,;
                len(aRepData[RF_P_COLUMNS]);
                )

        // Column total elements
        for nCol := 1 to len(aRepData[RF_P_COLUMNS])
            if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                for nGroup := 1 to len(aReportTotals)
                    aReportTotals[nGroup,nCol] := 0
                next
            end
        next

        // Initialize aGroupTotals as an array.
        aGroupTotals := ARRAY( LEN(aRepData[RF_P_GROUPS]) )

        // Execute the actual report based on matching records
        dbEval(;
            { ||;
                rfExecuteReport(;
                    aRepData,;
                    @aReportTotals,;
                    @aGroupTotals,;
                    @nPageNum,;
                    @lFirstPass,;
                    @nLinesLeft,;
                    @nMaxLinesAvail,;
                    acExtra,;
                    lDate,;
                    cLineSeparation;
                    );
                },;
            bForCondition,;
            bWhileCondition,;
            nNext,;
            nRecord,;
            lRest;
            )

        // Generate any totals that may have been identified
        // Make a pass through all the groups
        for nGroup := len(aRepData[RF_P_GROUPS]) to 1 step -1
            // Make sure group has subtotals.
            lAnySubTotals := .F.
            for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                    lAnySubTotals := .T.
                    exit
                end
            next

            if !lAnySubTotals
                loop
            end

            // Check to see if we need to eject the page
            if nLinesLeft < 2
                if aRepData[ RF_P_PLAIN ]
                    nLinesLeft := 1000
                else
                    // Eject Page.
                    qqout( FF )
                    // Print header.
                    rfReportHeader(;
                        aRepData,;
                        @aReportTotals,;
                        @aGroupTotals,;
                        @nPageNum,;
                        @nLinesLeft,;
                        @nMaxLinesAvail,;
                        acExtra,;
                        lDate,;
                        cLineSeparation;
                        )

                end
            end

            // Print the first line
            rfPrintIt(;
                space(aRepData[RF_P_LMARGIN]) + ;
                iif(;
                    nGroup==1,;
                    acExtra[RF_MSG_SUBTOTAL],;
                    acExtra[RF_MSG_SUBSUBTOTAL];
                    );
                )

            // Print the second line
            qqout( space(aRepData[RF_P_LMARGIN]) )
            for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                if nCol > 1
                    qqout( " " )
                end
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                    qqout(;
                        transform( aReportTotals[nGroup+1,nCol],;
                        aRepData[RF_P_COLUMNS,nCol,RF_C_PICT]);
                        )
                else
                    qqout(;
                        space(;
                            aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH];
                            );
                        )
                end
            next

            // Send a cr/lf for the last line
            qout()

        next

        // Any report totals?
        lAnyTotals := .F.
        for nCol := 1 to len(aRepData[RF_P_COLUMNS])
            if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                lAnyTotals := .T.
                exit
            end
        next nCol

        if lAnyTotals

            // Check to see if we need to eject the page
            if nLinesLeft < 2
                if aRepData[ RF_P_PLAIN ]
                    nLinesLeft := 1000
                else
                    // Eject page.
                    qqout( FF )
                    // Print header.
                    ReportHeader()
                end
            end

            // Print the first line
            rfPrintIt(;
                space(aRepData[RF_P_LMARGIN]);
                    + acExtra[RF_MSG_TOTAL];
                )

            // Print the second line
            qqout( space(aRepData[RF_P_LMARGIN]) )
            for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                if nCol > 1
                    qqout( " " )
                end
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                    qqout( transform(aReportTotals[1,nCol], ;
                    aRepData[RF_P_COLUMNS,nCol,RF_C_PICT]) )
                else
                qqout(;
                    space(aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH]);
                    )
            end
        next nCol

        // Send a cr/lf for the last line
        qout()

        end

        // Check to see if an "after report" eject,
        // or TO FILE has been specified.
        if aRepData[RF_P_AEJECT]
            // Eject Page
            if !aRepData[RF_P_PLAIN]
                qqout( FF )
            end
        end

    recover using xBreakVal
       lBroke := .T.
    end sequence

    if lBroke
        // keep the break value going
        break xBreakVal
    end

    return NIL

//----------------------------------------------------------------
static function rfExecuteReport(;
    aRepData,;
    aReportTotals,;
    aGroupTotals,;
    nPageNum,;
    lFirstPass,;
    nLinesLeft,;
    nMaxLinesAvail,;
    acExtra,;
    lDate,;
    cLineSeparation;
    )

    local aRecordHeader  := {}
    local aRecordToPrint := {}
    local nCol
    local nGroup
    local lGroupChanged  := .F.
    local lEjectGrp := .F.
    local nMaxLines
    local nLine
    local cLine
    local nLastElement

    local lAnySubTotals

    // Add to the main column totals
    for nCol := 1 to len(aRepData[RF_P_COLUMNS])
        if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
            // If this column should be totaled, do it.
            aReportTotals[ 1 ,nCol] += ;
                eval( aRepData[RF_P_COLUMNS,nCol,RF_C_EXP] )
        end
    next

    // Determine if any of the groups have changed.
    // If so, add the appropriate 
    // line to aRecordHeader for totaling out the previous records
    if !lFirstPass
        // Don't bother first time through

        // Make a pass through all the groups
        for nGroup := len(aRepData[RF_P_GROUPS]) to 1 step -1

            // Make sure group has subtotals.
            lAnySubTotals := .F.
            for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                    lAnySubTotals := .T.
                    exit
                end
            next


            // retrieve group eject state from report form
            if ( nGroup == 1 )
                lEjectGrp :=;
                    aRepData[RF_P_GROUPS,nGroup,RF_G_AEJECT]
            end

            if !lAnySubTotals
                loop
            end

            // For subgroup processing: check if group
            // has been changed.
            if strXToString( eval(aRepData[RF_P_GROUPS, 1, RF_G_EXP]),;
                aRepData[RF_P_GROUPS, 1, RF_G_TYPE]);
                    <> aGroupTotals[1]
                //
                lGroupChanged  := .T.
            end

            // If this (sub)group has changed since the last record.
            if lGroupChanged;
                .or. strXToString( eval( aRepData[RF_P_GROUPS, nGroup, RF_G_EXP]),;
                 aRepData[RF_P_GROUPS,nGroup,RF_G_TYPE]) != aGroupTotals[nGroup]

                 aadd(;
                    aRecordHeader,;
                    iif( nGroup==1,;
                        acExtra[RF_MSG_SUBTOTAL],;
                        acExtra[RF_MSG_SUBSUBTOTAL];
                        );
                    )
                 aadd( aRecordHeader, "" )

                 // Cycle through the columns, adding either
                 // the group amount from aReportTotals or
                 // spaces wide enough for the non-totaled columns.
                 for nCol := 1 to len(aRepData[RF_P_COLUMNS])
                     if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
                         aRecordHeader[ LEN(aRecordHeader) ] += ;
                             transform(;
                                 aReportTotals[nGroup+1,nCol],;
                                 aRepData[RF_P_COLUMNS,nCol,RF_C_PICT];
                                 )
                         // Zero out the group totals column from
                         // aReportTotals.
                         aReportTotals[nGroup+1,nCol] := 0
                     else
                         aRecordHeader[ len(aRecordHeader) ] += ;
                             space(aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH])
                     end
                     aRecordHeader[ LEN(aRecordHeader) ];
                        += " "
                 next

                 // Get rid of the extra space from the last column
                 aRecordHeader[len(aRecordHeader)] := ;
                     left( aRecordHeader[len(aRecordHeader)], ;
                     len(aRecordHeader[len(aRecordHeader)]) - 1 )
            end
        next

    end

    if (len( aRecordHeader ) > 0);
        .and. lEjectGrp;
        .and. lGroupChanged
        //
        if len( aRecordHeader ) > nLinesLeft

            if (aRepData[RF_P_PLAIN])
                nLinesLeft := 1000
            else
                // Eject Page.
                qqout( FF )
                // Print header.
                rfReportHeader(;
                    aRepData,;
                    @aReportTotals,;
                    @aGroupTotals,;
                    @nPageNum,;
                    @nLinesLeft,;
                    @nMaxLinesAvail,;
                    acExtra,;
                    lDate,;
                    cLineSeparation;
                    )

            end

        end

        aeval( aRecordHeader, { |HeaderLine| ;
            rfPrintIt( space( aRepData[ RF_P_LMARGIN ] ) +;
                HeaderLine ) } )

            aRecordHeader := {}

            if ( aRepData[RF_P_PLAIN] )
                nLinesLeft := 1000
            else
                // Eject Page.
                qqout( FF )
                // Print header.
                rfReportHeader(;
                    aRepData,;
                    @aReportTotals,;
                    @aGroupTotals,;
                    @nPageNum,;
                    @nLinesLeft,;
                    @nMaxLinesAvail,;
                    acExtra,;
                    lDate,;
                    cLineSeparation;
                    )

           end

       end

       // Add to aRecordHeader in the event that the group
       // has changed and new group headers need to be generated.

       // Cycle through the groups.
       for nGroup := 1 to len(aRepData[RF_P_GROUPS])
           // If the group has changed.
           if strXToString(;
               eval(aRepData[RF_P_GROUPS,nGroup,RF_G_EXP]),;
                  aRepData[RF_P_GROUPS,nGroup,RF_G_TYPE]) ==;
                      aGroupTotals[nGroup]
            else
                // Add a blank line before a new group.
                aadd( aRecordHeader, "" )
                // page eject after group
                //  put CRFF after group
                if nGroup == 1;
                    .and. !lFirstPass;
                    .and. !lAnySubTotals
                    //
                    if lEjectGrp :=;
                        aRepData[RF_P_GROUPS,nGroup,RF_G_AEJECT]
                        //
                        nLinesLeft  := 0
                    end
                end

                aadd(;
                    aRecordHeader,;
                    rtrim(;
                        aRepData[RF_P_GROUPS,nGroup,RF_G_HEADER];
                        ) + " ";
                    + strXToString(;
                        eval(;
                            aRepData[RF_P_GROUPS,nGroup,RF_G_EXP];
                            ),;
                        aRepData[RF_P_GROUPS,nGroup,RF_G_TYPE];
                        );
                    )
                // Add line separation
                if !(cLineSeparation == "")
                    aadd( aRecordHeader, cLineSeparation )
                end
            end
        next

        lFirstPass := .F.

        // Is there anything in the record header?
        if len( aRecordHeader ) > 0
            // Determine if aRecordHeader will fit
            // on the current page.  If not,
            // start a new header.
            if len( aRecordHeader ) > nLinesLeft

                if aRepData[RF_P_PLAIN]
                    nLinesLeft := 1000
                else
                    // Eject Page.
                    qqout( FF )
                    // Print header.
                    rfReportHeader(;
                        aRepData,;
                        @aReportTotals,;
                        @aGroupTotals,;
                        @nPageNum,;
                        @nLinesLeft,;
                        @nMaxLinesAvail,;
                        acExtra,;
                        lDate,;
                        cLineSeparation;
                        )
                end
            end

            // Send aRecordHeader to the output device,
            // resetting nLinesLeft.
            aeval( aRecordHeader, { |HeaderLine| ;
                rfPrintIt( space(aRepData[RF_P_LMARGIN]) +;
                    HeaderLine ) } )

            nLinesLeft -= len( aRecordHeader )

            // Make sure it didn't hit the bottom margin.
            if nLinesLeft == 0

                if aRepData[RF_P_PLAIN]
                    nLinesLeft := 1000
                else
                    // Eject Page.
                    qqout( FF )
                    // Print header.
                    rfReportHeader(;
                        aRepData,;
                        @aReportTotals,;
                        @aGroupTotals,;
                        @nPageNum,;
                        @nLinesLeft,;
                        @nMaxLinesAvail,;
                        acExtra,;
                        lDate,;
                        cLineSeparation;
                        )
            end
        end
    end

    // Add to the group totals.
    for nCol := 1 to len(aRepData[RF_P_COLUMNS])
        // If this column should be totaled, do it
        if aRepData[RF_P_COLUMNS,nCol,RF_C_TOTAL]
            // Cycle through the groups
            for nGroup := 1 to len( aReportTotals ) - 1
                aReportTotals[nGroup+1,nCol] += ;
                    eval( aRepData[RF_P_COLUMNS,nCol,RF_C_EXP] )
            next
        end
    next

    // Reset the group expressions in aGroupTotals
    for nGroup := 1 to len(aRepData[RF_P_GROUPS])
        aGroupTotals[nGroup] :=;
            strXToString(;
                eval(aRepData[RF_P_GROUPS,nGroup,RF_G_EXP]),;
                aRepData[RF_P_GROUPS,nGroup,RF_G_TYPE] )
    next

    // Only run through the record detail if this is NOT
    // a summary report.
    if !aRepData[ RF_P_SUMMARY ]
        // Determine the max number of lines needed
        // by each expression.
        nMaxLines := 1
        for nCol := 1 to len(aRepData[RF_P_COLUMNS])
            if aRepData[RF_P_COLUMNS,nCol,RF_C_TYPE] $ "M"
                nMaxLines :=;
                    max(;
                        mlcount(;
                            rtrim(;
                                eval( aRepData[RF_P_COLUMNS, nCol, RF_C_EXP]);
                                ),;
                            aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH];
                            ),;
                        nMaxLines )
            elseif aRepData[RF_P_COLUMNS,nCol,RF_C_TYPE] $ "C"
                nMaxLines :=;
                   max(;
                       mlcount(;
                           rtrim(;
                               strtran(;
                                   eval(;
                                       aRepData[RF_P_COLUMNS, nCol, RF_C_EXP];
                                       ),;
                                       ";",;
                                       NL(1);
                                   );
                               ),;
                           aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH]),;
                       nMaxLines )
            end
        next

        // Size aRecordToPrint to the maximum number of lines
        // it will need, then fill it with nulls.
        asize( aRecordToPrint, nMaxLines )
        afill( aRecordToPrint, "" )

        // Load the current record into aRecordToPrint.
        for nCol := 1 to len(aRepData[RF_P_COLUMNS])
            for nLine := 1 to nMaxLines
                // Check to see if it's a memo or character.
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TYPE] $ "CM"
                    // Load the current line of the current
                    // column into cLine with multi-lines
                    // per record ";"- method.
                    if aRepData[RF_P_COLUMNS,nCol,RF_C_TYPE] $ "C"
                        cLine :=;
                            memoline(;
                                rtrim(;
                                    strtran(;
                                        eval(;
                                            aRepData[RF_P_COLUMNS, nCol, RF_C_EXP];
                                            ),;
                                        ";", NL(1);
                                        );
                                    ),;
                                aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH],;
                                nLine;
                                )
                    else
                        cLine :=;
                            memoline(;
                                rtrim(;
                                    eval(;
                                        aRepData[RF_P_COLUMNS, nCol, RF_C_EXP];
                                        );
                                    ),;
                                aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH],;
                                nLine;
                                )
                    end
                    cLine :=;
                        padr( cLine, aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH] )
                else
                    if nLine == 1
                        cLine :=;
                            transform(;
                                eval(;
                                    aRepData[RF_P_COLUMNS, nCol, RF_C_EXP];
                                    ),;
                                aRepData[RF_P_COLUMNS,nCol,RF_C_PICT];
                                )
                        cLine := padr( cLine, aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH] )
                    else
                        cLine :=;
                            space(;
                                aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH];
                                )
                    end
                end

                // Add it to the existing report line
                if nCol > 1
                    aRecordToPrint[ nLine ] += acExtra[RF_MSG_COLSEP]
                end
                aRecordToPrint[ nLine ] += cLine
            next
        next

        // Add line separation
        if !(cLineSeparation == "")
            aadd( aRecordToPrint, cLineSeparation )
        end

        // Determine if aRecordToPrint will fit on the current page.
        if len( aRecordToPrint ) > nLinesLeft
            // The record will not fit on the current page.
            // Will it fit on a full page?
            // If not, break it up and print it.
            if len( aRecordToPrint ) > nMaxLinesAvail
                // This record is HUGE!  Break it up...
                nLine := 1
                while nLine < len( aRecordToPrint )
                    rfPrintIt( space(aRepData[RF_P_LMARGIN]) +;
                        aRecordToPrint[nLine] )
                    nLine++
                    nLinesLeft--
                    if nLinesLeft == 0

                        if aRepData[RF_P_PLAIN]
                            nLinesLeft := 1000
                        else
                        // Eject Page.
                        qqout( FF )
                        // Print header.
                            rfReportHeader(;
                                aRepData,;
                                @aReportTotals,;
                                @aGroupTotals,;
                                @nPageNum,;
                                @nLinesLeft,;
                                @nMaxLinesAvail,;
                                acExtra,;
                                lDate,;
                                cLineSeparation;
                                )
                        end
                    end
                end
            else

                if aRepData[RF_P_PLAIN]
                    nLinesLeft := 1000
                else
                    // Eject Page.
                    qqout( FF )
                    // Print header.
                    rfReportHeader(;
                        aRepData,;
                        @aReportTotals,;
                        @aGroupTotals,;
                        @nPageNum,;
                        @nLinesLeft,;
                        @nMaxLinesAvail,;
                        acExtra,;
                        lDate,;
                        cLineSeparation;
                        )
                end
                aeval(;
                    aRecordToPrint,;
                    { |RecordLine| ;
                        rfPrintIt(;
                            space(aRepData[RF_P_LMARGIN]) + RecordLine;
                            );
                        };
                    )
                nLinesLeft -= LEN( aRecordToPrint )
            end 
        else
            // Send aRecordToPrint to the output device,
            // resetting nLinesLeft.
            aeval(;
                aRecordToPrint, ;
                { |RecordLine| ;
                    rfPrintIt(;
                        space(aRepData[RF_P_LMARGIN]) + RecordLine );
                    };
                )
            nLinesLeft -= len( aRecordToPrint )
        end


        // Tack on the spacing for double/triple/etc.
        if aRepData[ RF_P_SPACING ] > 1
            //  Double space problem in REPORT FORM
            // at the bottom of the page.
            if nLinesLeft >= aRepData[ RF_P_SPACING ] - 1

                for nLine := 2 to aRepData[ RF_P_SPACING ]
                    rfPrintIt()
                    nLinesLeft--
                next
            end
        end

    end    // Was this a summary report?

    return NIL

//----------------------------------------------------------------
static function rfReportHeader(;
    aRepData,;
    aReportTotals,;
    aGroupTotals,;
    nPageNum,;
    nLinesLeft,;
    nMaxLinesAvail,;
    acExtra,;
    lDate,;
    cLineSeparation;
    )

    local nLinesInHeader := 0
    local aPageHeader    := {}
    local nHeadingLength :=;
        aRepData[RF_P_WIDTH] - aRepData[RF_P_LMARGIN] - 30

    local nCol
    local nLine
    local nMaxColLength
    local nGroup
    local cHeader
    local cPage
    local cDate
    local cTop
    local cMoreHeading

    local nHeadLine  // lines in a single heading
    local nRPageSize // width of report after subtracting right margin
    local aTempPgHeader        // temporary page header array
    local nHeadSize

    nRPageSize := aRepData[RF_P_WIDTH] - aRepData[RF_P_RMARGIN]

    //  Header width should be less then 255 characters.
    nHeadSize := min(nRPageSize, 254)

    // Create the header and drop it into aPageHeader

    // Start with the heading
    if !aRepData[RF_P_PLAIN]

        // If not a plain paper report, build.

        cPage :=;
            acExtra[RF_MSG_PAGENO] + " " + ltrim( str(nPageNum,6) )
        cDate := iif( lDate, dtoc( date() ), "" )
        cTop :=;
           padr(;
               cDate,;
               nHeadSize - len(cPage) - aRepData[RF_P_LMARGIN];
               );
           + cPage

        aadd( aPageHeader, cTop )

        // Test if the header is a code block.
        do case
        case valtype( aRepData[RF_P_HEADING] ) == "B"
            cMoreHeading := eval( aRepData[RF_P_HEADING] )
        case valtype( aRepData[RF_P_HEADING] ) == "C"
            cMoreHeading := aRepData[RF_P_HEADING]
        otherwise
            cMoreHeading := ""
        end

        if !empty( cMoreHeading )   // the heading
            aTempPgHeader :=;
                rfParseHeader( cMoreHeading, ;
            strOccurs( ";", cMoreHeading ) + 1 )
            for nLine := 1 to len( aTempPgHeader )
                // Determine number of lines in header given 
                // current report dimensions.
                nLinesInHeader :=;
                    max( mlcount(;
                        alltrim( aTempPgHeader[ nLine ] ),;
                        nHeadSize - aRepData[RF_P_LMARGIN] ), 1 )
                // extract lines and add to array
                for nHeadLine := 1 to nLinesInHeader
                    aadd(;
                        aPageHeader,;
                        padc(;
                            rtrim(;
                                memoline(;
                                    ltrim( aTempPgHeader[nLine] ),;
                                    nHeadSize - aRepData[RF_P_LMARGIN],;
                                    nHeadLine;
                                    );
                                ),;
                            nHeadSize - aRepData[RF_P_LMARGIN];
                            );
                        )
                next nHeadLine
            next nLine
        end

    end

    // Tack on the actual header from the FRM.
    for nLine := 1 to len( aRepData[RF_P_HEADER] )
        // Determine number of lines in header given current
        // report dimensions

        nLinesInHeader :=;
            max(;
                mlcount(;
                    alltrim( aRepData[RF_P_HEADER, nLine] ),;
                    nHeadSize - aRepData[RF_P_LMARGIN];
                    ),;
                1 )

        // Extract lines and add to array
        for nHeadLine := 1 to nLinesInHeader
            cHeader :=;
                rtrim(;
                    memoline(;
                        ltrim( aRepData[RF_P_HEADER, nLine] ),;
                        nHeadSize - aRepData[RF_P_LMARGIN], nHeadLine;
                        );
                    )
            aadd(;
                aPageHeader,;
                padc(;
                    cHeader,;
                    nHeadSize - aRepData[RF_P_LMARGIN], nHeadLine;
                    );
                )
        next nHeadLine

    next nLine

    // Add a blank line between the .FRM header
    // and the columns.
    aadd( aPageHeader, "" )

    // Now add the column headings.
    nLinesInHeader := len( aPageHeader )

    // Determine the longest column header
    nMaxColLength := 0
    for nCol := 1 to len( aRepData[ RF_P_COLUMNS ] )
        nMaxColLength :=;
            max(;
                len(aRepData[RF_P_COLUMNS,nCol,RF_C_HEADER]),;
                nMaxColLength;
                )
    next

    for nCol := 1 to len( aRepData[RF_P_COLUMNS] )
        asize( aRepData[RF_P_COLUMNS,nCol,RF_C_HEADER],;
            nMaxColLength )
    next

    for nLine := 1 to (nMaxColLength)
        aadd( aPageHeader, "" )
    next

    for nCol := 1 to len(aRepData[RF_P_COLUMNS])
        // Cycle through the columns
        for nLine := 1 to nMaxColLength
            if nCol > 1
                aPageHeader[ nLinesInHeader + nLine ];
                    += acExtra[RF_MSG_COLSEP]
            end
            if aRepData[RF_P_COLUMNS,nCol,RF_C_HEADER,nLine] == NIL
                aPageHeader[ nLinesInHeader + nLine ] += ;
                    space( aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH] )
            else
                if aRepData[RF_P_COLUMNS,nCol,RF_C_TYPE] == "N"
                    aPageHeader[ nLinesInHeader + nLine ] += ;
                        padl(;
                            aRepData[RF_P_COLUMNS, nCol, RF_C_HEADER, nLine],;
                            aRepData[RF_P_COLUMNS,nCol,RF_C_WIDTH];
                            )
                else
                    aPageHeader[ nLinesInHeader + nLine ] += ;
                           padr(;
                               aRepData[RF_P_COLUMNS, nCol, RF_C_HEADER, nLine],;
                               aRepData[RF_P_COLUMNS, nCol, RF_C_WIDTH];
                               )
                end
            end
        next
    next

    // Add line separation
    if !(cLineSeparation == "")
        aadd( aPageHeader, cLineSeparation )
    end

    // Insert the two blank lines between the heading
    // and the actual data. - I don't like it!
    //aadd( aPageHeader, "" )
    //aadd( aPageHeader, "" )

    aeval( aPageHeader, { | HeaderLine | ;
        rfPrintIt( space(aRepData[RF_P_LMARGIN])+ HeaderLine ) } )

    // Set the page number and number of available lines
    nPageNum++

    nLinesLeft := aRepData[RF_P_LINES] - len( aPageHeader )
    nMaxLinesAvail := aRepData[RF_P_LINES] - len( aPageHeader )

    return NIL

//----------------------------------------------------------------
static function rfPrintIt( cString )

    default cString to ""

    qqout( cString )
    qout()

    return NIL


//----------------------------------------------------------------
static function rfParseHeader( cHeaderString, nFields )

    local cItem
    local nItemCount := 0
    local aPageHeader := {}
    local nHeaderLen := 254
    local nPos

    while ( ++nItemCount <= nFields )

        cItem := substr( cHeaderString, 1, nHeaderLen )

        // check for explicit delimiter
        nPos := at( ";", cItem )

        if !empty( nPos )
            // delimiter present
            aadd( aPageHeader, substr( cItem, 1, nPos - 1 ) )
        else
            if empty( cItem )
                // empty string for S87 and 5.0 compatibility
                aadd( aPageHeader, "" )
            else
                // exception
                aadd( aPageHeader, cItem )
            end
            // empty or not, we jump past the field
            nPos := nHeaderLen
        end

        cHeaderString := substr( cHeaderString, nPos + 1 )

    end

    return( aPageHeader )

//================================================================
// RPT - FORMATTED TEXT PRINT
//================================================================
function rptMany( cText, bWhileCondition, bForCondition, cSymbol )
//
// rptMany( <cText>, [<bWhileCondition>], [<bForCondition>],
//          [<cSymbol>] ) --> NIL
//
// Prints with the nB report standard the text contained into
// <cText> for every record in the active Alias matching the
// conditions.
//
// <cText>              the text to print.
// <bWhileCondition>    code block WHILE condition for record
//                      to be included.
// <bForCondition>      code block FOR condition for record
//                      to be included.
// <cSymbol>            the symbol for print commands contained
//                      into the text file.
//

    default bWhileCondition to {|| .T. }
    default bForCondition   to {|| .T. }
    default cSymbol         to RPT_DEFAULT_COMMAND_SYMBOL

    // Check for active Alias.
    if alias() == "";
        // null string means no active alias
        //
        alert( _ERROR_NO_ALIAS )
        return NIL
    end

    // Start print until eof() is reached.
    dbgotop()
    while !eof() .and. eval(bWhileCondition)
        // Wait bar. waitFileEval() is not used
        // as it will not work in case of an indexex
        // file.
        waitFileEval()
        if eval(bForCondition)
            RPT( cText, NIL, NIL, NIL, SPACE_LEN, NIL, NIL,;
                cSymbol )
        end
        dbskip()
    end
    // Close wait bar.
    waitFileEval( .T. )
    dbgotop()

    return NIL

//================================================================
function rpt( cText, nTotalLines, lMain, lHeadFoot,;
              nLineLength, nTabSize, lWrap, cSymbol )
//
// rpt( <cText>, [<nTotalLines>], [<lMain>], [<lHeadFoot>],
//      [<nLineLength>], [<nTabSize>], [<lWrap>], [<cSymbol>] )
//      --> NIL
//
// Prints with the nB report standard the text contained into
// <cText> once.
//
// As this function is recursive, it is important to transfer the
// exact line dimention to the recursive call.
//
// <cText>              the text to be printed.
// <nTotalLines>        <cText> lines length, used with recursive
//                      call.
// <lMain>              true (.t.) means that it is the first
//                      call and not recursive. True is the
//                      default value.
// <lHeadFoot>          true (.t.) means that <cText> is a header
//                      or footer.
// <nLineLength>        the maximal line length.
// <nTabSize>           tab length.
// <lWrap>              true (.t.) means that the text will be
//                      wrapped if necessary.
// <cSymbol>            the prefix simbol for report commands.
//

    local nLine               := 0
    local cLine               := ""

    local cSubText            := ""
    local nSubTextLines       := 0
    local cCommand            := ""
    local cCondition          := ""
    local nParameter          := 0
    local cParameter          := ""
    local xParameter
    local nNeeded             := 0

    local nOldRow             := row()
    local nOldCol             := col()

    static nLPP
    static nPrintedLine
    static cHeader
    static nHeadLines
    static cFooter
    static nFootLines
    static cLeft
    static lNewPage

    // nLineLength must be set befor line count.
    default nLineLength  to SPACE_LEN
    
    default nTotalLines  to;
        mlcount( cText, nLineLength, nTabSize, lWrap )

    default lMain        to;
        .T. // main call for the entire document

    default lHeadFoot    to;
        .F. // if .T. it is a head or foot print

    default cSymbol      to RPT_DEFAULT_COMMAND_SYMBOL

    begin sequence

        // If it is the first call.
        if lMain == .T. .or. lMain == NIL
            // Static variable initialization.
            nLPP         := NIL
            nPrintedLine := NIL
            cHeader      := NIL
            nHeadLines   := NIL
            cFooter      := NIL
            nFootLines   := NIL
            cLeft        := NIL
            lNewPage     := NIL

        end

        // Static defaults.
        if nLPP == NIL
            nLPP := RPT_DEFAULT_LPP
        end
        if nPrintedLine == NIL
            nPrintedLine := 0
        end
        if cHeader == NIL
            cHeader := ""
        end
        if nHeadLines == NIL
            nHeadLines := 0
        end
        if cFooter == NIL
            cFooter := ""
        end
        if nFootLines == NIL
            nFootLines := 0
        end
        if cLeft == NIL
            cLeft := ""
        end
        if lNewPage   == NIL
            lNewPage := .T.
        end

        // If there are no more lines to print.
        if nTotalLines <= 0
            break
        end

        // Main loop.
        for nLine = 1 to nTotalLines

            // Line conuter correction.
            if nPrintedLine >= nLPP
                nPrintedLine := 0
            end

            // Remaining lines calculation.
            setRptLines( nLPP - nFootLines - nPrintedLines )

            // next line
            cLine :=;
                memoline( cText, nLineLength, nLine, nTabSize,;
                lWrap )

            // Line analisys.
            do case
            case upper( alltrim(cLine) ) = cSymbol+"REM"
                // Comment, the line is ignored.
            case upper( alltrim(cLine) ) = cSymbol+"COMMENT"
                // Comment, the line is ignored.
            case upper( alltrim(cLine) ) = cSymbol+"END"
                // If it appears here, it is an error,
                // the line is ignored.
                alert( RPT_ERROR_PRINT_ISOLATED_END )
            case upper( alltrim(cLine) ) = cSymbol+"COMMAND"
                // Start a command line.
                // The command lines are isolated.
                cCommand :=;
                    rptReadToEnd( cText, @nLine, NIL, nLineLength,;
                    nTabSize, lWrap, cSymbol )
                execute( cCommand, "REPORT COMMAND")
            case upper( alltrim(cLine) ) = cSymbol+"IF"
                cCondition :=;
                    alltrim( substr( ltrim(cLine),;
                    3+len(cSymbol) ) )
                cSubText :=;
                    rptReadToEnd( cText, @nLine, @nSubTextLines,;
                    nLineLength, nTabSize, lWrap, cSymbol )
                if cCondition == ""
                    // No condition.
                    alert( alltrim(cLine) + ";" +;
                         RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                    // Line ignored.
                else
                    if &(cCondition)
                        RPT( cSubText, nSubTextLines, .F., .F.,;
                            nLineLength, nTabSize, lWrap, cSymbol )
                    end
                end
            case upper( alltrim(cLine) ) = cSymbol+"WHILE"
                cCondition :=;
                    alltrim( substr( ltrim(cLine),;
                    6+len(cSymbol) ) )
                cSubText :=;
                    rptReadToEnd( cText, @nLine, @nSubTextLines,;
                    nLineLength, nTabSize, lWrap, cSymbol )
                if cCondition == ""
                    // No condition.
                else
                    while &(cCondition)
                        RPT( cSubText, nSubTextLines, .F., .F.,;
                            nLineLength, nTabSize, lWrap, cSymbol )
                    end
                end
            case upper( alltrim(cLine) ) = cSymbol+"DBSKIP"
                // dbskip()
                // the eof() and bof() check MUST be done inside
                // the document!!!
                cParameter :=;
                    alltrim( substr( ltrim(cLine),;
                        7+len(cSymbol) ) )
                if cParameter == ""
                    dbskip(+1)
                else
                    nParameter := &(cParameter)
                    dbskip( nParameter )
                end
            case upper( alltrim(cLine) ) = cSymbol+"LPP"
                // Lines per page.
                cParameter :=;
                    alltrim( substr( ltrim(cLine),;
                        4+len(cSymbol) ) )
                if cParameter == ""
                    alert( alltrim(cLine) + ";" +;
                         RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                    // Line ignored.
                else
                    nParameter := &(cParameter)
                    nLPP := nParameter
                end
            case upper( alltrim(cLine) ) = cSymbol+"PA"
                if (nPrintedLine > nHeadLines;
                    .and. nPrintedLine < nLPP)
                    // It is inside a page,
                    // than, the footer must be printed.
                    while nPrintedLine < (nLPP - nFootLines)
                        // Print an empty line each time.
                        RPT( NL(1), 1, .F., .F., nLineLength,;
                            nTabSize, lWrap, cSymbol )
                    end
                    // The footer should have been printed
                    // automatically.
                end
            case upper( alltrim(cLine) ) = cSymbol+"INSERT"
                cParameter :=;
                    alltrim( substr( ltrim(cLine),;
                    7+len(cSymbol) ) )
                if cParameter == ""
                    alert( alltrim(cLine) + ";" +;
                         RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                    // The line is ignored.
                else
                    // If the file exists (complete with 
                    // extention), it is included.
                    if file( cParameter )
                        RPT( memoread(cParameter), NIL, .F., NIL,;
                            SPACE_LEN, NIL, NIL, cSymbol )
                    else
                        alert( alltrim(cLine) + ";" +;
                            RPT_ERROR_PRINT_FILE_NOT_FOUND )
                    end
                end
            case upper( alltrim(cLine) ) = cSymbol+"NEED"
                cParameter :=;
                    alltrim( substr( ltrim(cLine),;
                    5+len(cSymbol) ) )
                if cParameter == ""
                    alert( alltrim(cLine) + ";" +;
                        RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                    // The line is ignored.
                else
                    nParameter := &(cParameter)
                    nNeeded := nParameter
                    if nPrintedLine + nNeeded > nLPP - nFootLines
                        // also when equal is ok
                        //
                        // Jump to next page.
                        RPT( cSymbol+"PA", 1, .F., .F.,;
                            nLineLength, nTabSize, lWrap, cSymbol )
                    end
                end
            case upper( alltrim(cLine) ) = cSymbol+"HEAD"
                cHeader :=;
                    rptReadToEnd( cText, @nLine, @nHeadLines,;
                        nLineLength, nTabSize, lWrap, cSymbol )
            case upper( alltrim(cLine) ) = cSymbol+"FOOT"
                cFooter :=;
                    rptReadToEnd( cText, @nLine, @nFootLines,;
                    nLineLength, nTabSize, lWrap, cSymbol )
            case upper( alltrim(cLine) ) = cSymbol+"LEFT"
                cParameter :=;
                    alltrim( substr( ltrim(cLine),;
                    5+len(cSymbol) ) )
                if cParameter == ""
                    alert( alltrim(cLine) + ";" +;
                        RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                    // The line is ignored.
                else
                    xParameter := &(cParameter)
                    do case
                        case valtype(xParameter) == "N" .and.;
                            xParameter >= 0
                            cLeft := space(xParameter)
                        case valtype(xParameter) == "C"
                            cLeft := xParameter
                         otherwise
                        alert( alltrim(cLine) + ";" +;
                            RPT_ERROR_PRINT_COMMAND_UNCOMPLETED )
                        // The line is ignored.
                    end
                end
            otherwise
                // Normal line to be printed.
                // Check if the head must be printed.
                if (nPrintedLine == 0) .and.;
                    !lHeadFoot
                    RPT( cHeader, nHeadLines, .F., .T.,;
                        nLineLength, nTabSize, lWrap, cSymbol )
                end
                // It prints the line deleting extra characters on
                // the right. The extra space (the line is ever 
                // SPACE_LEN long) will produce extra white lines 
                // on the printed text.
                qqout( rtrim( cLeft + RPTLineTrans(cLine) ) )
                qout("")
                // The printing interpretation may be long.
                waitWheel()
                nPrintedLine++
                // It checks if the footer must be printed.
                if (nPrintedLine >= ( nLPP - nFootLines ) );
                    .and. (lHeadFoot == .F.)
                    //
                    RPT( cFooter, nFootLines, .F., .T.,;
                        nLineLength, nTabSize, lWrap, cSymbol )
                    // After a footer there is ever a eject.
                    // The Eject command works only with printers
                    if setRptEject()
                        qqout( FF )  // form feed - chr(12)
                    end
                end
            end

        next

        if lMain; // main call
            .and. (nPrintedLine > 0 .and. nPrintedLine < nLPP)
                // in the middle of a page
            //
            // The footer must be printed.
            while nPrintedLine < (nLPP - nFootLines)
                // It prints an empty line.
                RPT( "", 1, .F., .F., nLineLength, nTabSize,;
                    lWrap, cSymbol )
            end
            // The footer should be automatically printed.
        end

    end sequence

    if lMain
        setpos( nOldRow, nOldCol )
    end

    return NIL

//================================================================
function rptTranslate( cText )
//
// rptTranslate( <cText> ) --> cTranslatedText
//
// This function translates the text <cText> if it contains
// variables delimited with  and .
//

    return rptLineTrans( cText )

//----------------------------------------------------------------
static function rptReadToEnd( cText, nLine, nLines,;
                              nLineLength, nTabSize,;
                              lWrap, cSymbol )
//
// --> cBlock
//
// Returns a block of lines from <cText>.
// The block is delimited with:
//      *...Command
//              ...
//              ...
//      *end
//

    local cLine  := ""
    local cBlock := ""
    local nStartLine := nLine
    local nSubLines := 0
    local lStart    := .T.

    while .T.
        nLine++
        cLine := memoline( cText, nLineLength, nLine, nTabSize, lWrap  )
        do case
        case cLine == "" // end of block
            exit
        case upper( alltrim(cLine) ) = cSymbol+"END"
            exit
        case upper( alltrim(cLine) ) = cSymbol+"COMMAND";
            .or. upper( alltrim(cLine) ) = cSymbol+"IF";
            .or. upper( alltrim(cLine) ) = cSymbol+"WHILE";
            .or. upper( alltrim(cLine) ) = cSymbol+"HEAD";
            .or. upper( alltrim(cLine) ) = cSymbol+"FOOT"
            // The next *END must be jumped as it don't belongs
            // to this level.
            if lStart
                // just started
                cBlock += rtrim(cLine)
            else
                cBlock += NL(1) + rtrim(cLine)
            end
            cBlock +=;
                NL(1) +;
                rptReadToEnd( cText, @nLine, @nSubLines,;
                nLineLength, nTabSize, lWrap, cSymbol ) +;
                    NL(1) + cSymbol+"END"
        otherwise
            if lStart
                // Just started.
                cBlock += rtrim(cLine)
            else
                cBlock += NL(1) + rtrim(cLine)
            end
        end
        lStart := .F.
    end

    // At now, nLine is pinted to *END

    // nLines must count only the content not the commands:
    // *... and *end.
    nLines := (nLine - nStartLine) -1

    // nLine and nLines are sent back
    return cBlock

//----------------------------------------------------------------
static function rptLineTrans( cLine )
//
// --> cTranslatedLine
//
// Translates the <cLine> content replacing what is into
//  and , using Memvars and Fields.
//
// This function is recursive.
//

    local bSaveErrorHandler
    local bSav2ErrorHandler
    local nPosLeft
    local nPosRight
    local cLineLeft
    local cLineCenter
    local cLineRight
    local cString
    local xContent


    nPosLeft := at( "", cLine )
    nPosRight := at( "", cLine )

    // if the line contains variables.
    do case
    case nPosLeft == 0 .and.;
         nPosRight == 0
        return cLine
    case nPosLeft == 0; // if here one of them is not zero
       .or. nPosRight == 0
        alert( RPT_ERROR_PARENTESES )
        return cLine
    end

    // A variable string exists.
    cString := substr( cLine, nPosLeft+1 )
    cString := substr( cString, 1, at( "", cString ) - 1 )
    cString := alltrim( cString )

    // Left side determination.
    cLineLeft := substr( cLine, 1, nPosLeft-1 )

    // Variable transfer.
    bSaveErrorHandler := errorblock( {|| break(NIL)} )
    begin sequence
        xContent := &(cString)
    recover
        // If the cString content is not recognised,
        // it generates an error.
        bSaveErrorHandler :=;
            errorblock( {|| break(NIL)} )  // good so
        begin sequence
            // Maybe, cString is a Memvar not jet defined.
            public &cString. := SPACE_STR
            &cString. :=;
                 alltrim( Accept( &cString.,;
                     "Insert " + cString ) )
            xContent := alltrim( &cString. )
        recover
            // But it wasn't a new variable.
            // Then, it is printed so as it is.
            xContent := "" + cString + ""
        end
        errorblock(bSav2ErrorHandler)

    end
    errorblock(bSaveErrorHandler)

    do case
    case valtype(xContent) == "C"
        cLineCenter := xContent     // without alltrim
    case valtype(xContent) == "N"
        cLineCenter := alltrim( str( xContent ) )
    case valtype(xContent) == "D"
        cLineCenter := dtoc( xContent )
    case valtype(xContent) == "M"
        cLineCenter := xContent     // without trim
    end

    // Right extraction with recursion.
    cLineRight := rptLineTrans( substr( cLine, nPosRight+1 ) )

    return cLineLeft + cLineCenter + cLineRight

//================================================================
// SET - SET FUNCTIONS
//================================================================
function setRptEject( lbEject )
//
// setRptEject( [<lbEject>] ) --> lPreviousEjectSet
//
// <lbEject>    logical or code block; if .t. it sets the eject
//              after the footer print with RPT() function.
//              Default is no change, starting value is .T..
//
// It sets the eject mode for the RPT() function.
//

    local  lPrevious
    static lEject

    if lEject == NIL
        lEject := .t.
    end

    lPrevious := lEject

    do case
    case lbEject == NIL
        // nil
    case valtype( lbEject ) == "L"
        lEject := lbEject
    case valtype( lbEject ) == "B"
        lEject := eval( lbEject )
    otherwise
        // nil
    end

    return lPrevious

//================================================================
function setRptLines( nLines )
//
// setRptLines( [<nLines>] ) --> nPreviousLines
//
// <nLines>     remaining lines: if given, it sets the
//              RPT() remaining line counter to the new value.
//              Default is no change.
//
// It sets the remaining line counter and returns the previous
// value.
//

    local  nPrevious := 0

    static nRemaining

    if nRemaining == NIL
        nRemaining := 0
    end

    nPrevious := nRemaining

    do case
    case nLines == NIL
        // nil
    case nLines >= 0
        nRemaining := nLines
    otherwise
        // nil
    end

    return nPrevious

//================================================================
function setOutput( caPeripheral )
//
//
// aOldOutput[1]    = _SET_CONSOLE
// aOldOutput[2]    = _SET_PRINTER
// aOldOutput[3]    = _SET_ALTERNATE
// aOldOutput[4]    = _SET_ALTFILE
// aOldOutput[5]    = _SET_EXTRA
// aOldOutput[6]    = _SET_EXTRAFILE
//

    local aOldOutput := {;
        .F.,;
        .F.,;
        .F.,;
        NIL,;
        .F.,;
        NIL;
        }

    local nLen

    if isConsoleOn()
        aOldOutput[1] := .T.
    end
    if isPrinterOn()
        aOldOutput[2] := .T.
    end
    if set( _SET_ALTERNATE )
        aOldOutput[3] := .T.
        aOldOutput[4] := set( _SET_ALTFILE )
    end
    if set( _SET_EXTRA )
        aOldOutput[5] := .T.
        aOldOutput[6] := set( _SET_EXTRAFILE )
    end
    
    do case
    case valtype( caPeripheral ) == "C"

        caPeripheral := upper( caPeripheral )
    
        do case
        case (caPeripheral == "CON");
            .or. (caPeripheral == "CON.TXT")
            set( _SET_ALTERNATE, .F.)
            set( _SET_PRINTER, "OFF" )
            set( _SET_CONSOLE, "ON" )
        case (caPeripheral == "PRN");
            .or. (caPeripheral == "PRN.TXT");
            .or. (caPeripheral == "LPT1");
            .or. (caPeripheral == "LPT1.TXT")
            set( _SET_ALTERNATE, .F.)
            set( _SET_PRINTER, "ON" )
            set( _SET_CONSOLE, "OFF" )
        otherwise
            set( _SET_CONSOLE, "OFF" )
            set( _SET_PRINTER, "OFF" )
            set( _SET_ALTERNATE, .T.)
            set( _SET_ALTFILE, caPeripheral, .T. )
        end
    case valtype( caPeripheral ) == "A"

        nLen := len( caPeripheral )
        
        if nLen > 0
            set( _SET_CONSOLE, caPeripheral[1] )
        end
        if nLen > 1
            set( _SET_PRINTER, caPeripheral[2] )
        end
        if nLen > 3
            set( _SET_ALTERNATE, caPeripheral[3] )
            set( _SET_ALTFILE, caPeripheral[4], .T. )
        end
        if nLen > 5
            set( _SET_EXTRA, caPeripheral[5] )
            set( _SET_EXTRAFILE, caPeripheral[6],  )
        end
    end

    return aOldOutput

//================================================================
// STR - STRING PATH/FILE NAME FUNCTIONS
//================================================================
function strOccurs( cSearch, cTarget )
//
// strOccurs( <cSearch>, <cTarget> ) --> nOccurrence
//
// <cSearch>        is the search string to find.
// <cTarget>        is the string to be searched for the
//                  presence of <cSearch>.
//
// The function returns the number of occurrence of <cSearch>
// inside <cTarget>.
//

    local nPos
    local nCount := 0

    do while !empty( cTarget )
        if (nPos := at( cSearch, cTarget )) != 0
            nCount++
            cTarget := substr( cTarget, nPos + 1 )
        else
            // End of string
            cTarget := ""
        end
    end

    return nCount

//================================================================
function strXToString( xVar, cType )
//
// strXToString( <xVar>, [<cType>] ) --> cTrasformed_to_string
//
// <xVar>   is the data of any type to be converted into string.
// <cType>  is the type of the data contained inside <xVar>.
//
// The function return <xVar> transformed into a character string.
//

    local cString

    default cType to valtype( xVar )

    cType := upper( cType )

    do case
    case cType == "D"
        cString := dtoc( xVar )
    case cType == "L"
        cString := iif( xVar, "T", "F" )
    case cType == "N"
        cString := str( xVar )
    case cType == "C"
        cString := xVar
    case cType == "M"
        cString := xVar
    case xVar == NIL
        cString := "NIL"
    otherwise
       cString := "*******"
    end

    return( cString )

//================================================================
function strTempPath()
//
// strTempPath() --> cTempPath
//
// The function tries to find if a temporary directory is defined
// with enviromental variables.
//

    local cTempPath := ""

    do case
    case getenv( "TEMP" ) == "" .and.;
         getenv( "TMP" ) == ""
        cTempPath := "."
    case !( getenv( "TEMP" ) == "" )
        cTempPath := getenv( "TEMP" )
    case !( getenv( "TMP" ) == "" )
        cTempPath := getenv( "TMP" )
    end

    return cTempPath

//================================================================
function strAddExtention( cName, cExt )
//
// StrAddExtention( <cName>, <cExt> ) --> cCompleteName
//
// <cName>      the filename or pathname without extention.
//
// <cExt>       the extention to be added.
//
// The function tries to add the extention <cExt> to <cName> if
// <cName> has no extention jet.
//

    local cLastFour
    local cNewName

    default cExt to ""

    cName := alltrim( cName )

    // Remove the extention point.
    if left( cExt, 1 ) == "."
        cExt := substr( cExt, 2 )
    end

    cLastFour := right( cName, 4 )

    if at( ".", cLastFour ) == 0 // there is no extention
        cNewName := cName + "." + cExt
    else
        cNewName := cName
    end

    return cNewName

//================================================================
function strCutExtention( cName )
//
// StrCutExtention( <cName> ) --> cName
//
// <cName>      the file name or pathname with extention.
//
// The funcion tries to cut the extention from <cName>.
//

    local cLastFour
    local cNewName

    cName := alltrim( cName )

    cLastFour := right( cName, 4 )

    if at( ".", cLastFour ) == 0 // there is no extention.
        cNewName := cName
    else
        cNewName := left( cName, rat( ".", cName )-1 )
    end

     return cNewName

//================================================================
function strDrive( cName )
//
// StrDrive( <cName> ) --> cDrive
//
// <cName>      the pathname where is to extract the drive.
//
// The function tries to extract the drive name from <cName>.
//

    local cDrive

    cName := ltrim( cName )

    if subst( cName, 2, 1 ) == ":"
        cDrive := left( cName, 2 )
    else
        cDrive := ""
    end

    return cDrive

//================================================================
function strExtention( cName )
//
// StrExtention( <cName> ) --> cExtension
//
// <cName>      the filename or pathname where is to extract
//              the file extention.
//
// The function tries to extract the file extention from
// <cName>.
//

    local cLastFour
    local cExt

    cName := alltrim( cName )

    cLastFour := right( cName, 4 )

    if at( ".", cLastFour ) == 0 // non c' estensione
        cExt := ""
    else
        cExt := right( cName, ( len(cName) - rat( ".", cName ) ) )
    end

    return cExt

//================================================================
function strFile( cName )
//
// StrFile( <cName> ) --> cFileName
//
// <cName>      the filename or pathname where is to extract
//              the file name.
//
// The function tries to extract the file name without path
// from <cName>.
//

    local nLastSlash
    local nLastColon

    cName := alltrim( cName )

    nLastSlash := rat( "\", cName )
    if nLastSlash > 0
        cName := substr( cName, nLastSlash+1 )
    end

    nLastColon := rat( ":", cName )
    if nLastColon > 0
        cName := substr( cName, nLastColon+1 )
    end

    return cName

//================================================================
function strPath( cName )
//
// StrPath( <cName> ) --> cPath
//
// <cName>      the filename or pathname where is to extract
//              the path.
//
// The function tries to extract the path from <cName>.
//

    local cPath
    local nLastSlash

    cName := alltrim( cName )

    nLastSlash := rat( "\", cName )

    if nLastSlash > 0
        if substr( cName, 2, 1 ) == ":"  // drive
            cPath := strPath( substr( cName, 3 ) )  // recursion
        else
            cPath := substr( cName, 1, nLastSlash )
        end
    else
        cPath := ""
    end

    return cPath

//================================================================
function strParent( cPathName )
//
// strParent( <cPathName> ) --> cParentPath
//
// <cPath>      the path to transform.
//
// The function tries to return a parent path.
//
    local cDrive := strDrive( cPathName )
    local cPath  := strPath( cPathName )
    local cFile  := strFile( cPathName )

    if len( cPath ) > 0
        do case
        case cPath == "\"
            // root; it remains as it is
        case right( cPath, 1 ) == "\"
            // normal condition
            cPath := strPath( left( cPath, len( cPath )-1 ) )
        otherwise
            // unknown situation
        end
    end

    return cDrive+cPath+cFile

//================================================================
// TEXT - TEXT DISPLAY
//================================================================
function Text( cText )
//
// Text( <cText> ) --> NIL
//
//
// <cText>      Text to display.
//

    local nOldCursor := setcursor( SC_NONE )
    local cOldScreen := savescreen()
    local cOldColor  := setcolor()
    local bOld_F1    :=;
        setkey( K_F1, NIL )   // to avoid recursion when
                              // usign it as help
    local bOld_F7    :=;
        setkey( K_F7, {|| textPrint( cText ) } )
    local nOldRow    := row()
    local nOldCol    := col()

    begin sequence

        if cText == NIL;
            .or. cText == ""
            //
            break
        end

        // Full screen.
        setcolor( COLOR_DEFAULT1 )
        scroll( maxrow(), 0, maxrow(), maxcol() )
        setpos( maxrow(), 0 )
        dispout( padc( TEXT_KEY_REMINDER, maxcol()+1 ) )

        setcolor( COLOR_DEFAULT2 )
        scroll( 0, 0, maxrow()-1, maxcol() )

        memoedit( cText + ENDTEXT, 00,00,maxrow()-1,maxcol(), .F. )

    end

    setcursor( nOldCursor )
    setcolor( cOldColor )
    restscreen( NIL, NIL, NIL, NIL, cOldScreen )
    setkey( K_F1, bOld_F1 )
    setkey( K_F7, bOld_F7 )
    setpos( nOldRow, nOldCol )

    return NIL

//----------------------------------------------------------------
static function textPrint( cText )
//

    local nLine
    local nLines    := mlcount( cText, 80 )

    // Prints on the Output peripheral.
    for nLine := 1 to nLines
        qout( memoline( cText, 80, nLine ) )
    next
    
    // Form Feed.
    qqout( FF )
    
    return NIL
    
//================================================================
// TB - BROWSE
//================================================================
function TB( nTop, nLeft, nBottom, nRight,;
             acCol, acColSayPic,;
             acColHead, acColFoot,;
             alColCalc, abColValid, abColMsg,;
             nFreeze,;
             lModify, lAppend, lDelete,;
             lAutoSort )
//
// TB( <nTop>, <nLeft>, <nBottom>, <nRight>,
//      <acCol>, <acColSayPic>,
//      [<acColHead>], [<acColFoot>],
//      [<alColCalc>], [<abColValid>], [<abColMsg>],
//      [<nFreeze>],
//      [<lModify>], [<lAppend>], [<lDelete>],
//      [<lAutosort>] )  --> NIL
//
// <nTop>, <nLeft>, <nBottom>, <nRight>         The display area
//                                              used to browse.
// <acCol>              Column array.
// <acColSayPic>        Picture array.
// <acColHead>          Column head description array.
// <acColFoot>          Column foot description array.
// <alColCalc>          Calculated column array: .T. menas
//                      calculated, .F. means editable.
// <abColValid>         Validation codeblock array.
// <abColMsg>           Message codeblock array. The codeblock
//                      must have a string result.
// <nFreeze>            Number of columns to be left visible.
// <lModify>            Ability to modify the file.
// <lAppend>            Ability to append data.
// <lDelete>            Ability to delete records.
// <lAutosort>          Ability to refresh record position
//                      when the file is indexed.
//

    local getlist := {}
    local bOldErrorHandler
    local lReadExit
    local nOldCursor
    local nOldRow
    local nOldCol
    local bOldF1

    local nALen := 0

    local oBrowse
    local nKey
    local lMore := .T.
    local alColMemo

    local nRow
    local nCol
    local cMsg
    local nLockedCol    := 0

    default nTop     to 0
    default nLeft    to 0
    default nBottom  to maxrow()
    default nRight   to maxcol()

    default acColSayPic to;
        iif( acCol == NIL, NIL, array( len( acCol ) ) )
    default acColHead to;
        iif( acCol == NIL, NIL, aclone( acCol ) )
    default acColFoot to;
        iif( acCol == NIL, NIL,;
        afill( array( len( acCol ) ), "" ) )
    default alColCalc to;
        iif( acCol == NIL, NIL,;
        afill( array( len( acCol ) ), .F. ) )
    default abColValid to;
        iif( acCol == NIL, NIL,;
        afill( array( len( acCol ) ), {||.T.} ) )
    default abColMsg to;
        NIL
    default nFreeze   to 0
    default lModify   to .T.
    default lAppend   to .T.
    default lDelete   to .T.
    default lAutosort to .T.

    if setkey( K_F1 ) == NIL // there is no previous help
        bOldF1 := setkey( K_F1,;
            { || Text( TB_HELP ) } )
    else
        bOldF1 := setkey( K_F1 )
    end

    if acCol == NIL
        tbDefault( @acCol, @acColSayPic, @alColCalc,;
            @acColHead, @acColFoot,;
            @abColValid, @abColMsg )
        nFreeze := 1
    end
    if acCol == NIL
       alert( TB_ERROR_NO_COLUMNS )
       return NIL
    end

    alColMemo := array( len( acCol ) )

    if acColSayPic == NIL
        alert( TB_ERROR_NO_PICTURES )
        return NIL
    end
    nALen := len( acCol )
    if !( nALen == len( acColSayPic );
        .and. nALen == len( alColCalc );
        .and. nALen == len( acColHead );
        .and. nALen == len( acColFoot );
        .and. nALen == len( abColValid );
        )
        //
        alert( TB_ERROR_ARRAY_DIFFERENT_DIMENTIONS )
        return NIL
    end

    // If it is not possible to modify...
    if !lModify
        lAppend := .F.
        lDelete := .F.
    end

    // If exist abColMsg, an extra line at bottom is needed.
    if !( abColMsg == NIL ) .and. len(abColMsg) == nALen
        nBottom--
    else
        abColMsg := NIL
    end    

    // Calculate the number of column on the left
    // where the cursor cannot enter.
    if nFreeze > 0
        nLockedCol := 1
        while .T.
            if nLockedCol <= nFreeze
                if alColCalc[nLockedCol]
                    // OK, locked column.
                else
                    nLockedCol--
                    exit
                end
            else
                nLockedCol--
                exit
            end
            nLockedCol++
        end
    else
        nLockedCol := 0
    end


    // If eof() it is better to move the record pointer.
    if eof()
        dbgobottom()
    end
    if bof()
        dbgotop()
    end

    lReadExit           := readexit(.T.)
    nOldCursor          := setcursor()
    nOldRow             := row()
    nOldCol             := col()

    bOldErrorHandler    := errorblock( {|e| ErrorHandler(e)} )
    begin sequence

        // Make a Tbrowse object for the current workarea.
        oBrowse := tbNew( nTop, nLeft, nBottom, nRight,;
                        acCol, acColHead, acColFoot,;
                        alColCalc, alColMemo )

        TB_APP_MODE_OFF(oBrowse)

        // Use a custom 'skipper' to handle append mode (see below)
        oBrowse:skipBlock := { |nSkip| tbSkip( nSkip, oBrowse ) }

        // Define pictures.
        tbColPicture(oBrowse, acColSayPic)

        // Turn the cursor off while browsing.
        setcursor(SC_NONE)

        // Freeze columns.
        oBrowse:freeze := nFreeze

        // Main loop.
        while lMore
            // Don't let the cursor move into locked columns
            // on the left.
            if ( oBrowse:colPos <= nLockedCol )
                oBrowse:colPos := nLockedCol + 1
            end
            // Stabilize the display until it's stable
            // or a key is pressed.
            oBrowse:forceStable()
            // Show the bottom message.
            // ( Here is the only possible place inside
            // this program ).
            nRow := row()
            nCol := col()
            if !(abColMsg == NIL)
                cMsg := eval( abColMsg[oBrowse:colPos] )
                @nBottom+1,nLeft say padc( cMsg, nRight+1-nLeft )
                setpos( nRow, nCol )
            end    
            // Check hit top/bottom.
            if ( oBrowse:hitBottom;
                .and. !TB_APP_MODE_ACTIVE( oBrowse );
                .and. lModify;
                .and. lAppend )
                //
                TB_APP_MODE_ON( oBrowse )
                nKey := K_DOWN
            else
                // Make sure that the current record is showing
                // up-to-date data in case we are on a network.
                oBrowse:refreshCurrent():forceStable()
                // Everything's done -- just wait for a key
                nKey := inkey( 0 )
            end

            // As a key was pressed, the "wait windows", or
            // "message line" must be closed!
            // Maybe there is nothing to close, but it is
            // better!
            waitFor()
            messageLine()
            //

            // Now the pressed key must be tested!
            do case
            case ( nKey == K_ESC )
                // Esc means leave
                lMore := .F.
            otherwise
                // It may be a function key or whatever else
                // that is "redirected" to a special funciton.
                if !empty( setkey( nKey ) )
                    eval( setkey( nKey ) )
                else
                    // Apply the key to the oBrowse.
                    tbApplyKey( oBrowse, nKey, acCol, alColCalc,;
                        acColHead, abColValid,;
                        alColMemo, lModify, lDelete,;
                        lAutosort )
                end
            end

        end

    recover
        // nil
    end sequence

    errorblock(bOldErrorHandler)
    readexit(lReadExit)
    setcursor(nOldCursor)
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOldF1 )

    return NIL

//----------------------------------------------------------------
static function tbSkip(nSkip, oBrowse)
//
// tbSkip(nSkip, oBrowse) --> nSkippedRecords
//
// Handle record movement requests from the Tbrowse object.
//

    local lAppend       := TB_APP_MODE_ACTIVE( oBrowse )
    local nI            := 0

    do case
    case ( nSkip == 0 .or. lastrec() == 0 )
        // Skip 0 (significant on a network)
        dbSkip(0)
    case ( nSkip > 0 .and. !eof() )
        // Skip Forward
        while (nI < nSkip)
            dbskip( 1 )
            if eof()
                iif(lAppend, nI++, dbskip(-1))
                exit
            end
            nI++
        end
    case ( nSkip < 0 )
        // Skip backward
        while ( nI > nSkip )
            dbskip(-1)
            if bof()
               exit
            end
            nI--
        end
    end

   return nI

//----------------------------------------------------------------
static function tbApplyKey( oBrowse, nKey,;
                    acCol, alColCalc, acColHead,;
                    abColValid, alColMemo,;
                    lModify, lDelete, lAutosort;
                          )
//
// Apply one keystroke to the oBrowse.
//

    local bOldErrorHandler
    local lMemo := .F.

    // determina se si tratti di un campo memo o di
    // campo molto grande
    lMemo := alColMemo[oBrowse:colPos]

    do case
    case nKey == K_DOWN
        oBrowse:down()
    case nKey == K_PGDN
        oBrowse:pageDown()
    case nKey == K_CTRL_PGDN
        oBrowse:goBottom()
        TB_APP_MODE_OFF(oBrowse)
    case nKey == K_UP
        oBrowse:up()
        if TB_APP_MODE_ACTIVE( oBrowse )
            TB_APP_MODE_OFF( oBrowse )
            oBrowse:refreshAll()
        end
    case nKey == K_PGUP
        oBrowse:pageUp()
        if TB_APP_MODE_ACTIVE( oBrowse )
            TB_APP_MODE_OFF( oBrowse )
            oBrowse:refreshAll()
        end
    case nKey == K_CTRL_PGUP
        oBrowse:goTop()
        TB_APP_MODE_OFF( oBrowse )
    case nKey == K_RIGHT
        oBrowse:right()
    case nKey == K_LEFT
        oBrowse:left()
    case nKey == K_HOME
        oBrowse:home()
    case nKey == K_END
        oBrowse:end()
    case nKey == K_CTRL_LEFT
        oBrowse:panLeft()
    case nKey == K_CTRL_RIGHT
        oBrowse:panRight()
    case nKey == K_CTRL_HOME
        oBrowse:panHome()
    case nKey == K_CTRL_END
        oBrowse:panEnd()
    case nKey == K_RETURN
        do case
        case !lModify  // read only
            // no edit allowed
            // (to view a memo, use a calculated column)
        case !alColCalc[oBrowse:colPos]
            if ( tbAlias(oBrowse, acCol, alColCalc) )->(rlock())
                // If it is read only and other possibilities.
                bOldErrorHandler :=;
                    errorblock( {|e| ErrorHandler(e)} )
                begin sequence
                    tbDoGet(oBrowse, acCol, abColValid, lMemo, lAutosort)
                    dbcommit()
                recover
                    // nil
                end
                errorblock(bOldErrorHandler)
                dbunlock()
            else
                alert( TB_ERROR_RECORD_LOCKED )
            end
        otherwise
            // nil
        end
    case nKey == K_CTRL_Y .or.;
         nKey == K_CTRL_DEL     // delete
        do case
        case lModify .and.;
             lDelete .and.;
             !deleted()
            if ( tbAlias(oBrowse, acCol, alColCalc) )->(rlock());
                .and. alert( TB_PROMPT_DELETE_RECORD,;
                { _MENU_NO, _MENU_YES } ) == 2
                //
                dbdelete()
            else
                alert( TB_ERROR_RECORD_LOCKED )
            end
            dbcommit()
            dbunlock()
        case lModify;
            .and. lDelete;
            .and. deleted()
            //
            if ( tbAlias(oBrowse, acCol, alColCalc) )->(rlock())
                recall
                dbcommit()
                dbunlock()
            else
                alert( TB_ERROR_RECORD_LOCKED )
            end
        otherwise
           // nil
        end
    otherwise
        do case
        case !lModify
            // no edit allowed
        case !alColCalc[oBrowse:colPos] .and. !lMemo
            // Edit allowed.
            if ( tbAlias(oBrowse, acCol, alColCalc) )->(rlock())
                bOldErrorHandler :=;
                    errorblock( {|e| ErrorHandler(e)} )
                begin sequence
                    // Repeat the key for the following tbDoGet().
                    keyboard chr(nKey)
                    tbDoGet(oBrowse, acCol, abColValid, lMemo, lAutosort)
                    dbcommit()
                recover
                    // nil
                end
                errorblock(bOldErrorHandler)
                dbunlock()
            else
                alert( TB_ERROR_RECORD_LOCKED )
            end
        otherwise
            // Do nothing
        end
    end

    return NIL

//----------------------------------------------------------------
static function tbDoGet(oBrowse, acCol, abColValid, lMemo, lAutosort)
//
// Do a GET for the current column in the browse.
//

    local lFlag := .T.
    local oCol
    local getlist
    local nKey
    local nLen
    local lAppend
    local bSavIns
    local nSavRecNo := recno()
    local xNewKey
    local xSavKey
    local cOldScreen
    local cOldColor
    local nSetCursor
    local cMemoOld
    local cMemoNew
    local nRow
    local nCol


    // If we're at EOF we're adding the first record,
    // so turn on append mode
    if eof()
        lAppend := TB_APP_MODE_ON(oBrowse)
    else
        lAppend := TB_APP_MODE_ACTIVE(oBrowse)
    end

    // Make sure screen is fully updated,
    // dbf position is correct, etc.
    oBrowse:forceStable()
    if ( lAppend .and. (recno() == lastrec() + 1 ) )
        // dbAppend()
        dbappend()
        // if neterror, ignore
        neterr()
    end

    // Save the current record's key value (or NIL)
    xSavKey := iif(empty(indexkey()), NIL, &(indexkey()))

    // Get the current column object from the browse
    oCol := oBrowse:getColumn(oBrowse:colPos)

    if lMemo

        cOldColor     := setcolor()
        cOldScreen    :=;
            savescreen( maxrow()/2, 00, maxrow(), maxcol() )
        nSetCursor    := setcursor ( SC_NORMAL )

        scroll( maxrow()/2, 00, maxrow(), maxcol() )
        setcolor( COLOR_DEFAULT1 )
        setpos( maxrow()/2, 01)
        dispout( padc( oCol:heading, maxcol()+1 ) )
        setpos( maxrow(), 01 )
        dispout( padc( TB_WINDOW_BOTTOM_MEMO, maxcol()+1 ) )
        setcolor( cOldColor )

        cMemoOld := rtrim( &(acCol[oBrowse:colPos]) )
        cMemoNew :=;
            memoedit( cMemoOld,;
            maxrow()/2+1, 01, maxrow()-1, maxcol()-1,;
            .T., NIL, SPACE_LEN )
        if ( cMemoOld <> cMemoNew )
            replace &(acCol[oBrowse:colPos]) with cMemoNew
            dbcommit()
        end

        // Restore.
        restscreen( maxrow()/2, 00, maxrow(), maxcol(),;
            cOldScreen )
        setcursor ( nSetCursor )

    else

        // Loop to check for valid data.
        while .T.

            // Get picture len to force scrolling if var is larger
            // than window
            nLen := oBrowse:colWidth(oBrowse:colPos)

            // Create a corresponding GET.
            // Before, save cursor position for possible loop.
            nRow := row()
            nCol := col()
            getlist :=;
                { getnew( row(), col(),;
                oCol:block,;
                oCol:heading,;
                oCol:picture,;
                oBrowse:colorSpec ) }

            // Set insert key to toggle insert mode and cursor shape
            bSavIns := setkey(K_INS, { || tglInsert() })

            // Set initial cursor shape
            setcursor(iif(ReadInsert(), SC_INSERT, SC_NORMAL))

            readmodal(getlist)
            getlist := {}

            setcursor(SC_NONE)
            setkey(K_INS, bSavIns)

            // Restore cursor position before data Validation.
            setpos( nRow, nCol )

            // Check for valid data.
            if eval( abColValid[oBrowse:colPos] )
                exit
            else
                // Restore cursor location before loop.
                // setpos( nRow, nCol ) // already restored.
                // Now loop.
            end    

        end
        
    end    

    // Turn append mode off after each new record.
    TB_APP_MODE_OFF(oBrowse)

    if lAutosort
        // Get the record's key value (or NIL) after the GET
        xNewKey := if(empty(indexkey()), NIL, &(indexkey()))

        oBrowse:inValidate()
        oBrowse:refreshAll():forceStable()

        // if the key has changed (or if this is a new record)
        if !(xNewKey == xSavKey);
           .or. (lAppend .and. xNewKey != NIL)
            //
            // Do a complete refresh.
            oBrowse:refreshAll():forceStable()
            // Make sure we're still on the right record
            // after stabilizing
            while &(indexkey()) > xNewKey .and. !oBrowse:hitTop()
                oBrowse:up():forceStable()
            end
        end
    end

    // Check exit key from get.
    nKey := lastkey()
    if nKey == K_UP   .or.;
       nKey == K_DOWN .or. ;
       nKey == K_PGUP .or.;
       nKey == K_PGDN
        keyboard(chr(nKey))
    end

    return NIL

//----------------------------------------------------------------
static function tbNew( nTop, nLeft, nBottom, nRight,;
                        acCol, acColHead, acColFoot,;
                        alColCalc, alColMemo )

    local oBrowse
    local n
    local oColumn
    local cType

    // Start with a new browse object from tbrowsedb()
    oBrowse := tbrowsedb(nTop, nLeft, nBottom, nRight)

    // Add columns
    for n := 1 to len( acCol )

        // Make a new column
        cType := valtype( &(acCol[n]) )
            // speed up macro evaluation
        do case
        case alColCalc[n]
            // Make a calculated field
            oColumn :=;
                tbAddCalCol( oBrowse, acColHead[n], acCol[n] )
            alColMemo[n] := .F.
        case ( cType == "M")
            // Make a calculated field to activate the macro window
            oColumn := tbAddCalCol( oBrowse, acColHead[n],;
                "padr(" + acCol[n] + ", 30 )" )
                // shows 30 characters anyway
            alColMemo[n] := .T.
        case ( cType == "C") .and.;
             ( len( &(acCol[n]) ) > SPACE_LEN )
            // Make a calculated field to activate the macro window
            oColumn := tbAddCalCol( oBrowse, acColHead[n],;
                "left(" + acCol[n] + ", 30 )" )
                // shows only 30 characters.
            alColMemo[n] := .T.
        otherwise
            // Make a new normal field column
            oColumn := tbColumnNew( acColHead[n],;
                          tbFieldWBlock( acCol[n] ) )
            alColMemo[n] := .F.
        end

        // Other attribute.
        oColumn:headSep( "" )           // no head line separation
        oColumn:colSep( "" )
        oColumn:footSep( "" )           // no foot separation line
        oColumn:footing( acColFoot[n] )

        oBrowse:addColumn( oColumn )


    next

    return oBrowse

//----------------------------------------------------------------
static function tbColPicture(oBrowse, acColSayPic)
//
// Set up pictures for the column.
//
    local n
    local oColumn
    default acColSayPic to NIL

    for n := 1 to oBrowse:colCount
        // Get (a reference to) the column
        oColumn := oBrowse:getColumn(n)
        // define picture
       oColumn:picture := acColSayPic[n]
    next

    return NIL

//----------------------------------------------------------------
static function tbFieldWBlock( cFieldName )
//
// return the column code block
//
    local bFieldWBlock
    local cAlias
    local cField
    local nArrowStart
    local nSelect

    nArrowStart := at( "->", cFieldName )

    do case
    case nArrowStart == 0
        // There is no arrow, so, no alias was specified.
        cAlias := NIL
        cField := alltrim( cFieldName )
    case nArrowStart > 0
        cAlias := substr( cFieldName, 1, nArrowStart-1 )
        cField := substr( cFieldName, nArrowStart+2 )
    end

    do case
    case cAlias == NIL
        bFieldWblock := fieldwblock( cField, select() )
    case upper(cAlias) == "FIELD"
        bFieldWblock := fieldwblock( cField, select() )
    case upper(cAlias) == "MEMVAR" .or. ;
        upper(cAlias) == "M"
        bFieldWblock := memvarblock( cField )
    otherwise
        nSelect := select(cAlias)
        bFieldWblock := fieldwblock( cField, nSelect )
    end

    return bFieldWBlock

//----------------------------------------------------------------
static function tbAlias( oBrowse, acCol, alColCalc )
//
// return the alias name for the actual column
//
    local cAlias
    local nArrowStart

    nArrowStart := at( "->", acCol[oBrowse:colPos] )

    do case
    case alColCalc[oBrowse:colPos]
        cAlias := alias()
    case nArrowStart == 0
        // There is no arrow, so, no alias was specified.
        cAlias := alias()
    case nArrowStart > 0
        cAlias := substr( acCol[oBrowse:colPos], 1, nArrowStart-1 )
    end

    return alltrim(cAlias)

//----------------------------------------------------------------
static function tbAddCalCol(oBrowse, cColHead, cCol)
//
// create a calculated column
//
    local oColumn

    oColumn := tbColumnNew(cColHead, { || &(cCol) } )
        // Evaluate the macro each time.

    return oColumn

//----------------------------------------------------------------
static function tbDefault( acCol, acColSayPic, alColCalc,;
    acColHead, acColFoot, abColValid, abColMsg )
//

    if ( alias() == "" )
         return NIL
    end

    // prepare arrays
    acCol       := {}
    acColSayPic := {}
    alColCalc   := {}
    acColHead   := {}
    acColFoot   := {}
    abColValid  := {}
    abColMsg    := NIL

    // the first default column
    aadd ( acCol, "if( deleted(), '*', ' ') +" +;
                        " str(recno(), 5, 0)" )
    aadd( alColCalc, .T. )
    aadd( acColSayPic, "!!!!!!" )

    aadd( acColHead, "Rec. #" )
    aadd( acColFoot, "" )
    aadd( abColValid, {||.T.} )

    // add the other columns
    tbDefColAdd( @acCol, @acColSayPic, @alColCalc,;
        @acColHead, @acColFoot,;
        @abColValid, @abColMsg )


    return NIL

//----------------------------------------------------------------
static function tbDefColAdd( acCol, acColSayPic, alColCalc,;
    acColHead, acColFoot, abColValid, abColMsg )
//

    local aStruct   := {}
    local nFields   := 0
    local nColIndex := 0
    local nRelations := 0
    local nIndRel := 0
    local cChildAlias := ""

    default acCol        to {}
    default acColSayPic  to {}
    default alColCalc    to {}
    default acColHead    to {}
    default acColFoot    to {}
    default abColValid   to {}
    default abColMsg     to NIL

    // Relation number determination.
    nRelations := 0
    while .T.
        nRelations++
        if dbrselect( nRelations ) > 0
            // Go on.
        else
            // nRelation must be reduced as the last is not true.
            nRelations--
            exit
        end
    end
    // Now nRelations contains the number of relations
    // established with the original Alias.

    // Files analisys.
    aStruct := dbstruct()
    nFields := len( aStruct )

    // Arrays compilation.
    nColIndex := 1
    while nColIndex <= nFields
        aadd( acCol, Alias()+"->"+aStruct[nColIndex, 1] )
        aadd( alColCalc, .F. )
        aadd( acColSayPic, tbDefPicture( aStruct[nColIndex, 1],;
                                         aStruct[nColIndex, 2],;
                                         aStruct[nColIndex, 3],;
                                         aStruct[nColIndex, 4] ) )
        aadd( acColHead, Alias()+"->"+aStruct[nColIndex, 1] )
        aadd( acColFoot, "" )
        aadd( abColValid, {||.T.} )
        nColIndex++
    end

    // It adds eventual relations.
    if nRelations > 0
        for nIndRel := 1 to nRelations

            // it determinates the Alias name for this relation
            cChildAlias := alias( dbrselect( nIndRel ) )

            // it adds the columns from the related Alias
            (cChildAlias)->(tbDefColAdd( @acCol,;
                @acColSayPic, @alColCalc,;
                @acColHead, @acColFoot,;
                @abColValid, @abColMsg ) )
        next
    end

    return NIL

//----------------------------------------------------------------
static function tbDefPicture( cColumn, cColumnType, nColumnLen,;
                    nColumnDec )

   local nLen := 0
   local cColSayPic := ""

   do case
   case cColumnType == "C"
      nLen := len( &(cColumn) )
      if nLen > 40
         cColSayPic := "@s40"
      else
         cColSayPic := replicate( "x", nLen )
      end
   case cColumnType == "N"
      if nColumnDec > 0
         // con decimale e virgola
         cColSayPic := ;
            replicate ( "9", nColumnLen-1-nColumnDec ) +;
            "." +;
            replicate ( "9", nColumnDec )
      else
         // intero
         cColSayPic := ;
            replicate ( "9", nColumnLen )
      end
   case cColumnType == "D"
      cColSayPic := "99/99/9999"
   case cColumnType == "L"
      cColSayPic := "L"
   case cColumnType == "M"
      cColSayPic := "@s40" // <Memo>
   end

   return cColSayPic

//================================================================
// WAIT  - These functions must be "opened" and then "closed".
//================================================================
function WaitFileEval( lClose )
//
// WaitFileEval( [<lClose>] ) --> .T.
//
// Shows a wait bar calculated with recno()/lastrec(),
//
// This function must be "closed".
//

    static nI
    static lIndex

    default lClose to .F.

    do case
    case lClose
        nI      := NIL
        lIndex  := NIL
        // Close WaitProgress().
        waitProgress(2) // > 100%

        return .T.        

    case nI == NIL
        nI      := 0
        if !(alias() == "");
            .and. !( ordsetfocus() == "" )
            //
            lIndex := .T.
        else
            lIndex := .F.
        end
    end
        
    // If [Esc] is pressed, a break() is possible.
    if inkey() == K_ESC
        // Do you want to break?
        if alert( WAIT_DO_YOU_WANT_TO_BREAK,;
            { WAIT_MENU_CHOICE_CONTINUE,;
                WAIT_MENU_CHOICE_BREAK} ) == 2
            break
        end    
    end
        
    if lIndex
        nI++
        waitProgress( recno()/lastrec() )
    else
        if recno() == lastrec()
            // Close WaitProgress().
            waitProgress(2) // > 100%
        else
            waitProgress( recno()/lastrec() )
        end
    end

    return .T.

//================================================================
function waitProgress( nPercent )
//
// WaitProgress ( [<nPercent>] ) --> .t.
//
// <nPercent>   the actual percent value (1 = 100%).
//              When nPercent > 1 the wait bar is closed.
//              When nPercent == 1 the wait bar is displayed
//              and closed.
//
// Shows a wait bar at the display top.
// The wait bar appears at the top as so it will not be in
// conflict with qout()|qqout() functions, as the natural
// display scroll is bottom-up.
//
// This function must be "closed".
//

    static cOldScreen

    local nElements
    local nBar
    local nOldRow    := row()
    local nOldCol    := col()
    local cOldColor  := setcolor( COLOR_DEFAULT0 )

    begin sequence

        if cOldScreen == NIL
            cOldScreen :=;
                savescreen( 00,00,00,maxcol()-1 )
        end

        waitWheel()

        if nPercent == NIL .or.;
           nPercent > 1

            // Position 00,maxcol() is reserver for the wait wheel.
            restscreen( 00,00,00,maxcol()-1, cOldScreen )
            cOldScreen := NIL

            break
        end

        // Position 00,maxcol() is reserver for the wait wheel.
        nElements := maxcol()
        nBar := nElements*nPercent
        if nBar < 0
            nBar := 0
        end

        // Position 00,maxcol() is reserver for the wait wheel.
        setpos( 00,00 )
        dispout( replicate( "", nBar ) )
        dispout( replicate( "", nElements-int(nBar) ) )

        // If 100% or more.
        if nPercent >= 1
            restscreen( 00,00,00,maxcol()-1, cOldScreen )
            cOldScreen := NIL
        end

    end

    // Restore.
    setpos( nOldRow, nOldCol )
    setcolor( cOldColor )

    return .t.

//================================================================
function waitWheel( lWheel )
//
// waitWheel( [<lWheel>] ) --> lWheelNow
//
// Shows a wait wheel at 00,maxcol() position.
// The screen is not saved.
//

    static nCounter
    static lWork

    local nOldRow    := row()
    local nOldCol    := col()
    local cOldColor  := setcolor( COLOR_DEFAULT0 )


    if lWork == NIL
        lWork := .T.
    end

    // Turn ON/OFF waitWheel()
    if valtype( lWheel ) == "L"
        lWork := lWheel
    end

    if !lWork
        return NIL
    end

    if nCounter == NIL
        nCounter := 1
    else
        nCounter++
        if nCounter > 8
            nCounter := 1
        end    
    end

    setpos( 0,maxcol() )
    do case
    case nCounter == 1
        dispout( "|" )
    case nCounter == 2
        dispout( "/" )
    case nCounter == 3
        dispout( "" )
    case nCounter == 4
        dispout( "\" )
    case nCounter == 5
        dispout( "|" )
    case nCounter == 6
        dispout( "/" )
    case nCounter == 7
        dispout( "" )
    case nCounter == 8
        dispout( "\" )
    end

    // Restore.
    setpos( nOldRow, nOldCol )
    setcolor( cOldColor )

    // Returns .t. if the WaitWheel is active.
    return lWork

//================================================================
function WaitFor( cMessage )
//
// This function was originally named "Wait()", but the name is
// now changed as the compiler confuses it with the command
// WAIT
//
// WaitFor( [<cMessage>] ) --> .T.
//
// <cMessage>   Text message to show. If it is NIL, it closes
//              the message.
//
// It shows a wait message at the center of the screen.
//
// WaitFor() without argument, closes the message.
//
// This function must be closed.
//

    static cOldScreen
    static nTop
    static nLeft
    static nBottom
    static nRight

    local nOldCursor := setcursor( SC_NONE )
    local cOldColor  := setcolor()
    local nOldRow    := row()
    local nOldCol    := col()

    local nWidth := 0

    local nLines
    local nLine

    begin sequence

        // Wait close?
        if valtype( cMessage ) <> "C"
            if cOldScreen <> NIL
                restscreen( nTop,nLeft,nBottom,nRight, cOldScreen )
                cOldScreen := NIL
            end

            break

        end

        // Already opened?
        if cOldScreen <> NIL
            restscreen( nTop,nLeft,nBottom,nRight, cOldScreen )
            cOldScreen := NIL
        end

        // line count
        cMessage := alltrim(cMessage)
        nLines := mlcount( cMessage, maxcol()-1 )
        nLine := 0
        while nLine < nLines
            nLine++
            nWidth :=;
                max( nWidth,;
                len( rtrim( memoline(cMessage,;
                maxcol()-1, nLine ) ) ) )
        end

        nTop        := int( ( (maxrow()+1) - (nLines+2) ) / 2 )
        nLeft       := int( ( (maxcol()+1) - (nWidth+2) ) / 2 )
        nBottom     := nTop + nLines+1
        nRight      := nLeft + nWidth+1

        cOldScreen := savescreen( nTop, nLeft, nBottom, nRight )

        setcolor( COLOR_DEFAULT2 )
        dispbox( nTop, nLeft, nBottom, nRight, B_DOUBLE )
        scroll( nTop+1, nLeft+1, nBottom-1, nRight-1 )
        nLine := 1
        while nLine <= nLines
            setpos( nTop+nLine, nLeft+1 )
            dispout( memoline(cMessage, nWidth, nLine ) )
            nLine++
        end

    end sequence

    // Restore.
    setcursor( nOldCursor )
    setcolor( cOldColor )
    setpos( nOldRow, nOldCol )

    return NIL

//================================================================
//================================================================
//================================================================
// COMMAND SUBSTITUTION FUNCTIONS
//================================================================
function bCompile( cString )
//
// bCompile( <cString> ) --> bBlock
//
// <bString>       string to translate into code block.
//
// Compiles the string <cString> and result a code block.
//

    local cCodeBlock

    if cString <> NIL
        cCodeBlock :=;
            "{||";
            + alltrim(cString);
            + "}"
    
        return &(cCodeBlock)
    else
        return NIL
    end

    return NIL

//================================================================
function CopyFile( cSource, cDestination )
//
// CopyFile( <cSource>, <cDestination> ) --> NIL
//
// Copy File command substitute.
//

    copy file (cSource) to (cDestination)

    return NIL

//================================================================
function dbApp( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest, cDriver )
//
// dbApp( <cFileName>,
//              [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>], [<cDriver>] ) --> NIL
//
// Import records from a (.dbf) file.
//
// <cFileName>          the (.dbf) file name to use to
//                      import data.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
// <cDriver>            the RDD name to use.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbApp( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest, cDriver )

    return NIL

//================================================================
function dbclose()
//
// This function is made in substitution to DBCLOSEALL() to avoid
// the macro file, CM_COMPILED_MACRO_ALIAS to be closed during
// macro execution.
//
// This function generate a warning duriing compilation.
//

    local nSelect

    for nSelect := 1 to _MAX_SELECT
        if (nSelect)->(used());
            .and. (nSelect)->(alias()) <> CM_COMPILED_MACRO_ALIAS
            (nSelect)->(dbclosearea())
        end
    end

    return NIL
//================================================================
function dbContinue()
//
// dbContinue() --> NIL
//
// Continue command substitute.
//

    continue

    return NIL

//================================================================
function dbCopy( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest, cDriver )
//
// dbCopy( <cFileName>,
//              [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>], [<cDriver>] ) --> NIL
//
// Export records to a new (.dbf) file.
//
// <cFileName>          the (.dbf) file name to create.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
// <cDriver>            the RDD name to use.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbCopy( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest, cDriver )

    return NIL

//================================================================
function dbCopyStruct( cFileName, acFields )
//
// dbCopyStruct( <cFileName>, [<acFields>] )  --> NIL
//
// Copy the current (.dbf) structure to a new (.dbf) file.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbCopyStruct( cFileName, acFields )

    return NIL

//================================================================
function dbCopyXStruct( cFileStructure )
//
// dbCopyXStruct( <cFileStructure> )  --> NIL
//
// Copy field definitions to a (.dbf) file.
//

    copy structure extended to (cFileStructure)

    return NIL

//================================================================
function dbOldCreate( cFileName, cFileStructure,;
                      cDriver, lNew, cAlias )
//
// dbOldCreate( <cFileName>, <cFileStructure>,
//      [<cDriver>], [<lNew>], [<cAlias>] ) --> NIL
//
// Creates a new database file with structure defined by
// the specified extended file <cFileStructure>.
//
// The name "dbOldCreate" is so to make no confusion with the
// CA-Clipper function dbCreate that works with an Array for
// the data structue.
//
// <cFileName>          contains the file name to create.
// <cFileStructure>     contains the file containing the
//                      structure.
// <cDriver>            contains the driver name to be used.
// <lNew>               if true (.T.) it opend the new file
//                      into the next free work area, else
//                      it will be opened into the actura
//                      area.
// <cAlias>             it contains the alias to be used
//                      to indentify the new file.
//

    default lNew to .F.

    if lNew
        create (cFileName);
            from (cFileStructure);
            via cDriver;
            alias (cAlias);
            new
    else
        create (cFileName);
            from (cFileStructure);
            via cDriver;
            alias (cAlias)
    end

    return NIL

//================================================================
function dbDelim( lCopy, cFileName, cDelimiter, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )
//
// dbDelim( <lCopy>, <cFileName>, [<cDelimiter>],
//              [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>] ) --> NIL
//
// Export records to a new ASCII file.
// Import records from a ASCII file.
//
// <lCopy>              if true (.T.) it exports, else it
//                      imports data.
// <cFileName>          the ASCII file name to create or the
//                      ASCII file name to use to import data.
// <cDelimiter>         the delimiter used.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbDelim( lCopy, cFileName, cDelimiter, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )

    return NIL

//================================================================
function dbJoin( cAlias, cFileName, acFields, bForCondition )
//
// dbJoin( <cAlias>, <cFileName>, [<acFields>],
//      [<bForCondition>] ) --> NIL
//
// Generates a new (.dbf) file by joining the active Alias
// with a second alias <cAlias> and eliminating records that
// do not meet the condition stated into the code block
// <bForCondition>.
//
// <cAlias>             the other Alias containing the data
//                      to use to join.
// <cFileName>          the (.dbf) file to create.
// <acFields>           fields to be involved.
// <bForCondition>      code block FOR.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbJoin( cAlias, cFileName, acFields, bForCondition )

    return NIL

//================================================================
function dbLabelForm( cLabel, lToPrinter, cFileName,;
             lNoConsole, bForCondition, bWhileCondition,;
             nNextRecords, nRecord, lRest,;
             lSample )
//
// dbLabelForm( <cLabel>, [<lToPrinter>], [<cFileName>],
//     [<lNoConsole>], [<bForCondition>], [<bWhileCondition>],
//     [<nNextRecords>], [<nRecord>], [<lRest>],
//     [<lSample> ) --> NIL
//
// Displays or prints lables form a definition held in a
// label (.lbl) file for a range of records in the active
// Alias.
//
// <cLabel>             the label (.lbl) file name.
// <lToPrinter>         if true (.T.) the labels will be
//                      printed.
// <cFileName>          the text file name to create
//                      containing the lables.
// <lNoConsole>         if true (.T.) the labels will not
//                      displayed on the console.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
// <lSample>            if true (.T.), only test labels
//                      of asterisks are printed.
//

    default lToPrinter  to .F.
    default lNoConsole  to .F.

    // change the following line if a new release uses
    // a different internal function.
    __LabelForm( cLabel, lToPrinter, cFileName,;
        lNoConsole, bForCondition, bWhileCondition,;
        nNextRecords, nRecord, lRest,;
        lSample )

    return NIL

//================================================================
function dbList( lToDisplay, abListColumns, lAll,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest,;
                lToPrinter, cFileName )
//
// dbList( [<lToDisplay>], <abListColumns>, [<lAll>],
//     [<bForCondition>], [<bWhileCondition>],
//     [<nNextRecords>], [<nRecord>], [<lRest>],
//     [<lToPrinter>], [<cFileName>] ) --> NIL
//
// Displays or prints the result of one or more expressions
// listed into <abListColumns> for a range of records in the
// active Alias.
//
// <lToDisplay>         if true (.T.) it displays the list.
// <abListColumns>      every element contains the expression
//                      (in code block form) to be listed.
// <lAll>               if true (.T.) it lists all records.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
// <lToPrinter>         if true (.T.) it prints the list.
// <cFileName>          the text file to create containing
//                      the list.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbList( lToDisplay, abListColumns, lAll,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest,;
                lToPrinter, cFileName )

    return NIL

//================================================================
function dbLocate( bForCondition, bWhileCondition,;
    nNextRecords, nRecord, lRest;
                 )
//
// dbLocate( [<bForCondition>], [<bWhileCondition>],
//     [<nNextRecords>], [<nRecord>], [<lRest>] ) --> NIL
//
// Positions the record pointer to the first record
// in the active Alias that matches the specified condition
// within the given scope.
//
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
//

    default bForCondition to { || .T. }
    default bWhileCondition to { || .T. }

    // change the following line if a new release uses
    // a different internal function.
    __dbLocate( bForCondition, bWhileCondition,;
        nNextRecords, nRecord, lRest;
              )

    return NIL

//================================================================
function dbPack()
//
// dbPack() --> NIL
//
// Pack command substitute.
//

    pack

    return NIL

//================================================================
function dbReportForm( cForm, lToPrinter, cFileName,;
             lNoConsole, bForCondition, bWhileCondition,;
             nNextRecords, nRecord, lRest,;
             lPlain, cHeading,;
             lNoEject, lSummary )
//
// dbReportForm( <cForm>, [<lToPrinter>], [<cFileName>],
//     [<lNoConsole>], [<bForCondition>], [<bWhileCondition>],
//     [<nNextRecords>], [<nRecord>], [<lRest>],
//     [<lPlain>], [<cHeading>],
//     [<lNoEject>, [<lSummary>] ) --> NIL
//
// Displays or prints a tabular and optionally grouped
// report with page and column headings for a range of
// records in the active Alias.
// The report definition is held in a report (.frm) file.
//
// <cForm>              the report (.frm) file name.
// <lToPrinter>         if true (.T.) the report will be
//                      printed.
// <cFileName>          the text file name to create
//                      containing the report.
// <lNoConsole>         if true (.T.) the report will not
//                      displayed on the console.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
// <lPlain>             if true (.T.), the report will
//                      not have page breaks.
// <cHeading>           contains the header printed each
//                      page.
// <lNoEject>           if true (.T.) it suppresses the
//                      initial page eject.
// <lSummary>           if true (.T.), only group, subgroup,
//                      and grand total lines are printed.
//

    default lToPrinter  to .F.
    default lNoConsole  to .F.
    default lPlain      to .F.
    default lNoEject    to .F.
    default lSummary    to .F.

    // change the following line if a new release uses
    // a different internal function.
    __ReportForm( cForm, lToPrinter, cFileName,;
        lNoConsole, bForCondition, bWhileCondition,;
        nNextRecords, nRecord, lRest,;
        lPlain, cHeading,;
        lNoEject, lSummary )

    return NIL

//================================================================
function dbSDF( lCopy, cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )
//
// dbSDF( <lCopy>, <cFileName>,
//              [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>] ) --> NIL
//
// Export records to a new ASCII file.
// Import records from a ASCII file.
//
// <lCopy>              if true (.T.) it exports, else it
//                      imports data.
// <cFileName>          the ASCII file name to create or the
//                      ASCII file name to use to import data.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbSDF( lCopy, cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )

    return NIL

//================================================================
function dbSort( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )
//
// dbSort( <cFileName>, [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>] ) --> NIL
//
// Copies records within the specified scope and condition
// from the current work area to another database file
// sorted according to the specified fields.
//
// <cFileName>          the (.dbf) file name to create.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbSort( cFileName, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )

    return NIL

//================================================================
function dbTotal( cFileName, bKey, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )
//
// dbTotal( <cFileName>, <bKey>, [<acFields>], [<bForCondition>],
//              [<bWhileCondition>], [<nNextRecords>], [<nRecord>],
//              [<lRest>] ) --> NIL
//
// Summerizes records in the current work area by key value,
// summing the specified numeric fields and then copying
// summary records to a second database file.
//
// <cFileName>          the (.dbf) file name to create.
// <bKey>               code block Key expression.
// <acFields>           the fields to be involved.
// <bForCondition>      code block FOR condition.
// <bWhileCondition>    code block WHILE condition.
// <nNextRecords>       equivalent to NEXT ...
// <nRecord>            equivalent to RECORD ...
// <lRest>              if true (.T.), then REST records.
//

    // change the following line if a new release uses
    // a different internal function.
    __dbTotal( cFileName, bKey, acFields,;
                bForCondition, bWhileCondition,;
                nNextRecords, nRecord, lRest )

    return NIL

//================================================================
function dbUpdate( cAlias, bKey, lRandom, bReplacement )
//
// dbUpdate( <cAlias>, <bKey>, [<lRandom>],
//              [<bReplacement>] ) --> NIL
//
// Updates the active Alias with the data contained into
// <cAlias> using the code block <bReplacement>.
//
// <cAlias>             the other Alias containing the data
//                      to use to update the active Alias.
// <bKey>               code block Key expression.
// <lRandom>            if true (.T.), then RANDOM.
// <bReplacement>       code block to be executed for the
//                      records with a matching key.
//
// Example:
//      dbUpdate( "INVOICE", {|| LAST}, .T.,;
//              {|| FIELD->TOTAL1 := INVOICE->SUM1,;
//                  FIELD->TOTAL2 := INVOICE->SUM2 } )
//

    // change the following line if a new release uses
    // a different internal function.
    __dbUpdate( cAlias, bKey, lRandom, bReplacement )

    return NIL

//================================================================
function dbZap()
//
// dbZap() --> NIL
//
// Zap command substitute.
//

    zap

    return NIL

//================================================================
function Get( nRow, nCol, cVar,;
    cGetPicture, cColorString, bPreExpression, bValid;
            )
//
// like @...get
//
// The name of the variable to be edited must be passed
// inside cVar. I don't have found another way.
// For example, pass by reference (@) will not work.
//
   memvar getlist

   default cColorString   to setcolor()
   default bPreExpression to { || .T. }
   default bValid         to { || .T. }

   setpos( nRow, nCol )
   aadd( GetList, _GET_(;
       &cVar., cVar, cGetPicture, bValid, bPreExpression;
                       ):display();
       )
   atail(GetList):colorDisp(cColorString)

   return NIL

//================================================================
function Keyboard( cString )
//
// Keyboard( [<cString>] ) --> NIL
//
// Keyboard command substitute.
//
    default cString to ""

    keyboard cString

    return NIL

//================================================================
function MemPublic( VarName )
//
// MemPublic( <cVarName> | <acVarName> ) --> NIL
//
// <cVarName>   Contains the variable name.
// <acVarName>  Contains an array of variable names.
//
// Creates the public variable|variables named into <cVarName>
// or <acVarname>.
//

    local nVar
    local cVar

    do case
    case valtype(VarName) == "C"
        public &VarName.
    case valtype(VarName) == "A"
        for nVar := 1 to len(VarName)
            cVar := VarName[nVar]
            public &cVar.
        next
    otherwise
        // Nothing will be declared.
    end

    return NIL

//================================================================
function MemRelease( VarName )
//
// MemRelease( <cVarName> | <acVarName> ) --> NIL
//
// <cVarName>   Contains the variable name.
// <acVarName>  Contains an array of variable names.
//
// Releases the public variable|variables named into <cVarName>
// or <acVarname>.
//

    local nVar

    do case
    case valtype(VarName) == "C"
        release &VarName.
    case valtype(VarName) == "A"
        for nVar := 1 to len(VarName)
            release &(VarName[nVar])
        next
    otherwise
        // Nothing will be declared.
    end

    return NIL

//================================================================
function MemRestore( cMemFileName, lAdditive )
//
// MemRestore( <cMemFileName>, [<lAdditive>] ) --> NIL
//
// Restore From command substitute.
//

    default lAdditive to .F.

    // change the following line if a new release uses
    // a different internal function.
    __MRestore( cMemFileName, lAdditive )

    return NIL

//================================================================
function MemSave( cMemFileName, cSkeleton, lLike )
//
// MemSave( <cMemFileName>, [<cSkeleton>], [<lLike>] ) --> NIL
//
// Save To command substitute.
//
// <cMemFileName>       (.mem) file name to create.
// <cSkeleton>          memory names skeleton.
// <lLike>              true (.T.) means LIKE SKELETON,
//                      false (.F.) means EXCEPT SKELETON.
//

    default cSkeleton to "*"
    default lLike to .T.

    if lLike
        save to &cMemFileName. all like &cSkeleton.
    else
        save to &cMemFileName. all except &cSkeleton.
    end

    return NIL

//================================================================
function Quit()
//
// Quit() --> NIL
//
// Quit command substitute.
//

    quit

    return NIL

//================================================================
function Run( cCommand )
//
// Run( <cCommand> ) --> NIL
//
// <cCommand>   String to execute by OS.
//
// Run command substitute.
//

   if cCommand <> NIL
      run (cCommand)
   else
      // nil
   end

   return NIL

//================================================================
function Say( nRow, nCol, cVar, cSayPicture, cColorString )
//
// like @...say
//
   memvar getlist

   default cColorString   to setcolor()


   setpos( nRow, nCol )
   if cSayPicture == NIL
      dispout( cVar, cColorString )
   else
      devoutpict( cVar, cSayPicture, cColorString )
   end

   return NIL

//================================================================
function SetFunction( nFunctionKey, cString )
//
// SetFunction( <nFunctionKey>, [<cString>] ) --> NIL
//
// Set Function command substitute.
//
    default cString to ""

    set function nFunctionKey to cString

    return NIL

//================================================================

#ifndef RUNTIME
//================================================================
// ASSIST - nB MENU
//================================================================
function Assist()
//

    local cOldScreen        := savescreen()
    local cOldColor         := setcolor()
    local nOldCursor        := setcursor( SC_NORMAL )
    local lOldSetWrap       := set(_SET_WRAP, .T.)
    local nOldSetMessage    := set(_SET_MESSAGE, maxrow()-1)
    local lOldSetCenter     := set(_SET_MCENTER, .T.)
    local bOld_F1           :=;
        setkey( K_F1, {|| Text(_MENU_HELP)} )
    local bOld_F2           := setkey( K_F2, NIL )
    local bOld_F3           :=;
        setkey( K_F3, { || Text( dbiStatus() ) } )
    local bOld_F5           :=;
        setkey( K_F5, { || setAlternate()} )
    local bOld_LEFT         := setkey( K_LEFT, NIL )
    local bOld_RIGHT        := setkey( K_RIGHT, NIL )
    local nOldRow           := row()
    local nOldCol           := col()

    local nMnuChoice := 1

    begin sequence

        while .T.
            statusLine()
            setcolor( COLOR_DEFAULT1 )
            scroll( 01, 00, 01, maxcol() )
            scroll( maxrow()-1, 00, maxrow()-1, maxcol() )
            @maxrow(),00 say padc( _KEY_MENU_H, maxcol()+1 )

            // The horizontal menu starts
            @01,01;
                prompt MNU_MENU_FILE_CHOICE;
                message MNU_MENU_FILE_MSG
            @row(),col()+1;
                prompt MNU_MENU_EDIT_CHOICE;
                message MNU_MENU_EDIT_MSG
            @row(),col()+1;
                prompt MNU_MENU_REPORT_CHOICE;
                message MNU_MENU_REPORT_MSG
            @row(),col()+1;
                prompt MNU_MENU_HTF_CHOICE;
                message MNU_MENU_HTF_MSG
            @row(),col()+1;
                prompt MNU_MENU_MACRO_CHOICE;
                message MNU_MENU_MACRO_MSG
            @row(),col()+1;
                prompt MNU_MENU_INFO_CHOICE;
                message MNU_MENU_INFO_MSG
            menu to nMnuChoice

            // [Left]/[Right] key redirection
            setkey( K_LEFT, { || mnuLeft() } )
            setkey( K_RIGHT, { || mnuRight() } )

            setcolor( COLOR_DEFAULT0 )

            // analisi del menu
            do case
            case nMnuChoice == 0 // ESC
                break
            case nMnuChoice == 1
                mnuvFile( 0, 0+len(MNU_MENU_FILE_CHOICE)+1 )
            case nMnuChoice == 2
                mnuvEdit( 5, 5+len(MNU_MENU_FILE_CHOICE)+1 )
            case nMnuChoice == 3
                mnuvReport( 10, 10+len(MNU_MENU_FILE_CHOICE)+1 )
            case nMnuChoice == 4
                mnuvHtf( 17, 17+len(MNU_MENU_FILE_CHOICE)+1 )
            case nMnuChoice == 5
                mnuvMacro( 21, 21+len(MNU_MENU_FILE_CHOICE)+1 )
            case nMnuChoice == 6
                mnuvInfo( 27, 27+len(MNU_MENU_FILE_CHOICE)+1 )
            end

            // arrow keys are released
            setkey( K_LEFT, NIL )
            setkey( K_RIGHT, NIL )

        end

    end sequence

    // restore
    setcolor( cOldColor )
    setcursor( nOldCursor )
    restscreen( ,,,, cOldScreen )
    set(_SET_WRAP, lOldSetWrap )
    set(_SET_MESSAGE, nOldSetMessage )
    set(_SET_MCENTER, lOldSetCenter )
    setpos( nOldRow, nOldCol )
    setkey( K_F1, bOld_F1 )
    setkey( K_F2, bOld_F2 )
    setkey( K_F3, bOld_F3 )
    setkey( K_F5, bOld_F5 )
    setkey( K_LEFT, bOld_LEFT )
    setkey( K_RIGHT, bOld_RIGHT )

    return NIL

#endif
//================================================================
// END
//================================================================

