/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   expo_fun.c: export records into achive files
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <signal.h>
#include "refs.h"
#include "abstr.h"
#include "keycodes.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "bbf_fun.h"
#include "sortbbf1.h"
#include "abbruch.h"
#include "cfg_fun.h"


#define REFZAHL_LEN 9
#define TEXTZEILEN_LEN 65
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000
#define ABS_ZEILE_LEN 30600

#define EXPO_TITELZEILE "REFERENCES VERSION 3.6 * EXPORT INTO AN ARCHIVE"

 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 static char txt_name[PFAD_LEN];
 static char log_name[PFAD_LEN];
 static char bbt_name[PFAD_LEN];
 extern char abstr_dat_name[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];

 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char txt_buf[TXTBUF_SIZE];
 static char bbt_buf[BBTBUF_SIZE];
 static long delaywrite;
 /* static long verzoegerung; */

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;
 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
 extern FILE * fpstichw;
 extern FILE * fpabs;

 static FILE * fpbbt;
 static FILE * fptxt;
 static FILE * fplog;


 static char * au_zeile;
 static char * ed_zeile;
 static char * ex_au_zeile;
 static char * abs_zeile;
 static char * desc_zeile;

 extern config_set one_config_set;

 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern keylistpix_rec         ix03rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;
 extern keylist_rec            one_stichw_rec;
 extern abstr_rec              one_abstr_rec;
 extern abstrpix_rec           ix04rec;

 static int eigene_kennziff;
   /*
    1: Die Kennziffern der Datenbank werden in das Archiv
       uebernommen
    2: Es werden eigene fortlaufende Kennziffern zugewiesen
   */
 static long erste_kennziff;

 int expo_fun_main(char * datpath);
 static int getfilenames(void);
 static int dateien_oeffnen_expo_fun(void);
 static void dateien_schliessen_expo_fun(void);
 static int machlist_expo_fun(void);
 static void compile_j1(void);
 static void compile_b1(void);
 static void compile_b2(void);
 static void compile_aued(FILE * fpaued, char * auedstring, long zeiger);
 static void compile_desc(char * desc_zeile, long zeiger);
 static void journal_archivieren(void);
 static void stichw_archivieren(void);
 static int add_abstract(char * kennziffer);
 static int fcode;
     /* Funktion-Code
        1: komplett
        2: keine keywords, journal names
     */

int expo_fun_main(char * datpath)
{
     delaywrite=one_config_set.delay_list_write;


     fcode = lotus_menu("@Complete$Write a complete archive with records, journal names and keywords (default)"
                        "@Exchange$Write an archive for exchange of records: no journal names, no keywords");

     if  ( !fcode )  return 1;

     if (!getfilenames()) return 1;

     if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,
            "'EXPORT REFERENCES': memory allocation error 001");
        beenden(fehlermeldung,2);
     }
     if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'EXPORT REFERENCES': memory allocation error 002");
        beenden(fehlermeldung,2);
     }
     if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'EXPORT REFERENCES': memory allocation error 003");
        beenden(fehlermeldung,2);
     }
     if ((abs_zeile =  (char *) malloc((ABS_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'EXPORT REFERENCES': memory allocation error 004");
        beenden(fehlermeldung,2);
     }
     if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'EXPORT REFERENCES': memory allocation error 005");
        beenden(fehlermeldung,2);
     }


     if (dateien_oeffnen_expo_fun())
     {
       machlist_expo_fun();
       dateien_schliessen_expo_fun();
     }


     if (isfile("_$.BBT")) remove("_$.BBT");
     if (isfile("_$$.BBT")) remove("_$$.BBT");


     free(au_zeile);
     free(ed_zeile);
     free(ex_au_zeile);
     free(abs_zeile);
     free(desc_zeile);

     wrtxt("\n[Please press any key for the main menu]>");
     tastelesen();
     return 0;
}

static int getfilenames(void)
{
  int taste;
  static char eingabe[DOSDATEIVORNAME_LEN +1];
  do
  {
    if (strlen(eingabe)==0) strcpy(eingabe,"BACK01");
    cls_line(EXPO_TITELZEILE);
    info_zeile("Edit filename for textfile, extension '.ARR' will be appended by the program");
    strcpy(wrtxtbu,"File name......");
    wrtxt(wrtxtbu);
    taste = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  eingabe,
                  DOSDATEIVORNAME_LEN,DOSDATEIVORNAME_LEN,0
                     );
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    if (taste==ESC_KEY)
    {
        cls_line("");
        return 0;
    }
    if (!isdosfilename(eingabe)) continue;
    if (taste==ENTER_KEY && strlen(eingabe) > 0) break;
  } while (1);
  upper(eingabe);
  strcpy(txt_name,eingabe);
  strcat(txt_name,".ARR");
  strcpy(log_name,eingabe);
  strcat(log_name,".LOG");
  if (isfile(txt_name))
  {
     taste = lotus_menu("Cancel$Archive file with the name already exists, do not overwrite"
                "@Overwrite$The contents of the existing archive file will be lost");
     if (taste<=1) return 0;
  }
  cls_line("");
  taste = datei_suchen("*.BBT",bbt_name);
  if (taste)
  {
     int sortiert_ok;
     char kennz_alt[KENNZIFFER_LEN + 1];
     long i, anzahl_records;
     sortiert_ok = 1;

     strcpy(kennz_alt,"");

     if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
     {
          sprintf(fehlermeldung,"ERROR: cannor read %s",bbt_name);
          beenden(fehlermeldung,2);
     }
     fseek(fpbbt,0L,SEEK_END);
     anzahl_records = ftell(fpbbt) / sizeof(one_bbt_rec) - 1;
     rewind(fpbbt);
     for (i=0;i<=anzahl_records;i++)
     {
         if (fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt)==0)
         {
             beeps();
             sprintf(wrtxtbu,"[ERROR: at least one record in %s not read]>",
                bbt_name);
             wrtxt(wrtxtbu);
             tastelesen();
         }
         if (strcmp(kennz_alt,one_bbt_rec.kennziffer)>=0)
         {
            sortiert_ok = 0;
            wrtxt("\n[It will be necessary to sort BBT-file, "
                     "please press any key]>");
            tastelesen();
            sc_gotoxy(1,one_config_set.sl);
            sc_clreol();
            break;
         }
         strcpy(kennz_alt,one_bbt_rec.kennziffer);
     }
     fclose (fpbbt);

     if (sortiert_ok)
     {
         return 1;
     }
     else
     {
        if (isfile("_$.BBT")) remove("_$.BBT");
        if (isfile("_$$.BBT")) remove("_$$.BBT");
        sprintf(wrtxtbu,"\nSorting records from file %s in ascending order...\n",bbt_name);
        wrtxt(wrtxtbu);
        domergebbf1(bbt_name,"_$.BBT");
        wrtxt("\nRemoving duplicate reference numbers...\n");
        dupl_ex_bbf("_$.BBT","_$$.BBT");
        strcpy(bbt_name,"_$$.BBT");
        return 1;
     }
  }
  else
  {
     wrtxt("\n[Export aborted, please press any key]>");
     tastelesen();
     return 0;
  }
}


static int dateien_oeffnen_expo_fun(void)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("ERROR: main index file is empty\n");
    return 0;
  }


  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    return 0;
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",desc_name);
    wrtxt(wrtxtbu);
    fclose(fpjournal);
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",abstr_dat_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }


  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",bbt_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    return 0;
  }
  if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fpbbt\n");
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    return 0;
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    return 0;
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",stichw_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    fclose(fpsource);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",txt_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fpstichw);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fptxt\n");
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fpstichw);
    fclose(fptxt);
    return 0;
  }
  if ((fplog=fopen(log_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",log_name);
    wrtxt(wrtxtbu);
    fclose(fpdesc);
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpabs);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fpstichw);
    fclose(fptxt);
    fclose(fplog);
    return 0;
  }

  return 1;
}

static void dateien_schliessen_expo_fun(void)
{
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpabs);
   fclose(fpbbt);
   fclose(fpsource);
   fclose(fpstichw);
   fclose(fptxt);
   fclose(fplog);
}

static int machlist_expo_fun(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int menupos, taste, ok;
   char zahl[REFZAHL_LEN+1];
   int schleifeok;

   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;
   wrtxt("\n");

   strcpy(zahl,"000000001");
   if (anzahl_records==-1)
   {
      wrtxt("Current BBT-file is empty\n");
      return 0;
   }

   erste_kennziff = 1;
    /* Die Variable sollte stets einen definierten Wert haben */

   taste=lotus_menu_default(
      &menupos,
     "@OriginalRefno$Original reference numbers are assigned to all exported references"
     "@Integer$Instead of original reference numbers, new numbers are assigned to all records"
                          );

   eigene_kennziff = 0;

   if (taste==0)
   {
      return 0;
   }
   if (taste==2)
   {
    schleifeok = 0;
    do
    {
      int wahl;
      sc_gotoxy(1,one_config_set.sl-1);
      info_zeile("Number assigned to the first reference [0..100,000,000]");
      strcpy(wrtxtbu,"[n].......");
      wrtxt(wrtxtbu);
      wahl = e_zle(
                    1+strlen(wrtxtbu),
                    one_config_set.sl-1,
                    zahl,
                    REFZAHL_LEN,
                    REFZAHL_LEN,
                    0);
      string_in_long(zahl,&j,&ok);
      if ((ok) && (j >= 0) && (j<=100000000) && (wahl==ENTER_KEY)) schleifeok=1; else schleifeok=0;
      sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      sc_gotoxy(1,one_config_set.sl);sc_clreol();
      sc_gotoxy(1,one_config_set.sl-1);

     }
     while (!schleifeok);
     eigene_kennziff = 1;
     erste_kennziff = j;
   }

  schleifeok = 0;
  /*
  strcpy(zahl,"0");
  do
  {
    int wahl;
    sc_gotoxy(1,one_config_set.sl-1);
    info_zeile("Enter delay time between processing of references in milliseconds [0..5000]");
    strcpy(wrtxtbu,"[msec]....");
    wrtxt(wrtxtbu);
    wahl = e_zle(
                     1+strlen(wrtxtbu),
                     one_config_set.sl-1,
                     zahl,
                     REFZAHL_LEN,
                     REFZAHL_LEN,
                     0);
    string_in_long(zahl,&verzoegerung,&ok);
    if ((ok) && wahl==ENTER_KEY && verzoegerung >=0 && verzoegerung <= 5000) schleifeok=1; else schleifeok=0;
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    sc_gotoxy(1,one_config_set.sl-1);

   }
   while (!schleifeok);
   */
   
   if (!read_ix01(journal_pix_name))
   {
      tastelesen();
      return 0;
   }
   if (!read_ix04(abstr_pix_name))
   {
      tastelesen();
      return 0;
   }
   sprintf(wrtxtbu,"Compiling %li references, please wait...\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);

   fprintf(fptxt,"****:BEGIN ARCHIVE\n");
   fprintf(fptxt,"\n****:BEGIN REFERENCES\n");
   for (i=0;i<=anzahl_records;i++)
   {
/*
#if defined(__EMX__)
        if (verzoegerung > 0) _sleep2((unsigned) verzoegerung);
#endif
#if defined(__DJGPP__)
        if (verzoegerung > 0) delay((unsigned) verzoegerung);
#endif
*/
        sc_gotoxy(1,one_config_set.sl);

        sprintf(wrtxtbu,"%.1f%% completed", (double) 100.0*(i+1)/(anzahl_records+1));
        wrtxt(wrtxtbu);
        sc_clreol();sc_gotoxy(1,one_config_set.sl);
        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);
        strcpy(haupt_schluessel,one_bbt_rec.kennziffer);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

           if (taste==1)
           {
              fprintf(fptxt,"\nRECN:%s\n",haupt_schluessel);
           }
           else
           {
              fprintf(fptxt,"\nRECN:%0*li\n",REFZAHL_LEN,j);
           }
           if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1();
           else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1();
           else compile_b2();

           add_abstract(haupt_schluessel);

           if (delaywrite > 0)
           {
#if defined(__EMX__)
              if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
              if (((i+1) % 200)==0) { delay (delaywrite); }
#endif
           }

        }
        else
          fprintf(fplog,"# %s: Reference not found\n",haupt_schluessel);
        j++;
   }
   fprintf(fptxt,"\n****:END REFERENCES\n");
   wrtxt("Writing CURRENT DATABASE completed...\n");

   close_ix01();
   close_ix04();
   if (!read_ix02(quell_pix_name))
   {
     tastelesen();
     return 0;
   }
   fprintf(fptxt,"\n****:BEGIN JOURNALS\n");

   if (fcode==1) journal_archivieren();

   fprintf(fptxt,"\n****:END JOURNALS\n");

   close_ix02();
   if (!read_ix03(stichw_pix_name))
   {
      tastelesen();
      return 0;
   }
   fprintf(fptxt,"\n****:BEGIN KEYWORDS THESAURUS\n");
   if (fcode==1) stichw_archivieren();
   fprintf(fptxt,"\n****:END KEYWORDS THESAURUS\n");
   fprintf(fptxt,"\n****:END ARCHIVE\n");
   close_ix03();
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   return 1;
}

static void compile_j1(void)
{
   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   fprintf(fptxt,"AUTH:%s\n",au_zeile);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   fprintf(fptxt,"JRNL:%s\n",one_journal_rec.kuerzel);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"MONP:%s\n",one_journal_rec.monat);
   fprintf(fptxt,"DAYP:%s\n",one_journal_rec.tag);
   fprintf(fptxt,"VOLM:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISNU:%s\n",one_journal_rec.issue_nummer);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr);
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}


static void compile_b1(void)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   fprintf(fptxt,"EDIT:%s\n",ed_zeile);
   fprintf(fptxt,"TITB:%s\n",one_buch_rec.titel_bu);
   fprintf(fptxt,"EDTN:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISBN:%s\n",one_buch_rec.isbn);
   fprintf(fptxt,"PLAC:%s\n",one_buch_rec.publ_ort);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"PUBL:%s\n",one_buch_rec.verlag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr);
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}



static void compile_b2(void)
{
   long byte_zeiger;

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   fprintf(fptxt,"DTYP:%s\n",one_journal_rec.reftyp);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   fprintf(fptxt,"AUTH:%s\n",au_zeile);
   fprintf(fptxt,"TITA:%s\n",one_journal_rec.titel);
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   fprintf(fptxt,"EDIT:%s\n",ed_zeile);
   fprintf(fptxt,"TITB:%s\n",one_buch_rec.titel_bu);
   fprintf(fptxt,"EDTN:%s\n",one_journal_rec.band);
   fprintf(fptxt,"ISBN:%s\n",one_buch_rec.isbn);
   fprintf(fptxt,"PLAC:%s\n",one_buch_rec.publ_ort);
   fprintf(fptxt,"YEAR:%s\n",one_journal_rec.jahrgang);
   fprintf(fptxt,"PUBL:%s\n",one_buch_rec.verlag);
   fprintf(fptxt,"PGFR:%s\n",one_journal_rec.seite_von);
   fprintf(fptxt,"PGTO:%s\n",one_journal_rec.seite_bis);
   fprintf(fptxt,"STAT:%s\n",one_journal_rec.status);
   compile_desc(desc_zeile,ix01rec.desc_rptr);
   fprintf(fptxt,"KEYW:%s\n",desc_zeile);
}



static void compile_aued(FILE * fpaued, char * auedstring, long zeiger)
{
   int anzahl_n, i;
   long byte_zeiger;
   strcpy(auedstring,"");
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   anzahl_n = one_aued_rec.au_n;
   for (i=1;i<=anzahl_n;i++)
   {
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring,",",AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_vornamen,AUTORZEILE_LEN);
        if  (i<anzahl_n) strlimcat(auedstring,";",AUTORZEILE_LEN);
   }
}


static void compile_desc(char * desc_zeile, long zeiger)
{
   int n_desc, i;
   long byte_zeiger;
   strcpy(desc_zeile,"");

   byte_zeiger = zeiger * sizeof(one_desc_rec);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   n_desc = one_desc_rec.desc_n;
   for (i=1;i<=n_desc;i++)
   {
        fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
        strlimcat(desc_zeile,one_desc_rec.keywordsfield,DESC_ZEILE_LEN);
        if (i< n_desc)
        {
          strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
        }
   }
   return;
}

static void journal_archivieren(void)
{
  long i, anzahl_records, byte_zeiger;
  wrtxt("Writing JOURNAL names into archive...\n");
  fseek(ix02file,0L,SEEK_END);
  byte_zeiger = ftell(ix02file);
  anzahl_records = byte_zeiger / sizeof(ix02rec);
  anzahl_records--;
  rewind(ix02file);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpsource,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);

      fprintf(fptxt,"\nJCOD:%s\n",one_quell_rec.quell_kuerzel);
      fprintf(fptxt,"ISSN:%s\n",one_quell_rec.quell_issn);
      fprintf(fptxt,"JNAM:%s\n",one_quell_rec.quell_zeitschrift);
      fprintf(fptxt,"JS01:%s\n",one_quell_rec.quell_kurzform);

  }
}



static void stichw_archivieren(void)
{
  long i, anzahl_records, byte_zeiger;
  wrtxt("Writing KEYWORD table into archive...\n");
  fseek(ix03file,0L,SEEK_END);
  byte_zeiger = ftell(ix03file);
  anzahl_records = byte_zeiger / sizeof(ix03rec);
  anzahl_records--;
  rewind(ix03file);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_stichw_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);

      fprintf(fptxt,"\nKEYT:%s\n",one_stichw_rec.keywordsfield);
  }
}


static int add_abstract(char * kennziffer)
{
   long rec_zeiger, byte_zeiger, j, anzahl_bloecke;

   fprintf(fptxt,"ABST:");
   strcpy(abs_zeile,"");
   if (locate_ix04(one_bbt_rec.kennziffer,&ix04rec)!=-1)
   {
       rec_zeiger = ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
       fseek(fpabs,byte_zeiger,SEEK_SET);
       anzahl_bloecke = one_abstr_rec.abstr_n;
       for (j=1;j<=anzahl_bloecke;j++)
       {
           fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
           strlimcat(abs_zeile,one_abstr_rec.abs_text,ABS_ZEILE_LEN);
       }
       fprintf(fptxt,"%s",abs_zeile);
   }
   fprintf(fptxt,"\n");
   return 1;
}

#undef REFZAHL_LEN
