/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/

/*
   f1_fun.c 
   help function
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include "fl_ut.h"
#include "f1_fun.h"
#include "refs.h"
#include "l_menu.h"
#include "str_fun.h"
#include "cfg_fun.h"
#include "vtxt.h"

#define HILFSFUNKTION_TITELZEILE "REFERENCES VERSION 3.6 * HELP"

 extern char wrtxtbu[WRTXTBU_LEN];
 extern config_set one_config_set;

 static void f1_text_zeigen(const char * txt);
 int edit_hilfe_befehl_schreiben(char * dateiname);



int f1_fun_main(void)
{
   static int taste, menupos;

   cls_line(HILFSFUNKTION_TITELZEILE);
   do
   {
       taste = lotus_menu_default(
                     &menupos,
                   "@MainMenuOptions$Short description of main menu options"
                   "@HelpFiles$Load text file of the documentation into the text editor/viewer"
                   "@View$View help file"
                   "@About$Information about REFERENCES, Version 3.6"
                          );
       if (taste==1) /* Menu option: MainMenuOptions */
       {
          f1_text_zeigen(F1_HAUPTMENU01);
       }
       
       else if (taste == 2) /* Menu option HelpFiles */
       {
         static int dateipos;
         char dname[PFAD_LEN+1];
         char dmaske[PFAD_LEN+1];
         char datei[PFAD_LEN+1];
         strcpy(dname,"");
         strcpy(dmaske,"");
         strcpy(datei,"");

         cls_line("");
         strcpy(dmaske,one_config_set.help_path);
         rtrim(dmaske,'\\');

         strcat(dmaske,"\\");
         /* Verzeichnis ist nicht zu lesen */
         if (isdirectory(dmaske)==0)
         {
             cls_line(HILFSFUNKTION_TITELZEILE);
             sprintf(wrtxtbu,"\n[Cannot read directory '%s' "
                       "please press any key]>",dmaske);
             wrtxt(wrtxtbu);
             tastelesen();
             cls_line(HILFSFUNKTION_TITELZEILE);
             continue;
         }

         strcat(dmaske,"*.*");
         if (datei_suchen_default(dmaske,dname,&dateipos))
         {
            strcpy(datei,one_config_set.help_path);
            rtrim(datei,'\\');
            strlimcat(datei,"\\",PFAD_LEN);
            strlimcat(datei,dname,PFAD_LEN);
            edit_hilfe_befehl_schreiben(datei);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
         }
         cls_line(HILFSFUNKTION_TITELZEILE);
       }
       else if (taste==3)  /* Menu option: View */
       {
         static int dateipos;
         char dname[PFAD_LEN+1];
         char dmaske[PFAD_LEN+1];
         char datei[PFAD_LEN+1];
         strcpy(dname,"");
         strcpy(dmaske,"");
         strcpy(datei,"");


         cls_line("");
         strcpy(dmaske,one_config_set.help_path);
         rtrim(dmaske,'\\');

         strcat(dmaske,"\\");
         /* Verzeichnis ist nicht zu lesen */
         if (isdirectory(dmaske)==0)
         {
             cls_line(HILFSFUNKTION_TITELZEILE);
             sprintf(wrtxtbu,"\n[Cannot read directory '%s' "
                       "please press any key]>",dmaske);
             wrtxt(wrtxtbu);
             tastelesen();
             cls_line(HILFSFUNKTION_TITELZEILE);
             continue;
         }

         strcat(dmaske,"*.*");
         if (datei_suchen_default(dmaske,dname,&dateipos))
         {
            strcpy(datei,one_config_set.help_path);
            rtrim(datei,'\\');
            strlimcat(datei,"\\",PFAD_LEN);
            strlimcat(datei,dname,PFAD_LEN);
            vtxt_main(datei);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
         }
         cls_line(HILFSFUNKTION_TITELZEILE);         

       }

       else if (taste==4)  /* Menu option: About */
       {
          f1_text_zeigen(F1_ABOUT);
       }
       else if (taste==0) break;
   } while(1);
   return 0;
}


static void f1_text_zeigen(const char * txt)
{
   int i, n_zeilen, taste;
   char zeile[SCREENLINE_LEN + 256];
   cls_line("");
   n_zeilen=countitem(txt,"@");
   taste = 200;
   for (i=1;i<=n_zeilen;i++)
   {
      if ((i==one_config_set.sl-3) ||
         ((i % (one_config_set.sl - 4))==0 &&
           i > (one_config_set.sl - 4)))
      {
        wrtxt("\n");
        taste = lotus_menu(
           "@NextPage$Show the next page or the remaining text"
           "@Cancel$Finish viewing the current text"
                          );
        if (taste==0 || taste==2)
        {
            break;
        }
        sc_gotoxy(1,one_config_set.sl - 2);
      }
      extractitem(i,txt,"@",zeile);
      wrtxt(zeile);
      wrtxt("\n");
   }
   if (taste!=0 && taste !=2) wrtxt("\n");
}


int edit_hilfe_befehl_schreiben(char * dateiname)
{
   FILE * fpcmd;
   /*
     name of text file in help file directory 
   */
   char kommandopfad[PFAD_LEN];

   strcpy(kommandopfad,one_config_set.call_editor_command_file);
   upper(one_config_set.call_editor_command_file);
   if ((fpcmd=fopen(kommandopfad,"wt"))==NULL)
   {
      sprintf(wrtxtbu,"\n[ERROR: Unable to create %s batch file]>",kommandopfad);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fprintf(fpcmd,"%s %s",one_config_set.text_pager,dateiname);
   fflush(fpcmd);
   fclose(fpcmd);
   sprintf(wrtxtbu,"\nPlease call '%s' to view %s\n\n",
            one_config_set.call_editor_command_file,dateiname);
   wrtxt(wrtxtbu);
   wrtxt("[Please press any key]>");
   tastelesen();
   return 1;
}
