/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
    l_menu.c
*/
#include <stdio.h>
#include <string.h>
#if defined(__EMX__) && !defined(MIT_ANSI_SYS)
  #include <sys/video.h>
#endif
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#if defined(__DJGPP__)
  #include <pc.h>
#endif
#include <dos.h>
#include "l_menu.h"
#include "keycodes.h"
#include "str_fun.h"
#include "cfg_fun.h"
#include "refs.h"

 extern config_set one_config_set;

#if defined(MIT_ANSI_SYS)
  extern ansi_farben_set one_ansi_farben_set;
#elif defined(__DJGPP__)
  extern ansi_farben_set one_ansi_farben_set;
#elif defined(__EMX__)
  extern ansi_farben_set one_ansi_farben_set;
#endif

int lotus_menu(char * zeile)
{
   int he;
   he = 0;
   return lotus_menu_default(&he,zeile);
}


int lotus_menu_default(int * hell, char * zeile)
{
  unsigned int i,lauf;
  char erste_zeile[256];
  char menusuch[256];
  char wort[100];
  char menupunkt[256];
  char kommentar[100];
  int mpunkte = countitem(zeile,"@");
  int taste = 200;
  if (* hell < 1) * hell = 1;
  if (* hell > mpunkte) * hell = mpunkte;
  wrtxt("\n");
  do
  {
      int x_pos;
      strcpy(erste_zeile,"");
      for (i=1;i<=mpunkte;i++)
      {
        extractitem(i,zeile,"@",menupunkt);
        extractitem(1,menupunkt,"$",wort);
        if (i== * hell)
        {
          extractitem(2,menupunkt,"$",kommentar);
        }
        if (i!= * hell)
        {
           if (i!=1)
           strcat(erste_zeile," ");
           else
           strcat(erste_zeile,"");
           strcat(erste_zeile,wort);
           strcat(erste_zeile," ");
        }
        else
        {

          if (i!=1)
          {
           strcat(erste_zeile," ~");
           x_pos = strlen(erste_zeile);
          }
          else
          {
           strcat(erste_zeile,"~");
           x_pos = 1;
          }
          /* 
           * next line new 21.4.2000 for compiled versions without 
           * reverse highlighting 
           */
          /* upper(wort); */
          strcat(erste_zeile,wort);
          strcat(erste_zeile,"~ ");
        }
      }
      sc_gotoxy(1,one_config_set.sl-1);
      zs(erste_zeile);
      sc_clreol();
      wrtxt("\n");
      zs(kommentar);
      sc_clreol();
      sc_gotoxy(x_pos,one_config_set.sl-1);
      taste = tastelesen();
      if (taste==RIGHT_KEY)
      {
        if (* hell==mpunkte)
        {
           * hell=1;
        } else  (* hell)++;
      }
      else if (taste==LEFT_KEY)
      {
        if ( * hell==1)
        {
           * hell=mpunkte;
        } else  (* hell)--;
      }

      else if (taste==HOME_KEY)
        * hell=1;
      else if (taste==END_KEY)
        * hell=mpunkte;

      else
      {
         for (lauf=1;lauf<=mpunkte;lauf++)
         {
            extractitem(lauf,zeile,"@",menusuch);
            if ((taste>32) && (taste<150) && (toupper(taste)==toupper(menusuch[0])))
            {
              * hell=lauf;
              taste = ENTER_KEY;
              break;
            }
         }
      }
  } while ((taste!=ENTER_KEY)&&(taste!=ESC_KEY));
  sc_gotoxy(1,one_config_set.sl);sc_clreol();
  sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
  if (taste!=ESC_KEY)
     return * hell;
  else return 0;
}


void sc_gotoxy(int x,int y)
{
#if defined(MIT_ANSI_SYS)
   printf("\033[%i;%iH",y,x);
   fflush(stdout);
#elif defined(__EMX__)
    v_gotoxy(x-1,y-1);
#elif defined(__DJGPP__)
    gotoxy(x,y);
#endif
}


void sc_clrscr(void)
{
#if defined(MIT_ANSI_SYS)
   printf("\033[2J");
   fflush(stdout);
#elif defined(__EMX__)
   v_clear();
   sc_gotoxy(1,1);
#elif defined(__DJGPP__)
   clrscr();
#endif

}


void sc_clreol(void)
{
#if defined(MIT_ANSI_SYS)
   printf("\033[0K");
   fflush(stdout);
#elif defined(__EMX__)
   v_clreol();
#elif defined(__DJGPP__)
   clreol();
#endif
}

int tastelesen(void)
{
  int c;
  int extended = 0;
  c = getch();
  if (!c)
    {
        extended = getch();
        c = -extended;
    }
    return c;
}


void zs(char * buntezeile)
{
  int i;
  int istinvert = 0;
  char puff[2];
  int laenge;

  laenge = strlen(buntezeile);
  for (i=0;i < laenge;i++)
  {
     if ((buntezeile[i]=='~') && (istinvert==0))
     {
#if defined(MIT_ANSI_SYS)
        wrtxt(one_ansi_farben_set.farbe_inv);
#elif defined(__EMX__)
        v_attrib(one_ansi_farben_set.farbe_inv);
#elif defined(__DJGPP__)
        textcolor(one_ansi_farben_set.farbe_inv_v);
        textbackground(one_ansi_farben_set.farbe_inv_h);
#endif
        istinvert = 1;
     }
     else if ((buntezeile[i]=='~') && (istinvert!=0))
     {
#if defined(MIT_ANSI_SYS)
         wrtxt(one_ansi_farben_set.farbe_norm);
#elif defined(__EMX__)
         v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
         textcolor(one_ansi_farben_set.farbe_norm_v);
         textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
         istinvert = 0;
     }
     else
     {
         sprintf(puff,"%c",buntezeile[i]);
         wrtxt(puff);
     }
  }
}



void zeile_schreiben(
                      char * inzeile,
                       int zeiger,
                       int lang,
                       int xcoor,
                       int ycoor
                     )
{
  int lauf;
  int inzeilelen;

  inzeilelen = strlen(inzeile);
  if (one_config_set.colors != 0 &&
      one_config_set.colors != 1
     )
  {
#if defined(MIT_ANSI_SYS)
    wrtxt(one_ansi_farben_set.farbe_e_zle);
#elif defined(__EMX__)
    v_attrib(one_ansi_farben_set.farbe_e_zle);
#elif defined(__DJGPP__)
    textcolor(one_ansi_farben_set.farbe_e_zle_v);
    textbackground(one_ansi_farben_set.farbe_e_zle_h);
#endif
  }

  if (zeiger > lang)
  {
     sc_gotoxy(xcoor,ycoor);
     for (lauf=(zeiger-lang);lauf<=zeiger;lauf++)
     {
       char buf[2];
       if (lauf <= inzeilelen)
          {
            sprintf(buf,"%c",inzeile[lauf-1]);
            wrtxt(buf);
          }
          else if (lauf==inzeilelen+1) wrtxt(" ");
     }
     sc_gotoxy(xcoor+lang+1,ycoor);
  } else
  {
     sc_gotoxy(xcoor,ycoor);
     for (lauf=1;lauf <= lang+1;lauf++)
     {
         char buf[2];
       if (lauf <= inzeilelen)
       {
          sprintf(buf,"%c",inzeile[lauf-1]);
          wrtxt(buf);
       }
       else
       {
          wrtxt("_");
       }
     }
     sc_gotoxy(xcoor+zeiger,ycoor);
  }
  if (one_config_set.colors!= 0 &&
      one_config_set.colors != 1
     )
  {
#if defined(MIT_ANSI_SYS)
     wrtxt(one_ansi_farben_set.farbe_norm);
#elif defined(__EMX__)
     v_attrib(one_ansi_farben_set.farbe_norm);
#elif defined(__DJGPP__)
     textcolor(one_ansi_farben_set.farbe_norm_v);
     textbackground(one_ansi_farben_set.farbe_norm_h);
#endif
  }
}

/*
   Aufruf der Eingabezeile
*/

int  e_zle (
        int xco,            /* x-Position der li. '[' der Eingabezeile */
        int yco,            /* y-Position der li. '[' der Eingabezeile */
        char * inzeile,     /*Die zu bearbeitende Textzeile*/
        int lang,           /*Laenge des Bildsch.-bereichs*/
        int stlaenge,       /*interne Laenge des Strings*/
        int blockiert       /* 2: zeigen, 1: nur lesen, 0: schreiben */
               )
{
   int taste = 0;
   int xcoor, ycoor;
   long zeiger;
   char puff[100];
   int insertmode;


   inzeile[stlaenge] = '\0';


   insertmode = one_config_set.insert_mode;
   if (stlaenge <1) stlaenge = 1;
   lang--;
   sc_gotoxy(xco,yco);
   if (blockiert==0)
   {
      sprintf(puff,"[%*s",(int) lang+2,"]");
      wrtxt(puff);
   }
   else if (blockiert==2)
   {
      sprintf(puff,"[%*s",(int) lang+2,"]");
      wrtxt(puff);
   }
   else       /* blockiert == 1 */
   {
      sprintf(puff,"(%*s",(int) lang+2,")");
      wrtxt(puff);
   }
   sc_gotoxy(xco+1,yco);
   xcoor = xco+1;
   ycoor = yco;
   zeiger = 0;
   taste = 0;
   do
   {
     zeile_schreiben(inzeile,(int) zeiger,lang,xcoor,ycoor);
     if (blockiert==2) {taste=0; break; }
     taste = tastelesen();

     if (taste==INS_KEY)
     {
        if (insertmode==1)
        {
           insertmode = 0;
        }
        else
        {
           insertmode=1;
        }
     }
     if (taste == LEFT_KEY)
     {
       zeiger--;
       if (zeiger < 0) zeiger = 0;
       if (zeiger > strlen(inzeile)) zeiger =  strlen(inzeile);
     }
     if (taste == RIGHT_KEY)
     {
       zeiger++;
       if (zeiger < 0) zeiger = 0;
       if (zeiger > strlen(inzeile)) zeiger =  strlen(inzeile);
     }
     if (!blockiert && taste == DEL_KEY)
     {
       str_del_char(inzeile, (int) zeiger+1);
     }

     if (!blockiert && taste == BACKSPACE_KEY)
     {
        str_del_char(inzeile, (int) zeiger);
        zeiger = zeiger - 1;
        if (zeiger < 0) zeiger = 0;
     }

     if (!blockiert && taste == CTRLBACKSPACE_KEY)
     {
       strncpy(inzeile,"",stlaenge);
       zeiger = 0;
     }

     if (!blockiert && taste==ALTI_KEY)
     {
        strncpy(inzeile,"",stlaenge);
        cb_lesen(inzeile,stlaenge);
        zeiger = 0;
     }
     if (!blockiert && taste==ALTC_KEY)
     {
        cb_schreiben(inzeile);
        zeiger = 0;
     }


     if (taste==HOME_KEY) zeiger = 0;
     if (taste==END_KEY) zeiger = strlen(inzeile);
     if (taste == CTRLLEFT_KEY)
     {
        zeiger = zeiger-5;
        if (zeiger < 0) zeiger = 0;
     }

     if (taste == CTRLRIGHT_KEY)
     {
        zeiger = zeiger + 5;
        if (zeiger > strlen(inzeile)) zeiger = strlen(inzeile);
     }


     /* hier werden Buchstaben eingefuegt... */
     if  (
         (taste > 31) &&
         (taste < 254) &&
         (taste !=CTRLBACKSPACE_KEY)
         )
     {
       if (blockiert)
          {
            beeps();
          }
       else
       {
         if (insertmode)
         {
            if (strlen(inzeile)>=stlaenge)
            {
               beeps();
            } else
            {
               str_ins_char(inzeile,(char) taste, (unsigned int) zeiger);
               zeiger++;
            }
         }
         else
         {
            if (strlen(inzeile)>=stlaenge && zeiger>=stlaenge)
            {
               beeps();
            } else
            {
               str_over_char(inzeile,(char) taste, (unsigned int) zeiger);
               zeiger++;
            }
         }
       }

     }


   } while (
             (taste!=ENTER_KEY) &&     /* Enter */
              (taste!=ESC_KEY) &&    /* Escape */
              (taste!=TAB_KEY) &&     /* Tab */
              (taste!=SHIFTTAB_KEY) &&   /* Shift-Tab */
              (taste!=UP_KEY) &&   /* Up */
              (taste!=DOWN_KEY) &&   /* Down */
              (taste!=PGUP_KEY) &&   /* PgUp */
              (taste!=PGDN_KEY) &&   /* PgDn */
              (taste!=CTRLPGDN_KEY) &&  /* Ctrl-PgDn */
              (taste!=CTRLPGUP_KEY) &&  /* Ctrl-PgUp */
              (taste!=CTRLHOME_KEY) &&  /* Ctrl-Home */
              (taste!=CTRLEND_KEY) &&  /* Ctrl-End */
              !((taste >=F10_KEY) && (taste <=F1_KEY)) &&     /* F1..F10 */
              !((taste >=SHIFTF10_KEY) && (taste <=SHIFTF1_KEY)) &&     /* Shift-F1..Shift-F10 */
              !((taste >=ALTF10_KEY) && (taste <=ALTF1_KEY)) &&   /* Alt-F1..Alt-F10 */
              !((taste >=CTRLF10_KEY) && (taste <=CTRLF1_KEY))       /* Ctrl-F1..Ctrl-F10 */
           );
   zeiger = 0;

   zeile_schreiben(inzeile, (unsigned int) zeiger,lang,xcoor,ycoor);
   one_config_set.insert_mode = insertmode;
   sc_gotoxy(xcoor-1,ycoor);
   return taste;
}



void info_zeile(char * zle)
{
    int xwert, ywert;
    xwert=1;
    ywert= one_config_set.sl-1;
    sc_gotoxy(1,one_config_set.sl);
    wrtxt(zle);
    sc_clreol();
    sc_gotoxy(xwert,ywert);
}

int wrtxt(char * zle)
{
#if defined(MIT_ANSI_SYS)
  printf("%s",zle);
  fflush(stdout);
  return 0;
#elif defined(__EMX__)
  v_puts(zle);
  return 0;
#elif defined(__DJGPP__)
  int i, laenge;
  if (strchr(zle,'\n')==NULL)
  {
     cprintf("%s",zle);
     return 0;
  }
  else
  {
     laenge = strlen(zle);
     for (i=0;i<laenge;i++)
     {
        if (zle[i]=='\n')
        {
           putch('\r');putch('\n');
        }
        else
        {
           putch(zle[i]);
        }
     }
     return 0;
  }
#endif
}

int beeps(void)
{
#if defined(__EMX__)
   printf("\a");
   fflush(stdout);
   return 0;
#endif
#if defined(__DJGPP__)
   sound(110);
   delay(200);
   nosound();
   return 0;
#endif
}


/* 
 * Reads the file CBFILE (clipboard) and copies into the input line 
 */
int cb_lesen(char * inzeile, unsigned int stlaenge)
{
    unsigned int i;
    FILE * fpcb;
    int ch;

    ch = 0;
    i = 0;
    if ((fpcb=fopen(CBFILE,"rt"))==NULL)
    {
       return 0;
    }
    do
    {
       ch=fgetc(fpcb);
       if (ch!=EOF && ch!='\n')
       {
          inzeile[i]=ch;
       }
       else
       {
           inzeile[i] = '\0';
       }
       i++;
    } while (ch!=EOF && ch != '\n' && i < stlaenge);
    inzeile[stlaenge]='\0';
    fclose(fpcb);
    return 1;
}


/* 
 * Writes the contents of the text entry field into the CBFILE file
 * (clipboard) 
 */
int cb_schreiben(char * inzeile)
{
    FILE * fpcb;
    if ((fpcb=fopen(CBFILE,"wt"))==NULL)
    {
       return 0;
    }
    fprintf(fpcb,"%s",inzeile);
    fclose(fpcb);
    return 1;
}


void cls_line(const char * zeile)
{
   sc_clrscr();
   wrtxt((char*) zeile);
   sc_gotoxy(1,one_config_set.sl-1);
}
