
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <conio.h>
#include <errno.h>

/////////////////////////////////////////////////////////////////////////////

#define TRUE  1
#define FALSE 0

char copyright [] = "Saverio Russo";
char email [] ="octopus1@blast.net";       // as of this moment
char icq [] = "ICQ-ADDRESS = 6542680";
/////////////////////////////////////////////////////////////////////////////

#define MAXBUF  65
#define MAXSTR  39

static unsigned long GetLong (char *str);
static char *HexStr          (char *s, unsigned long ln);
static char *BinStr          (char *s, unsigned long ln);
static void ErrMsg           (char *msg, char ch);
static int  isoctal          (int c);
static int  isbinary         (int c);
static char GetNibble        (char c);

struct {
   char *text;
   int (*isfunc) (int);
   unsigned int radix;
   char *pre;
} IsChar[] = {
   { " decimal ",     isdigit,  10, "" },
   { " hexidecimal ", isxdigit, 16, "0x\0" },
   { " octal ",       isoctal,   8, "0\0" },
   { " binary ",      isbinary,  2, "" }
};

////////////////////////////////////////////////////////////////////////////

void main(int argc, char *argv[])
{
   char number[MAXBUF];
   unsigned long num;

   // must supply one parameter only
   if (argc == 1)
   {
      printf( "\n  usage:  base <#[RADIX]>\n\n"
              "       #   = decimal number (default)\n"
              "      #[h] = hexidecimal number\n"    
              "      #[o] = octal number\n"  
              "      #[i] = binary number\n");

      exit(0);
   }
  
   if (strlen(argv[1]) > 33)
        argv[1][33] = '\0';

   num = GetLong(strcpy(number, argv[1]));

   printf("\n\n    Dec: %12lu"
          "   Hex: %s\n"
          "    \n"
          "    Oct: %12lo"
          "   Bin: %s\n", num, HexStr(number, num), num, BinStr(number, num));
}

static void ErrMsg(char *msg, char ch)
{
   printf("\n   %s", msg);

   if (ch)
       printf("   Character %c is at fault.\n", ch);
   else
       putchar('\n');
}

// filter out bad characters from incoming string
// returns an unsigned long
static unsigned long GetLong(char *str)
{
   char *p = strlwr(str);
   char temp[MAXBUF];
   int  c;
   unsigned long longn;

   for (c = 0; *p; p++)
   {
      if (!isdigit(*p) && !isxdigit(*p))
      {
         if (*p != 'h' && *p != 'o' && *p != 'i')
         {
            ErrMsg("ERROR!!!  bad character in input.", *p);
            exit(1);
         }
         else
         {
            if (*(p+1) == '\0')
            {
                c =  *p;
               *p = '\0';

               if      (c == 'h') c = 1;
               else if (c == 'o') c = 2;
               else if (c == 'i') c = 3;
            }
         }
      }
   }

   for (p = strlwr(str); *p; p++ )
   {
      if (IsChar[c].isfunc(*p) == 0)
      {
         sprintf(temp, "Error in %s input!!!", IsChar[c].text);
         ErrMsg(temp, *p);
         exit(1);
      }
   }

   strcat(strcpy (temp, IsChar[c].pre), str);
   longn = strtoul(temp, &p, IsChar[c].radix);

   if (errno == ERANGE)
   {
      ErrMsg("Number to large!!!  must not be grater than 4294967295", 0);
      exit(1);
   }

   return longn;
}


// format the incoming four byte unsigned long into a string containing
// eight hexidecimal characters of which each hex character is constructed
// from one nibble from the unsigned long 'ln'.
// incoming 'hexstr' must contain at least MAXSTR (39) bytes.
static char *HexStr(char *s, unsigned long ln)
{
   static char hexstr[MAXBUF];
   int j;
   char *p;

   strcpy(hexstr, s);

   for (j = 0; j < MAXSTR; j++)
           { hexstr[j] = 0x20; }

   hexstr[j] = '\0';  // make string
   p = (char *) &ln;

   for (j = 5; j > 1; j--)
   {
      hexstr[ 10*j-12 ] = GetNibble( *(p+5-j) & 0x0f);
      hexstr[ 10*j-17 ] = GetNibble((*(p+5-j) & 0xf0) >> 4);
   }

   return strlwr(hexstr);
}

// format binary output into eight nibles
static char *BinStr(char *s, unsigned long ln)
{
   int i, j, n;
   char str[MAXBUF];
   static char binstr[MAXBUF];

   strcpy(binstr, s);
  
   ultoa(ln, binstr, 2);
   strrev(binstr);
  
   for (i = j = n = 0; j < MAXSTR; i++, j++)
   {
      if (i == 4) { str[j++] = 0x20; i = 0; }
      binstr[n] ? (str[j] = binstr[n++]) : (str[j] = 0x30);
   }
  
   str[j] = '\0';
   return strcpy(binstr, strrev(str));
}

static int isoctal (int c)
{
   return (c >= '0' && c <= '7');
}

static int isbinary(int c)
{
   return (c >= '0' && c <= '1');
}

static char GetNibble(char c)
{
   return ((c > (8 + 1)) ? c + '7' : c + '0');
}
