#ifndef __MESSAGES_H
#define __MESSAGES_H

#ifndef CALENDAR_MODE
#define CALENDAR_MODE 1
#endif /* CALENDAR_MODE */

#include "bstring.h"
#include "vector.h"
#include "data.h"
#include "gui.h"

class messages
	{
	public:
		messages (int m, int d, int y, bstring h, Mcursor & mouse, int c_mode = 0);
		~messages ();

		void search (bstring the_string); /* search for given string
						returns 0 if no match, 1 if
						match was found */
		void show ();

		/* both above return -2 on normal exit, otherwise the location
		   if an edit was requested. */

		int quickfind (); // finds dates that occur
				// both on given date & before given date.

		long int the_edit; /* this gets set by get if an edit is
				      requested.  this variable gets set
				      to the value requested to be edited. */

	private:
		int month, day, year;

		void messages_help ();
		void activate();
		void do_search();
		void read();
		void find ();
		void reading_data (int update = 0); /* set to one to get
					 updating, set = 2 to get searching */
		void clear_reading_data ();
		void gr_clear ();
		void remove ();
		int edit();

		int get(); /* returns 2 if update & exit, 1 if exit.  Sets
			      the variables the_edit to a location (> -1)
			      if an edit is requested. */
		int current;
		int found;

		Mcursor & the_mouse;
		bstring home;
		vector<data>  the_data;

		bstring	search_string;

		int calendar_mode;
// calendar_mode == 1, reg. calendar mode.  == 2 if search mode!
		};

#endif /* __MESSAGES_H */