;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QEMMACES.ASM	Get/set debug registers via QEMM API	*
;*									*
;************************************************************************
;LastEdit: 1/15/93

	INCLUDE	API.INC
	Header@

.386

;========================================================================

CSeg@

extrn $DVG$QEMMCALL:near

;------------------------------------------------------------------------

PubProc@ QEMMGET_DEBUG,__PASCAL__
@regs = DPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	mov	ax,1001h		; get CPU debug registers
	LES_	di,@regs
IF LDATA eq 0
	push	ds
	pop	es
ENDIF ;LDATA
	call	$DVG$QEMMCALL
	mov	ax,-1			; assume error
	jc	getdebug_done
	mov	al,bl			; return INT01 state if no error
	mov	ah,0			; zero-extend to 16 bits
getdebug_done:
	pop	di
	pop	es
	pop	bp
	ret	dPtrSize
EndProc@ QEMMGET_DEBUG,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMSET_DEBUG,__PASCAL__
@INT01 = word ptr [bp+2+cPtrSize+dPtrSize]
@regs = DPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	mov	ax,1002h		; set CPU debug registers
	mov	bl,byte ptr @INT01
	LES_	di,@regs
IF LDATA eq 0
	push	ds
	pop	es
ENDIF ;LDATA
	call	$DVG$QEMMCALL
	mov	ax,0			; assume error (AX=0 means "error")
	jc	setdebug_done
	inc	ax			; AX <- 1 ("OK")
setdebug_done:
	pop	di
	pop	es
	pop	bp
	ret	2+dPtrSize
EndProc@ QEMMSET_DEBUG,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMGET_CR0,__PASCAL__
	mov	ax,1003h		; get CR0 register
	call	$DVG$QEMMCALL
	jc	getCR0_error
	push	eax
	shr	eax,16
	mov	dx,ax
	pop	eax
	ret

getCR0_error:
	mov	ax,-1
	mov	dx,ax
	ret
EndProc@ QEMMGET_CR0,__PASCAL__

;------------------------------------------------------------------------

CSegEnd@

	END
