;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File WINASYNC.ASM	Asynchronous notification of events	*
;*									*
;************************************************************************
;LastEdit: 12/29/92

	INCLUDE API.INC
	INCLUDE DVSTREAM.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

MIN_STACK equ 128
DEF_STACK equ 512

LOCAL_STACK STRUC
IF LDATA
  ls_next	dd ?
ELSE
  ls_next	dw ?
ENDIF
  ls_window	dd ?
  ls_events	dw ?
IF LPROG
  ls_func	dd ?
ELSE
  ls_func	dw ?
ENDIF
  ls_stktop	dw ?
IFDEF DV386
  ls_stktopseg	dw ?
ENDIF
LOCAL_STACK ENDS

;========================================================================
  
DSeg@
S_MANAGER	async_stream
	MS_PRIM_ASYNC 0,0
	MS_SEC_ASYNC 0,0
	S_END	async_stream

IF LDATA
local_stacks dd	0
ELSE
local_stacks dw 0
ENDIF
DSegEnd@

;========================================================================

CSeg@

ExtProc@ $DVG$NOTIFY,__PASCAL__
ExtProc@ $DVG$NONOTIFY,__PASCAL__
ExtProc@ DVWIN_STREAM,__PASCAL__

;------------------------------------------------------------------------

notify_handler proc far
	pushm	cx,bx,ax
	mov	bx,ss
	mov	cx,sp
IFDEF DV386
	lss	sp,dword ptr [si].ls_stktop
ELSE
	mov	ax,ds
	cli
	mov	ss,ax	      ; SS = segment of local stack data structure
	mov	sp,[si].ls_stktop
	sti
ENDIF
	pushm	bx,cx,ds,bp
	mov	bp,sp
; now that we've saved all the necessary registers, call the real handler 
	push	es			; stack window for which notification
	push	di			;   has been sent
	MOV_AX_DGROUP
	mov	ds,ax
	call	ss:[si].ls_func
	mov	sp,bp			; pop arg off stack if not done by func
; restore the registers and return
	popm	bp,ds,cx,bx
	cli
	mov	ss,bx
	mov	sp,cx
	sti
	popm	ax,bx,cx
	ret
notify_handler endp

;------------------------------------------------------------------------

make_local_stack proc near
@win = dword ptr [bp+6+cPtrSize]
@func = CPTR_ [bp+6]
@size = word ptr [bp+4]
	ASSUME	DS:DGROUP
	push	bp
	mov	bp,sp
	PUSHDPTR es,di
	mov	ax,size LOCAL_STACK
	add	ax,@size
	ALLOC_MEM			; allocate AX bytes
	mov	di,ax
IF LDATA
	mov	es,dx
	or	ax,dx
ELSE
	or	ax,ax
ENDIF
	jz	mls_done		; return NULL if alloc returned NULL
	COPYMEM32 ES_[di].ls_window,@win,ax
	COPYCPTR ES_[di].ls_func,@func,ax
	mov	ax,di
	add	ax,@size
	add	ax,size LOCAL_STACK
	mov	ES_[di].ls_stktop,ax
IFDEF DV386
	mov	ES_[di].ls_stktopseg,ss
ENDIF
	mov	ES_[di].ls_events,0
	COPYDPTR ES_[di].ls_next,local_stacks,ax
	mov	word ptr local_stacks,di
IF LDATA
	mov	word ptr local_stacks+2,es
	mov	dx,es
ENDIF
	mov	ax,di
mls_done:
	POPDPTR es,di
	pop	bp
	ret	6+cPtrSize
make_local_stack endp

;------------------------------------------------------------------------

free_local_stack proc near
@win = dword ptr [bp+4]
	ASSUME	DS:DGROUP
	push	bp
	mov	bp,sp
	mov	ax,word ptr @win
	mov	dx,word ptr @win+2
	PUSHDPTR es,di
	push	si
	xor	di,di			; prev = NULL
IF LDATA
	mov	es,di
ENDIF
	pushDS_
	LDS_	si,local_stacks		; stack = local_stacks
free_loop:
	DPTR_NULL ds,si,bx
	jz	free_done
	cmp	dx,word ptr [si].ls_window+2
	jne	free_next
	cmp	ax,word ptr [si].ls_window
	je	free_loopend
free_next:
	mov	di,si			; prev = stack
IF LDATA
	push	ds
	pop	es
ENDIF
	LDS_	si,[si].ls_next		; stack = stack->next
	jmp	free_loop
free_loopend:
	DPTR_NULL es,di,bx
	jz	free_noprev
	COPYDPTR ES_[di].ls_next,[si].ls_next,ax
	jmp short go_free
free_noprev:
	LES_	di,[si].ls_next
	mov	word ptr local_stacks,di
IF LDATA
	mov	word ptr local_stacks+2,es
ENDIF
go_free:
	FREE_MEM ds,si
free_done:
	popDS_
	pop	si
	POPDPTR es,di
	pop	bp
	ret	4
free_local_stack endp

;------------------------------------------------------------------------

; entry: DX:AX = window handle
; exit:  [DX:]AX -> local stack structure
find_local_stack proc near
	ASSUME	DS:DGROUP
	PUSHDPTR es,di			; save registers
	LES_	di,local_stacks
fls_loop:
	DPTR_NULL es,di,bx
	jz	fls_endloop
	cmp	dx,word ptr ES_[di].ls_window+2
	jne	fls_next
	cmp	ax,word ptr ES_[di].ls_window
	je	fls_endloop
fls_next:
	LES_	di,ES_[di].ls_next
	jmp	fls_loop
fls_endloop:
	mov	ax,di
IF LDATA
	mov	dx,es
ENDIF
	DPTR_NULL dx,ax,bx
	POPDPTR es,di
	ret
find_local_stack endp

;------------------------------------------------------------------------

PubProc@ DVWIN_ASYNC,__PASCAL__
@win = dword ptr [bp+Overhead+6+cPtrSize]
@func = CPTR_ [bp+Overhead+6]
@stksize = word ptr [bp+Overhead+4]
	pushm	di,si
	@Enter
	STACK_STREAM DGROUP:async_stream
	mov	si,bx			; remember stream's address
	mov	ax,word ptr @func
IF LPROG
	mov	dx,word ptr @func+2
	or	ax,dx
ELSE
	or	ax,ax
ENDIF
	jnz	start_async
	PUSHMEM32 @win
	call	free_local_stack
	jmp	async_done

start_async:
	mov	ax,@stksize
	or	ax,ax
	jnz	not_default_size
	mov	ax,DEF_STACK
not_default_size:
	cmp	ax,MIN_STACK
	jae	got_stack_size
	mov	ax,MIN_STACK
got_stack_size:
	mov	@stksize,ax
	mov	ax,word ptr @win
	mov	dx,word ptr @win+2
	call	find_local_stack
	jnz	update_stack
	PUSHMEM32 @win
	PUSHCPTRMEM @func
	push	@stksize
	call	make_local_stack
	jmp	stack_updated

update_stack:
IF LDATA
	push	es
	mov	es,dx
ENDIF
	mov	bx,ax
	mov	cx,ES_[bx].ls_stktop
	sub	cx,bx
	sub	cx,size LOCAL_STACK
	cmp	cx,@stksize
	jae	stack_big_enough
	push	ES_[bx].ls_events
	PUSHMEM32 @win
	call	free_local_stack
	PUSHMEM32 @win
	PUSHCPTRMEM @func
	push	@stksize
	call	make_local_stack
IF LDATA
	mov	es,dx
ENDIF
	mov	bx,ax
	pop	ES_[bx].ls_events
stack_big_enough:
IF LDATA
	pop	es
ENDIF
stack_updated:
	DPTR_NULL dx,ax,bx
	jnz	store_stack
	mov	ax,-1			; return(-1) if no local stack allocated
	jmp short async_return

store_stack:
	mov	word ptr SS_[si+10],ax
IF LDATA
	mov	word ptr SS_[si+12],dx
ELSE
	mov	word ptr SS_[si+12],ds
ENDIF
	mov	word ptr SS_[si+5],offset __TEXT:notify_handler
	mov	word ptr SS_[si+7],cs
async_done:
	PUSHMEM32 @win
	PUSHDPTR ss,si
	call	DVWIN_STREAM@
	xor	ax,ax			; successful return
async_return:
	@Exit	Y			; remove locals from stack
	popm	si,di
	ret	6+cPtrSize
EndProc@ DVWIN_ASYNC,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVWIN_NOTIFY,__PASCAL__
@win = dword ptr [bp+Overhead+2]
@event = word ptr [bp+Overhead]
	@Enter
	PUSHMEM32 @win
	push	@event
	call	$DVG$NOTIFY
	mov	ax,word ptr @win
	mov	dx,word ptr @win+2
	call	find_local_stack
	jz	notify_done
IF LDATA
	push	es
	mov	es,dx
ENDIF
	mov	bx,ax
	mov	cx,@event
	mov	ax,1
	shl	ax,cl
	or	ES_[bx].ls_events,ax
IF LDATA
	pop	es
ENDIF
notify_done:
	@Exit
	ret	6
EndProc@ DVWIN_NOTIFY,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVWIN_CANCEL,__PASCAL__
@win = dword ptr [bp+Overhead+4]
@event = word ptr [bp+Overhead+2]
@release = word ptr [bp+Overhead]
	@Enter
	PUSHMEM32 @win
	push	@event
	call	$DVG$NONOTIFY
	mov	ax,word ptr @win
	mov	dx,word ptr @win+2
	call	find_local_stack
	jz	cancel_done
IF LDATA
	push	es
	mov	es,dx
ENDIF
	mov	bx,ax
	mov	cx,@event
	mov	ax,1
	shl	ax,cl
	not	ax
	and	ES_[bx].ls_events,ax
	jnz	cancel_done2
	cmp	@release,0
	jz	cancel_done2
	push	word ptr @win+2
	push	word ptr @win
	xor	ax,ax
	PUSHCPTR ax,ax			; NULL
	push	ax			; 0
	call	DVWIN_ASYNC@
cancel_done2:
IF LDATA
	pop	es
ENDIF
cancel_done:
	@Exit
	ret	8
EndProc@ DVWIN_CANCEL,__PASCAL__

;------------------------------------------------------------------------

CSegEnd@

	END
