/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1988, 1992 Ralf Brown		*/
/*			All Rights Reserved.				*/
/*									*/
/*	File DVSTREAM.H		Prototypes and definitions for streams	*/
/*									*/
/************************************************************************/
/* LastEdit: 12/26/92							*/

#ifndef __DVSTREAM_H
#define __DVSTREAM_H

#ifndef __DVGLUE_H
#include "dvglue.h"
#endif /* __DVGLUE_H */

/*==========================================*/
/* stream headers, place at beginning of a  */
/* stream                                   */
/*==========================================*/

#define S_WINDOW(size)  0x1B, 0x00, size&0xFF, size>>8
#define S_QUERY(size)   0x1B, 0x01, size&0xFF, size>>8
#define S_MANAGER(size) 0x1B, 0x10, size&0xFF, size>>8

/*==========================================*/

#define WS_BLANKS(num)		0x00|(num & 0x1F)
#define WS_CHAR(num,ch)		0x20|(num & 0x1F),ch
#define WS_ATTR(num,attr)	0x40|(num & 0x1F),attr
#define WS_CHARS(num)		0x60|(num & 0x1F)   /* followed by appr # chars */
#define WS_MANYBLANKS(num)	0x80|((num >> 8) & 7),(num & 0xFF)
#define WS_MANYCHAR(num,ch)	0x88|((num >> 8) & 7),(num & 0xFF),ch
#define WS_MANYATTR(num,attr)	0x90|((num >> 8) & 7),(num & 0xFF),attr
#define WS_MANYCHARS(num)	0x98|((num >> 8) & 7),(num & 0xFF) /* + chars */
#define WS_SETCURSROW(row)	0xA0,row
#define WS_SETCURSCOL(col)	0xA1,col
#define WS_SCRLROW(row)		0xA2,row
#define WS_SCRLCOL(col)		0xA3,col
#define WS_WINROW(row)		0xA4,row
#define WS_WINCOL(col)		0xA5,col
#define WS_WINROWS(rows)	0xA6,rows
#define WS_WINCOLS(cols)	0xA7,cols
#define WS_VIEWPORTROW(row)	0xA8,row
#define WS_VIEWPORTCOL(col)	0xA9,col
#define WS_LSIZEROWS(rows)	0xAA,rows
#define WS_LSIZECOLS(cols)	0xAB,cols
#define WS_CURSDOWN(rows)	0xB0,rows
#define WS_CURSRIGHT(cols)	0xB1,cols
#define WS_SCRLORIGDOWN(rows)	0xB2,rows
#define WS_SCRLORIGRIGHT(cols)	0xB3,cols
#define WS_SHFTWINROW(rows)	0xB4,rows
#define WS_SHFTWINCOL(cols)	0xB5,cols
#define WS_EXPWINROWS(rows)	0xB6,rows
#define WS_EXPWINCOLS(cols)	0xB7,cols
#define WS_SHFTVIEWROW(rows)	0xB8,rows
#define WS_SHFTVIEWCOL(cols)	0xB9,cols
#define WS_RELSIZEROWS(rows)	0xBA,rows
#define WS_RELSIZECOLS(cols)	0xBB,cols
#define WS_CURSPOS(row,col)	0xC0,row,col
#define WS_SCRLORIG(row,col)	0xC1,row,col
#define WS_WINPOS(row,col)	0xC2,row,col
#define WS_WINSIZE(rows,cols)	0xC3,rows,cols
#define WS_VIEWPORT(row,col)	0xC4,row,col
#define WS_LSIZE(rows,cols)	0xC5,rows,cols
#define WS_RELCURS(rows,cols)	0xC8,rows,cols
#define WS_RELSCRL(rows,cols)	0xC9,rows,cols
#define WS_RELWINPOS(rows,cols) 0xCA,rows,cols
#define WS_RELWINSIZ(rows,cols) 0xCB,rows,cols
#define WS_RELVIEWP(rows,cols)	0xCC,rows,cols
#define WS_RELLSIZE(rows,cols)	0xCD,rows,cols
#define WS_SCROLLTEXT		0xCE
#define WS_SCROLLATTR		0xCF
#define WS_PARTFRAME		0xD0
#define WS_FULLFRAME		0xD1
#define WS_AUTOCOLOR		0xD2
#define WS_PROGCOLOR		0XD3
#define WS_UPDATE		0xD4,0xE4
#define WS_UNHIDDEN		0xD4
#define WS_HIDDEN		0xD5
#define WS_FRAME		0xD6
#define WS_NOFRAME		0xD7
#define WS_READCHAR		0xD8
#define WS_READATTR		0xD9
#define WS_LOGATTR		0xDA
#define WS_PHYSATTR		0xDB
#define WS_CTRLCHAR		0xDC
#define WS_NOCTRLCHAR		0xDD
#define WS_WRITEATTR		0xDE
#define WS_LEAVEATTR		0xDF
#define WS_REPEAT(count)	0xE0,count
#define WS_DOREPEAT		0xE1
#define WS_SETCOLOR(color)	0xE2,color
#define WS_CLEAR		0xE3
#define WS_REDRAW		0xE4
#define WS_TWOKEY_MENU		0xE5,0x18
#define WS_NEWWIN(rows,cols)	0xE6,rows,cols
#define WS_SCRL_UP(h,w)		0xE8,h,w
#define WS_SCRL_DOWN(h,w)	0xE9,h,w
#define WS_SCRL_LEFT(h,w)	0xEA,h,w
#define WS_SCRL_RIGHT(h,w)	0xEB,h,w
/* each of the next three opcodes must be followed by the proper number of */
/* data bytes */
#define WS_ATTRIB(flags,f,start,num) 0xEC,flags,(f<<7)|((start&7)<<4)|(num&15)
#define WS_FRATTR(flags,f,start,num) 0xED,flags,(f<<7)|((start&7)<<4)|(num&15)
#define WS_FRCHAR(flags,f,start,num) 0xEE,flags,(f<<7)|((start&7)<<4)|)num&15)
#define WS_TITLE(len)		0xEF,len  /* followed by "len" chars for title */
#define WS_FLDCLEAR(fld)	0xF0,fld
#define WS_FLDCHAR(fld,char)	0xF1,fld,char
#define WS_FLDATTR(fld,color)	0xF2,fld,color
#define WS_FLDCURS(fld)		0xF4,fld
#define WS_FLDTYPE(fld,type)	0xF6,fld,type
#define WS_FLDSCRLUP(fld)	0xF8,fld
#define WS_FLDSCRLDOWN(fld)	0xF9,fld
#define WS_FLDSCRLLEFT(fld)	0xFA,fld
#define WS_FLDSCRLRIGHT(fld)	0xFB,fld
#define WS_FLDUNMODIFY		0xFD
#define WS_FLDRESET		0xFE
/* to define a field table, use WS_FLDTABLE followed by the appropriate number */
/* of WS_FLD_DEF */
#define WS_FLDTABLE(flds,type,curcol,selcol)  \
				0xE5,0x18,0xFF,flds,type,0,0,curcol,selcol
#define WS_FLD_DEF(urow,ucol,lrow,lcol,type,mod,col,mod2)  \
                                urow,ucol,lrow,lcol,type,mod,col,mod2

/*==========================================*/

#define QS_CURSROW		0xA0,0
#define QS_CURSCOL		0xA1,0
#define QS_SCRLROW		0xA2,0
#define QS_SCRLCOL		0xA3,0
#define QS_WINROW		0xA4,0
#define QS_WINCOL		0xA5,0
#define QS_WINROWS		0xA6,0
#define QS_WINCOLS		0xA7,0
#define QS_VIEWROW		0xA8,0
#define QS_VIEWCOL		0xA9,0
#define QS_LSIZEROWS		0xAA,0
#define QS_LSIZECOLS		0xAB,0
#define QS_CURSPOS		0xC0,0,0
#define QS_SCRLORIG		0xC1,0,0
#define QS_WINPOS		0xC2,0,0
#define QS_WINSIZE		0xC3,0,0
#define QS_VIEWPORT		0xC4,0,0
#define QS_LOGSIZE		0xC5,0,0
#define QS_SCROLLATTR		0xCE
#define QS_FULLFRAME		0xD0
#define QS_PROGCOLOR		0xD2
#define QS_HIDDEN		0xD5
#define QS_FRAME		0xD6
#define QS_READATTR		0xD9
#define QS_LOGATTR		0xDA
#define QS_CTRLCHAR		0xDC
#define QS_LEAVEATTR		0xDF
#define QS_COLOR		0xE2,0
#define QS_FLDTYPE		0xF6,0

/*==========================================*/
/* OR in these when building manager stream */
/* which uses the immediately following     */
/* manifest constants                       */
/* *don't* OR in when calling DVwin_allow,  */
/* DVwin_disallow, DVwin_notify, or         */
/* DVwin_cancel                             */
/*==========================================*/

#define MS_ALLOW            0x00
#define MS_DISALLOW         0x20
#define MS_NOTIFY           0x40
#define MS_NONOTIFY         0x60

#define DV_HMOVE            0x00 /* origin of window moves l/r */
#define DV_VMOVE            0x01 /* origin of window moves u/d */
#define DV_HSIZE            0x02 /* window width changes */
#define DV_VSIZE            0x03 /* window height changes */
#define DV_HSCROLL          0x04 /* window scrolled l/r */
#define DV_VSCROLL          0x05 /* window scrolled u/d */
#define DV_CLOSE            0x06 /* "Close" menu option */
#define DV_HIDE             0x07 /* window hidden */
#define DV_MARK             0x08 /* "Mark" menu, allow/disallow only */
#define DV_HELP             0x08 /* "?" main menu selection, notify/cancel only */
#define DV_COLORS           0x09 /* "Rearrange" "Colors"???  notify/cancel only */
#define DV_SWITCHEDTO       0x0A /* switched from another window to this one, notify/cancel only */
#define DV_RAISE            DV_SWITCHEDTO
#define DV_SWITCHEDAWAY     0x0B /* switched to another window, notify/cancel only */
#define DV_LOWER            DV_SWITCHEDAWAY
#define DV_VIDEOMODE        0x0C /* changing video mode, notify/cancel only */
#define DV_SCISSORS_CUT     0x0D /* selected "Scissors" "Cut", notify/cancel only */
#define DV_SCISSORS_COPY    0x0E /* selected "Scissors" "Copy" */
#define DV_SCISSORS         0x0E /* allow/disallow "Scissors" menu */
#define DV_SCISSORS_PASTE   0x0F /* "Scissors" "Paste" selected, notify/cancel only */
#define DV_MAINMENU         0x10 /* DV menu popped up */
#define DV_SWITCH           0x11 /* "Switch" menu, allow/disallow only */
#define DV_MENU_END         0x11 /* DV menu popped down, notify/cancel only */
#define DV_OPENMENU         0x12 /* "Open" menu, allow/disallow only */
#define DV_QUIT             0x13 /* "Quit" selection, allow/disallow only */
#define DV_OTHER	    0x14 /* none of the above */

/*==========================================*/

#define MS_ATTACH             0x84
#define MS_DETACH             0x85
#define MS_FOREONLY           0x86
#define MS_NOFOREONLY         0x87
#define MS_MINSIZE(rows,cols) 0x88,rows,cols
#define MS_MAXSIZE(rows,cols) 0x89,rows,cols
#define MS_PRIM_ASYNC         0x8A /* plus DWORD pointer */
#define MS_SEC_ASYNC          0x8B /* plus DWORD pointer */
#define MS_DFLTNOTIFY	      0xAE

#define MS_FLDMARKER(ch)      0xAF,ch   /* marker character for selected fields */

#define MS_STDFIELDPROC		0xBC
#define MS_ALTFIELDPROC		0xBD
#define MS_MENUCURSOR		MS_ALTFIELDPROC /* allow cursor keys on menus */
#define MS_NOREVATTR		0xBE
#define MS_ALLOWREVATTR		0xBF

#define MS_WINTOPSYS          0xC0  /* make window topmost in system */
#define MS_GOFORE             0xC1  /* put task in foreground */
#define MS_WINTOP             0xC2  /* make window topmost in process */
#define MS_CURRFLDPOS(row,col) 0xC3,row,col  /* move mouse pointer rel to cur fld */
#define MS_FLDPOS(fld,row,col) 0xC4,fld,row,col  /* move ptr rel to given fld */
#define MS_ORPHAN	      0xC5
#define MS_WINSHOW            0xC6
#define MS_HIDE               0xC7
#define MS_SUSPEND            0xC8
#define MS_GOBACK             0xC9
#define MS_WINBOTTOM          0xCA
#define MS_CANCEL	      0xCB
#define MS_PASTE	      0xCC
#define MS_REORDER            0xCE
#define MS_NOP		      0xFF

/*=====================================================================*/
/* header for a panel file */

#define PAN_HEADER(num_panels)   0xC0,0xC3,num_panels


#endif /* __DVSTREAM_H */

/* End of file DVSTREAM.H */
