/**********************************************************************/
/**                                                                  **/
/**   Module-Name : PIFEDIT.C             Version : 1.0              **/
/**                                                                  **/
/**   Last Update : 22.01.91              by J. Braeuchi             **/
/**                                                                  **/
/**********************************************************************/
/**                                                                  **/
/**   Description : Edit Desqview PIFs                               **/
/**                                                                  **/
/**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>


typedef unsigned char byte;
typedef unsigned int  word;

struct PIF {
	    word reserv1;
	    char pgmtitle[30];
	    unsigned int maxmem,minmem;
	    char pgmname[64],pgmdrive[1],pgmdir[64],pgmparms[64];
	    byte screen,txtpages,firstint,lastint,rows,cols,
		 inirow,inicol;
	    word sysmem;
	    char sharepgm[64],sharepgmdata[64];
	    byte control1,control2;
	    char keys[2];
	    word scriptbuf,pause;
	    byte colormap,swappable;
	    char reserv2[3];
	    byte autoclose,usedisk;
	    byte dv_version;
	    byte reserv3;
	    byte pinirows,pinicols;
	    word maxems;
	    byte control3,kbdconflict,graphpages;
	    word x_sysmem;
	    byte iniscreen;
	    byte serialports,control4,protect;
	    char reserv4[19];
	   };
	     
/*** Globals **********************************************************/

struct PIF pif;
char name[80]="C:\\DV\\DUMMY.DVP";

/**********************************************************************/
/*                                                                    */
/*    Function-Name : show_pif                                        */
/*                                                                    */
/*    Descr  : Show Pif-Data                                          */
/*    Input  :                                                        */
/*    Output :                                                        */
/*                                                                    */
/**********************************************************************/
void show_pif(void)
{
 clrscr();
 cprintf("**** DesqView PIF-Editor ****     by J.Braeuchi ");
 cprintf("\n\n\rPIF-File : %s\n",name);
 cprintf("\n\rA)  Title      : %.30s",pif.pgmtitle); 
 cprintf("\n\rB)  Keys       : %.2s",pif.keys);
 cprintf("\n\rC)  Memory     : %dK max,%dK min,%dK System,%d Script",
	pif.maxmem,pif.minmem,pif.sysmem,pif.scriptbuf);
 cprintf("\n\rD)  Program    : %.64s",pif.pgmname);
 cprintf("\n\rE)  Directory  : %.1s:%.64s",pif.pgmdrive,pif.pgmdir);
 cprintf("\n\rF)  Parms      : %.64s",pif.pgmparms);
 cprintf("\n\rG)  max.EMS    : %d",pif.maxems);
 cprintf("\n\rH)  Window     : %u Rows %u Cols",pif.pinirows,pif.pinicols);
 cprintf("\n\rI)  Position   : %u Row  %u Col",pif.inirow,pif.inicol);
 cprintf("\n\rK)  SharePgm   : %.64s",pif.sharepgm);
 cprintf("\n\rL)  ...Data    : %.64s",pif.sharepgmdata);
 cprintf("\n\n\rU)  Update PIF-File");
 cprintf("\n\rX)  Exit without update");
}


/**********************************************************************/


void main(int argc,char *argv[])
{
 FILE *dvp;
 char inbuf[81];                              /* Raw Input            */ 
 char scanbuf[81];                            /* Scanned Input        */
 short scanint1,scanint2;
 int choice;                                  

 if (argc > 1) strcpy(name,strupr(argv[1]));

 dvp = fopen(name,"rb+");                     /* read/write binary    */
 if (dvp == NULL)
 {
  cprintf("\n\rCan't open '%s'.",argv[1]);
  exit(12);
 }

 fread(&pif,sizeof(struct PIF),1,dvp);

 do
 {
  show_pif();
  cprintf("\n\n\rSelect Item");
  choice = _toupper(getch());
  switch (choice)
  {
   case 'A' : cprintf("\n\n\r>> Title : ");
	      gets(inbuf);
	      sscanf(inbuf,"%30[A-Z a-z1-9]",scanbuf);
	      memcpy(pif.pgmtitle,scanbuf,30);
	      break;
   case 'B' : cprintf("\n\n\r>> Keys : ");
	      gets(inbuf);
	      sscanf(inbuf,"%2s",scanbuf);
	      memcpy(pif.keys,scanbuf,2);
	      break;
   case 'C' : cprintf("\n\n\r>> Memory (max min sys script) : ");
	      gets(inbuf);
	      sscanf(inbuf,"%u %u %u %u",
		     &pif.maxmem,&pif.minmem,
		     &pif.sysmem,&pif.scriptbuf);
	      break;
   case 'D' : cprintf("\n\n\r>> Program : ");
	      gets(inbuf);
	      sscanf(inbuf,"%64[A-Z a-z1-9]",scanbuf);
	      memcpy(pif.pgmname,scanbuf,64);
	      break;
   case 'E' : cprintf("\n\n\r>> Directory : ");
	      gets(inbuf);
	      sscanf(inbuf,"%66s",scanbuf);
	      if(scanbuf[1] == ':')
	      {
	       memcpy(pif.pgmdrive,scanbuf,1);
	       memcpy(pif.pgmdir,scanbuf+2,64);
	      }
	      else
	      {
	       memcpy(pif.pgmdir,scanbuf,64);
	      }
	      break;
   case 'F' : cprintf("\n\n\r>> Parms : ");
	      gets(inbuf);
	      sscanf(inbuf,"%64[!-~ ]",scanbuf);
	      memcpy(pif.pgmparms,scanbuf,64);
	      break;
   case 'G' : cprintf("\n\n\r>> max. EMS : ");
	      gets(inbuf);
	      sscanf(inbuf,"%u",&pif.maxems);
	      break;
   case 'H' : cprintf("\n\n\r>> Window (rows cols) : ");
	      gets(inbuf);
	      sscanf(inbuf,"%u %u",&scanint1,&scanint2);
	      pif.pinirows = (byte)scanint1;
	      pif.pinicols = (byte)scanint2;
	      if((scanint1 == 0) && (scanint2 == 0))
		pif.control3 |= 0x80;         /* Automatic Position   */
	      else
		pif.control3 &= 0xFF - 0x80;  /* take Parameters      */
	      break;
   case 'I' : cprintf("\n\n\r>> Position (row col) : ");
	      gets(inbuf);
	      sscanf(inbuf,"%u %u",&scanint1,&scanint2);
	      pif.inirow = (byte)scanint1;
	      pif.inicol = (byte)scanint2;
	      break;
   case 'K' : cprintf("\n\n\r>> Shared Program : ");
	      gets(inbuf);
	      sscanf(inbuf,"%64s",scanbuf);
	      memcpy(pif.sharepgm,scanbuf,64);
	      break;
   case 'L' : cprintf("\n\n\r>> Shared Program Data : ");
	      gets(inbuf);
	      sscanf(inbuf,"%64[!-~ ]",scanbuf);
	      memcpy(pif.sharepgmdata,scanbuf,64);
	      break;
   case 'U' : fseek(dvp,0L,SEEK_SET);
	      fwrite(&pif,sizeof(struct PIF),1,dvp);
	      break;
  }
 } while((choice != 'X') && (choice != 'U'));

 fclose(dvp);
}

/************************** End of Module *****************************/
