DECLARE SUB PopUp ()
DECLARE SUB ScrapTop ()
DECLARE FUNCTION WhoIsTop% ()
DECLARE SUB LogTop (slot%)
DECLARE FUNCTION FindFreeSlot% ()
DECLARE SUB ClearUp ()
DECLARE SUB DisableKbd ()
DECLARE SUB ShowSwitchMenu ()
DECLARE SUB CloseAuxWin ()
DECLARE SUB RestoreMainMenu ()
DECLARE SUB ProcessKey ()
DECLARE SUB PopDown ()
DECLARE SUB ProcessMail ()
DECLARE SUB Initialize ()
DECLARE SUB ProgramBody ()

'***************************************************************************
'*
'*  Name:               TASKMAN
'*
'*  Function:           Replace the DESQview menu with a customized
'*                      task manager.
'*
'***************************************************************************

' $INCLUDE: 'dvapi.bi'

TYPE TaskData
Handle AS LONG
Title AS STRING * 23
Position AS INTEGER
END TYPE


' minimum API version required and actual API version
CONST required = &H201
DIM version AS INTEGER

' Object handles
DIM SHARED win&, kbd&, pan&, obj&, mal&, auxwin&, auxkbd&, myapp&

' Constants
CONST MAINMENU = 1
CONST OPENMENU = 2
CONST SWITCHMENU = 3
CONST CLOSECONFIRM = 4
CONST EXITCONFIRM = 5
CONST HELPSCREEN = 6
CONST OPENERROR = 7
CONST OPENMAX = 8

' Variables
DIM SHARED PoppedUp%, CurrentMenu%, Done%, MenuField%, NumProg%
DIM SHARED TaskList%(3)
DIM SHARED TaskInfo(4) AS TaskData
DIM SHARED PifName$(2)
DIM SHARED Fentry AS FieldEntry

' Data Statements
DATA "c:\taskman\sd-pif.dvp"
DATA "c:\taskman\ss-pif.dvp"

'***************************************************************************
' Main Module - check for DESQview present and enable required extensions
'***************************************************************************

' Initialize DESQview interface and get API version number
version = ApiInit%

' If DESQview is not running or version is too low, display a message
IF version < required THEN
  OPEN "CONS:" FOR OUTPUT AS 1
  PRINT #1, USING "This program requires DESQview version #.##"; required \ 256 + (required MOD 256) / 100
  CLOSE 1
ELSE
  ' Tell DESQview what extensions to enable and start application
  CALL ApiLevel(required)
  CALL ProgramBody
END IF

' Disable DESQview interface and return from program
CALL ApiExit

SUB ClearUp

CALL KeyFree(kbd&)
CALL WinFree(win&)

CALL WinAllow(myapp&, AlwDvmenu)
CALL WinCancel(myapp&, NtfDvkey)

END SUB

SUB CloseAuxWin

CALL KeyFree(auxkbd&)
CALL WinFree(auxwin&)
CALL ObqSubfrom(auxkbd&)

END SUB

SUB DisableKbd

CALL KeyClose(kbd&)
CALL ObqSubfrom(kbd&)

END SUB

FUNCTION FindFreeSlot%

FindFreeSlot% = 0

FOR i = 2 TO 4
  IF TaskInfo(i).Handle = 0 THEN
    FindFreeSlot% = i
    EXIT FOR
  END IF
NEXT i

END FUNCTION

SUB Initialize

IF NOT ApiInteractive THEN
  CALL WinHide(WinMe&)
  CALL WinRedraw(WinMe&)
END IF

myapp& = TskMe&
pan& = PanNew&
mal& = MalMe&

READ PifName$(1), PifName$(2)

FOR i = 2 TO 4
  TaskInfo(i).Position = 99
NEXT i

stat% = PanOpen%(pan&, "c:\taskman\taskman.plb")
stat% = PanApply%(pan&, WinMe&, "menubar", win&, kbd&)

CALL FldType(win&, 3, FltInactive)

PoppedUp% = YES
CurrentMenu% = MAINMENU

CALL WinDisallow(myapp&, AlwDvmenu)
CALL WinNotify(myapp&, NtfDvkey)

CALL ObqOpen

Done% = NO

END SUB

SUB LogTop (slot%)


IF TaskInfo(slot%).Position <> 1 THEN
  breakslot% = TaskInfo(slot%).Position
  TaskInfo(slot%).Position = 1

  FOR i = 2 TO 4
    IF i <> slot% AND TaskInfo(i).Handle <> 0 AND TaskInfo(i).Position < breakslot% THEN
      TaskInfo(i).Position = TaskInfo(i).Position + 1
    END IF
  NEXT i
END IF

END SUB

SUB PopDown

CALL AppHide(myapp&)
PoppedUp% = NO

END SUB

SUB PopUp

CALL AppGoFore(myapp&)
CALL KeyErase(kbd&)
CALL FldPoint(win&, MenuField%, 0, 0)

PoppedUp% = YES

END SUB

SUB ProcessKey

IF obj& = kbd& THEN
  kbuf$ = KeyRead$(kbd&)
  kstat% = KeyStatus(kbd&)
ELSE
  kbuf$ = KeyRead$(auxkbd&)
  kstat% = KeyStatus(auxkbd&)
END IF

IF LEN(kbuf$) > 0 THEN selfield% = ASC(kbuf$) ELSE selfield% = 0

SELECT CASE CurrentMenu%
  CASE MAINMENU
    SELECT CASE selfield%
      CASE 0
        IF NumProg% <> 0 THEN CALL PopDown
      CASE 1
        errstat% = PanApply%(pan&, win&, "open", auxwin&, auxkbd&)
        CurrentMenu% = OPENMENU
        CALL DisableKbd
      CASE 2
        CALL DisableKbd
        CALL ShowSwitchMenu
        CurrentMenu% = SWITCHMENU
      CASE 3
        errstat% = PanApply%(pan&, win&, "close", auxwin&, auxkbd&)
        CALL FldWrite(auxwin&, 3, RIGHT$(STR$(WhoIsTop%), 1))
        CurrentMenu% = CLOSECONFIRM
        CALL DisableKbd
      CASE 4
        errstat% = PanApply%(pan&, win&, "confirm", auxwin&, auxkbd&)
        CurrentMenu% = EXITCONFIRM
        CALL DisableKbd
      CASE 5
        errstat% = PanApply%(pan&, win&, "help", auxwin&, auxkbd&)
        CurrentMenu% = HELPSCREEN
        CALL DisableKbd
      CASE 6
      CASE 7 TO 9
        CALL LogTop(selfield% - 5)
        CALL AppGoFore(TaskInfo(selfield% - 5).Handle)
        CALL PopDown
    END SELECT
    IF selfield% < 6 THEN MenuField% = selfield%
  CASE OPENMENU
    IF selfield% <> 0 THEN
      slot% = FindFreeSlot%
      IF slot% = 0 THEN
        errstat% = PanApply%(pan&, auxwin&, "maxerror", auxwin&, auxkbd&)
        CurrentMenu% = OPENMAX
      ELSE
        ' Cancel Notification during AppStart to ignore spurious notification
        ' message
        CALL WinCancel(myapp&, NtfDvkey)
        startwin& = AppStart&(PifName$(selfield%))
        CALL WinNotify(myapp&, NtfDvkey)

        IF startwin& = 0 THEN
          errstat% = PanApply%(pan&, auxwin&, "nostart", auxwin&, auxkbd&)
          CurrentMenu% = OPENERROR
        ELSE
          CALL CloseAuxWin
          CALL RestoreMainMenu
          CurrentMenu% = MAINMENU
          CALL PopDown

          NumProg% = NumProg% + 1
          CALL LogTop(slot%)

          TaskInfo(slot%).Handle = startwin&
          TaskInfo(slot%).Title = " #" + RIGHT$(STR$(slot%), 1) + " " + QryTitle$(startwin&)

          CALL FldType(win&, 3, FltDeselect)
          CALL FldType(win&, 4, FltInactive)
          CALL FldType(win&, slot% + 5, FltDeselect)

        END IF
      END IF
    ELSE
      CALL CloseAuxWin
      CALL RestoreMainMenu
      CurrentMenu% = MAINMENU
    END IF
  CASE SWITCHMENU
    contents$ = QryField(auxwin&, selfield%)
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
    IF selfield% > 1 THEN
      slot% = VAL(MID$(contents$, 3, 1))
      CALL LogTop(slot%)
      CALL AppGoFore(TaskInfo(slot%).Handle)
      CALL PopDown
    END IF
  CASE CLOSECONFIRM
    IF selfield% = 1 THEN
      ' Cancel Notification during TskFree to ignore spurious notification
      ' message
      CALL WinCancel(myapp&, NtfDvkey)
      CALL TskFree(TaskInfo(WhoIsTop%).Handle)
      CALL WinNotify(myapp&, NtfDvkey)

      CALL FldType(win&, WhoIsTop% + 5, FltInactive)
      CALL ScrapTop
      NumProg% = NumProg% - 1
      IF NumProg% = 0 THEN
        CALL FldType(win&, 3, FltInactive)
        CALL FldType(win&, 4, FltDeselect)
      END IF
    END IF
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
    IF NumProg% <> 0 THEN CALL PopDown
  CASE EXITCONFIRM
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
    IF selfield% = 1 THEN Done% = -1
  CASE HELPSCREEN
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
  CASE OPENERROR
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
  CASE OPENMAX
    CALL CloseAuxWin
    CALL RestoreMainMenu
    CurrentMenu% = MAINMENU
END SELECT


END SUB

SUB ProcessMail

message$ = MalRead$(mal&)
status% = MalStatus%(mal&)

IF status% = &H80 AND ASC(message$) = &H50 THEN
  CALL PopUp
END IF

END SUB

SUB ProgramBody
'***************************************************************************
' ProgramBody -
'***************************************************************************

CALL Initialize

DO
  obj& = ObqRead&
  SELECT CASE obj&
  CASE mal&
    CALL ProcessMail
  CASE kbd&
    CALL ProcessKey
  CASE auxkbd&
    CALL ProcessKey
  END SELECT
LOOP UNTIL Done%

CALL ClearUp

END SUB

SUB RestoreMainMenu

CALL KeyOpen(kbd&, win&)
CALL FldReset(win&)
CALL FldPoint(win&, MenuField%, 0, 0)

END SUB

SUB ScrapTop

topslot% = WhoIsTop%
TaskInfo(topslot%).Handle = 0
TaskInfo(topslot%).Position = 99
TaskInfo(topslot%).Title = ""
FOR i = 2 TO 4
  IF TaskInfo(i).Handle <> 0 THEN
    TaskInfo(i).Position = TaskInfo(i).Position - 1
  END IF
NEXT i

END SUB

SUB ShowSwitchMenu

errstat% = PanApply%(pan&, win&, "switch", auxwin&, auxkbd&)
auxkbd& = KeyNew&
CALL KeyOpen(auxkbd&, auxwin&)
CALL KeyAddto(auxkbd&, KbfField)
fieldno% = 2
FOR i = 2 TO 4
  IF TaskInfo(i).Handle <> 0 THEN
    CALL FldWrite(auxwin&, fieldno%, TaskInfo(i).Title)
    nobytes% = QryEntry%(auxwin&, fieldno%, Fentry)
    Fentry.FeType = FltDeselect
    Fentry.FeK1mode = ASC(MID$(QryField$(auxwin&, fieldno%), 3, 1))
    Fentry.FeKey2 = 0
    CALL FldEntry(auxwin&, fieldno%, Fentry)
    fieldno% = fieldno% + 1
  END IF
NEXT i
CALL WinUnhide(auxwin&)
CALL WinRedraw(auxwin&)

END SUB

FUNCTION WhoIsTop%

FOR i = 2 TO 4
 IF TaskInfo(i).Position = 1 THEN WhoIsTop% = i
NEXT i

END FUNCTION

